"use strict";
/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudToDeviceMessages = void 0;
const msRest = require("@azure/ms-rest-js");
const Mappers = require("../models/cloudToDeviceMessagesMappers");
const Parameters = require("../models/parameters");
/** Class representing a CloudToDeviceMessages. */
class CloudToDeviceMessages {
    /**
     * Create a CloudToDeviceMessages.
     * @param {IotHubGatewayServiceAPIsContext} client Reference to the service client.
     */
    constructor(client) {
        this.client = client;
    }
    purgeCloudToDeviceMessageQueue(id, options, callback) {
        return this.client.sendOperationRequest({
            id,
            options
        }, purgeCloudToDeviceMessageQueueOperationSpec, callback);
    }
    receiveFeedbackNotification(options, callback) {
        return this.client.sendOperationRequest({
            options
        }, receiveFeedbackNotificationOperationSpec, callback);
    }
    completeFeedbackNotification(lockToken, options, callback) {
        return this.client.sendOperationRequest({
            lockToken,
            options
        }, completeFeedbackNotificationOperationSpec, callback);
    }
    abandonFeedbackNotification(lockToken, options, callback) {
        return this.client.sendOperationRequest({
            lockToken,
            options
        }, abandonFeedbackNotificationOperationSpec, callback);
    }
}
exports.CloudToDeviceMessages = CloudToDeviceMessages;
// Operation Specifications
const serializer = new msRest.Serializer(Mappers);
const purgeCloudToDeviceMessageQueueOperationSpec = {
    httpMethod: "DELETE",
    path: "devices/{id}/commands",
    urlParameters: [
        Parameters.id
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    responses: {
        200: {
            bodyMapper: Mappers.PurgeMessageQueueResult
        },
        default: {}
    },
    serializer
};
const receiveFeedbackNotificationOperationSpec = {
    httpMethod: "GET",
    path: "messages/serviceBound/feedback",
    queryParameters: [
        Parameters.apiVersion
    ],
    responses: {
        200: {},
        204: {},
        default: {}
    },
    serializer
};
const completeFeedbackNotificationOperationSpec = {
    httpMethod: "DELETE",
    path: "messages/serviceBound/feedback/{lockToken}",
    urlParameters: [
        Parameters.lockToken
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    responses: {
        204: {},
        default: {}
    },
    serializer
};
const abandonFeedbackNotificationOperationSpec = {
    httpMethod: "POST",
    path: "messages/serviceBound/feedback/{lockToken}/abandon",
    urlParameters: [
        Parameters.lockToken
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    responses: {
        204: {},
        default: {}
    },
    serializer
};
//# sourceMappingURL=cloudToDeviceMessages.js.map