"use strict";
/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConfigurationOperations = void 0;
const msRest = require("@azure/ms-rest-js");
const Mappers = require("../models/configurationOperationsMappers");
const Parameters = require("../models/parameters");
/** Class representing a ConfigurationOperations. */
class ConfigurationOperations {
    /**
     * Create a ConfigurationOperations.
     * @param {IotHubGatewayServiceAPIsContext} client Reference to the service client.
     */
    constructor(client) {
        this.client = client;
    }
    get(id, options, callback) {
        return this.client.sendOperationRequest({
            id,
            options
        }, getOperationSpec, callback);
    }
    createOrUpdate(id, configuration, options, callback) {
        return this.client.sendOperationRequest({
            id,
            configuration,
            options
        }, createOrUpdateOperationSpec, callback);
    }
    deleteMethod(id, options, callback) {
        return this.client.sendOperationRequest({
            id,
            options
        }, deleteMethodOperationSpec, callback);
    }
    getConfigurations(options, callback) {
        return this.client.sendOperationRequest({
            options
        }, getConfigurationsOperationSpec, callback);
    }
    testQueries(input, options, callback) {
        return this.client.sendOperationRequest({
            input,
            options
        }, testQueriesOperationSpec, callback);
    }
    applyOnEdgeDevice(id, content, options, callback) {
        return this.client.sendOperationRequest({
            id,
            content,
            options
        }, applyOnEdgeDeviceOperationSpec, callback);
    }
}
exports.ConfigurationOperations = ConfigurationOperations;
// Operation Specifications
const serializer = new msRest.Serializer(Mappers);
const getOperationSpec = {
    httpMethod: "GET",
    path: "configurations/{id}",
    urlParameters: [
        Parameters.id
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    responses: {
        200: {
            bodyMapper: Mappers.Configuration
        },
        default: {}
    },
    serializer
};
const createOrUpdateOperationSpec = {
    httpMethod: "PUT",
    path: "configurations/{id}",
    urlParameters: [
        Parameters.id
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    headerParameters: [
        Parameters.ifMatch
    ],
    requestBody: {
        parameterPath: "configuration",
        mapper: {
            ...Mappers.Configuration,
            required: true
        }
    },
    responses: {
        200: {
            bodyMapper: Mappers.Configuration
        },
        201: {
            bodyMapper: Mappers.Configuration
        },
        default: {}
    },
    serializer
};
const deleteMethodOperationSpec = {
    httpMethod: "DELETE",
    path: "configurations/{id}",
    urlParameters: [
        Parameters.id
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    headerParameters: [
        Parameters.ifMatch
    ],
    responses: {
        204: {},
        default: {}
    },
    serializer
};
const getConfigurationsOperationSpec = {
    httpMethod: "GET",
    path: "configurations",
    queryParameters: [
        Parameters.top,
        Parameters.apiVersion
    ],
    responses: {
        200: {
            bodyMapper: {
                serializedName: "parsedResponse",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "Composite",
                            className: "Configuration"
                        }
                    }
                }
            }
        },
        default: {}
    },
    serializer
};
const testQueriesOperationSpec = {
    httpMethod: "POST",
    path: "configurations/testQueries",
    queryParameters: [
        Parameters.apiVersion
    ],
    requestBody: {
        parameterPath: "input",
        mapper: {
            ...Mappers.ConfigurationQueriesTestInput,
            required: true
        }
    },
    responses: {
        200: {
            bodyMapper: Mappers.ConfigurationQueriesTestResponse
        },
        default: {}
    },
    serializer
};
const applyOnEdgeDeviceOperationSpec = {
    httpMethod: "POST",
    path: "devices/{id}/applyConfigurationContent",
    urlParameters: [
        Parameters.id
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    requestBody: {
        parameterPath: "content",
        mapper: {
            ...Mappers.ConfigurationContent,
            required: true
        }
    },
    responses: {
        204: {},
        default: {}
    },
    serializer
};
//# sourceMappingURL=configurationOperations.js.map