"use strict";
/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.Query = void 0;
const msRest = require("@azure/ms-rest-js");
const Mappers = require("../models/queryMappers");
const Parameters = require("../models/parameters");
/** Class representing a Query. */
class Query {
    /**
     * Create a Query.
     * @param {IotHubGatewayServiceAPIsContext} client Reference to the service client.
     */
    constructor(client) {
        this.client = client;
    }
    getTwins(querySpecification, options, callback) {
        return this.client.sendOperationRequest({
            querySpecification,
            options
        }, getTwinsOperationSpec, callback);
    }
}
exports.Query = Query;
// Operation Specifications
const serializer = new msRest.Serializer(Mappers);
const getTwinsOperationSpec = {
    httpMethod: "POST",
    path: "devices/query",
    queryParameters: [
        Parameters.apiVersion
    ],
    headerParameters: [
        Parameters.xMsContinuation,
        Parameters.xMsMaxItemCount
    ],
    requestBody: {
        parameterPath: "querySpecification",
        mapper: {
            ...Mappers.QuerySpecification,
            required: true
        }
    },
    responses: {
        200: {
            bodyMapper: {
                serializedName: "parsedResponse",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "Composite",
                            className: "Twin"
                        }
                    }
                }
            },
            headersMapper: Mappers.QueryGetTwinsHeaders
        },
        default: {}
    },
    serializer
};
//# sourceMappingURL=query.js.map