/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */

import * as msRest from "@azure/ms-rest-js";
import * as Models from "../models";
import * as Mappers from "../models/statisticsMappers";
import * as Parameters from "../models/parameters";
import { IotHubGatewayServiceAPIsContext } from "../iotHubGatewayServiceAPIsContext";

/** Class representing a Statistics. */
export class Statistics {
  private readonly client: IotHubGatewayServiceAPIsContext;

  /**
   * Create a Statistics.
   * @param {IotHubGatewayServiceAPIsContext} client Reference to the service client.
   */
  constructor(client: IotHubGatewayServiceAPIsContext) {
    this.client = client;
  }

  /**
   * Gets device statistics of the IoT Hub identity registry, such as total device count.
   * @param [options] The optional parameters
   * @returns Promise<Models.StatisticsGetDeviceStatisticsResponse>
   */
  getDeviceStatistics(options?: msRest.RequestOptionsBase): Promise<Models.StatisticsGetDeviceStatisticsResponse>;
  /**
   * @param callback The callback
   */
  getDeviceStatistics(callback: msRest.ServiceCallback<Models.RegistryStatistics>): void;
  /**
   * @param options The optional parameters
   * @param callback The callback
   */
  getDeviceStatistics(options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.RegistryStatistics>): void;
  getDeviceStatistics(options?: msRest.RequestOptionsBase | msRest.ServiceCallback<Models.RegistryStatistics>, callback?: msRest.ServiceCallback<Models.RegistryStatistics>): Promise<Models.StatisticsGetDeviceStatisticsResponse> {
    return this.client.sendOperationRequest(
      {
        options
      },
      getDeviceStatisticsOperationSpec,
      callback) as Promise<Models.StatisticsGetDeviceStatisticsResponse>;
  }

  /**
   * Gets service statistics of the IoT Hub identity registry, such as connected device count.
   * @param [options] The optional parameters
   * @returns Promise<Models.StatisticsGetServiceStatisticsResponse>
   */
  getServiceStatistics(options?: msRest.RequestOptionsBase): Promise<Models.StatisticsGetServiceStatisticsResponse>;
  /**
   * @param callback The callback
   */
  getServiceStatistics(callback: msRest.ServiceCallback<Models.ServiceStatistics>): void;
  /**
   * @param options The optional parameters
   * @param callback The callback
   */
  getServiceStatistics(options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.ServiceStatistics>): void;
  getServiceStatistics(options?: msRest.RequestOptionsBase | msRest.ServiceCallback<Models.ServiceStatistics>, callback?: msRest.ServiceCallback<Models.ServiceStatistics>): Promise<Models.StatisticsGetServiceStatisticsResponse> {
    return this.client.sendOperationRequest(
      {
        options
      },
      getServiceStatisticsOperationSpec,
      callback) as Promise<Models.StatisticsGetServiceStatisticsResponse>;
  }
}

// Operation Specifications
const serializer = new msRest.Serializer(Mappers);
const getDeviceStatisticsOperationSpec: msRest.OperationSpec = {
  httpMethod: "GET",
  path: "statistics/devices",
  queryParameters: [
    Parameters.apiVersion
  ],
  responses: {
    200: {
      bodyMapper: Mappers.RegistryStatistics
    },
    default: {}
  },
  serializer
};

const getServiceStatisticsOperationSpec: msRest.OperationSpec = {
  httpMethod: "GET",
  path: "statistics/service",
  queryParameters: [
    Parameters.apiVersion
  ],
  responses: {
    200: {
      bodyMapper: Mappers.ServiceStatistics
    },
    default: {}
  },
  serializer
};
