import { Form } from "@node-wot/td-tools";
import { OptionName } from "coap-packet";
import { OptionValue } from "coap";
export { default as CoapServer } from "./coap-server";
export { default as CoapClientFactory } from "./coap-client-factory";
export { default as CoapClient } from "./coap-client";
export { default as CoapsClientFactory } from "./coaps-client-factory";
export { default as CoapsClient } from "./coaps-client";
export * from "./coap-server";
export * from "./coap-client-factory";
export * from "./coap-client";
export * from "./coaps-client-factory";
export * from "./coaps-client";
export declare class CoapOption {
    "cov:optionName": OptionName;
    "cov:optionValue": OptionValue;
}
export declare type CoapMethodName = "GET" | "POST" | "PUT" | "DELETE" | "FETCH" | "PATCH" | "iPATCH";
export declare class CoapForm extends Form {
    "cov:methodName"?: CoapMethodName;
    "cov:options"?: Array<CoapOption> | CoapOption;
}
export declare function isValidCoapMethod(methodName: CoapMethodName): methodName is CoapMethodName;
export declare function isSupportedCoapMethod(methodName: CoapMethodName): methodName is CoapMethodName;
