import * as TD from "@node-wot/td-tools";
import { ProtocolClient, Content } from "@node-wot/core";
import { HttpForm, HttpConfig } from "./http";
import OAuthManager from "./oauth-manager";
export default class HttpClient implements ProtocolClient {
    private readonly agent;
    private readonly provider;
    private proxyRequest;
    private authorization;
    private authorizationHeader;
    private allowSelfSigned;
    private oauth;
    private credential;
    private activeSubscriptions;
    constructor(config?: HttpConfig, secure?: boolean, oauthManager?: OAuthManager);
    toString(): string;
    readResource(form: HttpForm): Promise<Content>;
    writeResource(form: HttpForm, content: Content): Promise<any>;
    invokeResource(form: HttpForm, content?: Content): Promise<Content>;
    unlinkResource(form: HttpForm): Promise<any>;
    subscribeResource(form: HttpForm, next: ((value: any) => void), error?: (error: any) => void, complete?: () => void): any;
    start(): boolean;
    stop(): boolean;
    setSecurity(metadata: Array<TD.SecurityScheme>, credentials?: any): boolean;
    private generateFetchRequest;
    private fetch;
    private checkFetchResponse;
    private static isOAuthTokenExpired;
    private static fixLocalhostName;
}
