"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OAuthCredential = exports.BasicKeyCredential = exports.BearerCredential = exports.BasicCredential = exports.Credential = void 0;
const node_fetch_1 = require("node-fetch");
class Credential {
}
exports.Credential = Credential;
class BasicCredential extends Credential {
    constructor({ username, password }, options) {
        super();
        if (username === undefined || password === undefined || username === null || password === null) {
            throw new Error(`No Basic credentials for Thing`);
        }
        this.username = username;
        this.password = password;
        this.options = options;
    }
    sign(request) {
        return __awaiter(this, void 0, void 0, function* () {
            const result = request.clone();
            let headerName = "authorization";
            if (this.options !== undefined && this.options.in === "header" && this.options.name !== undefined) {
                headerName = this.options.name;
            }
            result.headers.set(headerName, "Basic " + Buffer.from(this.username + ":" + this.password).toString("base64"));
            return result;
        });
    }
}
exports.BasicCredential = BasicCredential;
class BearerCredential extends Credential {
    constructor({ token }, options) {
        super();
        if (token === undefined || token === null) {
            throw new Error(`No Bearer credentionals for Thing`);
        }
        this.token = token;
        this.options = options;
    }
    sign(request) {
        return __awaiter(this, void 0, void 0, function* () {
            const result = request.clone();
            let headerName = "authorization";
            if (this.options.in === "header" && this.options.name !== undefined) {
                headerName = this.options.name;
            }
            result.headers.set(headerName, "Bearer " + this.token);
            return result;
        });
    }
}
exports.BearerCredential = BearerCredential;
class BasicKeyCredential extends Credential {
    constructor({ apiKey }, options) {
        super();
        if (apiKey === undefined || apiKey === null) {
            throw new Error(`No API key credentials for Thing`);
        }
        this.apiKey = apiKey;
        this.options = options;
    }
    sign(request) {
        return __awaiter(this, void 0, void 0, function* () {
            const result = request.clone();
            let headerName = "authorization";
            if (this.options.in === "header" && this.options.name !== undefined) {
                headerName = this.options.name;
            }
            result.headers.append(headerName, this.apiKey);
            return result;
        });
    }
}
exports.BasicKeyCredential = BasicKeyCredential;
class OAuthCredential extends Credential {
    constructor(token, refresh) {
        super();
        this.token = token;
        this.refresh = refresh;
        this.token = token;
    }
    sign(request) {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.token instanceof Promise) {
                const tokenRequest = this.token;
                this.token = yield tokenRequest;
            }
            let tempRequest = { url: request.url, headers: {} };
            tempRequest = this.token.sign(tempRequest);
            const mergeHeaders = new node_fetch_1.Request(request, tempRequest);
            return mergeHeaders;
        });
    }
    refreshToken() {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.token instanceof Promise) {
                throw new Error("Uninitialized token. You have to call sing before refresh");
            }
            let newToken;
            if (this.refresh) {
                newToken = yield this.refresh();
            }
            else {
                newToken = yield this.token.refresh();
            }
            return new OAuthCredential(newToken, this.refresh);
        });
    }
}
exports.OAuthCredential = OAuthCredential;
//# sourceMappingURL=credential.js.map