import { HttpClient, HttpForm } from "./http";
import { Content } from "@node-wot/core";
export interface InternalSubscription {
    open(next: (value: Content) => void, error?: (error: Error) => void, complete?: () => void): Promise<void>;
    close(): void;
}
export declare class LongPollingSubscription implements InternalSubscription {
    private form;
    private client;
    private closed;
    constructor(form: HttpForm, client: HttpClient);
    open(next: (value: Content) => void, error?: (error: Error) => void, complete?: () => void): Promise<void>;
    close(): void;
}
export declare class SSESubscription implements InternalSubscription {
    private form;
    private eventSource;
    private closed;
    constructor(form: HttpForm);
    open(next: (value: Content) => void, error?: (error: Error) => void, complete?: () => void): Promise<void>;
    close(): void;
}
