/// <reference types="node" />
import { Form } from "@node-wot/td-tools";
export { default as MqttClient } from "./mqtt-client";
export { default as MqttClientFactory } from "./mqtt-client-factory";
export { default as MqttsClientFactory } from "./mqtts-client-factory";
export { default as MqttBrokerServer } from "./mqtt-broker-server";
export * from "./mqtt-client";
export * from "./mqtt-client-factory";
export * from "./mqtts-client-factory";
export * from "./mqtt-broker-server";
export declare enum MqttQoS {
    QoS0 = 0,
    QoS1 = 1,
    QoS2 = 2
}
export declare class MqttForm extends Form {
    "mqtt:qos": MqttQoS;
    "mqtt:retain": boolean;
}
export interface MqttClientConfig {
    username?: string;
    password?: string;
    rejectUnauthorized?: boolean;
}
export interface MqttBrokerServerConfig {
    uri: string;
    user?: string;
    psw?: string;
    clientId?: string;
    protocolVersion?: 3 | 4 | 5;
    rejectUnauthorized?: boolean;
    selfHost?: boolean;
    key?: Buffer;
    cert?: Buffer | undefined;
    selfHostAuthentication?: MqttClientConfig[];
}
