"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.removeEmptyDirs = exports.removeFiles = exports.findFilesToRemove = void 0;
const fs_1 = require("fs");
const path_1 = __importDefault(require("path"));
const filesystem_1 = require("./utils/filesystem");
const glob_1 = require("./utils/glob");
async function findFilesToRemove(nodeModulesPath, globLists) {
    const { included, includedDirs, excluded } = (0, glob_1.toAbsoluteGlobLists)((0, glob_1.optimizeGlobLists)(globLists), nodeModulesPath);
    const picoOptions = { ignore: excluded };
    const checkDir = includedDirs ? (0, glob_1.makeGlobMatcher)(includedDirs, picoOptions) : () => false;
    const checkFile = (0, glob_1.makeGlobMatcher)(included, picoOptions);
    let filesToRemove = await (0, filesystem_1.crawlDirWithChecks)([], nodeModulesPath, checkDir, checkFile);
    if (excluded.length) {
        filesToRemove = filesToRemove.filter(file => checkFile(file));
    }
    return filesToRemove;
}
exports.findFilesToRemove = findFilesToRemove;
async function removeFiles(filePaths, { dryRun = false } = {}) {
    let reducedSize = 0;
    await Promise.all(filePaths.map(async (filePath) => {
        try {
            const fileStats = await fs_1.promises.stat(filePath);
            if (!dryRun) {
                await fs_1.promises.unlink(filePath);
            }
            reducedSize += fileStats.size;
        }
        catch (error) {
        }
    }));
    return reducedSize;
}
exports.removeFiles = removeFiles;
async function removeEmptyDirs(filePaths) {
    let removedEmptyDirs = 0;
    await Promise.all(filePaths.map(async (filePath) => {
        const removedParentDirs = await (0, filesystem_1.removeEmptyDirsUp)(new Set(), path_1.default.dirname(filePath));
        removedEmptyDirs += removedParentDirs;
    }));
    return removedEmptyDirs;
}
exports.removeEmptyDirs = removeEmptyDirs;
