"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.yellow = exports.green = exports.bold = exports.yesOrNo = exports.makeLogger = void 0;
const readline_1 = __importDefault(require("readline"));
const supports_color_1 = __importDefault(require("supports-color"));
function makeLogger({ disabled }) {
    if (disabled) {
        const noop = () => undefined;
        return Object.keys(console.log).reduce((disabledConsole, key) => {
            disabledConsole[key] = noop;
            return disabledConsole;
        }, {});
    }
    return console;
}
exports.makeLogger = makeLogger;
async function yesOrNo(query) {
    const rl = readline_1.default.createInterface({
        input: process.stdin,
        output: process.stdout,
    });
    return new Promise(resolve => rl.question(query, (answer) => {
        rl.close();
        resolve(/ye?s?/i.test(answer));
    }));
}
exports.yesOrNo = yesOrNo;
function colorizer(colorCode) {
    if (!supports_color_1.default.stdout) {
        return (text) => String(text);
    }
    return (text) => `\x1b[${colorCode}m${text}\x1b[0m`;
}
exports.bold = colorizer('1');
exports.green = colorizer('32');
exports.yellow = colorizer('33');
