"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@node-wot/core");
const binding_http_1 = require("@node-wot/binding-http");
const binding_coap_1 = require("@node-wot/binding-coap");
const binding_mqtt_1 = require("@node-wot/binding-mqtt");
const binding_file_1 = require("@node-wot/binding-file");
function isObject(item) {
    return item && typeof item === "object" && !Array.isArray(item);
}
function mergeConfigs(target, source) {
    const output = Object.assign({}, target);
    Object.keys(source).forEach((key) => {
        if (!(key in target)) {
            Object.assign(output, { [key]: source[key] });
        }
        else {
            if (isObject(target[key]) && isObject(source[key])) {
                output[key] = mergeConfigs(target[key], source[key]);
            }
            else {
                Object.assign(output, { [key]: source[key] });
            }
        }
    });
    return output;
}
class DefaultServient extends core_1.Servient {
    constructor(clientOnly, config) {
        super();
        this.loggers = {
            warn: console.warn,
            info: console.info,
            debug: console.debug,
        };
        this.config =
            typeof config === "object"
                ? mergeConfigs(DefaultServient.defaultConfig, config)
                : DefaultServient.defaultConfig;
        if (clientOnly) {
            if (!this.config.servient) {
                this.config.servient = {};
            }
            this.config.servient.clientOnly = true;
        }
        this.setLogLevel(this.config.log.level);
        this.addCredentials(this.config.credentials);
        if (this.config.credentials)
            delete this.config.credentials;
        console.debug("[cli/default-servient]", "DefaultServient configured with");
        console.dir(this.config);
        if (typeof this.config.servient.staticAddress === "string") {
            core_1.Helpers.setStaticAddress(this.config.servient.staticAddress);
        }
        let coapServer;
        if (!this.config.servient.clientOnly) {
            if (this.config.http) {
                const httpServer = new binding_http_1.HttpServer(this.config.http);
                this.addServer(httpServer);
            }
            if (this.config.coap) {
                coapServer =
                    typeof this.config.coap.port === "number"
                        ? new binding_coap_1.CoapServer(this.config.coap.port)
                        : new binding_coap_1.CoapServer();
                this.addServer(coapServer);
            }
            if (this.config.mqtt) {
                const mqttBrokerServer = new binding_mqtt_1.MqttBrokerServer({
                    uri: this.config.mqtt.broker,
                    user: typeof this.config.mqtt.username === "string" ? this.config.mqtt.username : undefined,
                    psw: typeof this.config.mqtt.password === "string" ? this.config.mqtt.password : undefined,
                    clientId: typeof this.config.mqtt.clientId === "string" ? this.config.mqtt.clientId : undefined,
                    protocolVersion: typeof this.config.mqtt.protocolVersion === "number"
                        ? this.config.mqtt.protocolVersion
                        : undefined,
                });
                this.addServer(mqttBrokerServer);
            }
        }
        this.addClientFactory(new binding_file_1.FileClientFactory());
        this.addClientFactory(new binding_http_1.HttpClientFactory(this.config.http));
        this.addClientFactory(new binding_http_1.HttpsClientFactory(this.config.http));
        this.addClientFactory(new binding_coap_1.CoapClientFactory(coapServer));
        this.addClientFactory(new binding_coap_1.CoapsClientFactory());
        this.addClientFactory(new binding_mqtt_1.MqttClientFactory());
    }
    start() {
        return new Promise((resolve, reject) => {
            super
                .start()
                .then((myWoT) => {
                console.info("[cli/default-servient]", "DefaultServient started");
                myWoT
                    .produce({
                    title: "servient",
                    description: "node-wot CLI Servient",
                    properties: {
                        things: {
                            type: "object",
                            description: "Get things",
                            observable: false,
                            readOnly: true,
                        },
                    },
                    actions: {
                        setLogLevel: {
                            description: "Set log level",
                            input: { oneOf: [{ type: "string" }, { type: "number" }] },
                            output: { type: "string" },
                        },
                        shutdown: {
                            description: "Stop servient",
                            output: { type: "string" },
                        },
                        runScript: {
                            description: "Run script",
                            input: { type: "string" },
                            output: { type: "string" },
                        },
                    },
                })
                    .then((thing) => {
                    thing.setActionHandler("setLogLevel", (level) => __awaiter(this, void 0, void 0, function* () {
                        const ll = yield core_1.Helpers.parseInteractionOutput(level);
                        return new Promise((resolve, reject) => {
                            if (typeof ll === "number") {
                                this.setLogLevel(ll);
                            }
                            else if (typeof ll === "string") {
                                this.setLogLevel(ll);
                            }
                            else {
                                this.setLogLevel(ll + "");
                            }
                            resolve(`Log level set to '${this.logLevel}'`);
                        });
                    }));
                    thing.setActionHandler("shutdown", () => {
                        return new Promise((resolve, reject) => {
                            console.debug("[cli/default-servient]", "shutting down by remote");
                            this.shutdown();
                            resolve(undefined);
                        });
                    });
                    thing.setActionHandler("runScript", (script) => __awaiter(this, void 0, void 0, function* () {
                        const scriptv = yield core_1.Helpers.parseInteractionOutput(script);
                        return new Promise((resolve, reject) => {
                            console.debug("[cli/default-servient]", "running script", scriptv);
                            this.runScript(scriptv);
                            resolve(undefined);
                        });
                    }));
                    thing.setPropertyReadHandler("things", () => {
                        return new Promise((resolve, reject) => {
                            console.debug("[cli/default-servient]", "returnings things");
                            resolve(this.getThings());
                        });
                    });
                    thing
                        .expose()
                        .then(() => {
                        resolve(myWoT);
                    })
                        .catch((err) => reject(err));
                });
            })
                .catch((err) => reject(err));
        });
    }
    setLogLevel(logLevel) {
        if (logLevel === "error" || logLevel === 0) {
            console.warn = () => {
            };
            console.info = () => {
            };
            console.debug = () => {
            };
            this.logLevel = "error";
        }
        else if (logLevel === "warn" || logLevel === "warning" || logLevel === 1) {
            console.warn = this.loggers.warn;
            console.info = () => {
            };
            console.debug = () => {
            };
            this.logLevel = "warn";
        }
        else if (logLevel === "info" || logLevel === 2) {
            console.warn = this.loggers.warn;
            console.info = this.loggers.info;
            console.debug = () => {
            };
            this.logLevel = "info";
        }
        else if (logLevel === "debug" || logLevel === 3) {
            console.warn = this.loggers.warn;
            console.info = this.loggers.info;
            console.debug = this.loggers.debug;
            this.logLevel = "debug";
        }
        else {
            console.warn = this.loggers.warn;
            console.info = this.loggers.info;
            console.debug = () => {
            };
            this.logLevel = "info";
        }
    }
}
exports.default = DefaultServient;
DefaultServient.defaultConfig = {
    servient: {
        clientOnly: false,
        scriptAction: false,
    },
    http: {
        port: 8080,
        selfSigned: false,
    },
    coap: {
        port: 5683,
    },
    log: {
        level: "info",
    },
};
//# sourceMappingURL=cli-default-servient.js.map