// Code generated by capnpc-go. DO NOT EDIT.

package tunnelrpc

import (
	context "golang.org/x/net/context"
	strconv "strconv"
	capnp "zombiezen.com/go/capnproto2"
	text "zombiezen.com/go/capnproto2/encoding/text"
	schemas "zombiezen.com/go/capnproto2/schemas"
	server "zombiezen.com/go/capnproto2/server"
)

type Authentication struct{ capnp.Struct }

// Authentication_TypeID is the unique identifier for the type Authentication.
const Authentication_TypeID = 0xc082ef6e0d42ed1d

func NewAuthentication(s *capnp.Segment) (Authentication, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3})
	return Authentication{st}, err
}

func NewRootAuthentication(s *capnp.Segment) (Authentication, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3})
	return Authentication{st}, err
}

func ReadRootAuthentication(msg *capnp.Message) (Authentication, error) {
	root, err := msg.RootPtr()
	return Authentication{root.Struct()}, err
}

func (s Authentication) String() string {
	str, _ := text.Marshal(0xc082ef6e0d42ed1d, s.Struct)
	return str
}

func (s Authentication) Key() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s Authentication) HasKey() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Authentication) KeyBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s Authentication) SetKey(v string) error {
	return s.Struct.SetText(0, v)
}

func (s Authentication) Email() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s Authentication) HasEmail() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s Authentication) EmailBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s Authentication) SetEmail(v string) error {
	return s.Struct.SetText(1, v)
}

func (s Authentication) OriginCAKey() (string, error) {
	p, err := s.Struct.Ptr(2)
	return p.Text(), err
}

func (s Authentication) HasOriginCAKey() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s Authentication) OriginCAKeyBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(2)
	return p.TextBytes(), err
}

func (s Authentication) SetOriginCAKey(v string) error {
	return s.Struct.SetText(2, v)
}

// Authentication_List is a list of Authentication.
type Authentication_List struct{ capnp.List }

// NewAuthentication creates a new list of Authentication.
func NewAuthentication_List(s *capnp.Segment, sz int32) (Authentication_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3}, sz)
	return Authentication_List{l}, err
}

func (s Authentication_List) At(i int) Authentication { return Authentication{s.List.Struct(i)} }

func (s Authentication_List) Set(i int, v Authentication) error { return s.List.SetStruct(i, v.Struct) }

func (s Authentication_List) String() string {
	str, _ := text.MarshalList(0xc082ef6e0d42ed1d, s.List)
	return str
}

// Authentication_Promise is a wrapper for a Authentication promised by a client call.
type Authentication_Promise struct{ *capnp.Pipeline }

func (p Authentication_Promise) Struct() (Authentication, error) {
	s, err := p.Pipeline.Struct()
	return Authentication{s}, err
}

type TunnelRegistration struct{ capnp.Struct }

// TunnelRegistration_TypeID is the unique identifier for the type TunnelRegistration.
const TunnelRegistration_TypeID = 0xf41a0f001ad49e46

func NewTunnelRegistration(s *capnp.Segment) (TunnelRegistration, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 6})
	return TunnelRegistration{st}, err
}

func NewRootTunnelRegistration(s *capnp.Segment) (TunnelRegistration, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 6})
	return TunnelRegistration{st}, err
}

func ReadRootTunnelRegistration(msg *capnp.Message) (TunnelRegistration, error) {
	root, err := msg.RootPtr()
	return TunnelRegistration{root.Struct()}, err
}

func (s TunnelRegistration) String() string {
	str, _ := text.Marshal(0xf41a0f001ad49e46, s.Struct)
	return str
}

func (s TunnelRegistration) Err() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s TunnelRegistration) HasErr() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s TunnelRegistration) ErrBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s TunnelRegistration) SetErr(v string) error {
	return s.Struct.SetText(0, v)
}

func (s TunnelRegistration) Url() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s TunnelRegistration) HasUrl() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s TunnelRegistration) UrlBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s TunnelRegistration) SetUrl(v string) error {
	return s.Struct.SetText(1, v)
}

func (s TunnelRegistration) LogLines() (capnp.TextList, error) {
	p, err := s.Struct.Ptr(2)
	return capnp.TextList{List: p.List()}, err
}

func (s TunnelRegistration) HasLogLines() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s TunnelRegistration) SetLogLines(v capnp.TextList) error {
	return s.Struct.SetPtr(2, v.List.ToPtr())
}

// NewLogLines sets the logLines field to a newly
// allocated capnp.TextList, preferring placement in s's segment.
func (s TunnelRegistration) NewLogLines(n int32) (capnp.TextList, error) {
	l, err := capnp.NewTextList(s.Struct.Segment(), n)
	if err != nil {
		return capnp.TextList{}, err
	}
	err = s.Struct.SetPtr(2, l.List.ToPtr())
	return l, err
}

func (s TunnelRegistration) PermanentFailure() bool {
	return s.Struct.Bit(0)
}

func (s TunnelRegistration) SetPermanentFailure(v bool) {
	s.Struct.SetBit(0, v)
}

func (s TunnelRegistration) TunnelID() (string, error) {
	p, err := s.Struct.Ptr(3)
	return p.Text(), err
}

func (s TunnelRegistration) HasTunnelID() bool {
	p, err := s.Struct.Ptr(3)
	return p.IsValid() || err != nil
}

func (s TunnelRegistration) TunnelIDBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(3)
	return p.TextBytes(), err
}

func (s TunnelRegistration) SetTunnelID(v string) error {
	return s.Struct.SetText(3, v)
}

func (s TunnelRegistration) RetryAfterSeconds() uint16 {
	return s.Struct.Uint16(2)
}

func (s TunnelRegistration) SetRetryAfterSeconds(v uint16) {
	s.Struct.SetUint16(2, v)
}

func (s TunnelRegistration) EventDigest() ([]byte, error) {
	p, err := s.Struct.Ptr(4)
	return []byte(p.Data()), err
}

func (s TunnelRegistration) HasEventDigest() bool {
	p, err := s.Struct.Ptr(4)
	return p.IsValid() || err != nil
}

func (s TunnelRegistration) SetEventDigest(v []byte) error {
	return s.Struct.SetData(4, v)
}

func (s TunnelRegistration) ConnDigest() ([]byte, error) {
	p, err := s.Struct.Ptr(5)
	return []byte(p.Data()), err
}

func (s TunnelRegistration) HasConnDigest() bool {
	p, err := s.Struct.Ptr(5)
	return p.IsValid() || err != nil
}

func (s TunnelRegistration) SetConnDigest(v []byte) error {
	return s.Struct.SetData(5, v)
}

// TunnelRegistration_List is a list of TunnelRegistration.
type TunnelRegistration_List struct{ capnp.List }

// NewTunnelRegistration creates a new list of TunnelRegistration.
func NewTunnelRegistration_List(s *capnp.Segment, sz int32) (TunnelRegistration_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 6}, sz)
	return TunnelRegistration_List{l}, err
}

func (s TunnelRegistration_List) At(i int) TunnelRegistration {
	return TunnelRegistration{s.List.Struct(i)}
}

func (s TunnelRegistration_List) Set(i int, v TunnelRegistration) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelRegistration_List) String() string {
	str, _ := text.MarshalList(0xf41a0f001ad49e46, s.List)
	return str
}

// TunnelRegistration_Promise is a wrapper for a TunnelRegistration promised by a client call.
type TunnelRegistration_Promise struct{ *capnp.Pipeline }

func (p TunnelRegistration_Promise) Struct() (TunnelRegistration, error) {
	s, err := p.Pipeline.Struct()
	return TunnelRegistration{s}, err
}

type RegistrationOptions struct{ capnp.Struct }

// RegistrationOptions_TypeID is the unique identifier for the type RegistrationOptions.
const RegistrationOptions_TypeID = 0xc793e50592935b4a

func NewRegistrationOptions(s *capnp.Segment) (RegistrationOptions, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 8})
	return RegistrationOptions{st}, err
}

func NewRootRegistrationOptions(s *capnp.Segment) (RegistrationOptions, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 8})
	return RegistrationOptions{st}, err
}

func ReadRootRegistrationOptions(msg *capnp.Message) (RegistrationOptions, error) {
	root, err := msg.RootPtr()
	return RegistrationOptions{root.Struct()}, err
}

func (s RegistrationOptions) String() string {
	str, _ := text.Marshal(0xc793e50592935b4a, s.Struct)
	return str
}

func (s RegistrationOptions) ClientId() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s RegistrationOptions) HasClientId() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s RegistrationOptions) ClientIdBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s RegistrationOptions) SetClientId(v string) error {
	return s.Struct.SetText(0, v)
}

func (s RegistrationOptions) Version() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s RegistrationOptions) HasVersion() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s RegistrationOptions) VersionBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s RegistrationOptions) SetVersion(v string) error {
	return s.Struct.SetText(1, v)
}

func (s RegistrationOptions) Os() (string, error) {
	p, err := s.Struct.Ptr(2)
	return p.Text(), err
}

func (s RegistrationOptions) HasOs() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s RegistrationOptions) OsBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(2)
	return p.TextBytes(), err
}

func (s RegistrationOptions) SetOs(v string) error {
	return s.Struct.SetText(2, v)
}

func (s RegistrationOptions) ExistingTunnelPolicy() ExistingTunnelPolicy {
	return ExistingTunnelPolicy(s.Struct.Uint16(0))
}

func (s RegistrationOptions) SetExistingTunnelPolicy(v ExistingTunnelPolicy) {
	s.Struct.SetUint16(0, uint16(v))
}

func (s RegistrationOptions) PoolName() (string, error) {
	p, err := s.Struct.Ptr(3)
	return p.Text(), err
}

func (s RegistrationOptions) HasPoolName() bool {
	p, err := s.Struct.Ptr(3)
	return p.IsValid() || err != nil
}

func (s RegistrationOptions) PoolNameBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(3)
	return p.TextBytes(), err
}

func (s RegistrationOptions) SetPoolName(v string) error {
	return s.Struct.SetText(3, v)
}

func (s RegistrationOptions) Tags() (Tag_List, error) {
	p, err := s.Struct.Ptr(4)
	return Tag_List{List: p.List()}, err
}

func (s RegistrationOptions) HasTags() bool {
	p, err := s.Struct.Ptr(4)
	return p.IsValid() || err != nil
}

func (s RegistrationOptions) SetTags(v Tag_List) error {
	return s.Struct.SetPtr(4, v.List.ToPtr())
}

// NewTags sets the tags field to a newly
// allocated Tag_List, preferring placement in s's segment.
func (s RegistrationOptions) NewTags(n int32) (Tag_List, error) {
	l, err := NewTag_List(s.Struct.Segment(), n)
	if err != nil {
		return Tag_List{}, err
	}
	err = s.Struct.SetPtr(4, l.List.ToPtr())
	return l, err
}

func (s RegistrationOptions) ConnectionId() uint8 {
	return s.Struct.Uint8(2)
}

func (s RegistrationOptions) SetConnectionId(v uint8) {
	s.Struct.SetUint8(2, v)
}

func (s RegistrationOptions) OriginLocalIp() (string, error) {
	p, err := s.Struct.Ptr(5)
	return p.Text(), err
}

func (s RegistrationOptions) HasOriginLocalIp() bool {
	p, err := s.Struct.Ptr(5)
	return p.IsValid() || err != nil
}

func (s RegistrationOptions) OriginLocalIpBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(5)
	return p.TextBytes(), err
}

func (s RegistrationOptions) SetOriginLocalIp(v string) error {
	return s.Struct.SetText(5, v)
}

func (s RegistrationOptions) IsAutoupdated() bool {
	return s.Struct.Bit(24)
}

func (s RegistrationOptions) SetIsAutoupdated(v bool) {
	s.Struct.SetBit(24, v)
}

func (s RegistrationOptions) RunFromTerminal() bool {
	return s.Struct.Bit(25)
}

func (s RegistrationOptions) SetRunFromTerminal(v bool) {
	s.Struct.SetBit(25, v)
}

func (s RegistrationOptions) CompressionQuality() uint64 {
	return s.Struct.Uint64(8)
}

func (s RegistrationOptions) SetCompressionQuality(v uint64) {
	s.Struct.SetUint64(8, v)
}

func (s RegistrationOptions) Uuid() (string, error) {
	p, err := s.Struct.Ptr(6)
	return p.Text(), err
}

func (s RegistrationOptions) HasUuid() bool {
	p, err := s.Struct.Ptr(6)
	return p.IsValid() || err != nil
}

func (s RegistrationOptions) UuidBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(6)
	return p.TextBytes(), err
}

func (s RegistrationOptions) SetUuid(v string) error {
	return s.Struct.SetText(6, v)
}

func (s RegistrationOptions) NumPreviousAttempts() uint8 {
	return s.Struct.Uint8(4)
}

func (s RegistrationOptions) SetNumPreviousAttempts(v uint8) {
	s.Struct.SetUint8(4, v)
}

func (s RegistrationOptions) Features() (capnp.TextList, error) {
	p, err := s.Struct.Ptr(7)
	return capnp.TextList{List: p.List()}, err
}

func (s RegistrationOptions) HasFeatures() bool {
	p, err := s.Struct.Ptr(7)
	return p.IsValid() || err != nil
}

func (s RegistrationOptions) SetFeatures(v capnp.TextList) error {
	return s.Struct.SetPtr(7, v.List.ToPtr())
}

// NewFeatures sets the features field to a newly
// allocated capnp.TextList, preferring placement in s's segment.
func (s RegistrationOptions) NewFeatures(n int32) (capnp.TextList, error) {
	l, err := capnp.NewTextList(s.Struct.Segment(), n)
	if err != nil {
		return capnp.TextList{}, err
	}
	err = s.Struct.SetPtr(7, l.List.ToPtr())
	return l, err
}

// RegistrationOptions_List is a list of RegistrationOptions.
type RegistrationOptions_List struct{ capnp.List }

// NewRegistrationOptions creates a new list of RegistrationOptions.
func NewRegistrationOptions_List(s *capnp.Segment, sz int32) (RegistrationOptions_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 16, PointerCount: 8}, sz)
	return RegistrationOptions_List{l}, err
}

func (s RegistrationOptions_List) At(i int) RegistrationOptions {
	return RegistrationOptions{s.List.Struct(i)}
}

func (s RegistrationOptions_List) Set(i int, v RegistrationOptions) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s RegistrationOptions_List) String() string {
	str, _ := text.MarshalList(0xc793e50592935b4a, s.List)
	return str
}

// RegistrationOptions_Promise is a wrapper for a RegistrationOptions promised by a client call.
type RegistrationOptions_Promise struct{ *capnp.Pipeline }

func (p RegistrationOptions_Promise) Struct() (RegistrationOptions, error) {
	s, err := p.Pipeline.Struct()
	return RegistrationOptions{s}, err
}

type Tag struct{ capnp.Struct }

// Tag_TypeID is the unique identifier for the type Tag.
const Tag_TypeID = 0xcbd96442ae3bb01a

func NewTag(s *capnp.Segment) (Tag, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return Tag{st}, err
}

func NewRootTag(s *capnp.Segment) (Tag, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return Tag{st}, err
}

func ReadRootTag(msg *capnp.Message) (Tag, error) {
	root, err := msg.RootPtr()
	return Tag{root.Struct()}, err
}

func (s Tag) String() string {
	str, _ := text.Marshal(0xcbd96442ae3bb01a, s.Struct)
	return str
}

func (s Tag) Name() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s Tag) HasName() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s Tag) NameBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s Tag) SetName(v string) error {
	return s.Struct.SetText(0, v)
}

func (s Tag) Value() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s Tag) HasValue() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s Tag) ValueBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s Tag) SetValue(v string) error {
	return s.Struct.SetText(1, v)
}

// Tag_List is a list of Tag.
type Tag_List struct{ capnp.List }

// NewTag creates a new list of Tag.
func NewTag_List(s *capnp.Segment, sz int32) (Tag_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2}, sz)
	return Tag_List{l}, err
}

func (s Tag_List) At(i int) Tag { return Tag{s.List.Struct(i)} }

func (s Tag_List) Set(i int, v Tag) error { return s.List.SetStruct(i, v.Struct) }

func (s Tag_List) String() string {
	str, _ := text.MarshalList(0xcbd96442ae3bb01a, s.List)
	return str
}

// Tag_Promise is a wrapper for a Tag promised by a client call.
type Tag_Promise struct{ *capnp.Pipeline }

func (p Tag_Promise) Struct() (Tag, error) {
	s, err := p.Pipeline.Struct()
	return Tag{s}, err
}

type ExistingTunnelPolicy uint16

// ExistingTunnelPolicy_TypeID is the unique identifier for the type ExistingTunnelPolicy.
const ExistingTunnelPolicy_TypeID = 0x84cb9536a2cf6d3c

// Values of ExistingTunnelPolicy.
const (
	ExistingTunnelPolicy_ignore     ExistingTunnelPolicy = 0
	ExistingTunnelPolicy_disconnect ExistingTunnelPolicy = 1
	ExistingTunnelPolicy_balance    ExistingTunnelPolicy = 2
)

// String returns the enum's constant name.
func (c ExistingTunnelPolicy) String() string {
	switch c {
	case ExistingTunnelPolicy_ignore:
		return "ignore"
	case ExistingTunnelPolicy_disconnect:
		return "disconnect"
	case ExistingTunnelPolicy_balance:
		return "balance"

	default:
		return ""
	}
}

// ExistingTunnelPolicyFromString returns the enum value with a name,
// or the zero value if there's no such value.
func ExistingTunnelPolicyFromString(c string) ExistingTunnelPolicy {
	switch c {
	case "ignore":
		return ExistingTunnelPolicy_ignore
	case "disconnect":
		return ExistingTunnelPolicy_disconnect
	case "balance":
		return ExistingTunnelPolicy_balance

	default:
		return 0
	}
}

type ExistingTunnelPolicy_List struct{ capnp.List }

func NewExistingTunnelPolicy_List(s *capnp.Segment, sz int32) (ExistingTunnelPolicy_List, error) {
	l, err := capnp.NewUInt16List(s, sz)
	return ExistingTunnelPolicy_List{l.List}, err
}

func (l ExistingTunnelPolicy_List) At(i int) ExistingTunnelPolicy {
	ul := capnp.UInt16List{List: l.List}
	return ExistingTunnelPolicy(ul.At(i))
}

func (l ExistingTunnelPolicy_List) Set(i int, v ExistingTunnelPolicy) {
	ul := capnp.UInt16List{List: l.List}
	ul.Set(i, uint16(v))
}

type ServerInfo struct{ capnp.Struct }

// ServerInfo_TypeID is the unique identifier for the type ServerInfo.
const ServerInfo_TypeID = 0xf2c68e2547ec3866

func NewServerInfo(s *capnp.Segment) (ServerInfo, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return ServerInfo{st}, err
}

func NewRootServerInfo(s *capnp.Segment) (ServerInfo, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return ServerInfo{st}, err
}

func ReadRootServerInfo(msg *capnp.Message) (ServerInfo, error) {
	root, err := msg.RootPtr()
	return ServerInfo{root.Struct()}, err
}

func (s ServerInfo) String() string {
	str, _ := text.Marshal(0xf2c68e2547ec3866, s.Struct)
	return str
}

func (s ServerInfo) LocationName() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s ServerInfo) HasLocationName() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s ServerInfo) LocationNameBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s ServerInfo) SetLocationName(v string) error {
	return s.Struct.SetText(0, v)
}

// ServerInfo_List is a list of ServerInfo.
type ServerInfo_List struct{ capnp.List }

// NewServerInfo creates a new list of ServerInfo.
func NewServerInfo_List(s *capnp.Segment, sz int32) (ServerInfo_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return ServerInfo_List{l}, err
}

func (s ServerInfo_List) At(i int) ServerInfo { return ServerInfo{s.List.Struct(i)} }

func (s ServerInfo_List) Set(i int, v ServerInfo) error { return s.List.SetStruct(i, v.Struct) }

func (s ServerInfo_List) String() string {
	str, _ := text.MarshalList(0xf2c68e2547ec3866, s.List)
	return str
}

// ServerInfo_Promise is a wrapper for a ServerInfo promised by a client call.
type ServerInfo_Promise struct{ *capnp.Pipeline }

func (p ServerInfo_Promise) Struct() (ServerInfo, error) {
	s, err := p.Pipeline.Struct()
	return ServerInfo{s}, err
}

type AuthenticateResponse struct{ capnp.Struct }

// AuthenticateResponse_TypeID is the unique identifier for the type AuthenticateResponse.
const AuthenticateResponse_TypeID = 0x82c325a07ad22a65

func NewAuthenticateResponse(s *capnp.Segment) (AuthenticateResponse, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 3})
	return AuthenticateResponse{st}, err
}

func NewRootAuthenticateResponse(s *capnp.Segment) (AuthenticateResponse, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 3})
	return AuthenticateResponse{st}, err
}

func ReadRootAuthenticateResponse(msg *capnp.Message) (AuthenticateResponse, error) {
	root, err := msg.RootPtr()
	return AuthenticateResponse{root.Struct()}, err
}

func (s AuthenticateResponse) String() string {
	str, _ := text.Marshal(0x82c325a07ad22a65, s.Struct)
	return str
}

func (s AuthenticateResponse) PermanentErr() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s AuthenticateResponse) HasPermanentErr() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s AuthenticateResponse) PermanentErrBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s AuthenticateResponse) SetPermanentErr(v string) error {
	return s.Struct.SetText(0, v)
}

func (s AuthenticateResponse) RetryableErr() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s AuthenticateResponse) HasRetryableErr() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s AuthenticateResponse) RetryableErrBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s AuthenticateResponse) SetRetryableErr(v string) error {
	return s.Struct.SetText(1, v)
}

func (s AuthenticateResponse) Jwt() ([]byte, error) {
	p, err := s.Struct.Ptr(2)
	return []byte(p.Data()), err
}

func (s AuthenticateResponse) HasJwt() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s AuthenticateResponse) SetJwt(v []byte) error {
	return s.Struct.SetData(2, v)
}

func (s AuthenticateResponse) HoursUntilRefresh() uint8 {
	return s.Struct.Uint8(0)
}

func (s AuthenticateResponse) SetHoursUntilRefresh(v uint8) {
	s.Struct.SetUint8(0, v)
}

// AuthenticateResponse_List is a list of AuthenticateResponse.
type AuthenticateResponse_List struct{ capnp.List }

// NewAuthenticateResponse creates a new list of AuthenticateResponse.
func NewAuthenticateResponse_List(s *capnp.Segment, sz int32) (AuthenticateResponse_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 3}, sz)
	return AuthenticateResponse_List{l}, err
}

func (s AuthenticateResponse_List) At(i int) AuthenticateResponse {
	return AuthenticateResponse{s.List.Struct(i)}
}

func (s AuthenticateResponse_List) Set(i int, v AuthenticateResponse) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s AuthenticateResponse_List) String() string {
	str, _ := text.MarshalList(0x82c325a07ad22a65, s.List)
	return str
}

// AuthenticateResponse_Promise is a wrapper for a AuthenticateResponse promised by a client call.
type AuthenticateResponse_Promise struct{ *capnp.Pipeline }

func (p AuthenticateResponse_Promise) Struct() (AuthenticateResponse, error) {
	s, err := p.Pipeline.Struct()
	return AuthenticateResponse{s}, err
}

type ClientInfo struct{ capnp.Struct }

// ClientInfo_TypeID is the unique identifier for the type ClientInfo.
const ClientInfo_TypeID = 0x83ced0145b2f114b

func NewClientInfo(s *capnp.Segment) (ClientInfo, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 4})
	return ClientInfo{st}, err
}

func NewRootClientInfo(s *capnp.Segment) (ClientInfo, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 4})
	return ClientInfo{st}, err
}

func ReadRootClientInfo(msg *capnp.Message) (ClientInfo, error) {
	root, err := msg.RootPtr()
	return ClientInfo{root.Struct()}, err
}

func (s ClientInfo) String() string {
	str, _ := text.Marshal(0x83ced0145b2f114b, s.Struct)
	return str
}

func (s ClientInfo) ClientId() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return []byte(p.Data()), err
}

func (s ClientInfo) HasClientId() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s ClientInfo) SetClientId(v []byte) error {
	return s.Struct.SetData(0, v)
}

func (s ClientInfo) Features() (capnp.TextList, error) {
	p, err := s.Struct.Ptr(1)
	return capnp.TextList{List: p.List()}, err
}

func (s ClientInfo) HasFeatures() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s ClientInfo) SetFeatures(v capnp.TextList) error {
	return s.Struct.SetPtr(1, v.List.ToPtr())
}

// NewFeatures sets the features field to a newly
// allocated capnp.TextList, preferring placement in s's segment.
func (s ClientInfo) NewFeatures(n int32) (capnp.TextList, error) {
	l, err := capnp.NewTextList(s.Struct.Segment(), n)
	if err != nil {
		return capnp.TextList{}, err
	}
	err = s.Struct.SetPtr(1, l.List.ToPtr())
	return l, err
}

func (s ClientInfo) Version() (string, error) {
	p, err := s.Struct.Ptr(2)
	return p.Text(), err
}

func (s ClientInfo) HasVersion() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s ClientInfo) VersionBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(2)
	return p.TextBytes(), err
}

func (s ClientInfo) SetVersion(v string) error {
	return s.Struct.SetText(2, v)
}

func (s ClientInfo) Arch() (string, error) {
	p, err := s.Struct.Ptr(3)
	return p.Text(), err
}

func (s ClientInfo) HasArch() bool {
	p, err := s.Struct.Ptr(3)
	return p.IsValid() || err != nil
}

func (s ClientInfo) ArchBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(3)
	return p.TextBytes(), err
}

func (s ClientInfo) SetArch(v string) error {
	return s.Struct.SetText(3, v)
}

// ClientInfo_List is a list of ClientInfo.
type ClientInfo_List struct{ capnp.List }

// NewClientInfo creates a new list of ClientInfo.
func NewClientInfo_List(s *capnp.Segment, sz int32) (ClientInfo_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 4}, sz)
	return ClientInfo_List{l}, err
}

func (s ClientInfo_List) At(i int) ClientInfo { return ClientInfo{s.List.Struct(i)} }

func (s ClientInfo_List) Set(i int, v ClientInfo) error { return s.List.SetStruct(i, v.Struct) }

func (s ClientInfo_List) String() string {
	str, _ := text.MarshalList(0x83ced0145b2f114b, s.List)
	return str
}

// ClientInfo_Promise is a wrapper for a ClientInfo promised by a client call.
type ClientInfo_Promise struct{ *capnp.Pipeline }

func (p ClientInfo_Promise) Struct() (ClientInfo, error) {
	s, err := p.Pipeline.Struct()
	return ClientInfo{s}, err
}

type ConnectionOptions struct{ capnp.Struct }

// ConnectionOptions_TypeID is the unique identifier for the type ConnectionOptions.
const ConnectionOptions_TypeID = 0xb4bf9861fe035d04

func NewConnectionOptions(s *capnp.Segment) (ConnectionOptions, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return ConnectionOptions{st}, err
}

func NewRootConnectionOptions(s *capnp.Segment) (ConnectionOptions, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return ConnectionOptions{st}, err
}

func ReadRootConnectionOptions(msg *capnp.Message) (ConnectionOptions, error) {
	root, err := msg.RootPtr()
	return ConnectionOptions{root.Struct()}, err
}

func (s ConnectionOptions) String() string {
	str, _ := text.Marshal(0xb4bf9861fe035d04, s.Struct)
	return str
}

func (s ConnectionOptions) Client() (ClientInfo, error) {
	p, err := s.Struct.Ptr(0)
	return ClientInfo{Struct: p.Struct()}, err
}

func (s ConnectionOptions) HasClient() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s ConnectionOptions) SetClient(v ClientInfo) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewClient sets the client field to a newly
// allocated ClientInfo struct, preferring placement in s's segment.
func (s ConnectionOptions) NewClient() (ClientInfo, error) {
	ss, err := NewClientInfo(s.Struct.Segment())
	if err != nil {
		return ClientInfo{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

func (s ConnectionOptions) OriginLocalIp() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return []byte(p.Data()), err
}

func (s ConnectionOptions) HasOriginLocalIp() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s ConnectionOptions) SetOriginLocalIp(v []byte) error {
	return s.Struct.SetData(1, v)
}

func (s ConnectionOptions) ReplaceExisting() bool {
	return s.Struct.Bit(0)
}

func (s ConnectionOptions) SetReplaceExisting(v bool) {
	s.Struct.SetBit(0, v)
}

func (s ConnectionOptions) CompressionQuality() uint8 {
	return s.Struct.Uint8(1)
}

func (s ConnectionOptions) SetCompressionQuality(v uint8) {
	s.Struct.SetUint8(1, v)
}

func (s ConnectionOptions) NumPreviousAttempts() uint8 {
	return s.Struct.Uint8(2)
}

func (s ConnectionOptions) SetNumPreviousAttempts(v uint8) {
	s.Struct.SetUint8(2, v)
}

// ConnectionOptions_List is a list of ConnectionOptions.
type ConnectionOptions_List struct{ capnp.List }

// NewConnectionOptions creates a new list of ConnectionOptions.
func NewConnectionOptions_List(s *capnp.Segment, sz int32) (ConnectionOptions_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2}, sz)
	return ConnectionOptions_List{l}, err
}

func (s ConnectionOptions_List) At(i int) ConnectionOptions {
	return ConnectionOptions{s.List.Struct(i)}
}

func (s ConnectionOptions_List) Set(i int, v ConnectionOptions) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s ConnectionOptions_List) String() string {
	str, _ := text.MarshalList(0xb4bf9861fe035d04, s.List)
	return str
}

// ConnectionOptions_Promise is a wrapper for a ConnectionOptions promised by a client call.
type ConnectionOptions_Promise struct{ *capnp.Pipeline }

func (p ConnectionOptions_Promise) Struct() (ConnectionOptions, error) {
	s, err := p.Pipeline.Struct()
	return ConnectionOptions{s}, err
}

func (p ConnectionOptions_Promise) Client() ClientInfo_Promise {
	return ClientInfo_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type ConnectionResponse struct{ capnp.Struct }
type ConnectionResponse_result ConnectionResponse
type ConnectionResponse_result_Which uint16

const (
	ConnectionResponse_result_Which_error             ConnectionResponse_result_Which = 0
	ConnectionResponse_result_Which_connectionDetails ConnectionResponse_result_Which = 1
)

func (w ConnectionResponse_result_Which) String() string {
	const s = "errorconnectionDetails"
	switch w {
	case ConnectionResponse_result_Which_error:
		return s[0:5]
	case ConnectionResponse_result_Which_connectionDetails:
		return s[5:22]

	}
	return "ConnectionResponse_result_Which(" + strconv.FormatUint(uint64(w), 10) + ")"
}

// ConnectionResponse_TypeID is the unique identifier for the type ConnectionResponse.
const ConnectionResponse_TypeID = 0xdbaa9d03d52b62dc

func NewConnectionResponse(s *capnp.Segment) (ConnectionResponse, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return ConnectionResponse{st}, err
}

func NewRootConnectionResponse(s *capnp.Segment) (ConnectionResponse, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return ConnectionResponse{st}, err
}

func ReadRootConnectionResponse(msg *capnp.Message) (ConnectionResponse, error) {
	root, err := msg.RootPtr()
	return ConnectionResponse{root.Struct()}, err
}

func (s ConnectionResponse) String() string {
	str, _ := text.Marshal(0xdbaa9d03d52b62dc, s.Struct)
	return str
}

func (s ConnectionResponse) Result() ConnectionResponse_result { return ConnectionResponse_result(s) }

func (s ConnectionResponse_result) Which() ConnectionResponse_result_Which {
	return ConnectionResponse_result_Which(s.Struct.Uint16(0))
}
func (s ConnectionResponse_result) Error() (ConnectionError, error) {
	if s.Struct.Uint16(0) != 0 {
		panic("Which() != error")
	}
	p, err := s.Struct.Ptr(0)
	return ConnectionError{Struct: p.Struct()}, err
}

func (s ConnectionResponse_result) HasError() bool {
	if s.Struct.Uint16(0) != 0 {
		return false
	}
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s ConnectionResponse_result) SetError(v ConnectionError) error {
	s.Struct.SetUint16(0, 0)
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewError sets the error field to a newly
// allocated ConnectionError struct, preferring placement in s's segment.
func (s ConnectionResponse_result) NewError() (ConnectionError, error) {
	s.Struct.SetUint16(0, 0)
	ss, err := NewConnectionError(s.Struct.Segment())
	if err != nil {
		return ConnectionError{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

func (s ConnectionResponse_result) ConnectionDetails() (ConnectionDetails, error) {
	if s.Struct.Uint16(0) != 1 {
		panic("Which() != connectionDetails")
	}
	p, err := s.Struct.Ptr(0)
	return ConnectionDetails{Struct: p.Struct()}, err
}

func (s ConnectionResponse_result) HasConnectionDetails() bool {
	if s.Struct.Uint16(0) != 1 {
		return false
	}
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s ConnectionResponse_result) SetConnectionDetails(v ConnectionDetails) error {
	s.Struct.SetUint16(0, 1)
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewConnectionDetails sets the connectionDetails field to a newly
// allocated ConnectionDetails struct, preferring placement in s's segment.
func (s ConnectionResponse_result) NewConnectionDetails() (ConnectionDetails, error) {
	s.Struct.SetUint16(0, 1)
	ss, err := NewConnectionDetails(s.Struct.Segment())
	if err != nil {
		return ConnectionDetails{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// ConnectionResponse_List is a list of ConnectionResponse.
type ConnectionResponse_List struct{ capnp.List }

// NewConnectionResponse creates a new list of ConnectionResponse.
func NewConnectionResponse_List(s *capnp.Segment, sz int32) (ConnectionResponse_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return ConnectionResponse_List{l}, err
}

func (s ConnectionResponse_List) At(i int) ConnectionResponse {
	return ConnectionResponse{s.List.Struct(i)}
}

func (s ConnectionResponse_List) Set(i int, v ConnectionResponse) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s ConnectionResponse_List) String() string {
	str, _ := text.MarshalList(0xdbaa9d03d52b62dc, s.List)
	return str
}

// ConnectionResponse_Promise is a wrapper for a ConnectionResponse promised by a client call.
type ConnectionResponse_Promise struct{ *capnp.Pipeline }

func (p ConnectionResponse_Promise) Struct() (ConnectionResponse, error) {
	s, err := p.Pipeline.Struct()
	return ConnectionResponse{s}, err
}

func (p ConnectionResponse_Promise) Result() ConnectionResponse_result_Promise {
	return ConnectionResponse_result_Promise{p.Pipeline}
}

// ConnectionResponse_result_Promise is a wrapper for a ConnectionResponse_result promised by a client call.
type ConnectionResponse_result_Promise struct{ *capnp.Pipeline }

func (p ConnectionResponse_result_Promise) Struct() (ConnectionResponse_result, error) {
	s, err := p.Pipeline.Struct()
	return ConnectionResponse_result{s}, err
}

func (p ConnectionResponse_result_Promise) Error() ConnectionError_Promise {
	return ConnectionError_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

func (p ConnectionResponse_result_Promise) ConnectionDetails() ConnectionDetails_Promise {
	return ConnectionDetails_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type ConnectionError struct{ capnp.Struct }

// ConnectionError_TypeID is the unique identifier for the type ConnectionError.
const ConnectionError_TypeID = 0xf5f383d2785edb86

func NewConnectionError(s *capnp.Segment) (ConnectionError, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 1})
	return ConnectionError{st}, err
}

func NewRootConnectionError(s *capnp.Segment) (ConnectionError, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 1})
	return ConnectionError{st}, err
}

func ReadRootConnectionError(msg *capnp.Message) (ConnectionError, error) {
	root, err := msg.RootPtr()
	return ConnectionError{root.Struct()}, err
}

func (s ConnectionError) String() string {
	str, _ := text.Marshal(0xf5f383d2785edb86, s.Struct)
	return str
}

func (s ConnectionError) Cause() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s ConnectionError) HasCause() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s ConnectionError) CauseBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s ConnectionError) SetCause(v string) error {
	return s.Struct.SetText(0, v)
}

func (s ConnectionError) RetryAfter() int64 {
	return int64(s.Struct.Uint64(0))
}

func (s ConnectionError) SetRetryAfter(v int64) {
	s.Struct.SetUint64(0, uint64(v))
}

func (s ConnectionError) ShouldRetry() bool {
	return s.Struct.Bit(64)
}

func (s ConnectionError) SetShouldRetry(v bool) {
	s.Struct.SetBit(64, v)
}

// ConnectionError_List is a list of ConnectionError.
type ConnectionError_List struct{ capnp.List }

// NewConnectionError creates a new list of ConnectionError.
func NewConnectionError_List(s *capnp.Segment, sz int32) (ConnectionError_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 16, PointerCount: 1}, sz)
	return ConnectionError_List{l}, err
}

func (s ConnectionError_List) At(i int) ConnectionError { return ConnectionError{s.List.Struct(i)} }

func (s ConnectionError_List) Set(i int, v ConnectionError) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s ConnectionError_List) String() string {
	str, _ := text.MarshalList(0xf5f383d2785edb86, s.List)
	return str
}

// ConnectionError_Promise is a wrapper for a ConnectionError promised by a client call.
type ConnectionError_Promise struct{ *capnp.Pipeline }

func (p ConnectionError_Promise) Struct() (ConnectionError, error) {
	s, err := p.Pipeline.Struct()
	return ConnectionError{s}, err
}

type ConnectionDetails struct{ capnp.Struct }

// ConnectionDetails_TypeID is the unique identifier for the type ConnectionDetails.
const ConnectionDetails_TypeID = 0xb5f39f082b9ac18a

func NewConnectionDetails(s *capnp.Segment) (ConnectionDetails, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return ConnectionDetails{st}, err
}

func NewRootConnectionDetails(s *capnp.Segment) (ConnectionDetails, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return ConnectionDetails{st}, err
}

func ReadRootConnectionDetails(msg *capnp.Message) (ConnectionDetails, error) {
	root, err := msg.RootPtr()
	return ConnectionDetails{root.Struct()}, err
}

func (s ConnectionDetails) String() string {
	str, _ := text.Marshal(0xb5f39f082b9ac18a, s.Struct)
	return str
}

func (s ConnectionDetails) Uuid() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return []byte(p.Data()), err
}

func (s ConnectionDetails) HasUuid() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s ConnectionDetails) SetUuid(v []byte) error {
	return s.Struct.SetData(0, v)
}

func (s ConnectionDetails) LocationName() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s ConnectionDetails) HasLocationName() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s ConnectionDetails) LocationNameBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s ConnectionDetails) SetLocationName(v string) error {
	return s.Struct.SetText(1, v)
}

func (s ConnectionDetails) TunnelIsRemotelyManaged() bool {
	return s.Struct.Bit(0)
}

func (s ConnectionDetails) SetTunnelIsRemotelyManaged(v bool) {
	s.Struct.SetBit(0, v)
}

// ConnectionDetails_List is a list of ConnectionDetails.
type ConnectionDetails_List struct{ capnp.List }

// NewConnectionDetails creates a new list of ConnectionDetails.
func NewConnectionDetails_List(s *capnp.Segment, sz int32) (ConnectionDetails_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2}, sz)
	return ConnectionDetails_List{l}, err
}

func (s ConnectionDetails_List) At(i int) ConnectionDetails {
	return ConnectionDetails{s.List.Struct(i)}
}

func (s ConnectionDetails_List) Set(i int, v ConnectionDetails) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s ConnectionDetails_List) String() string {
	str, _ := text.MarshalList(0xb5f39f082b9ac18a, s.List)
	return str
}

// ConnectionDetails_Promise is a wrapper for a ConnectionDetails promised by a client call.
type ConnectionDetails_Promise struct{ *capnp.Pipeline }

func (p ConnectionDetails_Promise) Struct() (ConnectionDetails, error) {
	s, err := p.Pipeline.Struct()
	return ConnectionDetails{s}, err
}

type TunnelAuth struct{ capnp.Struct }

// TunnelAuth_TypeID is the unique identifier for the type TunnelAuth.
const TunnelAuth_TypeID = 0x9496331ab9cd463f

func NewTunnelAuth(s *capnp.Segment) (TunnelAuth, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return TunnelAuth{st}, err
}

func NewRootTunnelAuth(s *capnp.Segment) (TunnelAuth, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return TunnelAuth{st}, err
}

func ReadRootTunnelAuth(msg *capnp.Message) (TunnelAuth, error) {
	root, err := msg.RootPtr()
	return TunnelAuth{root.Struct()}, err
}

func (s TunnelAuth) String() string {
	str, _ := text.Marshal(0x9496331ab9cd463f, s.Struct)
	return str
}

func (s TunnelAuth) AccountTag() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s TunnelAuth) HasAccountTag() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s TunnelAuth) AccountTagBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s TunnelAuth) SetAccountTag(v string) error {
	return s.Struct.SetText(0, v)
}

func (s TunnelAuth) TunnelSecret() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return []byte(p.Data()), err
}

func (s TunnelAuth) HasTunnelSecret() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s TunnelAuth) SetTunnelSecret(v []byte) error {
	return s.Struct.SetData(1, v)
}

// TunnelAuth_List is a list of TunnelAuth.
type TunnelAuth_List struct{ capnp.List }

// NewTunnelAuth creates a new list of TunnelAuth.
func NewTunnelAuth_List(s *capnp.Segment, sz int32) (TunnelAuth_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2}, sz)
	return TunnelAuth_List{l}, err
}

func (s TunnelAuth_List) At(i int) TunnelAuth { return TunnelAuth{s.List.Struct(i)} }

func (s TunnelAuth_List) Set(i int, v TunnelAuth) error { return s.List.SetStruct(i, v.Struct) }

func (s TunnelAuth_List) String() string {
	str, _ := text.MarshalList(0x9496331ab9cd463f, s.List)
	return str
}

// TunnelAuth_Promise is a wrapper for a TunnelAuth promised by a client call.
type TunnelAuth_Promise struct{ *capnp.Pipeline }

func (p TunnelAuth_Promise) Struct() (TunnelAuth, error) {
	s, err := p.Pipeline.Struct()
	return TunnelAuth{s}, err
}

type RegistrationServer struct{ Client capnp.Client }

// RegistrationServer_TypeID is the unique identifier for the type RegistrationServer.
const RegistrationServer_TypeID = 0xf71695ec7fe85497

func (c RegistrationServer) RegisterConnection(ctx context.Context, params func(RegistrationServer_registerConnection_Params) error, opts ...capnp.CallOption) RegistrationServer_registerConnection_Results_Promise {
	if c.Client == nil {
		return RegistrationServer_registerConnection_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xf71695ec7fe85497,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:RegistrationServer",
			MethodName:    "registerConnection",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 8, PointerCount: 3}
		call.ParamsFunc = func(s capnp.Struct) error { return params(RegistrationServer_registerConnection_Params{Struct: s}) }
	}
	return RegistrationServer_registerConnection_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c RegistrationServer) UnregisterConnection(ctx context.Context, params func(RegistrationServer_unregisterConnection_Params) error, opts ...capnp.CallOption) RegistrationServer_unregisterConnection_Results_Promise {
	if c.Client == nil {
		return RegistrationServer_unregisterConnection_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xf71695ec7fe85497,
			MethodID:      1,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:RegistrationServer",
			MethodName:    "unregisterConnection",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 0}
		call.ParamsFunc = func(s capnp.Struct) error { return params(RegistrationServer_unregisterConnection_Params{Struct: s}) }
	}
	return RegistrationServer_unregisterConnection_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c RegistrationServer) UpdateLocalConfiguration(ctx context.Context, params func(RegistrationServer_updateLocalConfiguration_Params) error, opts ...capnp.CallOption) RegistrationServer_updateLocalConfiguration_Results_Promise {
	if c.Client == nil {
		return RegistrationServer_updateLocalConfiguration_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xf71695ec7fe85497,
			MethodID:      2,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:RegistrationServer",
			MethodName:    "updateLocalConfiguration",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 1}
		call.ParamsFunc = func(s capnp.Struct) error {
			return params(RegistrationServer_updateLocalConfiguration_Params{Struct: s})
		}
	}
	return RegistrationServer_updateLocalConfiguration_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}

type RegistrationServer_Server interface {
	RegisterConnection(RegistrationServer_registerConnection) error

	UnregisterConnection(RegistrationServer_unregisterConnection) error

	UpdateLocalConfiguration(RegistrationServer_updateLocalConfiguration) error
}

func RegistrationServer_ServerToClient(s RegistrationServer_Server) RegistrationServer {
	c, _ := s.(server.Closer)
	return RegistrationServer{Client: server.New(RegistrationServer_Methods(nil, s), c)}
}

func RegistrationServer_Methods(methods []server.Method, s RegistrationServer_Server) []server.Method {
	if cap(methods) == 0 {
		methods = make([]server.Method, 0, 3)
	}

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xf71695ec7fe85497,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:RegistrationServer",
			MethodName:    "registerConnection",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := RegistrationServer_registerConnection{c, opts, RegistrationServer_registerConnection_Params{Struct: p}, RegistrationServer_registerConnection_Results{Struct: r}}
			return s.RegisterConnection(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 1},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xf71695ec7fe85497,
			MethodID:      1,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:RegistrationServer",
			MethodName:    "unregisterConnection",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := RegistrationServer_unregisterConnection{c, opts, RegistrationServer_unregisterConnection_Params{Struct: p}, RegistrationServer_unregisterConnection_Results{Struct: r}}
			return s.UnregisterConnection(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 0},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xf71695ec7fe85497,
			MethodID:      2,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:RegistrationServer",
			MethodName:    "updateLocalConfiguration",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := RegistrationServer_updateLocalConfiguration{c, opts, RegistrationServer_updateLocalConfiguration_Params{Struct: p}, RegistrationServer_updateLocalConfiguration_Results{Struct: r}}
			return s.UpdateLocalConfiguration(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 0},
	})

	return methods
}

// RegistrationServer_registerConnection holds the arguments for a server call to RegistrationServer.registerConnection.
type RegistrationServer_registerConnection struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  RegistrationServer_registerConnection_Params
	Results RegistrationServer_registerConnection_Results
}

// RegistrationServer_unregisterConnection holds the arguments for a server call to RegistrationServer.unregisterConnection.
type RegistrationServer_unregisterConnection struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  RegistrationServer_unregisterConnection_Params
	Results RegistrationServer_unregisterConnection_Results
}

// RegistrationServer_updateLocalConfiguration holds the arguments for a server call to RegistrationServer.updateLocalConfiguration.
type RegistrationServer_updateLocalConfiguration struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  RegistrationServer_updateLocalConfiguration_Params
	Results RegistrationServer_updateLocalConfiguration_Results
}

type RegistrationServer_registerConnection_Params struct{ capnp.Struct }

// RegistrationServer_registerConnection_Params_TypeID is the unique identifier for the type RegistrationServer_registerConnection_Params.
const RegistrationServer_registerConnection_Params_TypeID = 0xe6646dec8feaa6ee

func NewRegistrationServer_registerConnection_Params(s *capnp.Segment) (RegistrationServer_registerConnection_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 3})
	return RegistrationServer_registerConnection_Params{st}, err
}

func NewRootRegistrationServer_registerConnection_Params(s *capnp.Segment) (RegistrationServer_registerConnection_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 3})
	return RegistrationServer_registerConnection_Params{st}, err
}

func ReadRootRegistrationServer_registerConnection_Params(msg *capnp.Message) (RegistrationServer_registerConnection_Params, error) {
	root, err := msg.RootPtr()
	return RegistrationServer_registerConnection_Params{root.Struct()}, err
}

func (s RegistrationServer_registerConnection_Params) String() string {
	str, _ := text.Marshal(0xe6646dec8feaa6ee, s.Struct)
	return str
}

func (s RegistrationServer_registerConnection_Params) Auth() (TunnelAuth, error) {
	p, err := s.Struct.Ptr(0)
	return TunnelAuth{Struct: p.Struct()}, err
}

func (s RegistrationServer_registerConnection_Params) HasAuth() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s RegistrationServer_registerConnection_Params) SetAuth(v TunnelAuth) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewAuth sets the auth field to a newly
// allocated TunnelAuth struct, preferring placement in s's segment.
func (s RegistrationServer_registerConnection_Params) NewAuth() (TunnelAuth, error) {
	ss, err := NewTunnelAuth(s.Struct.Segment())
	if err != nil {
		return TunnelAuth{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

func (s RegistrationServer_registerConnection_Params) TunnelId() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return []byte(p.Data()), err
}

func (s RegistrationServer_registerConnection_Params) HasTunnelId() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s RegistrationServer_registerConnection_Params) SetTunnelId(v []byte) error {
	return s.Struct.SetData(1, v)
}

func (s RegistrationServer_registerConnection_Params) ConnIndex() uint8 {
	return s.Struct.Uint8(0)
}

func (s RegistrationServer_registerConnection_Params) SetConnIndex(v uint8) {
	s.Struct.SetUint8(0, v)
}

func (s RegistrationServer_registerConnection_Params) Options() (ConnectionOptions, error) {
	p, err := s.Struct.Ptr(2)
	return ConnectionOptions{Struct: p.Struct()}, err
}

func (s RegistrationServer_registerConnection_Params) HasOptions() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s RegistrationServer_registerConnection_Params) SetOptions(v ConnectionOptions) error {
	return s.Struct.SetPtr(2, v.Struct.ToPtr())
}

// NewOptions sets the options field to a newly
// allocated ConnectionOptions struct, preferring placement in s's segment.
func (s RegistrationServer_registerConnection_Params) NewOptions() (ConnectionOptions, error) {
	ss, err := NewConnectionOptions(s.Struct.Segment())
	if err != nil {
		return ConnectionOptions{}, err
	}
	err = s.Struct.SetPtr(2, ss.Struct.ToPtr())
	return ss, err
}

// RegistrationServer_registerConnection_Params_List is a list of RegistrationServer_registerConnection_Params.
type RegistrationServer_registerConnection_Params_List struct{ capnp.List }

// NewRegistrationServer_registerConnection_Params creates a new list of RegistrationServer_registerConnection_Params.
func NewRegistrationServer_registerConnection_Params_List(s *capnp.Segment, sz int32) (RegistrationServer_registerConnection_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 3}, sz)
	return RegistrationServer_registerConnection_Params_List{l}, err
}

func (s RegistrationServer_registerConnection_Params_List) At(i int) RegistrationServer_registerConnection_Params {
	return RegistrationServer_registerConnection_Params{s.List.Struct(i)}
}

func (s RegistrationServer_registerConnection_Params_List) Set(i int, v RegistrationServer_registerConnection_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s RegistrationServer_registerConnection_Params_List) String() string {
	str, _ := text.MarshalList(0xe6646dec8feaa6ee, s.List)
	return str
}

// RegistrationServer_registerConnection_Params_Promise is a wrapper for a RegistrationServer_registerConnection_Params promised by a client call.
type RegistrationServer_registerConnection_Params_Promise struct{ *capnp.Pipeline }

func (p RegistrationServer_registerConnection_Params_Promise) Struct() (RegistrationServer_registerConnection_Params, error) {
	s, err := p.Pipeline.Struct()
	return RegistrationServer_registerConnection_Params{s}, err
}

func (p RegistrationServer_registerConnection_Params_Promise) Auth() TunnelAuth_Promise {
	return TunnelAuth_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

func (p RegistrationServer_registerConnection_Params_Promise) Options() ConnectionOptions_Promise {
	return ConnectionOptions_Promise{Pipeline: p.Pipeline.GetPipeline(2)}
}

type RegistrationServer_registerConnection_Results struct{ capnp.Struct }

// RegistrationServer_registerConnection_Results_TypeID is the unique identifier for the type RegistrationServer_registerConnection_Results.
const RegistrationServer_registerConnection_Results_TypeID = 0xea50d822450d1f17

func NewRegistrationServer_registerConnection_Results(s *capnp.Segment) (RegistrationServer_registerConnection_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return RegistrationServer_registerConnection_Results{st}, err
}

func NewRootRegistrationServer_registerConnection_Results(s *capnp.Segment) (RegistrationServer_registerConnection_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return RegistrationServer_registerConnection_Results{st}, err
}

func ReadRootRegistrationServer_registerConnection_Results(msg *capnp.Message) (RegistrationServer_registerConnection_Results, error) {
	root, err := msg.RootPtr()
	return RegistrationServer_registerConnection_Results{root.Struct()}, err
}

func (s RegistrationServer_registerConnection_Results) String() string {
	str, _ := text.Marshal(0xea50d822450d1f17, s.Struct)
	return str
}

func (s RegistrationServer_registerConnection_Results) Result() (ConnectionResponse, error) {
	p, err := s.Struct.Ptr(0)
	return ConnectionResponse{Struct: p.Struct()}, err
}

func (s RegistrationServer_registerConnection_Results) HasResult() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s RegistrationServer_registerConnection_Results) SetResult(v ConnectionResponse) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewResult sets the result field to a newly
// allocated ConnectionResponse struct, preferring placement in s's segment.
func (s RegistrationServer_registerConnection_Results) NewResult() (ConnectionResponse, error) {
	ss, err := NewConnectionResponse(s.Struct.Segment())
	if err != nil {
		return ConnectionResponse{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// RegistrationServer_registerConnection_Results_List is a list of RegistrationServer_registerConnection_Results.
type RegistrationServer_registerConnection_Results_List struct{ capnp.List }

// NewRegistrationServer_registerConnection_Results creates a new list of RegistrationServer_registerConnection_Results.
func NewRegistrationServer_registerConnection_Results_List(s *capnp.Segment, sz int32) (RegistrationServer_registerConnection_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return RegistrationServer_registerConnection_Results_List{l}, err
}

func (s RegistrationServer_registerConnection_Results_List) At(i int) RegistrationServer_registerConnection_Results {
	return RegistrationServer_registerConnection_Results{s.List.Struct(i)}
}

func (s RegistrationServer_registerConnection_Results_List) Set(i int, v RegistrationServer_registerConnection_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s RegistrationServer_registerConnection_Results_List) String() string {
	str, _ := text.MarshalList(0xea50d822450d1f17, s.List)
	return str
}

// RegistrationServer_registerConnection_Results_Promise is a wrapper for a RegistrationServer_registerConnection_Results promised by a client call.
type RegistrationServer_registerConnection_Results_Promise struct{ *capnp.Pipeline }

func (p RegistrationServer_registerConnection_Results_Promise) Struct() (RegistrationServer_registerConnection_Results, error) {
	s, err := p.Pipeline.Struct()
	return RegistrationServer_registerConnection_Results{s}, err
}

func (p RegistrationServer_registerConnection_Results_Promise) Result() ConnectionResponse_Promise {
	return ConnectionResponse_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type RegistrationServer_unregisterConnection_Params struct{ capnp.Struct }

// RegistrationServer_unregisterConnection_Params_TypeID is the unique identifier for the type RegistrationServer_unregisterConnection_Params.
const RegistrationServer_unregisterConnection_Params_TypeID = 0xf9cb7f4431a307d0

func NewRegistrationServer_unregisterConnection_Params(s *capnp.Segment) (RegistrationServer_unregisterConnection_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return RegistrationServer_unregisterConnection_Params{st}, err
}

func NewRootRegistrationServer_unregisterConnection_Params(s *capnp.Segment) (RegistrationServer_unregisterConnection_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return RegistrationServer_unregisterConnection_Params{st}, err
}

func ReadRootRegistrationServer_unregisterConnection_Params(msg *capnp.Message) (RegistrationServer_unregisterConnection_Params, error) {
	root, err := msg.RootPtr()
	return RegistrationServer_unregisterConnection_Params{root.Struct()}, err
}

func (s RegistrationServer_unregisterConnection_Params) String() string {
	str, _ := text.Marshal(0xf9cb7f4431a307d0, s.Struct)
	return str
}

// RegistrationServer_unregisterConnection_Params_List is a list of RegistrationServer_unregisterConnection_Params.
type RegistrationServer_unregisterConnection_Params_List struct{ capnp.List }

// NewRegistrationServer_unregisterConnection_Params creates a new list of RegistrationServer_unregisterConnection_Params.
func NewRegistrationServer_unregisterConnection_Params_List(s *capnp.Segment, sz int32) (RegistrationServer_unregisterConnection_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0}, sz)
	return RegistrationServer_unregisterConnection_Params_List{l}, err
}

func (s RegistrationServer_unregisterConnection_Params_List) At(i int) RegistrationServer_unregisterConnection_Params {
	return RegistrationServer_unregisterConnection_Params{s.List.Struct(i)}
}

func (s RegistrationServer_unregisterConnection_Params_List) Set(i int, v RegistrationServer_unregisterConnection_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s RegistrationServer_unregisterConnection_Params_List) String() string {
	str, _ := text.MarshalList(0xf9cb7f4431a307d0, s.List)
	return str
}

// RegistrationServer_unregisterConnection_Params_Promise is a wrapper for a RegistrationServer_unregisterConnection_Params promised by a client call.
type RegistrationServer_unregisterConnection_Params_Promise struct{ *capnp.Pipeline }

func (p RegistrationServer_unregisterConnection_Params_Promise) Struct() (RegistrationServer_unregisterConnection_Params, error) {
	s, err := p.Pipeline.Struct()
	return RegistrationServer_unregisterConnection_Params{s}, err
}

type RegistrationServer_unregisterConnection_Results struct{ capnp.Struct }

// RegistrationServer_unregisterConnection_Results_TypeID is the unique identifier for the type RegistrationServer_unregisterConnection_Results.
const RegistrationServer_unregisterConnection_Results_TypeID = 0xb046e578094b1ead

func NewRegistrationServer_unregisterConnection_Results(s *capnp.Segment) (RegistrationServer_unregisterConnection_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return RegistrationServer_unregisterConnection_Results{st}, err
}

func NewRootRegistrationServer_unregisterConnection_Results(s *capnp.Segment) (RegistrationServer_unregisterConnection_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return RegistrationServer_unregisterConnection_Results{st}, err
}

func ReadRootRegistrationServer_unregisterConnection_Results(msg *capnp.Message) (RegistrationServer_unregisterConnection_Results, error) {
	root, err := msg.RootPtr()
	return RegistrationServer_unregisterConnection_Results{root.Struct()}, err
}

func (s RegistrationServer_unregisterConnection_Results) String() string {
	str, _ := text.Marshal(0xb046e578094b1ead, s.Struct)
	return str
}

// RegistrationServer_unregisterConnection_Results_List is a list of RegistrationServer_unregisterConnection_Results.
type RegistrationServer_unregisterConnection_Results_List struct{ capnp.List }

// NewRegistrationServer_unregisterConnection_Results creates a new list of RegistrationServer_unregisterConnection_Results.
func NewRegistrationServer_unregisterConnection_Results_List(s *capnp.Segment, sz int32) (RegistrationServer_unregisterConnection_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0}, sz)
	return RegistrationServer_unregisterConnection_Results_List{l}, err
}

func (s RegistrationServer_unregisterConnection_Results_List) At(i int) RegistrationServer_unregisterConnection_Results {
	return RegistrationServer_unregisterConnection_Results{s.List.Struct(i)}
}

func (s RegistrationServer_unregisterConnection_Results_List) Set(i int, v RegistrationServer_unregisterConnection_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s RegistrationServer_unregisterConnection_Results_List) String() string {
	str, _ := text.MarshalList(0xb046e578094b1ead, s.List)
	return str
}

// RegistrationServer_unregisterConnection_Results_Promise is a wrapper for a RegistrationServer_unregisterConnection_Results promised by a client call.
type RegistrationServer_unregisterConnection_Results_Promise struct{ *capnp.Pipeline }

func (p RegistrationServer_unregisterConnection_Results_Promise) Struct() (RegistrationServer_unregisterConnection_Results, error) {
	s, err := p.Pipeline.Struct()
	return RegistrationServer_unregisterConnection_Results{s}, err
}

type RegistrationServer_updateLocalConfiguration_Params struct{ capnp.Struct }

// RegistrationServer_updateLocalConfiguration_Params_TypeID is the unique identifier for the type RegistrationServer_updateLocalConfiguration_Params.
const RegistrationServer_updateLocalConfiguration_Params_TypeID = 0xc5d6e311876a3604

func NewRegistrationServer_updateLocalConfiguration_Params(s *capnp.Segment) (RegistrationServer_updateLocalConfiguration_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return RegistrationServer_updateLocalConfiguration_Params{st}, err
}

func NewRootRegistrationServer_updateLocalConfiguration_Params(s *capnp.Segment) (RegistrationServer_updateLocalConfiguration_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return RegistrationServer_updateLocalConfiguration_Params{st}, err
}

func ReadRootRegistrationServer_updateLocalConfiguration_Params(msg *capnp.Message) (RegistrationServer_updateLocalConfiguration_Params, error) {
	root, err := msg.RootPtr()
	return RegistrationServer_updateLocalConfiguration_Params{root.Struct()}, err
}

func (s RegistrationServer_updateLocalConfiguration_Params) String() string {
	str, _ := text.Marshal(0xc5d6e311876a3604, s.Struct)
	return str
}

func (s RegistrationServer_updateLocalConfiguration_Params) Config() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return []byte(p.Data()), err
}

func (s RegistrationServer_updateLocalConfiguration_Params) HasConfig() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s RegistrationServer_updateLocalConfiguration_Params) SetConfig(v []byte) error {
	return s.Struct.SetData(0, v)
}

// RegistrationServer_updateLocalConfiguration_Params_List is a list of RegistrationServer_updateLocalConfiguration_Params.
type RegistrationServer_updateLocalConfiguration_Params_List struct{ capnp.List }

// NewRegistrationServer_updateLocalConfiguration_Params creates a new list of RegistrationServer_updateLocalConfiguration_Params.
func NewRegistrationServer_updateLocalConfiguration_Params_List(s *capnp.Segment, sz int32) (RegistrationServer_updateLocalConfiguration_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return RegistrationServer_updateLocalConfiguration_Params_List{l}, err
}

func (s RegistrationServer_updateLocalConfiguration_Params_List) At(i int) RegistrationServer_updateLocalConfiguration_Params {
	return RegistrationServer_updateLocalConfiguration_Params{s.List.Struct(i)}
}

func (s RegistrationServer_updateLocalConfiguration_Params_List) Set(i int, v RegistrationServer_updateLocalConfiguration_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s RegistrationServer_updateLocalConfiguration_Params_List) String() string {
	str, _ := text.MarshalList(0xc5d6e311876a3604, s.List)
	return str
}

// RegistrationServer_updateLocalConfiguration_Params_Promise is a wrapper for a RegistrationServer_updateLocalConfiguration_Params promised by a client call.
type RegistrationServer_updateLocalConfiguration_Params_Promise struct{ *capnp.Pipeline }

func (p RegistrationServer_updateLocalConfiguration_Params_Promise) Struct() (RegistrationServer_updateLocalConfiguration_Params, error) {
	s, err := p.Pipeline.Struct()
	return RegistrationServer_updateLocalConfiguration_Params{s}, err
}

type RegistrationServer_updateLocalConfiguration_Results struct{ capnp.Struct }

// RegistrationServer_updateLocalConfiguration_Results_TypeID is the unique identifier for the type RegistrationServer_updateLocalConfiguration_Results.
const RegistrationServer_updateLocalConfiguration_Results_TypeID = 0xe5ceae5d6897d7be

func NewRegistrationServer_updateLocalConfiguration_Results(s *capnp.Segment) (RegistrationServer_updateLocalConfiguration_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return RegistrationServer_updateLocalConfiguration_Results{st}, err
}

func NewRootRegistrationServer_updateLocalConfiguration_Results(s *capnp.Segment) (RegistrationServer_updateLocalConfiguration_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return RegistrationServer_updateLocalConfiguration_Results{st}, err
}

func ReadRootRegistrationServer_updateLocalConfiguration_Results(msg *capnp.Message) (RegistrationServer_updateLocalConfiguration_Results, error) {
	root, err := msg.RootPtr()
	return RegistrationServer_updateLocalConfiguration_Results{root.Struct()}, err
}

func (s RegistrationServer_updateLocalConfiguration_Results) String() string {
	str, _ := text.Marshal(0xe5ceae5d6897d7be, s.Struct)
	return str
}

// RegistrationServer_updateLocalConfiguration_Results_List is a list of RegistrationServer_updateLocalConfiguration_Results.
type RegistrationServer_updateLocalConfiguration_Results_List struct{ capnp.List }

// NewRegistrationServer_updateLocalConfiguration_Results creates a new list of RegistrationServer_updateLocalConfiguration_Results.
func NewRegistrationServer_updateLocalConfiguration_Results_List(s *capnp.Segment, sz int32) (RegistrationServer_updateLocalConfiguration_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0}, sz)
	return RegistrationServer_updateLocalConfiguration_Results_List{l}, err
}

func (s RegistrationServer_updateLocalConfiguration_Results_List) At(i int) RegistrationServer_updateLocalConfiguration_Results {
	return RegistrationServer_updateLocalConfiguration_Results{s.List.Struct(i)}
}

func (s RegistrationServer_updateLocalConfiguration_Results_List) Set(i int, v RegistrationServer_updateLocalConfiguration_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s RegistrationServer_updateLocalConfiguration_Results_List) String() string {
	str, _ := text.MarshalList(0xe5ceae5d6897d7be, s.List)
	return str
}

// RegistrationServer_updateLocalConfiguration_Results_Promise is a wrapper for a RegistrationServer_updateLocalConfiguration_Results promised by a client call.
type RegistrationServer_updateLocalConfiguration_Results_Promise struct{ *capnp.Pipeline }

func (p RegistrationServer_updateLocalConfiguration_Results_Promise) Struct() (RegistrationServer_updateLocalConfiguration_Results, error) {
	s, err := p.Pipeline.Struct()
	return RegistrationServer_updateLocalConfiguration_Results{s}, err
}

type TunnelServer struct{ Client capnp.Client }

// TunnelServer_TypeID is the unique identifier for the type TunnelServer.
const TunnelServer_TypeID = 0xea58385c65416035

func (c TunnelServer) RegisterTunnel(ctx context.Context, params func(TunnelServer_registerTunnel_Params) error, opts ...capnp.CallOption) TunnelServer_registerTunnel_Results_Promise {
	if c.Client == nil {
		return TunnelServer_registerTunnel_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "registerTunnel",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 3}
		call.ParamsFunc = func(s capnp.Struct) error { return params(TunnelServer_registerTunnel_Params{Struct: s}) }
	}
	return TunnelServer_registerTunnel_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c TunnelServer) GetServerInfo(ctx context.Context, params func(TunnelServer_getServerInfo_Params) error, opts ...capnp.CallOption) TunnelServer_getServerInfo_Results_Promise {
	if c.Client == nil {
		return TunnelServer_getServerInfo_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      1,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "getServerInfo",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 0}
		call.ParamsFunc = func(s capnp.Struct) error { return params(TunnelServer_getServerInfo_Params{Struct: s}) }
	}
	return TunnelServer_getServerInfo_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c TunnelServer) UnregisterTunnel(ctx context.Context, params func(TunnelServer_unregisterTunnel_Params) error, opts ...capnp.CallOption) TunnelServer_unregisterTunnel_Results_Promise {
	if c.Client == nil {
		return TunnelServer_unregisterTunnel_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      2,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "unregisterTunnel",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 8, PointerCount: 0}
		call.ParamsFunc = func(s capnp.Struct) error { return params(TunnelServer_unregisterTunnel_Params{Struct: s}) }
	}
	return TunnelServer_unregisterTunnel_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c TunnelServer) ObsoleteDeclarativeTunnelConnect(ctx context.Context, params func(TunnelServer_obsoleteDeclarativeTunnelConnect_Params) error, opts ...capnp.CallOption) TunnelServer_obsoleteDeclarativeTunnelConnect_Results_Promise {
	if c.Client == nil {
		return TunnelServer_obsoleteDeclarativeTunnelConnect_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      3,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "obsoleteDeclarativeTunnelConnect",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 0}
		call.ParamsFunc = func(s capnp.Struct) error {
			return params(TunnelServer_obsoleteDeclarativeTunnelConnect_Params{Struct: s})
		}
	}
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c TunnelServer) Authenticate(ctx context.Context, params func(TunnelServer_authenticate_Params) error, opts ...capnp.CallOption) TunnelServer_authenticate_Results_Promise {
	if c.Client == nil {
		return TunnelServer_authenticate_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      4,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "authenticate",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 3}
		call.ParamsFunc = func(s capnp.Struct) error { return params(TunnelServer_authenticate_Params{Struct: s}) }
	}
	return TunnelServer_authenticate_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c TunnelServer) ReconnectTunnel(ctx context.Context, params func(TunnelServer_reconnectTunnel_Params) error, opts ...capnp.CallOption) TunnelServer_reconnectTunnel_Results_Promise {
	if c.Client == nil {
		return TunnelServer_reconnectTunnel_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      5,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "reconnectTunnel",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 5}
		call.ParamsFunc = func(s capnp.Struct) error { return params(TunnelServer_reconnectTunnel_Params{Struct: s}) }
	}
	return TunnelServer_reconnectTunnel_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c TunnelServer) RegisterConnection(ctx context.Context, params func(RegistrationServer_registerConnection_Params) error, opts ...capnp.CallOption) RegistrationServer_registerConnection_Results_Promise {
	if c.Client == nil {
		return RegistrationServer_registerConnection_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xf71695ec7fe85497,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:RegistrationServer",
			MethodName:    "registerConnection",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 8, PointerCount: 3}
		call.ParamsFunc = func(s capnp.Struct) error { return params(RegistrationServer_registerConnection_Params{Struct: s}) }
	}
	return RegistrationServer_registerConnection_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c TunnelServer) UnregisterConnection(ctx context.Context, params func(RegistrationServer_unregisterConnection_Params) error, opts ...capnp.CallOption) RegistrationServer_unregisterConnection_Results_Promise {
	if c.Client == nil {
		return RegistrationServer_unregisterConnection_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xf71695ec7fe85497,
			MethodID:      1,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:RegistrationServer",
			MethodName:    "unregisterConnection",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 0}
		call.ParamsFunc = func(s capnp.Struct) error { return params(RegistrationServer_unregisterConnection_Params{Struct: s}) }
	}
	return RegistrationServer_unregisterConnection_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c TunnelServer) UpdateLocalConfiguration(ctx context.Context, params func(RegistrationServer_updateLocalConfiguration_Params) error, opts ...capnp.CallOption) RegistrationServer_updateLocalConfiguration_Results_Promise {
	if c.Client == nil {
		return RegistrationServer_updateLocalConfiguration_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xf71695ec7fe85497,
			MethodID:      2,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:RegistrationServer",
			MethodName:    "updateLocalConfiguration",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 1}
		call.ParamsFunc = func(s capnp.Struct) error {
			return params(RegistrationServer_updateLocalConfiguration_Params{Struct: s})
		}
	}
	return RegistrationServer_updateLocalConfiguration_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}

type TunnelServer_Server interface {
	RegisterTunnel(TunnelServer_registerTunnel) error

	GetServerInfo(TunnelServer_getServerInfo) error

	UnregisterTunnel(TunnelServer_unregisterTunnel) error

	ObsoleteDeclarativeTunnelConnect(TunnelServer_obsoleteDeclarativeTunnelConnect) error

	Authenticate(TunnelServer_authenticate) error

	ReconnectTunnel(TunnelServer_reconnectTunnel) error

	RegisterConnection(RegistrationServer_registerConnection) error

	UnregisterConnection(RegistrationServer_unregisterConnection) error

	UpdateLocalConfiguration(RegistrationServer_updateLocalConfiguration) error
}

func TunnelServer_ServerToClient(s TunnelServer_Server) TunnelServer {
	c, _ := s.(server.Closer)
	return TunnelServer{Client: server.New(TunnelServer_Methods(nil, s), c)}
}

func TunnelServer_Methods(methods []server.Method, s TunnelServer_Server) []server.Method {
	if cap(methods) == 0 {
		methods = make([]server.Method, 0, 9)
	}

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "registerTunnel",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := TunnelServer_registerTunnel{c, opts, TunnelServer_registerTunnel_Params{Struct: p}, TunnelServer_registerTunnel_Results{Struct: r}}
			return s.RegisterTunnel(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 1},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      1,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "getServerInfo",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := TunnelServer_getServerInfo{c, opts, TunnelServer_getServerInfo_Params{Struct: p}, TunnelServer_getServerInfo_Results{Struct: r}}
			return s.GetServerInfo(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 1},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      2,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "unregisterTunnel",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := TunnelServer_unregisterTunnel{c, opts, TunnelServer_unregisterTunnel_Params{Struct: p}, TunnelServer_unregisterTunnel_Results{Struct: r}}
			return s.UnregisterTunnel(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 0},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      3,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "obsoleteDeclarativeTunnelConnect",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := TunnelServer_obsoleteDeclarativeTunnelConnect{c, opts, TunnelServer_obsoleteDeclarativeTunnelConnect_Params{Struct: p}, TunnelServer_obsoleteDeclarativeTunnelConnect_Results{Struct: r}}
			return s.ObsoleteDeclarativeTunnelConnect(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 0},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      4,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "authenticate",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := TunnelServer_authenticate{c, opts, TunnelServer_authenticate_Params{Struct: p}, TunnelServer_authenticate_Results{Struct: r}}
			return s.Authenticate(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 1},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xea58385c65416035,
			MethodID:      5,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:TunnelServer",
			MethodName:    "reconnectTunnel",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := TunnelServer_reconnectTunnel{c, opts, TunnelServer_reconnectTunnel_Params{Struct: p}, TunnelServer_reconnectTunnel_Results{Struct: r}}
			return s.ReconnectTunnel(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 1},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xf71695ec7fe85497,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:RegistrationServer",
			MethodName:    "registerConnection",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := RegistrationServer_registerConnection{c, opts, RegistrationServer_registerConnection_Params{Struct: p}, RegistrationServer_registerConnection_Results{Struct: r}}
			return s.RegisterConnection(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 1},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xf71695ec7fe85497,
			MethodID:      1,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:RegistrationServer",
			MethodName:    "unregisterConnection",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := RegistrationServer_unregisterConnection{c, opts, RegistrationServer_unregisterConnection_Params{Struct: p}, RegistrationServer_unregisterConnection_Results{Struct: r}}
			return s.UnregisterConnection(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 0},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xf71695ec7fe85497,
			MethodID:      2,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:RegistrationServer",
			MethodName:    "updateLocalConfiguration",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := RegistrationServer_updateLocalConfiguration{c, opts, RegistrationServer_updateLocalConfiguration_Params{Struct: p}, RegistrationServer_updateLocalConfiguration_Results{Struct: r}}
			return s.UpdateLocalConfiguration(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 0},
	})

	return methods
}

// TunnelServer_registerTunnel holds the arguments for a server call to TunnelServer.registerTunnel.
type TunnelServer_registerTunnel struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  TunnelServer_registerTunnel_Params
	Results TunnelServer_registerTunnel_Results
}

// TunnelServer_getServerInfo holds the arguments for a server call to TunnelServer.getServerInfo.
type TunnelServer_getServerInfo struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  TunnelServer_getServerInfo_Params
	Results TunnelServer_getServerInfo_Results
}

// TunnelServer_unregisterTunnel holds the arguments for a server call to TunnelServer.unregisterTunnel.
type TunnelServer_unregisterTunnel struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  TunnelServer_unregisterTunnel_Params
	Results TunnelServer_unregisterTunnel_Results
}

// TunnelServer_obsoleteDeclarativeTunnelConnect holds the arguments for a server call to TunnelServer.obsoleteDeclarativeTunnelConnect.
type TunnelServer_obsoleteDeclarativeTunnelConnect struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  TunnelServer_obsoleteDeclarativeTunnelConnect_Params
	Results TunnelServer_obsoleteDeclarativeTunnelConnect_Results
}

// TunnelServer_authenticate holds the arguments for a server call to TunnelServer.authenticate.
type TunnelServer_authenticate struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  TunnelServer_authenticate_Params
	Results TunnelServer_authenticate_Results
}

// TunnelServer_reconnectTunnel holds the arguments for a server call to TunnelServer.reconnectTunnel.
type TunnelServer_reconnectTunnel struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  TunnelServer_reconnectTunnel_Params
	Results TunnelServer_reconnectTunnel_Results
}

type TunnelServer_registerTunnel_Params struct{ capnp.Struct }

// TunnelServer_registerTunnel_Params_TypeID is the unique identifier for the type TunnelServer_registerTunnel_Params.
const TunnelServer_registerTunnel_Params_TypeID = 0xb70431c0dc014915

func NewTunnelServer_registerTunnel_Params(s *capnp.Segment) (TunnelServer_registerTunnel_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3})
	return TunnelServer_registerTunnel_Params{st}, err
}

func NewRootTunnelServer_registerTunnel_Params(s *capnp.Segment) (TunnelServer_registerTunnel_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3})
	return TunnelServer_registerTunnel_Params{st}, err
}

func ReadRootTunnelServer_registerTunnel_Params(msg *capnp.Message) (TunnelServer_registerTunnel_Params, error) {
	root, err := msg.RootPtr()
	return TunnelServer_registerTunnel_Params{root.Struct()}, err
}

func (s TunnelServer_registerTunnel_Params) String() string {
	str, _ := text.Marshal(0xb70431c0dc014915, s.Struct)
	return str
}

func (s TunnelServer_registerTunnel_Params) OriginCert() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return []byte(p.Data()), err
}

func (s TunnelServer_registerTunnel_Params) HasOriginCert() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s TunnelServer_registerTunnel_Params) SetOriginCert(v []byte) error {
	return s.Struct.SetData(0, v)
}

func (s TunnelServer_registerTunnel_Params) Hostname() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s TunnelServer_registerTunnel_Params) HasHostname() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s TunnelServer_registerTunnel_Params) HostnameBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s TunnelServer_registerTunnel_Params) SetHostname(v string) error {
	return s.Struct.SetText(1, v)
}

func (s TunnelServer_registerTunnel_Params) Options() (RegistrationOptions, error) {
	p, err := s.Struct.Ptr(2)
	return RegistrationOptions{Struct: p.Struct()}, err
}

func (s TunnelServer_registerTunnel_Params) HasOptions() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s TunnelServer_registerTunnel_Params) SetOptions(v RegistrationOptions) error {
	return s.Struct.SetPtr(2, v.Struct.ToPtr())
}

// NewOptions sets the options field to a newly
// allocated RegistrationOptions struct, preferring placement in s's segment.
func (s TunnelServer_registerTunnel_Params) NewOptions() (RegistrationOptions, error) {
	ss, err := NewRegistrationOptions(s.Struct.Segment())
	if err != nil {
		return RegistrationOptions{}, err
	}
	err = s.Struct.SetPtr(2, ss.Struct.ToPtr())
	return ss, err
}

// TunnelServer_registerTunnel_Params_List is a list of TunnelServer_registerTunnel_Params.
type TunnelServer_registerTunnel_Params_List struct{ capnp.List }

// NewTunnelServer_registerTunnel_Params creates a new list of TunnelServer_registerTunnel_Params.
func NewTunnelServer_registerTunnel_Params_List(s *capnp.Segment, sz int32) (TunnelServer_registerTunnel_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3}, sz)
	return TunnelServer_registerTunnel_Params_List{l}, err
}

func (s TunnelServer_registerTunnel_Params_List) At(i int) TunnelServer_registerTunnel_Params {
	return TunnelServer_registerTunnel_Params{s.List.Struct(i)}
}

func (s TunnelServer_registerTunnel_Params_List) Set(i int, v TunnelServer_registerTunnel_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_registerTunnel_Params_List) String() string {
	str, _ := text.MarshalList(0xb70431c0dc014915, s.List)
	return str
}

// TunnelServer_registerTunnel_Params_Promise is a wrapper for a TunnelServer_registerTunnel_Params promised by a client call.
type TunnelServer_registerTunnel_Params_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_registerTunnel_Params_Promise) Struct() (TunnelServer_registerTunnel_Params, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_registerTunnel_Params{s}, err
}

func (p TunnelServer_registerTunnel_Params_Promise) Options() RegistrationOptions_Promise {
	return RegistrationOptions_Promise{Pipeline: p.Pipeline.GetPipeline(2)}
}

type TunnelServer_registerTunnel_Results struct{ capnp.Struct }

// TunnelServer_registerTunnel_Results_TypeID is the unique identifier for the type TunnelServer_registerTunnel_Results.
const TunnelServer_registerTunnel_Results_TypeID = 0xf2c122394f447e8e

func NewTunnelServer_registerTunnel_Results(s *capnp.Segment) (TunnelServer_registerTunnel_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return TunnelServer_registerTunnel_Results{st}, err
}

func NewRootTunnelServer_registerTunnel_Results(s *capnp.Segment) (TunnelServer_registerTunnel_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return TunnelServer_registerTunnel_Results{st}, err
}

func ReadRootTunnelServer_registerTunnel_Results(msg *capnp.Message) (TunnelServer_registerTunnel_Results, error) {
	root, err := msg.RootPtr()
	return TunnelServer_registerTunnel_Results{root.Struct()}, err
}

func (s TunnelServer_registerTunnel_Results) String() string {
	str, _ := text.Marshal(0xf2c122394f447e8e, s.Struct)
	return str
}

func (s TunnelServer_registerTunnel_Results) Result() (TunnelRegistration, error) {
	p, err := s.Struct.Ptr(0)
	return TunnelRegistration{Struct: p.Struct()}, err
}

func (s TunnelServer_registerTunnel_Results) HasResult() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s TunnelServer_registerTunnel_Results) SetResult(v TunnelRegistration) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewResult sets the result field to a newly
// allocated TunnelRegistration struct, preferring placement in s's segment.
func (s TunnelServer_registerTunnel_Results) NewResult() (TunnelRegistration, error) {
	ss, err := NewTunnelRegistration(s.Struct.Segment())
	if err != nil {
		return TunnelRegistration{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// TunnelServer_registerTunnel_Results_List is a list of TunnelServer_registerTunnel_Results.
type TunnelServer_registerTunnel_Results_List struct{ capnp.List }

// NewTunnelServer_registerTunnel_Results creates a new list of TunnelServer_registerTunnel_Results.
func NewTunnelServer_registerTunnel_Results_List(s *capnp.Segment, sz int32) (TunnelServer_registerTunnel_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return TunnelServer_registerTunnel_Results_List{l}, err
}

func (s TunnelServer_registerTunnel_Results_List) At(i int) TunnelServer_registerTunnel_Results {
	return TunnelServer_registerTunnel_Results{s.List.Struct(i)}
}

func (s TunnelServer_registerTunnel_Results_List) Set(i int, v TunnelServer_registerTunnel_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_registerTunnel_Results_List) String() string {
	str, _ := text.MarshalList(0xf2c122394f447e8e, s.List)
	return str
}

// TunnelServer_registerTunnel_Results_Promise is a wrapper for a TunnelServer_registerTunnel_Results promised by a client call.
type TunnelServer_registerTunnel_Results_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_registerTunnel_Results_Promise) Struct() (TunnelServer_registerTunnel_Results, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_registerTunnel_Results{s}, err
}

func (p TunnelServer_registerTunnel_Results_Promise) Result() TunnelRegistration_Promise {
	return TunnelRegistration_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type TunnelServer_getServerInfo_Params struct{ capnp.Struct }

// TunnelServer_getServerInfo_Params_TypeID is the unique identifier for the type TunnelServer_getServerInfo_Params.
const TunnelServer_getServerInfo_Params_TypeID = 0xdc3ed6801961e502

func NewTunnelServer_getServerInfo_Params(s *capnp.Segment) (TunnelServer_getServerInfo_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return TunnelServer_getServerInfo_Params{st}, err
}

func NewRootTunnelServer_getServerInfo_Params(s *capnp.Segment) (TunnelServer_getServerInfo_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return TunnelServer_getServerInfo_Params{st}, err
}

func ReadRootTunnelServer_getServerInfo_Params(msg *capnp.Message) (TunnelServer_getServerInfo_Params, error) {
	root, err := msg.RootPtr()
	return TunnelServer_getServerInfo_Params{root.Struct()}, err
}

func (s TunnelServer_getServerInfo_Params) String() string {
	str, _ := text.Marshal(0xdc3ed6801961e502, s.Struct)
	return str
}

// TunnelServer_getServerInfo_Params_List is a list of TunnelServer_getServerInfo_Params.
type TunnelServer_getServerInfo_Params_List struct{ capnp.List }

// NewTunnelServer_getServerInfo_Params creates a new list of TunnelServer_getServerInfo_Params.
func NewTunnelServer_getServerInfo_Params_List(s *capnp.Segment, sz int32) (TunnelServer_getServerInfo_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0}, sz)
	return TunnelServer_getServerInfo_Params_List{l}, err
}

func (s TunnelServer_getServerInfo_Params_List) At(i int) TunnelServer_getServerInfo_Params {
	return TunnelServer_getServerInfo_Params{s.List.Struct(i)}
}

func (s TunnelServer_getServerInfo_Params_List) Set(i int, v TunnelServer_getServerInfo_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_getServerInfo_Params_List) String() string {
	str, _ := text.MarshalList(0xdc3ed6801961e502, s.List)
	return str
}

// TunnelServer_getServerInfo_Params_Promise is a wrapper for a TunnelServer_getServerInfo_Params promised by a client call.
type TunnelServer_getServerInfo_Params_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_getServerInfo_Params_Promise) Struct() (TunnelServer_getServerInfo_Params, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_getServerInfo_Params{s}, err
}

type TunnelServer_getServerInfo_Results struct{ capnp.Struct }

// TunnelServer_getServerInfo_Results_TypeID is the unique identifier for the type TunnelServer_getServerInfo_Results.
const TunnelServer_getServerInfo_Results_TypeID = 0xe3e37d096a5b564e

func NewTunnelServer_getServerInfo_Results(s *capnp.Segment) (TunnelServer_getServerInfo_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return TunnelServer_getServerInfo_Results{st}, err
}

func NewRootTunnelServer_getServerInfo_Results(s *capnp.Segment) (TunnelServer_getServerInfo_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return TunnelServer_getServerInfo_Results{st}, err
}

func ReadRootTunnelServer_getServerInfo_Results(msg *capnp.Message) (TunnelServer_getServerInfo_Results, error) {
	root, err := msg.RootPtr()
	return TunnelServer_getServerInfo_Results{root.Struct()}, err
}

func (s TunnelServer_getServerInfo_Results) String() string {
	str, _ := text.Marshal(0xe3e37d096a5b564e, s.Struct)
	return str
}

func (s TunnelServer_getServerInfo_Results) Result() (ServerInfo, error) {
	p, err := s.Struct.Ptr(0)
	return ServerInfo{Struct: p.Struct()}, err
}

func (s TunnelServer_getServerInfo_Results) HasResult() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s TunnelServer_getServerInfo_Results) SetResult(v ServerInfo) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewResult sets the result field to a newly
// allocated ServerInfo struct, preferring placement in s's segment.
func (s TunnelServer_getServerInfo_Results) NewResult() (ServerInfo, error) {
	ss, err := NewServerInfo(s.Struct.Segment())
	if err != nil {
		return ServerInfo{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// TunnelServer_getServerInfo_Results_List is a list of TunnelServer_getServerInfo_Results.
type TunnelServer_getServerInfo_Results_List struct{ capnp.List }

// NewTunnelServer_getServerInfo_Results creates a new list of TunnelServer_getServerInfo_Results.
func NewTunnelServer_getServerInfo_Results_List(s *capnp.Segment, sz int32) (TunnelServer_getServerInfo_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return TunnelServer_getServerInfo_Results_List{l}, err
}

func (s TunnelServer_getServerInfo_Results_List) At(i int) TunnelServer_getServerInfo_Results {
	return TunnelServer_getServerInfo_Results{s.List.Struct(i)}
}

func (s TunnelServer_getServerInfo_Results_List) Set(i int, v TunnelServer_getServerInfo_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_getServerInfo_Results_List) String() string {
	str, _ := text.MarshalList(0xe3e37d096a5b564e, s.List)
	return str
}

// TunnelServer_getServerInfo_Results_Promise is a wrapper for a TunnelServer_getServerInfo_Results promised by a client call.
type TunnelServer_getServerInfo_Results_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_getServerInfo_Results_Promise) Struct() (TunnelServer_getServerInfo_Results, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_getServerInfo_Results{s}, err
}

func (p TunnelServer_getServerInfo_Results_Promise) Result() ServerInfo_Promise {
	return ServerInfo_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type TunnelServer_unregisterTunnel_Params struct{ capnp.Struct }

// TunnelServer_unregisterTunnel_Params_TypeID is the unique identifier for the type TunnelServer_unregisterTunnel_Params.
const TunnelServer_unregisterTunnel_Params_TypeID = 0x9b87b390babc2ccf

func NewTunnelServer_unregisterTunnel_Params(s *capnp.Segment) (TunnelServer_unregisterTunnel_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0})
	return TunnelServer_unregisterTunnel_Params{st}, err
}

func NewRootTunnelServer_unregisterTunnel_Params(s *capnp.Segment) (TunnelServer_unregisterTunnel_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0})
	return TunnelServer_unregisterTunnel_Params{st}, err
}

func ReadRootTunnelServer_unregisterTunnel_Params(msg *capnp.Message) (TunnelServer_unregisterTunnel_Params, error) {
	root, err := msg.RootPtr()
	return TunnelServer_unregisterTunnel_Params{root.Struct()}, err
}

func (s TunnelServer_unregisterTunnel_Params) String() string {
	str, _ := text.Marshal(0x9b87b390babc2ccf, s.Struct)
	return str
}

func (s TunnelServer_unregisterTunnel_Params) GracePeriodNanoSec() int64 {
	return int64(s.Struct.Uint64(0))
}

func (s TunnelServer_unregisterTunnel_Params) SetGracePeriodNanoSec(v int64) {
	s.Struct.SetUint64(0, uint64(v))
}

// TunnelServer_unregisterTunnel_Params_List is a list of TunnelServer_unregisterTunnel_Params.
type TunnelServer_unregisterTunnel_Params_List struct{ capnp.List }

// NewTunnelServer_unregisterTunnel_Params creates a new list of TunnelServer_unregisterTunnel_Params.
func NewTunnelServer_unregisterTunnel_Params_List(s *capnp.Segment, sz int32) (TunnelServer_unregisterTunnel_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0}, sz)
	return TunnelServer_unregisterTunnel_Params_List{l}, err
}

func (s TunnelServer_unregisterTunnel_Params_List) At(i int) TunnelServer_unregisterTunnel_Params {
	return TunnelServer_unregisterTunnel_Params{s.List.Struct(i)}
}

func (s TunnelServer_unregisterTunnel_Params_List) Set(i int, v TunnelServer_unregisterTunnel_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_unregisterTunnel_Params_List) String() string {
	str, _ := text.MarshalList(0x9b87b390babc2ccf, s.List)
	return str
}

// TunnelServer_unregisterTunnel_Params_Promise is a wrapper for a TunnelServer_unregisterTunnel_Params promised by a client call.
type TunnelServer_unregisterTunnel_Params_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_unregisterTunnel_Params_Promise) Struct() (TunnelServer_unregisterTunnel_Params, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_unregisterTunnel_Params{s}, err
}

type TunnelServer_unregisterTunnel_Results struct{ capnp.Struct }

// TunnelServer_unregisterTunnel_Results_TypeID is the unique identifier for the type TunnelServer_unregisterTunnel_Results.
const TunnelServer_unregisterTunnel_Results_TypeID = 0xa29a916d4ebdd894

func NewTunnelServer_unregisterTunnel_Results(s *capnp.Segment) (TunnelServer_unregisterTunnel_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return TunnelServer_unregisterTunnel_Results{st}, err
}

func NewRootTunnelServer_unregisterTunnel_Results(s *capnp.Segment) (TunnelServer_unregisterTunnel_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return TunnelServer_unregisterTunnel_Results{st}, err
}

func ReadRootTunnelServer_unregisterTunnel_Results(msg *capnp.Message) (TunnelServer_unregisterTunnel_Results, error) {
	root, err := msg.RootPtr()
	return TunnelServer_unregisterTunnel_Results{root.Struct()}, err
}

func (s TunnelServer_unregisterTunnel_Results) String() string {
	str, _ := text.Marshal(0xa29a916d4ebdd894, s.Struct)
	return str
}

// TunnelServer_unregisterTunnel_Results_List is a list of TunnelServer_unregisterTunnel_Results.
type TunnelServer_unregisterTunnel_Results_List struct{ capnp.List }

// NewTunnelServer_unregisterTunnel_Results creates a new list of TunnelServer_unregisterTunnel_Results.
func NewTunnelServer_unregisterTunnel_Results_List(s *capnp.Segment, sz int32) (TunnelServer_unregisterTunnel_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0}, sz)
	return TunnelServer_unregisterTunnel_Results_List{l}, err
}

func (s TunnelServer_unregisterTunnel_Results_List) At(i int) TunnelServer_unregisterTunnel_Results {
	return TunnelServer_unregisterTunnel_Results{s.List.Struct(i)}
}

func (s TunnelServer_unregisterTunnel_Results_List) Set(i int, v TunnelServer_unregisterTunnel_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_unregisterTunnel_Results_List) String() string {
	str, _ := text.MarshalList(0xa29a916d4ebdd894, s.List)
	return str
}

// TunnelServer_unregisterTunnel_Results_Promise is a wrapper for a TunnelServer_unregisterTunnel_Results promised by a client call.
type TunnelServer_unregisterTunnel_Results_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_unregisterTunnel_Results_Promise) Struct() (TunnelServer_unregisterTunnel_Results, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_unregisterTunnel_Results{s}, err
}

type TunnelServer_obsoleteDeclarativeTunnelConnect_Params struct{ capnp.Struct }

// TunnelServer_obsoleteDeclarativeTunnelConnect_Params_TypeID is the unique identifier for the type TunnelServer_obsoleteDeclarativeTunnelConnect_Params.
const TunnelServer_obsoleteDeclarativeTunnelConnect_Params_TypeID = 0xa766b24d4fe5da35

func NewTunnelServer_obsoleteDeclarativeTunnelConnect_Params(s *capnp.Segment) (TunnelServer_obsoleteDeclarativeTunnelConnect_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Params{st}, err
}

func NewRootTunnelServer_obsoleteDeclarativeTunnelConnect_Params(s *capnp.Segment) (TunnelServer_obsoleteDeclarativeTunnelConnect_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Params{st}, err
}

func ReadRootTunnelServer_obsoleteDeclarativeTunnelConnect_Params(msg *capnp.Message) (TunnelServer_obsoleteDeclarativeTunnelConnect_Params, error) {
	root, err := msg.RootPtr()
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Params{root.Struct()}, err
}

func (s TunnelServer_obsoleteDeclarativeTunnelConnect_Params) String() string {
	str, _ := text.Marshal(0xa766b24d4fe5da35, s.Struct)
	return str
}

// TunnelServer_obsoleteDeclarativeTunnelConnect_Params_List is a list of TunnelServer_obsoleteDeclarativeTunnelConnect_Params.
type TunnelServer_obsoleteDeclarativeTunnelConnect_Params_List struct{ capnp.List }

// NewTunnelServer_obsoleteDeclarativeTunnelConnect_Params creates a new list of TunnelServer_obsoleteDeclarativeTunnelConnect_Params.
func NewTunnelServer_obsoleteDeclarativeTunnelConnect_Params_List(s *capnp.Segment, sz int32) (TunnelServer_obsoleteDeclarativeTunnelConnect_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0}, sz)
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Params_List{l}, err
}

func (s TunnelServer_obsoleteDeclarativeTunnelConnect_Params_List) At(i int) TunnelServer_obsoleteDeclarativeTunnelConnect_Params {
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Params{s.List.Struct(i)}
}

func (s TunnelServer_obsoleteDeclarativeTunnelConnect_Params_List) Set(i int, v TunnelServer_obsoleteDeclarativeTunnelConnect_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_obsoleteDeclarativeTunnelConnect_Params_List) String() string {
	str, _ := text.MarshalList(0xa766b24d4fe5da35, s.List)
	return str
}

// TunnelServer_obsoleteDeclarativeTunnelConnect_Params_Promise is a wrapper for a TunnelServer_obsoleteDeclarativeTunnelConnect_Params promised by a client call.
type TunnelServer_obsoleteDeclarativeTunnelConnect_Params_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_obsoleteDeclarativeTunnelConnect_Params_Promise) Struct() (TunnelServer_obsoleteDeclarativeTunnelConnect_Params, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Params{s}, err
}

type TunnelServer_obsoleteDeclarativeTunnelConnect_Results struct{ capnp.Struct }

// TunnelServer_obsoleteDeclarativeTunnelConnect_Results_TypeID is the unique identifier for the type TunnelServer_obsoleteDeclarativeTunnelConnect_Results.
const TunnelServer_obsoleteDeclarativeTunnelConnect_Results_TypeID = 0xfeac5c8f4899ef7c

func NewTunnelServer_obsoleteDeclarativeTunnelConnect_Results(s *capnp.Segment) (TunnelServer_obsoleteDeclarativeTunnelConnect_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Results{st}, err
}

func NewRootTunnelServer_obsoleteDeclarativeTunnelConnect_Results(s *capnp.Segment) (TunnelServer_obsoleteDeclarativeTunnelConnect_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Results{st}, err
}

func ReadRootTunnelServer_obsoleteDeclarativeTunnelConnect_Results(msg *capnp.Message) (TunnelServer_obsoleteDeclarativeTunnelConnect_Results, error) {
	root, err := msg.RootPtr()
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Results{root.Struct()}, err
}

func (s TunnelServer_obsoleteDeclarativeTunnelConnect_Results) String() string {
	str, _ := text.Marshal(0xfeac5c8f4899ef7c, s.Struct)
	return str
}

// TunnelServer_obsoleteDeclarativeTunnelConnect_Results_List is a list of TunnelServer_obsoleteDeclarativeTunnelConnect_Results.
type TunnelServer_obsoleteDeclarativeTunnelConnect_Results_List struct{ capnp.List }

// NewTunnelServer_obsoleteDeclarativeTunnelConnect_Results creates a new list of TunnelServer_obsoleteDeclarativeTunnelConnect_Results.
func NewTunnelServer_obsoleteDeclarativeTunnelConnect_Results_List(s *capnp.Segment, sz int32) (TunnelServer_obsoleteDeclarativeTunnelConnect_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0}, sz)
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Results_List{l}, err
}

func (s TunnelServer_obsoleteDeclarativeTunnelConnect_Results_List) At(i int) TunnelServer_obsoleteDeclarativeTunnelConnect_Results {
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Results{s.List.Struct(i)}
}

func (s TunnelServer_obsoleteDeclarativeTunnelConnect_Results_List) Set(i int, v TunnelServer_obsoleteDeclarativeTunnelConnect_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_obsoleteDeclarativeTunnelConnect_Results_List) String() string {
	str, _ := text.MarshalList(0xfeac5c8f4899ef7c, s.List)
	return str
}

// TunnelServer_obsoleteDeclarativeTunnelConnect_Results_Promise is a wrapper for a TunnelServer_obsoleteDeclarativeTunnelConnect_Results promised by a client call.
type TunnelServer_obsoleteDeclarativeTunnelConnect_Results_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_obsoleteDeclarativeTunnelConnect_Results_Promise) Struct() (TunnelServer_obsoleteDeclarativeTunnelConnect_Results, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_obsoleteDeclarativeTunnelConnect_Results{s}, err
}

type TunnelServer_authenticate_Params struct{ capnp.Struct }

// TunnelServer_authenticate_Params_TypeID is the unique identifier for the type TunnelServer_authenticate_Params.
const TunnelServer_authenticate_Params_TypeID = 0x85c8cea1ab1894f3

func NewTunnelServer_authenticate_Params(s *capnp.Segment) (TunnelServer_authenticate_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3})
	return TunnelServer_authenticate_Params{st}, err
}

func NewRootTunnelServer_authenticate_Params(s *capnp.Segment) (TunnelServer_authenticate_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3})
	return TunnelServer_authenticate_Params{st}, err
}

func ReadRootTunnelServer_authenticate_Params(msg *capnp.Message) (TunnelServer_authenticate_Params, error) {
	root, err := msg.RootPtr()
	return TunnelServer_authenticate_Params{root.Struct()}, err
}

func (s TunnelServer_authenticate_Params) String() string {
	str, _ := text.Marshal(0x85c8cea1ab1894f3, s.Struct)
	return str
}

func (s TunnelServer_authenticate_Params) OriginCert() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return []byte(p.Data()), err
}

func (s TunnelServer_authenticate_Params) HasOriginCert() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s TunnelServer_authenticate_Params) SetOriginCert(v []byte) error {
	return s.Struct.SetData(0, v)
}

func (s TunnelServer_authenticate_Params) Hostname() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s TunnelServer_authenticate_Params) HasHostname() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s TunnelServer_authenticate_Params) HostnameBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s TunnelServer_authenticate_Params) SetHostname(v string) error {
	return s.Struct.SetText(1, v)
}

func (s TunnelServer_authenticate_Params) Options() (RegistrationOptions, error) {
	p, err := s.Struct.Ptr(2)
	return RegistrationOptions{Struct: p.Struct()}, err
}

func (s TunnelServer_authenticate_Params) HasOptions() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s TunnelServer_authenticate_Params) SetOptions(v RegistrationOptions) error {
	return s.Struct.SetPtr(2, v.Struct.ToPtr())
}

// NewOptions sets the options field to a newly
// allocated RegistrationOptions struct, preferring placement in s's segment.
func (s TunnelServer_authenticate_Params) NewOptions() (RegistrationOptions, error) {
	ss, err := NewRegistrationOptions(s.Struct.Segment())
	if err != nil {
		return RegistrationOptions{}, err
	}
	err = s.Struct.SetPtr(2, ss.Struct.ToPtr())
	return ss, err
}

// TunnelServer_authenticate_Params_List is a list of TunnelServer_authenticate_Params.
type TunnelServer_authenticate_Params_List struct{ capnp.List }

// NewTunnelServer_authenticate_Params creates a new list of TunnelServer_authenticate_Params.
func NewTunnelServer_authenticate_Params_List(s *capnp.Segment, sz int32) (TunnelServer_authenticate_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3}, sz)
	return TunnelServer_authenticate_Params_List{l}, err
}

func (s TunnelServer_authenticate_Params_List) At(i int) TunnelServer_authenticate_Params {
	return TunnelServer_authenticate_Params{s.List.Struct(i)}
}

func (s TunnelServer_authenticate_Params_List) Set(i int, v TunnelServer_authenticate_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_authenticate_Params_List) String() string {
	str, _ := text.MarshalList(0x85c8cea1ab1894f3, s.List)
	return str
}

// TunnelServer_authenticate_Params_Promise is a wrapper for a TunnelServer_authenticate_Params promised by a client call.
type TunnelServer_authenticate_Params_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_authenticate_Params_Promise) Struct() (TunnelServer_authenticate_Params, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_authenticate_Params{s}, err
}

func (p TunnelServer_authenticate_Params_Promise) Options() RegistrationOptions_Promise {
	return RegistrationOptions_Promise{Pipeline: p.Pipeline.GetPipeline(2)}
}

type TunnelServer_authenticate_Results struct{ capnp.Struct }

// TunnelServer_authenticate_Results_TypeID is the unique identifier for the type TunnelServer_authenticate_Results.
const TunnelServer_authenticate_Results_TypeID = 0xfc5edf80e39c0796

func NewTunnelServer_authenticate_Results(s *capnp.Segment) (TunnelServer_authenticate_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return TunnelServer_authenticate_Results{st}, err
}

func NewRootTunnelServer_authenticate_Results(s *capnp.Segment) (TunnelServer_authenticate_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return TunnelServer_authenticate_Results{st}, err
}

func ReadRootTunnelServer_authenticate_Results(msg *capnp.Message) (TunnelServer_authenticate_Results, error) {
	root, err := msg.RootPtr()
	return TunnelServer_authenticate_Results{root.Struct()}, err
}

func (s TunnelServer_authenticate_Results) String() string {
	str, _ := text.Marshal(0xfc5edf80e39c0796, s.Struct)
	return str
}

func (s TunnelServer_authenticate_Results) Result() (AuthenticateResponse, error) {
	p, err := s.Struct.Ptr(0)
	return AuthenticateResponse{Struct: p.Struct()}, err
}

func (s TunnelServer_authenticate_Results) HasResult() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s TunnelServer_authenticate_Results) SetResult(v AuthenticateResponse) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewResult sets the result field to a newly
// allocated AuthenticateResponse struct, preferring placement in s's segment.
func (s TunnelServer_authenticate_Results) NewResult() (AuthenticateResponse, error) {
	ss, err := NewAuthenticateResponse(s.Struct.Segment())
	if err != nil {
		return AuthenticateResponse{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// TunnelServer_authenticate_Results_List is a list of TunnelServer_authenticate_Results.
type TunnelServer_authenticate_Results_List struct{ capnp.List }

// NewTunnelServer_authenticate_Results creates a new list of TunnelServer_authenticate_Results.
func NewTunnelServer_authenticate_Results_List(s *capnp.Segment, sz int32) (TunnelServer_authenticate_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return TunnelServer_authenticate_Results_List{l}, err
}

func (s TunnelServer_authenticate_Results_List) At(i int) TunnelServer_authenticate_Results {
	return TunnelServer_authenticate_Results{s.List.Struct(i)}
}

func (s TunnelServer_authenticate_Results_List) Set(i int, v TunnelServer_authenticate_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_authenticate_Results_List) String() string {
	str, _ := text.MarshalList(0xfc5edf80e39c0796, s.List)
	return str
}

// TunnelServer_authenticate_Results_Promise is a wrapper for a TunnelServer_authenticate_Results promised by a client call.
type TunnelServer_authenticate_Results_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_authenticate_Results_Promise) Struct() (TunnelServer_authenticate_Results, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_authenticate_Results{s}, err
}

func (p TunnelServer_authenticate_Results_Promise) Result() AuthenticateResponse_Promise {
	return AuthenticateResponse_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type TunnelServer_reconnectTunnel_Params struct{ capnp.Struct }

// TunnelServer_reconnectTunnel_Params_TypeID is the unique identifier for the type TunnelServer_reconnectTunnel_Params.
const TunnelServer_reconnectTunnel_Params_TypeID = 0xa353a3556df74984

func NewTunnelServer_reconnectTunnel_Params(s *capnp.Segment) (TunnelServer_reconnectTunnel_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 5})
	return TunnelServer_reconnectTunnel_Params{st}, err
}

func NewRootTunnelServer_reconnectTunnel_Params(s *capnp.Segment) (TunnelServer_reconnectTunnel_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 5})
	return TunnelServer_reconnectTunnel_Params{st}, err
}

func ReadRootTunnelServer_reconnectTunnel_Params(msg *capnp.Message) (TunnelServer_reconnectTunnel_Params, error) {
	root, err := msg.RootPtr()
	return TunnelServer_reconnectTunnel_Params{root.Struct()}, err
}

func (s TunnelServer_reconnectTunnel_Params) String() string {
	str, _ := text.Marshal(0xa353a3556df74984, s.Struct)
	return str
}

func (s TunnelServer_reconnectTunnel_Params) Jwt() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return []byte(p.Data()), err
}

func (s TunnelServer_reconnectTunnel_Params) HasJwt() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s TunnelServer_reconnectTunnel_Params) SetJwt(v []byte) error {
	return s.Struct.SetData(0, v)
}

func (s TunnelServer_reconnectTunnel_Params) EventDigest() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return []byte(p.Data()), err
}

func (s TunnelServer_reconnectTunnel_Params) HasEventDigest() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s TunnelServer_reconnectTunnel_Params) SetEventDigest(v []byte) error {
	return s.Struct.SetData(1, v)
}

func (s TunnelServer_reconnectTunnel_Params) ConnDigest() ([]byte, error) {
	p, err := s.Struct.Ptr(2)
	return []byte(p.Data()), err
}

func (s TunnelServer_reconnectTunnel_Params) HasConnDigest() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s TunnelServer_reconnectTunnel_Params) SetConnDigest(v []byte) error {
	return s.Struct.SetData(2, v)
}

func (s TunnelServer_reconnectTunnel_Params) Hostname() (string, error) {
	p, err := s.Struct.Ptr(3)
	return p.Text(), err
}

func (s TunnelServer_reconnectTunnel_Params) HasHostname() bool {
	p, err := s.Struct.Ptr(3)
	return p.IsValid() || err != nil
}

func (s TunnelServer_reconnectTunnel_Params) HostnameBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(3)
	return p.TextBytes(), err
}

func (s TunnelServer_reconnectTunnel_Params) SetHostname(v string) error {
	return s.Struct.SetText(3, v)
}

func (s TunnelServer_reconnectTunnel_Params) Options() (RegistrationOptions, error) {
	p, err := s.Struct.Ptr(4)
	return RegistrationOptions{Struct: p.Struct()}, err
}

func (s TunnelServer_reconnectTunnel_Params) HasOptions() bool {
	p, err := s.Struct.Ptr(4)
	return p.IsValid() || err != nil
}

func (s TunnelServer_reconnectTunnel_Params) SetOptions(v RegistrationOptions) error {
	return s.Struct.SetPtr(4, v.Struct.ToPtr())
}

// NewOptions sets the options field to a newly
// allocated RegistrationOptions struct, preferring placement in s's segment.
func (s TunnelServer_reconnectTunnel_Params) NewOptions() (RegistrationOptions, error) {
	ss, err := NewRegistrationOptions(s.Struct.Segment())
	if err != nil {
		return RegistrationOptions{}, err
	}
	err = s.Struct.SetPtr(4, ss.Struct.ToPtr())
	return ss, err
}

// TunnelServer_reconnectTunnel_Params_List is a list of TunnelServer_reconnectTunnel_Params.
type TunnelServer_reconnectTunnel_Params_List struct{ capnp.List }

// NewTunnelServer_reconnectTunnel_Params creates a new list of TunnelServer_reconnectTunnel_Params.
func NewTunnelServer_reconnectTunnel_Params_List(s *capnp.Segment, sz int32) (TunnelServer_reconnectTunnel_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 5}, sz)
	return TunnelServer_reconnectTunnel_Params_List{l}, err
}

func (s TunnelServer_reconnectTunnel_Params_List) At(i int) TunnelServer_reconnectTunnel_Params {
	return TunnelServer_reconnectTunnel_Params{s.List.Struct(i)}
}

func (s TunnelServer_reconnectTunnel_Params_List) Set(i int, v TunnelServer_reconnectTunnel_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_reconnectTunnel_Params_List) String() string {
	str, _ := text.MarshalList(0xa353a3556df74984, s.List)
	return str
}

// TunnelServer_reconnectTunnel_Params_Promise is a wrapper for a TunnelServer_reconnectTunnel_Params promised by a client call.
type TunnelServer_reconnectTunnel_Params_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_reconnectTunnel_Params_Promise) Struct() (TunnelServer_reconnectTunnel_Params, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_reconnectTunnel_Params{s}, err
}

func (p TunnelServer_reconnectTunnel_Params_Promise) Options() RegistrationOptions_Promise {
	return RegistrationOptions_Promise{Pipeline: p.Pipeline.GetPipeline(4)}
}

type TunnelServer_reconnectTunnel_Results struct{ capnp.Struct }

// TunnelServer_reconnectTunnel_Results_TypeID is the unique identifier for the type TunnelServer_reconnectTunnel_Results.
const TunnelServer_reconnectTunnel_Results_TypeID = 0xd4d18de97bb12de3

func NewTunnelServer_reconnectTunnel_Results(s *capnp.Segment) (TunnelServer_reconnectTunnel_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return TunnelServer_reconnectTunnel_Results{st}, err
}

func NewRootTunnelServer_reconnectTunnel_Results(s *capnp.Segment) (TunnelServer_reconnectTunnel_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return TunnelServer_reconnectTunnel_Results{st}, err
}

func ReadRootTunnelServer_reconnectTunnel_Results(msg *capnp.Message) (TunnelServer_reconnectTunnel_Results, error) {
	root, err := msg.RootPtr()
	return TunnelServer_reconnectTunnel_Results{root.Struct()}, err
}

func (s TunnelServer_reconnectTunnel_Results) String() string {
	str, _ := text.Marshal(0xd4d18de97bb12de3, s.Struct)
	return str
}

func (s TunnelServer_reconnectTunnel_Results) Result() (TunnelRegistration, error) {
	p, err := s.Struct.Ptr(0)
	return TunnelRegistration{Struct: p.Struct()}, err
}

func (s TunnelServer_reconnectTunnel_Results) HasResult() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s TunnelServer_reconnectTunnel_Results) SetResult(v TunnelRegistration) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewResult sets the result field to a newly
// allocated TunnelRegistration struct, preferring placement in s's segment.
func (s TunnelServer_reconnectTunnel_Results) NewResult() (TunnelRegistration, error) {
	ss, err := NewTunnelRegistration(s.Struct.Segment())
	if err != nil {
		return TunnelRegistration{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// TunnelServer_reconnectTunnel_Results_List is a list of TunnelServer_reconnectTunnel_Results.
type TunnelServer_reconnectTunnel_Results_List struct{ capnp.List }

// NewTunnelServer_reconnectTunnel_Results creates a new list of TunnelServer_reconnectTunnel_Results.
func NewTunnelServer_reconnectTunnel_Results_List(s *capnp.Segment, sz int32) (TunnelServer_reconnectTunnel_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return TunnelServer_reconnectTunnel_Results_List{l}, err
}

func (s TunnelServer_reconnectTunnel_Results_List) At(i int) TunnelServer_reconnectTunnel_Results {
	return TunnelServer_reconnectTunnel_Results{s.List.Struct(i)}
}

func (s TunnelServer_reconnectTunnel_Results_List) Set(i int, v TunnelServer_reconnectTunnel_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s TunnelServer_reconnectTunnel_Results_List) String() string {
	str, _ := text.MarshalList(0xd4d18de97bb12de3, s.List)
	return str
}

// TunnelServer_reconnectTunnel_Results_Promise is a wrapper for a TunnelServer_reconnectTunnel_Results promised by a client call.
type TunnelServer_reconnectTunnel_Results_Promise struct{ *capnp.Pipeline }

func (p TunnelServer_reconnectTunnel_Results_Promise) Struct() (TunnelServer_reconnectTunnel_Results, error) {
	s, err := p.Pipeline.Struct()
	return TunnelServer_reconnectTunnel_Results{s}, err
}

func (p TunnelServer_reconnectTunnel_Results_Promise) Result() TunnelRegistration_Promise {
	return TunnelRegistration_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type RegisterUdpSessionResponse struct{ capnp.Struct }

// RegisterUdpSessionResponse_TypeID is the unique identifier for the type RegisterUdpSessionResponse.
const RegisterUdpSessionResponse_TypeID = 0xab6d5210c1f26687

func NewRegisterUdpSessionResponse(s *capnp.Segment) (RegisterUdpSessionResponse, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return RegisterUdpSessionResponse{st}, err
}

func NewRootRegisterUdpSessionResponse(s *capnp.Segment) (RegisterUdpSessionResponse, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return RegisterUdpSessionResponse{st}, err
}

func ReadRootRegisterUdpSessionResponse(msg *capnp.Message) (RegisterUdpSessionResponse, error) {
	root, err := msg.RootPtr()
	return RegisterUdpSessionResponse{root.Struct()}, err
}

func (s RegisterUdpSessionResponse) String() string {
	str, _ := text.Marshal(0xab6d5210c1f26687, s.Struct)
	return str
}

func (s RegisterUdpSessionResponse) Err() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s RegisterUdpSessionResponse) HasErr() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s RegisterUdpSessionResponse) ErrBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s RegisterUdpSessionResponse) SetErr(v string) error {
	return s.Struct.SetText(0, v)
}

func (s RegisterUdpSessionResponse) Spans() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return []byte(p.Data()), err
}

func (s RegisterUdpSessionResponse) HasSpans() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s RegisterUdpSessionResponse) SetSpans(v []byte) error {
	return s.Struct.SetData(1, v)
}

// RegisterUdpSessionResponse_List is a list of RegisterUdpSessionResponse.
type RegisterUdpSessionResponse_List struct{ capnp.List }

// NewRegisterUdpSessionResponse creates a new list of RegisterUdpSessionResponse.
func NewRegisterUdpSessionResponse_List(s *capnp.Segment, sz int32) (RegisterUdpSessionResponse_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2}, sz)
	return RegisterUdpSessionResponse_List{l}, err
}

func (s RegisterUdpSessionResponse_List) At(i int) RegisterUdpSessionResponse {
	return RegisterUdpSessionResponse{s.List.Struct(i)}
}

func (s RegisterUdpSessionResponse_List) Set(i int, v RegisterUdpSessionResponse) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s RegisterUdpSessionResponse_List) String() string {
	str, _ := text.MarshalList(0xab6d5210c1f26687, s.List)
	return str
}

// RegisterUdpSessionResponse_Promise is a wrapper for a RegisterUdpSessionResponse promised by a client call.
type RegisterUdpSessionResponse_Promise struct{ *capnp.Pipeline }

func (p RegisterUdpSessionResponse_Promise) Struct() (RegisterUdpSessionResponse, error) {
	s, err := p.Pipeline.Struct()
	return RegisterUdpSessionResponse{s}, err
}

type SessionManager struct{ Client capnp.Client }

// SessionManager_TypeID is the unique identifier for the type SessionManager.
const SessionManager_TypeID = 0x839445a59fb01686

func (c SessionManager) RegisterUdpSession(ctx context.Context, params func(SessionManager_registerUdpSession_Params) error, opts ...capnp.CallOption) SessionManager_registerUdpSession_Results_Promise {
	if c.Client == nil {
		return SessionManager_registerUdpSession_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0x839445a59fb01686,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:SessionManager",
			MethodName:    "registerUdpSession",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 16, PointerCount: 3}
		call.ParamsFunc = func(s capnp.Struct) error { return params(SessionManager_registerUdpSession_Params{Struct: s}) }
	}
	return SessionManager_registerUdpSession_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c SessionManager) UnregisterUdpSession(ctx context.Context, params func(SessionManager_unregisterUdpSession_Params) error, opts ...capnp.CallOption) SessionManager_unregisterUdpSession_Results_Promise {
	if c.Client == nil {
		return SessionManager_unregisterUdpSession_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0x839445a59fb01686,
			MethodID:      1,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:SessionManager",
			MethodName:    "unregisterUdpSession",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 2}
		call.ParamsFunc = func(s capnp.Struct) error { return params(SessionManager_unregisterUdpSession_Params{Struct: s}) }
	}
	return SessionManager_unregisterUdpSession_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}

type SessionManager_Server interface {
	RegisterUdpSession(SessionManager_registerUdpSession) error

	UnregisterUdpSession(SessionManager_unregisterUdpSession) error
}

func SessionManager_ServerToClient(s SessionManager_Server) SessionManager {
	c, _ := s.(server.Closer)
	return SessionManager{Client: server.New(SessionManager_Methods(nil, s), c)}
}

func SessionManager_Methods(methods []server.Method, s SessionManager_Server) []server.Method {
	if cap(methods) == 0 {
		methods = make([]server.Method, 0, 2)
	}

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0x839445a59fb01686,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:SessionManager",
			MethodName:    "registerUdpSession",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := SessionManager_registerUdpSession{c, opts, SessionManager_registerUdpSession_Params{Struct: p}, SessionManager_registerUdpSession_Results{Struct: r}}
			return s.RegisterUdpSession(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 1},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0x839445a59fb01686,
			MethodID:      1,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:SessionManager",
			MethodName:    "unregisterUdpSession",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := SessionManager_unregisterUdpSession{c, opts, SessionManager_unregisterUdpSession_Params{Struct: p}, SessionManager_unregisterUdpSession_Results{Struct: r}}
			return s.UnregisterUdpSession(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 0},
	})

	return methods
}

// SessionManager_registerUdpSession holds the arguments for a server call to SessionManager.registerUdpSession.
type SessionManager_registerUdpSession struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  SessionManager_registerUdpSession_Params
	Results SessionManager_registerUdpSession_Results
}

// SessionManager_unregisterUdpSession holds the arguments for a server call to SessionManager.unregisterUdpSession.
type SessionManager_unregisterUdpSession struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  SessionManager_unregisterUdpSession_Params
	Results SessionManager_unregisterUdpSession_Results
}

type SessionManager_registerUdpSession_Params struct{ capnp.Struct }

// SessionManager_registerUdpSession_Params_TypeID is the unique identifier for the type SessionManager_registerUdpSession_Params.
const SessionManager_registerUdpSession_Params_TypeID = 0x904e297b87fbecea

func NewSessionManager_registerUdpSession_Params(s *capnp.Segment) (SessionManager_registerUdpSession_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 3})
	return SessionManager_registerUdpSession_Params{st}, err
}

func NewRootSessionManager_registerUdpSession_Params(s *capnp.Segment) (SessionManager_registerUdpSession_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 3})
	return SessionManager_registerUdpSession_Params{st}, err
}

func ReadRootSessionManager_registerUdpSession_Params(msg *capnp.Message) (SessionManager_registerUdpSession_Params, error) {
	root, err := msg.RootPtr()
	return SessionManager_registerUdpSession_Params{root.Struct()}, err
}

func (s SessionManager_registerUdpSession_Params) String() string {
	str, _ := text.Marshal(0x904e297b87fbecea, s.Struct)
	return str
}

func (s SessionManager_registerUdpSession_Params) SessionId() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return []byte(p.Data()), err
}

func (s SessionManager_registerUdpSession_Params) HasSessionId() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s SessionManager_registerUdpSession_Params) SetSessionId(v []byte) error {
	return s.Struct.SetData(0, v)
}

func (s SessionManager_registerUdpSession_Params) DstIp() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return []byte(p.Data()), err
}

func (s SessionManager_registerUdpSession_Params) HasDstIp() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s SessionManager_registerUdpSession_Params) SetDstIp(v []byte) error {
	return s.Struct.SetData(1, v)
}

func (s SessionManager_registerUdpSession_Params) DstPort() uint16 {
	return s.Struct.Uint16(0)
}

func (s SessionManager_registerUdpSession_Params) SetDstPort(v uint16) {
	s.Struct.SetUint16(0, v)
}

func (s SessionManager_registerUdpSession_Params) CloseAfterIdleHint() int64 {
	return int64(s.Struct.Uint64(8))
}

func (s SessionManager_registerUdpSession_Params) SetCloseAfterIdleHint(v int64) {
	s.Struct.SetUint64(8, uint64(v))
}

func (s SessionManager_registerUdpSession_Params) TraceContext() (string, error) {
	p, err := s.Struct.Ptr(2)
	return p.Text(), err
}

func (s SessionManager_registerUdpSession_Params) HasTraceContext() bool {
	p, err := s.Struct.Ptr(2)
	return p.IsValid() || err != nil
}

func (s SessionManager_registerUdpSession_Params) TraceContextBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(2)
	return p.TextBytes(), err
}

func (s SessionManager_registerUdpSession_Params) SetTraceContext(v string) error {
	return s.Struct.SetText(2, v)
}

// SessionManager_registerUdpSession_Params_List is a list of SessionManager_registerUdpSession_Params.
type SessionManager_registerUdpSession_Params_List struct{ capnp.List }

// NewSessionManager_registerUdpSession_Params creates a new list of SessionManager_registerUdpSession_Params.
func NewSessionManager_registerUdpSession_Params_List(s *capnp.Segment, sz int32) (SessionManager_registerUdpSession_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 16, PointerCount: 3}, sz)
	return SessionManager_registerUdpSession_Params_List{l}, err
}

func (s SessionManager_registerUdpSession_Params_List) At(i int) SessionManager_registerUdpSession_Params {
	return SessionManager_registerUdpSession_Params{s.List.Struct(i)}
}

func (s SessionManager_registerUdpSession_Params_List) Set(i int, v SessionManager_registerUdpSession_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s SessionManager_registerUdpSession_Params_List) String() string {
	str, _ := text.MarshalList(0x904e297b87fbecea, s.List)
	return str
}

// SessionManager_registerUdpSession_Params_Promise is a wrapper for a SessionManager_registerUdpSession_Params promised by a client call.
type SessionManager_registerUdpSession_Params_Promise struct{ *capnp.Pipeline }

func (p SessionManager_registerUdpSession_Params_Promise) Struct() (SessionManager_registerUdpSession_Params, error) {
	s, err := p.Pipeline.Struct()
	return SessionManager_registerUdpSession_Params{s}, err
}

type SessionManager_registerUdpSession_Results struct{ capnp.Struct }

// SessionManager_registerUdpSession_Results_TypeID is the unique identifier for the type SessionManager_registerUdpSession_Results.
const SessionManager_registerUdpSession_Results_TypeID = 0x8635c6b4f45bf5cd

func NewSessionManager_registerUdpSession_Results(s *capnp.Segment) (SessionManager_registerUdpSession_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return SessionManager_registerUdpSession_Results{st}, err
}

func NewRootSessionManager_registerUdpSession_Results(s *capnp.Segment) (SessionManager_registerUdpSession_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return SessionManager_registerUdpSession_Results{st}, err
}

func ReadRootSessionManager_registerUdpSession_Results(msg *capnp.Message) (SessionManager_registerUdpSession_Results, error) {
	root, err := msg.RootPtr()
	return SessionManager_registerUdpSession_Results{root.Struct()}, err
}

func (s SessionManager_registerUdpSession_Results) String() string {
	str, _ := text.Marshal(0x8635c6b4f45bf5cd, s.Struct)
	return str
}

func (s SessionManager_registerUdpSession_Results) Result() (RegisterUdpSessionResponse, error) {
	p, err := s.Struct.Ptr(0)
	return RegisterUdpSessionResponse{Struct: p.Struct()}, err
}

func (s SessionManager_registerUdpSession_Results) HasResult() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s SessionManager_registerUdpSession_Results) SetResult(v RegisterUdpSessionResponse) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewResult sets the result field to a newly
// allocated RegisterUdpSessionResponse struct, preferring placement in s's segment.
func (s SessionManager_registerUdpSession_Results) NewResult() (RegisterUdpSessionResponse, error) {
	ss, err := NewRegisterUdpSessionResponse(s.Struct.Segment())
	if err != nil {
		return RegisterUdpSessionResponse{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// SessionManager_registerUdpSession_Results_List is a list of SessionManager_registerUdpSession_Results.
type SessionManager_registerUdpSession_Results_List struct{ capnp.List }

// NewSessionManager_registerUdpSession_Results creates a new list of SessionManager_registerUdpSession_Results.
func NewSessionManager_registerUdpSession_Results_List(s *capnp.Segment, sz int32) (SessionManager_registerUdpSession_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return SessionManager_registerUdpSession_Results_List{l}, err
}

func (s SessionManager_registerUdpSession_Results_List) At(i int) SessionManager_registerUdpSession_Results {
	return SessionManager_registerUdpSession_Results{s.List.Struct(i)}
}

func (s SessionManager_registerUdpSession_Results_List) Set(i int, v SessionManager_registerUdpSession_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s SessionManager_registerUdpSession_Results_List) String() string {
	str, _ := text.MarshalList(0x8635c6b4f45bf5cd, s.List)
	return str
}

// SessionManager_registerUdpSession_Results_Promise is a wrapper for a SessionManager_registerUdpSession_Results promised by a client call.
type SessionManager_registerUdpSession_Results_Promise struct{ *capnp.Pipeline }

func (p SessionManager_registerUdpSession_Results_Promise) Struct() (SessionManager_registerUdpSession_Results, error) {
	s, err := p.Pipeline.Struct()
	return SessionManager_registerUdpSession_Results{s}, err
}

func (p SessionManager_registerUdpSession_Results_Promise) Result() RegisterUdpSessionResponse_Promise {
	return RegisterUdpSessionResponse_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type SessionManager_unregisterUdpSession_Params struct{ capnp.Struct }

// SessionManager_unregisterUdpSession_Params_TypeID is the unique identifier for the type SessionManager_unregisterUdpSession_Params.
const SessionManager_unregisterUdpSession_Params_TypeID = 0x96b74375ce9b0ef6

func NewSessionManager_unregisterUdpSession_Params(s *capnp.Segment) (SessionManager_unregisterUdpSession_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return SessionManager_unregisterUdpSession_Params{st}, err
}

func NewRootSessionManager_unregisterUdpSession_Params(s *capnp.Segment) (SessionManager_unregisterUdpSession_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return SessionManager_unregisterUdpSession_Params{st}, err
}

func ReadRootSessionManager_unregisterUdpSession_Params(msg *capnp.Message) (SessionManager_unregisterUdpSession_Params, error) {
	root, err := msg.RootPtr()
	return SessionManager_unregisterUdpSession_Params{root.Struct()}, err
}

func (s SessionManager_unregisterUdpSession_Params) String() string {
	str, _ := text.Marshal(0x96b74375ce9b0ef6, s.Struct)
	return str
}

func (s SessionManager_unregisterUdpSession_Params) SessionId() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return []byte(p.Data()), err
}

func (s SessionManager_unregisterUdpSession_Params) HasSessionId() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s SessionManager_unregisterUdpSession_Params) SetSessionId(v []byte) error {
	return s.Struct.SetData(0, v)
}

func (s SessionManager_unregisterUdpSession_Params) Message() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s SessionManager_unregisterUdpSession_Params) HasMessage() bool {
	p, err := s.Struct.Ptr(1)
	return p.IsValid() || err != nil
}

func (s SessionManager_unregisterUdpSession_Params) MessageBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s SessionManager_unregisterUdpSession_Params) SetMessage(v string) error {
	return s.Struct.SetText(1, v)
}

// SessionManager_unregisterUdpSession_Params_List is a list of SessionManager_unregisterUdpSession_Params.
type SessionManager_unregisterUdpSession_Params_List struct{ capnp.List }

// NewSessionManager_unregisterUdpSession_Params creates a new list of SessionManager_unregisterUdpSession_Params.
func NewSessionManager_unregisterUdpSession_Params_List(s *capnp.Segment, sz int32) (SessionManager_unregisterUdpSession_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2}, sz)
	return SessionManager_unregisterUdpSession_Params_List{l}, err
}

func (s SessionManager_unregisterUdpSession_Params_List) At(i int) SessionManager_unregisterUdpSession_Params {
	return SessionManager_unregisterUdpSession_Params{s.List.Struct(i)}
}

func (s SessionManager_unregisterUdpSession_Params_List) Set(i int, v SessionManager_unregisterUdpSession_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s SessionManager_unregisterUdpSession_Params_List) String() string {
	str, _ := text.MarshalList(0x96b74375ce9b0ef6, s.List)
	return str
}

// SessionManager_unregisterUdpSession_Params_Promise is a wrapper for a SessionManager_unregisterUdpSession_Params promised by a client call.
type SessionManager_unregisterUdpSession_Params_Promise struct{ *capnp.Pipeline }

func (p SessionManager_unregisterUdpSession_Params_Promise) Struct() (SessionManager_unregisterUdpSession_Params, error) {
	s, err := p.Pipeline.Struct()
	return SessionManager_unregisterUdpSession_Params{s}, err
}

type SessionManager_unregisterUdpSession_Results struct{ capnp.Struct }

// SessionManager_unregisterUdpSession_Results_TypeID is the unique identifier for the type SessionManager_unregisterUdpSession_Results.
const SessionManager_unregisterUdpSession_Results_TypeID = 0xf24ec4ab5891b676

func NewSessionManager_unregisterUdpSession_Results(s *capnp.Segment) (SessionManager_unregisterUdpSession_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return SessionManager_unregisterUdpSession_Results{st}, err
}

func NewRootSessionManager_unregisterUdpSession_Results(s *capnp.Segment) (SessionManager_unregisterUdpSession_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return SessionManager_unregisterUdpSession_Results{st}, err
}

func ReadRootSessionManager_unregisterUdpSession_Results(msg *capnp.Message) (SessionManager_unregisterUdpSession_Results, error) {
	root, err := msg.RootPtr()
	return SessionManager_unregisterUdpSession_Results{root.Struct()}, err
}

func (s SessionManager_unregisterUdpSession_Results) String() string {
	str, _ := text.Marshal(0xf24ec4ab5891b676, s.Struct)
	return str
}

// SessionManager_unregisterUdpSession_Results_List is a list of SessionManager_unregisterUdpSession_Results.
type SessionManager_unregisterUdpSession_Results_List struct{ capnp.List }

// NewSessionManager_unregisterUdpSession_Results creates a new list of SessionManager_unregisterUdpSession_Results.
func NewSessionManager_unregisterUdpSession_Results_List(s *capnp.Segment, sz int32) (SessionManager_unregisterUdpSession_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0}, sz)
	return SessionManager_unregisterUdpSession_Results_List{l}, err
}

func (s SessionManager_unregisterUdpSession_Results_List) At(i int) SessionManager_unregisterUdpSession_Results {
	return SessionManager_unregisterUdpSession_Results{s.List.Struct(i)}
}

func (s SessionManager_unregisterUdpSession_Results_List) Set(i int, v SessionManager_unregisterUdpSession_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s SessionManager_unregisterUdpSession_Results_List) String() string {
	str, _ := text.MarshalList(0xf24ec4ab5891b676, s.List)
	return str
}

// SessionManager_unregisterUdpSession_Results_Promise is a wrapper for a SessionManager_unregisterUdpSession_Results promised by a client call.
type SessionManager_unregisterUdpSession_Results_Promise struct{ *capnp.Pipeline }

func (p SessionManager_unregisterUdpSession_Results_Promise) Struct() (SessionManager_unregisterUdpSession_Results, error) {
	s, err := p.Pipeline.Struct()
	return SessionManager_unregisterUdpSession_Results{s}, err
}

type UpdateConfigurationResponse struct{ capnp.Struct }

// UpdateConfigurationResponse_TypeID is the unique identifier for the type UpdateConfigurationResponse.
const UpdateConfigurationResponse_TypeID = 0xdb58ff694ba05cf9

func NewUpdateConfigurationResponse(s *capnp.Segment) (UpdateConfigurationResponse, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return UpdateConfigurationResponse{st}, err
}

func NewRootUpdateConfigurationResponse(s *capnp.Segment) (UpdateConfigurationResponse, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return UpdateConfigurationResponse{st}, err
}

func ReadRootUpdateConfigurationResponse(msg *capnp.Message) (UpdateConfigurationResponse, error) {
	root, err := msg.RootPtr()
	return UpdateConfigurationResponse{root.Struct()}, err
}

func (s UpdateConfigurationResponse) String() string {
	str, _ := text.Marshal(0xdb58ff694ba05cf9, s.Struct)
	return str
}

func (s UpdateConfigurationResponse) LatestAppliedVersion() int32 {
	return int32(s.Struct.Uint32(0))
}

func (s UpdateConfigurationResponse) SetLatestAppliedVersion(v int32) {
	s.Struct.SetUint32(0, uint32(v))
}

func (s UpdateConfigurationResponse) Err() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s UpdateConfigurationResponse) HasErr() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s UpdateConfigurationResponse) ErrBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s UpdateConfigurationResponse) SetErr(v string) error {
	return s.Struct.SetText(0, v)
}

// UpdateConfigurationResponse_List is a list of UpdateConfigurationResponse.
type UpdateConfigurationResponse_List struct{ capnp.List }

// NewUpdateConfigurationResponse creates a new list of UpdateConfigurationResponse.
func NewUpdateConfigurationResponse_List(s *capnp.Segment, sz int32) (UpdateConfigurationResponse_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return UpdateConfigurationResponse_List{l}, err
}

func (s UpdateConfigurationResponse_List) At(i int) UpdateConfigurationResponse {
	return UpdateConfigurationResponse{s.List.Struct(i)}
}

func (s UpdateConfigurationResponse_List) Set(i int, v UpdateConfigurationResponse) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s UpdateConfigurationResponse_List) String() string {
	str, _ := text.MarshalList(0xdb58ff694ba05cf9, s.List)
	return str
}

// UpdateConfigurationResponse_Promise is a wrapper for a UpdateConfigurationResponse promised by a client call.
type UpdateConfigurationResponse_Promise struct{ *capnp.Pipeline }

func (p UpdateConfigurationResponse_Promise) Struct() (UpdateConfigurationResponse, error) {
	s, err := p.Pipeline.Struct()
	return UpdateConfigurationResponse{s}, err
}

type ConfigurationManager struct{ Client capnp.Client }

// ConfigurationManager_TypeID is the unique identifier for the type ConfigurationManager.
const ConfigurationManager_TypeID = 0xb48edfbdaa25db04

func (c ConfigurationManager) UpdateConfiguration(ctx context.Context, params func(ConfigurationManager_updateConfiguration_Params) error, opts ...capnp.CallOption) ConfigurationManager_updateConfiguration_Results_Promise {
	if c.Client == nil {
		return ConfigurationManager_updateConfiguration_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xb48edfbdaa25db04,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:ConfigurationManager",
			MethodName:    "updateConfiguration",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 8, PointerCount: 1}
		call.ParamsFunc = func(s capnp.Struct) error { return params(ConfigurationManager_updateConfiguration_Params{Struct: s}) }
	}
	return ConfigurationManager_updateConfiguration_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}

type ConfigurationManager_Server interface {
	UpdateConfiguration(ConfigurationManager_updateConfiguration) error
}

func ConfigurationManager_ServerToClient(s ConfigurationManager_Server) ConfigurationManager {
	c, _ := s.(server.Closer)
	return ConfigurationManager{Client: server.New(ConfigurationManager_Methods(nil, s), c)}
}

func ConfigurationManager_Methods(methods []server.Method, s ConfigurationManager_Server) []server.Method {
	if cap(methods) == 0 {
		methods = make([]server.Method, 0, 1)
	}

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xb48edfbdaa25db04,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:ConfigurationManager",
			MethodName:    "updateConfiguration",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := ConfigurationManager_updateConfiguration{c, opts, ConfigurationManager_updateConfiguration_Params{Struct: p}, ConfigurationManager_updateConfiguration_Results{Struct: r}}
			return s.UpdateConfiguration(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 1},
	})

	return methods
}

// ConfigurationManager_updateConfiguration holds the arguments for a server call to ConfigurationManager.updateConfiguration.
type ConfigurationManager_updateConfiguration struct {
	Ctx     context.Context
	Options capnp.CallOptions
	Params  ConfigurationManager_updateConfiguration_Params
	Results ConfigurationManager_updateConfiguration_Results
}

type ConfigurationManager_updateConfiguration_Params struct{ capnp.Struct }

// ConfigurationManager_updateConfiguration_Params_TypeID is the unique identifier for the type ConfigurationManager_updateConfiguration_Params.
const ConfigurationManager_updateConfiguration_Params_TypeID = 0xb177ca2526a3ca76

func NewConfigurationManager_updateConfiguration_Params(s *capnp.Segment) (ConfigurationManager_updateConfiguration_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return ConfigurationManager_updateConfiguration_Params{st}, err
}

func NewRootConfigurationManager_updateConfiguration_Params(s *capnp.Segment) (ConfigurationManager_updateConfiguration_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return ConfigurationManager_updateConfiguration_Params{st}, err
}

func ReadRootConfigurationManager_updateConfiguration_Params(msg *capnp.Message) (ConfigurationManager_updateConfiguration_Params, error) {
	root, err := msg.RootPtr()
	return ConfigurationManager_updateConfiguration_Params{root.Struct()}, err
}

func (s ConfigurationManager_updateConfiguration_Params) String() string {
	str, _ := text.Marshal(0xb177ca2526a3ca76, s.Struct)
	return str
}

func (s ConfigurationManager_updateConfiguration_Params) Version() int32 {
	return int32(s.Struct.Uint32(0))
}

func (s ConfigurationManager_updateConfiguration_Params) SetVersion(v int32) {
	s.Struct.SetUint32(0, uint32(v))
}

func (s ConfigurationManager_updateConfiguration_Params) Config() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return []byte(p.Data()), err
}

func (s ConfigurationManager_updateConfiguration_Params) HasConfig() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s ConfigurationManager_updateConfiguration_Params) SetConfig(v []byte) error {
	return s.Struct.SetData(0, v)
}

// ConfigurationManager_updateConfiguration_Params_List is a list of ConfigurationManager_updateConfiguration_Params.
type ConfigurationManager_updateConfiguration_Params_List struct{ capnp.List }

// NewConfigurationManager_updateConfiguration_Params creates a new list of ConfigurationManager_updateConfiguration_Params.
func NewConfigurationManager_updateConfiguration_Params_List(s *capnp.Segment, sz int32) (ConfigurationManager_updateConfiguration_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return ConfigurationManager_updateConfiguration_Params_List{l}, err
}

func (s ConfigurationManager_updateConfiguration_Params_List) At(i int) ConfigurationManager_updateConfiguration_Params {
	return ConfigurationManager_updateConfiguration_Params{s.List.Struct(i)}
}

func (s ConfigurationManager_updateConfiguration_Params_List) Set(i int, v ConfigurationManager_updateConfiguration_Params) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s ConfigurationManager_updateConfiguration_Params_List) String() string {
	str, _ := text.MarshalList(0xb177ca2526a3ca76, s.List)
	return str
}

// ConfigurationManager_updateConfiguration_Params_Promise is a wrapper for a ConfigurationManager_updateConfiguration_Params promised by a client call.
type ConfigurationManager_updateConfiguration_Params_Promise struct{ *capnp.Pipeline }

func (p ConfigurationManager_updateConfiguration_Params_Promise) Struct() (ConfigurationManager_updateConfiguration_Params, error) {
	s, err := p.Pipeline.Struct()
	return ConfigurationManager_updateConfiguration_Params{s}, err
}

type ConfigurationManager_updateConfiguration_Results struct{ capnp.Struct }

// ConfigurationManager_updateConfiguration_Results_TypeID is the unique identifier for the type ConfigurationManager_updateConfiguration_Results.
const ConfigurationManager_updateConfiguration_Results_TypeID = 0x958096448eb3373e

func NewConfigurationManager_updateConfiguration_Results(s *capnp.Segment) (ConfigurationManager_updateConfiguration_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return ConfigurationManager_updateConfiguration_Results{st}, err
}

func NewRootConfigurationManager_updateConfiguration_Results(s *capnp.Segment) (ConfigurationManager_updateConfiguration_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return ConfigurationManager_updateConfiguration_Results{st}, err
}

func ReadRootConfigurationManager_updateConfiguration_Results(msg *capnp.Message) (ConfigurationManager_updateConfiguration_Results, error) {
	root, err := msg.RootPtr()
	return ConfigurationManager_updateConfiguration_Results{root.Struct()}, err
}

func (s ConfigurationManager_updateConfiguration_Results) String() string {
	str, _ := text.Marshal(0x958096448eb3373e, s.Struct)
	return str
}

func (s ConfigurationManager_updateConfiguration_Results) Result() (UpdateConfigurationResponse, error) {
	p, err := s.Struct.Ptr(0)
	return UpdateConfigurationResponse{Struct: p.Struct()}, err
}

func (s ConfigurationManager_updateConfiguration_Results) HasResult() bool {
	p, err := s.Struct.Ptr(0)
	return p.IsValid() || err != nil
}

func (s ConfigurationManager_updateConfiguration_Results) SetResult(v UpdateConfigurationResponse) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewResult sets the result field to a newly
// allocated UpdateConfigurationResponse struct, preferring placement in s's segment.
func (s ConfigurationManager_updateConfiguration_Results) NewResult() (UpdateConfigurationResponse, error) {
	ss, err := NewUpdateConfigurationResponse(s.Struct.Segment())
	if err != nil {
		return UpdateConfigurationResponse{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// ConfigurationManager_updateConfiguration_Results_List is a list of ConfigurationManager_updateConfiguration_Results.
type ConfigurationManager_updateConfiguration_Results_List struct{ capnp.List }

// NewConfigurationManager_updateConfiguration_Results creates a new list of ConfigurationManager_updateConfiguration_Results.
func NewConfigurationManager_updateConfiguration_Results_List(s *capnp.Segment, sz int32) (ConfigurationManager_updateConfiguration_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return ConfigurationManager_updateConfiguration_Results_List{l}, err
}

func (s ConfigurationManager_updateConfiguration_Results_List) At(i int) ConfigurationManager_updateConfiguration_Results {
	return ConfigurationManager_updateConfiguration_Results{s.List.Struct(i)}
}

func (s ConfigurationManager_updateConfiguration_Results_List) Set(i int, v ConfigurationManager_updateConfiguration_Results) error {
	return s.List.SetStruct(i, v.Struct)
}

func (s ConfigurationManager_updateConfiguration_Results_List) String() string {
	str, _ := text.MarshalList(0x958096448eb3373e, s.List)
	return str
}

// ConfigurationManager_updateConfiguration_Results_Promise is a wrapper for a ConfigurationManager_updateConfiguration_Results promised by a client call.
type ConfigurationManager_updateConfiguration_Results_Promise struct{ *capnp.Pipeline }

func (p ConfigurationManager_updateConfiguration_Results_Promise) Struct() (ConfigurationManager_updateConfiguration_Results, error) {
	s, err := p.Pipeline.Struct()
	return ConfigurationManager_updateConfiguration_Results{s}, err
}

func (p ConfigurationManager_updateConfiguration_Results_Promise) Result() UpdateConfigurationResponse_Promise {
	return UpdateConfigurationResponse_Promise{Pipeline: p.Pipeline.GetPipeline(0)}
}

type CloudflaredServer struct{ Client capnp.Client }

// CloudflaredServer_TypeID is the unique identifier for the type CloudflaredServer.
const CloudflaredServer_TypeID = 0xf548cef9dea2a4a1

func (c CloudflaredServer) RegisterUdpSession(ctx context.Context, params func(SessionManager_registerUdpSession_Params) error, opts ...capnp.CallOption) SessionManager_registerUdpSession_Results_Promise {
	if c.Client == nil {
		return SessionManager_registerUdpSession_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0x839445a59fb01686,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:SessionManager",
			MethodName:    "registerUdpSession",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 16, PointerCount: 3}
		call.ParamsFunc = func(s capnp.Struct) error { return params(SessionManager_registerUdpSession_Params{Struct: s}) }
	}
	return SessionManager_registerUdpSession_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c CloudflaredServer) UnregisterUdpSession(ctx context.Context, params func(SessionManager_unregisterUdpSession_Params) error, opts ...capnp.CallOption) SessionManager_unregisterUdpSession_Results_Promise {
	if c.Client == nil {
		return SessionManager_unregisterUdpSession_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0x839445a59fb01686,
			MethodID:      1,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:SessionManager",
			MethodName:    "unregisterUdpSession",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 2}
		call.ParamsFunc = func(s capnp.Struct) error { return params(SessionManager_unregisterUdpSession_Params{Struct: s}) }
	}
	return SessionManager_unregisterUdpSession_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}
func (c CloudflaredServer) UpdateConfiguration(ctx context.Context, params func(ConfigurationManager_updateConfiguration_Params) error, opts ...capnp.CallOption) ConfigurationManager_updateConfiguration_Results_Promise {
	if c.Client == nil {
		return ConfigurationManager_updateConfiguration_Results_Promise{Pipeline: capnp.NewPipeline(capnp.ErrorAnswer(capnp.ErrNullClient))}
	}
	call := &capnp.Call{
		Ctx: ctx,
		Method: capnp.Method{
			InterfaceID:   0xb48edfbdaa25db04,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:ConfigurationManager",
			MethodName:    "updateConfiguration",
		},
		Options: capnp.NewCallOptions(opts),
	}
	if params != nil {
		call.ParamsSize = capnp.ObjectSize{DataSize: 8, PointerCount: 1}
		call.ParamsFunc = func(s capnp.Struct) error { return params(ConfigurationManager_updateConfiguration_Params{Struct: s}) }
	}
	return ConfigurationManager_updateConfiguration_Results_Promise{Pipeline: capnp.NewPipeline(c.Client.Call(call))}
}

type CloudflaredServer_Server interface {
	RegisterUdpSession(SessionManager_registerUdpSession) error

	UnregisterUdpSession(SessionManager_unregisterUdpSession) error

	UpdateConfiguration(ConfigurationManager_updateConfiguration) error
}

func CloudflaredServer_ServerToClient(s CloudflaredServer_Server) CloudflaredServer {
	c, _ := s.(server.Closer)
	return CloudflaredServer{Client: server.New(CloudflaredServer_Methods(nil, s), c)}
}

func CloudflaredServer_Methods(methods []server.Method, s CloudflaredServer_Server) []server.Method {
	if cap(methods) == 0 {
		methods = make([]server.Method, 0, 3)
	}

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0x839445a59fb01686,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:SessionManager",
			MethodName:    "registerUdpSession",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := SessionManager_registerUdpSession{c, opts, SessionManager_registerUdpSession_Params{Struct: p}, SessionManager_registerUdpSession_Results{Struct: r}}
			return s.RegisterUdpSession(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 1},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0x839445a59fb01686,
			MethodID:      1,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:SessionManager",
			MethodName:    "unregisterUdpSession",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := SessionManager_unregisterUdpSession{c, opts, SessionManager_unregisterUdpSession_Params{Struct: p}, SessionManager_unregisterUdpSession_Results{Struct: r}}
			return s.UnregisterUdpSession(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 0},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xb48edfbdaa25db04,
			MethodID:      0,
			InterfaceName: "tunnelrpc/tunnelrpc.capnp:ConfigurationManager",
			MethodName:    "updateConfiguration",
		},
		Impl: func(c context.Context, opts capnp.CallOptions, p, r capnp.Struct) error {
			call := ConfigurationManager_updateConfiguration{c, opts, ConfigurationManager_updateConfiguration_Params{Struct: p}, ConfigurationManager_updateConfiguration_Results{Struct: r}}
			return s.UpdateConfiguration(call)
		},
		ResultsSize: capnp.ObjectSize{DataSize: 0, PointerCount: 1},
	})

	return methods
}

const schema_db8274f9144abc7e = "x\xda\xccZ{t\x1c\xe5u\xbfwfW#\x19\xc9" +
	"\xaba\x96H\x96#\xab\xd1\xb1Kqb@v\x9d\x82" +
	"\x9bF\x92\x91\x1cV\xf8\xa1\xd9\xb5s\xa8\xb1s\x18\xed" +
	"~\x92F\x9d\x9dYff\x85\xe5\xe0\xd886\x06\x0e" +
	"\x10 6`'n\x8c\x1d\xda\x83\x09)\x0e\xa6)=" +
	"\xa4\xc5i\x1c\x12H\x1c\x9c\x03\xa9\x89I\xd3\xc6q[" +
	"\xfb\x98R\x0c4\xc7m\xcc\xf4\xdc\x99\x9d\x87v\x17=" +
	" \x7f\xe4\xbf\xd5\x9d\xfb=\xee\xef\xfb\xdd\xc7w?]" +
	"}\xa0\xae\x8b\xeb\x88oN\x00\xc8\x87\xe35\x0e\x9b\xff" +
	"\xd3\x8d\xfb\xe6\xfd\xd3V\x90[\x10\x9d/<\xd7\x97\xbc" +
	"`o=\x09q^\x00X\xf4\x98\xb0\x11\xa5g\x05\x01" +
	"@zF\xf8\x0f@\xe7\x8e\x8f<\xf5\xb5\xc7zw~" +
	"\x11\xc4\x16>T\x06\\\xb4\xbb\xb6\x0f\xa5'kI\xf3" +
	"\xf1\xda\x1dR]\x9d\x00\xe0\xdc ^uS\xf2\xe5c" +
	"\xa4\x1d\x9d:FS\xbfU;\x1f%$5\xe9b-" +
	"M\xfd\xa9\xfcO\xf6\x7fr\xd7K\xdb@l\xe1\xc6M" +
	"}\xa6n#J\x17]\xcd\x0bu\xab\x00\x9d\xb7w6" +
	"?\xf1\xe8\xb1\x1fl\x07\xf1r\x84\xd2N\xc5\x19?G" +
	"@i\xde\x8c\xbf\x01t~\xfc\xeeM\xef\x1c\xfe\xfe\xe2" +
	";@\xbc\x82\x14\x90\x14\x8e\xceh\xe7\x00\xa5_\xcc\xe8" +
	"\x04t\xce\x9e\xfb\xbf\x1d\x9f\xbfb\xe5\xfd _\x81\x9c" +
	"?\xc5\xc5\x19-\x1c\xe0\xa2\xcb.iC@\xa7s\xd9" +
	"\x8f\x9fmY\xf4\xd0\xce\xb2\xbds\xa4ym\xfd|\x94" +
	"R\xf5\xb4\xa3\xde\xfa[\x01\x9dO\xff\xc9\xd3\xf7\xf5<" +
	"\xb4e\x17\x88W\x05\x0b>^\xbf\x96\x16<ZO\x0b" +
	"\xfe\xcf\xcc\xaf\x1c+^\xf7\xed\x87J;rg9]" +
	"?\x9f\x14.\xba3\xb4\x8f\xce\xbb\xf9\xbbG\x9f~\x18" +
	"\xe4\x05\x88\xce\xeb\x03\x1f\x7f\x95\xdf{\xf0$\xacA\x81" +
	"6\xb8h}\xc3~2/\xdf@\xba?\xf9\xc4s\x7f" +
	"\x7f\xff\xd3;\xbe\x02\xf2\xe5\x88\x00.\x9c\xc7\x1b\xfe\x97" +
	"\x14N7\xd0j;O|ge\xfe\x81=\xfb=\x80" +
	"\xdc\xef\x0d39\x0eb\xce\xb6\xd4o\xf2k\x0ed\x0e" +
	"\x94\xa0\x8b\xd3'\x9cy\x1e\xc9\xee\x99\xae\xdd\x8b\x7f~" +
	"z\xd5\x8ao\x0d\xfeudlGb#\x8d\xdd1x" +
	"\xfeHc:\xffD5D\x16$\x0e\xa2\xd4\x9b D" +
	"\xba\x13\xb4\xc7'\xe7\xdcP\xb7\xe1\xf4\xb2\xa7@\\\xe0" +
	"O\xb37\x91\xa6iF_<\xf0\x87\xf3^\xbc\xf5\x10" +
	"\xc8Wa\x00\xd6n\xfa\x86\xd23\xee\xd8\xd8\xc9y\x07" +
	"\xbf\xf3\xcb\xfb\x0eW\x90Ll\xdc\x88\xd2\xbcFZ\xe5" +
	"c\x8d\x9f\x91d\xfa\xe5\xc4\xd6\xf3\xef)\x8f\xfc\xe3\xe1" +
	"r\x02{'\xd58\x80\xd2\x0a\xd2[\x94jt\xed\xbb" +
	"\xfb\xc8\x9e\x8f\xd7~\xed\xedg\xaa\xaa\xdf\"\x0e\xa0\xb4" +
	"]\xa4\x05n\x17\x89I\x97\xa5\xf0\xf5\xe7;b\xdf\x8e" +
	"Rm\xde\xa5g\x09\xeak/%\x85\xd67\x966\xe8" +
	"on}\xbe\x0c\x14W\xf1\xb5K\xfbPz\xe3R\x9a" +
	"\xed\x8c\xab\x1c\xfb\xe4\xc8\x0e\xf1\xd4\xcf\x8ez\xa0x\x96" +
	"o\x97F\xc8\xf2G%:\xb8\xbe\x9b\xbe\xfc`\xfc\xf4" +
	"\x97_\xa0\xcdE\x9c N~\xb5\xe8\x88d\xa2\xf4\xaa" +
	"\xe4\x9e\xb6\xd4\xc4\x03:-O\xfd\xe97\x97\xe6^{" +
	"\xa9\xca\x89Hr\xd3yi}\x13\xfd\xfa\xf3&\x02\xf5" +
	"\xd4\x82C\x9f?s\xef\xf1WJ\x96\xb8k?\xd3\xe4" +
	"\x92\xe6\x87M\xb4\xf6\x85u\xfbnP\x9d\x1bO\x96\x03" +
	"\xe3j\x9ei\xfa\x16J\xd8\xecz\xab;]\xc0\xd0j" +
	"\xdaJ\xf3\x08JEW\xfb\x96f\x9a\x9b;\xad\xcc\xda" +
	"\xf2\xb3O\xbf\x1e!U\xb1\xf9W\x081g\xe5go" +
	"\x1a\xa9\xdbt\xeaTt[j\xb3\x0b\xf0&w\xe8?" +
	"\xfc\xf3\xc3\xc3\xeb\xbfy\xect\x94H\xcd&\x11\xe9\xbf" +
	"\xfe\xea\xec\x97\xce\xe5s\xff\xee\xba\x8c\x7f8\xbb\x9b\x97" +
	"\x10\x9c\x87\x9a)\xa44\xb55\xf4\xb6\x9f\xe8?\x1b\xc5" +
	"\xfb\xdeYKI\xe1\xb1Y4\xf9\xe2\x9b\xbb\xd9\xbak" +
	"n<[\xc1\xb4\xa3\xb3\x96\xa0\xf4\xea,\x17\xebY;" +
	"P:\xd3\xd2\x04\xe0\x8c\xfe\xed\x037>\xf1\xbd\x95\xe7" +
	"=/v\xf7\xf2Z\xcbB\xda\xcb}_\xe8Yum" +
	"\xfb\x91\xf3Q3\x8e\xb7\x9cw]\xb2\x85V\x1a\xbc\xe6" +
	"\xdcg\xe6\xdd\xf7\xfd\xf3eG\xe5*\xc6g\xcfG\xe9" +
	"\xb2\xd9\x04\x978\xbb\x13\xf0\xcde\x7f\xf9JK\xa2\xe5" +
	"\x9d2hkHw\xf1\xec\x11\x94R\xa4\xbb\xa8w\xf6" +
	"\x0bD\xe8G\xbf\xbe\xff_.\x1c\xbb\xfe\xdd\x0a\x1b\xae" +
	"m%\xee\xb7\xd2\xb4\xa9VAJ\xb5^\x0e\xe0\xdcq" +
	"\xf2s\x1b~\xfa\xc5\xb7\xdf-g\x98\xbb\x91\xee\xd64" +
	"Jk\xdc\x11r+\x11\xf6\xe1\xd5\xff\xb9\xf9\xdc\xae\x8f" +
	"\xfc\xa6b\xee\xb7ZGP\x8a\xcf!M\x9c\xf3\x82\xb4" +
	"\x8b~9/\x0b\x07:z6\xbft!rT\x9b\xe6" +
	"\xf4\x11<\x0f\x09_=\xb5\xe5\x97\x9f\xfbm\x14\x9e\xb1" +
	"9\xbf\"x\xee\x9dC\xf0\xdc\xf6\xe6\xee\xeb\xbf\xb4\xee" +
	"\x1b\xefE\x08\xf2\xe4\x9c\xad4\xd4.\xea:\xd3\xccB" +
	",{\x95\xff3{eV)\xe8\x85%\xddE{\x98" +
	"\xe9\xb6\x9aUl\x96f\x9dV\xc1\xd0-\xd6\x8f(7" +
	"\xf21\x80\x18\x02\x88\xca\x08\x80|3\x8f\xb2\xc6\xa1\x88" +
	"\x98$\xa2\x88*\x09\x87y\x94m\x0eE\x8eKR\x84" +
	"\x15oi\x07\x905\x1e\xe5\x0d\x1c\"\x9fD\x1e@," +
	">\x08 o\xe0Q\xde\xc6\xa1S`f^\xd1\x99\x0e" +
	"\x09\xbb\xd74\xb1\x1e8\xac\x07tLf\x9bc\xca\x80" +
	"\x06\x09\x16\x11\x0b#\xb7\xda\xd8\x00\x1c6\x00:\xc3F" +
	"\xd1\xb4\xd6\xe86\xaaZ\x9a\x0d\x9a\xcc\xc2a\xac\x01\x0e" +
	"k\x00'2/\xc3,K5\xf4\x15\x8a\xae\x0c1\x13" +
	"\x80,\xab\xe5\xe3\x00A\xfaB?\xd1\x89\x1d{\x80\x13" +
	"\x17\x08\x18f\x1a\xf4\xc9*~\xec pb\xab\xe0\x98" +
	"lH\xb5lf\xe2\x9a\\\xc1\x9d\x9b7\xf4.t\x8a" +
	"\xba\xf7\x01\x99\xe9}H\xd0\xaa]\xd8\x8f\xe1\xee\xf8\xca" +
	"\xdd]\xa7\xa9L\xb7\x13)}\xd0(\x83\xbc\xaf\x1a\xe4" +
	"}%\xc8\xb7E \xbf})\x80|\x1b\x8f\xf2\x9d\x1c" +
	"\x8a|\x09\xf3\xed\xf3\x01\xe4-<\xca\xf7p\xe8d\xdd" +
	"ER9\x00\x08\xd0\x1cd\x8a]4\x99E\xb2\x99\x80" +
	"\xfd<\xba\xa0\xcf\x04\xdc<\xcaL\xda\xbb\x7f\x08\x09\xc5" +
	"\xcc\x0e\x07\x075\x01\xd2\xbd\x1bT\xcbV\xf5\xa1\xd5\xae" +
	"\xbc\xb3\xdf\xd0\xd4\xec\x18YU\xef\xee\xb3u\x09\x00\xa2" +
	"x\xd9Z\x00\xe4Dq)@\xa7:\xa4\x1b&sr" +
	"\xaa\x955t\x9d\x01\x9f\xb57\x0f(\x9a\xa2gY\xb0" +
	"PM\xe5B\xde\x02\x19f\x8e2\xf3J%B\xdf\xb9" +
	"\xfd\x8a\xa9\xf0yK\xae\x0fp\xec]\x0b \xf7\xf0(" +
	"\xf7Gp\\A8.\xe7Q\xbe1\x82\xe3\x1a\xc2\xb1" +
	"\x9fGy\x1d\x87\x8ea\xaaC\xaa~\x1d\x03\xde\x8c2" +
	"\xd0\xb2u%\xcf\x08\xb3\x12\x1e\x9b\x8d\x82\xad\x1a\xba\x85" +
	"\x8da\xd6\x01\xc4\xc6\x08R\xc2d\x9c\xbc\xd2\xa7\x94\xcf" +
	"(C\x9f\x9bfVQ\xd0lK\x8e\x05\x964,\x01" +
	"\x90ky\x94\x93\x1cv\x9a\xcc*j66\x86\xe5\xc4" +
	"\xefbU\x1f\xbed\xb0\xe8\xa6t\x84\\>|\xdb\x17" +
	"\x86\xe4\xc2\x12zw\x11z\xdbx\x94\xef'\x16\xa2\xc7" +
	"\xc2{\xf7\x00\xc8\xf7\xf3(\x7f\x95C1\xc6%1\x86" +
	"(\xee\xa6\xb8\xf1\x08\x8f\xf2\xd79t,o\xe5\x14`" +
	"\xce\x87\xb9-g\xd9\xa9\x82\xff\xd7\xe6\x9ce\xf7\x1b\xa6" +
	"\x8d\x02p(\x00\x91\xd9\xb0X\xf7 9Z*\xa7\xb1" +
	"\xebU^\xb71\x0e\x1c\xc6\xc9zS\xc9\xb2\xeb\x0c\x8a" +
	".l\x83]:$\x10q\x06\xc0D^\xe8\x11*A" +
	"\x91\xd0\x0b\x0f\xbe\xf9W\x10{\xfe\x88G\xf9\x8f#\xe6" +
	"w\x90\x01W\xf3(\x7f\x8aCG\xc9f\x8d\xa2n\xaf" +
	"\x06^\x19*s\x92\x0c\x83D\xd6d!\x7f\xfcek" +
	"\xab\xc4\x01C\x1fT\x87\x8a\xa6bGN\xa8X\xc8)" +
	"6\x1b\xf7\xc9%\x86\xc6O\x81\x18A!2mb\xf8" +
	"\xa1\xac\x8c\x1a\x09S\xc9[Ql\xd2\xd5\xb0!\x1a|" +
	"\x82G\xf9\x9a\xea\x87\xbb9\xcf,K\x19b\x15\xf1$" +
	"^\x15\x13\x9de\xc9\xea4\xf3\xb2\xd2\x95&\xb3\x84\xa2" +
	"f\xd3.\xea\x1d\xc7\xdb\x06\x91q.\x8f\xf2\xd5\x1c6" +
	"\xe0{\x8e\xb7\x8f\x05\x0f\x86g\xd4\xc6L\xd30\xb11" +
	"\xcc\xda%H\xb2\xa5\x05\xd0\xd0{\x98\xad\xa8\x1a\x92\x1f" +
	"\x07\xa5m\x19p\x93\x05\xa2\x106O<\xb7\x93\xdc)" +
	"?\xee\xa4\xc8\x1f\x1ay\x94?\xca\xa13D\\\xedg" +
	"&\xaaFn\xa5\xa2\x1b\x19\x9eeC\"\x97V\x9a9" +
	"\xddE]~\xd8\x16\x04\xa3&\x1eo\xb2\x12\x08\xa5\xe1" +
	"\xfdm\xde\x9e#\x11\xa0=\xcc\xde\xc11\xdf>\x10F" +
	"\x80 \x80\xdeE\xcer'\x8f\xf2\xceH\"z\xa0/" +
	"\x1a\x02bI\x8c\x01\x88\xbb\x89%;y\x94\xf7q\xe3" +
	"s<\x1be\xba\xdd\xa3\x0e\x81\xc0\xacPJ[\xecQ" +
	"\x87\x18\xf0\xd6\x87\x0d\xc6\xb5\x93\xe0a\x0cX\x86\xc6l" +
	"\xd6\xc3\xb2\x9aB.7\xca\xbc\xef%2\xfa\x87:\x11" +
	"o\xd3\x15\xdeC\xfcM\xf8eU\xc4\x83\xdaC\xea\x06" +
	"\xd0.X\x18\xba\x95\xc0\xc2Z\xa8\xcd*(\xba5\x95" +
	"X\xe2\xad\xef\xc5\x8b\x0a\x9a\x84NU\xa2\x0aZ\xbf\x93" +
	"\xb8\xe4\xc2\x82\xe3\xe2\xc3\xd2\xd0\xba\xc0\xb8%\xa1qA" +
	"\x9d\x11\x03\x0ec\x80\x9dYw\xc2\x0a\x0bc\x93\xed\xaa" +
	"\xd3\xdb\x16a\x1bs\x0b;\xffn\x8c~CA\x14\xf7" +
	"\x03'6\x08\x8e\xbfs\xf4\xc7\x0b\x15EZl\xa2@" +
	"\xb4\xaa`\xab\x82\xa1[\xb4V\xc4E\x96Ts\x11\xb3" +
	"J\x92\xdc\x1a\xf5\x90R\x92|`O\xe8\x0c^\x92\x04" +
	"\x10\xf7\xee\x07\x90\xf7\xf1(\x7f\x83\xc3N\xaf~\xc3\xc6" +
	"\xb0\x13Tb\xb5W\xa5,7\xa0-\xabha\xcet" +
	"LV\xd0\x94,\xeb\xc5RE\x06\x88\xc0!\xba\xae\x94" +
	"/\x98\xcc\xb2P5t\xb9\xa8h*o\x8f\x05U\xb4" +
	"^\xcc\xf7\x9blTE\xa3hu\xdb6\xcb\x0b\x05\xdb" +
	"\x9aJ\x8d\x1d\x02DqTP5\x17\xa0H\x11F\xd5" +
	"h\x17\x8f\xf2\xf2\x08@)J\xa3\xd7\xf3(\xaf\x0e\x01" +
	"\x92\xbf\x0b \xaf\xe6Q\xbe\x99\xc3D\xb1\xa8\x06y\xc3" +
	"\xd1\x8c\xac{\xda\x90X\xa9\xe4\xcb\xd3G\xca\xe2\xd2," +
	"o\xd8L\x1b\xf38\x9a\x0b-\x9ej\xf8.\x8b\xa3~" +
	"\xbe\xfb}\xaa$'\xbe\xbc\x118P\x86{{5\xdc" +
	"\x17F\xec\xf0\xb7\xbcb \xb4C\xf8\x0b6\x16D\x1d" +
	"\x96\xa7\xbc\xe8\xc3]2\xa6\x1b\x84\x1bB\x9d\xe9\xc6\"" +
	"\xd7\x07\x97\x1bYE+\x0f!\x89\xf2|\x19\xadl\xa6" +
	"\x1e\x1e\xa2\x8b\xae*\xb4\xb9\xb0\x120\xd7\xf8\x13Kc" +
	"\xd8\x07\x90\xd9\x80<f\xb6a\x88\x8dt;.\x05\xc8" +
	"\xdcF\xf2;1\x84G\xda\x8e-\x00\x99-$\xbf\x07" +
	"\x83\x9b\xadt\x17\x1e\x04\xc8\xdcC\xe2GH=\xc6\xbb" +
	"\xde+\xedr\xa7\xdfI\xf2}$\x8f\xc7\x92\x18\x07\x90" +
	"\xf6\xe2|\x80\xcc#$?L\xf2\x1a.\x895\x00\xd2" +
	"!\x1c\x01\xc8<E\xf2\xe7H.\xc4\x93t\xb9\x97\x9e" +
	"E\x13 \xf3w$\xff\x1e\xc9k\x9b\x93X\x0b \x1d" +
	"q\xe5\xcf\x93\xfcG$\xaf\x9b\x95\xc4:\x00\xe9\x87\xb8" +
	"\x15 \xf3\x03\x92\xbfB\xf2\x19\x98\xa4\xd2W:\x8e{" +
	"\x002\xaf\x90\xfc_I~IM\x12/\x01\x90~\xe1" +
	"\xee\xe7\x04\xc9\x7fM\xf2\xfaX\x92\xeae\xe9\xdfp?" +
	"@\xe6\xd7$\xffo\x927\x08Il\x00\x90\xdep\xed" +
	":G\xf2Z\xae\xecb\xe9\xd3\xb8\xec\xf6\xc8\x1bV\xc0" +
	"\x13V\x0aG\xe8\xf9X\xbf\x91\xa0\x1b\"&\xc2\xa65" +
	" &\x00\x9d\x82ah+\xc7\xbbG\xc2V\x86,\xff" +
	"\xa6\xda\x18\xf6\xec\x00I\x18\x94r\x900\xf4T.\x88" +
	"Y\xe5\x01\xd2\xdf\x89ju\x17m\xa3X\x806\xe2b" +
	".\x08\x16fQ_f\x1a\xf9\xd5\xc8\xcc\xbc\xaa+\xda" +
	"$\x81\xb3\x0e8\xac\x83R\xa4\xf2\xe7\x9e8\x8a\xbe\xff" +
	"\xbd;`4W\xce\xe8\xb6\xc2\x92\xd5\xcaPY\xed0" +
	"\x7f\x92\xda!\xa1G\xe2d\xdb\xa8\xa2\x15+\x8b\xee\x9a" +
	"iV\x87\xe9N\xaf\xba\x9c\xec\xf2\xe1\xb7\xde\xca\xe2W" +
	"\x95ZiMe)\x91fV[\xa1J\xb1t0\xbc" +
	"Y\xf8\xf6.n\x8f\xdc\xc44\xc5f\x96\xdd]\xc0\x82" +
	"\xa6\xb2\xdcg\x99\x99\x88V\x17\xd1Rjj\xa9l\\" +
	"\xd1\xe6\x1a\x8c\x91\x07\x062\x9c+\x19<e<\x87\x98" +
	"\xed\xfdJ\xe9\x83\x06\x95LB\xb4\x94\x9c\xde\xe84\xb3" +
	"\x12S9\x8b\xb0g:y)<\x9dh\x9dfm." +
	"\x17&\xbaXV\x99\xafJ\x1d\xea\xdf\x93\"\xcd/\"" +
	"\xf7:\x1e\xe5\xe1\x08\xb9\x19\xa5\xda\x1c\x8fr!\xac\x17" +
	"\xf2\xe9\xb0\xdd(\xf2\\\xa9\xdfH\xe9\xb7\xc0\xa3|\x1b" +
	"\x87\x09\xa5h\x0fcc\xf8\x0e5\x0e\x84\xf1-1\xe2" +
	"zJ\xcf1\xc0\x0d\xbe\xbbF\x92r\xf0@\xf2\x81`" +
	"|\xdf\xf2\xdb\x82I\x0f0x$([\xf9}\x1b\x19" +
	"\x9d\xde\xa2\xc4\xdbf\xb7 \xf6\xdf_\xd0o\xb0\x8b\x87" +
	"6\x02'>.`\xf8\xa8\x80\xfe\x1b\x82\xb8\xd7\x04N" +
	"\xdc% \x17<\x91\xa1\xff\x14&\xdeu7p\xe2v" +
	"\x01\xf9\xe0\x85\x0b\xfd\xa6s\xc7\xd8\x0c\x04N\xdc$`" +
	",x[D\xbfe-\xde2\x02\x9c\xa8\x0a\x18\x0f\x1e" +
	"\xcf\xd0\x7fK\x11\xd7o\x05N\\\x13\xb6V\xa1\xd3\xb3" +
	"\xa3\x0b\x1d\x9f\xf3\xd0\xe6\xb2~|\xa3\xd5\xd3\x02\xe8B" +
	"\xc7\xbf\xb7\xf1\xefwqs\xb5\xfc^!$\xb2\x8a\xcd" +
	"\xba\xa8P\xf6\x02\x1c\x96\"\x1ct\xa1\x1c\xc3H\xc7>" +
	"\xd27\xfa\x80\x8d\x93\x0a?\x99f!\xea\x8f\xff\x801" +
	"\x97\xaf\xb6kZ'\xe89G\xe6\xa5\x8a\xbc\x9eG\xb9" +
	"\x99\x9b\xa4\xe0\xae\x1a:\xbd\x0d\xfb\xe4O\xd0`\x9a\xff" +
	"\x0f\x82\xf9\x8fS\xb8\xfe\x11\x8f\xf2\x89\x88[\xbfJ\xc2" +
	"\x97y\x94_\x8f\x94\xa3\xaf\x91\xaf\x9f\xe0Q~'|" +
	"Fx\xebn\x00\xf9\x1d\x1e\xd3\x91JK\xbcH\x8a\xbf" +
	"\xa5z\xc4\xad\xb3\xd0\xab\xb3\xe2\xf8 @\xa6\x96\xea\x94" +
	"\xa4[g\xc5\xbc:K\xc4\x01\x80L#\xc9?\x1a\xad" +
	"\xb3f\xe1Z\x80L3\xc9\xe7\xe2\xf8k\xb7P4\xc3" +
	"\xf2W3\x86\x96\xabz\xd5\xe4\xed\xbfk\xa0\xbdLQ" +
	"\xb5\xa2\xc9\xa0\xfc\x0a\x92\xea\x89\x943\xde\x83\x87\xd7\xc6" +
	"\xcc\x10\x09sh\x05-\xceitA&\xcad\x9aQ" +
	"\xcc\x0dj\x8a\xc9r\x19f\x0a^@\xe8\xe7\xe3r-" +
	"F\xfe\x03\x01 |(\x8e\x90}\xc2\xcc\xd8k\x9a\x06" +
	"\x9aeW\x8d\x85\xe1U#\xb8i\xac\x0dox\"\xd7" +
	"U\xba\xe2\x0d\x84\x97\xa3\xb6\xacR\xb4X\x05&\xc03" +
	"3\xe8\x84Y\xc3FQ\xcb\xa5\x19\x08\xb69Vq\xab" +
	"\x8bM\x16}\x13~$\xacw#\xa1\xff\xda\x89\xfe\xa3" +
	"\xa6(\xef\x01N\\A\x91\xd0\x7fxC\xff\xd5]\xec" +
	">\x08\x9c\xf8g\x14\x09\xfd7g\xf4\x1fR\xc5\x8e\x17" +
	"\x81\x13;\"\xefA>>\x15\xefA\xde\x07\xd7\x1f\xe8" +
	"C)\xa1r\xe5\x19\x95\"T\xb4\x11\xf1!:;^" +
	"B\x8d\x1c\xe7\xb4\x1eQ\xa6\xfc\xf6\x10\xfc\xd3KY\xcc" +
	"\xa9\xfb\xb0M6?5\xfe\x7f\x00\x00\x00\xff\xff\xda\xbc" +
	"\xea\xa1"

func init() {
	schemas.Register(schema_db8274f9144abc7e,
		0x82c325a07ad22a65,
		0x839445a59fb01686,
		0x83ced0145b2f114b,
		0x84cb9536a2cf6d3c,
		0x85c8cea1ab1894f3,
		0x8635c6b4f45bf5cd,
		0x904e297b87fbecea,
		0x9496331ab9cd463f,
		0x958096448eb3373e,
		0x96b74375ce9b0ef6,
		0x97b3c5c260257622,
		0x9b87b390babc2ccf,
		0xa29a916d4ebdd894,
		0xa353a3556df74984,
		0xa766b24d4fe5da35,
		0xab6d5210c1f26687,
		0xb046e578094b1ead,
		0xb177ca2526a3ca76,
		0xb48edfbdaa25db04,
		0xb4bf9861fe035d04,
		0xb5f39f082b9ac18a,
		0xb70431c0dc014915,
		0xc082ef6e0d42ed1d,
		0xc5d6e311876a3604,
		0xc793e50592935b4a,
		0xcbd96442ae3bb01a,
		0xd4d18de97bb12de3,
		0xdb58ff694ba05cf9,
		0xdbaa9d03d52b62dc,
		0xdc3ed6801961e502,
		0xe3e37d096a5b564e,
		0xe5ceae5d6897d7be,
		0xe6646dec8feaa6ee,
		0xea50d822450d1f17,
		0xea58385c65416035,
		0xf24ec4ab5891b676,
		0xf2c122394f447e8e,
		0xf2c68e2547ec3866,
		0xf41a0f001ad49e46,
		0xf548cef9dea2a4a1,
		0xf5f383d2785edb86,
		0xf71695ec7fe85497,
		0xf9cb7f4431a307d0,
		0xfc5edf80e39c0796,
		0xfeac5c8f4899ef7c)
}
