function(check_file target filename)
  set(full_filename "${RunCMake_TEST_BINARY_DIR}/${target}_verify_interface_header_sets/${filename}")
  if(NOT EXISTS "${full_filename}")
    string(APPEND RunCMake_TEST_FAILED "File ${full_filename} should exist but does not\n")
    set(RunCMake_TEST_FAILED "${RunCMake_TEST_FAILED}" PARENT_SCOPE)
    return()
  endif()

  if(filename MATCHES "^(.*)(\\.[a-z]+)$")
    set(header_filename "${CMAKE_MATCH_1}")
  endif()
  set(expected_contents "#include <${header_filename}>\n")
  file(READ "${full_filename}" actual_contents)

  if(NOT actual_contents STREQUAL expected_contents)
    string(REPLACE "\n" "\n  " expected_contents_formatted "${expected_contents}")
    string(REPLACE "\n" "\n  " actual_contents_formatted "${actual_contents}")
    string(APPEND RunCMake_TEST_FAILED "Expected contents of ${full_filename}:\n  ${expected_contents_formatted}\nActual contents:\n  ${actual_contents_formatted}\n")
    set(RunCMake_TEST_FAILED "${RunCMake_TEST_FAILED}" PARENT_SCOPE)
    return()
  endif()
endfunction()

check_file(static a.h.c)
check_file(static dir/c.h.c)
check_file(static dir/cxx.h.cxx)

if(NOT RunCMake_GENERATOR STREQUAL "Xcode")
  check_file(config debug.h.c)
  if(RunCMake_GENERATOR_IS_MULTI_CONFIG)
    check_file(config release.h.c)
  endif()
endif()
