"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const content_serdes_1 = require("../content-serdes");
class JsonCodec {
    constructor(subMediaType) {
        if (!subMediaType) {
            this.subMediaType = content_serdes_1.ContentSerdes.DEFAULT;
        }
        else {
            this.subMediaType = subMediaType;
        }
    }
    getMediaType() {
        return this.subMediaType;
    }
    bytesToValue(bytes, schema, parameters) {
        let parsed;
        try {
            parsed = JSON.parse(bytes.toString());
        }
        catch (err) {
            if (err instanceof SyntaxError) {
                if (bytes.byteLength === 0) {
                    parsed = undefined;
                }
                else {
                    parsed = bytes.toString();
                }
            }
            else {
                throw err;
            }
        }
        if (parsed && parsed.value !== undefined) {
            console.warn("[core/json-codec]", `JsonCodec removing { value: ... } wrapper`);
            parsed = parsed.value;
        }
        return parsed;
    }
    valueToBytes(value, schema, parameters) {
        let body = "";
        if (value !== undefined) {
            body = JSON.stringify(value);
        }
        return Buffer.from(body);
    }
}
exports.default = JsonCodec;
//# sourceMappingURL=json-codec.js.map