"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class NetconfCodec {
    getMediaType() {
        return "application/netconf";
    }
    bytesToValue(bytes, schema, parameters) {
        let parsed;
        try {
            parsed = JSON.parse(bytes.toString());
        }
        catch (err) {
            if (err instanceof SyntaxError) {
                if (bytes.byteLength === 0) {
                    parsed = undefined;
                }
                else {
                    parsed = bytes.toString();
                }
            }
            else {
                throw err;
            }
        }
        if (parsed && parsed.value !== undefined) {
            console.warn("[core/netconf-codec]", `NetconfCodec removing { value: ... } wrapper`);
            parsed = parsed.value;
        }
        return parsed;
    }
    valueToBytes(value, schema, parameters) {
        let body = "";
        if (value !== undefined) {
            const NSs = {};
            const tmpObj = this.getPayloadNamespaces(schema, value, NSs, false);
            body = JSON.stringify(tmpObj);
        }
        return Buffer.from(body);
    }
    getPayloadNamespaces(schema, payload, NSs, hasNamespace) {
        if (hasNamespace) {
            const properties = schema.properties;
            if (!properties) {
                throw new Error(`Missing "properties" field in TD`);
            }
            let nsFound = false;
            let aliasNs = "";
            let value;
            for (const key in properties) {
                const el = properties[key];
                if (!payload[key]) {
                    throw new Error(`Payload is missing '${key}' field specified in TD`);
                }
                if (el["nc:attribute"] === true && payload[key]) {
                    const ns = payload[key];
                    aliasNs = ns.split(":")[ns.split(":").length - 1];
                    NSs[aliasNs] = payload[key];
                    nsFound = true;
                }
                else if (payload[key]) {
                    value = payload[key];
                }
            }
            if (!nsFound) {
                throw new Error(`Namespace not found in the payload`);
            }
            else {
                return { payload: aliasNs + "\\" + ":" + value, NSs };
            }
        }
        if (schema && schema.type && schema.type === "object" && schema.properties) {
            let tmpObj;
            if (schema.properties && schema["nc:container"]) {
                tmpObj = this.getPayloadNamespaces(schema, payload, NSs, true);
            }
            else {
                tmpObj = this.getPayloadNamespaces(schema.properties, payload, NSs, false);
            }
            payload = tmpObj.payload;
            NSs = Object.assign(Object.assign({}, NSs), tmpObj.NSs);
        }
        for (const key in schema) {
            if ((schema[key].type && schema[key].type === "object") || hasNamespace) {
                let tmpHasNamespace = false;
                if (schema[key].properties && schema[key]["nc:container"]) {
                    tmpHasNamespace = true;
                }
                const tmpObj = this.getPayloadNamespaces(schema[key], payload[key], NSs, tmpHasNamespace);
                payload[key] = tmpObj.payload;
                NSs = Object.assign(Object.assign({}, NSs), tmpObj.NSs);
            }
        }
        return { payload, NSs };
    }
}
exports.default = NetconfCodec;
//# sourceMappingURL=netconf-codec.js.map