"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const TD = __importStar(require("@node-wot/td-tools"));
const helpers_1 = __importDefault(require("./helpers"));
const content_serdes_1 = __importDefault(require("./content-serdes"));
const UriTemplate = require("uritemplate");
const interaction_output_1 = require("./interaction-output");
var Affordance;
(function (Affordance) {
    Affordance[Affordance["PropertyAffordance"] = 0] = "PropertyAffordance";
    Affordance[Affordance["ActionAffordance"] = 1] = "ActionAffordance";
    Affordance[Affordance["EventAffordance"] = 2] = "EventAffordance";
})(Affordance || (Affordance = {}));
class ConsumedThingProperty extends TD.ThingProperty {
    constructor(name, thing) {
        super();
        this.getName = () => {
            return name;
        };
        this.getThing = () => {
            return thing;
        };
    }
}
class ConsumedThingAction extends TD.ThingAction {
    constructor(name, thing) {
        super();
        this.getName = () => {
            return name;
        };
        this.getThing = () => {
            return thing;
        };
    }
}
class ConsumedThingEvent extends TD.ThingEvent {
    constructor(name, thing) {
        super();
        this.getName = () => {
            return name;
        };
        this.getThing = () => {
            return thing;
        };
    }
}
class InternalSubscription {
    constructor(thing, name) {
        this.thing = thing;
        this.name = name;
        this.active = true;
    }
}
class InternalPropertySubscription extends InternalSubscription {
    constructor(thing, name, form) {
        super(thing, name);
        this.form = form;
        this.formIndex = this.thing.properties[name].forms.indexOf(form);
    }
    stop(options) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.unobserveProperty(options);
            this.thing["observedProperties"].delete(this.name);
        });
    }
    unobserveProperty(options = {}) {
        return __awaiter(this, void 0, void 0, function* () {
            const tp = this.thing.properties[this.name];
            if (!tp) {
                throw new Error(`ConsumedThing '${this.thing.title}' does not have property ${this.name}`);
            }
            if (!options.formIndex) {
                options.formIndex = this.matchingUnsubscribeForm();
            }
            const { client, form } = this.thing.getClientFor(tp.forms, "unobserveproperty", Affordance.PropertyAffordance, options);
            if (!client) {
                throw new Error(`ConsumedThing '${this.thing.title}' did not get suitable client for ${form.href}`);
            }
            if (!form) {
                throw new Error(`ConsumedThing '${this.thing.title}' did not get suitable form`);
            }
            console.debug("[core/consumed-thing]", `ConsumedThing '${this.thing.title}' unobserving to ${form.href}`);
            yield client.unlinkResource(form);
            this.active = false;
        });
    }
    matchingUnsubscribeForm() {
        const refForm = this.thing.properties[this.name].forms[this.formIndex];
        if (Array.isArray(refForm.op) && refForm.op.includes("unobserveproperty")) {
            return this.formIndex;
        }
        const bestFormMatch = this.findFormIndexWithScoring(this.formIndex, this.thing.properties[this.name].forms, "unobserveproperty");
        if (bestFormMatch === -1) {
            throw new Error(`Could not find matching form for unsubscribe`);
        }
        return bestFormMatch;
    }
    findFormIndexWithScoring(formIndex, forms, operation) {
        const refForm = forms[formIndex];
        let maxScore = 0;
        let maxScoreIndex = -1;
        for (let i = 0; i < forms.length; i++) {
            let score = 0;
            const form = forms[i];
            if (form.op === operation || (Array.isArray(form.op) && form.op.includes(operation))) {
                score += 1;
            }
            if (new URL(form.href).origin === new URL(refForm.href).origin) {
                score += 1;
            }
            if (form.contentType === refForm.contentType) {
                score += 1;
            }
            if (score > maxScore) {
                maxScore = score;
                maxScoreIndex = i;
            }
        }
        return maxScoreIndex;
    }
}
function findFormIndexWithScoring(formIndex, forms, operation) {
    const refForm = forms[formIndex];
    let maxScore = 0;
    let maxScoreIndex = -1;
    for (let i = 0; i < forms.length; i++) {
        let score = 0;
        const form = forms[i];
        if (form.op === operation || (Array.isArray(form.op) && form.op.includes(operation))) {
            score += 1;
        }
        if (new URL(form.href).origin === new URL(refForm.href).origin) {
            score += 1;
        }
        if (form.contentType === refForm.contentType) {
            score += 1;
        }
        if (score > maxScore) {
            maxScore = score;
            maxScoreIndex = i;
        }
    }
    return maxScoreIndex;
}
class InternalEventSubscription extends InternalSubscription {
    constructor(thing, name, form) {
        super(thing, name);
        this.form = form;
        this.formIndex = this.thing.events[name].forms.indexOf(form);
    }
    stop(options) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.unsubscribeEvent(options);
            this.thing["subscribedEvents"].delete(this.name);
        });
    }
    unsubscribeEvent(options = {}) {
        return __awaiter(this, void 0, void 0, function* () {
            const te = this.thing.events[this.name];
            if (!te) {
                throw new Error(`ConsumedThing '${this.thing.title}' does not have event ${this.name}`);
            }
            if (!options.formIndex) {
                options.formIndex = this.matchingUnsubscribeForm();
            }
            const { client, form } = this.thing.getClientFor(te.forms, "unsubscribeevent", Affordance.EventAffordance, options);
            if (!client) {
                throw new Error(`ConsumedThing '${this.thing.title}' did not get suitable client for ${form.href}`);
            }
            if (!form) {
                throw new Error(`ConsumedThing '${this.thing.title}' did not get suitable form`);
            }
            console.debug("[core/consumed-thing]", `ConsumedThing '${this.thing.title}' unsubscribing to ${form.href}`);
            client.unlinkResource(form);
            this.active = false;
        });
    }
    matchingUnsubscribeForm() {
        const refForm = this.thing.events[this.name].forms[this.formIndex];
        if (!refForm.op || (Array.isArray(refForm.op) && refForm.op.includes("unsubscribeevent"))) {
            return this.formIndex;
        }
        const bestFormMatch = findFormIndexWithScoring(this.formIndex, this.thing.events[this.name].forms, "unsubscribeevent");
        if (bestFormMatch === -1) {
            throw new Error(`Could not find matching form for unsubscribe`);
        }
        return bestFormMatch;
    }
}
class ConsumedThing extends TD.Thing {
    constructor(servient, thingModel = {}) {
        super();
        this.subscribedEvents = new Map();
        this.observedProperties = new Map();
        this.getServient = () => {
            return servient;
        };
        this.getClients = new (class {
            constructor() {
                this.clients = new Map();
                this.getMap = () => {
                    return this.clients;
                };
            }
        })().getMap;
        const clonedModel = JSON.parse(JSON.stringify(thingModel));
        Object.assign(this, clonedModel);
        this.extendInteractions();
    }
    getThingDescription() {
        return JSON.parse(JSON.stringify(this));
    }
    emitEvent(name, data) {
        console.warn("[core/consumed-thing]", "not implemented");
    }
    extendInteractions() {
        for (const propertyName in this.properties) {
            const newProp = helpers_1.default.extend(this.properties[propertyName], new ConsumedThingProperty(propertyName, this));
            this.properties[propertyName] = newProp;
        }
        for (const actionName in this.actions) {
            const newAction = helpers_1.default.extend(this.actions[actionName], new ConsumedThingAction(actionName, this));
            this.actions[actionName] = newAction;
        }
        for (const eventName in this.events) {
            const newEvent = helpers_1.default.extend(this.events[eventName], new ConsumedThingEvent(eventName, this));
            this.events[eventName] = newEvent;
        }
    }
    findForm(forms, op, affordance, schemes, idx) {
        let form = null;
        for (const f of forms) {
            let fop = "";
            if (f.op !== undefined) {
                fop = f.op;
            }
            else {
                switch (affordance) {
                    case Affordance.PropertyAffordance:
                        fop = ["readproperty", "writeproperty"];
                        break;
                    case Affordance.ActionAffordance:
                        fop = "invokeaction";
                        break;
                    case Affordance.EventAffordance:
                        fop = "subscribeevent";
                        break;
                }
            }
            if (fop.indexOf(op) !== -1 && f.href.indexOf(schemes[idx] + ":") !== -1) {
                form = f;
                break;
            }
        }
        return form;
    }
    getSecuritySchemes(security) {
        const scs = [];
        for (const s of security) {
            const ws = this.securityDefinitions[s + ""];
            if (ws) {
                scs.push(ws);
            }
        }
        return scs;
    }
    ensureClientSecurity(client, form) {
        if (this.securityDefinitions) {
            if (form && Array.isArray(form.security) && form.security.length > 0) {
                console.debug("[core/consumed-thing]", `ConsumedThing '${this.title}' setting credentials for ${client} based on form security`);
                client.setSecurity(this.getSecuritySchemes(form.security), this.getServient().retrieveCredentials(this.id));
            }
            else if (this.security && Array.isArray(this.security) && this.security.length > 0) {
                console.debug("[core/consumed-thing]", `ConsumedThing '${this.title}' setting credentials for ${client} based on thing security`);
                client.setSecurity(this.getSecuritySchemes(this.security), this.getServient().getCredentials(this.id));
            }
        }
    }
    getClientFor(forms, op, affordance, options) {
        if (forms.length === 0) {
            throw new Error(`ConsumedThing '${this.title}' has no links for this interaction`);
        }
        let form;
        let client;
        if (options && options.formIndex) {
            console.debug("[core/consumed-thing]", `ConsumedThing '${this.title}' asked to use formIndex '${options.formIndex}'`);
            if (options.formIndex >= 0 && options.formIndex < forms.length) {
                form = forms[options.formIndex];
                const scheme = helpers_1.default.extractScheme(form.href);
                if (this.getServient().hasClientFor(scheme)) {
                    console.debug("[core/consumed-thing]", `ConsumedThing '${this.title}' got client for '${scheme}'`);
                    client = this.getServient().getClientFor(scheme);
                    if (!this.getClients().get(scheme)) {
                        this.ensureClientSecurity(client, form);
                        this.getClients().set(scheme, client);
                    }
                }
                else {
                    throw new Error(`ConsumedThing '${this.title}' missing ClientFactory for '${scheme}'`);
                }
            }
            else {
                throw new Error(`ConsumedThing '${this.title}' missing formIndex '${options.formIndex}'`);
            }
        }
        else {
            const schemes = forms.map((link) => helpers_1.default.extractScheme(link.href));
            const cacheIdx = schemes.findIndex((scheme) => this.getClients().has(scheme));
            if (cacheIdx !== -1) {
                console.debug("[core/consumed-thing]", `ConsumedThing '${this.title}' chose cached client for '${schemes[cacheIdx]}'`);
                client = this.getClients().get(schemes[cacheIdx]);
                form = this.findForm(forms, op, affordance, schemes, cacheIdx);
            }
            else {
                console.debug("[core/consumed-thing]", `ConsumedThing '${this.title}' has no client in cache (${cacheIdx})`);
                const srvIdx = schemes.findIndex((scheme) => this.getServient().hasClientFor(scheme));
                if (srvIdx === -1)
                    throw new Error(`ConsumedThing '${this.title}' missing ClientFactory for '${schemes}'`);
                client = this.getServient().getClientFor(schemes[srvIdx]);
                console.debug("[core/consumed-thing]", `ConsumedThing '${this.title}' got new client for '${schemes[srvIdx]}'`);
                this.ensureClientSecurity(client, form);
                this.getClients().set(schemes[srvIdx], client);
                form = this.findForm(forms, op, affordance, schemes, srvIdx);
            }
        }
        return { client: client, form: form };
    }
    readProperty(propertyName, options) {
        return __awaiter(this, void 0, void 0, function* () {
            const tp = this.properties[propertyName];
            if (!tp) {
                throw new Error(`ConsumedThing '${this.title}' does not have property ${propertyName}`);
            }
            let { client, form } = this.getClientFor(tp.forms, "readproperty", Affordance.PropertyAffordance, options);
            if (!client) {
                throw new Error(`ConsumedThing '${this.title}' did not get suitable client for ${form.href}`);
            }
            if (!form) {
                throw new Error(`ConsumedThing '${this.title}' did not get suitable form`);
            }
            console.debug("[core/consumed-thing]", `ConsumedThing '${this.title}' reading ${form.href}`);
            form = this.handleUriVariables(tp, form, options);
            const content = yield client.readResource(form);
            return new interaction_output_1.InteractionOutput(content, form, tp);
        });
    }
    _readProperties(propertyNames) {
        return __awaiter(this, void 0, void 0, function* () {
            const promises = [];
            for (const propertyName of propertyNames) {
                promises.push(this.readProperty(propertyName));
            }
            const output = new Map();
            try {
                const result = yield Promise.all(promises);
                let index = 0;
                for (const propertyName of propertyNames) {
                    output.set(propertyName, result[index]);
                    index++;
                }
                return output;
            }
            catch (err) {
                throw new Error(`ConsumedThing '${this.title}', failed to read properties: ${propertyNames}.\n Error: ${err}`);
            }
        });
    }
    readAllProperties(options) {
        const propertyNames = [];
        for (const propertyName in this.properties) {
            const tp = this.properties[propertyName];
            const { form } = this.getClientFor(tp.forms, "readproperty", Affordance.PropertyAffordance, options);
            if (form) {
                propertyNames.push(propertyName);
            }
        }
        return this._readProperties(propertyNames);
    }
    readMultipleProperties(propertyNames, options) {
        return this._readProperties(propertyNames);
    }
    writeProperty(propertyName, value, options) {
        return __awaiter(this, void 0, void 0, function* () {
            const tp = this.properties[propertyName];
            if (!tp) {
                throw new Error(`ConsumedThing '${this.title}' does not have property ${propertyName}`);
            }
            let { client, form } = this.getClientFor(tp.forms, "writeproperty", Affordance.PropertyAffordance, options);
            if (!client) {
                throw new Error(`ConsumedThing '${this.title}' did not get suitable client for ${form.href}`);
            }
            if (!form) {
                throw new Error(`ConsumedThing '${this.title}' did not get suitable form`);
            }
            console.debug("[core/consumed-thing]", `ConsumedThing '${this.title}' writing ${form.href} with '${value}'`);
            const content = content_serdes_1.default.valueToContent(value, tp, form.contentType);
            form = this.handleUriVariables(tp, form, options);
            yield client.writeResource(form, content);
        });
    }
    writeMultipleProperties(valueMap, options) {
        return __awaiter(this, void 0, void 0, function* () {
            const promises = [];
            for (const propertyName in valueMap) {
                const value = valueMap.get(propertyName);
                promises.push(this.writeProperty(propertyName, value));
            }
            try {
                yield Promise.all(promises);
            }
            catch (err) {
                throw new Error(`ConsumedThing '${this.title}', failed to write multiple propertes: ${valueMap}\n Error: ${err}`);
            }
        });
    }
    invokeAction(actionName, parameter, options) {
        return __awaiter(this, void 0, void 0, function* () {
            const ta = this.actions[actionName];
            if (!ta) {
                throw new Error(`ConsumedThing '${this.title}' does not have action ${actionName}`);
            }
            let { client, form } = this.getClientFor(ta.forms, "invokeaction", Affordance.ActionAffordance, options);
            if (!client) {
                throw new Error(`ConsumedThing '${this.title}' did not get suitable client for ${form.href}`);
            }
            if (!form) {
                throw new Error(`ConsumedThing '${this.title}' did not get suitable form`);
            }
            console.debug("[core/consumed-thing]", `ConsumedThing '${this.title}' invoking ${form.href}${parameter !== undefined ? " with '" + parameter + "'" : ""}`);
            let input;
            if (parameter !== undefined) {
                input = content_serdes_1.default.valueToContent(parameter, ta.input, form.contentType);
            }
            form = this.handleUriVariables(ta, form, options);
            const content = yield client.invokeResource(form, input);
            if (!content.type)
                content.type = form.contentType;
            if (form.response) {
                if (content.type !== form.response.contentType) {
                    throw new Error(`Unexpected type in response`);
                }
            }
            try {
                return new interaction_output_1.InteractionOutput(content, form, ta.output);
            }
            catch (_a) {
                throw new Error(`Received invalid content from Thing`);
            }
        });
    }
    observeProperty(name, listener, errorListener, options) {
        return __awaiter(this, void 0, void 0, function* () {
            const tp = this.properties[name];
            if (!tp) {
                throw new Error(`ConsumedThing '${this.title}' does not have property ${name}`);
            }
            let { client, form } = this.getClientFor(tp.forms, "observeproperty", Affordance.PropertyAffordance, options);
            if (!client) {
                throw new Error(`ConsumedThing '${this.title}' did not get suitable client for ${form.href}`);
            }
            if (!form) {
                throw new Error(`ConsumedThing '${this.title}' did not get suitable form`);
            }
            if (this.observedProperties.has(name)) {
                throw new Error(`ConsumedThing '${this.title}' has already a function subscribed to ${name}. You can only observe once`);
            }
            console.debug("[core/consumed-thing]", `ConsumedThing '${this.title}' observing to ${form.href}`);
            form = this.handleUriVariables(tp, form, options);
            yield client.subscribeResource(form, (content) => {
                if (!content.type)
                    content.type = form.contentType;
                try {
                    listener(new interaction_output_1.InteractionOutput(content, form, tp));
                }
                catch (e) {
                    console.warn("[core/consumed-thing]", "Error while processing observe event for", tp.title);
                    console.warn("[core/consumed-thing]", e);
                }
            }, (err) => {
                errorListener === null || errorListener === void 0 ? void 0 : errorListener(err);
            }, () => {
            });
            const subscription = new InternalPropertySubscription(this, name, form);
            this.observedProperties.set(name, subscription);
            return subscription;
        });
    }
    subscribeEvent(name, listener, errorListener, options) {
        return __awaiter(this, void 0, void 0, function* () {
            const te = this.events[name];
            if (!te) {
                throw new Error(`ConsumedThing '${this.title}' does not have event ${name}`);
            }
            let { client, form } = this.getClientFor(te.forms, "subscribeevent", Affordance.EventAffordance, options);
            if (!client) {
                throw new Error(`ConsumedThing '${this.title}' did not get suitable client for ${form.href}`);
            }
            if (!form) {
                throw new Error(`ConsumedThing '${this.title}' did not get suitable form`);
            }
            if (this.subscribedEvents.has(name)) {
                throw new Error(`ConsumedThing '${this.title}' has already a function subscribed to ${name}. You can only subscribe once`);
            }
            console.debug("[core/consumed-thing]", `ConsumedThing '${this.title}' subscribing to ${form.href}`);
            form = this.handleUriVariables(te, form, options);
            yield client.subscribeResource(form, (content) => {
                if (!content.type)
                    content.type = form.contentType;
                try {
                    listener(new interaction_output_1.InteractionOutput(content, form, te.data));
                }
                catch (e) {
                    console.warn("[core/consumed-thing]", "Error while processing event for", te.title);
                    console.warn("[core/consumed-thing]", e);
                }
            }, (err) => {
                errorListener === null || errorListener === void 0 ? void 0 : errorListener(err);
            }, () => {
            });
            const subscription = new InternalEventSubscription(this, name, form);
            this.subscribedEvents.set(name, subscription);
            return subscription;
        });
    }
    handleUriVariables(ti, form, options) {
        const ut = UriTemplate.parse(form.href);
        const uriVariables = helpers_1.default.parseInteractionOptions(this, ti, options).uriVariables;
        const updatedHref = ut.expand(uriVariables);
        if (updatedHref !== form.href) {
            const updForm = Object.assign({}, form);
            updForm.href = updatedHref;
            form = updForm;
            console.debug("[core/consumed-thing]", `ConsumedThing '${this.title}' update form URI to ${form.href}`);
        }
        return form;
    }
}
exports.default = ConsumedThing;
//# sourceMappingURL=consumed-thing.js.map