"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const Subject_1 = require("rxjs/Subject");
const TD = __importStar(require("@node-wot/td-tools"));
const helpers_1 = __importDefault(require("./helpers"));
const interaction_output_1 = require("./interaction-output");
const stream_1 = require("stream");
const protocol_helpers_1 = __importDefault(require("./protocol-helpers"));
const es2018_1 = require("web-streams-polyfill/ponyfill/es2018");
const core_1 = require("./core");
const content_serdes_1 = __importDefault(require("./content-serdes"));
class PropertyState {
    constructor(value = null) {
        this.value = value;
        this.listeners = [];
        this.scope = {};
        this.writeHandler = null;
        this.readHandler = null;
    }
}
class ExposedThingProperty extends TD.ThingProperty {
    constructor(name, thing) {
        super();
        this.getName = () => {
            return name;
        };
        this.getThing = () => {
            return thing;
        };
        this.getState = new (class {
            constructor() {
                this.state = new PropertyState();
                this.getInternalState = () => {
                    return this.state;
                };
            }
        })().getInternalState;
        this.readOnly = false;
        this.writeOnly = false;
        this.observable = false;
    }
}
class ActionState {
    constructor() {
        this.scope = {};
        this.handler = null;
    }
}
class ExposedThingAction extends TD.ThingAction {
    constructor(name, thing) {
        super();
        this.getName = () => {
            return name;
        };
        this.getThing = () => {
            return thing;
        };
        this.getState = new (class {
            constructor() {
                this.state = new ActionState();
                this.getInternalState = () => {
                    return this.state;
                };
            }
        })().getInternalState;
    }
}
class EventState {
    constructor(event) {
        this.event = event;
        this.legacyListeners = [];
        this.listeners = [];
    }
    registerSubscription(formIndex, listener) {
        this.listeners[formIndex] = listener;
    }
    unRegisterSubscription(formIndex, listener) {
        this.listeners[formIndex] = undefined;
    }
    emit(input, options) {
        const form = this.event.forms[options === null || options === void 0 ? void 0 : options.formIndex];
        if (form) {
            if (this.listeners[options.formIndex]) {
                const content = core_1.ContentSerdes.get().valueToContent(input, this.event, form === null || form === void 0 ? void 0 : form.contentType);
                this.listeners[options.formIndex](content);
            }
            else {
                console.warn("[core/exposed-thing]", `Event '${this.event.name}' has no listener for form '${options.formIndex}'`);
            }
            return;
        }
        for (let formIndex = 0; formIndex < this.listeners.length; formIndex++) {
            const listener = this.listeners[formIndex];
            if (listener) {
                const content = core_1.ContentSerdes.get().valueToContent(input, this.event, this.event.forms[formIndex].contentType);
                listener(content);
            }
        }
    }
}
class ExposedThingEvent extends TD.ThingEvent {
    constructor(name, thing) {
        super();
        this.getName = () => {
            return name;
        };
        this.getThing = () => {
            return thing;
        };
        this.getState = new (class {
            constructor() {
                this.state = new EventState(thing.events[name]);
                this.getInternalState = () => {
                    return this.state;
                };
            }
        })().getInternalState;
    }
}
class ExposedThing extends TD.Thing {
    constructor(servient, thingModel = {}) {
        super();
        this.__propertyHandlers = new Map();
        this.__actionHandlers = new Map();
        this.__eventHandlers = new Map();
        this.__propertyListeners = new Map();
        this.__eventListeners = new Map();
        this.getServient = () => {
            return servient;
        };
        this.getSubjectTD = new (class {
            constructor() {
                this.subjectTDChange = new Subject_1.Subject();
                this.getSubject = () => {
                    return this.subjectTDChange;
                };
            }
        })().getSubject;
        const clonedModel = JSON.parse(JSON.stringify(thingModel));
        Object.assign(this, clonedModel);
        this.addDefaultLanguage(this);
        this.extendInteractions();
    }
    addDefaultLanguage(thing) {
        if (Array.isArray(thing["@context"])) {
            const arrayContext = thing["@context"];
            let languageSet = false;
            for (const arrayEntry of arrayContext) {
                if (typeof arrayEntry === "object") {
                    if (arrayEntry["@language"] !== undefined) {
                        languageSet = true;
                    }
                }
            }
            if (!languageSet) {
                arrayContext.push({
                    "@language": TD.DEFAULT_CONTEXT_LANGUAGE,
                });
            }
        }
    }
    extendInteractions() {
        for (const propertyName in this.properties) {
            const newProp = helpers_1.default.extend(this.properties[propertyName], new ExposedThingProperty(propertyName, this));
            this.properties[propertyName] = newProp;
        }
        for (const actionName in this.actions) {
            const newAction = helpers_1.default.extend(this.actions[actionName], new ExposedThingAction(actionName, this));
            this.actions[actionName] = newAction;
        }
        for (const eventName in this.events) {
            const newEvent = helpers_1.default.extend(this.events[eventName], new ExposedThingEvent(eventName, this));
            this.events[eventName] = newEvent;
        }
    }
    getThingDescription() {
        return JSON.parse(TD.serializeTD(this), (key, value) => {
            if (key === "__propertyHandlers" ||
                key === "__actionHandlers" ||
                key === "__eventHandlers" ||
                key === "__propertyListeners" ||
                key === "__eventListeners") {
                return undefined;
            }
            return value;
        });
    }
    emitEvent(name, data) {
        if (this.events[name]) {
            const es = this.events[name].getState();
            for (const listener of es.legacyListeners) {
                listener.call(this, data);
            }
            const eventListener = this.__eventListeners.get(name);
            const formIndex = protocol_helpers_1.default.getFormIndexForOperation(this.events[name], "event", "subscribeevent");
            if (eventListener) {
                if (formIndex !== -1 && eventListener[formIndex]) {
                    if (eventListener[formIndex].length < 1) {
                        return;
                    }
                    const form = this.events[name].forms[formIndex];
                    const content = core_1.ContentSerdes.get().valueToContent(data, this.event, form.contentType);
                    eventListener[formIndex].forEach((listener) => listener(content));
                }
                else {
                    for (let formIndex = 0; formIndex < this.eventListener.length; formIndex++) {
                        const listener = this.eventListener[formIndex];
                        if (listener) {
                            const content = core_1.ContentSerdes.get().valueToContent(data, this.event, this.event.forms[formIndex].contentType);
                            listener(content);
                        }
                    }
                }
            }
        }
        else {
            throw new Error("NotFoundError for event '" + name + "'");
        }
    }
    expose() {
        console.debug("[core/exposed-thing]", `ExposedThing '${this.title}' exposing all Interactions and TD`);
        return new Promise((resolve, reject) => {
            this.getServient()
                .expose(this)
                .then(() => {
                this.getSubjectTD().next(this.getThingDescription());
                resolve();
            })
                .catch((err) => reject(err));
        });
    }
    destroy() {
        console.debug("[core/exposed-thing]", `ExposedThing '${this.title}' destroying the thing and its interactions`);
        return new Promise((resolve, reject) => {
            this.getServient()
                .destroyThing(this.id)
                .then(() => {
                this.getSubjectTD().next(null);
                resolve();
            })
                .catch((err) => reject(err));
        });
    }
    setPropertyReadHandler(propertyName, handler) {
        console.debug("[core/exposed-thing]", `ExposedThing '${this.title}' setting read handler for '${propertyName}'`);
        if (this.properties[propertyName]) {
            if (this.properties[propertyName].writeOnly) {
                throw new Error(`ExposedThing '${this.title}' cannot set read handler for property '${propertyName}' due to writeOnly flag`);
            }
            else {
                let propertyHandler;
                if (this.__propertyHandlers.has(propertyName)) {
                    propertyHandler = this.__propertyHandlers.get(propertyName);
                    propertyHandler.readHandler = handler;
                }
                else {
                    propertyHandler = { readHandler: handler };
                }
                this.__propertyHandlers.set(propertyName, propertyHandler);
            }
        }
        else {
            throw new Error(`ExposedThing '${this.title}' has no Property '${propertyName}'`);
        }
        return this;
    }
    setPropertyWriteHandler(propertyName, handler) {
        console.debug("[core/exposed-thing]", `ExposedThing '${this.title}' setting write handler for '${propertyName}'`);
        if (this.properties[propertyName]) {
            if (this.properties[propertyName].readOnly) {
                throw new Error(`ExposedThing '${this.title}' cannot set write handler for property '${propertyName}' due to readOnly flag`);
            }
            else {
                let propertyHandler;
                if (this.__propertyHandlers.has(propertyName)) {
                    propertyHandler = this.__propertyHandlers.get(propertyName);
                    propertyHandler.writeHandler = handler;
                }
                else {
                    propertyHandler = { writeHandler: handler };
                }
                this.__propertyHandlers.set(propertyName, propertyHandler);
            }
        }
        else {
            throw new Error(`ExposedThing '${this.title}' has no Property '${propertyName}'`);
        }
        return this;
    }
    setPropertyObserveHandler(name, handler) {
        console.debug("[core/exposed-thing]", `ExposedThing '${this.title}' setting property observe handler for '${name}'`);
        if (this.properties[name]) {
            if (!this.properties[name].observable) {
                throw new Error(`ExposedThing '${this.title}' cannot set observe handler for property '${name}' since the observable flag is set to false`);
            }
            else {
                let propertyHandler;
                if (this.__propertyHandlers.has(name)) {
                    propertyHandler = this.__propertyHandlers.get(name);
                    propertyHandler.observeHandler = handler;
                }
                else {
                    propertyHandler = { observeHandler: handler };
                }
                this.__propertyHandlers.set(name, propertyHandler);
            }
        }
        else {
            throw new Error(`ExposedThing '${this.title}' has no Property '${name}'`);
        }
        return this;
    }
    setPropertyUnobserveHandler(name, handler) {
        console.debug("[core/exposed-thing]", `ExposedThing '${this.title}' setting property unobserve handler for '${name}'`);
        if (this.properties[name]) {
            if (!this.properties[name].observable) {
                throw new Error(`ExposedThing '${this.title}' cannot set unobserve handler for property '${name}' due to missing observable flag`);
            }
            else {
                let propertyHandler;
                if (this.__propertyHandlers.has(name)) {
                    propertyHandler = this.__propertyHandlers.get(name);
                    propertyHandler.unobserveHandler = handler;
                }
                else {
                    propertyHandler = { unobserveHandler: handler };
                }
                this.__propertyHandlers.set(name, propertyHandler);
            }
        }
        else {
            throw new Error(`ExposedThing '${this.title}' has no Property '${name}'`);
        }
        return this;
    }
    setActionHandler(actionName, handler) {
        console.debug("[core/exposed-thing]", `ExposedThing '${this.title}' setting action handler for '${actionName}'`);
        if (this.actions[actionName]) {
            this.__actionHandlers.set(actionName, handler);
        }
        else {
            throw new Error(`ExposedThing '${this.title}' has no Action '${actionName}'`);
        }
        return this;
    }
    setEventSubscribeHandler(name, handler) {
        console.debug("[core/exposed-thing]", `ExposedThing '${this.title}' setting event subscribe handler for '${name}'`);
        if (this.events[name]) {
            let eventHandler;
            if (this.__eventHandlers.has(name)) {
                eventHandler = this.__eventHandlers.get(name);
                eventHandler.subscribe = handler;
            }
            else {
                eventHandler = { subscribe: handler };
            }
            this.__eventHandlers.set(name, eventHandler);
        }
        else {
            throw new Error(`ExposedThing '${this.title}' has no Event '${name}'`);
        }
        return this;
    }
    setEventUnsubscribeHandler(name, handler) {
        console.debug("[core/exposed-thing]", `ExposedThing '${this.title}' setting event unsubscribe handler for '${name}'`);
        if (this.events[name]) {
            let eventHandler;
            if (this.__eventHandlers.has(name)) {
                eventHandler = this.__eventHandlers.get(name);
                eventHandler.unsubscribe = handler;
            }
            else {
                eventHandler = { unsubscribe: handler };
            }
            this.__eventHandlers.set(name, eventHandler);
        }
        else {
            throw new Error(`ExposedThing '${this.title}' has no Event '${name}'`);
        }
        return this;
    }
    setEventHandler(name, handler) {
        console.debug("[core/exposed-thing]", `ExposedThing '${this.title}' setting event handler for '${name}'`);
        if (this.events[name]) {
            let eventHandler;
            if (this.__eventHandlers.has(name)) {
                eventHandler = this.__eventHandlers.get(name);
                eventHandler.handler = handler;
            }
            else {
                eventHandler = { handler: handler };
            }
            this.__eventHandlers.set(name, eventHandler);
        }
        else {
            throw new Error(`ExposedThing '${this.title}' has no Event '${name}'`);
        }
        return this;
    }
    readProperty(propertyName, options) {
        return new Promise((resolve, reject) => {
            if (this.properties[propertyName]) {
                const ps = this.properties[propertyName].getState();
                if (ps.readHandler != null) {
                    console.debug("[core/exposed-thing]", `ExposedThing '${this.title}' calls registered readHandler for Property '${propertyName}'`);
                    ps.readHandler(options)
                        .then((customValue) => {
                        const body = ExposedThing.interactionInputToReadable(customValue);
                        const c = { body: body, type: "application/json" };
                        resolve(new interaction_output_1.InteractionOutput(c, undefined, this.properties[propertyName]));
                    })
                        .catch((err) => {
                        reject(err);
                    });
                }
                else {
                    console.debug("[core/exposed-thing]", `ExposedThing '${this.title}' gets internal value '${ps.value}' for Property '${propertyName}'`);
                    const body = ExposedThing.interactionInputToReadable(ps.value);
                    resolve(new interaction_output_1.InteractionOutput({ body, type: "application/json" }, undefined, this.properties[propertyName]));
                }
            }
            else {
                reject(new Error(`ExposedThing '${this.title}', no property found for '${propertyName}'`));
            }
        });
    }
    _readProperties(propertyNames, options) {
        return new Promise((resolve, reject) => {
            const promises = [];
            for (const propertyName of propertyNames) {
                promises.push(this.readProperty(propertyName, options));
            }
            const output = new Map();
            Promise.all(promises)
                .then((result) => {
                let index = 0;
                for (const propertyName of propertyNames) {
                    output.set(propertyName, result[index]);
                    index++;
                }
                resolve(output);
            })
                .catch((err) => {
                reject(new Error(`ConsumedThing '${this.title}', failed to read properties: ${propertyNames}.\n Error: ${err}`));
            });
        });
    }
    readAllProperties(options) {
        const propertyNames = [];
        for (const propertyName in this.properties) {
            propertyNames.push(propertyName);
        }
        return this._readProperties(propertyNames, options);
    }
    readMultipleProperties(propertyNames, options) {
        return this._readProperties(propertyNames, options);
    }
    writeProperty(propertyName, value, options) {
        return new Promise((resolve, reject) => {
            if (this.properties[propertyName]) {
                const ps = this.properties[propertyName].getState();
                if (ps.writeHandler != null) {
                    const body = ExposedThing.interactionInputToReadable(value);
                    const content = { body: body, type: "application/json" };
                    const promiseOrValueOrNil = ps.writeHandler(new interaction_output_1.InteractionOutput(content, {}, this.properties[propertyName]), options);
                    if (promiseOrValueOrNil !== undefined) {
                        if (typeof promiseOrValueOrNil.then === "function") {
                            promiseOrValueOrNil
                                .then((customValue) => {
                                console.debug("[core/exposed-thing]", `ExposedThing '${this.title}' write handler for Property '${propertyName}' sets custom value '${customValue}'`);
                                if (ps.value !== value) {
                                    for (const listener of ps.listeners) {
                                        listener.call(value);
                                    }
                                }
                                resolve();
                            })
                                .catch((customError) => {
                                console.warn("[core/exposed-thing]", `ExposedThing '${this.title}' write handler for Property '${propertyName}' rejected the write with error '${customError}'`);
                                reject(customError);
                            });
                        }
                        else {
                            console.warn("[core/exposed-thing]", `ExposedThing '${this.title}' write handler for Property '${propertyName}' does not return promise`);
                            if (ps.value !== promiseOrValueOrNil) {
                                for (const listener of ps.listeners) {
                                    listener.call(promiseOrValueOrNil);
                                }
                            }
                            resolve();
                        }
                    }
                    else {
                        console.warn("[core/exposed-thing]", `ExposedThing '${this.title}' write handler for Property '${propertyName}' does not return custom value, using direct value '${value}'`);
                        if (ps.value !== value) {
                            for (const listener of ps.listeners) {
                                listener.call(value);
                            }
                        }
                        resolve();
                    }
                }
                else {
                    console.debug("[core/exposed-thing]", `ExposedThing '${this.title}' directly sets Property '${propertyName}' to value '${value}'`);
                    if (ps.value !== value) {
                        for (const listener of ps.listeners) {
                            listener.call(value);
                        }
                    }
                    resolve();
                }
            }
            else {
                reject(new Error(`ExposedThing '${this.title}', no property found for '${propertyName}'`));
            }
        });
    }
    writeMultipleProperties(valueMap, options) {
        return new Promise((resolve, reject) => {
            const promises = [];
            for (const propertyName in valueMap) {
                promises.push(this.writeProperty(propertyName, valueMap.get(propertyName), options));
            }
            Promise.all(promises)
                .then((result) => {
                resolve();
            })
                .catch((err) => {
                reject(new Error(`ExposedThing '${this.title}', failed to write multiple properties. ${err.message}`));
            });
        });
    }
    invokeAction(actionName, parameter, options) {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.actions[actionName]) {
                console.debug("[core/exposed-thing]", `ExposedThing '${this.title}' has Action state of '${actionName}'`);
                const as = this.actions[actionName].getState();
                if (as.handler != null) {
                    console.debug("[core/exposed-thing]", `ExposedThing '${this.title}' calls registered handler for Action '${actionName}'`);
                    let bodyInput;
                    if (parameter) {
                        bodyInput = ExposedThing.interactionInputToReadable(parameter);
                    }
                    const cInput = { body: bodyInput, type: "application/json" };
                    const result = yield as.handler(new interaction_output_1.InteractionOutput(cInput, undefined, this.actions[actionName].input), options);
                    let bodyOutput;
                    if (result) {
                        bodyOutput = ExposedThing.interactionInputToReadable(result);
                    }
                    const cOutput = { body: bodyOutput, type: "application/json" };
                    return new interaction_output_1.InteractionOutput(cOutput, undefined, this.actions[actionName].output);
                }
                else {
                    throw new Error(`ExposedThing '${this.title}' has no handler for Action '${actionName}'`);
                }
            }
            else {
                throw new Error(`ExposedThing '${this.title}', no action found for '${actionName}'`);
            }
        });
    }
    observeProperty(name, listener, options) {
        return new Promise((resolve, reject) => {
            if (this.properties[name]) {
                const ps = this.properties[name].getState();
                ps.listeners.push(listener);
                console.debug("[core/exposed-thing]", `ExposedThing '${this.title}' subscribes to property '${name}'`);
            }
            else {
                reject(new Error(`ExposedThing '${this.title}', no property found for '${name}'`));
            }
        });
    }
    unobserveProperty(name) {
        return new Promise((resolve, reject) => {
            if (this.properties[name]) {
                console.debug("[core/exposed-thing]", `ExposedThing '${this.title}' unsubscribes from property '${name}'`);
            }
            else {
                reject(new Error(`ExposedThing '${this.title}', no property found for '${name}'`));
            }
        });
    }
    subscribeEvent(name, listener, options) {
        return new Promise((resolve, reject) => {
            if (this.events[name]) {
                const es = this.events[name].getState();
                es.legacyListeners.push(listener);
                console.debug("[core/exposed-thing]", `ExposedThing '${this.title}' subscribes to event '${name}'`);
            }
            else {
                reject(new Error(`ExposedThing '${this.title}', no event found for '${name}'`));
            }
        });
    }
    unsubscribeEvent(name) {
        return new Promise((resolve, reject) => {
            if (this.events[name]) {
                console.debug("[core/exposed-thing]", `ExposedThing '${this.title}' unsubscribes from event '${name}'`);
            }
            else {
                reject(new Error(`ExposedThing '${this.title}', no event found for '${name}'`));
            }
        });
    }
    handleInvokeAction(name, inputContent, options) {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.actions[name]) {
                console.debug("[core/exposed-thing]", `ExposedThing '${this.title}' has Action state of '${name}'`);
                const handler = this.__actionHandlers.get(name);
                if (handler != null) {
                    console.debug("[core/exposed-thing]", `ExposedThing '${this.title}' calls registered handler for Action '${name}'`);
                    helpers_1.default.validateInteractionOptions(this, this.actions[name], options);
                    const form = this.actions[name].forms
                        ? this.actions[name].forms[options.formIndex]
                        : { contentType: "application/json" };
                    const result = yield handler(new interaction_output_1.InteractionOutput(inputContent, form, this.actions[name].input), options);
                    if (result) {
                        return content_serdes_1.default.valueToContent(result, this.actions[name].output, form.contentType);
                    }
                }
                else {
                    throw new Error(`ExposedThing '${this.title}' has no handler for Action '${name}'`);
                }
            }
            else {
                throw new Error(`ExposedThing '${this.title}', no action found for '${name}'`);
            }
        });
    }
    handleReadProperty(propertyName, options) {
        var _a, _b;
        return __awaiter(this, void 0, void 0, function* () {
            if (this.properties[propertyName]) {
                console.debug("[core/exposed-thing]", `ExposedThing '${this.title}' has Action state of '${propertyName}'`);
                const readHandler = (_a = this.__propertyHandlers.get(propertyName)) === null || _a === void 0 ? void 0 : _a.readHandler;
                if (readHandler != null) {
                    console.debug("[core/exposed-thing]", `ExposedThing '${this.title}' calls registered readHandler for Property '${propertyName}'`);
                    helpers_1.default.validateInteractionOptions(this, this.properties[propertyName], options);
                    const result = yield readHandler(options);
                    const form = this.properties[propertyName].forms
                        ? this.properties[propertyName].forms[options.formIndex]
                        : { contentType: "application/json" };
                    return content_serdes_1.default.valueToContent(result, this.properties[propertyName], (_b = form === null || form === void 0 ? void 0 : form.contentType) !== null && _b !== void 0 ? _b : "application/json");
                }
                else {
                    throw new Error(`ExposedThing '${this.title}' has no readHandler for Property '${propertyName}'`);
                }
            }
            else {
                throw new Error(`ExposedThing '${this.title}', no property found for '${propertyName}'`);
            }
        });
    }
    _handleReadProperties(propertyNames, options) {
        return __awaiter(this, void 0, void 0, function* () {
            const promises = [];
            for (const propertyName of propertyNames) {
                const form = this.properties[propertyName].forms.find((form) => form.contentType === "application/json" || !form.contentType);
                if (!form) {
                    continue;
                }
                promises.push(this.handleReadProperty(propertyName, options));
            }
            try {
                const output = new Map();
                const results = yield Promise.all(promises);
                for (let i = 0; i < results.length; i++) {
                    output.set(propertyNames[i], results[i]);
                }
                return output;
            }
            catch (error) {
                throw new Error(`ConsumedThing '${this.title}', failed to read properties: ${propertyNames}.\n Error: ${error}`);
            }
        });
    }
    handleReadAllProperties(options) {
        return __awaiter(this, void 0, void 0, function* () {
            const propertyNames = [];
            for (const propertyName in this.properties) {
                propertyNames.push(propertyName);
            }
            return yield this._handleReadProperties(propertyNames, options);
        });
    }
    handleReadMultipleProperties(propertyNames, options) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this._handleReadProperties(propertyNames, options);
        });
    }
    handleWriteProperty(propertyName, inputContent, options) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            if (this.properties[propertyName]) {
                if (this.properties[propertyName].readOnly && this.properties[propertyName].readOnly === true) {
                    throw new Error(`ExposedThing '${this.title}', property '${propertyName}' is readOnly`);
                }
                helpers_1.default.validateInteractionOptions(this, this.properties[propertyName], options);
                const writeHandler = (_a = this.__propertyHandlers.get(propertyName)) === null || _a === void 0 ? void 0 : _a.writeHandler;
                const form = this.properties[propertyName].forms
                    ? this.properties[propertyName].forms[options.formIndex]
                    : {};
                if (writeHandler != null) {
                    yield writeHandler(new interaction_output_1.InteractionOutput(inputContent, form, this.properties[propertyName]), options);
                }
                else {
                    throw new Error(`ExposedThing '${this.title}' has no writeHandler for Property '${propertyName}'`);
                }
            }
            else {
                throw new Error(`ExposedThing '${this.title}', no property found for '${propertyName}'`);
            }
        });
    }
    handleWriteMultipleProperties(valueMap, options) {
        return __awaiter(this, void 0, void 0, function* () {
            const promises = [];
            for (const propertyName in valueMap) {
                const form = this.properties[propertyName].forms.find((form) => form.contentType === "application/json" || !form.contentType);
                if (!form) {
                    continue;
                }
                promises.push(this.handleWriteProperty(propertyName, valueMap.get(propertyName), options));
            }
            try {
                yield Promise.all(promises);
            }
            catch (error) {
                throw new Error(`ExposedThing '${this.title}', failed to write multiple properties. ${error.message}`);
            }
        });
    }
    handleSubscribeEvent(name, listener, options) {
        var _a, _b;
        return __awaiter(this, void 0, void 0, function* () {
            if (this.events[name]) {
                const eventListener = (_a = this.__eventListeners.get(name)) !== null && _a !== void 0 ? _a : {};
                const formIndex = protocol_helpers_1.default.getFormIndexForOperation(this.events[name], "event", "subscribeevent", options.formIndex);
                if (formIndex !== -1) {
                    if (!eventListener[formIndex])
                        eventListener[formIndex] = [];
                    eventListener[formIndex].push(listener);
                    this.__eventListeners.set(name, eventListener);
                    console.debug("[core/exposed-thing]", `ExposedThing '${this.title}' subscribes to event '${name}'`);
                }
                else {
                    throw new Error(`ExposedThing '${this.title}', no property listener from found for '${name}' with form index '${options.formIndex}'`);
                }
                helpers_1.default.validateInteractionOptions(this, this.events[name], options);
                const subscribe = (_b = this.__eventHandlers.get(name)) === null || _b === void 0 ? void 0 : _b.subscribe;
                if (subscribe) {
                    subscribe(options);
                }
                console.debug("[core/exposed-thing]", `ExposedThing '${this.title}' subscribes to event '${name}'`);
            }
            else {
                throw new Error(`ExposedThing '${this.title}', no event found for '${name}'`);
            }
        });
    }
    handleUnsubscribeEvent(name, listener, options) {
        var _a, _b;
        if (this.events[name]) {
            const eventListener = (_a = this.__eventListeners.get(name)) !== null && _a !== void 0 ? _a : {};
            const formIndex = protocol_helpers_1.default.getFormIndexForOperation(this.events[name], "event", "unsubscribeevent", options.formIndex);
            if (formIndex !== -1 && eventListener[formIndex] && eventListener[formIndex].indexOf(listener) !== -1) {
                eventListener[formIndex].splice(eventListener[formIndex].indexOf(listener), 1);
                this.__eventListeners.set(name, eventListener);
            }
            else {
                throw new Error(`ExposedThing '${this.title}', no event listener from found for '${name}' with form index '${options.formIndex}'`);
            }
            helpers_1.default.validateInteractionOptions(this, this.events[name], options);
            const unsubscribe = (_b = this.__eventHandlers.get(name)) === null || _b === void 0 ? void 0 : _b.unsubscribe;
            if (unsubscribe) {
                unsubscribe(options);
            }
            console.debug("[core/exposed-thing]", `ExposedThing '${this.title}' unsubscribes from event '${name}'`);
        }
        else {
            throw new Error(`ExposedThing '${this.title}', no event found for '${name}'`);
        }
    }
    handleObserveProperty(name, listener, options) {
        var _a, _b;
        return __awaiter(this, void 0, void 0, function* () {
            if (this.properties[name]) {
                const propertyListener = (_a = this.__propertyListeners.get(name)) !== null && _a !== void 0 ? _a : {};
                const formIndex = protocol_helpers_1.default.getFormIndexForOperation(this.properties[name], "property", "observeproperty", options.formIndex);
                if (formIndex !== -1) {
                    if (!propertyListener[formIndex])
                        propertyListener[formIndex] = [];
                    propertyListener[formIndex].push(listener);
                    this.__propertyListeners.set(name, propertyListener);
                    console.debug("[core/exposed-thing]", `ExposedThing '${this.title}' subscribes to property '${name}'`);
                }
                else {
                    throw new Error(`ExposedThing '${this.title}', no property listener from found for '${name}' with form index '${options.formIndex}'`);
                }
                helpers_1.default.validateInteractionOptions(this, this.properties[name], options);
                const observeHandler = (_b = this.__propertyHandlers.get(name)) === null || _b === void 0 ? void 0 : _b.observeHandler;
                if (observeHandler) {
                    observeHandler(options);
                }
            }
            else {
                throw new Error(`ExposedThing '${this.title}', no property found for '${name}'`);
            }
        });
    }
    handleUnobserveProperty(name, listener, options) {
        var _a, _b;
        if (this.properties[name]) {
            const propertyListener = (_a = this.__propertyListeners.get(name)) !== null && _a !== void 0 ? _a : {};
            const formIndex = protocol_helpers_1.default.getFormIndexForOperation(this.properties[name], "property", "unobserveproperty", options.formIndex);
            if (formIndex !== -1 &&
                propertyListener[formIndex] &&
                propertyListener[formIndex].indexOf(listener) !== -1) {
                propertyListener[formIndex].splice(propertyListener[formIndex].indexOf(listener), 1);
                this.__propertyListeners.set(name, propertyListener);
            }
            else {
                throw new Error(`ExposedThing '${this.title}', no property listener from found for '${name}' with form index '${options.formIndex}'`);
            }
            helpers_1.default.validateInteractionOptions(this, this.properties[name], options);
            const unobserveHandler = (_b = this.__propertyHandlers.get(name)) === null || _b === void 0 ? void 0 : _b.unobserveHandler;
            if (unobserveHandler) {
                unobserveHandler(options);
            }
        }
        else {
            throw new Error(`ExposedThing '${this.title}', no property found for '${name}'`);
        }
    }
    static interactionInputToReadable(input) {
        let body;
        if (typeof ReadableStream !== "undefined" && input instanceof ReadableStream) {
            body = protocol_helpers_1.default.toNodeStream(input);
        }
        else if (input instanceof es2018_1.ReadableStream) {
            body = protocol_helpers_1.default.toNodeStream(input);
        }
        else if (Array.isArray(input) || typeof input === "object") {
            body = stream_1.Readable.from(Buffer.from(JSON.stringify(input), "utf-8"));
        }
        else {
            body = stream_1.Readable.from(Buffer.from(input.toString(), "utf-8"));
        }
        return body;
    }
}
exports.default = ExposedThing;
//# sourceMappingURL=exposed-thing.js.map