"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.InteractionOutput = void 0;
const util = __importStar(require("util"));
const content_serdes_1 = require("./content-serdes");
const core_1 = require("./core");
const errors_1 = require("./errors");
const ajv_1 = __importDefault(require("ajv"));
const ajv = new ajv_1.default({ strict: false });
class InteractionOutput {
    constructor(content, form, schema) {
        this.content = content;
        this.form = form;
        this.schema = schema;
        if (content && content.body) {
            this.data = core_1.ProtocolHelpers.toWoTStream(content.body);
        }
    }
    arrayBuffer() {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.buffer) {
                return this.buffer;
            }
            const data = yield core_1.ProtocolHelpers.readStreamFully(this.content.body);
            this.dataUsed = true;
            this.buffer = data;
            return data;
        });
    }
    value() {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.parsedValue)
                return this.parsedValue;
            if (!this.schema) {
                throw new errors_1.NotReadableError("Cannot read value: missing schema");
            }
            const validate = ajv.compile(this.schema);
            if (!this.form || !content_serdes_1.ContentSerdes.get().isSupported(this.content.type)) {
                const message = !this.form ? "Missing form" : `Content type ${this.content.type} not supported`;
                throw new errors_1.NotSupportedError(message);
            }
            const data = yield core_1.ProtocolHelpers.readStreamFully(this.content.body);
            this.dataUsed = true;
            this.buffer = data;
            const value = content_serdes_1.ContentSerdes.get().contentToValue({ type: this.content.type, body: data }, this.schema);
            if (!validate(value)) {
                console.debug("[core]", "schema = ", util.inspect(this.schema, { depth: 10, colors: true }));
                console.debug("[core]", "value: ", value);
                console.debug("[core]", "Errror: ", validate.errors);
                throw new errors_1.DataSchemaError("Invalid value according to DataSchema", value);
            }
            this.parsedValue = value;
            return value;
        });
    }
}
exports.InteractionOutput = InteractionOutput;
//# sourceMappingURL=interaction-output.js.map