/// <reference types="node" />
import * as TD from "@node-wot/td-tools";
import { Readable } from "stream";
import { ReadableStream as PolyfillStream } from "web-streams-polyfill/ponyfill/es2018";
export interface IManagedStream {
    nodeStream: Readable;
    wotStream: ReadableStream;
}
export default class ProtocolHelpers {
    static updatePropertyFormWithTemplate(form: TD.Form, tdTemplate: WoT.ExposedThingInit, propertyName: string): void;
    static updateActionFormWithTemplate(form: TD.Form, tdTemplate: WoT.ExposedThingInit, actionName: string): void;
    static updateEventFormWithTemplate(form: TD.Form, tdTemplate: WoT.ExposedThingInit, eventName: string): void;
    static getPropertyContentType(td: WoT.ThingDescription, propertyName: string, uriScheme: string): string;
    static getActionContentType(td: WoT.ThingDescription, actionName: string, uriScheme: string): string;
    static getEventContentType(td: WoT.ThingDescription, eventName: string, uriScheme: string): string;
    static toWoTStream(stream: NodeJS.ReadableStream | IManagedStream): ReadableStream | PolyfillStream;
    static toNodeStream(stream: ReadableStream | PolyfillStream | IManagedStream | Readable): Readable;
    static readStreamFully(stream: NodeJS.ReadableStream): Promise<Buffer>;
    static findRequestMatchingFormIndex(forms: TD.Form[] | undefined, uriScheme: string, requestUrl: string | undefined, contentType?: string): number;
    static getFormIndexForOperation(interaction: TD.ThingInteraction, type: "property" | "action" | "event", operationName?: string, formIndex?: number): number;
}
