import { CompilerFunction } from "vm2";
import * as WoT from "wot-typescript-definitions";
import ExposedThing from "./exposed-thing";
import { ProtocolClientFactory, ProtocolServer, ProtocolClient } from "./protocol-interfaces";
import { ContentCodec } from "./content-serdes";
export interface ScriptOptions {
    argv?: Array<string>;
    compiler?: CompilerFunction;
    env?: Record<string, string>;
}
export default class Servient {
    private servers;
    private clientFactories;
    private things;
    private credentialStore;
    private uncaughtListeners;
    runScript(code: string, filename?: string): unknown;
    runPrivilegedScript(code: string, filename?: string, options?: ScriptOptions): unknown;
    private logScriptError;
    addMediaType(codec: ContentCodec, offered?: boolean): void;
    expose(thing: ExposedThing): Promise<void>;
    addThing(thing: ExposedThing): boolean;
    destroyThing(thingId: string): Promise<boolean>;
    getThing(id: string): ExposedThing;
    getThings(): Record<string, WoT.ThingDescription>;
    addServer(server: ProtocolServer): boolean;
    getServers(): Array<ProtocolServer>;
    addClientFactory(clientFactory: ProtocolClientFactory): void;
    hasClientFor(scheme: string): boolean;
    getClientFor(scheme: string): ProtocolClient;
    getClientSchemes(): string[];
    addCredentials(credentials: Record<string, unknown>): void;
    getCredentials(identifier: string): unknown;
    retrieveCredentials(identifier: string): Array<unknown>;
    start(): Promise<typeof WoT>;
    shutdown(): Promise<void>;
}
