"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataType = exports.DiscoveryMethod = exports.ThingDiscoveryImpl = void 0;
const TD = __importStar(require("@node-wot/td-tools"));
const exposed_thing_1 = __importDefault(require("./exposed-thing"));
const consumed_thing_1 = __importDefault(require("./consumed-thing"));
const helpers_1 = __importDefault(require("./helpers"));
class ThingDiscoveryImpl {
    constructor(filter) {
        this.filter = filter || null;
        this.active = false;
        this.done = false;
        this.error = new Error("not implemented");
    }
    start() {
        this.active = true;
    }
    next() {
        return new Promise((resolve, reject) => {
            reject(this.error);
        });
    }
    stop() {
        this.active = false;
        this.done = false;
    }
}
exports.ThingDiscoveryImpl = ThingDiscoveryImpl;
class WoTImpl {
    constructor(srv) {
        this.srv = srv;
    }
    discover(filter) {
        return new ThingDiscoveryImpl(filter);
    }
    consume(td) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const thing = TD.parseTD(JSON.stringify(td), true);
                const newThing = new consumed_thing_1.default(this.srv, thing);
                console.debug("[core/wot-impl]", `WoTImpl consuming TD ${newThing.id ? "'" + newThing.id + "'" : "without id"} to instantiate ConsumedThing '${newThing.title}'`);
                return newThing;
            }
            catch (err) {
                throw new Error("Cannot consume TD because " + err.message);
            }
        });
    }
    produce(init) {
        return new Promise((resolve, reject) => {
            try {
                const validated = helpers_1.default.validateExposedThingInit(init);
                if (!validated.valid) {
                    throw new Error("Thing Description JSON schema validation failed:\n" + validated.errors);
                }
                const newThing = new exposed_thing_1.default(this.srv, init);
                console.debug("[core/servient]", `WoTImpl producing new ExposedThing '${newThing.title}'`);
                if (this.srv.addThing(newThing)) {
                    resolve(newThing);
                }
                else {
                    throw new Error("Thing already exists: " + newThing.title);
                }
            }
            catch (err) {
                reject(new Error("Cannot produce ExposedThing because " + err.message));
            }
        });
    }
}
exports.default = WoTImpl;
var DiscoveryMethod;
(function (DiscoveryMethod) {
    DiscoveryMethod[DiscoveryMethod["any"] = 0] = "any";
    DiscoveryMethod[DiscoveryMethod["local"] = 1] = "local";
    DiscoveryMethod[DiscoveryMethod["directory"] = 2] = "directory";
    DiscoveryMethod[DiscoveryMethod["multicast"] = 3] = "multicast";
})(DiscoveryMethod = exports.DiscoveryMethod || (exports.DiscoveryMethod = {}));
var DataType;
(function (DataType) {
    DataType["boolean"] = "boolean";
    DataType["number"] = "number";
    DataType["integer"] = "integer";
    DataType["string"] = "string";
    DataType["object"] = "object";
    DataType["array"] = "array";
    DataType["null"] = "null";
})(DataType = exports.DataType || (exports.DataType = {}));
//# sourceMappingURL=wot-impl.js.map