// Code generated by entc, DO NOT EDIT.

package ent

import (
	"context"
	"fmt"
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/bouncer"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/predicate"
)

// BouncerUpdate is the builder for updating Bouncer entities.
type BouncerUpdate struct {
	config
	hooks    []Hook
	mutation *BouncerMutation
}

// Where appends a list predicates to the BouncerUpdate builder.
func (bu *BouncerUpdate) Where(ps ...predicate.Bouncer) *BouncerUpdate {
	bu.mutation.Where(ps...)
	return bu
}

// SetCreatedAt sets the "created_at" field.
func (bu *BouncerUpdate) SetCreatedAt(t time.Time) *BouncerUpdate {
	bu.mutation.SetCreatedAt(t)
	return bu
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (bu *BouncerUpdate) SetNillableCreatedAt(t *time.Time) *BouncerUpdate {
	if t != nil {
		bu.SetCreatedAt(*t)
	}
	return bu
}

// SetUpdatedAt sets the "updated_at" field.
func (bu *BouncerUpdate) SetUpdatedAt(t time.Time) *BouncerUpdate {
	bu.mutation.SetUpdatedAt(t)
	return bu
}

// SetNillableUpdatedAt sets the "updated_at" field if the given value is not nil.
func (bu *BouncerUpdate) SetNillableUpdatedAt(t *time.Time) *BouncerUpdate {
	if t != nil {
		bu.SetUpdatedAt(*t)
	}
	return bu
}

// SetName sets the "name" field.
func (bu *BouncerUpdate) SetName(s string) *BouncerUpdate {
	bu.mutation.SetName(s)
	return bu
}

// SetAPIKey sets the "api_key" field.
func (bu *BouncerUpdate) SetAPIKey(s string) *BouncerUpdate {
	bu.mutation.SetAPIKey(s)
	return bu
}

// SetRevoked sets the "revoked" field.
func (bu *BouncerUpdate) SetRevoked(b bool) *BouncerUpdate {
	bu.mutation.SetRevoked(b)
	return bu
}

// SetIPAddress sets the "ip_address" field.
func (bu *BouncerUpdate) SetIPAddress(s string) *BouncerUpdate {
	bu.mutation.SetIPAddress(s)
	return bu
}

// SetNillableIPAddress sets the "ip_address" field if the given value is not nil.
func (bu *BouncerUpdate) SetNillableIPAddress(s *string) *BouncerUpdate {
	if s != nil {
		bu.SetIPAddress(*s)
	}
	return bu
}

// ClearIPAddress clears the value of the "ip_address" field.
func (bu *BouncerUpdate) ClearIPAddress() *BouncerUpdate {
	bu.mutation.ClearIPAddress()
	return bu
}

// SetType sets the "type" field.
func (bu *BouncerUpdate) SetType(s string) *BouncerUpdate {
	bu.mutation.SetType(s)
	return bu
}

// SetNillableType sets the "type" field if the given value is not nil.
func (bu *BouncerUpdate) SetNillableType(s *string) *BouncerUpdate {
	if s != nil {
		bu.SetType(*s)
	}
	return bu
}

// ClearType clears the value of the "type" field.
func (bu *BouncerUpdate) ClearType() *BouncerUpdate {
	bu.mutation.ClearType()
	return bu
}

// SetVersion sets the "version" field.
func (bu *BouncerUpdate) SetVersion(s string) *BouncerUpdate {
	bu.mutation.SetVersion(s)
	return bu
}

// SetNillableVersion sets the "version" field if the given value is not nil.
func (bu *BouncerUpdate) SetNillableVersion(s *string) *BouncerUpdate {
	if s != nil {
		bu.SetVersion(*s)
	}
	return bu
}

// ClearVersion clears the value of the "version" field.
func (bu *BouncerUpdate) ClearVersion() *BouncerUpdate {
	bu.mutation.ClearVersion()
	return bu
}

// SetUntil sets the "until" field.
func (bu *BouncerUpdate) SetUntil(t time.Time) *BouncerUpdate {
	bu.mutation.SetUntil(t)
	return bu
}

// SetNillableUntil sets the "until" field if the given value is not nil.
func (bu *BouncerUpdate) SetNillableUntil(t *time.Time) *BouncerUpdate {
	if t != nil {
		bu.SetUntil(*t)
	}
	return bu
}

// ClearUntil clears the value of the "until" field.
func (bu *BouncerUpdate) ClearUntil() *BouncerUpdate {
	bu.mutation.ClearUntil()
	return bu
}

// SetLastPull sets the "last_pull" field.
func (bu *BouncerUpdate) SetLastPull(t time.Time) *BouncerUpdate {
	bu.mutation.SetLastPull(t)
	return bu
}

// SetNillableLastPull sets the "last_pull" field if the given value is not nil.
func (bu *BouncerUpdate) SetNillableLastPull(t *time.Time) *BouncerUpdate {
	if t != nil {
		bu.SetLastPull(*t)
	}
	return bu
}

// Mutation returns the BouncerMutation object of the builder.
func (bu *BouncerUpdate) Mutation() *BouncerMutation {
	return bu.mutation
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (bu *BouncerUpdate) Save(ctx context.Context) (int, error) {
	var (
		err      error
		affected int
	)
	if len(bu.hooks) == 0 {
		affected, err = bu.sqlSave(ctx)
	} else {
		var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
			mutation, ok := m.(*BouncerMutation)
			if !ok {
				return nil, fmt.Errorf("unexpected mutation type %T", m)
			}
			bu.mutation = mutation
			affected, err = bu.sqlSave(ctx)
			mutation.done = true
			return affected, err
		})
		for i := len(bu.hooks) - 1; i >= 0; i-- {
			if bu.hooks[i] == nil {
				return 0, fmt.Errorf("ent: uninitialized hook (forgotten import ent/runtime?)")
			}
			mut = bu.hooks[i](mut)
		}
		if _, err := mut.Mutate(ctx, bu.mutation); err != nil {
			return 0, err
		}
	}
	return affected, err
}

// SaveX is like Save, but panics if an error occurs.
func (bu *BouncerUpdate) SaveX(ctx context.Context) int {
	affected, err := bu.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (bu *BouncerUpdate) Exec(ctx context.Context) error {
	_, err := bu.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (bu *BouncerUpdate) ExecX(ctx context.Context) {
	if err := bu.Exec(ctx); err != nil {
		panic(err)
	}
}

func (bu *BouncerUpdate) sqlSave(ctx context.Context) (n int, err error) {
	_spec := &sqlgraph.UpdateSpec{
		Node: &sqlgraph.NodeSpec{
			Table:   bouncer.Table,
			Columns: bouncer.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: bouncer.FieldID,
			},
		},
	}
	if ps := bu.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := bu.mutation.CreatedAt(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeTime,
			Value:  value,
			Column: bouncer.FieldCreatedAt,
		})
	}
	if value, ok := bu.mutation.UpdatedAt(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeTime,
			Value:  value,
			Column: bouncer.FieldUpdatedAt,
		})
	}
	if value, ok := bu.mutation.Name(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: bouncer.FieldName,
		})
	}
	if value, ok := bu.mutation.APIKey(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: bouncer.FieldAPIKey,
		})
	}
	if value, ok := bu.mutation.Revoked(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeBool,
			Value:  value,
			Column: bouncer.FieldRevoked,
		})
	}
	if value, ok := bu.mutation.IPAddress(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: bouncer.FieldIPAddress,
		})
	}
	if bu.mutation.IPAddressCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Column: bouncer.FieldIPAddress,
		})
	}
	if value, ok := bu.mutation.GetType(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: bouncer.FieldType,
		})
	}
	if bu.mutation.TypeCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Column: bouncer.FieldType,
		})
	}
	if value, ok := bu.mutation.Version(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: bouncer.FieldVersion,
		})
	}
	if bu.mutation.VersionCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Column: bouncer.FieldVersion,
		})
	}
	if value, ok := bu.mutation.Until(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeTime,
			Value:  value,
			Column: bouncer.FieldUntil,
		})
	}
	if bu.mutation.UntilCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeTime,
			Column: bouncer.FieldUntil,
		})
	}
	if value, ok := bu.mutation.LastPull(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeTime,
			Value:  value,
			Column: bouncer.FieldLastPull,
		})
	}
	if n, err = sqlgraph.UpdateNodes(ctx, bu.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{bouncer.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{err.Error(), err}
		}
		return 0, err
	}
	return n, nil
}

// BouncerUpdateOne is the builder for updating a single Bouncer entity.
type BouncerUpdateOne struct {
	config
	fields   []string
	hooks    []Hook
	mutation *BouncerMutation
}

// SetCreatedAt sets the "created_at" field.
func (buo *BouncerUpdateOne) SetCreatedAt(t time.Time) *BouncerUpdateOne {
	buo.mutation.SetCreatedAt(t)
	return buo
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (buo *BouncerUpdateOne) SetNillableCreatedAt(t *time.Time) *BouncerUpdateOne {
	if t != nil {
		buo.SetCreatedAt(*t)
	}
	return buo
}

// SetUpdatedAt sets the "updated_at" field.
func (buo *BouncerUpdateOne) SetUpdatedAt(t time.Time) *BouncerUpdateOne {
	buo.mutation.SetUpdatedAt(t)
	return buo
}

// SetNillableUpdatedAt sets the "updated_at" field if the given value is not nil.
func (buo *BouncerUpdateOne) SetNillableUpdatedAt(t *time.Time) *BouncerUpdateOne {
	if t != nil {
		buo.SetUpdatedAt(*t)
	}
	return buo
}

// SetName sets the "name" field.
func (buo *BouncerUpdateOne) SetName(s string) *BouncerUpdateOne {
	buo.mutation.SetName(s)
	return buo
}

// SetAPIKey sets the "api_key" field.
func (buo *BouncerUpdateOne) SetAPIKey(s string) *BouncerUpdateOne {
	buo.mutation.SetAPIKey(s)
	return buo
}

// SetRevoked sets the "revoked" field.
func (buo *BouncerUpdateOne) SetRevoked(b bool) *BouncerUpdateOne {
	buo.mutation.SetRevoked(b)
	return buo
}

// SetIPAddress sets the "ip_address" field.
func (buo *BouncerUpdateOne) SetIPAddress(s string) *BouncerUpdateOne {
	buo.mutation.SetIPAddress(s)
	return buo
}

// SetNillableIPAddress sets the "ip_address" field if the given value is not nil.
func (buo *BouncerUpdateOne) SetNillableIPAddress(s *string) *BouncerUpdateOne {
	if s != nil {
		buo.SetIPAddress(*s)
	}
	return buo
}

// ClearIPAddress clears the value of the "ip_address" field.
func (buo *BouncerUpdateOne) ClearIPAddress() *BouncerUpdateOne {
	buo.mutation.ClearIPAddress()
	return buo
}

// SetType sets the "type" field.
func (buo *BouncerUpdateOne) SetType(s string) *BouncerUpdateOne {
	buo.mutation.SetType(s)
	return buo
}

// SetNillableType sets the "type" field if the given value is not nil.
func (buo *BouncerUpdateOne) SetNillableType(s *string) *BouncerUpdateOne {
	if s != nil {
		buo.SetType(*s)
	}
	return buo
}

// ClearType clears the value of the "type" field.
func (buo *BouncerUpdateOne) ClearType() *BouncerUpdateOne {
	buo.mutation.ClearType()
	return buo
}

// SetVersion sets the "version" field.
func (buo *BouncerUpdateOne) SetVersion(s string) *BouncerUpdateOne {
	buo.mutation.SetVersion(s)
	return buo
}

// SetNillableVersion sets the "version" field if the given value is not nil.
func (buo *BouncerUpdateOne) SetNillableVersion(s *string) *BouncerUpdateOne {
	if s != nil {
		buo.SetVersion(*s)
	}
	return buo
}

// ClearVersion clears the value of the "version" field.
func (buo *BouncerUpdateOne) ClearVersion() *BouncerUpdateOne {
	buo.mutation.ClearVersion()
	return buo
}

// SetUntil sets the "until" field.
func (buo *BouncerUpdateOne) SetUntil(t time.Time) *BouncerUpdateOne {
	buo.mutation.SetUntil(t)
	return buo
}

// SetNillableUntil sets the "until" field if the given value is not nil.
func (buo *BouncerUpdateOne) SetNillableUntil(t *time.Time) *BouncerUpdateOne {
	if t != nil {
		buo.SetUntil(*t)
	}
	return buo
}

// ClearUntil clears the value of the "until" field.
func (buo *BouncerUpdateOne) ClearUntil() *BouncerUpdateOne {
	buo.mutation.ClearUntil()
	return buo
}

// SetLastPull sets the "last_pull" field.
func (buo *BouncerUpdateOne) SetLastPull(t time.Time) *BouncerUpdateOne {
	buo.mutation.SetLastPull(t)
	return buo
}

// SetNillableLastPull sets the "last_pull" field if the given value is not nil.
func (buo *BouncerUpdateOne) SetNillableLastPull(t *time.Time) *BouncerUpdateOne {
	if t != nil {
		buo.SetLastPull(*t)
	}
	return buo
}

// Mutation returns the BouncerMutation object of the builder.
func (buo *BouncerUpdateOne) Mutation() *BouncerMutation {
	return buo.mutation
}

// Select allows selecting one or more fields (columns) of the returned entity.
// The default is selecting all fields defined in the entity schema.
func (buo *BouncerUpdateOne) Select(field string, fields ...string) *BouncerUpdateOne {
	buo.fields = append([]string{field}, fields...)
	return buo
}

// Save executes the query and returns the updated Bouncer entity.
func (buo *BouncerUpdateOne) Save(ctx context.Context) (*Bouncer, error) {
	var (
		err  error
		node *Bouncer
	)
	if len(buo.hooks) == 0 {
		node, err = buo.sqlSave(ctx)
	} else {
		var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
			mutation, ok := m.(*BouncerMutation)
			if !ok {
				return nil, fmt.Errorf("unexpected mutation type %T", m)
			}
			buo.mutation = mutation
			node, err = buo.sqlSave(ctx)
			mutation.done = true
			return node, err
		})
		for i := len(buo.hooks) - 1; i >= 0; i-- {
			if buo.hooks[i] == nil {
				return nil, fmt.Errorf("ent: uninitialized hook (forgotten import ent/runtime?)")
			}
			mut = buo.hooks[i](mut)
		}
		if _, err := mut.Mutate(ctx, buo.mutation); err != nil {
			return nil, err
		}
	}
	return node, err
}

// SaveX is like Save, but panics if an error occurs.
func (buo *BouncerUpdateOne) SaveX(ctx context.Context) *Bouncer {
	node, err := buo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (buo *BouncerUpdateOne) Exec(ctx context.Context) error {
	_, err := buo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (buo *BouncerUpdateOne) ExecX(ctx context.Context) {
	if err := buo.Exec(ctx); err != nil {
		panic(err)
	}
}

func (buo *BouncerUpdateOne) sqlSave(ctx context.Context) (_node *Bouncer, err error) {
	_spec := &sqlgraph.UpdateSpec{
		Node: &sqlgraph.NodeSpec{
			Table:   bouncer.Table,
			Columns: bouncer.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: bouncer.FieldID,
			},
		},
	}
	id, ok := buo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "ID", err: fmt.Errorf("missing Bouncer.ID for update")}
	}
	_spec.Node.ID.Value = id
	if fields := buo.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, bouncer.FieldID)
		for _, f := range fields {
			if !bouncer.ValidColumn(f) {
				return nil, &ValidationError{Name: f, err: fmt.Errorf("ent: invalid field %q for query", f)}
			}
			if f != bouncer.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, f)
			}
		}
	}
	if ps := buo.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := buo.mutation.CreatedAt(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeTime,
			Value:  value,
			Column: bouncer.FieldCreatedAt,
		})
	}
	if value, ok := buo.mutation.UpdatedAt(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeTime,
			Value:  value,
			Column: bouncer.FieldUpdatedAt,
		})
	}
	if value, ok := buo.mutation.Name(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: bouncer.FieldName,
		})
	}
	if value, ok := buo.mutation.APIKey(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: bouncer.FieldAPIKey,
		})
	}
	if value, ok := buo.mutation.Revoked(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeBool,
			Value:  value,
			Column: bouncer.FieldRevoked,
		})
	}
	if value, ok := buo.mutation.IPAddress(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: bouncer.FieldIPAddress,
		})
	}
	if buo.mutation.IPAddressCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Column: bouncer.FieldIPAddress,
		})
	}
	if value, ok := buo.mutation.GetType(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: bouncer.FieldType,
		})
	}
	if buo.mutation.TypeCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Column: bouncer.FieldType,
		})
	}
	if value, ok := buo.mutation.Version(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: bouncer.FieldVersion,
		})
	}
	if buo.mutation.VersionCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Column: bouncer.FieldVersion,
		})
	}
	if value, ok := buo.mutation.Until(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeTime,
			Value:  value,
			Column: bouncer.FieldUntil,
		})
	}
	if buo.mutation.UntilCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeTime,
			Column: bouncer.FieldUntil,
		})
	}
	if value, ok := buo.mutation.LastPull(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeTime,
			Value:  value,
			Column: bouncer.FieldLastPull,
		})
	}
	_node = &Bouncer{config: buo.config}
	_spec.Assign = _node.assignValues
	_spec.ScanValues = _node.scanValues
	if err = sqlgraph.UpdateNode(ctx, buo.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{bouncer.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{err.Error(), err}
		}
		return nil, err
	}
	return _node, nil
}
