// Code generated by entc, DO NOT EDIT.

package decision

import (
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/predicate"
)

// ID filters vertices based on their ID field.
func ID(id int) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldID), id))
	})
}

// IDEQ applies the EQ predicate on the ID field.
func IDEQ(id int) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldID), id))
	})
}

// IDNEQ applies the NEQ predicate on the ID field.
func IDNEQ(id int) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldID), id))
	})
}

// IDIn applies the In predicate on the ID field.
func IDIn(ids ...int) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(ids) == 0 {
			s.Where(sql.False())
			return
		}
		v := make([]interface{}, len(ids))
		for i := range v {
			v[i] = ids[i]
		}
		s.Where(sql.In(s.C(FieldID), v...))
	})
}

// IDNotIn applies the NotIn predicate on the ID field.
func IDNotIn(ids ...int) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(ids) == 0 {
			s.Where(sql.False())
			return
		}
		v := make([]interface{}, len(ids))
		for i := range v {
			v[i] = ids[i]
		}
		s.Where(sql.NotIn(s.C(FieldID), v...))
	})
}

// IDGT applies the GT predicate on the ID field.
func IDGT(id int) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldID), id))
	})
}

// IDGTE applies the GTE predicate on the ID field.
func IDGTE(id int) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldID), id))
	})
}

// IDLT applies the LT predicate on the ID field.
func IDLT(id int) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldID), id))
	})
}

// IDLTE applies the LTE predicate on the ID field.
func IDLTE(id int) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldID), id))
	})
}

// CreatedAt applies equality check predicate on the "created_at" field. It's identical to CreatedAtEQ.
func CreatedAt(v time.Time) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldCreatedAt), v))
	})
}

// UpdatedAt applies equality check predicate on the "updated_at" field. It's identical to UpdatedAtEQ.
func UpdatedAt(v time.Time) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldUpdatedAt), v))
	})
}

// Until applies equality check predicate on the "until" field. It's identical to UntilEQ.
func Until(v time.Time) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldUntil), v))
	})
}

// Scenario applies equality check predicate on the "scenario" field. It's identical to ScenarioEQ.
func Scenario(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldScenario), v))
	})
}

// Type applies equality check predicate on the "type" field. It's identical to TypeEQ.
func Type(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldType), v))
	})
}

// StartIP applies equality check predicate on the "start_ip" field. It's identical to StartIPEQ.
func StartIP(v int64) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldStartIP), v))
	})
}

// EndIP applies equality check predicate on the "end_ip" field. It's identical to EndIPEQ.
func EndIP(v int64) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldEndIP), v))
	})
}

// StartSuffix applies equality check predicate on the "start_suffix" field. It's identical to StartSuffixEQ.
func StartSuffix(v int64) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldStartSuffix), v))
	})
}

// EndSuffix applies equality check predicate on the "end_suffix" field. It's identical to EndSuffixEQ.
func EndSuffix(v int64) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldEndSuffix), v))
	})
}

// IPSize applies equality check predicate on the "ip_size" field. It's identical to IPSizeEQ.
func IPSize(v int64) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldIPSize), v))
	})
}

// Scope applies equality check predicate on the "scope" field. It's identical to ScopeEQ.
func Scope(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldScope), v))
	})
}

// Value applies equality check predicate on the "value" field. It's identical to ValueEQ.
func Value(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldValue), v))
	})
}

// Origin applies equality check predicate on the "origin" field. It's identical to OriginEQ.
func Origin(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldOrigin), v))
	})
}

// Simulated applies equality check predicate on the "simulated" field. It's identical to SimulatedEQ.
func Simulated(v bool) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldSimulated), v))
	})
}

// CreatedAtEQ applies the EQ predicate on the "created_at" field.
func CreatedAtEQ(v time.Time) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldCreatedAt), v))
	})
}

// CreatedAtNEQ applies the NEQ predicate on the "created_at" field.
func CreatedAtNEQ(v time.Time) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldCreatedAt), v))
	})
}

// CreatedAtIn applies the In predicate on the "created_at" field.
func CreatedAtIn(vs ...time.Time) predicate.Decision {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.Decision(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.In(s.C(FieldCreatedAt), v...))
	})
}

// CreatedAtNotIn applies the NotIn predicate on the "created_at" field.
func CreatedAtNotIn(vs ...time.Time) predicate.Decision {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.Decision(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.NotIn(s.C(FieldCreatedAt), v...))
	})
}

// CreatedAtGT applies the GT predicate on the "created_at" field.
func CreatedAtGT(v time.Time) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldCreatedAt), v))
	})
}

// CreatedAtGTE applies the GTE predicate on the "created_at" field.
func CreatedAtGTE(v time.Time) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldCreatedAt), v))
	})
}

// CreatedAtLT applies the LT predicate on the "created_at" field.
func CreatedAtLT(v time.Time) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldCreatedAt), v))
	})
}

// CreatedAtLTE applies the LTE predicate on the "created_at" field.
func CreatedAtLTE(v time.Time) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldCreatedAt), v))
	})
}

// CreatedAtIsNil applies the IsNil predicate on the "created_at" field.
func CreatedAtIsNil() predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldCreatedAt)))
	})
}

// CreatedAtNotNil applies the NotNil predicate on the "created_at" field.
func CreatedAtNotNil() predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldCreatedAt)))
	})
}

// UpdatedAtEQ applies the EQ predicate on the "updated_at" field.
func UpdatedAtEQ(v time.Time) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldUpdatedAt), v))
	})
}

// UpdatedAtNEQ applies the NEQ predicate on the "updated_at" field.
func UpdatedAtNEQ(v time.Time) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldUpdatedAt), v))
	})
}

// UpdatedAtIn applies the In predicate on the "updated_at" field.
func UpdatedAtIn(vs ...time.Time) predicate.Decision {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.Decision(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.In(s.C(FieldUpdatedAt), v...))
	})
}

// UpdatedAtNotIn applies the NotIn predicate on the "updated_at" field.
func UpdatedAtNotIn(vs ...time.Time) predicate.Decision {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.Decision(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.NotIn(s.C(FieldUpdatedAt), v...))
	})
}

// UpdatedAtGT applies the GT predicate on the "updated_at" field.
func UpdatedAtGT(v time.Time) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldUpdatedAt), v))
	})
}

// UpdatedAtGTE applies the GTE predicate on the "updated_at" field.
func UpdatedAtGTE(v time.Time) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldUpdatedAt), v))
	})
}

// UpdatedAtLT applies the LT predicate on the "updated_at" field.
func UpdatedAtLT(v time.Time) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldUpdatedAt), v))
	})
}

// UpdatedAtLTE applies the LTE predicate on the "updated_at" field.
func UpdatedAtLTE(v time.Time) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldUpdatedAt), v))
	})
}

// UpdatedAtIsNil applies the IsNil predicate on the "updated_at" field.
func UpdatedAtIsNil() predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldUpdatedAt)))
	})
}

// UpdatedAtNotNil applies the NotNil predicate on the "updated_at" field.
func UpdatedAtNotNil() predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldUpdatedAt)))
	})
}

// UntilEQ applies the EQ predicate on the "until" field.
func UntilEQ(v time.Time) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldUntil), v))
	})
}

// UntilNEQ applies the NEQ predicate on the "until" field.
func UntilNEQ(v time.Time) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldUntil), v))
	})
}

// UntilIn applies the In predicate on the "until" field.
func UntilIn(vs ...time.Time) predicate.Decision {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.Decision(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.In(s.C(FieldUntil), v...))
	})
}

// UntilNotIn applies the NotIn predicate on the "until" field.
func UntilNotIn(vs ...time.Time) predicate.Decision {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.Decision(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.NotIn(s.C(FieldUntil), v...))
	})
}

// UntilGT applies the GT predicate on the "until" field.
func UntilGT(v time.Time) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldUntil), v))
	})
}

// UntilGTE applies the GTE predicate on the "until" field.
func UntilGTE(v time.Time) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldUntil), v))
	})
}

// UntilLT applies the LT predicate on the "until" field.
func UntilLT(v time.Time) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldUntil), v))
	})
}

// UntilLTE applies the LTE predicate on the "until" field.
func UntilLTE(v time.Time) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldUntil), v))
	})
}

// ScenarioEQ applies the EQ predicate on the "scenario" field.
func ScenarioEQ(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldScenario), v))
	})
}

// ScenarioNEQ applies the NEQ predicate on the "scenario" field.
func ScenarioNEQ(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldScenario), v))
	})
}

// ScenarioIn applies the In predicate on the "scenario" field.
func ScenarioIn(vs ...string) predicate.Decision {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.Decision(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.In(s.C(FieldScenario), v...))
	})
}

// ScenarioNotIn applies the NotIn predicate on the "scenario" field.
func ScenarioNotIn(vs ...string) predicate.Decision {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.Decision(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.NotIn(s.C(FieldScenario), v...))
	})
}

// ScenarioGT applies the GT predicate on the "scenario" field.
func ScenarioGT(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldScenario), v))
	})
}

// ScenarioGTE applies the GTE predicate on the "scenario" field.
func ScenarioGTE(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldScenario), v))
	})
}

// ScenarioLT applies the LT predicate on the "scenario" field.
func ScenarioLT(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldScenario), v))
	})
}

// ScenarioLTE applies the LTE predicate on the "scenario" field.
func ScenarioLTE(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldScenario), v))
	})
}

// ScenarioContains applies the Contains predicate on the "scenario" field.
func ScenarioContains(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.Contains(s.C(FieldScenario), v))
	})
}

// ScenarioHasPrefix applies the HasPrefix predicate on the "scenario" field.
func ScenarioHasPrefix(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.HasPrefix(s.C(FieldScenario), v))
	})
}

// ScenarioHasSuffix applies the HasSuffix predicate on the "scenario" field.
func ScenarioHasSuffix(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.HasSuffix(s.C(FieldScenario), v))
	})
}

// ScenarioEqualFold applies the EqualFold predicate on the "scenario" field.
func ScenarioEqualFold(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.EqualFold(s.C(FieldScenario), v))
	})
}

// ScenarioContainsFold applies the ContainsFold predicate on the "scenario" field.
func ScenarioContainsFold(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.ContainsFold(s.C(FieldScenario), v))
	})
}

// TypeEQ applies the EQ predicate on the "type" field.
func TypeEQ(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldType), v))
	})
}

// TypeNEQ applies the NEQ predicate on the "type" field.
func TypeNEQ(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldType), v))
	})
}

// TypeIn applies the In predicate on the "type" field.
func TypeIn(vs ...string) predicate.Decision {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.Decision(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.In(s.C(FieldType), v...))
	})
}

// TypeNotIn applies the NotIn predicate on the "type" field.
func TypeNotIn(vs ...string) predicate.Decision {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.Decision(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.NotIn(s.C(FieldType), v...))
	})
}

// TypeGT applies the GT predicate on the "type" field.
func TypeGT(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldType), v))
	})
}

// TypeGTE applies the GTE predicate on the "type" field.
func TypeGTE(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldType), v))
	})
}

// TypeLT applies the LT predicate on the "type" field.
func TypeLT(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldType), v))
	})
}

// TypeLTE applies the LTE predicate on the "type" field.
func TypeLTE(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldType), v))
	})
}

// TypeContains applies the Contains predicate on the "type" field.
func TypeContains(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.Contains(s.C(FieldType), v))
	})
}

// TypeHasPrefix applies the HasPrefix predicate on the "type" field.
func TypeHasPrefix(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.HasPrefix(s.C(FieldType), v))
	})
}

// TypeHasSuffix applies the HasSuffix predicate on the "type" field.
func TypeHasSuffix(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.HasSuffix(s.C(FieldType), v))
	})
}

// TypeEqualFold applies the EqualFold predicate on the "type" field.
func TypeEqualFold(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.EqualFold(s.C(FieldType), v))
	})
}

// TypeContainsFold applies the ContainsFold predicate on the "type" field.
func TypeContainsFold(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.ContainsFold(s.C(FieldType), v))
	})
}

// StartIPEQ applies the EQ predicate on the "start_ip" field.
func StartIPEQ(v int64) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldStartIP), v))
	})
}

// StartIPNEQ applies the NEQ predicate on the "start_ip" field.
func StartIPNEQ(v int64) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldStartIP), v))
	})
}

// StartIPIn applies the In predicate on the "start_ip" field.
func StartIPIn(vs ...int64) predicate.Decision {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.Decision(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.In(s.C(FieldStartIP), v...))
	})
}

// StartIPNotIn applies the NotIn predicate on the "start_ip" field.
func StartIPNotIn(vs ...int64) predicate.Decision {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.Decision(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.NotIn(s.C(FieldStartIP), v...))
	})
}

// StartIPGT applies the GT predicate on the "start_ip" field.
func StartIPGT(v int64) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldStartIP), v))
	})
}

// StartIPGTE applies the GTE predicate on the "start_ip" field.
func StartIPGTE(v int64) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldStartIP), v))
	})
}

// StartIPLT applies the LT predicate on the "start_ip" field.
func StartIPLT(v int64) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldStartIP), v))
	})
}

// StartIPLTE applies the LTE predicate on the "start_ip" field.
func StartIPLTE(v int64) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldStartIP), v))
	})
}

// StartIPIsNil applies the IsNil predicate on the "start_ip" field.
func StartIPIsNil() predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldStartIP)))
	})
}

// StartIPNotNil applies the NotNil predicate on the "start_ip" field.
func StartIPNotNil() predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldStartIP)))
	})
}

// EndIPEQ applies the EQ predicate on the "end_ip" field.
func EndIPEQ(v int64) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldEndIP), v))
	})
}

// EndIPNEQ applies the NEQ predicate on the "end_ip" field.
func EndIPNEQ(v int64) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldEndIP), v))
	})
}

// EndIPIn applies the In predicate on the "end_ip" field.
func EndIPIn(vs ...int64) predicate.Decision {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.Decision(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.In(s.C(FieldEndIP), v...))
	})
}

// EndIPNotIn applies the NotIn predicate on the "end_ip" field.
func EndIPNotIn(vs ...int64) predicate.Decision {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.Decision(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.NotIn(s.C(FieldEndIP), v...))
	})
}

// EndIPGT applies the GT predicate on the "end_ip" field.
func EndIPGT(v int64) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldEndIP), v))
	})
}

// EndIPGTE applies the GTE predicate on the "end_ip" field.
func EndIPGTE(v int64) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldEndIP), v))
	})
}

// EndIPLT applies the LT predicate on the "end_ip" field.
func EndIPLT(v int64) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldEndIP), v))
	})
}

// EndIPLTE applies the LTE predicate on the "end_ip" field.
func EndIPLTE(v int64) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldEndIP), v))
	})
}

// EndIPIsNil applies the IsNil predicate on the "end_ip" field.
func EndIPIsNil() predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldEndIP)))
	})
}

// EndIPNotNil applies the NotNil predicate on the "end_ip" field.
func EndIPNotNil() predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldEndIP)))
	})
}

// StartSuffixEQ applies the EQ predicate on the "start_suffix" field.
func StartSuffixEQ(v int64) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldStartSuffix), v))
	})
}

// StartSuffixNEQ applies the NEQ predicate on the "start_suffix" field.
func StartSuffixNEQ(v int64) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldStartSuffix), v))
	})
}

// StartSuffixIn applies the In predicate on the "start_suffix" field.
func StartSuffixIn(vs ...int64) predicate.Decision {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.Decision(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.In(s.C(FieldStartSuffix), v...))
	})
}

// StartSuffixNotIn applies the NotIn predicate on the "start_suffix" field.
func StartSuffixNotIn(vs ...int64) predicate.Decision {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.Decision(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.NotIn(s.C(FieldStartSuffix), v...))
	})
}

// StartSuffixGT applies the GT predicate on the "start_suffix" field.
func StartSuffixGT(v int64) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldStartSuffix), v))
	})
}

// StartSuffixGTE applies the GTE predicate on the "start_suffix" field.
func StartSuffixGTE(v int64) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldStartSuffix), v))
	})
}

// StartSuffixLT applies the LT predicate on the "start_suffix" field.
func StartSuffixLT(v int64) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldStartSuffix), v))
	})
}

// StartSuffixLTE applies the LTE predicate on the "start_suffix" field.
func StartSuffixLTE(v int64) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldStartSuffix), v))
	})
}

// StartSuffixIsNil applies the IsNil predicate on the "start_suffix" field.
func StartSuffixIsNil() predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldStartSuffix)))
	})
}

// StartSuffixNotNil applies the NotNil predicate on the "start_suffix" field.
func StartSuffixNotNil() predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldStartSuffix)))
	})
}

// EndSuffixEQ applies the EQ predicate on the "end_suffix" field.
func EndSuffixEQ(v int64) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldEndSuffix), v))
	})
}

// EndSuffixNEQ applies the NEQ predicate on the "end_suffix" field.
func EndSuffixNEQ(v int64) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldEndSuffix), v))
	})
}

// EndSuffixIn applies the In predicate on the "end_suffix" field.
func EndSuffixIn(vs ...int64) predicate.Decision {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.Decision(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.In(s.C(FieldEndSuffix), v...))
	})
}

// EndSuffixNotIn applies the NotIn predicate on the "end_suffix" field.
func EndSuffixNotIn(vs ...int64) predicate.Decision {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.Decision(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.NotIn(s.C(FieldEndSuffix), v...))
	})
}

// EndSuffixGT applies the GT predicate on the "end_suffix" field.
func EndSuffixGT(v int64) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldEndSuffix), v))
	})
}

// EndSuffixGTE applies the GTE predicate on the "end_suffix" field.
func EndSuffixGTE(v int64) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldEndSuffix), v))
	})
}

// EndSuffixLT applies the LT predicate on the "end_suffix" field.
func EndSuffixLT(v int64) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldEndSuffix), v))
	})
}

// EndSuffixLTE applies the LTE predicate on the "end_suffix" field.
func EndSuffixLTE(v int64) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldEndSuffix), v))
	})
}

// EndSuffixIsNil applies the IsNil predicate on the "end_suffix" field.
func EndSuffixIsNil() predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldEndSuffix)))
	})
}

// EndSuffixNotNil applies the NotNil predicate on the "end_suffix" field.
func EndSuffixNotNil() predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldEndSuffix)))
	})
}

// IPSizeEQ applies the EQ predicate on the "ip_size" field.
func IPSizeEQ(v int64) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldIPSize), v))
	})
}

// IPSizeNEQ applies the NEQ predicate on the "ip_size" field.
func IPSizeNEQ(v int64) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldIPSize), v))
	})
}

// IPSizeIn applies the In predicate on the "ip_size" field.
func IPSizeIn(vs ...int64) predicate.Decision {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.Decision(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.In(s.C(FieldIPSize), v...))
	})
}

// IPSizeNotIn applies the NotIn predicate on the "ip_size" field.
func IPSizeNotIn(vs ...int64) predicate.Decision {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.Decision(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.NotIn(s.C(FieldIPSize), v...))
	})
}

// IPSizeGT applies the GT predicate on the "ip_size" field.
func IPSizeGT(v int64) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldIPSize), v))
	})
}

// IPSizeGTE applies the GTE predicate on the "ip_size" field.
func IPSizeGTE(v int64) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldIPSize), v))
	})
}

// IPSizeLT applies the LT predicate on the "ip_size" field.
func IPSizeLT(v int64) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldIPSize), v))
	})
}

// IPSizeLTE applies the LTE predicate on the "ip_size" field.
func IPSizeLTE(v int64) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldIPSize), v))
	})
}

// IPSizeIsNil applies the IsNil predicate on the "ip_size" field.
func IPSizeIsNil() predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldIPSize)))
	})
}

// IPSizeNotNil applies the NotNil predicate on the "ip_size" field.
func IPSizeNotNil() predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldIPSize)))
	})
}

// ScopeEQ applies the EQ predicate on the "scope" field.
func ScopeEQ(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldScope), v))
	})
}

// ScopeNEQ applies the NEQ predicate on the "scope" field.
func ScopeNEQ(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldScope), v))
	})
}

// ScopeIn applies the In predicate on the "scope" field.
func ScopeIn(vs ...string) predicate.Decision {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.Decision(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.In(s.C(FieldScope), v...))
	})
}

// ScopeNotIn applies the NotIn predicate on the "scope" field.
func ScopeNotIn(vs ...string) predicate.Decision {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.Decision(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.NotIn(s.C(FieldScope), v...))
	})
}

// ScopeGT applies the GT predicate on the "scope" field.
func ScopeGT(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldScope), v))
	})
}

// ScopeGTE applies the GTE predicate on the "scope" field.
func ScopeGTE(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldScope), v))
	})
}

// ScopeLT applies the LT predicate on the "scope" field.
func ScopeLT(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldScope), v))
	})
}

// ScopeLTE applies the LTE predicate on the "scope" field.
func ScopeLTE(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldScope), v))
	})
}

// ScopeContains applies the Contains predicate on the "scope" field.
func ScopeContains(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.Contains(s.C(FieldScope), v))
	})
}

// ScopeHasPrefix applies the HasPrefix predicate on the "scope" field.
func ScopeHasPrefix(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.HasPrefix(s.C(FieldScope), v))
	})
}

// ScopeHasSuffix applies the HasSuffix predicate on the "scope" field.
func ScopeHasSuffix(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.HasSuffix(s.C(FieldScope), v))
	})
}

// ScopeEqualFold applies the EqualFold predicate on the "scope" field.
func ScopeEqualFold(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.EqualFold(s.C(FieldScope), v))
	})
}

// ScopeContainsFold applies the ContainsFold predicate on the "scope" field.
func ScopeContainsFold(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.ContainsFold(s.C(FieldScope), v))
	})
}

// ValueEQ applies the EQ predicate on the "value" field.
func ValueEQ(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldValue), v))
	})
}

// ValueNEQ applies the NEQ predicate on the "value" field.
func ValueNEQ(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldValue), v))
	})
}

// ValueIn applies the In predicate on the "value" field.
func ValueIn(vs ...string) predicate.Decision {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.Decision(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.In(s.C(FieldValue), v...))
	})
}

// ValueNotIn applies the NotIn predicate on the "value" field.
func ValueNotIn(vs ...string) predicate.Decision {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.Decision(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.NotIn(s.C(FieldValue), v...))
	})
}

// ValueGT applies the GT predicate on the "value" field.
func ValueGT(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldValue), v))
	})
}

// ValueGTE applies the GTE predicate on the "value" field.
func ValueGTE(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldValue), v))
	})
}

// ValueLT applies the LT predicate on the "value" field.
func ValueLT(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldValue), v))
	})
}

// ValueLTE applies the LTE predicate on the "value" field.
func ValueLTE(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldValue), v))
	})
}

// ValueContains applies the Contains predicate on the "value" field.
func ValueContains(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.Contains(s.C(FieldValue), v))
	})
}

// ValueHasPrefix applies the HasPrefix predicate on the "value" field.
func ValueHasPrefix(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.HasPrefix(s.C(FieldValue), v))
	})
}

// ValueHasSuffix applies the HasSuffix predicate on the "value" field.
func ValueHasSuffix(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.HasSuffix(s.C(FieldValue), v))
	})
}

// ValueEqualFold applies the EqualFold predicate on the "value" field.
func ValueEqualFold(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.EqualFold(s.C(FieldValue), v))
	})
}

// ValueContainsFold applies the ContainsFold predicate on the "value" field.
func ValueContainsFold(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.ContainsFold(s.C(FieldValue), v))
	})
}

// OriginEQ applies the EQ predicate on the "origin" field.
func OriginEQ(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldOrigin), v))
	})
}

// OriginNEQ applies the NEQ predicate on the "origin" field.
func OriginNEQ(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldOrigin), v))
	})
}

// OriginIn applies the In predicate on the "origin" field.
func OriginIn(vs ...string) predicate.Decision {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.Decision(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.In(s.C(FieldOrigin), v...))
	})
}

// OriginNotIn applies the NotIn predicate on the "origin" field.
func OriginNotIn(vs ...string) predicate.Decision {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.Decision(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.NotIn(s.C(FieldOrigin), v...))
	})
}

// OriginGT applies the GT predicate on the "origin" field.
func OriginGT(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldOrigin), v))
	})
}

// OriginGTE applies the GTE predicate on the "origin" field.
func OriginGTE(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldOrigin), v))
	})
}

// OriginLT applies the LT predicate on the "origin" field.
func OriginLT(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldOrigin), v))
	})
}

// OriginLTE applies the LTE predicate on the "origin" field.
func OriginLTE(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldOrigin), v))
	})
}

// OriginContains applies the Contains predicate on the "origin" field.
func OriginContains(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.Contains(s.C(FieldOrigin), v))
	})
}

// OriginHasPrefix applies the HasPrefix predicate on the "origin" field.
func OriginHasPrefix(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.HasPrefix(s.C(FieldOrigin), v))
	})
}

// OriginHasSuffix applies the HasSuffix predicate on the "origin" field.
func OriginHasSuffix(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.HasSuffix(s.C(FieldOrigin), v))
	})
}

// OriginEqualFold applies the EqualFold predicate on the "origin" field.
func OriginEqualFold(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.EqualFold(s.C(FieldOrigin), v))
	})
}

// OriginContainsFold applies the ContainsFold predicate on the "origin" field.
func OriginContainsFold(v string) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.ContainsFold(s.C(FieldOrigin), v))
	})
}

// SimulatedEQ applies the EQ predicate on the "simulated" field.
func SimulatedEQ(v bool) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldSimulated), v))
	})
}

// SimulatedNEQ applies the NEQ predicate on the "simulated" field.
func SimulatedNEQ(v bool) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldSimulated), v))
	})
}

// HasOwner applies the HasEdge predicate on the "owner" edge.
func HasOwner() predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		step := sqlgraph.NewStep(
			sqlgraph.From(Table, FieldID),
			sqlgraph.To(OwnerTable, FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, OwnerTable, OwnerColumn),
		)
		sqlgraph.HasNeighbors(s, step)
	})
}

// HasOwnerWith applies the HasEdge predicate on the "owner" edge with a given conditions (other predicates).
func HasOwnerWith(preds ...predicate.Alert) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		step := sqlgraph.NewStep(
			sqlgraph.From(Table, FieldID),
			sqlgraph.To(OwnerInverseTable, FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, OwnerTable, OwnerColumn),
		)
		sqlgraph.HasNeighborsWith(s, step, func(s *sql.Selector) {
			for _, p := range preds {
				p(s)
			}
		})
	})
}

// And groups predicates with the AND operator between them.
func And(predicates ...predicate.Decision) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s1 := s.Clone().SetP(nil)
		for _, p := range predicates {
			p(s1)
		}
		s.Where(s1.P())
	})
}

// Or groups predicates with the OR operator between them.
func Or(predicates ...predicate.Decision) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		s1 := s.Clone().SetP(nil)
		for i, p := range predicates {
			if i > 0 {
				s1.Or()
			}
			p(s1)
		}
		s.Where(s1.P())
	})
}

// Not applies the not operator on the given predicate.
func Not(p predicate.Decision) predicate.Decision {
	return predicate.Decision(func(s *sql.Selector) {
		p(s.Not())
	})
}
