// Code generated by entc, DO NOT EDIT.

package ent

import (
	"fmt"
	"strings"
	"time"

	"entgo.io/ent/dialect/sql"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/alert"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/meta"
)

// Meta is the model entity for the Meta schema.
type Meta struct {
	config `json:"-"`
	// ID of the ent.
	ID int `json:"id,omitempty"`
	// CreatedAt holds the value of the "created_at" field.
	CreatedAt *time.Time `json:"created_at,omitempty"`
	// UpdatedAt holds the value of the "updated_at" field.
	UpdatedAt *time.Time `json:"updated_at,omitempty"`
	// Key holds the value of the "key" field.
	Key string `json:"key,omitempty"`
	// Value holds the value of the "value" field.
	Value string `json:"value,omitempty"`
	// Edges holds the relations/edges for other nodes in the graph.
	// The values are being populated by the MetaQuery when eager-loading is set.
	Edges       MetaEdges `json:"edges"`
	alert_metas *int
}

// MetaEdges holds the relations/edges for other nodes in the graph.
type MetaEdges struct {
	// Owner holds the value of the owner edge.
	Owner *Alert `json:"owner,omitempty"`
	// loadedTypes holds the information for reporting if a
	// type was loaded (or requested) in eager-loading or not.
	loadedTypes [1]bool
}

// OwnerOrErr returns the Owner value or an error if the edge
// was not loaded in eager-loading, or loaded but was not found.
func (e MetaEdges) OwnerOrErr() (*Alert, error) {
	if e.loadedTypes[0] {
		if e.Owner == nil {
			// The edge owner was loaded in eager-loading,
			// but was not found.
			return nil, &NotFoundError{label: alert.Label}
		}
		return e.Owner, nil
	}
	return nil, &NotLoadedError{edge: "owner"}
}

// scanValues returns the types for scanning values from sql.Rows.
func (*Meta) scanValues(columns []string) ([]interface{}, error) {
	values := make([]interface{}, len(columns))
	for i := range columns {
		switch columns[i] {
		case meta.FieldID:
			values[i] = new(sql.NullInt64)
		case meta.FieldKey, meta.FieldValue:
			values[i] = new(sql.NullString)
		case meta.FieldCreatedAt, meta.FieldUpdatedAt:
			values[i] = new(sql.NullTime)
		case meta.ForeignKeys[0]: // alert_metas
			values[i] = new(sql.NullInt64)
		default:
			return nil, fmt.Errorf("unexpected column %q for type Meta", columns[i])
		}
	}
	return values, nil
}

// assignValues assigns the values that were returned from sql.Rows (after scanning)
// to the Meta fields.
func (m *Meta) assignValues(columns []string, values []interface{}) error {
	if m, n := len(values), len(columns); m < n {
		return fmt.Errorf("mismatch number of scan values: %d != %d", m, n)
	}
	for i := range columns {
		switch columns[i] {
		case meta.FieldID:
			value, ok := values[i].(*sql.NullInt64)
			if !ok {
				return fmt.Errorf("unexpected type %T for field id", value)
			}
			m.ID = int(value.Int64)
		case meta.FieldCreatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field created_at", values[i])
			} else if value.Valid {
				m.CreatedAt = new(time.Time)
				*m.CreatedAt = value.Time
			}
		case meta.FieldUpdatedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field updated_at", values[i])
			} else if value.Valid {
				m.UpdatedAt = new(time.Time)
				*m.UpdatedAt = value.Time
			}
		case meta.FieldKey:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field key", values[i])
			} else if value.Valid {
				m.Key = value.String
			}
		case meta.FieldValue:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field value", values[i])
			} else if value.Valid {
				m.Value = value.String
			}
		case meta.ForeignKeys[0]:
			if value, ok := values[i].(*sql.NullInt64); !ok {
				return fmt.Errorf("unexpected type %T for edge-field alert_metas", value)
			} else if value.Valid {
				m.alert_metas = new(int)
				*m.alert_metas = int(value.Int64)
			}
		}
	}
	return nil
}

// QueryOwner queries the "owner" edge of the Meta entity.
func (m *Meta) QueryOwner() *AlertQuery {
	return (&MetaClient{config: m.config}).QueryOwner(m)
}

// Update returns a builder for updating this Meta.
// Note that you need to call Meta.Unwrap() before calling this method if this Meta
// was returned from a transaction, and the transaction was committed or rolled back.
func (m *Meta) Update() *MetaUpdateOne {
	return (&MetaClient{config: m.config}).UpdateOne(m)
}

// Unwrap unwraps the Meta entity that was returned from a transaction after it was closed,
// so that all future queries will be executed through the driver which created the transaction.
func (m *Meta) Unwrap() *Meta {
	tx, ok := m.config.driver.(*txDriver)
	if !ok {
		panic("ent: Meta is not a transactional entity")
	}
	m.config.driver = tx.drv
	return m
}

// String implements the fmt.Stringer.
func (m *Meta) String() string {
	var builder strings.Builder
	builder.WriteString("Meta(")
	builder.WriteString(fmt.Sprintf("id=%v", m.ID))
	if v := m.CreatedAt; v != nil {
		builder.WriteString(", created_at=")
		builder.WriteString(v.Format(time.ANSIC))
	}
	if v := m.UpdatedAt; v != nil {
		builder.WriteString(", updated_at=")
		builder.WriteString(v.Format(time.ANSIC))
	}
	builder.WriteString(", key=")
	builder.WriteString(m.Key)
	builder.WriteString(", value=")
	builder.WriteString(m.Value)
	builder.WriteByte(')')
	return builder.String()
}

// MetaSlice is a parsable slice of Meta.
type MetaSlice []*Meta

func (m MetaSlice) config(cfg config) {
	for _i := range m {
		m[_i].config = cfg
	}
}
