// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/configitem"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/predicate"
)

// ConfigItemUpdate is the builder for updating ConfigItem entities.
type ConfigItemUpdate struct {
	config
	hooks    []Hook
	mutation *ConfigItemMutation
}

// Where appends a list predicates to the ConfigItemUpdate builder.
func (ciu *ConfigItemUpdate) Where(ps ...predicate.ConfigItem) *ConfigItemUpdate {
	ciu.mutation.Where(ps...)
	return ciu
}

// SetCreatedAt sets the "created_at" field.
func (ciu *ConfigItemUpdate) SetCreatedAt(t time.Time) *ConfigItemUpdate {
	ciu.mutation.SetCreatedAt(t)
	return ciu
}

// ClearCreatedAt clears the value of the "created_at" field.
func (ciu *ConfigItemUpdate) ClearCreatedAt() *ConfigItemUpdate {
	ciu.mutation.ClearCreatedAt()
	return ciu
}

// SetUpdatedAt sets the "updated_at" field.
func (ciu *ConfigItemUpdate) SetUpdatedAt(t time.Time) *ConfigItemUpdate {
	ciu.mutation.SetUpdatedAt(t)
	return ciu
}

// ClearUpdatedAt clears the value of the "updated_at" field.
func (ciu *ConfigItemUpdate) ClearUpdatedAt() *ConfigItemUpdate {
	ciu.mutation.ClearUpdatedAt()
	return ciu
}

// SetName sets the "name" field.
func (ciu *ConfigItemUpdate) SetName(s string) *ConfigItemUpdate {
	ciu.mutation.SetName(s)
	return ciu
}

// SetValue sets the "value" field.
func (ciu *ConfigItemUpdate) SetValue(s string) *ConfigItemUpdate {
	ciu.mutation.SetValue(s)
	return ciu
}

// Mutation returns the ConfigItemMutation object of the builder.
func (ciu *ConfigItemUpdate) Mutation() *ConfigItemMutation {
	return ciu.mutation
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (ciu *ConfigItemUpdate) Save(ctx context.Context) (int, error) {
	var (
		err      error
		affected int
	)
	ciu.defaults()
	if len(ciu.hooks) == 0 {
		affected, err = ciu.sqlSave(ctx)
	} else {
		var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
			mutation, ok := m.(*ConfigItemMutation)
			if !ok {
				return nil, fmt.Errorf("unexpected mutation type %T", m)
			}
			ciu.mutation = mutation
			affected, err = ciu.sqlSave(ctx)
			mutation.done = true
			return affected, err
		})
		for i := len(ciu.hooks) - 1; i >= 0; i-- {
			if ciu.hooks[i] == nil {
				return 0, fmt.Errorf("ent: uninitialized hook (forgotten import ent/runtime?)")
			}
			mut = ciu.hooks[i](mut)
		}
		if _, err := mut.Mutate(ctx, ciu.mutation); err != nil {
			return 0, err
		}
	}
	return affected, err
}

// SaveX is like Save, but panics if an error occurs.
func (ciu *ConfigItemUpdate) SaveX(ctx context.Context) int {
	affected, err := ciu.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (ciu *ConfigItemUpdate) Exec(ctx context.Context) error {
	_, err := ciu.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (ciu *ConfigItemUpdate) ExecX(ctx context.Context) {
	if err := ciu.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (ciu *ConfigItemUpdate) defaults() {
	if _, ok := ciu.mutation.CreatedAt(); !ok && !ciu.mutation.CreatedAtCleared() {
		v := configitem.UpdateDefaultCreatedAt()
		ciu.mutation.SetCreatedAt(v)
	}
	if _, ok := ciu.mutation.UpdatedAt(); !ok && !ciu.mutation.UpdatedAtCleared() {
		v := configitem.UpdateDefaultUpdatedAt()
		ciu.mutation.SetUpdatedAt(v)
	}
}

func (ciu *ConfigItemUpdate) sqlSave(ctx context.Context) (n int, err error) {
	_spec := &sqlgraph.UpdateSpec{
		Node: &sqlgraph.NodeSpec{
			Table:   configitem.Table,
			Columns: configitem.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: configitem.FieldID,
			},
		},
	}
	if ps := ciu.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := ciu.mutation.CreatedAt(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeTime,
			Value:  value,
			Column: configitem.FieldCreatedAt,
		})
	}
	if ciu.mutation.CreatedAtCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeTime,
			Column: configitem.FieldCreatedAt,
		})
	}
	if value, ok := ciu.mutation.UpdatedAt(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeTime,
			Value:  value,
			Column: configitem.FieldUpdatedAt,
		})
	}
	if ciu.mutation.UpdatedAtCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeTime,
			Column: configitem.FieldUpdatedAt,
		})
	}
	if value, ok := ciu.mutation.Name(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: configitem.FieldName,
		})
	}
	if value, ok := ciu.mutation.Value(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: configitem.FieldValue,
		})
	}
	if n, err = sqlgraph.UpdateNodes(ctx, ciu.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{configitem.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return 0, err
	}
	return n, nil
}

// ConfigItemUpdateOne is the builder for updating a single ConfigItem entity.
type ConfigItemUpdateOne struct {
	config
	fields   []string
	hooks    []Hook
	mutation *ConfigItemMutation
}

// SetCreatedAt sets the "created_at" field.
func (ciuo *ConfigItemUpdateOne) SetCreatedAt(t time.Time) *ConfigItemUpdateOne {
	ciuo.mutation.SetCreatedAt(t)
	return ciuo
}

// ClearCreatedAt clears the value of the "created_at" field.
func (ciuo *ConfigItemUpdateOne) ClearCreatedAt() *ConfigItemUpdateOne {
	ciuo.mutation.ClearCreatedAt()
	return ciuo
}

// SetUpdatedAt sets the "updated_at" field.
func (ciuo *ConfigItemUpdateOne) SetUpdatedAt(t time.Time) *ConfigItemUpdateOne {
	ciuo.mutation.SetUpdatedAt(t)
	return ciuo
}

// ClearUpdatedAt clears the value of the "updated_at" field.
func (ciuo *ConfigItemUpdateOne) ClearUpdatedAt() *ConfigItemUpdateOne {
	ciuo.mutation.ClearUpdatedAt()
	return ciuo
}

// SetName sets the "name" field.
func (ciuo *ConfigItemUpdateOne) SetName(s string) *ConfigItemUpdateOne {
	ciuo.mutation.SetName(s)
	return ciuo
}

// SetValue sets the "value" field.
func (ciuo *ConfigItemUpdateOne) SetValue(s string) *ConfigItemUpdateOne {
	ciuo.mutation.SetValue(s)
	return ciuo
}

// Mutation returns the ConfigItemMutation object of the builder.
func (ciuo *ConfigItemUpdateOne) Mutation() *ConfigItemMutation {
	return ciuo.mutation
}

// Select allows selecting one or more fields (columns) of the returned entity.
// The default is selecting all fields defined in the entity schema.
func (ciuo *ConfigItemUpdateOne) Select(field string, fields ...string) *ConfigItemUpdateOne {
	ciuo.fields = append([]string{field}, fields...)
	return ciuo
}

// Save executes the query and returns the updated ConfigItem entity.
func (ciuo *ConfigItemUpdateOne) Save(ctx context.Context) (*ConfigItem, error) {
	var (
		err  error
		node *ConfigItem
	)
	ciuo.defaults()
	if len(ciuo.hooks) == 0 {
		node, err = ciuo.sqlSave(ctx)
	} else {
		var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
			mutation, ok := m.(*ConfigItemMutation)
			if !ok {
				return nil, fmt.Errorf("unexpected mutation type %T", m)
			}
			ciuo.mutation = mutation
			node, err = ciuo.sqlSave(ctx)
			mutation.done = true
			return node, err
		})
		for i := len(ciuo.hooks) - 1; i >= 0; i-- {
			if ciuo.hooks[i] == nil {
				return nil, fmt.Errorf("ent: uninitialized hook (forgotten import ent/runtime?)")
			}
			mut = ciuo.hooks[i](mut)
		}
		v, err := mut.Mutate(ctx, ciuo.mutation)
		if err != nil {
			return nil, err
		}
		nv, ok := v.(*ConfigItem)
		if !ok {
			return nil, fmt.Errorf("unexpected node type %T returned from ConfigItemMutation", v)
		}
		node = nv
	}
	return node, err
}

// SaveX is like Save, but panics if an error occurs.
func (ciuo *ConfigItemUpdateOne) SaveX(ctx context.Context) *ConfigItem {
	node, err := ciuo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (ciuo *ConfigItemUpdateOne) Exec(ctx context.Context) error {
	_, err := ciuo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (ciuo *ConfigItemUpdateOne) ExecX(ctx context.Context) {
	if err := ciuo.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (ciuo *ConfigItemUpdateOne) defaults() {
	if _, ok := ciuo.mutation.CreatedAt(); !ok && !ciuo.mutation.CreatedAtCleared() {
		v := configitem.UpdateDefaultCreatedAt()
		ciuo.mutation.SetCreatedAt(v)
	}
	if _, ok := ciuo.mutation.UpdatedAt(); !ok && !ciuo.mutation.UpdatedAtCleared() {
		v := configitem.UpdateDefaultUpdatedAt()
		ciuo.mutation.SetUpdatedAt(v)
	}
}

func (ciuo *ConfigItemUpdateOne) sqlSave(ctx context.Context) (_node *ConfigItem, err error) {
	_spec := &sqlgraph.UpdateSpec{
		Node: &sqlgraph.NodeSpec{
			Table:   configitem.Table,
			Columns: configitem.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: configitem.FieldID,
			},
		},
	}
	id, ok := ciuo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "id", err: errors.New(`ent: missing "ConfigItem.id" for update`)}
	}
	_spec.Node.ID.Value = id
	if fields := ciuo.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, configitem.FieldID)
		for _, f := range fields {
			if !configitem.ValidColumn(f) {
				return nil, &ValidationError{Name: f, err: fmt.Errorf("ent: invalid field %q for query", f)}
			}
			if f != configitem.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, f)
			}
		}
	}
	if ps := ciuo.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := ciuo.mutation.CreatedAt(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeTime,
			Value:  value,
			Column: configitem.FieldCreatedAt,
		})
	}
	if ciuo.mutation.CreatedAtCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeTime,
			Column: configitem.FieldCreatedAt,
		})
	}
	if value, ok := ciuo.mutation.UpdatedAt(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeTime,
			Value:  value,
			Column: configitem.FieldUpdatedAt,
		})
	}
	if ciuo.mutation.UpdatedAtCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeTime,
			Column: configitem.FieldUpdatedAt,
		})
	}
	if value, ok := ciuo.mutation.Name(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: configitem.FieldName,
		})
	}
	if value, ok := ciuo.mutation.Value(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: configitem.FieldValue,
		})
	}
	_node = &ConfigItem{config: ciuo.config}
	_spec.Assign = _node.assignValues
	_spec.ScanValues = _node.scanValues
	if err = sqlgraph.UpdateNode(ctx, ciuo.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{configitem.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	return _node, nil
}
