#ifndef _DRV_TAPI_QOS_IO_H
#define _DRV_TAPI_QOS_IO_H
/******************************************************************************

                              Copyright (c) 2009
                            Lantiq Deutschland GmbH
                     Am Campeon 3; 85579 Neubiberg, Germany

  For licensing information, see the file 'LICENSE' in the root folder of
  this software module.

*******************************************************************************/

/**
   \file drv_tapi_qos_io.h  TAPI interface to the QOS driver.

   \remarks Define QOS_SUPPORT to compile this service.
*/

/** \addtogroup TAPI_INTERFACE */
/*@{*/

/** \defgroup TAPI_INTERFACE_QOS QOS Services
    The QOS service is a direct connection from the KPI interface to the
    network stack of the operating system. All QOS services apply to channel
    file descriptors. */
/*@{*/


/* ========================================================================== */
/*                     TAPI Interface Ioctl Commands                          */
/* ========================================================================== */

/** magic number for QOS ioctls */
#define QOS_IOC_MAGIC 's'

/* ======================================================================== */
/* TAPI QOS Services, ioctl commands (Group TAPI_INTERFACE_QOS)             */
/* ======================================================================== */

/** This service creates a new session on a channel.

   \param QOS_INIT_SESSION* The parameter points to a
          \ref QOS_INIT_SESSION structure.

   \return Returns value as follows:
      - \ref IFX_SUCCESS: if successful
      - \ref IFX_ERROR: in case of an error
*/
#define  FIO_QOS_START                       _IOW(QOS_IOC_MAGIC, 0x00, IFX_int32_t)

/*  The FIO_QOS_ACTIVATE IOCTL is obsolete. For compatibility it will do
    nothing and always return IFX_SUCCESS.
    FIO_QOS_START does this functionality now implicitly.

   \param int This interface expects no parameter. It should be set to 0.

   \return Returns value as follows:
      - \ref IFX_SUCCESS: in all cases
*/
#define  FIO_QOS_ACTIVATE                    _IO(QOS_IOC_MAGIC, 0x01)

/** This service deactivates and deletes a session on a channel.
    The parameter is ignored, the port number is no longer needed to
    stop a session.
   \param int This interface expects no parameter. It should be set to 0.

   \return Returns value as follows:
      - \ref IFX_SUCCESS: if successful
      - \ref IFX_ERROR: in case of an error
*/
#define  FIO_QOS_STOP                        _IO(QOS_IOC_MAGIC, 0x02)

/** This service stops the entire qos support. Regardless on which channel file
    descriptor it is given it deactivates and deletes all sessions on all
    channels.

   \param int This interface expects no parameter. It should be set to 0.

   \return Returns value as follows:
      - \ref IFX_SUCCESS: if successful
      - \ref IFX_ERROR: in case of an error
*/
#define  FIO_QOS_CLEAN                       _IO(QOS_IOC_MAGIC, 0x03)


/* ========================================================================= */
/*                      TAPI Interface Enumerations                          */
/* ========================================================================= */

/* ======================================================================== */
/* TAPI QOS Services, enumerations (Group TAPI_INTERFACE_QOS)               */
/* ======================================================================== */

/* This define is now obsolete. It is kept for backward compatibility only. */
#define QOS_PORT_CLEAN     0xFFFF /* or 65535 */


/* ========================================================================== */
/*                      TAPI Interface Structures                             */
/* ========================================================================== */

/* ======================================================================== */
/* TAPI QOS Services, structures (Group TAPI_INTERFACE_QOS)                 */
/* ======================================================================== */

/** TAPI QOS session creation structure used for \ref FIO_QOS_START. */
typedef struct
{
   /** Source (local) port number. */
   IFX_uint16_t srcPort;
   /** Source (local) ip address. */
   IFX_uint32_t srcAddr;
   /** Destination (remote) port number. */
   IFX_uint16_t destPort;
   /** Destination (remore) ip address. */
   IFX_uint32_t destAddr;
} QOS_INIT_SESSION;


/*@}*/ /* TAPI_INTERFACE_QOS */
/*@}*/ /* TAPI_INTERFACE */

#endif /* _DRV_TAPI_QOS_IO_H */
