#ifndef _DRV_API_H_TAPI
#define _DRV_API_H_TAPI
/****************************************************************************
                              Copyright (c) 2009
                            Lantiq Deutschland GmbH
                     Am Campeon 3; 85579 Neubiberg, Germany

  For licensing information, see the file 'LICENSE' in the root folder of
  this software module.

 ****************************************************************************/

/**
   \file drv_api.h
   This file contains the defines, the structures declarations
                 the tables declarations and the global functions declarations.

      Use compiler switch ENABLE_TRACE for trace output, for debugging purposes.
      Compiler switch for OS is needed. Use LINUX for linux and VXWORKS for
      VxWorks..
*/

/* ============================= */
/* Global Defines                */
/* ============================= */

/* ============================= */
/* includes                      */
/* ============================= */
#ifdef HAVE_CONFIG_H
#include <drv_config.h>
#endif

#include "drv_tapi_osmap.h"

#if defined(VXWORKS)
   #include "drv_tapi_vxworks.h"
   #include "sys_drv_timerlib_vxworks.h"
#elif defined(LINUX)
   #ifdef __NO_INLINE__
      #error "no inline, maybe use of -O0 ???"
   #endif /* __NO_INLINE__ */
   #include "drv_tapi_linux.h"
#elif defined(WINDOWS)
   #include "drv_tapi_win.h"
#else
   #error TAPI driver - no OS specified. Please define your operating system!
#endif /* OS */

/* return values */

#ifndef OK
/** return value on success */
#define OK      0
#endif

#ifndef ERROR
/** return value on failure */
#define ERROR  (-1)
#endif

/** mark variable as unused, to suppress compilation warrnings

   \remark: (ANSI X3.159-1989)
      void is used, in any context where the value of an expression
      is to be discarded, to indicate explicitly that a value is
      ignored by writing the cast (void).
*/
#define IFX_UNUSED(var) ((IFX_void_t)(var))

#endif /* _DRV_API_H_TAPI */
