#ifndef _DRV_TAPI_CID_H
#define _DRV_TAPI_CID_H
/******************************************************************************

                              Copyright (c) 2009
                            Lantiq Deutschland GmbH
                     Am Campeon 3; 85579 Neubiberg, Germany

  For licensing information, see the file 'LICENSE' in the root folder of
  this software module.

*******************************************************************************/

/**
   \file drv_tapi_cid.h
   Interface of the TAPI caller id implementation.
   This file contains the declaration of the functions for the CID module.
*/

extern IFX_int32_t IFX_TAPI_CID_SetPredefAlertTones   (IFX_void_t);

extern IFX_int32_t IFX_TAPI_CID_Initialise            (TAPI_CHANNEL *pChannel);
extern IFX_void_t  IFX_TAPI_CID_Cleanup               (TAPI_CHANNEL *pChannel);

extern IFX_int32_t TAPI_Phone_CID_SetConfig           (TAPI_CHANNEL *pChannel, IFX_TAPI_CID_CFG_t const *pCidConf);

extern IFX_int32_t TAPI_Phone_CID_Info_Tx             (TAPI_CHANNEL *pChannel, IFX_TAPI_CID_MSG_t const *pCidInfo);
extern IFX_int32_t TAPI_Phone_CID_Seq_Tx              (TAPI_CHANNEL *pChannel, IFX_TAPI_CID_MSG_t const *pCidInfo);
extern IFX_int32_t TAPI_Phone_CID_Stop_Tx             (TAPI_CHANNEL *pChannel);

extern IFX_int32_t TAPI_Phone_CidRx_Start             (TAPI_CHANNEL *pChannel, IFX_TAPI_CID_HOOK_MODE_t cidHookMode);
extern IFX_int32_t TAPI_Phone_CidRx_Stop              (TAPI_CHANNEL *pChannel);
extern IFX_int32_t TAPI_Phone_Get_CidRxData           (TAPI_CHANNEL *pChannel, IFX_TAPI_CID_RX_DATA_t *pCidRxData);
extern IFX_int32_t TAPI_Phone_CidRx_Status            (TAPI_CHANNEL *pChannel, IFX_TAPI_CID_RX_STATUS_t *pCidRxStatus);

extern IFX_boolean_t TAPI_Cid_UseSequence             (TAPI_CHANNEL *pChannel);

/* trigger function called by ringing to indicate a ring pause */
extern IFX_void_t  IFX_TAPI_CID_OnRingpause           (TAPI_CHANNEL *pChannel);
/* trigger function to indicate a hook event to CID */
extern IFX_void_t  IFX_TAPI_CID_OnHookEvent           (TAPI_CHANNEL *pChannel, IFX_boolean_t bOffhook, IFX_boolean_t *bSendHookEvent, IFX_boolean_t *bDoRingStop);
/* trigger function to indicate a DTMF event to CID */
extern IFX_boolean_t IFX_TAPI_CID_OnDtmfEvent         (TAPI_CHANNEL *pChannel, IFX_uint8_t nDtmfAscii);
/* trigger function to indicate a CidRxEnd event to CID */
extern IFX_void_t  IFX_TAPI_CID_OnCidRxEndEvent       (TAPI_CHANNEL *pChannel);

/* exported for use by LL driver */
extern IFX_TAPI_CID_RX_DATA_t *TAPI_Phone_GetCidRxBuf (TAPI_CHANNEL *pChannel, IFX_uint32_t nLen);
#endif /* _DRV_TAPI_CID_H */
