/******************************************************************************

                              Copyright (c) 2009
                            Lantiq Deutschland GmbH
                     Am Campeon 3; 85579 Neubiberg, Germany

  For licensing information, see the file 'LICENSE' in the root folder of
  this software module.

******************************************************************************/

/**
   \file drv_vmmc_linux.h
   This file contains the declarations of the linux specific driver functions.
*/

/* ============================= */
/* Includes                      */
/* ============================= */
#include <linux/kernel.h>
#ifdef MODULE
   #include <linux/module.h>
#endif
#include <linux/version.h>
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0))
   #include <linux/hardirq.h>
#else
   #include <asm/hardirq.h>
#endif /* Ver >= 2.6 */
#include <asm/byteorder.h>
#include <linux/interrupt.h>

#include "ifx_types.h"     /* ifx type definitions */

/* ============================= */
/* Macros & Definitions          */
/* ============================= */
#define VMMC_OS_IN_INTERRUPT() \
   /*lint -save -e 155 -e 506 -e 774 */    \
   (in_interrupt() ? IFX_TRUE : IFX_FALSE) \
   /*lint -restore */


/** Returns system tick in milliseconds
Maybe used to measure roughly times for testing
\return system tick in milliseconds  */
#define IFXOS_GET_TICK()      \
   (IFX_ulong_t)(jiffies * 1000 / HZ)

/* ============================= */
/* Global variable declaration   */
/* ============================= */

/* ============================= */
/* Global function declaration   */
/* ============================= */
IFX_void_t *VMMC_OS_MapBuffer          (IFX_void_t *p_buffer,
                                        IFX_uint32_t size);
IFX_void_t  VMMC_OS_UnmapBuffer        (IFX_void_t *p_buffer);
