from enum import Enum
import os
from typing import Union, Any

Path = Union[str, bytes, os.PathLike[Any]]

class SSLVersion(Enum):
    TLSv1_2: SSLVersion = ...
    value: int

class SSLVerifyOption(Enum):
    VERIFY: SSLVerifyOption = ...
    VERIFY_REQ_CLIENT_CERT: SSLVerifyOption = ...
    NO_VERIFY: SSLVerifyOption = ...

class SSLContext:
    def __init__(self, version: SSLVersion = ...) -> None: ...
    def set_verify_option(self, option: SSLVerifyOption) -> None: ...
    @property
    def needs_peer_verify(self) -> bool: ...
    def load_cert_chain(self, *, certfile: Path, keyfile: Path) -> None: ...
    def load_verify_locations(self, *, cafile: Path) -> None: ...
    def authenticate(self, *, peer_cert: bool, peer_name: bool) -> None: ...
