#!fish
# Maven fish auto completion
#
# Possible calls to mvn
#
## Lifecycle
# mvn $lifecycle(s)
#
# Attention: Multiple lifecycles can be given
#
### Samples
# mvn clean
# mvn clean install
# mvn install
#
#
## Plugins
# mvn $plugin:$goal
### Samples
# mvn jboss:start
# mvn ejb:ejb
# mvn jboss:start ejb:ejb
# Attention: Multiple plugins can be given


# Default lifecycles
complete -c mvn -f -a 'pre-clean clean post-clean validate initialize generate-sources process-sources generate-resources process-resources compile process-classes generate-test-sources process-test-sources generate-test-resources process-test-resources test-compile process-test-classes testprepare-package package pre-integration-test integration-test post-integration-test verify install deploy pre-site site post-site site-deploy'

# All options form mvn --help
complete -c mvn -f -o am -l also-make -d "If project list is specified, also build projects required by the list"
complete -c mvn -f -o amd -l also-make-dependents -d "If project list is specified, also build projects that depend on projects on the list"
complete -c mvn -f -o B -l batch-mode -d "Run in non-interactive (batch) mode"
complete -c mvn -r -f -o b -l builder -d "The id of the build strategy to use."
complete -c mvn -f -o C -l strict-checksums -d "Fail the build if checksums don't match"
complete -c mvn -f -o c -l lax-checksums -d "Warn if checksums don't match"
complete -c mvn -f -o cpu -l check-plugin-updates -d "Ineffective, only kept for backward compatibility"
complete -c mvn -f -o D -l define -d "Define a system property"
complete -c mvn -f -o e -l errors -d "Produce execution error messages"
complete -c mvn -f -o emp -l encrypt-master-password -d "Encrypt master security password"
complete -c mvn -f -o ep -l encrypt-password -d "Encrypt server password"
complete -c mvn -r -o f -l file -d "Force the use of an alternate POM file (or directory with pom.xml)."
complete -c mvn -f -o fae -l fail-at-end -d "Only fail the build afterwards; allow all non-impacted builds to continue"
complete -c mvn -f -o ff -l fail-fast -d "Stop at first failure in reactorized builds"
complete -c mvn -f -o fn -l fail-never -d "NEVER fail the build, regardless of project result"
complete -c mvn -r -o gs -l global-settings -d "Alternate path for the global settings file"
complete -c mvn -f -o h -l help -d "Display help information"
complete -c mvn -r -o l -l log-file -d "Log file to where all build output will go."
complete -c mvn -f -o llr -l legacy-local-repository -d "Use Maven 2 Legacy Local Repository behaviour, ie no use of _remote.repositories"
complete -c mvn -f -o N -l non-recursive -d "Do not recurse into sub-projects"
complete -c mvn -f -o npr -l no-plugin-registry -d "Ineffective, only kept for backward compatibility"
complete -c mvn -f -o npu -l no-plugin-updates -d "Ineffective, only kept for backward compatibility"
complete -c mvn -f -o nsu -l no-snapshot-updates -d "Suppress SNAPSHOT updates"
complete -c mvn -f -o o -l offline -d "Work offline"
complete -c mvn -r -f -o pl -l projects -d "Comma-delimited list of specified reactor projects to build instead of all projects"
complete -c mvn -f -o q -l quiet -d "Quiet output - only show errors"
complete -c mvn -r -f -o rf -l resume-from -d "Resume reactor from specified project"
complete -c mvn -r -o s -l settings -d "Alternate path for the user settings file"
complete -c mvn -r -f -o T -l threads -d "Thread count, for instance 2.0C where C is core multiplied"
complete -c mvn -r -o t -l toolchains -d "Alternate path for the user toolchains file"
complete -c mvn -f -o U -l update-snapshots -d "Forces a check for missing releases and updated snapshots on remote repositories"
complete -c mvn -f -o up -l update-plugins -d "Ineffective, only kept for backward compatibility"
complete -c mvn -f -o V -l show-version -d "Display version information WITHOUT stopping build"
complete -c mvn -f -o v -l version -d "Display version information"
complete -c mvn -f -o X -l debug -d "Produce execution debug output"

#
# Profiles
#
#TODO search pom.xml hierarchy
function __fish_mvn_profiles
    # find line opening the profile-tag
    # read next line
    # extract contents of id-tag
    sed -n -e '/<profile>/{n; s!^.*<id>\([^<]*\)</id>.*$!\1!; p}' ~/.m2/settings.xml pom.xml 2>/dev/null
end

complete -c mvn -f -r -o P -l activate-profiles -a "(__fish_mvn_profiles)" -d "Comma-delimited list of profiles to activate"


#default properties for some plugins / profiles
complete -c mvn -o DskipTests -d "Skipping JUnit Tests"
complete -c mvn -o DbuildInstaller -d "Build installer (if profile is available in project)"
complete -c mvn -o DperformRelease -d "Use release profile (create javadoc and attach sources)"
complete -c mvn -o Dmaven.surefire.debug -d "Run surefire tests with debugging on port 5005"
complete -c mvn -o Dmaven.javadoc.skip -d "Skip Javadoc generation"


#
# Plugin configurations
#


# More plugins
complete -c mvn -a "clean:clean" -d "Clean the build"
complete -c mvn -a "clean:help" -d "Display help information on maven-clean-plugin"
complete -c mvn -a "compiler:compile" -d "Compiles application sources"
complete -c mvn -a "compiler:help" -d "Display help information on maven-compiler-plugin"
complete -c mvn -a "compiler:testCompile" -d "Compiles application test sources."
complete -c mvn -a "deploy:help" -d "Display help information on maven-deploy-plugin"
complete -c mvn -a "deploy:deploy-file" -d "Installs the artifact in the remote repository."
complete -c mvn -a "deploy:deploy" -d "Deploys an artifact to remote repository."
complete -c mvn -a "failsafe:help" -d "Display help information on maven-failsafe-plugin"
complete -c mvn -a "failsafe:integration-test" -d "Run integration tests using Surefire."
complete -c mvn -a "failsafe:verify" -d "Verify integration tests ran using Surefire."
complete -c mvn -a "install:install" -d "Installs the project's main artifact, and any other artifacts attached by other plugins in the lifecycle, to the local repository."
complete -c mvn -a "install:help" -d "Display help information on maven-install-plugin"
complete -c mvn -a "install:install-file" -d "Installs a file in the local repository."
complete -c mvn -a "resources:testResources" -d "Copy resources for the test source code to the test output directory"
complete -c mvn -a "resources:copy-resources" -d "Copy resources of the configured plugin attribute resources"
complete -c mvn -a "resources:help" -d "Display help information on maven-resources-plugin"
complete -c mvn -a "resources:resources" -d "Copy resources for the main source code to the main output directory"
complete -c mvn -a "site:attach-descriptor" -d "Adds the site descriptor (site.xml) to the list of files to be installed/deployed"
complete -c mvn -a "site:deploy" -d "Deploys the generated site"
complete -c mvn -a "site:effective-site" -d "Displays the effective site descriptor"
complete -c mvn -a "site:help" -d "Display help information on maven-site-plugin"
complete -c mvn -a "site:jar" -d "Bundles the site output into a JAR so that it can be deployed to a repository."
complete -c mvn -a "site:run" -d "Starts the site up, rendering documents as requested for faster editing. It uses Jetty as the web server."
complete -c mvn -a "site:site" -d "Generates the site for a single project"
complete -c mvn -a "site:stage" -d "Deploys the generated site to a local staging or mock directory"
complete -c mvn -a "site:stage-deploy" -d "Deploys the generated site to a staging or mock URL"
complete -c mvn -a "surefire:help" -d "Display help information on maven-surefire-plugin"
complete -c mvn -a "surefire:test" -d "Run tests using Surefire."
complete -c mvn -a "verifier:help" -d "Display help information on maven-verifier-plugin"
complete -c mvn -a "verifier:verify" -d "Verifies the existence or non-existence of files/directories and optionally checks file content against a regular expression."
complete -c mvn -a "ear:ear" -d "Builds J2EE Enterprise Archive (EAR) files."
complete -c mvn -a "ear:generate-application-xml" -d "Generates the EAR deployment descriptor file(s)."
complete -c mvn -a "ear:help" -d "Display help information on maven-ear-plugin"
complete -c mvn -a "ejb:ejb" -d "Build an EJB (and optional client) from the current project."
complete -c mvn -a "ejb:help" -d "Display help information on maven-ejb-plugin"
complete -c mvn -a "jar:help" -d "Display help information on maven-jar-plugin"
complete -c mvn -a "jar:jar" -d "Build a JAR from the current project."
complete -c mvn -a "jar:test-jar" -d "Build a JAR of the test classes for the current project."
complete -c mvn -a "rar:help" -d "Display help information on maven-rar-plugin"
complete -c mvn -a "rar:rar" -d "Builds J2EE Resource Adapter Archive (RAR) files."
complete -c mvn -a "shade:help" -d "Display help information on maven-shade-plugin"
complete -c mvn -a "shade:shade" -d "Mojo that performs shading delegating to the Shader component."
complete -c mvn -a "source:aggregate" -d "Aggregate sources for all modules in an aggregator project."
complete -c mvn -a "source:jar" -d "This plugin bundles all the sources into a jar archive."
complete -c mvn -a "source:test-jar-no-fork" -d "This goal bundles all the test sources into a jar archive"
complete -c mvn -a "source:test-jar" -d "This plugin bundles all the test sources into a jar archive."
complete -c mvn -a "source:generated-test-jar" -d "This plugin bundles all the test sources into a jar archive."
complete -c mvn -a "source:help" -d "Display help information on maven-source-plugin"
complete -c mvn -a "source:jar-no-fork" -d "This goal bundles all the sources into a jar archive"
complete -c mvn -a "changelog:changelog" -d "Generate a changelog report."
complete -c mvn -a "changelog:file-activity" -d "Generate a file activity report."
complete -c mvn -a "changelog:dev-activity" -d "Generate a developer activity report."
complete -c mvn -a "changelog:help" -d "Display help information on maven-changelog-plugin"
complete -c mvn -a "changes:changes-validate" -d "Goal which validate the changes.xml file."
complete -c mvn -a "changes:changes-check" -d "Check that changes.xml has the necessary data for a release announcement"
complete -c mvn -a "changes:github-report" -d "Goal which downloads issues from GitHub and generates a report."
complete -c mvn -a "changes:announcement-generate" -d "Goal which generate an announcement from the announcement template."
complete -c mvn -a "changes:trac-report" -d "Goal which downloads issues from the Issue Tracking System and generates a report."
complete -c mvn -a "changes:changes-report" -d "Goal which creates a nicely formatted Changes Report in html format from a changes.xml file."
complete -c mvn -a "changes:announcement-mail" -d "Goal which sends an announcement through email."
complete -c mvn -a "changes:jira-report" -d "Goal which downloads issues from the Issue Tracking System and generates a report."
complete -c mvn -a "changes:help" -d "Display help information on maven-changes-plugin"
complete -c mvn -a "checkstyle:check" -d "Perform Checkstyle analysis"
complete -c mvn -a "checkstyle:checkstyle" -d "Perform Checkstyle analysis and generate an HTML report"
complete -c mvn -a "checkstyle:checkstyle-aggregate" -d "Perform Checkstyle analysis and generate an aggregate HTML report"
complete -c mvn -a "checkstyle:help" -d "Display help information on maven-checkstyle-plugin"
complete -c mvn -a "doap:generate" -d "Generate a Description of a Project (DOAP) file"
complete -c mvn -a "doap:help" -d "Display help information on maven-doap-plugin"
complete -c mvn -a "docck:check" -d "Checks a plugin's documentation for the standard minimums."
complete -c mvn -a "docck:help" -d "Display help information on maven-docck-plugin"
complete -c mvn -a "javadoc:aggregate" -d "Generates documentation for the Java code in an aggregator project using the standard Javadoc Tool."
complete -c mvn -a "javadoc:aggregate-jar" -d "Bundles the Javadoc documentation for main Java code in an aggregator project into a jar using the standard Javadoc Tool."
complete -c mvn -a "javadoc:fix" -d "Fix Javadoc documentation and tags for the Java code for the project. See Where Tags Can Be Used."
complete -c mvn -a "javadoc:help" -d "Display help information on maven-javadoc-plugin"
complete -c mvn -a "javadoc:jar" -d "Bundle the Javadoc into a jar"
complete -c mvn -a "javadoc:javadoc" -d "Generate documentation"
complete -c mvn -a "javadoc:javadoc-no-fork" -d "Generate documentation"
complete -c mvn -a "javadoc:resource-bundle" -d "Bundle AbstractJavadocMojo.javadocDirectory"
complete -c mvn -a "javadoc:test-aggregate" -d "Generates documentation for the Java Test code"
complete -c mvn -a "javadoc:test-aggregate-jar" -d "Bundle documentation for Java Test Code into a jar"
complete -c mvn -a "javadoc:test-fix" -d "Fix Javadoc documentation and tags for the Test Java code"
complete -c mvn -a "javadoc:test-jar" -d "Bundles the Javadoc documentation for test Java code into a jar"
complete -c mvn -a "javadoc:test-javadoc" -d "Generates documentation for the Java Test code"
complete -c mvn -a "javadoc:test-javadoc-no-fork" -d "Generate documentation for the Java Test code"
complete -c mvn -a "javadoc:test-resource-bundle" -d "Bundle TestJavadocJar.testJavadocDirectory"
complete -c mvn -a "jxr:aggregate" -d "Generates a combined JXR report in an aggregating project."
complete -c mvn -a "jxr:help" -d "Display help information on maven-jxr-plugin"
complete -c mvn -a "jxr:jxr" -d "Creates an html-based, cross referenced version of Java source code for a project."
complete -c mvn -a "jxr:test-aggregate" -d "Generates a combined JXR report for test code in an aggregating project."
complete -c mvn -a "jxr:test-jxr" -d "Creates an html-based, cross referenced version of Java source code for a project's test sources."
complete -c mvn -a "linkcheck:linkcheck" -d "Generates a Linkcheck report."
complete -c mvn -a "linkcheck:help" -d "Display help information on maven-linkcheck-plugin"
complete -c mvn -a "pmd:check" -d "Fail the build if there were any PMD violations in the source code."
complete -c mvn -a "pmd:cpd" -d "Creates a report for PMD's CPD tool. See http://pmd.sourceforge.net/cpd.html for more detail."
complete -c mvn -a "pmd:cpd-check" -d "Fail the build if there were any CPD violations in the source code."
complete -c mvn -a "pmd:help" -d "Display help information on maven-pmd-plugin"
complete -c mvn -a "pmd:pmd" -d "Creates a PMD report."
complete -c mvn -a "project-info-reports:cim" -d "Generates the Project Continuous Integration System report."
complete -c mvn -a "project-info-reports:dependencies" -d "Generates the Project Dependencies report."
complete -c mvn -a "project-info-reports:dependency-convergence" -d "Generates the Dependency Convergence report for reactor builds."
complete -c mvn -a "project-info-reports:dependency-info" -d "Generates code snippets to be added to build tools."
complete -c mvn -a "project-info-reports:dependency-management" -d "Generates the Project Dependency Management report."
complete -c mvn -a "project-info-reports:distribution-management" -d "Generates the Project Distribution Management report."
complete -c mvn -a "project-info-reports:help" -d "Display help information on maven-project-info-reports-plugin"
complete -c mvn -a "project-info-reports:index" -d "Generates the project index page."
complete -c mvn -a "project-info-reports:issue-tracking" -d "Generates the Project Issue Tracking report."
complete -c mvn -a "project-info-reports:license" -d "Generates the Project License report."
complete -c mvn -a "project-info-reports:mailing-list" -d "Generates the Mailing List report."
complete -c mvn -a "project-info-reports:modules" -d "Generates the Project Modules report."
complete -c mvn -a "project-info-reports:plugin-management" -d "Generates the Project Plugin Management report."
complete -c mvn -a "project-info-reports:plugins" -d "Generates the Project Plugins report."
complete -c mvn -a "project-info-reports:project-team" -d "Generates the Project Team report."
complete -c mvn -a "project-info-reports:scm" -d "Generates the Project Source Code Management (SCM) report."
complete -c mvn -a "project-info-reports:summary" -d "Generates the project information reports summary."
complete -c mvn -a "surefire-report:failsafe-report-only" -d "Create Failsafe Test Report html "
complete -c mvn -a "surefire-report:help" -d "Display help information on maven-surefire-report-plugin"
complete -c mvn -a "surefire-report:report" -d "Create Surefire Test Report html"
complete -c mvn -a "surefire-report:report-only" -d "Create Surefire Test Report html"
complete -c mvn -a "ant:ant" -d "Generate Ant build files."
complete -c mvn -a "ant:clean" -d "Clean all Ant build files."
complete -c mvn -a "ant:help" -d "Display help information on maven-ant-plugin"
complete -c mvn -a "antrun:help" -d "Display help information on maven-antrun-plugin"
complete -c mvn -a "antrun:run" -d "Maven AntRun Mojo"
complete -c mvn -a "archetype:crawl" -d "Crawl a Maven repository (filesystem, not HTTP) and creates a catalog file."
complete -c mvn -a "archetype:create" -d "Retrieve an archetype from the remote repository"
complete -c mvn -a "archetype:create-from-project" -d "Creates an archetype project from the current project"
complete -c mvn -a "archetype:generate" -d "Generate new project from an archetype, or update project if using a partial archetype"
complete -c mvn -a "archetype:help" -d "Display help information on maven-archetype-plugin"
complete -c mvn -a "archetype:integration-test" -d "Execute the archetype integration tests"
complete -c mvn -a "archetype:jar" -d "Build a JAR from the current Archetype project."
complete -c mvn -a "archetype:update-local-catalog" -d "Updates the local catalog"
complete -c mvn -a "assembly:assembly" -d "Assemble an application bundle or distribution using an assembly descriptor from the command line"
complete -c mvn -a "assembly:attached" -d "Assemble an application bundle or distribution from an assembly descriptor"
complete -c mvn -a "assembly:directory" -d "Assemble an application bundle or distribution"
complete -c mvn -a "assembly:directory-inline" -d "Like assembly:attached, but ignore the <formats/> section"
complete -c mvn -a "assembly:directory-single" -d "Assemble an application bundle or distribution from an assembly descriptor"
complete -c mvn -a "assembly:help" -d "Display help information on maven-assembly-plugin"
complete -c mvn -a "assembly:single" -d "Assemble an application bundle or distribution from an assembly descriptor"
complete -c mvn -a "assembly:unpack" -d "Unpack project dependencies. Currently supports dependencies of type jar and zip."
complete -c mvn -a "dependency:analyze" -d "Analyzes the dependencies of this project"
complete -c mvn -a "dependency:analyze-dep-mgt" -d "Look for dependency mismatches in your dependencyManagement section"
complete -c mvn -a "dependency:analyze-duplicate" -d "Determine duplicate dependencies"
complete -c mvn -a "dependency:analyze-only" -d "Analyze the dependencies of this project"
complete -c mvn -a "dependency:analyze-report" -d "Analyze the dependencies of this project and produce a report"
complete -c mvn -a "dependency:build-classpath" -d "This goal will output a classpath string of dependencies from the local repository to a file or log."
complete -c mvn -a "dependency:copy" -d "Goal that copies a list of artifacts from the repository to defined locations."
complete -c mvn -a "dependency:copy-dependencies" -d "Goal that copies the project dependencies from the repository to a defined location."
complete -c mvn -a "dependency:display-ancestors" -d "Displays all ancestor POMs of the project"
complete -c mvn -a "dependency:get" -d "Resolves a single artifact, eventually transitively, from the specified remote repositories"
complete -c mvn -a "dependency:go-offline" -d "Resolve all project dependencies"
complete -c mvn -a "dependency:help" -d "Display help information on maven-dependency-plugin"
complete -c mvn -a "dependency:list" -d "Displays the list of dependencies for this project."
complete -c mvn -a "dependency:list-repositories" -d "Resolve all project dependencies and then lists the repositories used"
complete -c mvn -a "dependency:properties" -d "Set a property pointing to the artifact file for each project dependency"
complete -c mvn -a "dependency:purge-local-repository" -d "Remove the project dependencies from the local repository, and optionally re-resolve them."
complete -c mvn -a "dependency:resolve" -d "Resolve project dependencies"
complete -c mvn -a "dependency:resolve-plugins" -d "Goal that resolves all project plugins and reports and their dependencies."
complete -c mvn -a "dependency:sources" -d "Goal that resolves the project source dependencies from the repository."
complete -c mvn -a "dependency:tree" -d "Displays the dependency tree for this project."
complete -c mvn -a "dependency:unpack" -d "Goal that retrieves a list of artifacts from the repository and unpacks them in a defined location."
complete -c mvn -a "dependency:unpack-dependencies" -d "Goal that unpacks the project dependencies from the repository to a defined location."
complete -c mvn -a "enforcer:display-info" -d "This goal displays the current platform information."
complete -c mvn -a "enforcer:enforce" -d "This goal executes the defined enforcer-rules once per module."
complete -c mvn -a "enforcer:help" -d "Display help information on maven-enforcer-plugin"
complete -c mvn -a "gpg:help" -d "Display help information on maven-gpg-plugin"
complete -c mvn -a "gpg:sign" -d "Sign project artifact, the POM, and attached artifacts with GnuPG for deployment."
complete -c mvn -a "gpg:sign-and-deploy-file" -d "Signs artifacts and installs the artifact in the remote repository."
complete -c mvn -a "help:expressions" -d "Displays the supported Plugin expressions used by Maven."
complete -c mvn -a "help:active-profiles" -d "Displays a list of the profiles which are currently active for this build."
complete -c mvn -a "help:effective-settings" -d "Displays the calculated settings as XML for this project"
complete -c mvn -a "help:system" -d "Displays a list of the platform details like system properties and environment variables."
complete -c mvn -a "help:effective-pom" -d "Displays the effective POM as an XML for this build, with the active profiles factored in."
complete -c mvn -a "help:help" -d "Display help information on maven-help-plugin"
complete -c mvn -a "help:all-profiles" -d "Displays a list of available profiles under the current project"
complete -c mvn -a "help:describe" -d "Displays a list of the attributes for a Maven Plugin and/or goals (aka Mojo - Maven plain Old Java Object)."
complete -c mvn -a "help:evaluate" -d "Evaluates Maven expressions given by the user in an interactive mode."
complete -c mvn -a "invoker:help" -d "Display help information on maven-invoker-plugin"
complete -c mvn -a "invoker:install" -d "Installs the project artifacts of the main build into the local repository"
complete -c mvn -a "invoker:integration-test" -d "Searches for integration test Maven projects, and executes each, collecting a log in the project directory"
complete -c mvn -a "invoker:report" -d "Generate a report based on the results of the Maven invocations"
complete -c mvn -a "invoker:run" -d "Searches for integration test Maven projects, and executes each, collecting a log in the project directory, and outputting the results to the command line."
complete -c mvn -a "invoker:verify" -d "Checks the results of maven-invoker-plugin based integration tests and fails the build if any tests failed."
complete -c mvn -a "jarsigner:help" -d "Display help information on maven-jarsigner-plugin"
complete -c mvn -a "jarsigner:sign" -d "Signs a project artifact and attachments using jarsigner."
complete -c mvn -a "jarsigner:verify" -d "Checks the signatures of a project artifact and attachments using jarsigner."
complete -c mvn -a "patch:apply" -d "Apply one or more patches to project sources."
complete -c mvn -a "patch:help" -d "Display help information on maven-patch-plugin"
complete -c mvn -a "pdf:help" -d "Display help information on maven-pdf-plugin"
complete -c mvn -a "pdf:pdf" -d "Generates a PDF document for a project."
complete -c mvn -a "plugin:updateRegistry" -d "Update the user plugin registry (if it's in use) to reflect the version we're installing."
complete -c mvn -a "plugin:report" -d "Generates the Plugin's documentation report."
complete -c mvn -a "plugin:xdoc" -d "Generate Xdoc files for the project mojos or goals."
complete -c mvn -a "plugin:addPluginArtifactMetadata" -d "Inject any plugin-specific artifact metadata to the project's artifact, for subsequent installation and deployment"
complete -c mvn -a "plugin:help" -d "Display help information on maven-plugin-plugin"
complete -c mvn -a "plugin:helpmojo" -d "Generates a HelpMojo class."
complete -c mvn -a "plugin:descriptor" -d "Generate a plugin descriptor"
complete -c mvn -a "release:perform" -d "Perform a release from SCM"
complete -c mvn -a "release:rollback" -d "Rollback changes made by a previous release"
complete -c mvn -a "release:prepare-with-pom" -d "Prepare for a release in SCM, fully resolving dependencies for the purpose of producing a 'release POM'."
complete -c mvn -a "release:stage" -d "Perform a release from SCM to a staging repository"
complete -c mvn -a "release:update-versions" -d "Update the POM versions for a project"
complete -c mvn -a "release:prepare" -d "Prepare for a release in SCM"
complete -c mvn -a "release:clean" -d "Clean up after a release preparation"
complete -c mvn -a "release:help" -d "Display help information on maven-release-plugin"
complete -c mvn -a "release:branch" -d "Branch a project in SCM"
complete -c mvn -a "remote-resources:process" -d "Pull down resourceBundles containing remote resources and process the resources contained inside"
complete -c mvn -a "remote-resources:help" -d "Display help information on maven-remote-resources-plugin"
complete -c mvn -a "remote-resources:bundle" -d "Bundle up resources that should be considered as a remote-resource."
complete -c mvn -a "repository:bundle-create" -d "Goal which creates an upload bundle for a project built with Maven."
complete -c mvn -a "repository:bundle-pack" -d "Packs artifacts already available in a local repository in a bundle for an upload requests"
complete -c mvn -a "repository:help" -d "Display help information on maven-repository-plugin"
complete -c mvn -a "scm:status" -d "Display the modification status of the files in the configured scm url."
complete -c mvn -a "scm:branch" -d "Branch the project."
complete -c mvn -a "scm:validate" -d "Validate scm connection string."
complete -c mvn -a "scm:checkin" -d "Commit changes to the configured scm url."
complete -c mvn -a "scm:diff" -d "Display the difference of the working copy with the latest copy in the configured scm url."
complete -c mvn -a "scm:update" -d "Update the local working copy with the latest source from the configured scm url."
complete -c mvn -a "scm:add" -d "Add a file set to the project."
complete -c mvn -a "scm:remove" -d "Mark a set of files for deletion."
complete -c mvn -a "scm:unedit" -d "Unedit/unlock a set of files."
complete -c mvn -a "scm:bootstrap" -d "Pull the project source from the configured scm and execute the configured goals."
complete -c mvn -a "scm:checkout" -d "Get a fresh copy of the latest source from the configured scm url."
complete -c mvn -a "scm:tag" -d "Tag the project."
complete -c mvn -a "scm:edit" -d "Edit/lock a set of files."
complete -c mvn -a "scm:check-local-modification" -d "This mojo will fail the build if there is any local modifications"
complete -c mvn -a "scm:list" -d "Get the list of project files."
complete -c mvn -a "scm:changelog" -d "Dump changelog contents to console. It is mainly used to test maven-scm-api's changelog command."
complete -c mvn -a "scm:help" -d "Display help information on maven-scm-plugin"
complete -c mvn -a "scm:export" -d "Get a fresh exported copy of the latest source from the configured scm url."
complete -c mvn -a "scm:update-subprojects" -d "Updates all projects in a multi project build"
complete -c mvn -a "scm-publish:publish-scm" -d "Publish a content to scm"
complete -c mvn -a "scm-publish:help" -d "Display help information on maven-scm-publish-plugin"
complete -c mvn -a "scm-publish:scmpublish" -d "Empty goal, provided only to set loose the lifecycle."
complete -c mvn -a "stage:copy" -d "Copies artifacts from one repository to another repository."
complete -c mvn -a "stage:help" -d "Display help information on maven-stage-plugin"
complete -c mvn -a "toolchains:help" -d "Display help information on maven-toolchains-plugin"
complete -c mvn -a "toolchains:toolchain" -d "Check that toolchains requirements are met by currently configured toolchains"
complete -c mvn -a "eclipse:clean" -d "Deletes the .project, .classpath, .wtpmodules files and .settings folder used by Eclipse."
complete -c mvn -a "eclipse:configure-workspace" -d "Configure Eclipse Workspace features"
complete -c mvn -a "eclipse:eclipse" -d "Generate Eclipse configuration files"
complete -c mvn -a "eclipse:help" -d "Display help information on maven-eclipse-plugin"
complete -c mvn -a "eclipse:install-plugins" -d "Install plugins resolved from the Maven repository system into an Eclipse instance."
complete -c mvn -a "eclipse:myeclipse" -d "Generates MyEclipse configuration files"
complete -c mvn -a "eclipse:myeclipse-clean" -d "Deletes configuration files used by MyEclipse"
complete -c mvn -a "eclipse:rad" -d "Generates the rad-6 configuration files."
complete -c mvn -a "eclipse:rad-clean" -d "Deletes the config files used by Rad-6. the files .j2ee and the file .websettings"
complete -c mvn -a "eclipse:remove-cache" -d "Removes the not-available marker files from the repository."
complete -c mvn -a "eclipse:resolve-workspace-dependencies" -d "For all projects currently part of the workspace, all references to the M2_REPO classpath variable are resolved"
complete -c mvn -a "eclipse:to-maven" -d "Add eclipse artifacts from an eclipse installation to the local repo"
complete -c mvn -a "jboss-packaging:har-exploded" -d "Builds a deployable JBoss Hibernate exploded Archive."
complete -c mvn -a "jboss-packaging:esb" -d "Builds a deployable JBoss ESB Archive."
complete -c mvn -a "jboss-packaging:esb-exploded" -d "Builds a deployable JBoss ESB exploded Archive."
complete -c mvn -a "jboss-packaging:aop" -d "Builds a deployable JBoss AOP Archive."
complete -c mvn -a "jboss-packaging:spring" -d "Builds a deployable JBoss Spring Archive."
complete -c mvn -a "jboss-packaging:har" -d "Builds a deployable JBoss Hibernate Archive"
complete -c mvn -a "jboss-packaging:help" -d "Display help information on jboss-packaging-maven-plugin"
complete -c mvn -a "jboss-packaging:par" -d "Builds a deployable JBoss Process Archive."
complete -c mvn -a "jboss-packaging:sar" -d "Builds a deployable JBoss Service Archive."
complete -c mvn -a "jboss-packaging:sar-inplace" -d "Builds a deployable JBoss Service in place exploded Archive."
complete -c mvn -a "jboss-packaging:sar-exploded" -d "Builds a deployable JBoss Service exploded Archive."
complete -c mvn -a "was6:wsAdmin" -d "The wsadmin goal executes the WebSphere command-line administration tool with the specified arguments."
complete -c mvn -a "was6:wsListApps" -d "Lists all the applications installed on a WebSphere Server or Cell"
complete -c mvn -a "was6:wsStartServer" -d "Starts a standalone server instance"
complete -c mvn -a "was6:wsStartApp" -d "Start an application on a WebSphere Server or in a WebSphere Cell"
complete -c mvn -a "was6:clean" -d "Cleans out temporary resources and generated sources."
complete -c mvn -a "was6:wsStopServer" -d "Stop a standalone server instance"
complete -c mvn -a "was6:wsStopApp" -d "Stop an application on a WebSphere Server or in a WebSphere Cell"
complete -c mvn -a "was6:servicedeploy" -d "Executes the ServiceDeploy command against an archive file (Ear, Zip or Jar) to produce an ear file that can be deployed on Process Server"
complete -c mvn -a "was6:installApp" -d "Installs an EAR into WebSphere Application Server."
complete -c mvn -a "was6:wsDefaultBindings" -d "Generate default IBM WebSphere Bindings for the specified EAR file"
complete -c mvn -a "was6:endpointEnabler" -d "Executes the endpoint enabler ant task on the EAR archive."
complete -c mvn -a "was6:wsdl2java" -d "Creates Java classes and deployment descriptor templates from a Web Services Description Language (WSDL) file"
complete -c mvn -a "was6:help" -d "Display help information on was6-maven-plugin"
complete -c mvn -a "was6:ejbdeploy" -d "Generates EJB RMIC stub sources"
complete -c mvn -a "was6:wsUninstallApp" -d "Uninstall an existing application from a WebSphere Server or Cell"
complete -c mvn -a "weblogic:stop" -d "Stop an artifact on Weblogic server(s) or cluster(s)."
complete -c mvn -a "weblogic:start" -d "Start an artifact on Weblogic server(s) or cluster(s)."
complete -c mvn -a "weblogic:undeploy" -d "Undeploy artifacts from Weblogic server(s) or cluster(s)."
complete -c mvn -a "weblogic:appc" -d "Run the weblogic appc compiler against an artifact."
complete -c mvn -a "weblogic:clientgen9" -d "Runs Client Gen on a given WSDL"
complete -c mvn -a "weblogic:listapps" -d "List the atifacts on Weblogic server(s) or cluster(s)."
complete -c mvn -a "weblogic:help" -d "Display help information on weblogic-maven-plugin"
complete -c mvn -a "weblogic:wsdlgen" -d "This class generates wsdl from ear/war package"
complete -c mvn -a "weblogic:redeploy" -d "Redeploy artifact on Weblogic server(s) or cluster(s)."
complete -c mvn -a "weblogic:jwsc" -d "Runs the JWSC compiler task for web service enabled code."
complete -c mvn -a "weblogic:servicegen" -d "Runs Service Gen on a given WSDL."
complete -c mvn -a "weblogic:deploy" -d "Deploy an artifact to Weblogic servers(s) or cluster(s)."
complete -c mvn -a "antlr:help" -d "Display help information on antlr-maven-plugin"
complete -c mvn -a "antlr:html" -d "Generates Antlr documentation from grammar files."
complete -c mvn -a "antlr:generate" -d "Generates files based on grammar files with Antlr tool."
complete -c mvn -a "aspectj:aspectj-report" -d "Creates an AspectJ HTML report using the ajdoc tool and format."
complete -c mvn -a "aspectj:compile" -d "Weaves all main classes."
complete -c mvn -a "aspectj:EclipseAjcMojo" -d "Create eclipse configuration of aspectJ"
complete -c mvn -a "aspectj:help" -d "Display help information on aspectj-maven-plugin"
complete -c mvn -a "aspectj:test-compile" -d "Weaves all test classes."
complete -c mvn -a "axistools:java2wsdl" -d "A Plugin for generating WSDL files using Axis Java2WSDL."
complete -c mvn -a "axistools:help" -d "Display help information on axistools-maven-plugin"
complete -c mvn -a "axistools:wsdl2java" -d "A Plugin for generating stubs for WSDL files using Axis WSDL2Java."
complete -c mvn -a "axistools:admin" -d "Utility for turning xml into Axis deployment operations (wraps org.apache.axis.utils.Admin)"
complete -c mvn -a "castor:help" -d "Display help information on castor-maven-plugin"
complete -c mvn -a "castor:mappings" -d "A mojo that uses Castor MappingTool to generate mapping files from a set of Classes. MappingTool."
complete -c mvn -a "castor:mapping" -d "A mojo that uses Castor MappingTool to generate mapping files from a single Class. MappingTool."
complete -c mvn -a "castor:generate" -d "A mojo that uses Castor to generate a collection of javabeans from an XSD"
complete -c mvn -a "commons-attributes:compile" -d "Commons-attributes compiler."
complete -c mvn -a "commons-attributes:test-compile" -d "Commons-attributes compiler for tests."
complete -c mvn -a "gwt:debug" -d "Runs the project with a debugger port hook (optionally suspended)."
complete -c mvn -a "gwt:mergewebxml" -d "Merges GWT servlet elements into deployment descriptor (and non GWT servlets into shell)"
complete -c mvn -a "gwt:help" -d "Display help information on gwt-maven-plugin"
complete -c mvn -a "gwt:compile" -d "Invokes the GWT Compiler"
complete -c mvn -a "gwt:source-jar" -d "Add GWT java source code and module descriptor as resources to project jar"
complete -c mvn -a "gwt:resources" -d "Copy GWT java source code and module descriptor as resources in the build outputDirectory"
complete -c mvn -a "gwt:compile-report" -d "see http://code.google.com/webtoolkit/doc/latest/DevGuideCompileReport.html#Usage"
complete -c mvn -a "gwt:css" -d "Creates CSS interfaces for css files"
complete -c mvn -a "gwt:run-codeserver" -d "Runs GWT modules with Super Dev Mode."
complete -c mvn -a "gwt:eclipseTest" -d "Goal which creates Eclipse lauch configurations for GWTTestCases."
complete -c mvn -a "gwt:test" -d "Mimic surefire to run GWTTestCases during integration-test phase, until SUREFIRE-508 is fixed"
complete -c mvn -a "gwt:clean" -d "Cleanup the webapp directory for GWT module compilation output"
complete -c mvn -a "gwt:generateAsync" -d "Goal which generate Async interface."
complete -c mvn -a "gwt:i18n" -d "Creates I18N interfaces for constants and messages files."
complete -c mvn -a "gwt:run" -d "Runs the project in the GWT (Classic or Super) Dev Mode for development."
complete -c mvn -a "gwt:eclipse" -d "Goal which creates Eclipse lauch configurations for GWT modules."
complete -c mvn -a "hibernate3:hbm2doc" -d "'hbm2doc' generates html documentation a'la javadoc for the database schema."
complete -c mvn -a "hibernate3:hbm2hbmxml" -d "Generate a set of .hbm files"
complete -c mvn -a "hibernate3:hbm2dao" -d "Generate a set of DAOs."
complete -c mvn -a "hibernate3:query" -d "Execute a HQL query statements"
complete -c mvn -a "hibernate3:instrument" -d "Goal for 'cglib' or 'javassist' instrumentation."
complete -c mvn -a "hibernate3:run" -d "'AntRun' wrapper."
complete -c mvn -a "hibernate3:hbmtemplate" -d "'hbmtemplate' generic exporter that can be controlled by a user provided template or class."
complete -c mvn -a "hibernate3:hbm2cfgxml" -d "'hbm2cfgxml' generates a hibernate.cfg.xml"
complete -c mvn -a "hibernate3:hbm2ddl" -d "'hbm2ddl' lets you run schemaexport and schemaupdate which generates the appropriate SQL DDL"
complete -c mvn -a "hibernate3:help" -d "Display help information on hibernate3-maven-plugin"
complete -c mvn -a "hibernate3:hbmlint" -d "'hbmlint' scans mappings for errors"
complete -c mvn -a "hibernate3:hbm2java" -d "'hbm2java' is a java code generator"
complete -c mvn -a "idlj:generate-test" -d "Process CORBA IDL test files in IDLJ"
complete -c mvn -a "idlj:help" -d "Display help information on idlj-maven-plugin"
complete -c mvn -a "idlj:generate" -d "Process CORBA IDL files in IDLJ."
complete -c mvn -a "javacc:jjtree" -d "Parses a JJTree grammar file (*.jjt) and transforms it to Java source files and a JavaCC grammar file"
complete -c mvn -a "javacc:jtb" -d "Parses a JTB file and transforms it into source files for an AST and a JavaCC grammar file which automatically builds the AST"
complete -c mvn -a "javacc:jjdoc" -d "JJDoc takes a JavaCC parser specification and produces documentation for the BNF grammar"
complete -c mvn -a "javacc:jtb-javacc" -d "Preprocesses ordinary grammar files (*.jtb) with JTB and passes the output to JavaCC in order to finally generate a parser with parse tree actions"
complete -c mvn -a "javacc:help" -d "Display help information on javacc-maven-plugin"
complete -c mvn -a "javacc:jjtree-javacc" -d "Preprocesses decorated grammar files (*.jjt) with JJTree and passes the output to JavaCC in order to finally generate a parser with parse tree actions."
complete -c mvn -a "javacc:javacc" -d "Parses a JavaCC grammar file (*.jj) and transforms it to Java source files. Detailed information about the JavaCC options can be found on the JavaCC website."
complete -c mvn -a "jaxb2:help" -d "Display help information on jaxb2-maven-plugin"
complete -c mvn -a "jaxb2:schemagen" -d "Mojo that creates XML schema(s) from compile-scope Java sources or binaries by invoking the JAXB SchemaGenerator"
complete -c mvn -a "jaxb2:testSchemagen" -d "Mojo that creates XML schema(s) from test-scope Java testSources or binaries by invoking the JAXB SchemaGenerator"
complete -c mvn -a "jaxb2:testXjc" -d "Mojo that creates test-scope Java source or binaries from XML schema(s) by invoking the JAXB XJC binding compiler"
complete -c mvn -a "jaxb2:xjc" -d "Mojo that creates compile-scope Java source or binaries from XML schema(s) by invoking the JAXB XJC binding compiler"
complete -c mvn -a "jpox:enhance"
complete -c mvn -a "jpox:schema-create" -d "Generates the Schema from the JDO mappings and the enhanced class files."
complete -c mvn -a "jpox:schema-dbinfo" -d "Provides detailed information about the database - limits and datatypes support"
complete -c mvn -a "jpox:schema-delete" -d "Deletes all database tables required for a set of JDO MetaData files (and enhanced classes) from the database schema."
complete -c mvn -a "jpox:schema-info" -d "Provides a detailed information about the database schema. The output is written to console/terminal. "
complete -c mvn -a "jpox:schema-validate" -d "Validates all database tables required for a set of JDO MetaData files (and classes) for correct structure"
complete -c mvn -a "jslint:test-jslint" -d "Goal which reports on the test source files using JSLint."
complete -c mvn -a "jslint:jslint" -d "Goal which reports on the source files using JSLint."
complete -c mvn -a "jslint:help" -d "Display help information on jslint-maven-plugin"
complete -c mvn -a "js-import:test-generate-html" -d "Test goal implementation of the generate html mojo."
complete -c mvn -a "js-import:generate-html" -d "Main goal implementation of the generate html mojo."
complete -c mvn -a "js-import:test-import-js" -d "Test goal implementation of the import mojo."
complete -c mvn -a "js-import:import-js" -d "Main goal implementation of the import mojo."
complete -c mvn -a "js-import:help" -d "Display help information on js-import-maven-plugin"
complete -c mvn -a "jspc:compile"
complete -c mvn -a "jspc:testCompile"
complete -c mvn -a "openjpa:test-enhance" -d "Processes Application model classes and enhances them by running Open JPA Enhancer tool."
complete -c mvn -a "openjpa:help" -d "Display help information on openjpa-maven-plugin"
complete -c mvn -a "openjpa:enhance" -d "Processes Application model classes and enhances them by running Open JPA Enhancer tool"
complete -c mvn -a "openjpa:schema" -d "Executes the schema generation via the OpenJPA MappingTool."
complete -c mvn -a "openjpa:sql" -d "Executes the SQL generation via the OpenJPA MappingTool."
complete -c mvn -a "rmic:help" -d "Display help information on rmic-maven-plugin"
complete -c mvn -a "rmic:test-rmic" -d "Compiles rmi stubs and skeleton classes from a remote implementation class"
complete -c mvn -a "rmic:rmic" -d "Compiles rmi stubs and skeleton classes from a remote implementation class."
complete -c mvn -a "rmic:package" -d "Creates a jar containing the rmic generated classes."
complete -c mvn -a "sablecc:generate" -d "A plugin for processing grammar files in SableCC."
complete -c mvn -a "sqlj:sqlj" -d "Translates SQLJ source code using the SQLJ Translator."
complete -c mvn -a "sqlj:clean" -d "Cleans out generated stale resources."
complete -c mvn -a "sqlj:help" -d "Display help information on sqlj-maven-plugin"
complete -c mvn -a "xdoclet:help" -d "Display help information on xdoclet-maven-plugin"
complete -c mvn -a "xdoclet:xdoclet" -d "Runs XDoclet."
complete -c mvn -a "xmlbeans:xmlbeans-test" -d "A Maven 2 plugin which parses xsd files and produces a corresponding object model based on the Apache XML Beans parser"
complete -c mvn -a "xmlbeans:help" -d "Display help information on xmlbeans-maven-plugin"
complete -c mvn -a "xmlbeans:xmlbeans" -d "A Maven 2 plugin which parses xsd files and produces a corresponding object model based on the Apache XML Beans parser"
complete -c mvn -a "nbm:autoupdate" -d "Create the NetBeans auto update site definition."
complete -c mvn -a "nbm:branding" -d "Package branding resources for NetBeans platform/IDE based application"
complete -c mvn -a "nbm:build-installers" -d "Build installers for Mavenized NetBeans application"
complete -c mvn -a "nbm:cluster" -d "Create the NetBeans module clusters from reactor"
complete -c mvn -a "nbm:cluster-app" -d "Create the NetBeans module clusters/application for the 'nbm-application' packaging projects"
complete -c mvn -a "nbm:help" -d "Display help information on nbm-maven-plugin"
complete -c mvn -a "nbm:manifest" -d "Goal for generating NetBeans module system specific manifest entries, part of nbm lifecycle/packaging"
complete -c mvn -a "nbm:nbm" -d "Create the NetBeans module artifact (nbm file), part of 'nbm' lifecycle/packaging."
complete -c mvn -a "nbm:run-ide" -d "Run NetBeans IDE with additional custom module clusters, to be used in conjunction with nbm:cluster"
complete -c mvn -a "nbm:run-platform" -d "Run a branded application on top of NetBeans Platform"
complete -c mvn -a "nbm:standalone-zip" -d "Create a standalone application out of the composed clusters of nbm-application"
complete -c mvn -a "nbm:webstart-app" -d "Create webstartable binaries for a 'nbm-application'."
complete -c mvn -a "clirr:clirr" -d "Generate a report from the Clirr output."
complete -c mvn -a "clirr:check-arbitrary" -d "Check for compatibility between two arbitrary artifact sets."
complete -c mvn -a "clirr:help" -d "Display help information on clirr-maven-plugin"
complete -c mvn -a "clirr:check" -d "Check for compatibility with previous version."
complete -c mvn -a "clirr:check-no-fork" -d "Check for compatibility with previous version without forking the project"
complete -c mvn -a "cobertura:check" -d "Check the coverage percentages for unit tests from the last instrumentation, and optionally fail the build if the targets are not met"
complete -c mvn -a "cobertura:check-integration-test" -d "Check the coverage percentages for unit tests and integration tests from the last instrumentation, and optionally fail the build if the targets are not met"
complete -c mvn -a "cobertura:clean" -d "Clean up the files that Cobertura Maven Plugin has created during instrumentation."
complete -c mvn -a "cobertura:cobertura" -d "Instrument the compiled classes, run the unit tests and generate a Cobertura report."
complete -c mvn -a "cobertura:cobertura-integration-test" -d "Instrument the compiled classes, run the unit tests and integration tests and generate a Cobertura report."
complete -c mvn -a "cobertura:dump-datafile" -d "Output the contents of Cobertura's data file to the command line."
complete -c mvn -a "cobertura:help" -d "Display help information on cobertura-maven-plugin"
complete -c mvn -a "cobertura:instrument" -d "Instrument the compiled classes."
complete -c mvn -a "scmchangelog:report" -d "Goal which produces a changelog report based on the Subversion logs."
complete -c mvn -a "scmchangelog:help" -d "Display help information on scmchangelog-maven-plugin"
complete -c mvn -a "sonar:help" -d "Display help information on sonar-maven-plugin"
complete -c mvn -a "sonar:sonar" -d "Analyze project"
complete -c mvn -a "taglist:taglist" -d "Scans the source files for tags and generates a report on their occurrences."
complete -c mvn -a "taglist:help" -d "Display help information on taglist-maven-plugin"
complete -c mvn -a "javancss:check" -d "Check the build if for any Method with a ccn greater than a limit in the source code"
complete -c mvn -a "javancss:help" -d "Display help information on javancss-maven-plugin"
complete -c mvn -a "javancss:report" -d "Generates a JavaNCSS report based on this module's source code."
complete -c mvn -a "jdepend:generate-no-fork" -d "Run JDepend and generate a site report"
complete -c mvn -a "jdepend:help" -d "Display help information on jdepend-maven-plugin"
complete -c mvn -a "jdepend:generate" -d "Run JDepend and generate a site report"
complete -c mvn -a "codenarc:codenarc" -d "Create a CodeNarc Report."
complete -c mvn -a "codenarc:help" -d "Display help information on codenarc-maven-plugin"
complete -c mvn -a "findbugs:check"
complete -c mvn -a "findbugs:findbugs"
complete -c mvn -a "findbugs:gui" -d "Open the findbugs GUI to browse the report"
complete -c mvn -a "findbugs:help" -d "Display help information on findbugs-maven-plugin"
complete -c mvn -a "fitnesse:remotecall" -d "This goal uses the fitnesse.runner.TestRunner class for getting result of a remote FitNesse web page execution"
complete -c mvn -a "fitnesse:help" -d "Display help information on fitnesse-maven-plugin"
complete -c mvn -a "fitnesse:run" -d "This goal uses the fitnesse.runner.TestRunner class for calling a remote FitNesse web page and executes the tests or suites locally into a forked JVM"
complete -c mvn -a "fitnesse:fitnesse" -d "Generates a FitNesse report from a FitNesse web server"
complete -c mvn -a "selenium:start-server" -d "Start the Selenium server."
complete -c mvn -a "selenium:xvfb" -d "Starts an Xvfb instance suitable for handling X11 displays for headless systems"
complete -c mvn -a "selenium:stop-server" -d "Stop the Selenium server."
complete -c mvn -a "selenium:selenese" -d "Run a suite of HTML Selenese tests."
complete -c mvn -a "selenium:help" -d "Display help information on selenium-maven-plugin"
complete -c mvn -a "webtest:help" -d "Display help information on webtest-maven-plugin"
complete -c mvn -a "webtest:verify-filecontent" -d "Allows grepping through a set of files to find particular text strings and fail the build if one or matches are found"
complete -c mvn -a "webtest:clean" -d "Remove temporary data from running the Canoo WebTests"
complete -c mvn -a "webtest:test" -d "Runs a Canoo WebTest defined in an ANT script."
complete -c mvn -a "webtest:loop" -d "Runs a Canoo WebTest in a loop until an error or failure occurs"
complete -c mvn -a "webtest:info" -d "Prints the configuration settings."
complete -c mvn -a "webtest:report" -d "Creates the HTML report for a test run based on XSLT."
complete -c mvn -a "webtest:verify-result" -d "Checks the webtest result file for test failures and throws an exception if one or more tests failed"
complete -c mvn -a "chronos-jmeter:jmeter" -d "Invokes JMeter"
complete -c mvn -a "chronos-jmeter:check" -d "Checks the latest performancetests to verify that performance targets have been met"
complete -c mvn -a "chronos-jmeter:jmetergui" -d "Invokes the JMeter gui"
complete -c mvn -a "chronos-jmeter:jmeteroutput" -d "Analyzes output from JMeter"
complete -c mvn -a "chronos-jmeter:help" -d "Display help information on chronos-jmeter-maven-plugin"
complete -c mvn -a "chronos-jmeter:savehistory" -d "Save a snapshot of the currently executed test to enable later historic reports."
complete -c mvn -a "chronos-surefire:help" -d "Display help information on chronos-surefire-maven-plugin"
complete -c mvn -a "chronos-surefire:collect" -d "Goal which collects the execution of each performed unittest, and compares the execution time to previous measured execution times for the same test"
complete -c mvn -a "chronos-report:historyreport" -d "Creates a historic report of performance test results."
complete -c mvn -a "chronos-report:report" -d "Creates a report of the currently executed performancetest in html format."
complete -c mvn -a "chronos-report:help" -d "Display help information on chronos-report-maven-plugin"
complete -c mvn -a "animal-sniffer:build" -d "Generates an API Signature from at least one of: the java runtime, the module dependencies and the module classes."
complete -c mvn -a "animal-sniffer:check" -d "Checks the classes compiled by this module."
complete -c mvn -a "animal-sniffer:help" -d "Display help information on animal-sniffer-maven-plugin"
complete -c mvn -a "appassembler:generate-daemons" -d "Generates JSW based daemon wrappers."
complete -c mvn -a "appassembler:assemble" -d "Assembles the artifacts and generates bin scripts for the configured applications"
complete -c mvn -a "appassembler:create-repository" -d "Creates an appassembler repository"
complete -c mvn -a "appassembler:help" -d "Display help information on appassembler-maven-plugin"
complete -c mvn -a "build-helper:parse-version" -d "Parse a version string and set properties containing the component parts of the version"
complete -c mvn -a "build-helper:bsh-property" -d "Define one or many properties as a result of a Beanshell script invocation"
complete -c mvn -a "build-helper:add-resource" -d "Add more resource directories to the POM."
complete -c mvn -a "build-helper:maven-version" -d "Store the maven core version in a property maven.version."
complete -c mvn -a "build-helper:attach-artifact" -d "Attach additional artifacts to be installed and deployed."
complete -c mvn -a "build-helper:add-test-source" -d "Add test source directories to the POM."
complete -c mvn -a "build-helper:released-version" -d "Resolve the latest released version of this project"
complete -c mvn -a "build-helper:local-ip" -d "Retrieve current host IP address and place it under a configurable project property"
complete -c mvn -a "build-helper:reserve-network-port" -d "Reserve a list of random and not in use network ports and place them in a configurable project properties."
complete -c mvn -a "build-helper:remove-project-artifact" -d "Remove project's artifacts from local repository"
complete -c mvn -a "build-helper:add-source" -d "Add more source directories to the POM."
complete -c mvn -a "build-helper:add-test-resource" -d "Add more test resource directories to the POM."
complete -c mvn -a "build-helper:cpu-count" -d "Retrieve number of CPUs with project factor, and place it under a configurable project property"
complete -c mvn -a "build-helper:timestamp-property" -d "Sets a property based on the current date and time."
complete -c mvn -a "build-helper:regex-properties" -d "Sets a property by applying a regex replacement rule to a supplied value"
complete -c mvn -a "build-helper:regex-property" -d "Sets a property by applying a regex replacement rule to a supplied value."
complete -c mvn -a "build-helper:help" -d "Display help information on build-helper-maven-plugin"
complete -c mvn -a "buildnumber:create-timestamp" -d "This mojo is designed to give you a timestamp available through one or more properties"
complete -c mvn -a "buildnumber:create" -d "This mojo is designed to give you a build number"
complete -c mvn -a "buildnumber:help" -d "Display help information on buildnumber-maven-plugin"
complete -c mvn -a "buildnumber:hgchangeset" -d "Goal which sets project properties for changeSet and changeSetDate from the current Mercurial repository."
complete -c mvn -a "cassandra:help" -d "Display help information on cassandra-maven-plugin"
complete -c mvn -a "cassandra:load" -d "Loads a cassandra-cli bscript into a Cassandra instance."
complete -c mvn -a "cassandra:delete" -d "Deletes the Cassandra home directory that we create for running Cassandra."
complete -c mvn -a "cassandra:start-cluster" -d "Starts a Cassandra instance in the background."
complete -c mvn -a "cassandra:cu-load" -d "Loads a CassandraUnit DataSet into a Cassandra instance."
complete -c mvn -a "cassandra:stop-cluster" -d "Stops a background Cassandra instance."
complete -c mvn -a "cassandra:repair" -d "Runs nodetool repair on a Cassandra instance."
complete -c mvn -a "cassandra:cql-exec" -d "Executes cql statements from maven."
complete -c mvn -a "cassandra:stop" -d "Stops a background Cassandra instance."
complete -c mvn -a "cassandra:flush" -d "Runs nodetool flush on a Cassandra instance."
complete -c mvn -a "cassandra:run" -d "Runs Cassandra in the foreground."
complete -c mvn -a "cassandra:start" -d "Starts a Cassandra instance in the background."
complete -c mvn -a "cassandra:cleanup" -d "Runs nodetool cleanup on a Cassandra instance."
complete -c mvn -a "cassandra:compact" -d "Runs nodetool compact on a Cassandra instance."
complete -c mvn -a "ditaot:help" -d "Display help information on ditaot-maven-plugin"
complete -c mvn -a "ditaot:version" -d "Display DITA Open Toolkit's built-in version, with option to insert a custom version found under \${dita.dir}/ditaotVersionPath, via version property to Maven's \${versionName}"
complete -c mvn -a "ditaot:eclipse" -d "Generate http://www.dita-op.org's Eclipse configuration to allow editing, previewing DITA under Eclipse IDE."
complete -c mvn -a "ditaot:print-help" -d "Display DITA Open Toolkit's common Ant properties usage"
complete -c mvn -a "ditaot:chm2web" -d "Convert DITA Open Toolkit's Microsoft CHM output file, produced by htmlhelp transtype, to pure HTML set of files"
complete -c mvn -a "ditaot:run" -d "Execute DITA Open Toolkit's Ant command line to transform DITA files to desired output format"
complete -c mvn -a "exec:exec" -d "A Plugin for executing external programs."
complete -c mvn -a "exec:help" -d "Display help information on exec-maven-plugin"
complete -c mvn -a "exec:java" -d "Executes the supplied java class in the current VM with the enclosing project's dependencies as classpath."
complete -c mvn -a "keytool:clean" -d "A Mojo that deletes a generated keystore file."
complete -c mvn -a "keytool:exportCertificate" -d "To export a certificate from a keystore"
complete -c mvn -a "keytool:changeKeyPassword" -d "To change the key password of an entry of a keystore"
complete -c mvn -a "keytool:generateSecretKey" -d "To generate a secret key into a keystore"
complete -c mvn -a "keytool:importKeystore" -d "To import all entries of a keystore to another keystore"
complete -c mvn -a "keytool:changeStorePassword" -d "To change the store password of a keystore"
complete -c mvn -a "keytool:importCertificate" -d "To import a certificate into a keystore"
complete -c mvn -a "keytool:generateCertificateRequest" -d "To generate certificate request"
complete -c mvn -a "keytool:list" -d "To list entries in a keystore"
complete -c mvn -a "keytool:printCertificateRequest" -d "To print the content of a certificate request"
complete -c mvn -a "keytool:printCertificate" -d "To print the content of a certificate"
complete -c mvn -a "keytool:deleteAlias" -d "To delete an entry alias from a keystore"
complete -c mvn -a "keytool:help" -d "Display help information on keytool-maven-plugin"
complete -c mvn -a "keytool:generateKeyPair" -d "To generate a key pair into a keystore"
complete -c mvn -a "keytool:changeAlias" -d "To change an entry alias into a keystore"
complete -c mvn -a "keytool:printCRLFile" -d "To print the content of a CRL file"
complete -c mvn -a "keytool:generateCertificate" -d "To generate certificate from a certificate request from a keystore"
complete -c mvn -a "latex:help" -d "Display help information on latex-maven-plugin"
complete -c mvn -a "latex:latex" -d "LaTeX documents building goal."
complete -c mvn -a "license:third-party-report" -d "Generates a report of all third-parties detected in the module."
complete -c mvn -a "license:check-file-header" -d "The goal to check if the state of header on project source files."
complete -c mvn -a "license:add-third-party" -d "Goal to generate the third-party license file"
complete -c mvn -a "license:update-project-license" -d "Updates (or creates) the main project license file according to the given license defines as licenseName"
complete -c mvn -a "license:help" -d "Display help information on license-maven-plugin"
complete -c mvn -a "license:aggregate-add-third-party" -d "This goal forks executions of the add-third-party goal for all the leaf projects of the tree of modules below the point where it is executed"
complete -c mvn -a "license:license-list" -d "Display all available licenses."
complete -c mvn -a "license:comment-style-list" -d "Displays all the available comment style to box file headers."
complete -c mvn -a "license:update-file-header" -d "The goal to update (or add) the header on project source files"
complete -c mvn -a "license:download-licenses" -d "Download the license files of all the current project's dependencies, and generate a summary file containing a list of all dependencies and their licenses."
complete -c mvn -a "ounce:report" -d "Generate the scan results as part of the site."
complete -c mvn -a "ounce:application" -d "This mojo generates an Ounce application file"
complete -c mvn -a "ounce:scan" -d "This mojo allows an on demand scan of an application and the optional publishing of the results."
complete -c mvn -a "ounce:project-only" -d "This mojo generates an Ounce project file"
complete -c mvn -a "ounce:project" -d "This mojo generates an Ounce project file"
complete -c mvn -a "ounce:help" -d "Display help information on ounce-maven-plugin"
complete -c mvn -a "rpm:attached-rpm" -d "Construct the RPM file and attaches it as a secondary artifact."
complete -c mvn -a "rpm:help" -d "Display help information on rpm-maven-plugin"
complete -c mvn -a "rpm:rpm" -d "Construct the RPM file."
complete -c mvn -a "rpm:version" -d "Makes the rpm version and release attributes available as properties."
complete -c mvn -a "siteskinner:skin" -d "Call mvn siteskinner:skin on a maven project"
complete -c mvn -a "siteskinner:help" -d "Display help information on siteskinner-maven-plugin"
complete -c mvn -a "sql:help" -d "Display help information on sql-maven-plugin"
complete -c mvn -a "sql:execute" -d "Executes SQL against a database."
complete -c mvn -a "truezip:list" -d "List all files in the archive."
complete -c mvn -a "truezip:ls" -d "Display an archive's list to console"
complete -c mvn -a "truezip:cp" -d "Copy an archive/directory to another archive/directory"
complete -c mvn -a "truezip:remove" -d "Remove a set of files from an existing archive."
complete -c mvn -a "truezip:copy" -d "Copy a set of files in and out of an existing archive."
complete -c mvn -a "truezip:move" -d "Move a single file or multiple files (via FileSet) between archives or directories."
complete -c mvn -a "truezip:help" -d "Display help information on truezip-maven-plugin"
complete -c mvn -a "truezip:update" -d "Update open archives immediately, flush cached data to disk."
complete -c mvn -a "versions:commit" -d "Removes the initial backup of the pom, thereby accepting the changes."
complete -c mvn -a "versions:compare-dependencies" -d "Compare dependency versions of the current project to dependencies or dependency management of a remote repository project"
complete -c mvn -a "versions:dependency-updates-report" -d "Generates a report of available updates for the dependencies of a project."
complete -c mvn -a "versions:display-dependency-updates" -d "Displays all dependencies that have newer versions available."
complete -c mvn -a "versions:display-parent-updates" -d "Displays any updates of the project's parent project"
complete -c mvn -a "versions:display-plugin-updates" -d "Displays all plugins that have newer versions available."
complete -c mvn -a "versions:display-property-updates" -d "Displays properties that are linked to artifact versions and have updates available."
complete -c mvn -a "versions:force-releases" -d "Replaces any -SNAPSHOT versions with a release version, older if necessary (if there has been a release)."
complete -c mvn -a "versions:help" -d "Display help information on versions-maven-plugin"
complete -c mvn -a "versions:lock-snapshots" -d "Attempts to resolve unlocked snapshot dependency versions to the locked timestamp versions used in the build"
complete -c mvn -a "versions:plugin-updates-report" -d "Generates a report of available updates for the plugins of a project."
complete -c mvn -a "versions:property-updates-report" -d "Generates a report of available updates for properties of a project which are linked to the dependencies and/or plugins of a project."
complete -c mvn -a "versions:resolve-ranges" -d "Attempts to resolve dependency version ranges to the specific version being used in the build"
complete -c mvn -a "versions:revert" -d "Restores the pom from the initial backup."
complete -c mvn -a "versions:set" -d "Sets the current project's version and based on that change propagates that change onto any child modules as necessary."
complete -c mvn -a "versions:unlock-snapshots" -d "Attempts to resolve unlocked snapshot dependency versions to the locked timestamp versions used in the build"
complete -c mvn -a "versions:update-child-modules" -d "Scans the current projects child modules, updating the versions of any which use the current project to the version of the current project."
complete -c mvn -a "versions:update-parent" -d "Sets the parent version to the latest parent version."
complete -c mvn -a "versions:update-properties" -d "Sets properties to the latest versions of specific artifacts."
complete -c mvn -a "versions:update-property" -d "Sets a property to the latest version in a given range of associated artifacts."
complete -c mvn -a "versions:use-latest-releases" -d "Replaces any release versions with the latest release version."
complete -c mvn -a "versions:use-latest-snapshots" -d "Replaces any release versions with the latest snapshot version (if it has been deployed)."
complete -c mvn -a "versions:use-latest-versions" -d "Replaces any version with the latest version."
complete -c mvn -a "versions:use-next-releases" -d "Replaces any release versions with the next release version (if it has been released)."
complete -c mvn -a "versions:use-next-snapshots" -d "Replaces any release versions with the next snapshot version (if it has been deployed)."
complete -c mvn -a "versions:use-next-versions" -d "Replaces any version with the latest version."
complete -c mvn -a "versions:use-reactor" -d "Replaces any versions with the corresponding version from the reactor."
complete -c mvn -a "versions:use-releases" -d "Replaces any -SNAPSHOT versions with the corresponding release version (if it has been released)."
complete -c mvn -a "vfs:copy" -d "Copy files from one VFS to another VFS"
complete -c mvn -a "vfs:help" -d "Display help information on vfs-maven-plugin"
complete -c mvn -a "vfs:list" -d "Display file list of a virtual file system."
complete -c mvn -a "vfs:merge-maven-repositories" -d "Merge Maven repository from one VFS to another VFS"
complete -c mvn -a "vfs:move" -d "Move files from a virtual file system to another"
complete -c mvn -a "vfs:remove" -d "Remove files from a virtual file system"
complete -c mvn -a "xml:validate" -d "The ValidatorMojo's task is the validation of XML files against a given schema."
complete -c mvn -a "xml:help" -d "Display help information on xml-maven-plugin"
complete -c mvn -a "xml:transform" -d "The TransformMojo is used for transforming a set of files using a common stylesheet."
complete -c mvn -a "nexus-staging:rc-release" -d "Releases a single closed Nexus staging repository into a permanent Nexus repository for general consumption."
complete -c mvn -a "nexus-staging:close" -d "Closes a Nexus staging repository."
complete -c mvn -a "nexus-staging:deploy" -d "Alternative deploy mojo, that will select proper DeployStrategy to perform deploys"
complete -c mvn -a "nexus-staging:promote" -d "Promotes a closed Nexus staging repository into a Nexus Build Promotion Profile."
complete -c mvn -a "nexus-staging:deploy-staged" -d "Deploys the (previously) locally staged artifacts from nexus-staging repository, that were staged using DeployMojo and having the DeployMojo.skipRemoteStaging flag set to true."
complete -c mvn -a "nexus-staging:rc-drop" -d "Drops a Nexus staging repository that is either open or closed."
complete -c mvn -a "nexus-staging:rc-promote" -d "Promotes a closed Nexus staging repository into a Nexus Build Promotion Profile."
complete -c mvn -a "nexus-staging:help" -d "Display help information on nexus-staging-maven-plugin"
complete -c mvn -a "nexus-staging:drop" -d "Drops a Nexus staging repository that is either open or closed."
complete -c mvn -a "nexus-staging:deploy-staged-repository" -d "Deploys the (previously) staged artifacts from some local repository, that were staged using maven-deploy-plugin together with switch altDeploymentRepository for cases when POM modifications are not possible for some reason"
complete -c mvn -a "nexus-staging:release" -d "Releases a single closed Nexus staging repository into a permanent Nexus repository for general consumption."
complete -c mvn -a "nexus-staging:rc-list" -d "Lists staging repositories accessible by current user available on Nexus."
complete -c mvn -a "nexus-staging:rc-list-profiles" -d "Lists staging profiles accessible by current user available on Nexus."
complete -c mvn -a "nexus-staging:rc-close" -d "Closes a Nexus staging repository."
complete -c mvn -a "appengine:vacuum_indexes" -d "Delete unused indexes from application."
complete -c mvn -a "appengine:devserver_start" -d "Starts the App Engine development server and does not wait."
complete -c mvn -a "appengine:backends_start" -d "Start the specified backend."
complete -c mvn -a "appengine:devserver_stop" -d "Stops the App Engine development server."
complete -c mvn -a "appengine:backends_rollback" -d "Roll back a previously in-progress update."
complete -c mvn -a "appengine:start_module_version" -d "Start the specified module version."
complete -c mvn -a "appengine:migrate_traffic" -d "Change the default version, but more gently than set_default_version."
complete -c mvn -a "appengine:update_dispatch" -d "Update application dispatch.xml."
complete -c mvn -a "appengine:endpoints_get_client_lib" -d "App Engine endpoints get-client-lib … command."
complete -c mvn -a "appengine:debug" -d "Debug the specified VM Runtime instance."
complete -c mvn -a "appengine:set_default_version" -d "Set the default serving version."
complete -c mvn -a "appengine:enhance" -d "Runs the datanucleus enhancer."
complete -c mvn -a "appengine:update" -d "Create or update an app version."
complete -c mvn -a "appengine:create-property" -d "Maven project version is dot based, e.g '1.9.15' , whereas appengine-web.xml is dash based, e.g"
complete -c mvn -a "appengine:backends_configure" -d "Configure the specified backend."
complete -c mvn -a "appengine:update_cron" -d "Update application cron jobs."
complete -c mvn -a "appengine:devserver" -d "Runs the App Engine development server."
complete -c mvn -a "appengine:backends_delete" -d "Delete the specified backend."
complete -c mvn -a "appengine:backends_update" -d "Update the specified backend or all backends."
complete -c mvn -a "appengine:update_indexes" -d "Update application indexes."
complete -c mvn -a "appengine:update_queues" -d "Update application task queue definitions."
complete -c mvn -a "appengine:stop_module_version" -d "Stop the specified module version."
complete -c mvn -a "appengine:rollback" -d "Rollback an in-progress update."
complete -c mvn -a "appengine:update_dos" -d "Update application DoS protection configuration."
complete -c mvn -a "appengine:endpoints_get_discovery_doc" -d "App Engine endpoints get-discovery-doc command."
complete -c mvn -a "appengine:backends_stop" -d "Stop the specified backend."
complete -c mvn -a "android:aar" -d "Creates an Android Archive (aar) file"
complete -c mvn -a "android:apk" -d "Creates the apk file"
complete -c mvn -a "android:apklib" -d "Creates the apklib file"
complete -c mvn -a "android:clean"
complete -c mvn -a "android:connect" -d "Connect external IP addresses to the ADB server."
complete -c mvn -a "android:deploy" -d "Deploys the apk(s) of the current project(s) to all attached devices and emulators"
complete -c mvn -a "android:deploy-apk" -d "Deploys a specified Android application apk to attached devices and emulators"
complete -c mvn -a "android:deploy-dependencies" -d "Deploys all directly declared dependencies of <type>apk</type> in this project's pom"
complete -c mvn -a "android:devices" -d "DevicesMojo lists all attached devices and emulators found with the android debug bridge"
complete -c mvn -a "android:dex" -d "Converts compiled Java classes to the Android dex format."
complete -c mvn -a "android:disconnect" -d "Disconnect external IP addresses from the ADB server."
complete -c mvn -a "android:emma" -d "After compiled Java classes use emma tool"
complete -c mvn -a "android:emulator-start" -d "EmulatorStartMojo can start the Android Emulator with a specified Android Virtual Device (avd)."
complete -c mvn -a "android:emulator-stop" -d "EmulatorStartMojo can stop the Android Emulator with a specified Android Virtual Device (avd)."
complete -c mvn -a "android:emulator-stop-all" -d "EmulatorStopeAllMojo will stop all attached devices."
complete -c mvn -a "android:generate-sources" -d "Generates R.java based on resources specified by the resources configuration parameter"
complete -c mvn -a "android:help" -d "Display help information on android-maven-plugin"
complete -c mvn -a "android:instrument" -d "Runs the instrumentation apk on device."
complete -c mvn -a "android:internal-integration-test" -d Internal
complete -c mvn -a "android:internal-pre-integration-test" -d Internal
complete -c mvn -a "android:lint" -d "LintMojo can run the lint command against the project"
complete -c mvn -a "android:manifest-merger" -d "Manifest Merger V2 AndroidManifest.xml file"
complete -c mvn -a "android:manifest-update" -d "Updates various version attributes present in the AndroidManifest.xml file."
complete -c mvn -a "android:monkey" -d "Execute tests using UI/Application Exerciser Monkey"
complete -c mvn -a "android:monkeyrunner" -d "Execute monkey runner programs"
complete -c mvn -a "android:ndk-build"
complete -c mvn -a "android:proguard" -d "Process both application and dependency classes using the ProGuard byte code obfuscator, minimzer, and optimizer"
complete -c mvn -a "android:publish-apk"
complete -c mvn -a "android:publish-listing"
complete -c mvn -a "android:pull" -d "Copy file or directory from all the attached (or specified) devices/emulators."
complete -c mvn -a "android:push" -d "Copy file to all the attached (or specified) devices/emulators."
complete -c mvn -a "android:redeploy" -d "Undeploys and the deploys (= redeploys) the apk(s) of the current project(s) to all attached devices and emulators"
complete -c mvn -a "android:redeploy-apk" -d "Reploys a specified Android application apk to attached devices and emulators"
complete -c mvn -a "android:run" -d "Runs the first Activity shown in the top-level launcher as determined by its Intent filters"
complete -c mvn -a "android:uiautomator" -d "Can execute tests using ui uiautomator"
complete -c mvn -a "android:undeploy" -d "Undeploys the apk(s) of the current project(s) to all attached devices and emulators"
complete -c mvn -a "android:undeploy-apk" -d "Undeploys a specified Android application apk from attached devices and emulators"
complete -c mvn -a "android:unpack" -d "Unpack libraries code and dependencies into target"
complete -c mvn -a "android:zipalign" -d "ZipalignMojo can run the zipalign command against the apk"
complete -c mvn -a "liquibase:releaseLocks" -d "Removes any Liquibase updater locks from the current database."
complete -c mvn -a "liquibase:tag" -d "Writes a Liquibase tag to the database."
complete -c mvn -a "liquibase:dropAll" -d "Drops all database objects in the configured schema(s)"
complete -c mvn -a "liquibase:updateSQL" -d "Generates the SQL that is required to update the database to the current version as specified in the DatabaseChangeLogs."
complete -c mvn -a "liquibase:listLocks" -d "Lists all Liquibase updater locks on the current database."
complete -c mvn -a "liquibase:migrate" -d "Liquibase Migration Maven plugin"
complete -c mvn -a "liquibase:changelogSync" -d "Marks all unapplied changes to the database as applied in the change log."
complete -c mvn -a "liquibase:clearCheckSums" -d "Clears all checksums in the current changelog, so they will be recalculated next update."
complete -c mvn -a "liquibase:dbDoc" -d "Generates dbDocs against the database."
complete -c mvn -a "liquibase:rollbackSQL" -d "Generates the SQL that is required to rollback the database to the specified pointing attributes 'rollbackCount', 'rollbackTag'"
complete -c mvn -a "liquibase:status" -d "Prints which changesets need to be applied to the database."
complete -c mvn -a "liquibase:changelogSyncSQL" -d "Generates SQL that marks all unapplied changes as applied."
complete -c mvn -a "liquibase:updateTestingRollback" -d "Applies the DatabaseChangeLogs to the database, testing rollback"
complete -c mvn -a "liquibase:help" -d "Display help information on liquibase-maven-plugin"
complete -c mvn -a "liquibase:rollback" -d "Invokes Liquibase rollbacks on a database."
complete -c mvn -a "liquibase:futureRollbackSQL" -d "Generates the SQL that is required to rollback the database to current state after the next update."
complete -c mvn -a "liquibase:diff" -d "Generates a diff between the specified database and the reference database"
complete -c mvn -a "liquibase:update" -d "Applies the DatabaseChangeLogs to the database"
complete -c mvn -a "liquibase:generateChangeLog" -d "Generates SQL that marks all unapplied changes as applied."
complete -c mvn -a "liquibase:migrateSQL" -d "Creates an SQL migration script using the provided DatabaseChangeLog(s)"
complete -c mvn -a "jgitflow:feature-deploy"
complete -c mvn -a "jgitflow:release-finish" -d "Finishes a release"
complete -c mvn -a "jgitflow:hotfix-start" -d "Starts a hotfix"
complete -c mvn -a "jgitflow:hotfix-finish" -d "Finishes a hotfix"
complete -c mvn -a "jgitflow:feature-finish" -d "Finishes a feature branch"
complete -c mvn -a "jgitflow:build-number" -d "Updates the pom versions in the current branch by adding a build number label"
complete -c mvn -a "jgitflow:release-start" -d "Starts a release"
complete -c mvn -a "jgitflow:feature-start" -d "Starts a feature branch"
complete -c mvn -a "spring-boot:help" -d "Display help information on spring-boot-maven-plugin"
complete -c mvn -a "spring-boot:repackage" -d "Repackage JAR and WAR for use with java -jar"
complete -c mvn -a "spring-boot:run" -d "Run an executable archive application"
