/** \file
 *  This C source file was generated by $ANTLR version 3.5.2
 *
 *     -  From the grammar source file : SMARTPL2SQL.g
 *     -                            On : 2021-03-13 16:02:01
 *     -           for the tree parser : SMARTPL2SQLTreeParser
 *
 * Editing it, at least manually, is not wise.
 *
 * C language generator and runtime by Jim Idle, jimi|hereisanat|idle|dotgoeshere|ws.
 *
 *
*/
// [The "BSD license"]
// Copyright (c) 2005-2009 Jim Idle, Temporal Wave LLC
// http://www.temporal-wave.com
// http://www.linkedin.com/in/jimidle
//
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. The name of the author may not be used to endorse or promote products
//    derived from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


/* =============================================================================
 * This is what the grammar programmer asked us to put at the top of every file.
 */

	#include <stdio.h>
	#include <stdlib.h>
	#include <string.h>
	#include <limits.h>
	#include <errno.h>
	#include <time.h>
	#include <sqlite3.h>

	#include "logger.h"
	#include "db.h"

/* End of Header action.
 * =============================================================================
 */

/* -----------------------------------------
 * Include the ANTLR3 generated header file.
 */
#include    "SMARTPL2SQL.h"
/* ----------------------------------------- */





/* MACROS that hide the C interface implementations from the
 * generated code, which makes it a little more understandable to the human eye.
 * I am very much against using C pre-processor macros for function calls and bits
 * of code as you cannot see what is happening when single stepping in debuggers
 * and so on. The exception (in my book at least) is for generated code, where you are
 * not maintaining it, but may wish to read and understand it. If you single step it, you know that input()
 * hides some indirect calls, but is always referring to the input stream. This is
 * probably more readable than ctx->input->istream->input(snarfle0->blarg) and allows me to rejig
 * the runtime interfaces without changing the generated code too often, without
 * confusing the reader of the generated output, who may not wish to know the gory
 * details of the interface inheritance.
 */

#define		CTX	ctx

/* Aids in accessing scopes for grammar programmers
 */
#undef	SCOPE_TYPE
#undef	SCOPE_STACK
#undef	SCOPE_TOP
#define	SCOPE_TYPE(scope)   pSMARTPL2SQL_##scope##_SCOPE
#define SCOPE_STACK(scope)  pSMARTPL2SQL_##scope##Stack
#define	SCOPE_TOP(scope)    ctx->pSMARTPL2SQL_##scope##Top
#define	SCOPE_SIZE(scope)		ctx->pSMARTPL2SQL_##scope##Stack_limit
#define SCOPE_INSTANCE(scope, i)	(ctx->SCOPE_STACK(scope)->get(ctx->SCOPE_STACK(scope),i))

/* Macros for accessing things in the parser
 */

#undef	    PARSER
#undef	    RECOGNIZER
#undef	    HAVEPARSEDRULE
#undef	    INPUT
#undef	    STRSTREAM
#undef	    HASEXCEPTION
#undef	    EXCEPTION
#undef	    MATCHT
#undef	    MATCHANYT
#undef	    FOLLOWSTACK
#undef	    FOLLOWPUSH
#undef	    FOLLOWPOP
#undef	    PRECOVER
#undef	    PREPORTERROR
#undef	    LA
#undef	    LT
#undef	    CONSTRUCTEX
#undef	    CONSUME
#undef	    MARK
#undef	    REWIND
#undef	    REWINDLAST
#undef	    PERRORRECOVERY
#undef	    HASFAILED
#undef	    FAILEDFLAG
#undef	    RECOVERFROMMISMATCHEDSET
#undef	    RECOVERFROMMISMATCHEDELEMENT
#undef	    BACKTRACKING
#undef      ADAPTOR
#undef	    RULEMEMO
#undef		SEEK
#undef		INDEX
#undef		DBG

#define	    PARSER							ctx->pTreeParser
#define	    RECOGNIZER						PARSER->rec
#define		PSRSTATE						RECOGNIZER->state
#define	    HAVEPARSEDRULE(r)				RECOGNIZER->alreadyParsedRule(RECOGNIZER, r)
#define	    INPUT							PARSER->ctnstream
#define		ISTREAM							INPUT->tnstream->istream
#define	    STRSTREAM						INPUT->tnstream
#define	    HASEXCEPTION()					(PSRSTATE->error == ANTLR3_TRUE)
#define	    EXCEPTION						PSRSTATE->exception
#define	    MATCHT(t, fs)					RECOGNIZER->match(RECOGNIZER, t, fs)
#define	    MATCHANYT()						RECOGNIZER->matchAny(RECOGNIZER)
#define	    FOLLOWSTACK					    PSRSTATE->following
#define	    FOLLOWPUSH(x)					FOLLOWSTACK->push(FOLLOWSTACK, ((void *)(&(x))), NULL)
#define	    FOLLOWPOP()						FOLLOWSTACK->pop(FOLLOWSTACK)
#define	    PRECOVER()						RECOGNIZER->recover(RECOGNIZER)
#define	    PREPORTERROR()					RECOGNIZER->reportError(RECOGNIZER)
#define	    LA(n)							ISTREAM->_LA(ISTREAM, n)
#define	    LT(n)							INPUT->tnstream->_LT(INPUT->tnstream, n)
#define	    CONSTRUCTEX()					RECOGNIZER->exConstruct(RECOGNIZER)
#define	    CONSUME()						ISTREAM->consume(ISTREAM)
#define	    MARK()							ISTREAM->mark(ISTREAM)
#define	    REWIND(m)						ISTREAM->rewind(ISTREAM, m)
#define	    REWINDLAST()					ISTREAM->rewindLast(ISTREAM)
#define	    PERRORRECOVERY					PSRSTATE->errorRecovery
#define	    FAILEDFLAG						PSRSTATE->failed
#define	    HASFAILED()						(FAILEDFLAG == ANTLR3_TRUE)
#define	    BACKTRACKING					PSRSTATE->backtracking
#define	    RECOVERFROMMISMATCHEDSET(s)		RECOGNIZER->recoverFromMismatchedSet(RECOGNIZER, s)
#define	    RECOVERFROMMISMATCHEDELEMENT(e)	RECOGNIZER->recoverFromMismatchedElement(RECOGNIZER, s)
#define     ADAPTOR                         INPUT->adaptor
#define		RULEMEMO						PSRSTATE->ruleMemo
#define		SEEK(n)							ISTREAM->seek(ISTREAM, n)
#define		INDEX()							ISTREAM->index(ISTREAM)
#define		DBG								RECOGNIZER->debugger



#define		TOKTEXT(tok, txt)				tok, (pANTLR3_UINT8)txt

/* The 4 tokens defined below may well clash with your own #defines or token types. If so
 * then for the present you must use different names for your defines as these are hard coded
 * in the code generator. It would be better not to use such names internally, and maybe
 * we can change this in a forthcoming release. I deliberately do not #undef these
 * here as this will at least give you a redefined error somewhere if they clash.
 */
#define	    UP	    ANTLR3_TOKEN_UP
#define	    DOWN    ANTLR3_TOKEN_DOWN
#define	    EOR	    ANTLR3_TOKEN_EOR
#define	    INVALID ANTLR3_TOKEN_INVALID


/* =============================================================================
 * Functions to create and destroy scopes. First come the rule scopes, followed
 * by the global declared scopes.
 */



/* ============================================================================= */

/* =============================================================================
 * Start of recognizer
 */


/** \brief Table of all token names in symbolic order, mainly used for
 *         error reporting.
 */
pANTLR3_UINT8   SMARTPL2SQLTokenNames[37+4]
     = {
        (pANTLR3_UINT8) "<invalid>",       /* String to print to indicate an invalid token */
        (pANTLR3_UINT8) "<EOR>",
        (pANTLR3_UINT8) "<DOWN>",
        (pANTLR3_UINT8) "<UP>",
        (pANTLR3_UINT8) "AFTER",
        (pANTLR3_UINT8) "AGO",
        (pANTLR3_UINT8) "AND",
        (pANTLR3_UINT8) "BEFORE",
        (pANTLR3_UINT8) "DATE",
        (pANTLR3_UINT8) "DATETAG",
        (pANTLR3_UINT8) "DATINTERVAL",
        (pANTLR3_UINT8) "ENUMTAG",
        (pANTLR3_UINT8) "ENUMVAL",
        (pANTLR3_UINT8) "EQUAL",
        (pANTLR3_UINT8) "GREATER",
        (pANTLR3_UINT8) "GREATEREQUAL",
        (pANTLR3_UINT8) "GROUPTAG",
        (pANTLR3_UINT8) "HAVING",
        (pANTLR3_UINT8) "INCLUDES",
        (pANTLR3_UINT8) "INT",
        (pANTLR3_UINT8) "INTBOOL",
        (pANTLR3_UINT8) "INTTAG",
        (pANTLR3_UINT8) "IS",
        (pANTLR3_UINT8) "LESS",
        (pANTLR3_UINT8) "LESSEQUAL",
        (pANTLR3_UINT8) "LIMIT",
        (pANTLR3_UINT8) "LPAR",
        (pANTLR3_UINT8) "NOT",
        (pANTLR3_UINT8) "NeverUsedRule",
        (pANTLR3_UINT8) "OR",
        (pANTLR3_UINT8) "ORDERBY",
        (pANTLR3_UINT8) "RANDOMTAG",
        (pANTLR3_UINT8) "RPAR",
        (pANTLR3_UINT8) "SORTDIR",
        (pANTLR3_UINT8) "STARTSWITH",
        (pANTLR3_UINT8) "STR",
        (pANTLR3_UINT8) "STRTAG",
        (pANTLR3_UINT8) "WHITESPACE",
        (pANTLR3_UINT8) "XXX",
        (pANTLR3_UINT8) "'{'",
        (pANTLR3_UINT8) "'}'"
       };



// Forward declare the locally static matching functions we have generated.
//
static 
 SMARTPL2SQL_playlist_return
	playlist    (pSMARTPL2SQL ctx);
static 
 SMARTPL2SQL_expression_return
	expression    (pSMARTPL2SQL ctx);
static 
 pANTLR3_STRING
	ordertag    (pSMARTPL2SQL ctx);
static 
 pANTLR3_STRING
	dateval    (pSMARTPL2SQL ctx);
static 
 pANTLR3_STRING
	interval    (pSMARTPL2SQL ctx);
static void	SMARTPL2SQLFree(pSMARTPL2SQL ctx);
static void     SMARTPL2SQLReset (pSMARTPL2SQL ctx);

/* For use in tree output where we are accumulating rule labels via label += ruleRef
 * we need a function that knows how to free a return scope when the list is destroyed.
 * We cannot just use ANTLR3_FREE because in debug tracking mode, this is a macro.
 */
static	void ANTLR3_CDECL freeScope(void * scope)
{
    ANTLR3_FREE(scope);
}

/** \brief Name of the grammar file that generated this code
 */
static const char fileName[] = "SMARTPL2SQL.g";

/** \brief Return the name of the grammar file that generated this code.
 */
static const char * getGrammarFileName()
{
	return fileName;
}
/** \brief Create a new SMARTPL2SQL parser and return a context for it.
 *
 * \param[in] instream Pointer to an input stream interface.
 *
 * \return Pointer to new parser context upon success.
 */
ANTLR3_API pSMARTPL2SQL
SMARTPL2SQLNew   (pANTLR3_COMMON_TREE_NODE_STREAM instream)
{
	// See if we can create a new parser with the standard constructor
	//
	return SMARTPL2SQLNewSSD(instream, NULL);
}

/** \brief Create a new SMARTPL2SQL parser and return a context for it.
 *
 * \param[in] instream Pointer to an input stream interface.
 *
 * \return Pointer to new parser context upon success.
 */
ANTLR3_API pSMARTPL2SQL
SMARTPL2SQLNewSSD   (pANTLR3_COMMON_TREE_NODE_STREAM instream, pANTLR3_RECOGNIZER_SHARED_STATE state)
{
    pSMARTPL2SQL ctx;	    /* Context structure we will build and return   */

    ctx	= (pSMARTPL2SQL) ANTLR3_CALLOC(1, sizeof(SMARTPL2SQL));

    if	(ctx == NULL)
    {
		// Failed to allocate memory for parser context
		//
        return  NULL;
    }

    /* -------------------------------------------------------------------
     * Memory for basic structure is allocated, now to fill in
     * the base ANTLR3 structures. We initialize the function pointers
     * for the standard ANTLR3 parser function set, but upon return
     * from here, the programmer may set the pointers to provide custom
     * implementations of each function.
     *
     * We don't use the macros defined in SMARTPL2SQL.h here, in order that you can get a sense
     * of what goes where.
     */

    /* Create a base Tree parser/recognizer, using the supplied tree node stream
     */
    ctx->pTreeParser		= antlr3TreeParserNewStream(ANTLR3_SIZE_HINT, instream, state);

    /* Install the implementation of our SMARTPL2SQL interface
     */
    ctx->playlist	= playlist;
    ctx->expression	= expression;
    ctx->ordertag	= ordertag;
    ctx->dateval	= dateval;
    ctx->interval	= interval;
    ctx->free			= SMARTPL2SQLFree;
    ctx->reset			= SMARTPL2SQLReset;
    ctx->getGrammarFileName	= getGrammarFileName;

    /* Install the scope pushing methods.
     */

    /* Install the token table
     */
    PSRSTATE->tokenNames   = SMARTPL2SQLTokenNames;


    /* Return the newly built parser to the caller
     */
    return  ctx;
}

static void
SMARTPL2SQLReset (pSMARTPL2SQL ctx)
{
    RECOGNIZER->reset(RECOGNIZER);
}

/** Free the parser resources
 */
 static void
 SMARTPL2SQLFree(pSMARTPL2SQL ctx)
 {
    /* Free any scope memory
     */

	// Free this parser
	//
    ctx->pTreeParser->free(ctx->pTreeParser);

    ANTLR3_FREE(ctx);

    /* Everything is released, so we can return
     */
    return;
 }

/** Return token names used by this 
tree parser

 *
 * The returned pointer is used as an index into the token names table (using the token
 * number as the index).
 *
 * \return Pointer to first char * in the table.
 */
static pANTLR3_UINT8    *getTokenNames()
{
        return SMARTPL2SQLTokenNames;
}


    	static void append_date(pANTLR3_STRING result, const char *datval, char beforeorafter, const char *interval)
    	{
    		if (strcmp((char *)datval, "today") == 0)
    		{
    			result->append8(result, "strftime('%s', datetime('now', 'start of day'");
    		}
    		else if (strcmp((char *)datval, "yesterday") == 0)
    		{
    			result->append8(result, "strftime('%s', datetime('now', 'start of day', '-1 day'");
    		}
    		else if (strcmp((char *)datval, "last week") == 0)
    		{
    			result->append8(result, "strftime('%s', datetime('now', 'start of day', 'weekday 0', '-13 days'");
    		}
    		else if (strcmp((char *)datval, "last month") == 0)
    		{
    			result->append8(result, "strftime('%s', datetime('now', 'start of month', '-1 month'");
    		}
    		else if (strcmp((char *)datval, "last year") == 0)
    		{
    			result->append8(result, "strftime('%s', datetime('now', 'start of year', '-1 year'");
    		}
    		else
    		{
    			result->append8(result, "strftime('%s', datetime(\'");
    			result->append8(result, datval);
    			result->append8(result, "\'");
    		}

    		if (beforeorafter)
    		{
    			result->append8(result, ", '");
    			result->addc(result, beforeorafter);
    			result->append8(result, interval);
    			result->addc(result, '\'');
    		}
    		result->append8(result, ", 'utc'))");
    	}


/* Declare the bitsets
 */
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STR_in_playlist66  */
static	ANTLR3_BITWORD FOLLOW_STR_in_playlist66_bits[]	= { ANTLR3_UINT64_LIT(0x0000008000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_STR_in_playlist66	= { FOLLOW_STR_in_playlist66_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_39_in_playlist68  */
static	ANTLR3_BITWORD FOLLOW_39_in_playlist68_bits[]	= { ANTLR3_UINT64_LIT(0x000000106A230A40) };
static  ANTLR3_BITSET_LIST FOLLOW_39_in_playlist68	= { FOLLOW_39_in_playlist68_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_expression_in_playlist74  */
static	ANTLR3_BITWORD FOLLOW_expression_in_playlist74_bits[]	= { ANTLR3_UINT64_LIT(0x0000010000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_expression_in_playlist74	= { FOLLOW_expression_in_playlist74_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_40_in_playlist76  */
static	ANTLR3_BITWORD FOLLOW_40_in_playlist76_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_40_in_playlist76	= { FOLLOW_40_in_playlist76_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LIMIT_in_expression101  */
static	ANTLR3_BITWORD FOLLOW_LIMIT_in_expression101_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_LIMIT_in_expression101	= { FOLLOW_LIMIT_in_expression101_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_expression_in_expression107  */
static	ANTLR3_BITWORD FOLLOW_expression_in_expression107_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000080000) };
static  ANTLR3_BITSET_LIST FOLLOW_expression_in_expression107	= { FOLLOW_expression_in_expression107_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INT_in_expression109  */
static	ANTLR3_BITWORD FOLLOW_INT_in_expression109_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_INT_in_expression109	= { FOLLOW_INT_in_expression109_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ORDERBY_in_expression120  */
static	ANTLR3_BITWORD FOLLOW_ORDERBY_in_expression120_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_ORDERBY_in_expression120	= { FOLLOW_ORDERBY_in_expression120_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_expression_in_expression126  */
static	ANTLR3_BITWORD FOLLOW_expression_in_expression126_bits[]	= { ANTLR3_UINT64_LIT(0x0000001080200A00) };
static  ANTLR3_BITSET_LIST FOLLOW_expression_in_expression126	= { FOLLOW_expression_in_expression126_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ordertag_in_expression132  */
static	ANTLR3_BITWORD FOLLOW_ordertag_in_expression132_bits[]	= { ANTLR3_UINT64_LIT(0x0000000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_ordertag_in_expression132	= { FOLLOW_ordertag_in_expression132_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SORTDIR_in_expression134  */
static	ANTLR3_BITWORD FOLLOW_SORTDIR_in_expression134_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_SORTDIR_in_expression134	= { FOLLOW_SORTDIR_in_expression134_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_HAVING_in_expression145  */
static	ANTLR3_BITWORD FOLLOW_HAVING_in_expression145_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_HAVING_in_expression145	= { FOLLOW_HAVING_in_expression145_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_expression_in_expression151  */
static	ANTLR3_BITWORD FOLLOW_expression_in_expression151_bits[]	= { ANTLR3_UINT64_LIT(0x000000106A230A40) };
static  ANTLR3_BITSET_LIST FOLLOW_expression_in_expression151	= { FOLLOW_expression_in_expression151_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_expression_in_expression157  */
static	ANTLR3_BITWORD FOLLOW_expression_in_expression157_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_expression_in_expression157	= { FOLLOW_expression_in_expression157_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NOT_in_expression168  */
static	ANTLR3_BITWORD FOLLOW_NOT_in_expression168_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_NOT_in_expression168	= { FOLLOW_NOT_in_expression168_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_expression_in_expression174  */
static	ANTLR3_BITWORD FOLLOW_expression_in_expression174_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_expression_in_expression174	= { FOLLOW_expression_in_expression174_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_AND_in_expression185  */
static	ANTLR3_BITWORD FOLLOW_AND_in_expression185_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_AND_in_expression185	= { FOLLOW_AND_in_expression185_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_expression_in_expression191  */
static	ANTLR3_BITWORD FOLLOW_expression_in_expression191_bits[]	= { ANTLR3_UINT64_LIT(0x000000106A230A40) };
static  ANTLR3_BITSET_LIST FOLLOW_expression_in_expression191	= { FOLLOW_expression_in_expression191_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_expression_in_expression197  */
static	ANTLR3_BITWORD FOLLOW_expression_in_expression197_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_expression_in_expression197	= { FOLLOW_expression_in_expression197_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_OR_in_expression208  */
static	ANTLR3_BITWORD FOLLOW_OR_in_expression208_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_OR_in_expression208	= { FOLLOW_OR_in_expression208_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_expression_in_expression214  */
static	ANTLR3_BITWORD FOLLOW_expression_in_expression214_bits[]	= { ANTLR3_UINT64_LIT(0x000000106A230A40) };
static  ANTLR3_BITSET_LIST FOLLOW_expression_in_expression214	= { FOLLOW_expression_in_expression214_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_expression_in_expression220  */
static	ANTLR3_BITWORD FOLLOW_expression_in_expression220_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_expression_in_expression220	= { FOLLOW_expression_in_expression220_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRTAG_in_expression230  */
static	ANTLR3_BITWORD FOLLOW_STRTAG_in_expression230_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_STRTAG_in_expression230	= { FOLLOW_STRTAG_in_expression230_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INCLUDES_in_expression232  */
static	ANTLR3_BITWORD FOLLOW_INCLUDES_in_expression232_bits[]	= { ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INCLUDES_in_expression232	= { FOLLOW_INCLUDES_in_expression232_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STR_in_expression234  */
static	ANTLR3_BITWORD FOLLOW_STR_in_expression234_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_STR_in_expression234	= { FOLLOW_STR_in_expression234_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRTAG_in_expression243  */
static	ANTLR3_BITWORD FOLLOW_STRTAG_in_expression243_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000400000) };
static  ANTLR3_BITSET_LIST FOLLOW_STRTAG_in_expression243	= { FOLLOW_STRTAG_in_expression243_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IS_in_expression245  */
static	ANTLR3_BITWORD FOLLOW_IS_in_expression245_bits[]	= { ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_IS_in_expression245	= { FOLLOW_IS_in_expression245_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STR_in_expression247  */
static	ANTLR3_BITWORD FOLLOW_STR_in_expression247_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_STR_in_expression247	= { FOLLOW_STR_in_expression247_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRTAG_in_expression256  */
static	ANTLR3_BITWORD FOLLOW_STRTAG_in_expression256_bits[]	= { ANTLR3_UINT64_LIT(0x0000000400000000) };
static  ANTLR3_BITSET_LIST FOLLOW_STRTAG_in_expression256	= { FOLLOW_STRTAG_in_expression256_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STARTSWITH_in_expression258  */
static	ANTLR3_BITWORD FOLLOW_STARTSWITH_in_expression258_bits[]	= { ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_STARTSWITH_in_expression258	= { FOLLOW_STARTSWITH_in_expression258_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STR_in_expression260  */
static	ANTLR3_BITWORD FOLLOW_STR_in_expression260_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_STR_in_expression260	= { FOLLOW_STR_in_expression260_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTTAG_in_expression269  */
static	ANTLR3_BITWORD FOLLOW_INTTAG_in_expression269_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTTAG_in_expression269	= { FOLLOW_INTTAG_in_expression269_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTBOOL_in_expression271  */
static	ANTLR3_BITWORD FOLLOW_INTBOOL_in_expression271_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000080000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTBOOL_in_expression271	= { FOLLOW_INTBOOL_in_expression271_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INT_in_expression273  */
static	ANTLR3_BITWORD FOLLOW_INT_in_expression273_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INT_in_expression273	= { FOLLOW_INT_in_expression273_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DATETAG_in_expression282  */
static	ANTLR3_BITWORD FOLLOW_DATETAG_in_expression282_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_DATETAG_in_expression282	= { FOLLOW_DATETAG_in_expression282_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_AFTER_in_expression284  */
static	ANTLR3_BITWORD FOLLOW_AFTER_in_expression284_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000080100) };
static  ANTLR3_BITSET_LIST FOLLOW_AFTER_in_expression284	= { FOLLOW_AFTER_in_expression284_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_dateval_in_expression286  */
static	ANTLR3_BITWORD FOLLOW_dateval_in_expression286_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_dateval_in_expression286	= { FOLLOW_dateval_in_expression286_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DATETAG_in_expression295  */
static	ANTLR3_BITWORD FOLLOW_DATETAG_in_expression295_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000080) };
static  ANTLR3_BITSET_LIST FOLLOW_DATETAG_in_expression295	= { FOLLOW_DATETAG_in_expression295_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BEFORE_in_expression297  */
static	ANTLR3_BITWORD FOLLOW_BEFORE_in_expression297_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000080100) };
static  ANTLR3_BITSET_LIST FOLLOW_BEFORE_in_expression297	= { FOLLOW_BEFORE_in_expression297_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_dateval_in_expression299  */
static	ANTLR3_BITWORD FOLLOW_dateval_in_expression299_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_dateval_in_expression299	= { FOLLOW_dateval_in_expression299_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ENUMTAG_in_expression308  */
static	ANTLR3_BITWORD FOLLOW_ENUMTAG_in_expression308_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000400000) };
static  ANTLR3_BITSET_LIST FOLLOW_ENUMTAG_in_expression308	= { FOLLOW_ENUMTAG_in_expression308_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IS_in_expression310  */
static	ANTLR3_BITWORD FOLLOW_IS_in_expression310_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000001000) };
static  ANTLR3_BITSET_LIST FOLLOW_IS_in_expression310	= { FOLLOW_IS_in_expression310_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ENUMVAL_in_expression312  */
static	ANTLR3_BITWORD FOLLOW_ENUMVAL_in_expression312_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ENUMVAL_in_expression312	= { FOLLOW_ENUMVAL_in_expression312_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GROUPTAG_in_expression321  */
static	ANTLR3_BITWORD FOLLOW_GROUPTAG_in_expression321_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_GROUPTAG_in_expression321	= { FOLLOW_GROUPTAG_in_expression321_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTBOOL_in_expression323  */
static	ANTLR3_BITWORD FOLLOW_INTBOOL_in_expression323_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000080000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTBOOL_in_expression323	= { FOLLOW_INTBOOL_in_expression323_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INT_in_expression325  */
static	ANTLR3_BITWORD FOLLOW_INT_in_expression325_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INT_in_expression325	= { FOLLOW_INT_in_expression325_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRTAG_in_ordertag349  */
static	ANTLR3_BITWORD FOLLOW_STRTAG_in_ordertag349_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_STRTAG_in_ordertag349	= { FOLLOW_STRTAG_in_ordertag349_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTTAG_in_ordertag358  */
static	ANTLR3_BITWORD FOLLOW_INTTAG_in_ordertag358_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTTAG_in_ordertag358	= { FOLLOW_INTTAG_in_ordertag358_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DATETAG_in_ordertag367  */
static	ANTLR3_BITWORD FOLLOW_DATETAG_in_ordertag367_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DATETAG_in_ordertag367	= { FOLLOW_DATETAG_in_ordertag367_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ENUMTAG_in_ordertag376  */
static	ANTLR3_BITWORD FOLLOW_ENUMTAG_in_ordertag376_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ENUMTAG_in_ordertag376	= { FOLLOW_ENUMTAG_in_ordertag376_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RANDOMTAG_in_ordertag385  */
static	ANTLR3_BITWORD FOLLOW_RANDOMTAG_in_ordertag385_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RANDOMTAG_in_ordertag385	= { FOLLOW_RANDOMTAG_in_ordertag385_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DATE_in_dateval410  */
static	ANTLR3_BITWORD FOLLOW_DATE_in_dateval410_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DATE_in_dateval410	= { FOLLOW_DATE_in_dateval410_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_interval_in_dateval419  */
static	ANTLR3_BITWORD FOLLOW_interval_in_dateval419_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000080) };
static  ANTLR3_BITSET_LIST FOLLOW_interval_in_dateval419	= { FOLLOW_interval_in_dateval419_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BEFORE_in_dateval421  */
static	ANTLR3_BITWORD FOLLOW_BEFORE_in_dateval421_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000100) };
static  ANTLR3_BITSET_LIST FOLLOW_BEFORE_in_dateval421	= { FOLLOW_BEFORE_in_dateval421_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DATE_in_dateval423  */
static	ANTLR3_BITWORD FOLLOW_DATE_in_dateval423_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DATE_in_dateval423	= { FOLLOW_DATE_in_dateval423_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_interval_in_dateval432  */
static	ANTLR3_BITWORD FOLLOW_interval_in_dateval432_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_interval_in_dateval432	= { FOLLOW_interval_in_dateval432_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_AFTER_in_dateval434  */
static	ANTLR3_BITWORD FOLLOW_AFTER_in_dateval434_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000100) };
static  ANTLR3_BITSET_LIST FOLLOW_AFTER_in_dateval434	= { FOLLOW_AFTER_in_dateval434_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DATE_in_dateval436  */
static	ANTLR3_BITWORD FOLLOW_DATE_in_dateval436_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DATE_in_dateval436	= { FOLLOW_DATE_in_dateval436_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_interval_in_dateval445  */
static	ANTLR3_BITWORD FOLLOW_interval_in_dateval445_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000020) };
static  ANTLR3_BITSET_LIST FOLLOW_interval_in_dateval445	= { FOLLOW_interval_in_dateval445_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_AGO_in_dateval447  */
static	ANTLR3_BITWORD FOLLOW_AGO_in_dateval447_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_AGO_in_dateval447	= { FOLLOW_AGO_in_dateval447_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INT_in_interval471  */
static	ANTLR3_BITWORD FOLLOW_INT_in_interval471_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000400) };
static  ANTLR3_BITSET_LIST FOLLOW_INT_in_interval471	= { FOLLOW_INT_in_interval471_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DATINTERVAL_in_interval473  */
static	ANTLR3_BITWORD FOLLOW_DATINTERVAL_in_interval473_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DATINTERVAL_in_interval473	= { FOLLOW_DATINTERVAL_in_interval473_bits, 1	};


/* ==============================================
 * Parsing rules
 */
/**
 * $ANTLR start playlist
 * SMARTPL2SQL.g:81:1: playlist returns [ pANTLR3_STRING title, pANTLR3_STRING query, pANTLR3_STRING orderby, pANTLR3_STRING having, int limit ] : STR '{' e= expression '}' ;
 */
static SMARTPL2SQL_playlist_return
playlist(pSMARTPL2SQL ctx)
{
    SMARTPL2SQL_playlist_return retval;


    pANTLR3_BASE_TREE    STR1;
    SMARTPL2SQL_expression_return e;
    #undef	RETURN_TYPE_e
    #define	RETURN_TYPE_e SMARTPL2SQL_expression_return

    /* Initialize rule variables
     */

     retval.title= NULL;
     retval.query= NULL;
     retval.orderby= NULL;
     retval.having= NULL;
     retval.limit= -1;
     
    STR1       = NULL;
    retval.start = LT(1); retval.stop = retval.start;


    {
        // SMARTPL2SQL.g:83:2: ( STR '{' e= expression '}' )
        // SMARTPL2SQL.g:83:4: STR '{' e= expression '}'
        {
            STR1 = (pANTLR3_BASE_TREE) MATCHT(STR, &FOLLOW_STR_in_playlist66);
            if  (HASEXCEPTION())
            {
                goto ruleplaylistEx;
            }


             MATCHT(39, &FOLLOW_39_in_playlist68);
            if  (HASEXCEPTION())
            {
                goto ruleplaylistEx;
            }


            FOLLOWPUSH(FOLLOW_expression_in_playlist74);
            e=expression(ctx);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleplaylistEx;
            }


             MATCHT(40, &FOLLOW_40_in_playlist76);
            if  (HASEXCEPTION())
            {
                goto ruleplaylistEx;
            }


            {

                			pANTLR3_UINT8 val;
                			val = (STR1->getText(STR1))->toUTF8((STR1->getText(STR1)))->chars;
                			val++;
                			val[strlen((const char *)val) - 1] = '\0';
                			
                			
                retval.title= (STR1->getText(STR1))->factory->newRaw((STR1->getText(STR1))->factory);

                			retval.title
                ->append8(retval.title
                , (const char *)val);
                			
                			retval.query= 
                e.result
                ->factory->newRaw(e.result
                ->factory);

                			retval.query
                ->append8(retval.query
                , "(");
                			retval.query
                ->appendS(retval.query
                , e.result
                );
                			retval.query
                ->append8(retval.query
                , ")");
                			
                			retval.limit= 
                e.limit
                ;

                			
                			retval.orderby= 
                e.result
                ->factory->newRaw(e.result
                ->factory);

                			retval.orderby
                ->appendS(retval.orderby
                , e.orderby
                );
                			
                			retval.having= 
                e.result
                ->factory->newRaw(e.result
                ->factory);

                			retval.having
                ->appendS(retval.having
                , e.having
                );
                		
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleplaylistEx; /* Prevent compiler warnings */
    ruleplaylistEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return retval;
}
/* $ANTLR end playlist */

/**
 * $ANTLR start expression
 * SMARTPL2SQL.g:108:1: expression returns [ pANTLR3_STRING result, pANTLR3_STRING orderby, pANTLR3_STRING having, int limit ] : ( ^( LIMIT a= expression INT ) | ^( ORDERBY a= expression o= ordertag SORTDIR ) | ^( HAVING a= expression b= expression ) | ^( NOT a= expression ) | ^( AND a= expression b= expression ) | ^( OR a= expression b= expression ) | STRTAG INCLUDES STR | STRTAG IS STR | STRTAG STARTSWITH STR | INTTAG INTBOOL INT | DATETAG AFTER dateval | DATETAG BEFORE dateval | ENUMTAG IS ENUMVAL | GROUPTAG INTBOOL INT );
 */
static SMARTPL2SQL_expression_return
expression(pSMARTPL2SQL ctx)
{
    SMARTPL2SQL_expression_return retval;


    pANTLR3_BASE_TREE    INT2;
    pANTLR3_BASE_TREE    SORTDIR3;
    pANTLR3_BASE_TREE    STR4;
    pANTLR3_BASE_TREE    STRTAG5;
    pANTLR3_BASE_TREE    STR6;
    pANTLR3_BASE_TREE    STRTAG7;
    pANTLR3_BASE_TREE    STR8;
    pANTLR3_BASE_TREE    STRTAG9;
    pANTLR3_BASE_TREE    INTTAG10;
    pANTLR3_BASE_TREE    INTBOOL11;
    pANTLR3_BASE_TREE    INT12;
    pANTLR3_BASE_TREE    DATETAG13;
    pANTLR3_BASE_TREE    DATETAG15;
    pANTLR3_BASE_TREE    ENUMTAG17;
    pANTLR3_BASE_TREE    ENUMVAL18;
    pANTLR3_BASE_TREE    GROUPTAG19;
    pANTLR3_BASE_TREE    INTBOOL20;
    pANTLR3_BASE_TREE    INT21;
    SMARTPL2SQL_expression_return a;
    #undef	RETURN_TYPE_a
    #define	RETURN_TYPE_a SMARTPL2SQL_expression_return

    pANTLR3_STRING o;
    #undef	RETURN_TYPE_o
    #define	RETURN_TYPE_o pANTLR3_STRING

    SMARTPL2SQL_expression_return b;
    #undef	RETURN_TYPE_b
    #define	RETURN_TYPE_b SMARTPL2SQL_expression_return

    pANTLR3_STRING dateval14;
    #undef	RETURN_TYPE_dateval14
    #define	RETURN_TYPE_dateval14 pANTLR3_STRING

    pANTLR3_STRING dateval16;
    #undef	RETURN_TYPE_dateval16
    #define	RETURN_TYPE_dateval16 pANTLR3_STRING

    /* Initialize rule variables
     */

     retval.result= NULL;
     retval.orderby= NULL;
     retval.having= NULL;
     retval.limit= -1;
     
    INT2       = NULL;
    SORTDIR3       = NULL;
    STR4       = NULL;
    STRTAG5       = NULL;
    STR6       = NULL;
    STRTAG7       = NULL;
    STR8       = NULL;
    STRTAG9       = NULL;
    INTTAG10       = NULL;
    INTBOOL11       = NULL;
    INT12       = NULL;
    DATETAG13       = NULL;
    DATETAG15       = NULL;
    ENUMTAG17       = NULL;
    ENUMVAL18       = NULL;
    GROUPTAG19       = NULL;
    INTBOOL20       = NULL;
    INT21       = NULL;
    retval.start = LT(1); retval.stop = retval.start;


    {
        {
            //  SMARTPL2SQL.g:110:2: ( ^( LIMIT a= expression INT ) | ^( ORDERBY a= expression o= ordertag SORTDIR ) | ^( HAVING a= expression b= expression ) | ^( NOT a= expression ) | ^( AND a= expression b= expression ) | ^( OR a= expression b= expression ) | STRTAG INCLUDES STR | STRTAG IS STR | STRTAG STARTSWITH STR | INTTAG INTBOOL INT | DATETAG AFTER dateval | DATETAG BEFORE dateval | ENUMTAG IS ENUMVAL | GROUPTAG INTBOOL INT )

            ANTLR3_UINT32 alt1;

            alt1=14;

            switch ( LA(1) )
            {
            case LIMIT:
            	{
            		alt1=1;
            	}
                break;
            case ORDERBY:
            	{
            		alt1=2;
            	}
                break;
            case HAVING:
            	{
            		alt1=3;
            	}
                break;
            case NOT:
            	{
            		alt1=4;
            	}
                break;
            case AND:
            	{
            		alt1=5;
            	}
                break;
            case OR:
            	{
            		alt1=6;
            	}
                break;
            case STRTAG:
            	{
            		switch ( LA(2) )
            		{
            		case INCLUDES:
            			{
            				alt1=7;
            			}
            		    break;
            		case IS:
            			{
            				alt1=8;
            			}
            		    break;
            		case STARTSWITH:
            			{
            				alt1=9;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 1;
            		    EXCEPTION->state        = 7;


            		    goto ruleexpressionEx;

            		}

            	}
                break;
            case INTTAG:
            	{
            		alt1=10;
            	}
                break;
            case DATETAG:
            	{
            		switch ( LA(2) )
            		{
            		case AFTER:
            			{
            				alt1=11;
            			}
            		    break;
            		case BEFORE:
            			{
            				alt1=12;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 1;
            		    EXCEPTION->state        = 9;


            		    goto ruleexpressionEx;

            		}

            	}
                break;
            case ENUMTAG:
            	{
            		alt1=13;
            	}
                break;
            case GROUPTAG:
            	{
            		alt1=14;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 1;
                EXCEPTION->state        = 0;


                goto ruleexpressionEx;

            }

            switch (alt1)
            {
        	case 1:
        	    // SMARTPL2SQL.g:110:4: ^( LIMIT a= expression INT )
        	    {
        	         MATCHT(LIMIT, &FOLLOW_LIMIT_in_expression101);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        MATCHT(ANTLR3_TOKEN_DOWN, NULL);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }

        	        FOLLOWPUSH(FOLLOW_expression_in_expression107);
        	        a=expression(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        INT2 = (pANTLR3_BASE_TREE) MATCHT(INT, &FOLLOW_INT_in_expression109);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        MATCHT(ANTLR3_TOKEN_UP, NULL);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }



        	        {

        	            			retval.result= 
        	            a.result
        	            ->factory->newRaw(a.result
        	            ->factory);

        	            			retval.result
        	            ->appendS(retval.result
        	            , a.result
        	            );
        	            			
        	            			retval.having= 
        	            a.result
        	            ->factory->newRaw(a.result
        	            ->factory);

        	            			retval.having
        	            ->appendS(retval.having
        	            , a.having
        	            );
        	            			
        	            			retval.orderby= 
        	            a.result
        	            ->factory->newRaw(a.result
        	            ->factory);

        	            			retval.orderby
        	            ->appendS(retval.orderby
        	            , a.orderby
        	            );
        	            			
        	            			retval.limit= atoi((const char *)(INT2->getText(INT2))->chars);

        	            		
        	        }


        	    }
        	    break;
        	case 2:
        	    // SMARTPL2SQL.g:123:4: ^( ORDERBY a= expression o= ordertag SORTDIR )
        	    {
        	         MATCHT(ORDERBY, &FOLLOW_ORDERBY_in_expression120);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        MATCHT(ANTLR3_TOKEN_DOWN, NULL);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }

        	        FOLLOWPUSH(FOLLOW_expression_in_expression126);
        	        a=expression(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_ordertag_in_expression132);
        	        o=ordertag(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        SORTDIR3 = (pANTLR3_BASE_TREE) MATCHT(SORTDIR, &FOLLOW_SORTDIR_in_expression134);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        MATCHT(ANTLR3_TOKEN_UP, NULL);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }



        	        {

        	            			retval.result= 
        	            a.result
        	            ->factory->newRaw(a.result
        	            ->factory);

        	            			retval.result
        	            ->appendS(retval.result
        	            , a.result
        	            );
        	            			
        	            			retval.having= 
        	            a.result
        	            ->factory->newRaw(a.result
        	            ->factory);

        	            			retval.having
        	            ->appendS(retval.having
        	            , a.having
        	            );
        	            			
        	            			retval.orderby= 
        	            o
        	            ->factory->newRaw(o
        	            ->factory);

        	            			retval.orderby
        	            ->appendS(retval.orderby
        	            , o
        	            );
        	            			retval.orderby
        	            ->append8(retval.orderby
        	            , " ");
        	            			retval.orderby
        	            ->appendS(retval.orderby
        	            , (SORTDIR3->getText(SORTDIR3))->toUTF8((SORTDIR3->getText(SORTDIR3))));
        	            		
        	        }


        	    }
        	    break;
        	case 3:
        	    // SMARTPL2SQL.g:136:4: ^( HAVING a= expression b= expression )
        	    {
        	         MATCHT(HAVING, &FOLLOW_HAVING_in_expression145);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        MATCHT(ANTLR3_TOKEN_DOWN, NULL);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }

        	        FOLLOWPUSH(FOLLOW_expression_in_expression151);
        	        a=expression(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_expression_in_expression157);
        	        b=expression(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        MATCHT(ANTLR3_TOKEN_UP, NULL);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }



        	        {

        	            			retval.result= 
        	            a.result
        	            ->factory->newRaw(a.result
        	            ->factory);

        	            			retval.result
        	            ->appendS(retval.result
        	            , a.result
        	            );
        	            			
        	            			retval.having= 
        	            b.result
        	            ->factory->newRaw(b.result
        	            ->factory);

        	            			retval.having
        	            ->appendS(retval.having
        	            , b.result
        	            );
        	            		
        	        }


        	    }
        	    break;
        	case 4:
        	    // SMARTPL2SQL.g:144:4: ^( NOT a= expression )
        	    {
        	         MATCHT(NOT, &FOLLOW_NOT_in_expression168);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        MATCHT(ANTLR3_TOKEN_DOWN, NULL);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }

        	        FOLLOWPUSH(FOLLOW_expression_in_expression174);
        	        a=expression(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        MATCHT(ANTLR3_TOKEN_UP, NULL);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }



        	        {

        	            			retval.result= 
        	            a.result
        	            ->factory->newRaw(a.result
        	            ->factory);

        	            			retval.result
        	            ->append8(retval.result
        	            , "NOT(");
        	            			retval.result
        	            ->appendS(retval.result
        	            , a.result
        	            );
        	            			retval.result
        	            ->append8(retval.result
        	            , ")");
        	            		
        	        }


        	    }
        	    break;
        	case 5:
        	    // SMARTPL2SQL.g:151:4: ^( AND a= expression b= expression )
        	    {
        	         MATCHT(AND, &FOLLOW_AND_in_expression185);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        MATCHT(ANTLR3_TOKEN_DOWN, NULL);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }

        	        FOLLOWPUSH(FOLLOW_expression_in_expression191);
        	        a=expression(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_expression_in_expression197);
        	        b=expression(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        MATCHT(ANTLR3_TOKEN_UP, NULL);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }



        	        {

        	            			retval.result= 
        	            a.result
        	            ->factory->newRaw(a.result
        	            ->factory);

        	            			retval.result
        	            ->append8(retval.result
        	            , "(");
        	            			retval.result
        	            ->appendS(retval.result
        	            , a.result
        	            );
        	            			retval.result
        	            ->append8(retval.result
        	            , " AND ");
        	            			retval.result
        	            ->appendS(retval.result
        	            , b.result
        	            );
        	            			retval.result
        	            ->append8(retval.result
        	            , ")");
        	            		
        	        }


        	    }
        	    break;
        	case 6:
        	    // SMARTPL2SQL.g:160:4: ^( OR a= expression b= expression )
        	    {
        	         MATCHT(OR, &FOLLOW_OR_in_expression208);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        MATCHT(ANTLR3_TOKEN_DOWN, NULL);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }

        	        FOLLOWPUSH(FOLLOW_expression_in_expression214);
        	        a=expression(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_expression_in_expression220);
        	        b=expression(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        MATCHT(ANTLR3_TOKEN_UP, NULL);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }



        	        {

        	            			retval.result= 
        	            a.result
        	            ->factory->newRaw(a.result
        	            ->factory);

        	            			retval.result
        	            ->append8(retval.result
        	            , "(");
        	            			retval.result
        	            ->appendS(retval.result
        	            , a.result
        	            );
        	            			retval.result
        	            ->append8(retval.result
        	            , " OR ");
        	            			retval.result
        	            ->appendS(retval.result
        	            , b.result
        	            );
        	            			retval.result
        	            ->append8(retval.result
        	            , ")");
        	            		
        	        }


        	    }
        	    break;
        	case 7:
        	    // SMARTPL2SQL.g:169:4: STRTAG INCLUDES STR
        	    {
        	        STRTAG5 = (pANTLR3_BASE_TREE) MATCHT(STRTAG, &FOLLOW_STRTAG_in_expression230);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	         MATCHT(INCLUDES, &FOLLOW_INCLUDES_in_expression232);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        STR4 = (pANTLR3_BASE_TREE) MATCHT(STR, &FOLLOW_STR_in_expression234);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        {

        	            			pANTLR3_UINT8 val;
        	            			char *tmp;
        	            			
        	            			val = (STR4->getText(STR4))->toUTF8((STR4->getText(STR4)))->chars;
        	            			val++;
        	            			val[strlen((const char *)val) - 1] = '\0';
        	            			
        	            			tmp = sqlite3_mprintf("%q", (const char *)val);
        	            			
        	            			
        	            retval.result= (STR4->getText(STR4))->factory->newRaw((STR4->getText(STR4))->factory);

        	            			retval.result
        	            ->append8(retval.result
        	            , "f.");
        	            			retval.result
        	            ->appendS(retval.result
        	            , (STRTAG5->getText(STRTAG5))->toUTF8((STRTAG5->getText(STRTAG5))));
        	            			
        	            retval.result
        	            ->append8(retval.result
        	            , " LIKE '%");
        	            			retval.result
        	            ->append8(retval.result
        	            , tmp);
        	            			retval.result
        	            ->append8(retval.result
        	            , "%'");
        	            			
        	            			sqlite3_free(tmp);
        	            		
        	        }


        	    }
        	    break;
        	case 8:
        	    // SMARTPL2SQL.g:189:4: STRTAG IS STR
        	    {
        	        STRTAG7 = (pANTLR3_BASE_TREE) MATCHT(STRTAG, &FOLLOW_STRTAG_in_expression243);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	         MATCHT(IS, &FOLLOW_IS_in_expression245);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        STR6 = (pANTLR3_BASE_TREE) MATCHT(STR, &FOLLOW_STR_in_expression247);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        {

        	            			pANTLR3_UINT8 val;
        	            			char *tmp;
        	            			
        	            			val = (STR6->getText(STR6))->toUTF8((STR6->getText(STR6)))->chars;
        	            			val++;
        	            			val[strlen((const char *)val) - 1] = '\0';
        	            			
        	            			tmp = sqlite3_mprintf("%q", (const char *)val);
        	            			
        	            			
        	            retval.result= (STR6->getText(STR6))->factory->newRaw((STR6->getText(STR6))->factory);

        	            			retval.result
        	            ->append8(retval.result
        	            , "f.");
        	            			retval.result
        	            ->appendS(retval.result
        	            , (STRTAG7->getText(STRTAG7))->toUTF8((STRTAG7->getText(STRTAG7))));
        	            			
        	            retval.result
        	            ->append8(retval.result
        	            , " LIKE '");
        	            			retval.result
        	            ->append8(retval.result
        	            , tmp);
        	            			retval.result
        	            ->append8(retval.result
        	            , "'");
        	            			
        	            			sqlite3_free(tmp);
        	            		
        	        }


        	    }
        	    break;
        	case 9:
        	    // SMARTPL2SQL.g:209:4: STRTAG STARTSWITH STR
        	    {
        	        STRTAG9 = (pANTLR3_BASE_TREE) MATCHT(STRTAG, &FOLLOW_STRTAG_in_expression256);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	         MATCHT(STARTSWITH, &FOLLOW_STARTSWITH_in_expression258);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        STR8 = (pANTLR3_BASE_TREE) MATCHT(STR, &FOLLOW_STR_in_expression260);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        {

        	            			pANTLR3_UINT8 val;
        	            			char *tmp;
        	            			
        	            			val = (STR8->getText(STR8))->toUTF8((STR8->getText(STR8)))->chars;
        	            			val++;
        	            			val[strlen((const char *)val) - 1] = '\0';
        	            			
        	            			tmp = sqlite3_mprintf("%q", (const char *)val);
        	            			
        	            			
        	            retval.result= (STR8->getText(STR8))->factory->newRaw((STR8->getText(STR8))->factory);

        	            			retval.result
        	            ->append8(retval.result
        	            , "f.");
        	            			retval.result
        	            ->appendS(retval.result
        	            , (STRTAG9->getText(STRTAG9))->toUTF8((STRTAG9->getText(STRTAG9))));
        	            			
        	            retval.result
        	            ->append8(retval.result
        	            , " LIKE '");
        	            			retval.result
        	            ->append8(retval.result
        	            , tmp);
        	            			retval.result
        	            ->append8(retval.result
        	            , "%'");
        	            			
        	            			sqlite3_free(tmp);
        	            		
        	        }


        	    }
        	    break;
        	case 10:
        	    // SMARTPL2SQL.g:229:4: INTTAG INTBOOL INT
        	    {
        	        INTTAG10 = (pANTLR3_BASE_TREE) MATCHT(INTTAG, &FOLLOW_INTTAG_in_expression269);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        INTBOOL11 = (pANTLR3_BASE_TREE) MATCHT(INTBOOL, &FOLLOW_INTBOOL_in_expression271);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        INT12 = (pANTLR3_BASE_TREE) MATCHT(INT, &FOLLOW_INT_in_expression273);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        {

        	            			retval.result= (INTTAG10->getText(INTTAG10))->factory->newRaw((INTTAG10->getText(INTTAG10))->factory);

        	            			retval.result
        	            ->append8(retval.result
        	            , "f.");
        	            			retval.result
        	            ->appendS(retval.result
        	            , (INTTAG10->getText(INTTAG10))->toUTF8((INTTAG10->getText(INTTAG10))));
        	            			
        	            retval.result
        	            ->append8(retval.result
        	            , " ");
        	            			retval.result
        	            ->appendS(retval.result
        	            , (INTBOOL11->getText(INTBOOL11))->toUTF8((INTBOOL11->getText(INTBOOL11))));
        	            			
        	            retval.result
        	            ->append8(retval.result
        	            , " ");
        	            			retval.result
        	            ->appendS(retval.result
        	            , (INT12->getText(INT12))->toUTF8((INT12->getText(INT12))));
        	            		
        	        }


        	    }
        	    break;
        	case 11:
        	    // SMARTPL2SQL.g:239:4: DATETAG AFTER dateval
        	    {
        	        DATETAG13 = (pANTLR3_BASE_TREE) MATCHT(DATETAG, &FOLLOW_DATETAG_in_expression282);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	         MATCHT(AFTER, &FOLLOW_AFTER_in_expression284);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_dateval_in_expression286);
        	        dateval14=dateval(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        {

        	            			retval.result= (DATETAG13->getText(DATETAG13))->factory->newRaw((DATETAG13->getText(DATETAG13))->factory);

        	            			retval.result
        	            ->append8(retval.result
        	            , "f.");
        	            			retval.result
        	            ->appendS(retval.result
        	            , (DATETAG13->getText(DATETAG13))->toUTF8((DATETAG13->getText(DATETAG13))));
        	            			
        	            retval.result
        	            ->append8(retval.result
        	            , " > ");
        	            			retval.result
        	            ->append8(retval.result
        	            , (const char*)dateval14
        	            ->chars);
        	            		
        	        }


        	    }
        	    break;
        	case 12:
        	    // SMARTPL2SQL.g:247:4: DATETAG BEFORE dateval
        	    {
        	        DATETAG15 = (pANTLR3_BASE_TREE) MATCHT(DATETAG, &FOLLOW_DATETAG_in_expression295);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	         MATCHT(BEFORE, &FOLLOW_BEFORE_in_expression297);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_dateval_in_expression299);
        	        dateval16=dateval(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        {

        	            			retval.result= (DATETAG15->getText(DATETAG15))->factory->newRaw((DATETAG15->getText(DATETAG15))->factory);

        	            			retval.result
        	            ->append8(retval.result
        	            , "f.");
        	            			retval.result
        	            ->appendS(retval.result
        	            , (DATETAG15->getText(DATETAG15))->toUTF8((DATETAG15->getText(DATETAG15))));
        	            			
        	            retval.result
        	            ->append8(retval.result
        	            , " < ");
        	            			retval.result
        	            ->append8(retval.result
        	            , (const char*)dateval16
        	            ->chars);
        	            		
        	        }


        	    }
        	    break;
        	case 13:
        	    // SMARTPL2SQL.g:255:4: ENUMTAG IS ENUMVAL
        	    {
        	        ENUMTAG17 = (pANTLR3_BASE_TREE) MATCHT(ENUMTAG, &FOLLOW_ENUMTAG_in_expression308);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	         MATCHT(IS, &FOLLOW_IS_in_expression310);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        ENUMVAL18 = (pANTLR3_BASE_TREE) MATCHT(ENUMVAL, &FOLLOW_ENUMVAL_in_expression312);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        {

        	            			pANTLR3_UINT8 tag;
        	            			pANTLR3_UINT8 val;
        	            			char str[20];
        	            			
        	            			sprintf(str, "1=1");
        	            			
        	            			tag = (ENUMTAG17->getText(ENUMTAG17))->chars;
        	            			val = (ENUMVAL18->getText(ENUMVAL18))->chars;
        	            			if (strcmp((char *)tag, "media_kind") == 0)
        	            			{
        	            				if (strcmp((char *)val, "music") == 0)
        	            				{
        	            					sprintf(str, "f.media_kind = %d", MEDIA_KIND_MUSIC);
        	            				}
        	            				else if (strcmp((char *)val, "movie") == 0)
        	            				{
        	            					sprintf(str, "f.media_kind = %d", MEDIA_KIND_MOVIE);
        	            				}
        	            				else if (strcmp((char *)val, "podcast") == 0)
        	            				{
        	            					sprintf(str, "f.media_kind = %d", MEDIA_KIND_PODCAST);
        	            				}
        	            				else if (strcmp((char *)val, "audiobook") == 0)
        	            				{
        	            					sprintf(str, "f.media_kind = %d", MEDIA_KIND_AUDIOBOOK);
        	            				}
        	            				else if (strcmp((char *)val, "tvshow") == 0)
        	            				{
        	            					sprintf(str, "f.media_kind = %d", MEDIA_KIND_TVSHOW);
        	            				}
        	            			}
        	            			else if (strcmp((char *)tag, "data_kind") == 0)
        	            			{
        	            				if (strcmp((char *)val, "file") == 0)
        	            				{
        	            					sprintf(str, "f.data_kind = %d", DATA_KIND_FILE);
        	            				}
        	            				else if (strcmp((char *)val, "url") == 0)
        	            				{
        	            					sprintf(str, "f.data_kind = %d", DATA_KIND_HTTP);
        	            				}
        	            				else if (strcmp((char *)val, "spotify") == 0)
        	            				{
        	            					sprintf(str, "f.data_kind = %d", DATA_KIND_SPOTIFY);
        	            				}
        	            				else if (strcmp((char *)val, "pipe") == 0)
        	            				{
        	            					sprintf(str, "f.data_kind = %d", DATA_KIND_PIPE);
        	            				}
        	            			}
        	            			
        	            			
        	            retval.result= (ENUMTAG17->getText(ENUMTAG17))->factory->newRaw((ENUMTAG17->getText(ENUMTAG17))->factory);

        	            			retval.result
        	            ->append8(retval.result
        	            , str);
        	            		
        	        }


        	    }
        	    break;
        	case 14:
        	    // SMARTPL2SQL.g:311:4: GROUPTAG INTBOOL INT
        	    {
        	        GROUPTAG19 = (pANTLR3_BASE_TREE) MATCHT(GROUPTAG, &FOLLOW_GROUPTAG_in_expression321);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        INTBOOL20 = (pANTLR3_BASE_TREE) MATCHT(INTBOOL, &FOLLOW_INTBOOL_in_expression323);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        INT21 = (pANTLR3_BASE_TREE) MATCHT(INT, &FOLLOW_INT_in_expression325);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexpressionEx;
        	        }


        	        {

        	            			retval.result= (GROUPTAG19->getText(GROUPTAG19))->factory->newRaw((GROUPTAG19->getText(GROUPTAG19))->factory);

        	            			retval.result
        	            ->appendS(retval.result
        	            , (GROUPTAG19->getText(GROUPTAG19))->toUTF8((GROUPTAG19->getText(GROUPTAG19))));
        	            			
        	            retval.result
        	            ->append8(retval.result
        	            , " ");
        	            			retval.result
        	            ->appendS(retval.result
        	            , (INTBOOL20->getText(INTBOOL20))->toUTF8((INTBOOL20->getText(INTBOOL20))));
        	            			
        	            retval.result
        	            ->append8(retval.result
        	            , " ");
        	            			retval.result
        	            ->appendS(retval.result
        	            , (INT21->getText(INT21))->toUTF8((INT21->getText(INT21))));
        	            		
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleexpressionEx; /* Prevent compiler warnings */
    ruleexpressionEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return retval;
}
/* $ANTLR end expression */

/**
 * $ANTLR start ordertag
 * SMARTPL2SQL.g:322:1: ordertag returns [ pANTLR3_STRING result ] : ( STRTAG | INTTAG | DATETAG | ENUMTAG | RANDOMTAG );
 */
static pANTLR3_STRING
ordertag(pSMARTPL2SQL ctx)
{
    pANTLR3_STRING result;


    pANTLR3_BASE_TREE    STRTAG22;
    pANTLR3_BASE_TREE    INTTAG23;
    pANTLR3_BASE_TREE    DATETAG24;
    pANTLR3_BASE_TREE    ENUMTAG25;
    pANTLR3_BASE_TREE    RANDOMTAG26;

    /* Initialize rule variables
     */

     result= NULL;
     
    STRTAG22       = NULL;
    INTTAG23       = NULL;
    DATETAG24       = NULL;
    ENUMTAG25       = NULL;
    RANDOMTAG26       = NULL;

    {
        {
            //  SMARTPL2SQL.g:324:2: ( STRTAG | INTTAG | DATETAG | ENUMTAG | RANDOMTAG )

            ANTLR3_UINT32 alt2;

            alt2=5;

            switch ( LA(1) )
            {
            case STRTAG:
            	{
            		alt2=1;
            	}
                break;
            case INTTAG:
            	{
            		alt2=2;
            	}
                break;
            case DATETAG:
            	{
            		alt2=3;
            	}
                break;
            case ENUMTAG:
            	{
            		alt2=4;
            	}
                break;
            case RANDOMTAG:
            	{
            		alt2=5;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 2;
                EXCEPTION->state        = 0;


                goto ruleordertagEx;

            }

            switch (alt2)
            {
        	case 1:
        	    // SMARTPL2SQL.g:324:4: STRTAG
        	    {
        	        STRTAG22 = (pANTLR3_BASE_TREE) MATCHT(STRTAG, &FOLLOW_STRTAG_in_ordertag349);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleordertagEx;
        	        }


        	        {

        	            			result= (STRTAG22->getText(STRTAG22))->factory->newRaw((STRTAG22->getText(STRTAG22))->factory);

        	            			result
        	            ->append8(result
        	            , "f.");
        	            			result
        	            ->appendS(result
        	            , (STRTAG22->getText(STRTAG22))->toUTF8((STRTAG22->getText(STRTAG22))));
        	            		
        	        }


        	    }
        	    break;
        	case 2:
        	    // SMARTPL2SQL.g:330:4: INTTAG
        	    {
        	        INTTAG23 = (pANTLR3_BASE_TREE) MATCHT(INTTAG, &FOLLOW_INTTAG_in_ordertag358);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleordertagEx;
        	        }


        	        {

        	            			result= (INTTAG23->getText(INTTAG23))->factory->newRaw((INTTAG23->getText(INTTAG23))->factory);

        	            			result
        	            ->append8(result
        	            , "f.");
        	            			result
        	            ->appendS(result
        	            , (INTTAG23->getText(INTTAG23))->toUTF8((INTTAG23->getText(INTTAG23))));
        	            		
        	        }


        	    }
        	    break;
        	case 3:
        	    // SMARTPL2SQL.g:336:4: DATETAG
        	    {
        	        DATETAG24 = (pANTLR3_BASE_TREE) MATCHT(DATETAG, &FOLLOW_DATETAG_in_ordertag367);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleordertagEx;
        	        }


        	        {

        	            			result= (DATETAG24->getText(DATETAG24))->factory->newRaw((DATETAG24->getText(DATETAG24))->factory);

        	            			result
        	            ->append8(result
        	            , "f.");
        	            			result
        	            ->appendS(result
        	            , (DATETAG24->getText(DATETAG24))->toUTF8((DATETAG24->getText(DATETAG24))));
        	            		
        	        }


        	    }
        	    break;
        	case 4:
        	    // SMARTPL2SQL.g:342:4: ENUMTAG
        	    {
        	        ENUMTAG25 = (pANTLR3_BASE_TREE) MATCHT(ENUMTAG, &FOLLOW_ENUMTAG_in_ordertag376);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleordertagEx;
        	        }


        	        {

        	            			result= (ENUMTAG25->getText(ENUMTAG25))->factory->newRaw((ENUMTAG25->getText(ENUMTAG25))->factory);

        	            			result
        	            ->append8(result
        	            , "f.");
        	            			result
        	            ->appendS(result
        	            , (ENUMTAG25->getText(ENUMTAG25))->toUTF8((ENUMTAG25->getText(ENUMTAG25))));
        	            		
        	        }


        	    }
        	    break;
        	case 5:
        	    // SMARTPL2SQL.g:348:4: RANDOMTAG
        	    {
        	        RANDOMTAG26 = (pANTLR3_BASE_TREE) MATCHT(RANDOMTAG, &FOLLOW_RANDOMTAG_in_ordertag385);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleordertagEx;
        	        }


        	        {

        	            			result= (RANDOMTAG26->getText(RANDOMTAG26))->factory->newRaw((RANDOMTAG26->getText(RANDOMTAG26))->factory);

        	            			result
        	            ->append8(result
        	            , "random()");
        	            		
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleordertagEx; /* Prevent compiler warnings */
    ruleordertagEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return result;
}
/* $ANTLR end ordertag */

/**
 * $ANTLR start dateval
 * SMARTPL2SQL.g:355:1: dateval returns [ pANTLR3_STRING result ] : ( DATE | interval BEFORE DATE | interval AFTER DATE | interval AGO );
 */
static pANTLR3_STRING
dateval(pSMARTPL2SQL ctx)
{
    pANTLR3_STRING result;


    pANTLR3_BASE_TREE    DATE27;
    pANTLR3_BASE_TREE    DATE28;
    pANTLR3_BASE_TREE    DATE30;
    pANTLR3_BASE_TREE    AGO32;
    pANTLR3_STRING interval29;
    #undef	RETURN_TYPE_interval29
    #define	RETURN_TYPE_interval29 pANTLR3_STRING

    pANTLR3_STRING interval31;
    #undef	RETURN_TYPE_interval31
    #define	RETURN_TYPE_interval31 pANTLR3_STRING

    pANTLR3_STRING interval33;
    #undef	RETURN_TYPE_interval33
    #define	RETURN_TYPE_interval33 pANTLR3_STRING

    /* Initialize rule variables
     */

     result= NULL;
     
    DATE27       = NULL;
    DATE28       = NULL;
    DATE30       = NULL;
    AGO32       = NULL;

    {
        {
            //  SMARTPL2SQL.g:357:2: ( DATE | interval BEFORE DATE | interval AFTER DATE | interval AGO )

            ANTLR3_UINT32 alt3;

            alt3=4;

            switch ( LA(1) )
            {
            case DATE:
            	{
            		alt3=1;
            	}
                break;
            case INT:
            	{
            		switch ( LA(2) )
            		{
            		case DATINTERVAL:
            			{
            				switch ( LA(3) )
            				{
            				case BEFORE:
            					{
            						alt3=2;
            					}
            				    break;
            				case AFTER:
            					{
            						alt3=3;
            					}
            				    break;
            				case AGO:
            					{
            						alt3=4;
            					}
            				    break;

            				default:
            				    CONSTRUCTEX();
            				    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            				    EXCEPTION->message      = (void *)"";
            				    EXCEPTION->decisionNum  = 3;
            				    EXCEPTION->state        = 3;


            				    goto ruledatevalEx;

            				}

            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 3;
            		    EXCEPTION->state        = 2;


            		    goto ruledatevalEx;

            		}

            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 3;
                EXCEPTION->state        = 0;


                goto ruledatevalEx;

            }

            switch (alt3)
            {
        	case 1:
        	    // SMARTPL2SQL.g:357:4: DATE
        	    {
        	        DATE27 = (pANTLR3_BASE_TREE) MATCHT(DATE, &FOLLOW_DATE_in_dateval410);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledatevalEx;
        	        }


        	        {

        	            			pANTLR3_UINT8 datval;
        	            			
        	            			datval = (DATE27->getText(DATE27))->chars;
        	            			
        	            result= (DATE27->getText(DATE27))->factory->newRaw((DATE27->getText(DATE27))->factory);

        	            			
        	            			append_date(result
        	            , (const char *)datval, 0, NULL);
        	            		
        	        }


        	    }
        	    break;
        	case 2:
        	    // SMARTPL2SQL.g:366:4: interval BEFORE DATE
        	    {
        	        FOLLOWPUSH(FOLLOW_interval_in_dateval419);
        	        interval29=interval(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledatevalEx;
        	        }


        	         MATCHT(BEFORE, &FOLLOW_BEFORE_in_dateval421);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledatevalEx;
        	        }


        	        DATE28 = (pANTLR3_BASE_TREE) MATCHT(DATE, &FOLLOW_DATE_in_dateval423);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledatevalEx;
        	        }


        	        {

        	            			result= (DATE28->getText(DATE28))->factory->newRaw((DATE28->getText(DATE28))->factory);

        	            			append_date(result
        	            , (const char *)(DATE28->getText(DATE28))->chars, '-', (const char *)
        	            interval29
        	            ->chars);
        	            		
        	        }


        	    }
        	    break;
        	case 3:
        	    // SMARTPL2SQL.g:371:4: interval AFTER DATE
        	    {
        	        FOLLOWPUSH(FOLLOW_interval_in_dateval432);
        	        interval31=interval(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledatevalEx;
        	        }


        	         MATCHT(AFTER, &FOLLOW_AFTER_in_dateval434);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledatevalEx;
        	        }


        	        DATE30 = (pANTLR3_BASE_TREE) MATCHT(DATE, &FOLLOW_DATE_in_dateval436);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledatevalEx;
        	        }


        	        {

        	            			result= (DATE30->getText(DATE30))->factory->newRaw((DATE30->getText(DATE30))->factory);

        	            			append_date(result
        	            , (const char *)(DATE30->getText(DATE30))->chars, '+', (const char *)
        	            interval31
        	            ->chars);
        	            		
        	        }


        	    }
        	    break;
        	case 4:
        	    // SMARTPL2SQL.g:376:4: interval AGO
        	    {
        	        FOLLOWPUSH(FOLLOW_interval_in_dateval445);
        	        interval33=interval(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledatevalEx;
        	        }


        	        AGO32 = (pANTLR3_BASE_TREE) MATCHT(AGO, &FOLLOW_AGO_in_dateval447);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledatevalEx;
        	        }


        	        {

        	            			result= (AGO32->getText(AGO32))->factory->newRaw((AGO32->getText(AGO32))->factory);

        	            			append_date(result
        	            , "today", '-', (const char *)interval33
        	            ->chars);
        	            		
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruledatevalEx; /* Prevent compiler warnings */
    ruledatevalEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return result;
}
/* $ANTLR end dateval */

/**
 * $ANTLR start interval
 * SMARTPL2SQL.g:383:1: interval returns [ pANTLR3_STRING result ] : INT DATINTERVAL ;
 */
static pANTLR3_STRING
interval(pSMARTPL2SQL ctx)
{
    pANTLR3_STRING result;


    pANTLR3_BASE_TREE    DATINTERVAL34;
    pANTLR3_BASE_TREE    INT35;

    /* Initialize rule variables
     */

     result= NULL;
     
    DATINTERVAL34       = NULL;
    INT35       = NULL;

    {
        // SMARTPL2SQL.g:385:2: ( INT DATINTERVAL )
        // SMARTPL2SQL.g:385:4: INT DATINTERVAL
        {
            INT35 = (pANTLR3_BASE_TREE) MATCHT(INT, &FOLLOW_INT_in_interval471);
            if  (HASEXCEPTION())
            {
                goto ruleintervalEx;
            }


            DATINTERVAL34 = (pANTLR3_BASE_TREE) MATCHT(DATINTERVAL, &FOLLOW_DATINTERVAL_in_interval473);
            if  (HASEXCEPTION())
            {
                goto ruleintervalEx;
            }


            {

                			pANTLR3_UINT8 interval;
                			int intval;
                			char buf[25];

                			result= (DATINTERVAL34->getText(DATINTERVAL34))->factory->newRaw((DATINTERVAL34->getText(DATINTERVAL34))->factory);


                			// SQL doesnt have a modifer for 'week' but for day/hr/min/sec/month/yr
                			interval = (DATINTERVAL34->getText(DATINTERVAL34))->chars;
                			if (strcmp((char *)interval, "weeks") == 0)
                			{
                				intval = atoi((const char *)(INT35->getText(INT35))->chars) * 7;
                				snprintf(buf, sizeof(buf), "%d days", intval);

                				
                result
                ->append8(result
                , buf);
                			}
                			else
                			{
                				result
                ->append8(result
                , (const char *)(INT35->getText(INT35))->chars);
                				
                result
                ->append8(result
                , " ");
                				result
                ->append8(result
                , (const char *)(DATINTERVAL34->getText(DATINTERVAL34))->chars);
                			}
                			return 
                result
                ;
                		
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleintervalEx; /* Prevent compiler warnings */
    ruleintervalEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return result;
}
/* $ANTLR end interval */
/* End of parsing rules
 * ==============================================
 */

/* ==============================================
 * Syntactic predicates
 */
/* End of syntactic predicates
 * ==============================================
 */






/* End of code
 * =============================================================================
 */
