"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HAPMimeTypes = exports.PairingStates = exports.PairMethods = exports.TLVValues = exports.consideredTrue = void 0;
/**
 * @group Utils
 */
function consideredTrue(input) {
    if (!input) {
        return false;
    }
    return input === "true" || input === "1";
}
exports.consideredTrue = consideredTrue;
/**
 * @group HAP Accessory Server
 */
var TLVValues;
(function (TLVValues) {
    // noinspection JSUnusedGlobalSymbols
    TLVValues[TLVValues["REQUEST_TYPE"] = 0] = "REQUEST_TYPE";
    TLVValues[TLVValues["METHOD"] = 0] = "METHOD";
    TLVValues[TLVValues["USERNAME"] = 1] = "USERNAME";
    TLVValues[TLVValues["IDENTIFIER"] = 1] = "IDENTIFIER";
    TLVValues[TLVValues["SALT"] = 2] = "SALT";
    TLVValues[TLVValues["PUBLIC_KEY"] = 3] = "PUBLIC_KEY";
    TLVValues[TLVValues["PASSWORD_PROOF"] = 4] = "PASSWORD_PROOF";
    TLVValues[TLVValues["ENCRYPTED_DATA"] = 5] = "ENCRYPTED_DATA";
    TLVValues[TLVValues["SEQUENCE_NUM"] = 6] = "SEQUENCE_NUM";
    TLVValues[TLVValues["STATE"] = 6] = "STATE";
    TLVValues[TLVValues["ERROR_CODE"] = 7] = "ERROR_CODE";
    TLVValues[TLVValues["RETRY_DELAY"] = 8] = "RETRY_DELAY";
    TLVValues[TLVValues["CERTIFICATE"] = 9] = "CERTIFICATE";
    TLVValues[TLVValues["PROOF"] = 10] = "PROOF";
    TLVValues[TLVValues["SIGNATURE"] = 10] = "SIGNATURE";
    TLVValues[TLVValues["PERMISSIONS"] = 11] = "PERMISSIONS";
    TLVValues[TLVValues["FRAGMENT_DATA"] = 12] = "FRAGMENT_DATA";
    TLVValues[TLVValues["FRAGMENT_LAST"] = 13] = "FRAGMENT_LAST";
    TLVValues[TLVValues["SEPARATOR"] = 255] = "SEPARATOR"; // Zero-length TLV that separates different TLVs in a list.
})(TLVValues = exports.TLVValues || (exports.TLVValues = {}));
/**
 * @group HAP Accessory Server
 */
var PairMethods;
(function (PairMethods) {
    // noinspection JSUnusedGlobalSymbols
    PairMethods[PairMethods["PAIR_SETUP"] = 0] = "PAIR_SETUP";
    PairMethods[PairMethods["PAIR_SETUP_WITH_AUTH"] = 1] = "PAIR_SETUP_WITH_AUTH";
    PairMethods[PairMethods["PAIR_VERIFY"] = 2] = "PAIR_VERIFY";
    PairMethods[PairMethods["ADD_PAIRING"] = 3] = "ADD_PAIRING";
    PairMethods[PairMethods["REMOVE_PAIRING"] = 4] = "REMOVE_PAIRING";
    PairMethods[PairMethods["LIST_PAIRINGS"] = 5] = "LIST_PAIRINGS";
})(PairMethods = exports.PairMethods || (exports.PairMethods = {}));
/**
 * Pairing states (pair-setup or pair-verify). Encoded in {@link TLVValues.SEQUENCE_NUM}.
 *
 * @group HAP Accessory Server
 */
var PairingStates;
(function (PairingStates) {
    PairingStates[PairingStates["M1"] = 1] = "M1";
    PairingStates[PairingStates["M2"] = 2] = "M2";
    PairingStates[PairingStates["M3"] = 3] = "M3";
    PairingStates[PairingStates["M4"] = 4] = "M4";
    PairingStates[PairingStates["M5"] = 5] = "M5";
    PairingStates[PairingStates["M6"] = 6] = "M6";
})(PairingStates = exports.PairingStates || (exports.PairingStates = {}));
/**
 * @group HAP Accessory Server
 */
var HAPMimeTypes;
(function (HAPMimeTypes) {
    HAPMimeTypes["PAIRING_TLV8"] = "application/pairing+tlv8";
    HAPMimeTypes["HAP_JSON"] = "application/hap+json";
    HAPMimeTypes["IMAGE_JPEG"] = "image/jpeg";
})(HAPMimeTypes = exports.HAPMimeTypes || (exports.HAPMimeTypes = {}));
//# sourceMappingURL=internal-types.js.map