"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.HomebridgeNestCamService = void 0;
const common_1 = require("@nestjs/common");
const path = require("path");
const child_process = require("child_process");
const fs = require("fs-extra");
const logger_service_1 = require("../../../core/logger/logger.service");
const plugins_service_1 = require("../../plugins/plugins.service");
let HomebridgeNestCamService = class HomebridgeNestCamService {
    constructor(pluginsService, logger) {
        this.pluginsService = pluginsService;
        this.logger = logger;
    }
    async linkAccount(client) {
        var _a;
        let complete = false;
        const plugins = await this.pluginsService.getInstalledPlugins();
        const nestCamPlugin = plugins.find(x => x.name === 'homebridge-nest-cam');
        if (!nestCamPlugin) {
            this.logger.error('Cannot find homebridge-nest-cam package.');
        }
        const childProcessPath = path.join(nestCamPlugin.installPath, nestCamPlugin.name, 'dist/uix.js');
        if (!await fs.pathExists(childProcessPath)) {
            client.emit('server_error', {
                key: 'not_supported',
                message: 'Your version of homebridge-nest-cam does not support account linking using the Homebridge UI.',
            });
            return;
        }
        if ((_a = this.child) === null || _a === void 0 ? void 0 : _a.connected) {
            this.child.kill();
        }
        this.logger.log(`Starting homebridge-nest-cam account linking script: ${childProcessPath}`);
        this.child = child_process.fork(childProcessPath, [], {
            silent: true,
        });
        this.child.stdout.on('data', (data) => {
            process.stdout.write(data);
        });
        this.child.stderr.on('data', (data) => {
            process.stdout.write(data);
        });
        const cleanup = () => {
            complete = true;
            if (this.child.connected) {
                this.child.disconnect();
                const childPid = this.child.pid;
                setTimeout(() => {
                    try {
                        process.kill(childPid, 'SIGTERM');
                    }
                    catch (e) { }
                }, 5000);
            }
            client.removeAllListeners('end');
            client.removeAllListeners('username');
            client.removeAllListeners('password');
            client.removeAllListeners('totp');
            client.removeAllListeners('cancel');
        };
        client.on('disconnect', () => {
            cleanup();
        });
        client.on('end', () => {
            cleanup();
        });
        client.on('cancel', () => {
            cleanup();
        });
        client.on('username', (payload) => {
            this.child.send({ action: 'username', payload });
        });
        client.on('password', (payload) => {
            this.child.send({ action: 'password', payload });
        });
        client.on('totp', (payload) => {
            this.child.send({ action: 'totp', payload });
        });
        this.child.send({ action: 'doLogin' });
        this.child.addListener('message', (request) => {
            request.action = request.action === 'error' ? 'server_error' : request.action;
            client.emit(request.action, request.payload);
            if (request.action === 'credentials') {
                complete = true;
                cleanup();
            }
        });
        this.child.on('exit', () => {
            this.logger.log('The homebridge-nest-cam account linking script exited.');
            if (!complete) {
                client.emit('browser_closed', { message: 'The account linking process closed unexpectedly.' });
                cleanup();
            }
        });
    }
};
HomebridgeNestCamService = __decorate([
    common_1.Injectable(),
    __metadata("design:paramtypes", [plugins_service_1.PluginsService,
        logger_service_1.Logger])
], HomebridgeNestCamService);
exports.HomebridgeNestCamService = HomebridgeNestCamService;
//# sourceMappingURL=homebridge-nest-cam.service.js.map