/// <reference types="node" />
import { FastifyReply } from 'fastify';
import { BackupService } from './backup.service';
import { Logger } from '../../core/logger/logger.service';
export declare class BackupController {
    private backupService;
    private logger;
    constructor(backupService: BackupService, logger: Logger);
    downloadBackup(reply: any): Promise<void>;
    getNextBackupTime(): Promise<{
        next: boolean | Date;
    }>;
    listScheduledBackups(): Promise<{
        id: string;
        instanceId: string;
        timestamp: Date;
        fileName: string;
    }[]>;
    getScheduledBackup(backupId: any): Promise<import("@nestjs/common").NotFoundException | import("fs").ReadStream>;
    restoreBackup(req: any, res: FastifyReply): void;
    restoreHbfx(req: any, res: FastifyReply): void;
    postBackupRestoreRestart(): {
        status: number;
    };
}
