"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.groupByEndpoint = exports.copyExposesRangeToCharacteristic = exports.roundToDecimalPlaces = exports.getOrAddCharacteristic = exports.errorToString = void 0;
const z2mModels_1 = require("./z2mModels");
function errorToString(e) {
    if (typeof e === 'string') {
        return e;
    }
    if (e instanceof Error) {
        e.message; // works, `e` narrowed to Error
    }
    return JSON.stringify(e);
}
exports.errorToString = errorToString;
function getOrAddCharacteristic(service, characteristic) {
    return service.getCharacteristic(characteristic) || service.addCharacteristic(characteristic);
}
exports.getOrAddCharacteristic = getOrAddCharacteristic;
function roundToDecimalPlaces(input, decimalPlaces) {
    if (decimalPlaces !== Math.round(decimalPlaces) || decimalPlaces < 1 || decimalPlaces > 10) {
        throw new Error(`decimalPlaces must be a whole number between 1 and 10, not ${decimalPlaces}`);
    }
    const maxDecimals = Math.pow(10, decimalPlaces);
    return Math.round((input + Number.EPSILON) * maxDecimals) / maxDecimals;
}
exports.roundToDecimalPlaces = roundToDecimalPlaces;
function copyExposesRangeToCharacteristic(exposes, characteristic) {
    if ((0, z2mModels_1.exposesHasNumericRangeProperty)(exposes)) {
        characteristic.setProps({
            minValue: exposes.value_min,
            maxValue: exposes.value_max,
            minStep: exposes.value_step,
        });
        return true;
    }
    return false;
}
exports.copyExposesRangeToCharacteristic = copyExposesRangeToCharacteristic;
function groupByEndpoint(entries) {
    const endpointMap = new Map();
    entries.forEach((entry) => {
        const collection = endpointMap.get(entry.endpoint);
        if (!collection) {
            endpointMap.set(entry.endpoint, [entry]);
        }
        else {
            collection.push(entry);
        }
    });
    return endpointMap;
}
exports.groupByEndpoint = groupByEndpoint;
//# sourceMappingURL=helpers.js.map