"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExtendedTimer = void 0;
class ExtendedTimer {
    constructor(callback, interval = 1000) {
        this.callback = callback;
        this.interval = interval;
        this.timeout = undefined;
    }
    get isActive() {
        return this.timeout !== undefined;
    }
    changeInterval(newInterval) {
        this.interval = newInterval;
        if (this.isActive) {
            this.restart();
        }
    }
    start() {
        if (!this.isActive) {
            this.timeout = setInterval(this.callback, this.interval);
        }
    }
    restart() {
        this.stop();
        this.start();
    }
    stop() {
        if (this.isActive) {
            clearInterval(this.timeout);
            this.timeout = undefined;
        }
    }
}
exports.ExtendedTimer = ExtendedTimer;
//# sourceMappingURL=timer.js.map