"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BasicSensorCreator = void 0;
const z2mModels_1 = require("../z2mModels");
const helpers_1 = require("../helpers");
const humidity_1 = require("./basic_sensors/humidity");
const air_pressure_1 = require("./basic_sensors/air_pressure");
const light_1 = require("./basic_sensors/light");
const temperature_1 = require("./basic_sensors/temperature");
const contact_1 = require("./basic_sensors/contact");
const leak_1 = require("./basic_sensors/leak");
const carbon_monoxide_1 = require("./basic_sensors/carbon_monoxide");
const smoke_1 = require("./basic_sensors/smoke");
const vibration_1 = require("./basic_sensors/vibration");
const presence_1 = require("./basic_sensors/presence");
const occupancy_1 = require("./basic_sensors/occupancy");
const device_temperature_1 = require("./basic_sensors/device_temperature");
class BasicSensorCreator {
    constructor(converterConfigRegistry) {
        for (const config of BasicSensorCreator.configs) {
            converterConfigRegistry.registerConverterConfiguration(config.converterConfigTag, config.isValidConverterConfiguration);
        }
    }
    createServicesFromExposes(accessory, exposes) {
        const endpointMap = (0, helpers_1.groupByEndpoint)(exposes.filter(e => (0, z2mModels_1.exposesHasProperty)(e) && !accessory.isPropertyExcluded(e.property)
            && (0, z2mModels_1.exposesIsPublished)(e)).map(e => e));
        endpointMap.forEach((value, key) => {
            const optionalProperties = value.filter(e => (0, z2mModels_1.exposesHasBinaryProperty)(e) && (e.name === 'battery_low' || e.name === 'tamper'))
                .map(e => e);
            BasicSensorCreator.handlers.forEach(h => {
                const values = value.filter(e => e.name === h.exposesName && e.type === h.exposesType);
                if (values.length > 0 && !accessory.isServiceHandlerIdKnown(h.generateIdentifier(key, accessory))) {
                    values.forEach(e => this.createService(accessory, e, (x) => new h(x, optionalProperties, accessory)));
                }
            });
        });
    }
    createService(accessory, expose, creator) {
        try {
            const handler = creator(expose);
            accessory.registerServiceHandler(handler);
        }
        catch (error) {
            accessory.log.warn(`Failed to setup sensor for accessory ${accessory.displayName} from expose "${JSON.stringify(expose)}": ${error}`);
        }
    }
}
exports.BasicSensorCreator = BasicSensorCreator;
BasicSensorCreator.handlers = [
    humidity_1.HumiditySensorHandler,
    temperature_1.TemperatureSensorHandler,
    light_1.LightSensorHandler,
    air_pressure_1.AirPressureSensorHandler,
    contact_1.ContactSensorHandler,
    occupancy_1.OccupancySensorHandler,
    presence_1.PresenceSensorHandler,
    vibration_1.VibrationSensorHandler,
    smoke_1.SmokeSensorHandler,
    carbon_monoxide_1.CarbonMonoxideSensorHandler,
    leak_1.WaterLeakSensorHandler,
    leak_1.GasLeakSensorHandler,
    device_temperature_1.DeviceTemperatureSensorHandler,
];
BasicSensorCreator.configs = [
    occupancy_1.OccupancySensorHandler,
];
//# sourceMappingURL=basic_sensors.js.map