import { BasicAccessory } from '../interfaces';
import { ExposesEntryWithBinaryProperty, ExposesKnownTypes } from '../../z2mModels';
import { Characteristic, CharacteristicValue, WithUUID } from 'homebridge';
import { BasicSensorHandler, IdentifierGenerator, ServiceConstructor } from './basic';
export declare class BinarySensorTypeDefinition {
    readonly service: ServiceConstructor;
    readonly characteristic: WithUUID<{
        new (): Characteristic;
    }>;
    readonly hapOnValue: CharacteristicValue;
    readonly hapOffValue: CharacteristicValue;
    readonly additionalSubType?: string | undefined;
    constructor(service: ServiceConstructor, characteristic: WithUUID<{
        new (): Characteristic;
    }>, hapOnValue: CharacteristicValue, hapOffValue: CharacteristicValue, additionalSubType?: string | undefined);
}
export interface BinarySensorConfig {
    type?: string;
}
export declare const isBinarySensorConfig: (x: any) => x is BinarySensorConfig;
export declare abstract class ConfigurableBinarySensorHandler extends BasicSensorHandler {
    static readonly exposesType: ExposesKnownTypes;
    constructor(accessory: BasicAccessory, expose: ExposesEntryWithBinaryProperty, otherExposes: ExposesEntryWithBinaryProperty[], identifierGen: IdentifierGenerator, logName: string, configTag: string | undefined, defaultType: string, typeDefinitions: Map<string, BinarySensorTypeDefinition>);
}
export declare abstract class BinarySensorHandler extends ConfigurableBinarySensorHandler {
    constructor(accessory: BasicAccessory, expose: ExposesEntryWithBinaryProperty, otherExposes: ExposesEntryWithBinaryProperty[], identifierGen: IdentifierGenerator, logName: string, service: ServiceConstructor, characteristic: WithUUID<{
        new (): Characteristic;
    }>, hapOnValue: CharacteristicValue, hapOffValue: CharacteristicValue, additionalSubType?: string | undefined);
}
//# sourceMappingURL=binary.d.ts.map