/*
 * Copyright 2009 Freescale Semiconductor, Inc. All Rights Reserved.
 */

/*
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 */
////////////////////////////////////////////////////////////////////////////////
//
// WARNING!  THIS FILE IS AUTOMATICALLY GENERATED FROM XML.
//                DO NOT MODIFY THIS FILE DIRECTLY.
//
////////////////////////////////////////////////////////////////////////////////
//
// The following naming conventions are followed in this file.
//      XX_<module>_<regname>_<field>
//
// XX specifies the define / macro class
//      HW pertains to a register
//      BM indicates a Bit Mask
//      BF indicates a Bit Field macro
//
// <module> is the hardware module name which can be any of the following...
//      USB20 (Note when there is more than one copy of a given module, the
//      module name includes a number starting from 0 for the first instance
//      of that module)
//
// <regname> is the specific register within that module
//
// <field> is the specific bitfield within that <module>_<register>
//
// We also define the following...
//      hw_<module>_<regname>_t is typedef of anonymous union
//
////////////////////////////////////////////////////////////////////////////////

#ifndef _REGSDCP_H
#define _REGSDCP_H  1

#include "regs.h"

#ifndef REGS_DCP_BASE
#define REGS_DCP_BASE (REGS_BASE + 0x00028000)
#endif

////////////////////////////////////////////////////////////////////////////////
//// HW_DCP_CTRL - DCP Control Register 0
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg8_t   CHANNEL_INTERRUPT_ENABLE;
        unsigned CSC_INTERRUPT_ENABLE      :  1;
        unsigned RSVD0                     : 12;
        unsigned ENABLE_CONTEXT_SWITCHING  :  1;
        unsigned ENABLE_CONTEXT_CACHING    :  1;
        unsigned GATHER_RESIDUAL_WRITES    :  1;
        unsigned RSVD1                     :  4;
        unsigned PRESENT_CSC               :  1;
        unsigned PRESENT_CRYPTO            :  1;
        unsigned CLKGATE                   :  1;
        unsigned SFTRST                    :  1;
    } B;
} hw_dcp_ctrl_t;
#endif


//
// constants & macros for entire HW_DCP_CTRL register
//

#define HW_DCP_CTRL_ADDR      (REGS_DCP_BASE + 0x00000000)
#define HW_DCP_CTRL_SET_ADDR  (REGS_DCP_BASE + 0x00000004)
#define HW_DCP_CTRL_CLR_ADDR  (REGS_DCP_BASE + 0x00000008)
#define HW_DCP_CTRL_TOG_ADDR  (REGS_DCP_BASE + 0x0000000C)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_CTRL           (*(volatile hw_dcp_ctrl_t *) HW_DCP_CTRL_ADDR)
#define HW_DCP_CTRL_RD()      (HW_DCP_CTRL.U)
#define HW_DCP_CTRL_WR(v)     (HW_DCP_CTRL.U = (v))
#define HW_DCP_CTRL_SET(v)    ((*(volatile reg32_t *) HW_DCP_CTRL_SET_ADDR) = (v))
#define HW_DCP_CTRL_CLR(v)    ((*(volatile reg32_t *) HW_DCP_CTRL_CLR_ADDR) = (v))
#define HW_DCP_CTRL_TOG(v)    ((*(volatile reg32_t *) HW_DCP_CTRL_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_DCP_CTRL bitfields
//

//--- Register HW_DCP_CTRL, field SFTRST

#define BP_DCP_CTRL_SFTRST      31
#define BM_DCP_CTRL_SFTRST      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_DCP_CTRL_SFTRST(v)   ((((reg32_t) v) << 31) & BM_DCP_CTRL_SFTRST)
#else
#define BF_DCP_CTRL_SFTRST(v)   (((v) << 31) & BM_DCP_CTRL_SFTRST)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CTRL_SFTRST(v)   BF_CS1(DCP_CTRL, SFTRST, v)
#endif

//--- Register HW_DCP_CTRL, field CLKGATE

#define BP_DCP_CTRL_CLKGATE      30
#define BM_DCP_CTRL_CLKGATE      0x40000000

#define BF_DCP_CTRL_CLKGATE(v)   (((v) << 30) & BM_DCP_CTRL_CLKGATE)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CTRL_CLKGATE(v)   BF_CS1(DCP_CTRL, CLKGATE, v)
#endif

//--- Register HW_DCP_CTRL, field PRESENT_CRYPTO

#define BP_DCP_CTRL_PRESENT_CRYPTO      29
#define BM_DCP_CTRL_PRESENT_CRYPTO      0x20000000

#define BF_DCP_CTRL_PRESENT_CRYPTO(v)   (((v) << 29) & BM_DCP_CTRL_PRESENT_CRYPTO)

#define BV_DCP_CTRL_PRESENT_CRYPTO__Present  0x1
#define BV_DCP_CTRL_PRESENT_CRYPTO__Absent   0x0

//--- Register HW_DCP_CTRL, field PRESENT_CSC

#define BP_DCP_CTRL_PRESENT_CSC      28
#define BM_DCP_CTRL_PRESENT_CSC      0x10000000

#define BF_DCP_CTRL_PRESENT_CSC(v)   (((v) << 28) & BM_DCP_CTRL_PRESENT_CSC)

#define BV_DCP_CTRL_PRESENT_CSC__Present  0x1
#define BV_DCP_CTRL_PRESENT_CSC__Absent   0x0

//--- Register HW_DCP_CTRL, field GATHER_RESIDUAL_WRITES

#define BP_DCP_CTRL_GATHER_RESIDUAL_WRITES      23
#define BM_DCP_CTRL_GATHER_RESIDUAL_WRITES      0x00800000

#define BF_DCP_CTRL_GATHER_RESIDUAL_WRITES(v)   (((v) << 23) & BM_DCP_CTRL_GATHER_RESIDUAL_WRITES)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CTRL_GATHER_RESIDUAL_WRITES(v)   BF_CS1(DCP_CTRL, GATHER_RESIDUAL_WRITES, v)
#endif

//--- Register HW_DCP_CTRL, field ENABLE_CONTEXT_CACHING

#define BP_DCP_CTRL_ENABLE_CONTEXT_CACHING      22
#define BM_DCP_CTRL_ENABLE_CONTEXT_CACHING      0x00400000

#define BF_DCP_CTRL_ENABLE_CONTEXT_CACHING(v)   (((v) << 22) & BM_DCP_CTRL_ENABLE_CONTEXT_CACHING)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CTRL_ENABLE_CONTEXT_CACHING(v)   BF_CS1(DCP_CTRL, ENABLE_CONTEXT_CACHING, v)
#endif

//--- Register HW_DCP_CTRL, field ENABLE_CONTEXT_SWITCHING

#define BP_DCP_CTRL_ENABLE_CONTEXT_SWITCHING      21
#define BM_DCP_CTRL_ENABLE_CONTEXT_SWITCHING      0x00200000

#define BF_DCP_CTRL_ENABLE_CONTEXT_SWITCHING(v)   (((v) << 21) & BM_DCP_CTRL_ENABLE_CONTEXT_SWITCHING)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CTRL_ENABLE_CONTEXT_SWITCHING(v)   BF_CS1(DCP_CTRL, ENABLE_CONTEXT_SWITCHING, v)
#endif

//--- Register HW_DCP_CTRL, field CSC_INTERRUPT_ENABLE

#define BP_DCP_CTRL_CSC_INTERRUPT_ENABLE      8
#define BM_DCP_CTRL_CSC_INTERRUPT_ENABLE      0x00000100

#define BF_DCP_CTRL_CSC_INTERRUPT_ENABLE(v)   (((v) << 8) & BM_DCP_CTRL_CSC_INTERRUPT_ENABLE)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CTRL_CSC_INTERRUPT_ENABLE(v)   BF_CS1(DCP_CTRL, CSC_INTERRUPT_ENABLE, v)
#endif

//--- Register HW_DCP_CTRL, field CHANNEL_INTERRUPT_ENABLE

#define BP_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE      0
#define BM_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE      0x000000FF

#define BF_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE(v)   (((v) << 0) & BM_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE(v)   (HW_DCP_CTRL.B.CHANNEL_INTERRUPT_ENABLE = (v))
#endif

#define BV_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE__CH0  0x01
#define BV_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE__CH1  0x02
#define BV_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE__CH2  0x04
#define BV_DCP_CTRL_CHANNEL_INTERRUPT_ENABLE__CH3  0x08


////////////////////////////////////////////////////////////////////////////////
//// HW_DCP_STAT - DCP Status Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IRQ             :  4;
        unsigned RSVD0           :  4;
        unsigned CSCIRQ          :  1;
        unsigned RSVD1           :  7;
        reg8_t   READY_CHANNELS;
        unsigned CUR_CHANNEL     :  4;
        unsigned OTP_KEY_READY   :  1;
        unsigned RSVD2           :  3;
    } B;
} hw_dcp_stat_t;
#endif


//
// constants & macros for entire HW_DCP_STAT register
//

#define HW_DCP_STAT_ADDR      (REGS_DCP_BASE + 0x00000010)
#define HW_DCP_STAT_SET_ADDR  (REGS_DCP_BASE + 0x00000014)
#define HW_DCP_STAT_CLR_ADDR  (REGS_DCP_BASE + 0x00000018)
#define HW_DCP_STAT_TOG_ADDR  (REGS_DCP_BASE + 0x0000001C)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_STAT           (*(volatile hw_dcp_stat_t *) HW_DCP_STAT_ADDR)
#define HW_DCP_STAT_RD()      (HW_DCP_STAT.U)
#define HW_DCP_STAT_WR(v)     (HW_DCP_STAT.U = (v))
#define HW_DCP_STAT_SET(v)    ((*(volatile reg32_t *) HW_DCP_STAT_SET_ADDR) = (v))
#define HW_DCP_STAT_CLR(v)    ((*(volatile reg32_t *) HW_DCP_STAT_CLR_ADDR) = (v))
#define HW_DCP_STAT_TOG(v)    ((*(volatile reg32_t *) HW_DCP_STAT_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_DCP_STAT bitfields
//

//--- Register HW_DCP_STAT, field OTP_KEY_READY

#define BP_DCP_STAT_OTP_KEY_READY      28
#define BM_DCP_STAT_OTP_KEY_READY      0x10000000

#define BF_DCP_STAT_OTP_KEY_READY(v)   (((v) << 28) & BM_DCP_STAT_OTP_KEY_READY)

//--- Register HW_DCP_STAT, field CUR_CHANNEL

#define BP_DCP_STAT_CUR_CHANNEL      24
#define BM_DCP_STAT_CUR_CHANNEL      0x0F000000

#define BF_DCP_STAT_CUR_CHANNEL(v)   (((v) << 24) & BM_DCP_STAT_CUR_CHANNEL)

#define BV_DCP_STAT_CUR_CHANNEL__None  0x0
#define BV_DCP_STAT_CUR_CHANNEL__CH0   0x1
#define BV_DCP_STAT_CUR_CHANNEL__CH1   0x2
#define BV_DCP_STAT_CUR_CHANNEL__CH2   0x3
#define BV_DCP_STAT_CUR_CHANNEL__CH3   0x4
#define BV_DCP_STAT_CUR_CHANNEL__CSC   0x8

//--- Register HW_DCP_STAT, field READY_CHANNELS

#define BP_DCP_STAT_READY_CHANNELS      16
#define BM_DCP_STAT_READY_CHANNELS      0x00FF0000

#define BF_DCP_STAT_READY_CHANNELS(v)   (((v) << 16) & BM_DCP_STAT_READY_CHANNELS)

#define BV_DCP_STAT_READY_CHANNELS__CH0  0x01
#define BV_DCP_STAT_READY_CHANNELS__CH1  0x02
#define BV_DCP_STAT_READY_CHANNELS__CH2  0x04
#define BV_DCP_STAT_READY_CHANNELS__CH3  0x08

//--- Register HW_DCP_STAT, field CSCIRQ

#define BP_DCP_STAT_CSCIRQ      8
#define BM_DCP_STAT_CSCIRQ      0x00000100

#define BF_DCP_STAT_CSCIRQ(v)   (((v) << 8) & BM_DCP_STAT_CSCIRQ)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_STAT_CSCIRQ(v)   BF_CS1(DCP_STAT, CSCIRQ, v)
#endif

//--- Register HW_DCP_STAT, field IRQ

#define BP_DCP_STAT_IRQ      0
#define BM_DCP_STAT_IRQ      0x0000000F

#define BF_DCP_STAT_IRQ(v)   (((v) << 0) & BM_DCP_STAT_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_STAT_IRQ(v)   BF_CS1(DCP_STAT, IRQ, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DCP_CHANNELCTRL - DCP Channel Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg8_t   ENABLE_CHANNEL;
        reg8_t   HIGH_PRIORITY_CHANNEL;
        unsigned CH0_IRQ_MERGED         :  1;
        unsigned CSC_PRIORITY           :  2;
        unsigned RSVD                   : 13;
    } B;
} hw_dcp_channelctrl_t;
#endif


//
// constants & macros for entire HW_DCP_CHANNELCTRL register
//

#define HW_DCP_CHANNELCTRL_ADDR      (REGS_DCP_BASE + 0x00000020)
#define HW_DCP_CHANNELCTRL_SET_ADDR  (REGS_DCP_BASE + 0x00000024)
#define HW_DCP_CHANNELCTRL_CLR_ADDR  (REGS_DCP_BASE + 0x00000028)
#define HW_DCP_CHANNELCTRL_TOG_ADDR  (REGS_DCP_BASE + 0x0000002C)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_CHANNELCTRL           (*(volatile hw_dcp_channelctrl_t *) HW_DCP_CHANNELCTRL_ADDR)
#define HW_DCP_CHANNELCTRL_RD()      (HW_DCP_CHANNELCTRL.U)
#define HW_DCP_CHANNELCTRL_WR(v)     (HW_DCP_CHANNELCTRL.U = (v))
#define HW_DCP_CHANNELCTRL_SET(v)    ((*(volatile reg32_t *) HW_DCP_CHANNELCTRL_SET_ADDR) = (v))
#define HW_DCP_CHANNELCTRL_CLR(v)    ((*(volatile reg32_t *) HW_DCP_CHANNELCTRL_CLR_ADDR) = (v))
#define HW_DCP_CHANNELCTRL_TOG(v)    ((*(volatile reg32_t *) HW_DCP_CHANNELCTRL_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_DCP_CHANNELCTRL bitfields
//

//--- Register HW_DCP_CHANNELCTRL, field CSC_PRIORITY

#define BP_DCP_CHANNELCTRL_CSC_PRIORITY      17
#define BM_DCP_CHANNELCTRL_CSC_PRIORITY      0x00060000

#define BF_DCP_CHANNELCTRL_CSC_PRIORITY(v)   (((v) << 17) & BM_DCP_CHANNELCTRL_CSC_PRIORITY)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CHANNELCTRL_CSC_PRIORITY(v)   BF_CS1(DCP_CHANNELCTRL, CSC_PRIORITY, v)
#endif

#define BV_DCP_CHANNELCTRL_CSC_PRIORITY__HIGH        0x3
#define BV_DCP_CHANNELCTRL_CSC_PRIORITY__MED         0x2
#define BV_DCP_CHANNELCTRL_CSC_PRIORITY__LOW         0x1
#define BV_DCP_CHANNELCTRL_CSC_PRIORITY__BACKGROUND  0x0

//--- Register HW_DCP_CHANNELCTRL, field CH0_IRQ_MERGED

#define BP_DCP_CHANNELCTRL_CH0_IRQ_MERGED      16
#define BM_DCP_CHANNELCTRL_CH0_IRQ_MERGED      0x00010000

#define BF_DCP_CHANNELCTRL_CH0_IRQ_MERGED(v)   (((v) << 16) & BM_DCP_CHANNELCTRL_CH0_IRQ_MERGED)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CHANNELCTRL_CH0_IRQ_MERGED(v)   BF_CS1(DCP_CHANNELCTRL, CH0_IRQ_MERGED, v)
#endif

//--- Register HW_DCP_CHANNELCTRL, field HIGH_PRIORITY_CHANNEL

#define BP_DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL      8
#define BM_DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL      0x0000FF00

#define BF_DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL(v)   (((v) << 8) & BM_DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL(v)   (HW_DCP_CHANNELCTRL.B.HIGH_PRIORITY_CHANNEL = (v))
#endif

#define BV_DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL__CH0  0x01
#define BV_DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL__CH1  0x02
#define BV_DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL__CH2  0x04
#define BV_DCP_CHANNELCTRL_HIGH_PRIORITY_CHANNEL__CH3  0x08

//--- Register HW_DCP_CHANNELCTRL, field ENABLE_CHANNEL

#define BP_DCP_CHANNELCTRL_ENABLE_CHANNEL      0
#define BM_DCP_CHANNELCTRL_ENABLE_CHANNEL      0x000000FF

#define BF_DCP_CHANNELCTRL_ENABLE_CHANNEL(v)   (((v) << 0) & BM_DCP_CHANNELCTRL_ENABLE_CHANNEL)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CHANNELCTRL_ENABLE_CHANNEL(v)   (HW_DCP_CHANNELCTRL.B.ENABLE_CHANNEL = (v))
#endif

#define BV_DCP_CHANNELCTRL_ENABLE_CHANNEL__CH0  0x01
#define BV_DCP_CHANNELCTRL_ENABLE_CHANNEL__CH1  0x02
#define BV_DCP_CHANNELCTRL_ENABLE_CHANNEL__CH2  0x04
#define BV_DCP_CHANNELCTRL_ENABLE_CHANNEL__CH3  0x08


////////////////////////////////////////////////////////////////////////////////
//// HW_DCP_CAPABILITY0 - DCP Capability 0 Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg8_t   NUM_KEYS;
        unsigned NUM_CHANNELS     :  4;
        unsigned RSVD             : 18;
        unsigned ENABLE_TZONE     :  1;
        unsigned DISABLE_DECRYPT  :  1;
    } B;
} hw_dcp_capability0_t;
#endif


//
// constants & macros for entire HW_DCP_CAPABILITY0 register
//

#define HW_DCP_CAPABILITY0_ADDR      (REGS_DCP_BASE + 0x00000030)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_CAPABILITY0           (*(volatile hw_dcp_capability0_t *) HW_DCP_CAPABILITY0_ADDR)
#define HW_DCP_CAPABILITY0_RD()      (HW_DCP_CAPABILITY0.U)
#define HW_DCP_CAPABILITY0_WR(v)     (HW_DCP_CAPABILITY0.U = (v))
#define HW_DCP_CAPABILITY0_SET(v)    (HW_DCP_CAPABILITY0_WR(HW_DCP_CAPABILITY0_RD() |  (v)))
#define HW_DCP_CAPABILITY0_CLR(v)    (HW_DCP_CAPABILITY0_WR(HW_DCP_CAPABILITY0_RD() & ~(v)))
#define HW_DCP_CAPABILITY0_TOG(v)    (HW_DCP_CAPABILITY0_WR(HW_DCP_CAPABILITY0_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DCP_CAPABILITY0 bitfields
//

//--- Register HW_DCP_CAPABILITY0, field DISABLE_DECRYPT

#define BP_DCP_CAPABILITY0_DISABLE_DECRYPT      31
#define BM_DCP_CAPABILITY0_DISABLE_DECRYPT      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_DCP_CAPABILITY0_DISABLE_DECRYPT(v)   ((((reg32_t) v) << 31) & BM_DCP_CAPABILITY0_DISABLE_DECRYPT)
#else
#define BF_DCP_CAPABILITY0_DISABLE_DECRYPT(v)   (((v) << 31) & BM_DCP_CAPABILITY0_DISABLE_DECRYPT)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CAPABILITY0_DISABLE_DECRYPT(v)   BF_CS1(DCP_CAPABILITY0, DISABLE_DECRYPT, v)
#endif

//--- Register HW_DCP_CAPABILITY0, field ENABLE_TZONE

#define BP_DCP_CAPABILITY0_ENABLE_TZONE      30
#define BM_DCP_CAPABILITY0_ENABLE_TZONE      0x40000000

#define BF_DCP_CAPABILITY0_ENABLE_TZONE(v)   (((v) << 30) & BM_DCP_CAPABILITY0_ENABLE_TZONE)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CAPABILITY0_ENABLE_TZONE(v)   BF_CS1(DCP_CAPABILITY0, ENABLE_TZONE, v)
#endif

//--- Register HW_DCP_CAPABILITY0, field NUM_CHANNELS

#define BP_DCP_CAPABILITY0_NUM_CHANNELS      8
#define BM_DCP_CAPABILITY0_NUM_CHANNELS      0x00000F00

#define BF_DCP_CAPABILITY0_NUM_CHANNELS(v)   (((v) << 8) & BM_DCP_CAPABILITY0_NUM_CHANNELS)

//--- Register HW_DCP_CAPABILITY0, field NUM_KEYS

#define BP_DCP_CAPABILITY0_NUM_KEYS      0
#define BM_DCP_CAPABILITY0_NUM_KEYS      0x000000FF

#define BF_DCP_CAPABILITY0_NUM_KEYS(v)   (((v) << 0) & BM_DCP_CAPABILITY0_NUM_KEYS)


////////////////////////////////////////////////////////////////////////////////
//// HW_DCP_CAPABILITY1 - DCP Capability 1 Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg16_t  CIPHER_ALGORITHMS;
        reg16_t  HASH_ALGORITHMS;
    } B;
} hw_dcp_capability1_t;
#endif


//
// constants & macros for entire HW_DCP_CAPABILITY1 register
//

#define HW_DCP_CAPABILITY1_ADDR      (REGS_DCP_BASE + 0x00000040)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_CAPABILITY1           (*(volatile hw_dcp_capability1_t *) HW_DCP_CAPABILITY1_ADDR)
#define HW_DCP_CAPABILITY1_RD()      (HW_DCP_CAPABILITY1.U)
#endif


//
// constants & macros for individual HW_DCP_CAPABILITY1 bitfields
//

//--- Register HW_DCP_CAPABILITY1, field HASH_ALGORITHMS

#define BP_DCP_CAPABILITY1_HASH_ALGORITHMS      16
#define BM_DCP_CAPABILITY1_HASH_ALGORITHMS      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_DCP_CAPABILITY1_HASH_ALGORITHMS(v)   ((((reg32_t) v) << 16) & BM_DCP_CAPABILITY1_HASH_ALGORITHMS)
#else
#define BF_DCP_CAPABILITY1_HASH_ALGORITHMS(v)   (((v) << 16) & BM_DCP_CAPABILITY1_HASH_ALGORITHMS)
#endif

#define BV_DCP_CAPABILITY1_HASH_ALGORITHMS__SHA1   0x0001
#define BV_DCP_CAPABILITY1_HASH_ALGORITHMS__CRC32  0x0002

//--- Register HW_DCP_CAPABILITY1, field CIPHER_ALGORITHMS

#define BP_DCP_CAPABILITY1_CIPHER_ALGORITHMS      0
#define BM_DCP_CAPABILITY1_CIPHER_ALGORITHMS      0x0000FFFF

#define BF_DCP_CAPABILITY1_CIPHER_ALGORITHMS(v)   (((v) << 0) & BM_DCP_CAPABILITY1_CIPHER_ALGORITHMS)

#define BV_DCP_CAPABILITY1_CIPHER_ALGORITHMS__AES128  0x0001


////////////////////////////////////////////////////////////////////////////////
//// HW_DCP_CONTEXT - DCP Context Buffer Pointer
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  ADDR;
    } B;
} hw_dcp_context_t;
#endif


//
// constants & macros for entire HW_DCP_CONTEXT register
//

#define HW_DCP_CONTEXT_ADDR      (REGS_DCP_BASE + 0x00000050)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_CONTEXT           (*(volatile hw_dcp_context_t *) HW_DCP_CONTEXT_ADDR)
#define HW_DCP_CONTEXT_RD()      (HW_DCP_CONTEXT.U)
#define HW_DCP_CONTEXT_WR(v)     (HW_DCP_CONTEXT.U = (v))
#define HW_DCP_CONTEXT_SET(v)    (HW_DCP_CONTEXT_WR(HW_DCP_CONTEXT_RD() |  (v)))
#define HW_DCP_CONTEXT_CLR(v)    (HW_DCP_CONTEXT_WR(HW_DCP_CONTEXT_RD() & ~(v)))
#define HW_DCP_CONTEXT_TOG(v)    (HW_DCP_CONTEXT_WR(HW_DCP_CONTEXT_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DCP_CONTEXT bitfields
//

//--- Register HW_DCP_CONTEXT, field ADDR

#define BP_DCP_CONTEXT_ADDR      0
#define BM_DCP_CONTEXT_ADDR      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DCP_CONTEXT_ADDR(v)   ((reg32_t) v)
#else
#define BF_DCP_CONTEXT_ADDR(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CONTEXT_ADDR(v)   (HW_DCP_CONTEXT.B.ADDR = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DCP_KEY - DCP Key Index
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned SUBWORD       :  2;
        unsigned RSVD_SUBWORD  :  2;
        unsigned INDEX         :  2;
        unsigned RSVD_INDEX    :  2;
        unsigned RSVD          : 24;
    } B;
} hw_dcp_key_t;
#endif


//
// constants & macros for entire HW_DCP_KEY register
//

#define HW_DCP_KEY_ADDR      (REGS_DCP_BASE + 0x00000060)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_KEY           (*(volatile hw_dcp_key_t *) HW_DCP_KEY_ADDR)
#define HW_DCP_KEY_RD()      (HW_DCP_KEY.U)
#define HW_DCP_KEY_WR(v)     (HW_DCP_KEY.U = (v))
#define HW_DCP_KEY_SET(v)    (HW_DCP_KEY_WR(HW_DCP_KEY_RD() |  (v)))
#define HW_DCP_KEY_CLR(v)    (HW_DCP_KEY_WR(HW_DCP_KEY_RD() & ~(v)))
#define HW_DCP_KEY_TOG(v)    (HW_DCP_KEY_WR(HW_DCP_KEY_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DCP_KEY bitfields
//

//--- Register HW_DCP_KEY, field INDEX

#define BP_DCP_KEY_INDEX      4
#define BM_DCP_KEY_INDEX      0x00000030

#define BF_DCP_KEY_INDEX(v)   (((v) << 4) & BM_DCP_KEY_INDEX)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_KEY_INDEX(v)   BF_CS1(DCP_KEY, INDEX, v)
#endif

//--- Register HW_DCP_KEY, field SUBWORD

#define BP_DCP_KEY_SUBWORD      0
#define BM_DCP_KEY_SUBWORD      0x00000003

#define BF_DCP_KEY_SUBWORD(v)   (((v) << 0) & BM_DCP_KEY_SUBWORD)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_KEY_SUBWORD(v)   BF_CS1(DCP_KEY, SUBWORD, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DCP_KEYDATA - DCP Key Data
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_dcp_keydata_t;
#endif


//
// constants & macros for entire HW_DCP_KEYDATA register
//

#define HW_DCP_KEYDATA_ADDR      (REGS_DCP_BASE + 0x00000070)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_KEYDATA           (*(volatile hw_dcp_keydata_t *) HW_DCP_KEYDATA_ADDR)
#define HW_DCP_KEYDATA_RD()      (HW_DCP_KEYDATA.U)
#define HW_DCP_KEYDATA_WR(v)     (HW_DCP_KEYDATA.U = (v))
#define HW_DCP_KEYDATA_SET(v)    (HW_DCP_KEYDATA_WR(HW_DCP_KEYDATA_RD() |  (v)))
#define HW_DCP_KEYDATA_CLR(v)    (HW_DCP_KEYDATA_WR(HW_DCP_KEYDATA_RD() & ~(v)))
#define HW_DCP_KEYDATA_TOG(v)    (HW_DCP_KEYDATA_WR(HW_DCP_KEYDATA_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DCP_KEYDATA bitfields
//

//--- Register HW_DCP_KEYDATA, field DATA

#define BP_DCP_KEYDATA_DATA      0
#define BM_DCP_KEYDATA_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DCP_KEYDATA_DATA(v)   ((reg32_t) v)
#else
#define BF_DCP_KEYDATA_DATA(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_DCP_KEYDATA_DATA(v)   (HW_DCP_KEYDATA.B.DATA = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DCP_PACKET0 - DCP Work Packet 0 Status Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  ADDR;
    } B;
} hw_dcp_packet0_t;
#endif


//
// constants & macros for entire HW_DCP_PACKET0 register
//

#define HW_DCP_PACKET0_ADDR      (REGS_DCP_BASE + 0x00000080)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_PACKET0           (*(volatile hw_dcp_packet0_t *) HW_DCP_PACKET0_ADDR)
#define HW_DCP_PACKET0_RD()      (HW_DCP_PACKET0.U)
#endif


//
// constants & macros for individual HW_DCP_PACKET0 bitfields
//

//--- Register HW_DCP_PACKET0, field ADDR

#define BP_DCP_PACKET0_ADDR      0
#define BM_DCP_PACKET0_ADDR      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DCP_PACKET0_ADDR(v)   ((reg32_t) v)
#else
#define BF_DCP_PACKET0_ADDR(v)   (v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DCP_PACKET1 - DCP Work Packet 1 Status Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned INTERRUPT         :  1;
        unsigned DECR_SEMAPHORE    :  1;
        unsigned CHAIN             :  1;
        unsigned CHAIN_CONTIGUOUS  :  1;
        unsigned ENABLE_MEMCOPY    :  1;
        unsigned ENABLE_CIPHER     :  1;
        unsigned ENABLE_HASH       :  1;
        unsigned ENABLE_BLIT       :  1;
        unsigned CIPHER_ENCRYPT    :  1;
        unsigned CIPHER_INIT       :  1;
        unsigned OTP_KEY           :  1;
        unsigned PAYLOAD_KEY       :  1;
        unsigned HASH_INIT         :  1;
        unsigned HASH_TERM         :  1;
        unsigned CHECK_HASH        :  1;
        unsigned HASH_OUTPUT       :  1;
        unsigned CONSTANT_FILL     :  1;
        unsigned TEST_SEMA_IRQ     :  1;
        unsigned KEY_BYTESWAP      :  1;
        unsigned KEY_WORDSWAP      :  1;
        unsigned INPUT_BYTESWAP    :  1;
        unsigned INPUT_WORDSWAP    :  1;
        unsigned OUTPUT_BYTESWAP   :  1;
        unsigned OUTPUT_WORDSWAP   :  1;
        reg8_t   TAG;
    } B;
} hw_dcp_packet1_t;
#endif


//
// constants & macros for entire HW_DCP_PACKET1 register
//

#define HW_DCP_PACKET1_ADDR      (REGS_DCP_BASE + 0x00000090)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_PACKET1           (*(volatile hw_dcp_packet1_t *) HW_DCP_PACKET1_ADDR)
#define HW_DCP_PACKET1_RD()      (HW_DCP_PACKET1.U)
#endif


//
// constants & macros for individual HW_DCP_PACKET1 bitfields
//

//--- Register HW_DCP_PACKET1, field TAG

#define BP_DCP_PACKET1_TAG      24
#define BM_DCP_PACKET1_TAG      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_DCP_PACKET1_TAG(v)   ((((reg32_t) v) << 24) & BM_DCP_PACKET1_TAG)
#else
#define BF_DCP_PACKET1_TAG(v)   (((v) << 24) & BM_DCP_PACKET1_TAG)
#endif

//--- Register HW_DCP_PACKET1, field OUTPUT_WORDSWAP

#define BP_DCP_PACKET1_OUTPUT_WORDSWAP      23
#define BM_DCP_PACKET1_OUTPUT_WORDSWAP      0x00800000

#define BF_DCP_PACKET1_OUTPUT_WORDSWAP(v)   (((v) << 23) & BM_DCP_PACKET1_OUTPUT_WORDSWAP)

//--- Register HW_DCP_PACKET1, field OUTPUT_BYTESWAP

#define BP_DCP_PACKET1_OUTPUT_BYTESWAP      22
#define BM_DCP_PACKET1_OUTPUT_BYTESWAP      0x00400000

#define BF_DCP_PACKET1_OUTPUT_BYTESWAP(v)   (((v) << 22) & BM_DCP_PACKET1_OUTPUT_BYTESWAP)

//--- Register HW_DCP_PACKET1, field INPUT_WORDSWAP

#define BP_DCP_PACKET1_INPUT_WORDSWAP      21
#define BM_DCP_PACKET1_INPUT_WORDSWAP      0x00200000

#define BF_DCP_PACKET1_INPUT_WORDSWAP(v)   (((v) << 21) & BM_DCP_PACKET1_INPUT_WORDSWAP)

//--- Register HW_DCP_PACKET1, field INPUT_BYTESWAP

#define BP_DCP_PACKET1_INPUT_BYTESWAP      20
#define BM_DCP_PACKET1_INPUT_BYTESWAP      0x00100000

#define BF_DCP_PACKET1_INPUT_BYTESWAP(v)   (((v) << 20) & BM_DCP_PACKET1_INPUT_BYTESWAP)

//--- Register HW_DCP_PACKET1, field KEY_WORDSWAP

#define BP_DCP_PACKET1_KEY_WORDSWAP      19
#define BM_DCP_PACKET1_KEY_WORDSWAP      0x00080000

#define BF_DCP_PACKET1_KEY_WORDSWAP(v)   (((v) << 19) & BM_DCP_PACKET1_KEY_WORDSWAP)

//--- Register HW_DCP_PACKET1, field KEY_BYTESWAP

#define BP_DCP_PACKET1_KEY_BYTESWAP      18
#define BM_DCP_PACKET1_KEY_BYTESWAP      0x00040000

#define BF_DCP_PACKET1_KEY_BYTESWAP(v)   (((v) << 18) & BM_DCP_PACKET1_KEY_BYTESWAP)

//--- Register HW_DCP_PACKET1, field TEST_SEMA_IRQ

#define BP_DCP_PACKET1_TEST_SEMA_IRQ      17
#define BM_DCP_PACKET1_TEST_SEMA_IRQ      0x00020000

#define BF_DCP_PACKET1_TEST_SEMA_IRQ(v)   (((v) << 17) & BM_DCP_PACKET1_TEST_SEMA_IRQ)

//--- Register HW_DCP_PACKET1, field CONSTANT_FILL

#define BP_DCP_PACKET1_CONSTANT_FILL      16
#define BM_DCP_PACKET1_CONSTANT_FILL      0x00010000

#define BF_DCP_PACKET1_CONSTANT_FILL(v)   (((v) << 16) & BM_DCP_PACKET1_CONSTANT_FILL)

//--- Register HW_DCP_PACKET1, field HASH_OUTPUT

#define BP_DCP_PACKET1_HASH_OUTPUT      15
#define BM_DCP_PACKET1_HASH_OUTPUT      0x00008000

#define BF_DCP_PACKET1_HASH_OUTPUT(v)   (((v) << 15) & BM_DCP_PACKET1_HASH_OUTPUT)

#define BV_DCP_PACKET1_HASH_OUTPUT__INPUT   0x00
#define BV_DCP_PACKET1_HASH_OUTPUT__OUTPUT  0x01

//--- Register HW_DCP_PACKET1, field CHECK_HASH

#define BP_DCP_PACKET1_CHECK_HASH      14
#define BM_DCP_PACKET1_CHECK_HASH      0x00004000

#define BF_DCP_PACKET1_CHECK_HASH(v)   (((v) << 14) & BM_DCP_PACKET1_CHECK_HASH)

//--- Register HW_DCP_PACKET1, field HASH_TERM

#define BP_DCP_PACKET1_HASH_TERM      13
#define BM_DCP_PACKET1_HASH_TERM      0x00002000

#define BF_DCP_PACKET1_HASH_TERM(v)   (((v) << 13) & BM_DCP_PACKET1_HASH_TERM)

//--- Register HW_DCP_PACKET1, field HASH_INIT

#define BP_DCP_PACKET1_HASH_INIT      12
#define BM_DCP_PACKET1_HASH_INIT      0x00001000

#define BF_DCP_PACKET1_HASH_INIT(v)   (((v) << 12) & BM_DCP_PACKET1_HASH_INIT)

//--- Register HW_DCP_PACKET1, field PAYLOAD_KEY

#define BP_DCP_PACKET1_PAYLOAD_KEY      11
#define BM_DCP_PACKET1_PAYLOAD_KEY      0x00000800

#define BF_DCP_PACKET1_PAYLOAD_KEY(v)   (((v) << 11) & BM_DCP_PACKET1_PAYLOAD_KEY)

//--- Register HW_DCP_PACKET1, field OTP_KEY

#define BP_DCP_PACKET1_OTP_KEY      10
#define BM_DCP_PACKET1_OTP_KEY      0x00000400

#define BF_DCP_PACKET1_OTP_KEY(v)   (((v) << 10) & BM_DCP_PACKET1_OTP_KEY)

//--- Register HW_DCP_PACKET1, field CIPHER_INIT

#define BP_DCP_PACKET1_CIPHER_INIT      9
#define BM_DCP_PACKET1_CIPHER_INIT      0x00000200

#define BF_DCP_PACKET1_CIPHER_INIT(v)   (((v) << 9) & BM_DCP_PACKET1_CIPHER_INIT)

//--- Register HW_DCP_PACKET1, field CIPHER_ENCRYPT

#define BP_DCP_PACKET1_CIPHER_ENCRYPT      8
#define BM_DCP_PACKET1_CIPHER_ENCRYPT      0x00000100

#define BF_DCP_PACKET1_CIPHER_ENCRYPT(v)   (((v) << 8) & BM_DCP_PACKET1_CIPHER_ENCRYPT)

#define BV_DCP_PACKET1_CIPHER_ENCRYPT__ENCRYPT  0x01
#define BV_DCP_PACKET1_CIPHER_ENCRYPT__DECRYPT  0x00

//--- Register HW_DCP_PACKET1, field ENABLE_BLIT

#define BP_DCP_PACKET1_ENABLE_BLIT      7
#define BM_DCP_PACKET1_ENABLE_BLIT      0x00000080

#define BF_DCP_PACKET1_ENABLE_BLIT(v)   (((v) << 7) & BM_DCP_PACKET1_ENABLE_BLIT)

//--- Register HW_DCP_PACKET1, field ENABLE_HASH

#define BP_DCP_PACKET1_ENABLE_HASH      6
#define BM_DCP_PACKET1_ENABLE_HASH      0x00000040

#define BF_DCP_PACKET1_ENABLE_HASH(v)   (((v) << 6) & BM_DCP_PACKET1_ENABLE_HASH)

//--- Register HW_DCP_PACKET1, field ENABLE_CIPHER

#define BP_DCP_PACKET1_ENABLE_CIPHER      5
#define BM_DCP_PACKET1_ENABLE_CIPHER      0x00000020

#define BF_DCP_PACKET1_ENABLE_CIPHER(v)   (((v) << 5) & BM_DCP_PACKET1_ENABLE_CIPHER)

//--- Register HW_DCP_PACKET1, field ENABLE_MEMCOPY

#define BP_DCP_PACKET1_ENABLE_MEMCOPY      4
#define BM_DCP_PACKET1_ENABLE_MEMCOPY      0x00000010

#define BF_DCP_PACKET1_ENABLE_MEMCOPY(v)   (((v) << 4) & BM_DCP_PACKET1_ENABLE_MEMCOPY)

//--- Register HW_DCP_PACKET1, field CHAIN_CONTIGUOUS

#define BP_DCP_PACKET1_CHAIN_CONTIGUOUS      3
#define BM_DCP_PACKET1_CHAIN_CONTIGUOUS      0x00000008

#define BF_DCP_PACKET1_CHAIN_CONTIGUOUS(v)   (((v) << 3) & BM_DCP_PACKET1_CHAIN_CONTIGUOUS)

//--- Register HW_DCP_PACKET1, field CHAIN

#define BP_DCP_PACKET1_CHAIN      2
#define BM_DCP_PACKET1_CHAIN      0x00000004

#define BF_DCP_PACKET1_CHAIN(v)   (((v) << 2) & BM_DCP_PACKET1_CHAIN)

//--- Register HW_DCP_PACKET1, field DECR_SEMAPHORE

#define BP_DCP_PACKET1_DECR_SEMAPHORE      1
#define BM_DCP_PACKET1_DECR_SEMAPHORE      0x00000002

#define BF_DCP_PACKET1_DECR_SEMAPHORE(v)   (((v) << 1) & BM_DCP_PACKET1_DECR_SEMAPHORE)

//--- Register HW_DCP_PACKET1, field INTERRUPT

#define BP_DCP_PACKET1_INTERRUPT      0
#define BM_DCP_PACKET1_INTERRUPT      0x00000001

#define BF_DCP_PACKET1_INTERRUPT(v)   (((v) << 0) & BM_DCP_PACKET1_INTERRUPT)


////////////////////////////////////////////////////////////////////////////////
//// HW_DCP_PACKET2 - DCP Work Packet 2 Status Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned CIPHER_SELECT  :  4;
        unsigned CIPHER_MODE    :  4;
        reg8_t   KEY_SELECT;
        unsigned HASH_SELECT    :  4;
        unsigned RSVD           :  4;
        reg8_t   CIPHER_CFG;
    } B;
} hw_dcp_packet2_t;
#endif


//
// constants & macros for entire HW_DCP_PACKET2 register
//

#define HW_DCP_PACKET2_ADDR      (REGS_DCP_BASE + 0x000000A0)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_PACKET2           (*(volatile hw_dcp_packet2_t *) HW_DCP_PACKET2_ADDR)
#define HW_DCP_PACKET2_RD()      (HW_DCP_PACKET2.U)
#endif


//
// constants & macros for individual HW_DCP_PACKET2 bitfields
//

//--- Register HW_DCP_PACKET2, field CIPHER_CFG

#define BP_DCP_PACKET2_CIPHER_CFG      24
#define BM_DCP_PACKET2_CIPHER_CFG      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_DCP_PACKET2_CIPHER_CFG(v)   ((((reg32_t) v) << 24) & BM_DCP_PACKET2_CIPHER_CFG)
#else
#define BF_DCP_PACKET2_CIPHER_CFG(v)   (((v) << 24) & BM_DCP_PACKET2_CIPHER_CFG)
#endif

//--- Register HW_DCP_PACKET2, field HASH_SELECT

#define BP_DCP_PACKET2_HASH_SELECT      16
#define BM_DCP_PACKET2_HASH_SELECT      0x000F0000

#define BF_DCP_PACKET2_HASH_SELECT(v)   (((v) << 16) & BM_DCP_PACKET2_HASH_SELECT)

#define BV_DCP_PACKET2_HASH_SELECT__SHA1   0x00
#define BV_DCP_PACKET2_HASH_SELECT__CRC32  0x01

//--- Register HW_DCP_PACKET2, field KEY_SELECT

#define BP_DCP_PACKET2_KEY_SELECT      8
#define BM_DCP_PACKET2_KEY_SELECT      0x0000FF00

#define BF_DCP_PACKET2_KEY_SELECT(v)   (((v) << 8) & BM_DCP_PACKET2_KEY_SELECT)

//--- Register HW_DCP_PACKET2, field CIPHER_MODE

#define BP_DCP_PACKET2_CIPHER_MODE      4
#define BM_DCP_PACKET2_CIPHER_MODE      0x000000F0

#define BF_DCP_PACKET2_CIPHER_MODE(v)   (((v) << 4) & BM_DCP_PACKET2_CIPHER_MODE)

#define BV_DCP_PACKET2_CIPHER_MODE__ECB  0x00
#define BV_DCP_PACKET2_CIPHER_MODE__CBC  0x01

//--- Register HW_DCP_PACKET2, field CIPHER_SELECT

#define BP_DCP_PACKET2_CIPHER_SELECT      0
#define BM_DCP_PACKET2_CIPHER_SELECT      0x0000000F

#define BF_DCP_PACKET2_CIPHER_SELECT(v)   (((v) << 0) & BM_DCP_PACKET2_CIPHER_SELECT)

#define BV_DCP_PACKET2_CIPHER_SELECT__AES128  0x00


////////////////////////////////////////////////////////////////////////////////
//// HW_DCP_PACKET3 - DCP Work Packet 3 Status Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  ADDR;
    } B;
} hw_dcp_packet3_t;
#endif


//
// constants & macros for entire HW_DCP_PACKET3 register
//

#define HW_DCP_PACKET3_ADDR      (REGS_DCP_BASE + 0x000000B0)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_PACKET3           (*(volatile hw_dcp_packet3_t *) HW_DCP_PACKET3_ADDR)
#define HW_DCP_PACKET3_RD()      (HW_DCP_PACKET3.U)
#endif


//
// constants & macros for individual HW_DCP_PACKET3 bitfields
//

//--- Register HW_DCP_PACKET3, field ADDR

#define BP_DCP_PACKET3_ADDR      0
#define BM_DCP_PACKET3_ADDR      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DCP_PACKET3_ADDR(v)   ((reg32_t) v)
#else
#define BF_DCP_PACKET3_ADDR(v)   (v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DCP_PACKET4 - DCP Work Packet 4 Status Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  ADDR;
    } B;
} hw_dcp_packet4_t;
#endif


//
// constants & macros for entire HW_DCP_PACKET4 register
//

#define HW_DCP_PACKET4_ADDR      (REGS_DCP_BASE + 0x000000C0)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_PACKET4           (*(volatile hw_dcp_packet4_t *) HW_DCP_PACKET4_ADDR)
#define HW_DCP_PACKET4_RD()      (HW_DCP_PACKET4.U)
#endif


//
// constants & macros for individual HW_DCP_PACKET4 bitfields
//

//--- Register HW_DCP_PACKET4, field ADDR

#define BP_DCP_PACKET4_ADDR      0
#define BM_DCP_PACKET4_ADDR      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DCP_PACKET4_ADDR(v)   ((reg32_t) v)
#else
#define BF_DCP_PACKET4_ADDR(v)   (v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DCP_PACKET5 - DCP Work Packet 5 Status Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  COUNT;
    } B;
} hw_dcp_packet5_t;
#endif


//
// constants & macros for entire HW_DCP_PACKET5 register
//

#define HW_DCP_PACKET5_ADDR      (REGS_DCP_BASE + 0x000000D0)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_PACKET5           (*(volatile hw_dcp_packet5_t *) HW_DCP_PACKET5_ADDR)
#define HW_DCP_PACKET5_RD()      (HW_DCP_PACKET5.U)
#endif


//
// constants & macros for individual HW_DCP_PACKET5 bitfields
//

//--- Register HW_DCP_PACKET5, field COUNT

#define BP_DCP_PACKET5_COUNT      0
#define BM_DCP_PACKET5_COUNT      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DCP_PACKET5_COUNT(v)   ((reg32_t) v)
#else
#define BF_DCP_PACKET5_COUNT(v)   (v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DCP_PACKET6 - DCP Work Packet 6 Status Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  ADDR;
    } B;
} hw_dcp_packet6_t;
#endif


//
// constants & macros for entire HW_DCP_PACKET6 register
//

#define HW_DCP_PACKET6_ADDR      (REGS_DCP_BASE + 0x000000E0)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_PACKET6           (*(volatile hw_dcp_packet6_t *) HW_DCP_PACKET6_ADDR)
#define HW_DCP_PACKET6_RD()      (HW_DCP_PACKET6.U)
#endif


//
// constants & macros for individual HW_DCP_PACKET6 bitfields
//

//--- Register HW_DCP_PACKET6, field ADDR

#define BP_DCP_PACKET6_ADDR      0
#define BM_DCP_PACKET6_ADDR      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DCP_PACKET6_ADDR(v)   ((reg32_t) v)
#else
#define BF_DCP_PACKET6_ADDR(v)   (v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// multi-register-define name HW_DCP_CHnCMDPTR : base 0x80028100 : count 4 : offset 0x40
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  ADDR;
    } B;
} hw_dcp_chncmdptr_t;
#endif


//
// constants & macros for entire HW_DCP_CHnCMDPTR multi-register
//

#define HW_DCP_CHnCMDPTR_COUNT        4
#define HW_DCP_CHnCMDPTR_ADDR(n)      (REGS_DCP_BASE + 0x00000100 + ((n) * 0x40))

#ifndef __LANGUAGE_ASM__
#define HW_DCP_CHnCMDPTR(n)           (*(volatile hw_dcp_chncmdptr_t *) HW_DCP_CHnCMDPTR_ADDR(n))
#define HW_DCP_CHnCMDPTR_RD(n)        (HW_DCP_CHnCMDPTR(n).U)
#define HW_DCP_CHnCMDPTR_WR(n, v)     (HW_DCP_CHnCMDPTR(n).U = (v))
#define HW_DCP_CHnCMDPTR_SET(n, v)    (HW_DCP_CHnCMDPTR_WR(n, HW_DCP_CHnCMDPTR_RD(n) |  (v)))
#define HW_DCP_CHnCMDPTR_CLR(n, v)    (HW_DCP_CHnCMDPTR_WR(n, HW_DCP_CHnCMDPTR_RD(n) & ~(v)))
#define HW_DCP_CHnCMDPTR_TOG(n, v)    (HW_DCP_CHnCMDPTR_WR(n, HW_DCP_CHnCMDPTR_RD(n) ^  (v)))
#endif


//
// constants & macros for individual HW_DCP_CHnCMDPTR multi-register bitfields
//

//--- Register HW_DCP_CHnCMDPTR, field ADDR

#define BP_DCP_CHnCMDPTR_ADDR      0
#define BM_DCP_CHnCMDPTR_ADDR      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DCP_CHnCMDPTR_ADDR(v)   ((reg32_t) v)
#else
#define BF_DCP_CHnCMDPTR_ADDR(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CHnCMDPTR_ADDR(n, v)  (HW_DCP_CHnCMDPTR(n).B.ADDR = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// multi-register-define name HW_DCP_CHnSEMA : base 0x80028110 : count 4 : offset 0x40
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg8_t   INCREMENT;
        reg8_t   RSVD1;
        reg8_t   VALUE;
        reg8_t   RSVD2;
    } B;
} hw_dcp_chnsema_t;
#endif


//
// constants & macros for entire HW_DCP_CHnSEMA multi-register
//

#define HW_DCP_CHnSEMA_COUNT        4
#define HW_DCP_CHnSEMA_ADDR(n)      (REGS_DCP_BASE + 0x00000110 + ((n) * 0x40))

#ifndef __LANGUAGE_ASM__
#define HW_DCP_CHnSEMA(n)           (*(volatile hw_dcp_chnsema_t *) HW_DCP_CHnSEMA_ADDR(n))
#define HW_DCP_CHnSEMA_RD(n)        (HW_DCP_CHnSEMA(n).U)
#define HW_DCP_CHnSEMA_WR(n, v)     (HW_DCP_CHnSEMA(n).U = (v))
#define HW_DCP_CHnSEMA_SET(n, v)    (HW_DCP_CHnSEMA_WR(n, HW_DCP_CHnSEMA_RD(n) |  (v)))
#define HW_DCP_CHnSEMA_CLR(n, v)    (HW_DCP_CHnSEMA_WR(n, HW_DCP_CHnSEMA_RD(n) & ~(v)))
#define HW_DCP_CHnSEMA_TOG(n, v)    (HW_DCP_CHnSEMA_WR(n, HW_DCP_CHnSEMA_RD(n) ^  (v)))
#endif


//
// constants & macros for individual HW_DCP_CHnSEMA multi-register bitfields
//

//--- Register HW_DCP_CHnSEMA, field VALUE

#define BP_DCP_CHnSEMA_VALUE      16
#define BM_DCP_CHnSEMA_VALUE      0x00FF0000

#define BF_DCP_CHnSEMA_VALUE(v)   (((v) << 16) & BM_DCP_CHnSEMA_VALUE)

//--- Register HW_DCP_CHnSEMA, field INCREMENT

#define BP_DCP_CHnSEMA_INCREMENT      0
#define BM_DCP_CHnSEMA_INCREMENT      0x000000FF

#define BF_DCP_CHnSEMA_INCREMENT(v)   (((v) << 0) & BM_DCP_CHnSEMA_INCREMENT)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CHnSEMA_INCREMENT(n, v)  (HW_DCP_CHnSEMA(n).B.INCREMENT = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// multi-register-define name HW_DCP_CHnSTAT : base 0x80028120 : count 4 : offset 0x40
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSVD_COMPLETE    :  1;
        unsigned HASH_MISMATCH    :  1;
        unsigned ERROR_SETUP      :  1;
        unsigned ERROR_PACKET     :  1;
        unsigned ERROR_SRC        :  1;
        unsigned ERROR_DST        :  1;
        unsigned ERROR_PAGEFAULT  :  1;
        unsigned RSVD0            :  9;
        reg8_t   ERROR_CODE;
        reg8_t   TAG;
    } B;
} hw_dcp_chnstat_t;
#endif


//
// constants & macros for entire HW_DCP_CHnSTAT multi-register
//

#define HW_DCP_CHnSTAT_COUNT        4
#define HW_DCP_CHnSTAT_ADDR(n)      (REGS_DCP_BASE + 0x00000120 + ((n) * 0x40))
#define HW_DCP_CHnSTAT_SET_ADDR(n)  (REGS_DCP_BASE + 0x00000124 + ((n) * 0x40))
#define HW_DCP_CHnSTAT_CLR_ADDR(n)  (REGS_DCP_BASE + 0x00000128 + ((n) * 0x40))
#define HW_DCP_CHnSTAT_TOG_ADDR(n)  (REGS_DCP_BASE + 0x0000012C + ((n) * 0x40))

#ifndef __LANGUAGE_ASM__
#define HW_DCP_CHnSTAT(n)           (*(volatile hw_dcp_chnstat_t *) HW_DCP_CHnSTAT_ADDR(n))
#define HW_DCP_CHnSTAT_RD(n)        (HW_DCP_CHnSTAT(n).U)
#define HW_DCP_CHnSTAT_WR(n, v)     (HW_DCP_CHnSTAT(n).U = (v))
#define HW_DCP_CHnSTAT_SET(n, v)    ((*(volatile reg32_t *) HW_DCP_CHnSTAT_SET_ADDR(n)) = (v))
#define HW_DCP_CHnSTAT_CLR(n, v)    ((*(volatile reg32_t *) HW_DCP_CHnSTAT_CLR_ADDR(n)) = (v))
#define HW_DCP_CHnSTAT_TOG(n, v)    ((*(volatile reg32_t *) HW_DCP_CHnSTAT_TOG_ADDR(n)) = (v))
#endif


//
// constants & macros for individual HW_DCP_CHnSTAT multi-register bitfields
//

//--- Register HW_DCP_CHnSTAT, field TAG

#define BP_DCP_CHnSTAT_TAG      24
#define BM_DCP_CHnSTAT_TAG      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_DCP_CHnSTAT_TAG(v)   ((((reg32_t) v) << 24) & BM_DCP_CHnSTAT_TAG)
#else
#define BF_DCP_CHnSTAT_TAG(v)   (((v) << 24) & BM_DCP_CHnSTAT_TAG)
#endif

//--- Register HW_DCP_CHnSTAT, field ERROR_CODE

#define BP_DCP_CHnSTAT_ERROR_CODE      16
#define BM_DCP_CHnSTAT_ERROR_CODE      0x00FF0000

#define BF_DCP_CHnSTAT_ERROR_CODE(v)   (((v) << 16) & BM_DCP_CHnSTAT_ERROR_CODE)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CHnSTAT_ERROR_CODE(n, v)  (HW_DCP_CHnSTAT(n).B.ERROR_CODE = (v))
#endif

#define BV_DCP_CHnSTAT_ERROR_CODE__NEXT_CHAIN_IS_0  0x01
#define BV_DCP_CHnSTAT_ERROR_CODE__NO_CHAIN         0x02
#define BV_DCP_CHnSTAT_ERROR_CODE__CONTEXT_ERROR    0x03
#define BV_DCP_CHnSTAT_ERROR_CODE__PAYLOAD_ERROR    0x04
#define BV_DCP_CHnSTAT_ERROR_CODE__INVALID_MODE     0x05

//--- Register HW_DCP_CHnSTAT, field ERROR_PAGEFAULT

#define BP_DCP_CHnSTAT_ERROR_PAGEFAULT      6
#define BM_DCP_CHnSTAT_ERROR_PAGEFAULT      0x00000040

#define BF_DCP_CHnSTAT_ERROR_PAGEFAULT(v)   (((v) << 6) & BM_DCP_CHnSTAT_ERROR_PAGEFAULT)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CHnSTAT_ERROR_PAGEFAULT(n, v)  BF_CS1n(DCP_CHnSTAT, n, ERROR_PAGEFAULT, v)
#endif

//--- Register HW_DCP_CHnSTAT, field ERROR_DST

#define BP_DCP_CHnSTAT_ERROR_DST      5
#define BM_DCP_CHnSTAT_ERROR_DST      0x00000020

#define BF_DCP_CHnSTAT_ERROR_DST(v)   (((v) << 5) & BM_DCP_CHnSTAT_ERROR_DST)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CHnSTAT_ERROR_DST(n, v)  BF_CS1n(DCP_CHnSTAT, n, ERROR_DST, v)
#endif

//--- Register HW_DCP_CHnSTAT, field ERROR_SRC

#define BP_DCP_CHnSTAT_ERROR_SRC      4
#define BM_DCP_CHnSTAT_ERROR_SRC      0x00000010

#define BF_DCP_CHnSTAT_ERROR_SRC(v)   (((v) << 4) & BM_DCP_CHnSTAT_ERROR_SRC)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CHnSTAT_ERROR_SRC(n, v)  BF_CS1n(DCP_CHnSTAT, n, ERROR_SRC, v)
#endif

//--- Register HW_DCP_CHnSTAT, field ERROR_PACKET

#define BP_DCP_CHnSTAT_ERROR_PACKET      3
#define BM_DCP_CHnSTAT_ERROR_PACKET      0x00000008

#define BF_DCP_CHnSTAT_ERROR_PACKET(v)   (((v) << 3) & BM_DCP_CHnSTAT_ERROR_PACKET)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CHnSTAT_ERROR_PACKET(n, v)  BF_CS1n(DCP_CHnSTAT, n, ERROR_PACKET, v)
#endif

//--- Register HW_DCP_CHnSTAT, field ERROR_SETUP

#define BP_DCP_CHnSTAT_ERROR_SETUP      2
#define BM_DCP_CHnSTAT_ERROR_SETUP      0x00000004

#define BF_DCP_CHnSTAT_ERROR_SETUP(v)   (((v) << 2) & BM_DCP_CHnSTAT_ERROR_SETUP)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CHnSTAT_ERROR_SETUP(n, v)  BF_CS1n(DCP_CHnSTAT, n, ERROR_SETUP, v)
#endif

//--- Register HW_DCP_CHnSTAT, field HASH_MISMATCH

#define BP_DCP_CHnSTAT_HASH_MISMATCH      1
#define BM_DCP_CHnSTAT_HASH_MISMATCH      0x00000002

#define BF_DCP_CHnSTAT_HASH_MISMATCH(v)   (((v) << 1) & BM_DCP_CHnSTAT_HASH_MISMATCH)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CHnSTAT_HASH_MISMATCH(n, v)  BF_CS1n(DCP_CHnSTAT, n, HASH_MISMATCH, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// multi-register-define name HW_DCP_CHnOPTS : base 0x80028130 : count 4 : offset 0x40
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg16_t  RECOVERY_TIMER;
        reg16_t  RSVD;
    } B;
} hw_dcp_chnopts_t;
#endif


//
// constants & macros for entire HW_DCP_CHnOPTS multi-register
//

#define HW_DCP_CHnOPTS_COUNT        4
#define HW_DCP_CHnOPTS_ADDR(n)      (REGS_DCP_BASE + 0x00000130 + ((n) * 0x40))
#define HW_DCP_CHnOPTS_SET_ADDR(n)  (REGS_DCP_BASE + 0x00000134 + ((n) * 0x40))
#define HW_DCP_CHnOPTS_CLR_ADDR(n)  (REGS_DCP_BASE + 0x00000138 + ((n) * 0x40))
#define HW_DCP_CHnOPTS_TOG_ADDR(n)  (REGS_DCP_BASE + 0x0000013C + ((n) * 0x40))

#ifndef __LANGUAGE_ASM__
#define HW_DCP_CHnOPTS(n)           (*(volatile hw_dcp_chnopts_t *) HW_DCP_CHnOPTS_ADDR(n))
#define HW_DCP_CHnOPTS_RD(n)        (HW_DCP_CHnOPTS(n).U)
#define HW_DCP_CHnOPTS_WR(n, v)     (HW_DCP_CHnOPTS(n).U = (v))
#define HW_DCP_CHnOPTS_SET(n, v)    ((*(volatile reg32_t *) HW_DCP_CHnOPTS_SET_ADDR(n)) = (v))
#define HW_DCP_CHnOPTS_CLR(n, v)    ((*(volatile reg32_t *) HW_DCP_CHnOPTS_CLR_ADDR(n)) = (v))
#define HW_DCP_CHnOPTS_TOG(n, v)    ((*(volatile reg32_t *) HW_DCP_CHnOPTS_TOG_ADDR(n)) = (v))
#endif


//
// constants & macros for individual HW_DCP_CHnOPTS multi-register bitfields
//

//--- Register HW_DCP_CHnOPTS, field RECOVERY_TIMER

#define BP_DCP_CHnOPTS_RECOVERY_TIMER      0
#define BM_DCP_CHnOPTS_RECOVERY_TIMER      0x0000FFFF

#define BF_DCP_CHnOPTS_RECOVERY_TIMER(v)   (((v) << 0) & BM_DCP_CHnOPTS_RECOVERY_TIMER)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CHnOPTS_RECOVERY_TIMER(n, v)  (HW_DCP_CHnOPTS(n).B.RECOVERY_TIMER = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DCP_CSCCTRL0 - Color Space Conversion Control Register 0
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ENABLE      :  1;
        unsigned RSVD0       :  3;
        unsigned YUV_FORMAT  :  4;
        unsigned RGB_FORMAT  :  2;
        unsigned DELTA       :  1;
        unsigned SUBSAMPLE   :  1;
        unsigned ROTATE      :  1;
        unsigned SCALE       :  1;
        unsigned UPSAMPLE    :  1;
        unsigned CLIP        :  1;
        reg16_t  RSVD1;
    } B;
} hw_dcp_cscctrl0_t;
#endif


//
// constants & macros for entire HW_DCP_CSCCTRL0 register
//

#define HW_DCP_CSCCTRL0_ADDR      (REGS_DCP_BASE + 0x00000300)
#define HW_DCP_CSCCTRL0_SET_ADDR  (REGS_DCP_BASE + 0x00000304)
#define HW_DCP_CSCCTRL0_CLR_ADDR  (REGS_DCP_BASE + 0x00000308)
#define HW_DCP_CSCCTRL0_TOG_ADDR  (REGS_DCP_BASE + 0x0000030C)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_CSCCTRL0           (*(volatile hw_dcp_cscctrl0_t *) HW_DCP_CSCCTRL0_ADDR)
#define HW_DCP_CSCCTRL0_RD()      (HW_DCP_CSCCTRL0.U)
#define HW_DCP_CSCCTRL0_WR(v)     (HW_DCP_CSCCTRL0.U = (v))
#define HW_DCP_CSCCTRL0_SET(v)    ((*(volatile reg32_t *) HW_DCP_CSCCTRL0_SET_ADDR) = (v))
#define HW_DCP_CSCCTRL0_CLR(v)    ((*(volatile reg32_t *) HW_DCP_CSCCTRL0_CLR_ADDR) = (v))
#define HW_DCP_CSCCTRL0_TOG(v)    ((*(volatile reg32_t *) HW_DCP_CSCCTRL0_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_DCP_CSCCTRL0 bitfields
//

//--- Register HW_DCP_CSCCTRL0, field CLIP

#define BP_DCP_CSCCTRL0_CLIP      15
#define BM_DCP_CSCCTRL0_CLIP      0x00008000

#define BF_DCP_CSCCTRL0_CLIP(v)   (((v) << 15) & BM_DCP_CSCCTRL0_CLIP)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CSCCTRL0_CLIP(v)   BF_CS1(DCP_CSCCTRL0, CLIP, v)
#endif

//--- Register HW_DCP_CSCCTRL0, field UPSAMPLE

#define BP_DCP_CSCCTRL0_UPSAMPLE      14
#define BM_DCP_CSCCTRL0_UPSAMPLE      0x00004000

#define BF_DCP_CSCCTRL0_UPSAMPLE(v)   (((v) << 14) & BM_DCP_CSCCTRL0_UPSAMPLE)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CSCCTRL0_UPSAMPLE(v)   BF_CS1(DCP_CSCCTRL0, UPSAMPLE, v)
#endif

//--- Register HW_DCP_CSCCTRL0, field SCALE

#define BP_DCP_CSCCTRL0_SCALE      13
#define BM_DCP_CSCCTRL0_SCALE      0x00002000

#define BF_DCP_CSCCTRL0_SCALE(v)   (((v) << 13) & BM_DCP_CSCCTRL0_SCALE)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CSCCTRL0_SCALE(v)   BF_CS1(DCP_CSCCTRL0, SCALE, v)
#endif

//--- Register HW_DCP_CSCCTRL0, field ROTATE

#define BP_DCP_CSCCTRL0_ROTATE      12
#define BM_DCP_CSCCTRL0_ROTATE      0x00001000

#define BF_DCP_CSCCTRL0_ROTATE(v)   (((v) << 12) & BM_DCP_CSCCTRL0_ROTATE)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CSCCTRL0_ROTATE(v)   BF_CS1(DCP_CSCCTRL0, ROTATE, v)
#endif

//--- Register HW_DCP_CSCCTRL0, field SUBSAMPLE

#define BP_DCP_CSCCTRL0_SUBSAMPLE      11
#define BM_DCP_CSCCTRL0_SUBSAMPLE      0x00000800

#define BF_DCP_CSCCTRL0_SUBSAMPLE(v)   (((v) << 11) & BM_DCP_CSCCTRL0_SUBSAMPLE)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CSCCTRL0_SUBSAMPLE(v)   BF_CS1(DCP_CSCCTRL0, SUBSAMPLE, v)
#endif

//--- Register HW_DCP_CSCCTRL0, field DELTA

#define BP_DCP_CSCCTRL0_DELTA      10
#define BM_DCP_CSCCTRL0_DELTA      0x00000400

#define BF_DCP_CSCCTRL0_DELTA(v)   (((v) << 10) & BM_DCP_CSCCTRL0_DELTA)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CSCCTRL0_DELTA(v)   BF_CS1(DCP_CSCCTRL0, DELTA, v)
#endif

//--- Register HW_DCP_CSCCTRL0, field RGB_FORMAT

#define BP_DCP_CSCCTRL0_RGB_FORMAT      8
#define BM_DCP_CSCCTRL0_RGB_FORMAT      0x00000300

#define BF_DCP_CSCCTRL0_RGB_FORMAT(v)   (((v) << 8) & BM_DCP_CSCCTRL0_RGB_FORMAT)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CSCCTRL0_RGB_FORMAT(v)   BF_CS1(DCP_CSCCTRL0, RGB_FORMAT, v)
#endif

#define BV_DCP_CSCCTRL0_RGB_FORMAT__RGB16_565  0x0
#define BV_DCP_CSCCTRL0_RGB_FORMAT__YCbCrI     0x1
#define BV_DCP_CSCCTRL0_RGB_FORMAT__RGB24      0x2
#define BV_DCP_CSCCTRL0_RGB_FORMAT__YUV422I    0x3

//--- Register HW_DCP_CSCCTRL0, field YUV_FORMAT

#define BP_DCP_CSCCTRL0_YUV_FORMAT      4
#define BM_DCP_CSCCTRL0_YUV_FORMAT      0x000000F0

#define BF_DCP_CSCCTRL0_YUV_FORMAT(v)   (((v) << 4) & BM_DCP_CSCCTRL0_YUV_FORMAT)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CSCCTRL0_YUV_FORMAT(v)   BF_CS1(DCP_CSCCTRL0, YUV_FORMAT, v)
#endif

#define BV_DCP_CSCCTRL0_YUV_FORMAT__YUV420  0x0
#define BV_DCP_CSCCTRL0_YUV_FORMAT__YUV422  0x2

//--- Register HW_DCP_CSCCTRL0, field ENABLE

#define BP_DCP_CSCCTRL0_ENABLE      0
#define BM_DCP_CSCCTRL0_ENABLE      0x00000001

#define BF_DCP_CSCCTRL0_ENABLE(v)   (((v) << 0) & BM_DCP_CSCCTRL0_ENABLE)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CSCCTRL0_ENABLE(v)   BF_CS1(DCP_CSCCTRL0, ENABLE, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DCP_CSCSTAT - Color Space Conversion Status Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned COMPLETE         :  1;
        unsigned RSVD0            :  1;
        unsigned ERROR_SETUP      :  1;
        unsigned RSVD1            :  1;
        unsigned ERROR_SRC        :  1;
        unsigned ERROR_DST        :  1;
        unsigned ERROR_PAGEFAULT  :  1;
        unsigned RSVD2            :  9;
        reg8_t   ERROR_CODE;
        reg8_t   RSVD3;
    } B;
} hw_dcp_cscstat_t;
#endif


//
// constants & macros for entire HW_DCP_CSCSTAT register
//

#define HW_DCP_CSCSTAT_ADDR      (REGS_DCP_BASE + 0x00000310)
#define HW_DCP_CSCSTAT_SET_ADDR  (REGS_DCP_BASE + 0x00000314)
#define HW_DCP_CSCSTAT_CLR_ADDR  (REGS_DCP_BASE + 0x00000318)
#define HW_DCP_CSCSTAT_TOG_ADDR  (REGS_DCP_BASE + 0x0000031C)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_CSCSTAT           (*(volatile hw_dcp_cscstat_t *) HW_DCP_CSCSTAT_ADDR)
#define HW_DCP_CSCSTAT_RD()      (HW_DCP_CSCSTAT.U)
#define HW_DCP_CSCSTAT_WR(v)     (HW_DCP_CSCSTAT.U = (v))
#define HW_DCP_CSCSTAT_SET(v)    ((*(volatile reg32_t *) HW_DCP_CSCSTAT_SET_ADDR) = (v))
#define HW_DCP_CSCSTAT_CLR(v)    ((*(volatile reg32_t *) HW_DCP_CSCSTAT_CLR_ADDR) = (v))
#define HW_DCP_CSCSTAT_TOG(v)    ((*(volatile reg32_t *) HW_DCP_CSCSTAT_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_DCP_CSCSTAT bitfields
//

//--- Register HW_DCP_CSCSTAT, field ERROR_CODE

#define BP_DCP_CSCSTAT_ERROR_CODE      16
#define BM_DCP_CSCSTAT_ERROR_CODE      0x00FF0000

#define BF_DCP_CSCSTAT_ERROR_CODE(v)   (((v) << 16) & BM_DCP_CSCSTAT_ERROR_CODE)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CSCSTAT_ERROR_CODE(v)   (HW_DCP_CSCSTAT.B.ERROR_CODE = (v))
#endif

#define BV_DCP_CSCSTAT_ERROR_CODE__LUMA0_FETCH_ERROR_Y0  0x01
#define BV_DCP_CSCSTAT_ERROR_CODE__LUMA1_FETCH_ERROR_Y1  0x02
#define BV_DCP_CSCSTAT_ERROR_CODE__CHROMA_FETCH_ERROR_U  0x03
#define BV_DCP_CSCSTAT_ERROR_CODE__CHROMA_FETCH_ERROR_V  0x04

//--- Register HW_DCP_CSCSTAT, field ERROR_PAGEFAULT

#define BP_DCP_CSCSTAT_ERROR_PAGEFAULT      6
#define BM_DCP_CSCSTAT_ERROR_PAGEFAULT      0x00000040

#define BF_DCP_CSCSTAT_ERROR_PAGEFAULT(v)   (((v) << 6) & BM_DCP_CSCSTAT_ERROR_PAGEFAULT)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CSCSTAT_ERROR_PAGEFAULT(v)   BF_CS1(DCP_CSCSTAT, ERROR_PAGEFAULT, v)
#endif

//--- Register HW_DCP_CSCSTAT, field ERROR_DST

#define BP_DCP_CSCSTAT_ERROR_DST      5
#define BM_DCP_CSCSTAT_ERROR_DST      0x00000020

#define BF_DCP_CSCSTAT_ERROR_DST(v)   (((v) << 5) & BM_DCP_CSCSTAT_ERROR_DST)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CSCSTAT_ERROR_DST(v)   BF_CS1(DCP_CSCSTAT, ERROR_DST, v)
#endif

//--- Register HW_DCP_CSCSTAT, field ERROR_SRC

#define BP_DCP_CSCSTAT_ERROR_SRC      4
#define BM_DCP_CSCSTAT_ERROR_SRC      0x00000010

#define BF_DCP_CSCSTAT_ERROR_SRC(v)   (((v) << 4) & BM_DCP_CSCSTAT_ERROR_SRC)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CSCSTAT_ERROR_SRC(v)   BF_CS1(DCP_CSCSTAT, ERROR_SRC, v)
#endif

//--- Register HW_DCP_CSCSTAT, field ERROR_SETUP

#define BP_DCP_CSCSTAT_ERROR_SETUP      2
#define BM_DCP_CSCSTAT_ERROR_SETUP      0x00000004

#define BF_DCP_CSCSTAT_ERROR_SETUP(v)   (((v) << 2) & BM_DCP_CSCSTAT_ERROR_SETUP)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CSCSTAT_ERROR_SETUP(v)   BF_CS1(DCP_CSCSTAT, ERROR_SETUP, v)
#endif

//--- Register HW_DCP_CSCSTAT, field COMPLETE

#define BP_DCP_CSCSTAT_COMPLETE      0
#define BM_DCP_CSCSTAT_COMPLETE      0x00000001

#define BF_DCP_CSCSTAT_COMPLETE(v)   (((v) << 0) & BM_DCP_CSCSTAT_COMPLETE)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CSCSTAT_COMPLETE(v)   BF_CS1(DCP_CSCSTAT, COMPLETE, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DCP_CSCOUTBUFPARAM - Color Space Conversion Output Buffer Parameters
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned LINE_SIZE   : 12;
        unsigned FIELD_SIZE  : 12;
        reg8_t   RSVD1;
    } B;
} hw_dcp_cscoutbufparam_t;
#endif


//
// constants & macros for entire HW_DCP_CSCOUTBUFPARAM register
//

#define HW_DCP_CSCOUTBUFPARAM_ADDR      (REGS_DCP_BASE + 0x00000320)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_CSCOUTBUFPARAM           (*(volatile hw_dcp_cscoutbufparam_t *) HW_DCP_CSCOUTBUFPARAM_ADDR)
#define HW_DCP_CSCOUTBUFPARAM_RD()      (HW_DCP_CSCOUTBUFPARAM.U)
#define HW_DCP_CSCOUTBUFPARAM_WR(v)     (HW_DCP_CSCOUTBUFPARAM.U = (v))
#define HW_DCP_CSCOUTBUFPARAM_SET(v)    (HW_DCP_CSCOUTBUFPARAM_WR(HW_DCP_CSCOUTBUFPARAM_RD() |  (v)))
#define HW_DCP_CSCOUTBUFPARAM_CLR(v)    (HW_DCP_CSCOUTBUFPARAM_WR(HW_DCP_CSCOUTBUFPARAM_RD() & ~(v)))
#define HW_DCP_CSCOUTBUFPARAM_TOG(v)    (HW_DCP_CSCOUTBUFPARAM_WR(HW_DCP_CSCOUTBUFPARAM_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DCP_CSCOUTBUFPARAM bitfields
//

//--- Register HW_DCP_CSCOUTBUFPARAM, field FIELD_SIZE

#define BP_DCP_CSCOUTBUFPARAM_FIELD_SIZE      12
#define BM_DCP_CSCOUTBUFPARAM_FIELD_SIZE      0x00FFF000

#define BF_DCP_CSCOUTBUFPARAM_FIELD_SIZE(v)   (((v) << 12) & BM_DCP_CSCOUTBUFPARAM_FIELD_SIZE)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CSCOUTBUFPARAM_FIELD_SIZE(v)   BF_CS1(DCP_CSCOUTBUFPARAM, FIELD_SIZE, v)
#endif

//--- Register HW_DCP_CSCOUTBUFPARAM, field LINE_SIZE

#define BP_DCP_CSCOUTBUFPARAM_LINE_SIZE      0
#define BM_DCP_CSCOUTBUFPARAM_LINE_SIZE      0x00000FFF

#define BF_DCP_CSCOUTBUFPARAM_LINE_SIZE(v)   (((v) << 0) & BM_DCP_CSCOUTBUFPARAM_LINE_SIZE)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CSCOUTBUFPARAM_LINE_SIZE(v)   BF_CS1(DCP_CSCOUTBUFPARAM, LINE_SIZE, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DCP_CSCINBUFPARAM - Color Space Conversion Input Buffer Parameters
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned LINE_SIZE  : 12;
        unsigned RSVD1      : 20;
    } B;
} hw_dcp_cscinbufparam_t;
#endif


//
// constants & macros for entire HW_DCP_CSCINBUFPARAM register
//

#define HW_DCP_CSCINBUFPARAM_ADDR      (REGS_DCP_BASE + 0x00000330)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_CSCINBUFPARAM           (*(volatile hw_dcp_cscinbufparam_t *) HW_DCP_CSCINBUFPARAM_ADDR)
#define HW_DCP_CSCINBUFPARAM_RD()      (HW_DCP_CSCINBUFPARAM.U)
#define HW_DCP_CSCINBUFPARAM_WR(v)     (HW_DCP_CSCINBUFPARAM.U = (v))
#define HW_DCP_CSCINBUFPARAM_SET(v)    (HW_DCP_CSCINBUFPARAM_WR(HW_DCP_CSCINBUFPARAM_RD() |  (v)))
#define HW_DCP_CSCINBUFPARAM_CLR(v)    (HW_DCP_CSCINBUFPARAM_WR(HW_DCP_CSCINBUFPARAM_RD() & ~(v)))
#define HW_DCP_CSCINBUFPARAM_TOG(v)    (HW_DCP_CSCINBUFPARAM_WR(HW_DCP_CSCINBUFPARAM_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DCP_CSCINBUFPARAM bitfields
//

//--- Register HW_DCP_CSCINBUFPARAM, field LINE_SIZE

#define BP_DCP_CSCINBUFPARAM_LINE_SIZE      0
#define BM_DCP_CSCINBUFPARAM_LINE_SIZE      0x00000FFF

#define BF_DCP_CSCINBUFPARAM_LINE_SIZE(v)   (((v) << 0) & BM_DCP_CSCINBUFPARAM_LINE_SIZE)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CSCINBUFPARAM_LINE_SIZE(v)   BF_CS1(DCP_CSCINBUFPARAM, LINE_SIZE, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DCP_CSCRGB - Color Space RGB Frame Buffer Pointer
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  ADDR;
    } B;
} hw_dcp_cscrgb_t;
#endif


//
// constants & macros for entire HW_DCP_CSCRGB register
//

#define HW_DCP_CSCRGB_ADDR      (REGS_DCP_BASE + 0x00000340)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_CSCRGB           (*(volatile hw_dcp_cscrgb_t *) HW_DCP_CSCRGB_ADDR)
#define HW_DCP_CSCRGB_RD()      (HW_DCP_CSCRGB.U)
#define HW_DCP_CSCRGB_WR(v)     (HW_DCP_CSCRGB.U = (v))
#define HW_DCP_CSCRGB_SET(v)    (HW_DCP_CSCRGB_WR(HW_DCP_CSCRGB_RD() |  (v)))
#define HW_DCP_CSCRGB_CLR(v)    (HW_DCP_CSCRGB_WR(HW_DCP_CSCRGB_RD() & ~(v)))
#define HW_DCP_CSCRGB_TOG(v)    (HW_DCP_CSCRGB_WR(HW_DCP_CSCRGB_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DCP_CSCRGB bitfields
//

//--- Register HW_DCP_CSCRGB, field ADDR

#define BP_DCP_CSCRGB_ADDR      0
#define BM_DCP_CSCRGB_ADDR      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DCP_CSCRGB_ADDR(v)   ((reg32_t) v)
#else
#define BF_DCP_CSCRGB_ADDR(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CSCRGB_ADDR(v)   (HW_DCP_CSCRGB.B.ADDR = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DCP_CSCLUMA - Color Space Luma (Y) Buffer Pointer
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  ADDR;
    } B;
} hw_dcp_cscluma_t;
#endif


//
// constants & macros for entire HW_DCP_CSCLUMA register
//

#define HW_DCP_CSCLUMA_ADDR      (REGS_DCP_BASE + 0x00000350)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_CSCLUMA           (*(volatile hw_dcp_cscluma_t *) HW_DCP_CSCLUMA_ADDR)
#define HW_DCP_CSCLUMA_RD()      (HW_DCP_CSCLUMA.U)
#define HW_DCP_CSCLUMA_WR(v)     (HW_DCP_CSCLUMA.U = (v))
#define HW_DCP_CSCLUMA_SET(v)    (HW_DCP_CSCLUMA_WR(HW_DCP_CSCLUMA_RD() |  (v)))
#define HW_DCP_CSCLUMA_CLR(v)    (HW_DCP_CSCLUMA_WR(HW_DCP_CSCLUMA_RD() & ~(v)))
#define HW_DCP_CSCLUMA_TOG(v)    (HW_DCP_CSCLUMA_WR(HW_DCP_CSCLUMA_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DCP_CSCLUMA bitfields
//

//--- Register HW_DCP_CSCLUMA, field ADDR

#define BP_DCP_CSCLUMA_ADDR      0
#define BM_DCP_CSCLUMA_ADDR      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DCP_CSCLUMA_ADDR(v)   ((reg32_t) v)
#else
#define BF_DCP_CSCLUMA_ADDR(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CSCLUMA_ADDR(v)   (HW_DCP_CSCLUMA.B.ADDR = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DCP_CSCCHROMAU - Color Space Chroma (U/Cb) Buffer Pointer
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  ADDR;
    } B;
} hw_dcp_cscchromau_t;
#endif


//
// constants & macros for entire HW_DCP_CSCCHROMAU register
//

#define HW_DCP_CSCCHROMAU_ADDR      (REGS_DCP_BASE + 0x00000360)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_CSCCHROMAU           (*(volatile hw_dcp_cscchromau_t *) HW_DCP_CSCCHROMAU_ADDR)
#define HW_DCP_CSCCHROMAU_RD()      (HW_DCP_CSCCHROMAU.U)
#define HW_DCP_CSCCHROMAU_WR(v)     (HW_DCP_CSCCHROMAU.U = (v))
#define HW_DCP_CSCCHROMAU_SET(v)    (HW_DCP_CSCCHROMAU_WR(HW_DCP_CSCCHROMAU_RD() |  (v)))
#define HW_DCP_CSCCHROMAU_CLR(v)    (HW_DCP_CSCCHROMAU_WR(HW_DCP_CSCCHROMAU_RD() & ~(v)))
#define HW_DCP_CSCCHROMAU_TOG(v)    (HW_DCP_CSCCHROMAU_WR(HW_DCP_CSCCHROMAU_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DCP_CSCCHROMAU bitfields
//

//--- Register HW_DCP_CSCCHROMAU, field ADDR

#define BP_DCP_CSCCHROMAU_ADDR      0
#define BM_DCP_CSCCHROMAU_ADDR      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DCP_CSCCHROMAU_ADDR(v)   ((reg32_t) v)
#else
#define BF_DCP_CSCCHROMAU_ADDR(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CSCCHROMAU_ADDR(v)   (HW_DCP_CSCCHROMAU.B.ADDR = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DCP_CSCCHROMAV - Color Space Chroma (V/Cr) Buffer Pointer
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  ADDR;
    } B;
} hw_dcp_cscchromav_t;
#endif


//
// constants & macros for entire HW_DCP_CSCCHROMAV register
//

#define HW_DCP_CSCCHROMAV_ADDR      (REGS_DCP_BASE + 0x00000370)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_CSCCHROMAV           (*(volatile hw_dcp_cscchromav_t *) HW_DCP_CSCCHROMAV_ADDR)
#define HW_DCP_CSCCHROMAV_RD()      (HW_DCP_CSCCHROMAV.U)
#define HW_DCP_CSCCHROMAV_WR(v)     (HW_DCP_CSCCHROMAV.U = (v))
#define HW_DCP_CSCCHROMAV_SET(v)    (HW_DCP_CSCCHROMAV_WR(HW_DCP_CSCCHROMAV_RD() |  (v)))
#define HW_DCP_CSCCHROMAV_CLR(v)    (HW_DCP_CSCCHROMAV_WR(HW_DCP_CSCCHROMAV_RD() & ~(v)))
#define HW_DCP_CSCCHROMAV_TOG(v)    (HW_DCP_CSCCHROMAV_WR(HW_DCP_CSCCHROMAV_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DCP_CSCCHROMAV bitfields
//

//--- Register HW_DCP_CSCCHROMAV, field ADDR

#define BP_DCP_CSCCHROMAV_ADDR      0
#define BM_DCP_CSCCHROMAV_ADDR      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DCP_CSCCHROMAV_ADDR(v)   ((reg32_t) v)
#else
#define BF_DCP_CSCCHROMAV_ADDR(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CSCCHROMAV_ADDR(v)   (HW_DCP_CSCCHROMAV.B.ADDR = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DCP_CSCCOEFF0 - Color Space Conversion Coefficient Register 0
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg8_t   Y_OFFSET;
        reg8_t   UV_OFFSET;
        unsigned C0         : 10;
        unsigned RSVD1      :  6;
    } B;
} hw_dcp_csccoeff0_t;
#endif


//
// constants & macros for entire HW_DCP_CSCCOEFF0 register
//

#define HW_DCP_CSCCOEFF0_ADDR      (REGS_DCP_BASE + 0x00000380)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_CSCCOEFF0           (*(volatile hw_dcp_csccoeff0_t *) HW_DCP_CSCCOEFF0_ADDR)
#define HW_DCP_CSCCOEFF0_RD()      (HW_DCP_CSCCOEFF0.U)
#define HW_DCP_CSCCOEFF0_WR(v)     (HW_DCP_CSCCOEFF0.U = (v))
#define HW_DCP_CSCCOEFF0_SET(v)    (HW_DCP_CSCCOEFF0_WR(HW_DCP_CSCCOEFF0_RD() |  (v)))
#define HW_DCP_CSCCOEFF0_CLR(v)    (HW_DCP_CSCCOEFF0_WR(HW_DCP_CSCCOEFF0_RD() & ~(v)))
#define HW_DCP_CSCCOEFF0_TOG(v)    (HW_DCP_CSCCOEFF0_WR(HW_DCP_CSCCOEFF0_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DCP_CSCCOEFF0 bitfields
//

//--- Register HW_DCP_CSCCOEFF0, field C0

#define BP_DCP_CSCCOEFF0_C0      16
#define BM_DCP_CSCCOEFF0_C0      0x03FF0000

#define BF_DCP_CSCCOEFF0_C0(v)   (((v) << 16) & BM_DCP_CSCCOEFF0_C0)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CSCCOEFF0_C0(v)   BF_CS1(DCP_CSCCOEFF0, C0, v)
#endif

//--- Register HW_DCP_CSCCOEFF0, field UV_OFFSET

#define BP_DCP_CSCCOEFF0_UV_OFFSET      8
#define BM_DCP_CSCCOEFF0_UV_OFFSET      0x0000FF00

#define BF_DCP_CSCCOEFF0_UV_OFFSET(v)   (((v) << 8) & BM_DCP_CSCCOEFF0_UV_OFFSET)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CSCCOEFF0_UV_OFFSET(v)   (HW_DCP_CSCCOEFF0.B.UV_OFFSET = (v))
#endif

//--- Register HW_DCP_CSCCOEFF0, field Y_OFFSET

#define BP_DCP_CSCCOEFF0_Y_OFFSET      0
#define BM_DCP_CSCCOEFF0_Y_OFFSET      0x000000FF

#define BF_DCP_CSCCOEFF0_Y_OFFSET(v)   (((v) << 0) & BM_DCP_CSCCOEFF0_Y_OFFSET)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CSCCOEFF0_Y_OFFSET(v)   (HW_DCP_CSCCOEFF0.B.Y_OFFSET = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DCP_CSCCOEFF1 - Color Space Conversion Coefficient Register 1
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned C4     : 10;
        unsigned RSVD0  :  6;
        unsigned C1     : 10;
        unsigned RSVD1  :  6;
    } B;
} hw_dcp_csccoeff1_t;
#endif


//
// constants & macros for entire HW_DCP_CSCCOEFF1 register
//

#define HW_DCP_CSCCOEFF1_ADDR      (REGS_DCP_BASE + 0x00000390)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_CSCCOEFF1           (*(volatile hw_dcp_csccoeff1_t *) HW_DCP_CSCCOEFF1_ADDR)
#define HW_DCP_CSCCOEFF1_RD()      (HW_DCP_CSCCOEFF1.U)
#define HW_DCP_CSCCOEFF1_WR(v)     (HW_DCP_CSCCOEFF1.U = (v))
#define HW_DCP_CSCCOEFF1_SET(v)    (HW_DCP_CSCCOEFF1_WR(HW_DCP_CSCCOEFF1_RD() |  (v)))
#define HW_DCP_CSCCOEFF1_CLR(v)    (HW_DCP_CSCCOEFF1_WR(HW_DCP_CSCCOEFF1_RD() & ~(v)))
#define HW_DCP_CSCCOEFF1_TOG(v)    (HW_DCP_CSCCOEFF1_WR(HW_DCP_CSCCOEFF1_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DCP_CSCCOEFF1 bitfields
//

//--- Register HW_DCP_CSCCOEFF1, field C1

#define BP_DCP_CSCCOEFF1_C1      16
#define BM_DCP_CSCCOEFF1_C1      0x03FF0000

#define BF_DCP_CSCCOEFF1_C1(v)   (((v) << 16) & BM_DCP_CSCCOEFF1_C1)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CSCCOEFF1_C1(v)   BF_CS1(DCP_CSCCOEFF1, C1, v)
#endif

//--- Register HW_DCP_CSCCOEFF1, field C4

#define BP_DCP_CSCCOEFF1_C4      0
#define BM_DCP_CSCCOEFF1_C4      0x000003FF

#define BF_DCP_CSCCOEFF1_C4(v)   (((v) << 0) & BM_DCP_CSCCOEFF1_C4)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CSCCOEFF1_C4(v)   BF_CS1(DCP_CSCCOEFF1, C4, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DCP_CSCCOEFF2 - Color Space Conversion Coefficient Register 2
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned C3     : 10;
        unsigned RSVD0  :  6;
        unsigned C2     : 10;
        unsigned RSVD1  :  6;
    } B;
} hw_dcp_csccoeff2_t;
#endif


//
// constants & macros for entire HW_DCP_CSCCOEFF2 register
//

#define HW_DCP_CSCCOEFF2_ADDR      (REGS_DCP_BASE + 0x000003A0)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_CSCCOEFF2           (*(volatile hw_dcp_csccoeff2_t *) HW_DCP_CSCCOEFF2_ADDR)
#define HW_DCP_CSCCOEFF2_RD()      (HW_DCP_CSCCOEFF2.U)
#define HW_DCP_CSCCOEFF2_WR(v)     (HW_DCP_CSCCOEFF2.U = (v))
#define HW_DCP_CSCCOEFF2_SET(v)    (HW_DCP_CSCCOEFF2_WR(HW_DCP_CSCCOEFF2_RD() |  (v)))
#define HW_DCP_CSCCOEFF2_CLR(v)    (HW_DCP_CSCCOEFF2_WR(HW_DCP_CSCCOEFF2_RD() & ~(v)))
#define HW_DCP_CSCCOEFF2_TOG(v)    (HW_DCP_CSCCOEFF2_WR(HW_DCP_CSCCOEFF2_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DCP_CSCCOEFF2 bitfields
//

//--- Register HW_DCP_CSCCOEFF2, field C2

#define BP_DCP_CSCCOEFF2_C2      16
#define BM_DCP_CSCCOEFF2_C2      0x03FF0000

#define BF_DCP_CSCCOEFF2_C2(v)   (((v) << 16) & BM_DCP_CSCCOEFF2_C2)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CSCCOEFF2_C2(v)   BF_CS1(DCP_CSCCOEFF2, C2, v)
#endif

//--- Register HW_DCP_CSCCOEFF2, field C3

#define BP_DCP_CSCCOEFF2_C3      0
#define BM_DCP_CSCCOEFF2_C3      0x000003FF

#define BF_DCP_CSCCOEFF2_C3(v)   (((v) << 0) & BM_DCP_CSCCOEFF2_C3)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CSCCOEFF2_C3(v)   BF_CS1(DCP_CSCCOEFF2, C3, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DCP_CSCCLIP - Color Space Conversion Clipping Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned WIDTH   : 12;
        unsigned HEIGHT  : 12;
        reg8_t   RSVD1;
    } B;
} hw_dcp_cscclip_t;
#endif


//
// constants & macros for entire HW_DCP_CSCCLIP register
//

#define HW_DCP_CSCCLIP_ADDR      (REGS_DCP_BASE + 0x000003D0)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_CSCCLIP           (*(volatile hw_dcp_cscclip_t *) HW_DCP_CSCCLIP_ADDR)
#define HW_DCP_CSCCLIP_RD()      (HW_DCP_CSCCLIP.U)
#define HW_DCP_CSCCLIP_WR(v)     (HW_DCP_CSCCLIP.U = (v))
#define HW_DCP_CSCCLIP_SET(v)    (HW_DCP_CSCCLIP_WR(HW_DCP_CSCCLIP_RD() |  (v)))
#define HW_DCP_CSCCLIP_CLR(v)    (HW_DCP_CSCCLIP_WR(HW_DCP_CSCCLIP_RD() & ~(v)))
#define HW_DCP_CSCCLIP_TOG(v)    (HW_DCP_CSCCLIP_WR(HW_DCP_CSCCLIP_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DCP_CSCCLIP bitfields
//

//--- Register HW_DCP_CSCCLIP, field HEIGHT

#define BP_DCP_CSCCLIP_HEIGHT      12
#define BM_DCP_CSCCLIP_HEIGHT      0x00FFF000

#define BF_DCP_CSCCLIP_HEIGHT(v)   (((v) << 12) & BM_DCP_CSCCLIP_HEIGHT)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CSCCLIP_HEIGHT(v)   BF_CS1(DCP_CSCCLIP, HEIGHT, v)
#endif

//--- Register HW_DCP_CSCCLIP, field WIDTH

#define BP_DCP_CSCCLIP_WIDTH      0
#define BM_DCP_CSCCLIP_WIDTH      0x00000FFF

#define BF_DCP_CSCCLIP_WIDTH(v)   (((v) << 0) & BM_DCP_CSCCLIP_WIDTH)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CSCCLIP_WIDTH(v)   BF_CS1(DCP_CSCCLIP, WIDTH, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DCP_CSCXSCALE - Color Space Conversion X-Scaling Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned WIDTH  : 12;
        unsigned FRAC   : 12;
        unsigned INT    :  2;
        unsigned RSVD1  :  6;
    } B;
} hw_dcp_cscxscale_t;
#endif


//
// constants & macros for entire HW_DCP_CSCXSCALE register
//

#define HW_DCP_CSCXSCALE_ADDR      (REGS_DCP_BASE + 0x000003E0)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_CSCXSCALE           (*(volatile hw_dcp_cscxscale_t *) HW_DCP_CSCXSCALE_ADDR)
#define HW_DCP_CSCXSCALE_RD()      (HW_DCP_CSCXSCALE.U)
#define HW_DCP_CSCXSCALE_WR(v)     (HW_DCP_CSCXSCALE.U = (v))
#define HW_DCP_CSCXSCALE_SET(v)    (HW_DCP_CSCXSCALE_WR(HW_DCP_CSCXSCALE_RD() |  (v)))
#define HW_DCP_CSCXSCALE_CLR(v)    (HW_DCP_CSCXSCALE_WR(HW_DCP_CSCXSCALE_RD() & ~(v)))
#define HW_DCP_CSCXSCALE_TOG(v)    (HW_DCP_CSCXSCALE_WR(HW_DCP_CSCXSCALE_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DCP_CSCXSCALE bitfields
//

//--- Register HW_DCP_CSCXSCALE, field INT

#define BP_DCP_CSCXSCALE_INT      24
#define BM_DCP_CSCXSCALE_INT      0x03000000

#define BF_DCP_CSCXSCALE_INT(v)   (((v) << 24) & BM_DCP_CSCXSCALE_INT)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CSCXSCALE_INT(v)   BF_CS1(DCP_CSCXSCALE, INT, v)
#endif

//--- Register HW_DCP_CSCXSCALE, field FRAC

#define BP_DCP_CSCXSCALE_FRAC      12
#define BM_DCP_CSCXSCALE_FRAC      0x00FFF000

#define BF_DCP_CSCXSCALE_FRAC(v)   (((v) << 12) & BM_DCP_CSCXSCALE_FRAC)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CSCXSCALE_FRAC(v)   BF_CS1(DCP_CSCXSCALE, FRAC, v)
#endif

//--- Register HW_DCP_CSCXSCALE, field WIDTH

#define BP_DCP_CSCXSCALE_WIDTH      0
#define BM_DCP_CSCXSCALE_WIDTH      0x00000FFF

#define BF_DCP_CSCXSCALE_WIDTH(v)   (((v) << 0) & BM_DCP_CSCXSCALE_WIDTH)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CSCXSCALE_WIDTH(v)   BF_CS1(DCP_CSCXSCALE, WIDTH, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DCP_CSCYSCALE - Color Space Conversion Y-Scaling Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned HEIGHT  : 12;
        unsigned FRAC    : 12;
        unsigned INT     :  2;
        unsigned RSVD1   :  6;
    } B;
} hw_dcp_cscyscale_t;
#endif


//
// constants & macros for entire HW_DCP_CSCYSCALE register
//

#define HW_DCP_CSCYSCALE_ADDR      (REGS_DCP_BASE + 0x000003F0)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_CSCYSCALE           (*(volatile hw_dcp_cscyscale_t *) HW_DCP_CSCYSCALE_ADDR)
#define HW_DCP_CSCYSCALE_RD()      (HW_DCP_CSCYSCALE.U)
#define HW_DCP_CSCYSCALE_WR(v)     (HW_DCP_CSCYSCALE.U = (v))
#define HW_DCP_CSCYSCALE_SET(v)    (HW_DCP_CSCYSCALE_WR(HW_DCP_CSCYSCALE_RD() |  (v)))
#define HW_DCP_CSCYSCALE_CLR(v)    (HW_DCP_CSCYSCALE_WR(HW_DCP_CSCYSCALE_RD() & ~(v)))
#define HW_DCP_CSCYSCALE_TOG(v)    (HW_DCP_CSCYSCALE_WR(HW_DCP_CSCYSCALE_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DCP_CSCYSCALE bitfields
//

//--- Register HW_DCP_CSCYSCALE, field INT

#define BP_DCP_CSCYSCALE_INT      24
#define BM_DCP_CSCYSCALE_INT      0x03000000

#define BF_DCP_CSCYSCALE_INT(v)   (((v) << 24) & BM_DCP_CSCYSCALE_INT)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CSCYSCALE_INT(v)   BF_CS1(DCP_CSCYSCALE, INT, v)
#endif

//--- Register HW_DCP_CSCYSCALE, field FRAC

#define BP_DCP_CSCYSCALE_FRAC      12
#define BM_DCP_CSCYSCALE_FRAC      0x00FFF000

#define BF_DCP_CSCYSCALE_FRAC(v)   (((v) << 12) & BM_DCP_CSCYSCALE_FRAC)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CSCYSCALE_FRAC(v)   BF_CS1(DCP_CSCYSCALE, FRAC, v)
#endif

//--- Register HW_DCP_CSCYSCALE, field HEIGHT

#define BP_DCP_CSCYSCALE_HEIGHT      0
#define BM_DCP_CSCYSCALE_HEIGHT      0x00000FFF

#define BF_DCP_CSCYSCALE_HEIGHT(v)   (((v) << 0) & BM_DCP_CSCYSCALE_HEIGHT)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_CSCYSCALE_HEIGHT(v)   BF_CS1(DCP_CSCYSCALE, HEIGHT, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DCP_DBGSELECT - DCP Debug Select Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg8_t   INDEX;
        unsigned RSVD   : 24;
    } B;
} hw_dcp_dbgselect_t;
#endif


//
// constants & macros for entire HW_DCP_DBGSELECT register
//

#define HW_DCP_DBGSELECT_ADDR      (REGS_DCP_BASE + 0x00000400)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_DBGSELECT           (*(volatile hw_dcp_dbgselect_t *) HW_DCP_DBGSELECT_ADDR)
#define HW_DCP_DBGSELECT_RD()      (HW_DCP_DBGSELECT.U)
#define HW_DCP_DBGSELECT_WR(v)     (HW_DCP_DBGSELECT.U = (v))
#define HW_DCP_DBGSELECT_SET(v)    (HW_DCP_DBGSELECT_WR(HW_DCP_DBGSELECT_RD() |  (v)))
#define HW_DCP_DBGSELECT_CLR(v)    (HW_DCP_DBGSELECT_WR(HW_DCP_DBGSELECT_RD() & ~(v)))
#define HW_DCP_DBGSELECT_TOG(v)    (HW_DCP_DBGSELECT_WR(HW_DCP_DBGSELECT_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DCP_DBGSELECT bitfields
//

//--- Register HW_DCP_DBGSELECT, field INDEX

#define BP_DCP_DBGSELECT_INDEX      0
#define BM_DCP_DBGSELECT_INDEX      0x000000FF

#define BF_DCP_DBGSELECT_INDEX(v)   (((v) << 0) & BM_DCP_DBGSELECT_INDEX)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_DBGSELECT_INDEX(v)   (HW_DCP_DBGSELECT.B.INDEX = (v))
#endif

#define BV_DCP_DBGSELECT_INDEX__CONTROL  0x01
#define BV_DCP_DBGSELECT_INDEX__OTPKEY0  0x10
#define BV_DCP_DBGSELECT_INDEX__OTPKEY1  0x11
#define BV_DCP_DBGSELECT_INDEX__OTPKEY2  0x12
#define BV_DCP_DBGSELECT_INDEX__OTPKEY3  0x13


////////////////////////////////////////////////////////////////////////////////
//// HW_DCP_DBGDATA - DCP Debug Data Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_dcp_dbgdata_t;
#endif


//
// constants & macros for entire HW_DCP_DBGDATA register
//

#define HW_DCP_DBGDATA_ADDR      (REGS_DCP_BASE + 0x00000410)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_DBGDATA           (*(volatile hw_dcp_dbgdata_t *) HW_DCP_DBGDATA_ADDR)
#define HW_DCP_DBGDATA_RD()      (HW_DCP_DBGDATA.U)
#endif


//
// constants & macros for individual HW_DCP_DBGDATA bitfields
//

//--- Register HW_DCP_DBGDATA, field DATA

#define BP_DCP_DBGDATA_DATA      0
#define BM_DCP_DBGDATA_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_DCP_DBGDATA_DATA(v)   ((reg32_t) v)
#else
#define BF_DCP_DBGDATA_DATA(v)   (v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DCP_PAGETABLE - DCP Page Table Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ENABLE  :  1;
        unsigned FLUSH   :  1;
        unsigned BASE    : 30;
    } B;
} hw_dcp_pagetable_t;
#endif


//
// constants & macros for entire HW_DCP_PAGETABLE register
//

#define HW_DCP_PAGETABLE_ADDR      (REGS_DCP_BASE + 0x00000420)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_PAGETABLE           (*(volatile hw_dcp_pagetable_t *) HW_DCP_PAGETABLE_ADDR)
#define HW_DCP_PAGETABLE_RD()      (HW_DCP_PAGETABLE.U)
#define HW_DCP_PAGETABLE_WR(v)     (HW_DCP_PAGETABLE.U = (v))
#define HW_DCP_PAGETABLE_SET(v)    (HW_DCP_PAGETABLE_WR(HW_DCP_PAGETABLE_RD() |  (v)))
#define HW_DCP_PAGETABLE_CLR(v)    (HW_DCP_PAGETABLE_WR(HW_DCP_PAGETABLE_RD() & ~(v)))
#define HW_DCP_PAGETABLE_TOG(v)    (HW_DCP_PAGETABLE_WR(HW_DCP_PAGETABLE_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DCP_PAGETABLE bitfields
//

//--- Register HW_DCP_PAGETABLE, field BASE

#define BP_DCP_PAGETABLE_BASE      2
#define BM_DCP_PAGETABLE_BASE      0xFFFFFFFC

#ifndef __LANGUAGE_ASM__
#define BF_DCP_PAGETABLE_BASE(v)   ((((reg32_t) v) << 2) & BM_DCP_PAGETABLE_BASE)
#else
#define BF_DCP_PAGETABLE_BASE(v)   (((v) << 2) & BM_DCP_PAGETABLE_BASE)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_DCP_PAGETABLE_BASE(v)   BF_CS1(DCP_PAGETABLE, BASE, v)
#endif

//--- Register HW_DCP_PAGETABLE, field FLUSH

#define BP_DCP_PAGETABLE_FLUSH      1
#define BM_DCP_PAGETABLE_FLUSH      0x00000002

#define BF_DCP_PAGETABLE_FLUSH(v)   (((v) << 1) & BM_DCP_PAGETABLE_FLUSH)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_PAGETABLE_FLUSH(v)   BF_CS1(DCP_PAGETABLE, FLUSH, v)
#endif

//--- Register HW_DCP_PAGETABLE, field ENABLE

#define BP_DCP_PAGETABLE_ENABLE      0
#define BM_DCP_PAGETABLE_ENABLE      0x00000001

#define BF_DCP_PAGETABLE_ENABLE(v)   (((v) << 0) & BM_DCP_PAGETABLE_ENABLE)

#ifndef __LANGUAGE_ASM__
#define BW_DCP_PAGETABLE_ENABLE(v)   BF_CS1(DCP_PAGETABLE, ENABLE, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DCP_VERSION - DCP Version Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg16_t  STEP;
        reg8_t   MINOR;
        reg8_t   MAJOR;
    } B;
} hw_dcp_version_t;
#endif


//
// constants & macros for entire HW_DCP_VERSION register
//

#define HW_DCP_VERSION_ADDR      (REGS_DCP_BASE + 0x00000430)

#ifndef __LANGUAGE_ASM__
#define HW_DCP_VERSION           (*(volatile hw_dcp_version_t *) HW_DCP_VERSION_ADDR)
#define HW_DCP_VERSION_RD()      (HW_DCP_VERSION.U)
#endif


//
// constants & macros for individual HW_DCP_VERSION bitfields
//

//--- Register HW_DCP_VERSION, field MAJOR

#define BP_DCP_VERSION_MAJOR      24
#define BM_DCP_VERSION_MAJOR      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_DCP_VERSION_MAJOR(v)   ((((reg32_t) v) << 24) & BM_DCP_VERSION_MAJOR)
#else
#define BF_DCP_VERSION_MAJOR(v)   (((v) << 24) & BM_DCP_VERSION_MAJOR)
#endif

//--- Register HW_DCP_VERSION, field MINOR

#define BP_DCP_VERSION_MINOR      16
#define BM_DCP_VERSION_MINOR      0x00FF0000

#define BF_DCP_VERSION_MINOR(v)   (((v) << 16) & BM_DCP_VERSION_MINOR)

//--- Register HW_DCP_VERSION, field STEP

#define BP_DCP_VERSION_STEP      0
#define BM_DCP_VERSION_STEP      0x0000FFFF

#define BF_DCP_VERSION_STEP(v)   (((v) << 0) & BM_DCP_VERSION_STEP)


#endif // _REGSDCP_H

////////////////////////////////////////////////////////////////////////////////
