/*
 * Copyright 2009 Freescale Semiconductor, Inc. All Rights Reserved.
 */

/*
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 */
////////////////////////////////////////////////////////////////////////////////
//
// WARNING!  THIS FILE IS AUTOMATICALLY GENERATED FROM XML.
//                DO NOT MODIFY THIS FILE DIRECTLY.
//
////////////////////////////////////////////////////////////////////////////////
//
// The following naming conventions are followed in this file.
//      XX_<module>_<regname>_<field>
//
// XX specifies the define / macro class
//      HW pertains to a register
//      BM indicates a Bit Mask
//      BF indicates a Bit Field macro
//
// <module> is the hardware module name which can be any of the following...
//      USB20 (Note when there is more than one copy of a given module, the
//      module name includes a number starting from 0 for the first instance
//      of that module)
//
// <regname> is the specific register within that module
//
// <field> is the specific bitfield within that <module>_<register>
//
// We also define the following...
//      hw_<module>_<regname>_t is typedef of anonymous union
//
////////////////////////////////////////////////////////////////////////////////

#ifndef _REGSDRAM_H
#define _REGSDRAM_H  1

#include "regs.h"

#ifndef REGS_DRAM_BASE
#define REGS_DRAM_BASE (REGS_BASE + 0x000E0000)
#endif

////////////////////////////////////////////////////////////////////////////////
//// HW_DRAM_CTL00 - DRAM Control Register 00
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ADDR_CMP_EN         :  1;
        unsigned RSVD1               :  7;
        unsigned AHB0_FIFO_TYPE_REG  :  1;
        unsigned RSVD2               :  7;
        unsigned AHB0_R_PRIORITY     :  1;
        unsigned RSVD3               :  7;
        unsigned AHB0_W_PRIORITY     :  1;
        unsigned RSVD4               :  7;
    } B;
} hw_dram_ctl00_t;
#endif


//
// constants & macros for entire HW_DRAM_CTL00 register
//

#define HW_DRAM_CTL00_ADDR      (REGS_DRAM_BASE + 0x00000000)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL00           (*(volatile hw_dram_ctl00_t *) HW_DRAM_CTL00_ADDR)
#define HW_DRAM_CTL00_RD()      (HW_DRAM_CTL00.U)
#define HW_DRAM_CTL00_WR(v)     (HW_DRAM_CTL00.U = (v))
#define HW_DRAM_CTL00_SET(v)    (HW_DRAM_CTL00_WR(HW_DRAM_CTL00_RD() |  (v)))
#define HW_DRAM_CTL00_CLR(v)    (HW_DRAM_CTL00_WR(HW_DRAM_CTL00_RD() & ~(v)))
#define HW_DRAM_CTL00_TOG(v)    (HW_DRAM_CTL00_WR(HW_DRAM_CTL00_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DRAM_CTL00 bitfields
//

//--- Register HW_DRAM_CTL00, field AHB0_W_PRIORITY

#define BP_DRAM_CTL00_AHB0_W_PRIORITY      24
#define BM_DRAM_CTL00_AHB0_W_PRIORITY      0x01000000

#define BF_DRAM_CTL00_AHB0_W_PRIORITY(v)   (((v) << 24) & BM_DRAM_CTL00_AHB0_W_PRIORITY)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL00_AHB0_W_PRIORITY(v)   BF_CS1(DRAM_CTL00, AHB0_W_PRIORITY, v)
#endif

//--- Register HW_DRAM_CTL00, field AHB0_R_PRIORITY

#define BP_DRAM_CTL00_AHB0_R_PRIORITY      16
#define BM_DRAM_CTL00_AHB0_R_PRIORITY      0x00010000

#define BF_DRAM_CTL00_AHB0_R_PRIORITY(v)   (((v) << 16) & BM_DRAM_CTL00_AHB0_R_PRIORITY)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL00_AHB0_R_PRIORITY(v)   BF_CS1(DRAM_CTL00, AHB0_R_PRIORITY, v)
#endif

//--- Register HW_DRAM_CTL00, field AHB0_FIFO_TYPE_REG

#define BP_DRAM_CTL00_AHB0_FIFO_TYPE_REG      8
#define BM_DRAM_CTL00_AHB0_FIFO_TYPE_REG      0x00000100

#define BF_DRAM_CTL00_AHB0_FIFO_TYPE_REG(v)   (((v) << 8) & BM_DRAM_CTL00_AHB0_FIFO_TYPE_REG)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL00_AHB0_FIFO_TYPE_REG(v)   BF_CS1(DRAM_CTL00, AHB0_FIFO_TYPE_REG, v)
#endif

//--- Register HW_DRAM_CTL00, field ADDR_CMP_EN

#define BP_DRAM_CTL00_ADDR_CMP_EN      0
#define BM_DRAM_CTL00_ADDR_CMP_EN      0x00000001

#define BF_DRAM_CTL00_ADDR_CMP_EN(v)   (((v) << 0) & BM_DRAM_CTL00_ADDR_CMP_EN)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL00_ADDR_CMP_EN(v)   BF_CS1(DRAM_CTL00, ADDR_CMP_EN, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DRAM_CTL01 - DRAM Control Register 01
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned AHB1_FIFO_TYPE_REG  :  1;
        unsigned RSVD1               :  7;
        unsigned AHB1_R_PRIORITY     :  1;
        unsigned RSVD2               :  7;
        unsigned AHB1_W_PRIORITY     :  1;
        unsigned RSVD3               :  7;
        unsigned AHB2_FIFO_TYPE_REG  :  1;
        unsigned RSVD4               :  7;
    } B;
} hw_dram_ctl01_t;
#endif


//
// constants & macros for entire HW_DRAM_CTL01 register
//

#define HW_DRAM_CTL01_ADDR      (REGS_DRAM_BASE + 0x00000004)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL01           (*(volatile hw_dram_ctl01_t *) HW_DRAM_CTL01_ADDR)
#define HW_DRAM_CTL01_RD()      (HW_DRAM_CTL01.U)
#define HW_DRAM_CTL01_WR(v)     (HW_DRAM_CTL01.U = (v))
#define HW_DRAM_CTL01_SET(v)    (HW_DRAM_CTL01_WR(HW_DRAM_CTL01_RD() |  (v)))
#define HW_DRAM_CTL01_CLR(v)    (HW_DRAM_CTL01_WR(HW_DRAM_CTL01_RD() & ~(v)))
#define HW_DRAM_CTL01_TOG(v)    (HW_DRAM_CTL01_WR(HW_DRAM_CTL01_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DRAM_CTL01 bitfields
//

//--- Register HW_DRAM_CTL01, field AHB2_FIFO_TYPE_REG

#define BP_DRAM_CTL01_AHB2_FIFO_TYPE_REG      24
#define BM_DRAM_CTL01_AHB2_FIFO_TYPE_REG      0x01000000

#define BF_DRAM_CTL01_AHB2_FIFO_TYPE_REG(v)   (((v) << 24) & BM_DRAM_CTL01_AHB2_FIFO_TYPE_REG)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL01_AHB2_FIFO_TYPE_REG(v)   BF_CS1(DRAM_CTL01, AHB2_FIFO_TYPE_REG, v)
#endif

//--- Register HW_DRAM_CTL01, field AHB1_W_PRIORITY

#define BP_DRAM_CTL01_AHB1_W_PRIORITY      16
#define BM_DRAM_CTL01_AHB1_W_PRIORITY      0x00010000

#define BF_DRAM_CTL01_AHB1_W_PRIORITY(v)   (((v) << 16) & BM_DRAM_CTL01_AHB1_W_PRIORITY)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL01_AHB1_W_PRIORITY(v)   BF_CS1(DRAM_CTL01, AHB1_W_PRIORITY, v)
#endif

//--- Register HW_DRAM_CTL01, field AHB1_R_PRIORITY

#define BP_DRAM_CTL01_AHB1_R_PRIORITY      8
#define BM_DRAM_CTL01_AHB1_R_PRIORITY      0x00000100

#define BF_DRAM_CTL01_AHB1_R_PRIORITY(v)   (((v) << 8) & BM_DRAM_CTL01_AHB1_R_PRIORITY)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL01_AHB1_R_PRIORITY(v)   BF_CS1(DRAM_CTL01, AHB1_R_PRIORITY, v)
#endif

//--- Register HW_DRAM_CTL01, field AHB1_FIFO_TYPE_REG

#define BP_DRAM_CTL01_AHB1_FIFO_TYPE_REG      0
#define BM_DRAM_CTL01_AHB1_FIFO_TYPE_REG      0x00000001

#define BF_DRAM_CTL01_AHB1_FIFO_TYPE_REG(v)   (((v) << 0) & BM_DRAM_CTL01_AHB1_FIFO_TYPE_REG)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL01_AHB1_FIFO_TYPE_REG(v)   BF_CS1(DRAM_CTL01, AHB1_FIFO_TYPE_REG, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DRAM_CTL02 - DRAM Control Register 02
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned AHB2_R_PRIORITY     :  1;
        unsigned RSVD1               :  7;
        unsigned AHB2_W_PRIORITY     :  1;
        unsigned RSVD2               :  7;
        unsigned AHB3_FIFO_TYPE_REG  :  1;
        unsigned RSVD3               :  7;
        unsigned AHB3_R_PRIORITY     :  1;
        unsigned RSVD4               :  7;
    } B;
} hw_dram_ctl02_t;
#endif


//
// constants & macros for entire HW_DRAM_CTL02 register
//

#define HW_DRAM_CTL02_ADDR      (REGS_DRAM_BASE + 0x00000008)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL02           (*(volatile hw_dram_ctl02_t *) HW_DRAM_CTL02_ADDR)
#define HW_DRAM_CTL02_RD()      (HW_DRAM_CTL02.U)
#define HW_DRAM_CTL02_WR(v)     (HW_DRAM_CTL02.U = (v))
#define HW_DRAM_CTL02_SET(v)    (HW_DRAM_CTL02_WR(HW_DRAM_CTL02_RD() |  (v)))
#define HW_DRAM_CTL02_CLR(v)    (HW_DRAM_CTL02_WR(HW_DRAM_CTL02_RD() & ~(v)))
#define HW_DRAM_CTL02_TOG(v)    (HW_DRAM_CTL02_WR(HW_DRAM_CTL02_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DRAM_CTL02 bitfields
//

//--- Register HW_DRAM_CTL02, field AHB3_R_PRIORITY

#define BP_DRAM_CTL02_AHB3_R_PRIORITY      24
#define BM_DRAM_CTL02_AHB3_R_PRIORITY      0x01000000

#define BF_DRAM_CTL02_AHB3_R_PRIORITY(v)   (((v) << 24) & BM_DRAM_CTL02_AHB3_R_PRIORITY)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL02_AHB3_R_PRIORITY(v)   BF_CS1(DRAM_CTL02, AHB3_R_PRIORITY, v)
#endif

//--- Register HW_DRAM_CTL02, field AHB3_FIFO_TYPE_REG

#define BP_DRAM_CTL02_AHB3_FIFO_TYPE_REG      16
#define BM_DRAM_CTL02_AHB3_FIFO_TYPE_REG      0x00010000

#define BF_DRAM_CTL02_AHB3_FIFO_TYPE_REG(v)   (((v) << 16) & BM_DRAM_CTL02_AHB3_FIFO_TYPE_REG)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL02_AHB3_FIFO_TYPE_REG(v)   BF_CS1(DRAM_CTL02, AHB3_FIFO_TYPE_REG, v)
#endif

//--- Register HW_DRAM_CTL02, field AHB2_W_PRIORITY

#define BP_DRAM_CTL02_AHB2_W_PRIORITY      8
#define BM_DRAM_CTL02_AHB2_W_PRIORITY      0x00000100

#define BF_DRAM_CTL02_AHB2_W_PRIORITY(v)   (((v) << 8) & BM_DRAM_CTL02_AHB2_W_PRIORITY)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL02_AHB2_W_PRIORITY(v)   BF_CS1(DRAM_CTL02, AHB2_W_PRIORITY, v)
#endif

//--- Register HW_DRAM_CTL02, field AHB2_R_PRIORITY

#define BP_DRAM_CTL02_AHB2_R_PRIORITY      0
#define BM_DRAM_CTL02_AHB2_R_PRIORITY      0x00000001

#define BF_DRAM_CTL02_AHB2_R_PRIORITY(v)   (((v) << 0) & BM_DRAM_CTL02_AHB2_R_PRIORITY)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL02_AHB2_R_PRIORITY(v)   BF_CS1(DRAM_CTL02, AHB2_R_PRIORITY, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DRAM_CTL03 - DRAM Control Register 03
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned AHB3_W_PRIORITY    :  1;
        unsigned RSVD1              :  7;
        unsigned AP                 :  1;
        unsigned RSVD2              :  7;
        unsigned AREFRESH           :  1;
        unsigned RSVD3              :  7;
        unsigned AUTO_REFRESH_MODE  :  1;
        unsigned RSVD4              :  7;
    } B;
} hw_dram_ctl03_t;
#endif


//
// constants & macros for entire HW_DRAM_CTL03 register
//

#define HW_DRAM_CTL03_ADDR      (REGS_DRAM_BASE + 0x0000000C)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL03           (*(volatile hw_dram_ctl03_t *) HW_DRAM_CTL03_ADDR)
#define HW_DRAM_CTL03_RD()      (HW_DRAM_CTL03.U)
#define HW_DRAM_CTL03_WR(v)     (HW_DRAM_CTL03.U = (v))
#define HW_DRAM_CTL03_SET(v)    (HW_DRAM_CTL03_WR(HW_DRAM_CTL03_RD() |  (v)))
#define HW_DRAM_CTL03_CLR(v)    (HW_DRAM_CTL03_WR(HW_DRAM_CTL03_RD() & ~(v)))
#define HW_DRAM_CTL03_TOG(v)    (HW_DRAM_CTL03_WR(HW_DRAM_CTL03_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DRAM_CTL03 bitfields
//

//--- Register HW_DRAM_CTL03, field AUTO_REFRESH_MODE

#define BP_DRAM_CTL03_AUTO_REFRESH_MODE      24
#define BM_DRAM_CTL03_AUTO_REFRESH_MODE      0x01000000

#define BF_DRAM_CTL03_AUTO_REFRESH_MODE(v)   (((v) << 24) & BM_DRAM_CTL03_AUTO_REFRESH_MODE)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL03_AUTO_REFRESH_MODE(v)   BF_CS1(DRAM_CTL03, AUTO_REFRESH_MODE, v)
#endif

//--- Register HW_DRAM_CTL03, field AREFRESH

#define BP_DRAM_CTL03_AREFRESH      16
#define BM_DRAM_CTL03_AREFRESH      0x00010000

#define BF_DRAM_CTL03_AREFRESH(v)   (((v) << 16) & BM_DRAM_CTL03_AREFRESH)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL03_AREFRESH(v)   BF_CS1(DRAM_CTL03, AREFRESH, v)
#endif

//--- Register HW_DRAM_CTL03, field AP

#define BP_DRAM_CTL03_AP      8
#define BM_DRAM_CTL03_AP      0x00000100

#define BF_DRAM_CTL03_AP(v)   (((v) << 8) & BM_DRAM_CTL03_AP)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL03_AP(v)   BF_CS1(DRAM_CTL03, AP, v)
#endif

//--- Register HW_DRAM_CTL03, field AHB3_W_PRIORITY

#define BP_DRAM_CTL03_AHB3_W_PRIORITY      0
#define BM_DRAM_CTL03_AHB3_W_PRIORITY      0x00000001

#define BF_DRAM_CTL03_AHB3_W_PRIORITY(v)   (((v) << 0) & BM_DRAM_CTL03_AHB3_W_PRIORITY)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL03_AHB3_W_PRIORITY(v)   BF_CS1(DRAM_CTL03, AHB3_W_PRIORITY, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DRAM_CTL04 - DRAM Control Register 04
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BANK_SPLIT_EN    :  1;
        unsigned RSVD1            :  7;
        unsigned CONCURRENTAP     :  1;
        unsigned RSVD2            :  7;
        unsigned DLLLOCKREG       :  1;
        unsigned RSVD3            :  7;
        unsigned DLL_BYPASS_MODE  :  1;
        unsigned RSVD4            :  7;
    } B;
} hw_dram_ctl04_t;
#endif


//
// constants & macros for entire HW_DRAM_CTL04 register
//

#define HW_DRAM_CTL04_ADDR      (REGS_DRAM_BASE + 0x00000010)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL04           (*(volatile hw_dram_ctl04_t *) HW_DRAM_CTL04_ADDR)
#define HW_DRAM_CTL04_RD()      (HW_DRAM_CTL04.U)
#define HW_DRAM_CTL04_WR(v)     (HW_DRAM_CTL04.U = (v))
#define HW_DRAM_CTL04_SET(v)    (HW_DRAM_CTL04_WR(HW_DRAM_CTL04_RD() |  (v)))
#define HW_DRAM_CTL04_CLR(v)    (HW_DRAM_CTL04_WR(HW_DRAM_CTL04_RD() & ~(v)))
#define HW_DRAM_CTL04_TOG(v)    (HW_DRAM_CTL04_WR(HW_DRAM_CTL04_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DRAM_CTL04 bitfields
//

//--- Register HW_DRAM_CTL04, field DLL_BYPASS_MODE

#define BP_DRAM_CTL04_DLL_BYPASS_MODE      24
#define BM_DRAM_CTL04_DLL_BYPASS_MODE      0x01000000

#define BF_DRAM_CTL04_DLL_BYPASS_MODE(v)   (((v) << 24) & BM_DRAM_CTL04_DLL_BYPASS_MODE)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL04_DLL_BYPASS_MODE(v)   BF_CS1(DRAM_CTL04, DLL_BYPASS_MODE, v)
#endif

//--- Register HW_DRAM_CTL04, field DLLLOCKREG

#define BP_DRAM_CTL04_DLLLOCKREG      16
#define BM_DRAM_CTL04_DLLLOCKREG      0x00010000

#define BF_DRAM_CTL04_DLLLOCKREG(v)   (((v) << 16) & BM_DRAM_CTL04_DLLLOCKREG)

//--- Register HW_DRAM_CTL04, field CONCURRENTAP

#define BP_DRAM_CTL04_CONCURRENTAP      8
#define BM_DRAM_CTL04_CONCURRENTAP      0x00000100

#define BF_DRAM_CTL04_CONCURRENTAP(v)   (((v) << 8) & BM_DRAM_CTL04_CONCURRENTAP)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL04_CONCURRENTAP(v)   BF_CS1(DRAM_CTL04, CONCURRENTAP, v)
#endif

//--- Register HW_DRAM_CTL04, field BANK_SPLIT_EN

#define BP_DRAM_CTL04_BANK_SPLIT_EN      0
#define BM_DRAM_CTL04_BANK_SPLIT_EN      0x00000001

#define BF_DRAM_CTL04_BANK_SPLIT_EN(v)   (((v) << 0) & BM_DRAM_CTL04_BANK_SPLIT_EN)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL04_BANK_SPLIT_EN(v)   BF_CS1(DRAM_CTL04, BANK_SPLIT_EN, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DRAM_CTL05 - DRAM Control Register 05
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned EN_LOWPOWER_MODE  :  1;
        unsigned RSVD1             :  7;
        unsigned FAST_WRITE        :  1;
        unsigned RSVD2             :  7;
        unsigned INTRPTAPBURST     :  1;
        unsigned RSVD3             :  7;
        unsigned INTRPTREADA       :  1;
        unsigned RSVD4             :  7;
    } B;
} hw_dram_ctl05_t;
#endif


//
// constants & macros for entire HW_DRAM_CTL05 register
//

#define HW_DRAM_CTL05_ADDR      (REGS_DRAM_BASE + 0x00000014)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL05           (*(volatile hw_dram_ctl05_t *) HW_DRAM_CTL05_ADDR)
#define HW_DRAM_CTL05_RD()      (HW_DRAM_CTL05.U)
#define HW_DRAM_CTL05_WR(v)     (HW_DRAM_CTL05.U = (v))
#define HW_DRAM_CTL05_SET(v)    (HW_DRAM_CTL05_WR(HW_DRAM_CTL05_RD() |  (v)))
#define HW_DRAM_CTL05_CLR(v)    (HW_DRAM_CTL05_WR(HW_DRAM_CTL05_RD() & ~(v)))
#define HW_DRAM_CTL05_TOG(v)    (HW_DRAM_CTL05_WR(HW_DRAM_CTL05_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DRAM_CTL05 bitfields
//

//--- Register HW_DRAM_CTL05, field INTRPTREADA

#define BP_DRAM_CTL05_INTRPTREADA      24
#define BM_DRAM_CTL05_INTRPTREADA      0x01000000

#define BF_DRAM_CTL05_INTRPTREADA(v)   (((v) << 24) & BM_DRAM_CTL05_INTRPTREADA)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL05_INTRPTREADA(v)   BF_CS1(DRAM_CTL05, INTRPTREADA, v)
#endif

//--- Register HW_DRAM_CTL05, field INTRPTAPBURST

#define BP_DRAM_CTL05_INTRPTAPBURST      16
#define BM_DRAM_CTL05_INTRPTAPBURST      0x00010000

#define BF_DRAM_CTL05_INTRPTAPBURST(v)   (((v) << 16) & BM_DRAM_CTL05_INTRPTAPBURST)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL05_INTRPTAPBURST(v)   BF_CS1(DRAM_CTL05, INTRPTAPBURST, v)
#endif

//--- Register HW_DRAM_CTL05, field FAST_WRITE

#define BP_DRAM_CTL05_FAST_WRITE      8
#define BM_DRAM_CTL05_FAST_WRITE      0x00000100

#define BF_DRAM_CTL05_FAST_WRITE(v)   (((v) << 8) & BM_DRAM_CTL05_FAST_WRITE)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL05_FAST_WRITE(v)   BF_CS1(DRAM_CTL05, FAST_WRITE, v)
#endif

//--- Register HW_DRAM_CTL05, field EN_LOWPOWER_MODE

#define BP_DRAM_CTL05_EN_LOWPOWER_MODE      0
#define BM_DRAM_CTL05_EN_LOWPOWER_MODE      0x00000001

#define BF_DRAM_CTL05_EN_LOWPOWER_MODE(v)   (((v) << 0) & BM_DRAM_CTL05_EN_LOWPOWER_MODE)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL05_EN_LOWPOWER_MODE(v)   BF_CS1(DRAM_CTL05, EN_LOWPOWER_MODE, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DRAM_CTL06 - DRAM Control Register 06
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned INTRPTWRITEA  :  1;
        unsigned RSVD1         :  7;
        unsigned NO_CMD_INIT   :  1;
        unsigned RSVD2         :  7;
        unsigned PLACEMENT_EN  :  1;
        unsigned RSVD3         :  7;
        unsigned POWER_DOWN    :  1;
        unsigned RSVD4         :  7;
    } B;
} hw_dram_ctl06_t;
#endif


//
// constants & macros for entire HW_DRAM_CTL06 register
//

#define HW_DRAM_CTL06_ADDR      (REGS_DRAM_BASE + 0x00000018)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL06           (*(volatile hw_dram_ctl06_t *) HW_DRAM_CTL06_ADDR)
#define HW_DRAM_CTL06_RD()      (HW_DRAM_CTL06.U)
#define HW_DRAM_CTL06_WR(v)     (HW_DRAM_CTL06.U = (v))
#define HW_DRAM_CTL06_SET(v)    (HW_DRAM_CTL06_WR(HW_DRAM_CTL06_RD() |  (v)))
#define HW_DRAM_CTL06_CLR(v)    (HW_DRAM_CTL06_WR(HW_DRAM_CTL06_RD() & ~(v)))
#define HW_DRAM_CTL06_TOG(v)    (HW_DRAM_CTL06_WR(HW_DRAM_CTL06_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DRAM_CTL06 bitfields
//

//--- Register HW_DRAM_CTL06, field POWER_DOWN

#define BP_DRAM_CTL06_POWER_DOWN      24
#define BM_DRAM_CTL06_POWER_DOWN      0x01000000

#define BF_DRAM_CTL06_POWER_DOWN(v)   (((v) << 24) & BM_DRAM_CTL06_POWER_DOWN)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL06_POWER_DOWN(v)   BF_CS1(DRAM_CTL06, POWER_DOWN, v)
#endif

//--- Register HW_DRAM_CTL06, field PLACEMENT_EN

#define BP_DRAM_CTL06_PLACEMENT_EN      16
#define BM_DRAM_CTL06_PLACEMENT_EN      0x00010000

#define BF_DRAM_CTL06_PLACEMENT_EN(v)   (((v) << 16) & BM_DRAM_CTL06_PLACEMENT_EN)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL06_PLACEMENT_EN(v)   BF_CS1(DRAM_CTL06, PLACEMENT_EN, v)
#endif

//--- Register HW_DRAM_CTL06, field NO_CMD_INIT

#define BP_DRAM_CTL06_NO_CMD_INIT      8
#define BM_DRAM_CTL06_NO_CMD_INIT      0x00000100

#define BF_DRAM_CTL06_NO_CMD_INIT(v)   (((v) << 8) & BM_DRAM_CTL06_NO_CMD_INIT)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL06_NO_CMD_INIT(v)   BF_CS1(DRAM_CTL06, NO_CMD_INIT, v)
#endif

//--- Register HW_DRAM_CTL06, field INTRPTWRITEA

#define BP_DRAM_CTL06_INTRPTWRITEA      0
#define BM_DRAM_CTL06_INTRPTWRITEA      0x00000001

#define BF_DRAM_CTL06_INTRPTWRITEA(v)   (((v) << 0) & BM_DRAM_CTL06_INTRPTWRITEA)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL06_INTRPTWRITEA(v)   BF_CS1(DRAM_CTL06, INTRPTWRITEA, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DRAM_CTL07 - DRAM Control Register 07
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PRIORITY_EN      :  1;
        unsigned RSVD1            :  7;
        unsigned RD2RD_TURN       :  1;
        unsigned RSVD2            :  7;
        unsigned REG_DIMM_ENABLE  :  1;
        unsigned RSVD3            :  7;
        unsigned RW_SAME_EN       :  1;
        unsigned RSVD4            :  7;
    } B;
} hw_dram_ctl07_t;
#endif


//
// constants & macros for entire HW_DRAM_CTL07 register
//

#define HW_DRAM_CTL07_ADDR      (REGS_DRAM_BASE + 0x0000001C)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL07           (*(volatile hw_dram_ctl07_t *) HW_DRAM_CTL07_ADDR)
#define HW_DRAM_CTL07_RD()      (HW_DRAM_CTL07.U)
#define HW_DRAM_CTL07_WR(v)     (HW_DRAM_CTL07.U = (v))
#define HW_DRAM_CTL07_SET(v)    (HW_DRAM_CTL07_WR(HW_DRAM_CTL07_RD() |  (v)))
#define HW_DRAM_CTL07_CLR(v)    (HW_DRAM_CTL07_WR(HW_DRAM_CTL07_RD() & ~(v)))
#define HW_DRAM_CTL07_TOG(v)    (HW_DRAM_CTL07_WR(HW_DRAM_CTL07_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DRAM_CTL07 bitfields
//

//--- Register HW_DRAM_CTL07, field RW_SAME_EN

#define BP_DRAM_CTL07_RW_SAME_EN      24
#define BM_DRAM_CTL07_RW_SAME_EN      0x01000000

#define BF_DRAM_CTL07_RW_SAME_EN(v)   (((v) << 24) & BM_DRAM_CTL07_RW_SAME_EN)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL07_RW_SAME_EN(v)   BF_CS1(DRAM_CTL07, RW_SAME_EN, v)
#endif

//--- Register HW_DRAM_CTL07, field REG_DIMM_ENABLE

#define BP_DRAM_CTL07_REG_DIMM_ENABLE      16
#define BM_DRAM_CTL07_REG_DIMM_ENABLE      0x00010000

#define BF_DRAM_CTL07_REG_DIMM_ENABLE(v)   (((v) << 16) & BM_DRAM_CTL07_REG_DIMM_ENABLE)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL07_REG_DIMM_ENABLE(v)   BF_CS1(DRAM_CTL07, REG_DIMM_ENABLE, v)
#endif

//--- Register HW_DRAM_CTL07, field RD2RD_TURN

#define BP_DRAM_CTL07_RD2RD_TURN      8
#define BM_DRAM_CTL07_RD2RD_TURN      0x00000100

#define BF_DRAM_CTL07_RD2RD_TURN(v)   (((v) << 8) & BM_DRAM_CTL07_RD2RD_TURN)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL07_RD2RD_TURN(v)   BF_CS1(DRAM_CTL07, RD2RD_TURN, v)
#endif

//--- Register HW_DRAM_CTL07, field PRIORITY_EN

#define BP_DRAM_CTL07_PRIORITY_EN      0
#define BM_DRAM_CTL07_PRIORITY_EN      0x00000001

#define BF_DRAM_CTL07_PRIORITY_EN(v)   (((v) << 0) & BM_DRAM_CTL07_PRIORITY_EN)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL07_PRIORITY_EN(v)   BF_CS1(DRAM_CTL07, PRIORITY_EN, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DRAM_CTL08 - DRAM Control Register 08
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned SDR_MODE      :  1;
        unsigned RSVD1         :  7;
        unsigned SREFRESH      :  1;
        unsigned RSVD2         :  7;
        unsigned START         :  1;
        unsigned RSVD3         :  7;
        unsigned TRAS_LOCKOUT  :  1;
        unsigned RSVD4         :  7;
    } B;
} hw_dram_ctl08_t;
#endif


//
// constants & macros for entire HW_DRAM_CTL08 register
//

#define HW_DRAM_CTL08_ADDR      (REGS_DRAM_BASE + 0x00000020)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL08           (*(volatile hw_dram_ctl08_t *) HW_DRAM_CTL08_ADDR)
#define HW_DRAM_CTL08_RD()      (HW_DRAM_CTL08.U)
#define HW_DRAM_CTL08_WR(v)     (HW_DRAM_CTL08.U = (v))
#define HW_DRAM_CTL08_SET(v)    (HW_DRAM_CTL08_WR(HW_DRAM_CTL08_RD() |  (v)))
#define HW_DRAM_CTL08_CLR(v)    (HW_DRAM_CTL08_WR(HW_DRAM_CTL08_RD() & ~(v)))
#define HW_DRAM_CTL08_TOG(v)    (HW_DRAM_CTL08_WR(HW_DRAM_CTL08_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DRAM_CTL08 bitfields
//

//--- Register HW_DRAM_CTL08, field TRAS_LOCKOUT

#define BP_DRAM_CTL08_TRAS_LOCKOUT      24
#define BM_DRAM_CTL08_TRAS_LOCKOUT      0x01000000

#define BF_DRAM_CTL08_TRAS_LOCKOUT(v)   (((v) << 24) & BM_DRAM_CTL08_TRAS_LOCKOUT)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL08_TRAS_LOCKOUT(v)   BF_CS1(DRAM_CTL08, TRAS_LOCKOUT, v)
#endif

//--- Register HW_DRAM_CTL08, field START

#define BP_DRAM_CTL08_START      16
#define BM_DRAM_CTL08_START      0x00010000

#define BF_DRAM_CTL08_START(v)   (((v) << 16) & BM_DRAM_CTL08_START)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL08_START(v)   BF_CS1(DRAM_CTL08, START, v)
#endif

//--- Register HW_DRAM_CTL08, field SREFRESH

#define BP_DRAM_CTL08_SREFRESH      8
#define BM_DRAM_CTL08_SREFRESH      0x00000100

#define BF_DRAM_CTL08_SREFRESH(v)   (((v) << 8) & BM_DRAM_CTL08_SREFRESH)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL08_SREFRESH(v)   BF_CS1(DRAM_CTL08, SREFRESH, v)
#endif

//--- Register HW_DRAM_CTL08, field SDR_MODE

#define BP_DRAM_CTL08_SDR_MODE      0
#define BM_DRAM_CTL08_SDR_MODE      0x00000001

#define BF_DRAM_CTL08_SDR_MODE(v)   (((v) << 0) & BM_DRAM_CTL08_SDR_MODE)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL08_SDR_MODE(v)   BF_CS1(DRAM_CTL08, SDR_MODE, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DRAM_CTL09 - DRAM Control Register 09
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned WRITEINTERP             :  1;
        unsigned RSVD1                   :  7;
        unsigned WRITE_MODEREG           :  1;
        unsigned RSVD2                   :  7;
        unsigned OUT_OF_RANGE_SOURCE_ID  :  2;
        unsigned RSVD3                   :  6;
        unsigned OUT_OF_RANGE_TYPE       :  2;
        unsigned RSVD4                   :  6;
    } B;
} hw_dram_ctl09_t;
#endif


//
// constants & macros for entire HW_DRAM_CTL09 register
//

#define HW_DRAM_CTL09_ADDR      (REGS_DRAM_BASE + 0x00000024)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL09           (*(volatile hw_dram_ctl09_t *) HW_DRAM_CTL09_ADDR)
#define HW_DRAM_CTL09_RD()      (HW_DRAM_CTL09.U)
#define HW_DRAM_CTL09_WR(v)     (HW_DRAM_CTL09.U = (v))
#define HW_DRAM_CTL09_SET(v)    (HW_DRAM_CTL09_WR(HW_DRAM_CTL09_RD() |  (v)))
#define HW_DRAM_CTL09_CLR(v)    (HW_DRAM_CTL09_WR(HW_DRAM_CTL09_RD() & ~(v)))
#define HW_DRAM_CTL09_TOG(v)    (HW_DRAM_CTL09_WR(HW_DRAM_CTL09_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DRAM_CTL09 bitfields
//

//--- Register HW_DRAM_CTL09, field OUT_OF_RANGE_TYPE

#define BP_DRAM_CTL09_OUT_OF_RANGE_TYPE      24
#define BM_DRAM_CTL09_OUT_OF_RANGE_TYPE      0x03000000

#define BF_DRAM_CTL09_OUT_OF_RANGE_TYPE(v)   (((v) << 24) & BM_DRAM_CTL09_OUT_OF_RANGE_TYPE)

//--- Register HW_DRAM_CTL09, field OUT_OF_RANGE_SOURCE_ID

#define BP_DRAM_CTL09_OUT_OF_RANGE_SOURCE_ID      16
#define BM_DRAM_CTL09_OUT_OF_RANGE_SOURCE_ID      0x00030000

#define BF_DRAM_CTL09_OUT_OF_RANGE_SOURCE_ID(v)   (((v) << 16) & BM_DRAM_CTL09_OUT_OF_RANGE_SOURCE_ID)

//--- Register HW_DRAM_CTL09, field WRITE_MODEREG

#define BP_DRAM_CTL09_WRITE_MODEREG      8
#define BM_DRAM_CTL09_WRITE_MODEREG      0x00000100

#define BF_DRAM_CTL09_WRITE_MODEREG(v)   (((v) << 8) & BM_DRAM_CTL09_WRITE_MODEREG)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL09_WRITE_MODEREG(v)   BF_CS1(DRAM_CTL09, WRITE_MODEREG, v)
#endif

//--- Register HW_DRAM_CTL09, field WRITEINTERP

#define BP_DRAM_CTL09_WRITEINTERP      0
#define BM_DRAM_CTL09_WRITEINTERP      0x00000001

#define BF_DRAM_CTL09_WRITEINTERP(v)   (((v) << 0) & BM_DRAM_CTL09_WRITEINTERP)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL09_WRITEINTERP(v)   BF_CS1(DRAM_CTL09, WRITEINTERP, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DRAM_CTL10 - DRAM Control Register 10
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned Q_FULLNESS  :  2;
        unsigned RSVD1       :  6;
        unsigned TEMRS       :  2;
        unsigned RSVD2       :  6;
        unsigned ADDR_PINS   :  3;
        unsigned RSVD3       :  5;
        unsigned AGE_COUNT   :  3;
        unsigned RSVD4       :  5;
    } B;
} hw_dram_ctl10_t;
#endif


//
// constants & macros for entire HW_DRAM_CTL10 register
//

#define HW_DRAM_CTL10_ADDR      (REGS_DRAM_BASE + 0x00000028)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL10           (*(volatile hw_dram_ctl10_t *) HW_DRAM_CTL10_ADDR)
#define HW_DRAM_CTL10_RD()      (HW_DRAM_CTL10.U)
#define HW_DRAM_CTL10_WR(v)     (HW_DRAM_CTL10.U = (v))
#define HW_DRAM_CTL10_SET(v)    (HW_DRAM_CTL10_WR(HW_DRAM_CTL10_RD() |  (v)))
#define HW_DRAM_CTL10_CLR(v)    (HW_DRAM_CTL10_WR(HW_DRAM_CTL10_RD() & ~(v)))
#define HW_DRAM_CTL10_TOG(v)    (HW_DRAM_CTL10_WR(HW_DRAM_CTL10_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DRAM_CTL10 bitfields
//

//--- Register HW_DRAM_CTL10, field AGE_COUNT

#define BP_DRAM_CTL10_AGE_COUNT      24
#define BM_DRAM_CTL10_AGE_COUNT      0x07000000

#define BF_DRAM_CTL10_AGE_COUNT(v)   (((v) << 24) & BM_DRAM_CTL10_AGE_COUNT)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL10_AGE_COUNT(v)   BF_CS1(DRAM_CTL10, AGE_COUNT, v)
#endif

//--- Register HW_DRAM_CTL10, field ADDR_PINS

#define BP_DRAM_CTL10_ADDR_PINS      16
#define BM_DRAM_CTL10_ADDR_PINS      0x00070000

#define BF_DRAM_CTL10_ADDR_PINS(v)   (((v) << 16) & BM_DRAM_CTL10_ADDR_PINS)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL10_ADDR_PINS(v)   BF_CS1(DRAM_CTL10, ADDR_PINS, v)
#endif

//--- Register HW_DRAM_CTL10, field TEMRS

#define BP_DRAM_CTL10_TEMRS      8
#define BM_DRAM_CTL10_TEMRS      0x00000300

#define BF_DRAM_CTL10_TEMRS(v)   (((v) << 8) & BM_DRAM_CTL10_TEMRS)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL10_TEMRS(v)   BF_CS1(DRAM_CTL10, TEMRS, v)
#endif

//--- Register HW_DRAM_CTL10, field Q_FULLNESS

#define BP_DRAM_CTL10_Q_FULLNESS      0
#define BM_DRAM_CTL10_Q_FULLNESS      0x00000003

#define BF_DRAM_CTL10_Q_FULLNESS(v)   (((v) << 0) & BM_DRAM_CTL10_Q_FULLNESS)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL10_Q_FULLNESS(v)   BF_CS1(DRAM_CTL10, Q_FULLNESS, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DRAM_CTL11 - DRAM Control Register 11
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned CASLAT             :  3;
        unsigned RSVD1              :  5;
        unsigned COLUMN_SIZE        :  3;
        unsigned RSVD2              :  5;
        unsigned COMMAND_AGE_COUNT  :  3;
        unsigned RSVD3              :  5;
        unsigned MAX_CS_REG         :  3;
        unsigned RSVD4              :  5;
    } B;
} hw_dram_ctl11_t;
#endif


//
// constants & macros for entire HW_DRAM_CTL11 register
//

#define HW_DRAM_CTL11_ADDR      (REGS_DRAM_BASE + 0x0000002C)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL11           (*(volatile hw_dram_ctl11_t *) HW_DRAM_CTL11_ADDR)
#define HW_DRAM_CTL11_RD()      (HW_DRAM_CTL11.U)
#define HW_DRAM_CTL11_WR(v)     (HW_DRAM_CTL11.U = (v))
#define HW_DRAM_CTL11_SET(v)    (HW_DRAM_CTL11_WR(HW_DRAM_CTL11_RD() |  (v)))
#define HW_DRAM_CTL11_CLR(v)    (HW_DRAM_CTL11_WR(HW_DRAM_CTL11_RD() & ~(v)))
#define HW_DRAM_CTL11_TOG(v)    (HW_DRAM_CTL11_WR(HW_DRAM_CTL11_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DRAM_CTL11 bitfields
//

//--- Register HW_DRAM_CTL11, field MAX_CS_REG

#define BP_DRAM_CTL11_MAX_CS_REG      24
#define BM_DRAM_CTL11_MAX_CS_REG      0x07000000

#define BF_DRAM_CTL11_MAX_CS_REG(v)   (((v) << 24) & BM_DRAM_CTL11_MAX_CS_REG)

//--- Register HW_DRAM_CTL11, field COMMAND_AGE_COUNT

#define BP_DRAM_CTL11_COMMAND_AGE_COUNT      16
#define BM_DRAM_CTL11_COMMAND_AGE_COUNT      0x00070000

#define BF_DRAM_CTL11_COMMAND_AGE_COUNT(v)   (((v) << 16) & BM_DRAM_CTL11_COMMAND_AGE_COUNT)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL11_COMMAND_AGE_COUNT(v)   BF_CS1(DRAM_CTL11, COMMAND_AGE_COUNT, v)
#endif

//--- Register HW_DRAM_CTL11, field COLUMN_SIZE

#define BP_DRAM_CTL11_COLUMN_SIZE      8
#define BM_DRAM_CTL11_COLUMN_SIZE      0x00000700

#define BF_DRAM_CTL11_COLUMN_SIZE(v)   (((v) << 8) & BM_DRAM_CTL11_COLUMN_SIZE)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL11_COLUMN_SIZE(v)   BF_CS1(DRAM_CTL11, COLUMN_SIZE, v)
#endif

//--- Register HW_DRAM_CTL11, field CASLAT

#define BP_DRAM_CTL11_CASLAT      0
#define BM_DRAM_CTL11_CASLAT      0x00000007

#define BF_DRAM_CTL11_CASLAT(v)   (((v) << 0) & BM_DRAM_CTL11_CASLAT)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL11_CASLAT(v)   BF_CS1(DRAM_CTL11, CASLAT, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DRAM_CTL12 - DRAM Control Register 12
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned TCKE      :  3;
        unsigned RSVD1     :  5;
        reg8_t   OBSOLETE;
        unsigned TRRD      :  3;
        unsigned RSVD2     :  5;
        unsigned TWR_INT   :  3;
        unsigned RSVD3     :  5;
    } B;
} hw_dram_ctl12_t;
#endif


//
// constants & macros for entire HW_DRAM_CTL12 register
//

#define HW_DRAM_CTL12_ADDR      (REGS_DRAM_BASE + 0x00000030)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL12           (*(volatile hw_dram_ctl12_t *) HW_DRAM_CTL12_ADDR)
#define HW_DRAM_CTL12_RD()      (HW_DRAM_CTL12.U)
#define HW_DRAM_CTL12_WR(v)     (HW_DRAM_CTL12.U = (v))
#define HW_DRAM_CTL12_SET(v)    (HW_DRAM_CTL12_WR(HW_DRAM_CTL12_RD() |  (v)))
#define HW_DRAM_CTL12_CLR(v)    (HW_DRAM_CTL12_WR(HW_DRAM_CTL12_RD() & ~(v)))
#define HW_DRAM_CTL12_TOG(v)    (HW_DRAM_CTL12_WR(HW_DRAM_CTL12_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DRAM_CTL12 bitfields
//

//--- Register HW_DRAM_CTL12, field TWR_INT

#define BP_DRAM_CTL12_TWR_INT      24
#define BM_DRAM_CTL12_TWR_INT      0x07000000

#define BF_DRAM_CTL12_TWR_INT(v)   (((v) << 24) & BM_DRAM_CTL12_TWR_INT)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL12_TWR_INT(v)   BF_CS1(DRAM_CTL12, TWR_INT, v)
#endif

//--- Register HW_DRAM_CTL12, field TRRD

#define BP_DRAM_CTL12_TRRD      16
#define BM_DRAM_CTL12_TRRD      0x00070000

#define BF_DRAM_CTL12_TRRD(v)   (((v) << 16) & BM_DRAM_CTL12_TRRD)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL12_TRRD(v)   BF_CS1(DRAM_CTL12, TRRD, v)
#endif

//--- Register HW_DRAM_CTL12, field TCKE

#define BP_DRAM_CTL12_TCKE      0
#define BM_DRAM_CTL12_TCKE      0x00000007

#define BF_DRAM_CTL12_TCKE(v)   (((v) << 0) & BM_DRAM_CTL12_TCKE)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL12_TCKE(v)   BF_CS1(DRAM_CTL12, TCKE, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DRAM_CTL13 - DRAM Control Register 13
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned TWTR             :  3;
        unsigned RSVD1            :  5;
        unsigned APREBIT          :  4;
        unsigned RSVD2            :  4;
        unsigned CASLAT_LIN       :  4;
        unsigned RSVD3            :  4;
        unsigned CASLAT_LIN_GATE  :  4;
        unsigned RSVD4            :  4;
    } B;
} hw_dram_ctl13_t;
#endif


//
// constants & macros for entire HW_DRAM_CTL13 register
//

#define HW_DRAM_CTL13_ADDR      (REGS_DRAM_BASE + 0x00000034)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL13           (*(volatile hw_dram_ctl13_t *) HW_DRAM_CTL13_ADDR)
#define HW_DRAM_CTL13_RD()      (HW_DRAM_CTL13.U)
#define HW_DRAM_CTL13_WR(v)     (HW_DRAM_CTL13.U = (v))
#define HW_DRAM_CTL13_SET(v)    (HW_DRAM_CTL13_WR(HW_DRAM_CTL13_RD() |  (v)))
#define HW_DRAM_CTL13_CLR(v)    (HW_DRAM_CTL13_WR(HW_DRAM_CTL13_RD() & ~(v)))
#define HW_DRAM_CTL13_TOG(v)    (HW_DRAM_CTL13_WR(HW_DRAM_CTL13_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DRAM_CTL13 bitfields
//

//--- Register HW_DRAM_CTL13, field CASLAT_LIN_GATE

#define BP_DRAM_CTL13_CASLAT_LIN_GATE      24
#define BM_DRAM_CTL13_CASLAT_LIN_GATE      0x0F000000

#define BF_DRAM_CTL13_CASLAT_LIN_GATE(v)   (((v) << 24) & BM_DRAM_CTL13_CASLAT_LIN_GATE)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL13_CASLAT_LIN_GATE(v)   BF_CS1(DRAM_CTL13, CASLAT_LIN_GATE, v)
#endif

//--- Register HW_DRAM_CTL13, field CASLAT_LIN

#define BP_DRAM_CTL13_CASLAT_LIN      16
#define BM_DRAM_CTL13_CASLAT_LIN      0x000F0000

#define BF_DRAM_CTL13_CASLAT_LIN(v)   (((v) << 16) & BM_DRAM_CTL13_CASLAT_LIN)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL13_CASLAT_LIN(v)   BF_CS1(DRAM_CTL13, CASLAT_LIN, v)
#endif

//--- Register HW_DRAM_CTL13, field APREBIT

#define BP_DRAM_CTL13_APREBIT      8
#define BM_DRAM_CTL13_APREBIT      0x00000F00

#define BF_DRAM_CTL13_APREBIT(v)   (((v) << 8) & BM_DRAM_CTL13_APREBIT)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL13_APREBIT(v)   BF_CS1(DRAM_CTL13, APREBIT, v)
#endif

//--- Register HW_DRAM_CTL13, field TWTR

#define BP_DRAM_CTL13_TWTR      0
#define BM_DRAM_CTL13_TWTR      0x00000007

#define BF_DRAM_CTL13_TWTR(v)   (((v) << 0) & BM_DRAM_CTL13_TWTR)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL13_TWTR(v)   BF_CS1(DRAM_CTL13, TWTR, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DRAM_CTL14 - DRAM Control Register 14
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned CS_MAP                   :  4;
        unsigned RSVD1                    :  4;
        unsigned INITAREF                 :  4;
        unsigned RSVD2                    :  4;
        unsigned LOWPOWER_REFRESH_ENABLE  :  4;
        unsigned RSVD3                    :  4;
        unsigned MAX_COL_REG              :  4;
        unsigned RSVD4                    :  4;
    } B;
} hw_dram_ctl14_t;
#endif


//
// constants & macros for entire HW_DRAM_CTL14 register
//

#define HW_DRAM_CTL14_ADDR      (REGS_DRAM_BASE + 0x00000038)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL14           (*(volatile hw_dram_ctl14_t *) HW_DRAM_CTL14_ADDR)
#define HW_DRAM_CTL14_RD()      (HW_DRAM_CTL14.U)
#define HW_DRAM_CTL14_WR(v)     (HW_DRAM_CTL14.U = (v))
#define HW_DRAM_CTL14_SET(v)    (HW_DRAM_CTL14_WR(HW_DRAM_CTL14_RD() |  (v)))
#define HW_DRAM_CTL14_CLR(v)    (HW_DRAM_CTL14_WR(HW_DRAM_CTL14_RD() & ~(v)))
#define HW_DRAM_CTL14_TOG(v)    (HW_DRAM_CTL14_WR(HW_DRAM_CTL14_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DRAM_CTL14 bitfields
//

//--- Register HW_DRAM_CTL14, field MAX_COL_REG

#define BP_DRAM_CTL14_MAX_COL_REG      24
#define BM_DRAM_CTL14_MAX_COL_REG      0x0F000000

#define BF_DRAM_CTL14_MAX_COL_REG(v)   (((v) << 24) & BM_DRAM_CTL14_MAX_COL_REG)

//--- Register HW_DRAM_CTL14, field LOWPOWER_REFRESH_ENABLE

#define BP_DRAM_CTL14_LOWPOWER_REFRESH_ENABLE      16
#define BM_DRAM_CTL14_LOWPOWER_REFRESH_ENABLE      0x000F0000

#define BF_DRAM_CTL14_LOWPOWER_REFRESH_ENABLE(v)   (((v) << 16) & BM_DRAM_CTL14_LOWPOWER_REFRESH_ENABLE)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL14_LOWPOWER_REFRESH_ENABLE(v)   BF_CS1(DRAM_CTL14, LOWPOWER_REFRESH_ENABLE, v)
#endif

//--- Register HW_DRAM_CTL14, field INITAREF

#define BP_DRAM_CTL14_INITAREF      8
#define BM_DRAM_CTL14_INITAREF      0x00000F00

#define BF_DRAM_CTL14_INITAREF(v)   (((v) << 8) & BM_DRAM_CTL14_INITAREF)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL14_INITAREF(v)   BF_CS1(DRAM_CTL14, INITAREF, v)
#endif

//--- Register HW_DRAM_CTL14, field CS_MAP

#define BP_DRAM_CTL14_CS_MAP      0
#define BM_DRAM_CTL14_CS_MAP      0x0000000F

#define BF_DRAM_CTL14_CS_MAP(v)   (((v) << 0) & BM_DRAM_CTL14_CS_MAP)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL14_CS_MAP(v)   BF_CS1(DRAM_CTL14, CS_MAP, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DRAM_CTL15 - DRAM Control Register 15
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned MAX_ROW_REG  :  4;
        unsigned RSVD1        :  4;
        unsigned PORT_BUSY    :  4;
        unsigned RSVD2        :  4;
        unsigned TDAL         :  4;
        unsigned RSVD3        :  4;
        unsigned TRP          :  4;
        unsigned RSVD4        :  4;
    } B;
} hw_dram_ctl15_t;
#endif


//
// constants & macros for entire HW_DRAM_CTL15 register
//

#define HW_DRAM_CTL15_ADDR      (REGS_DRAM_BASE + 0x0000003C)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL15           (*(volatile hw_dram_ctl15_t *) HW_DRAM_CTL15_ADDR)
#define HW_DRAM_CTL15_RD()      (HW_DRAM_CTL15.U)
#define HW_DRAM_CTL15_WR(v)     (HW_DRAM_CTL15.U = (v))
#define HW_DRAM_CTL15_SET(v)    (HW_DRAM_CTL15_WR(HW_DRAM_CTL15_RD() |  (v)))
#define HW_DRAM_CTL15_CLR(v)    (HW_DRAM_CTL15_WR(HW_DRAM_CTL15_RD() & ~(v)))
#define HW_DRAM_CTL15_TOG(v)    (HW_DRAM_CTL15_WR(HW_DRAM_CTL15_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DRAM_CTL15 bitfields
//

//--- Register HW_DRAM_CTL15, field TRP

#define BP_DRAM_CTL15_TRP      24
#define BM_DRAM_CTL15_TRP      0x0F000000

#define BF_DRAM_CTL15_TRP(v)   (((v) << 24) & BM_DRAM_CTL15_TRP)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL15_TRP(v)   BF_CS1(DRAM_CTL15, TRP, v)
#endif

//--- Register HW_DRAM_CTL15, field TDAL

#define BP_DRAM_CTL15_TDAL      16
#define BM_DRAM_CTL15_TDAL      0x000F0000

#define BF_DRAM_CTL15_TDAL(v)   (((v) << 16) & BM_DRAM_CTL15_TDAL)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL15_TDAL(v)   BF_CS1(DRAM_CTL15, TDAL, v)
#endif

//--- Register HW_DRAM_CTL15, field PORT_BUSY

#define BP_DRAM_CTL15_PORT_BUSY      8
#define BM_DRAM_CTL15_PORT_BUSY      0x00000F00

#define BF_DRAM_CTL15_PORT_BUSY(v)   (((v) << 8) & BM_DRAM_CTL15_PORT_BUSY)

//--- Register HW_DRAM_CTL15, field MAX_ROW_REG

#define BP_DRAM_CTL15_MAX_ROW_REG      0
#define BM_DRAM_CTL15_MAX_ROW_REG      0x0000000F

#define BF_DRAM_CTL15_MAX_ROW_REG(v)   (((v) << 0) & BM_DRAM_CTL15_MAX_ROW_REG)


////////////////////////////////////////////////////////////////////////////////
//// HW_DRAM_CTL16 - DRAM Control Register 16
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned INT_ACK               :  4;
        unsigned RSVD1                 :  4;
        unsigned LOWPOWER_AUTO_ENABLE  :  5;
        unsigned RSVD2                 :  3;
        unsigned LOWPOWER_CONTROL      :  5;
        unsigned RSVD3                 :  3;
        unsigned TMRD                  :  5;
        unsigned RSVD4                 :  3;
    } B;
} hw_dram_ctl16_t;
#endif


//
// constants & macros for entire HW_DRAM_CTL16 register
//

#define HW_DRAM_CTL16_ADDR      (REGS_DRAM_BASE + 0x00000040)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL16           (*(volatile hw_dram_ctl16_t *) HW_DRAM_CTL16_ADDR)
#define HW_DRAM_CTL16_RD()      (HW_DRAM_CTL16.U)
#define HW_DRAM_CTL16_WR(v)     (HW_DRAM_CTL16.U = (v))
#define HW_DRAM_CTL16_SET(v)    (HW_DRAM_CTL16_WR(HW_DRAM_CTL16_RD() |  (v)))
#define HW_DRAM_CTL16_CLR(v)    (HW_DRAM_CTL16_WR(HW_DRAM_CTL16_RD() & ~(v)))
#define HW_DRAM_CTL16_TOG(v)    (HW_DRAM_CTL16_WR(HW_DRAM_CTL16_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DRAM_CTL16 bitfields
//

//--- Register HW_DRAM_CTL16, field TMRD

#define BP_DRAM_CTL16_TMRD      24
#define BM_DRAM_CTL16_TMRD      0x1F000000

#define BF_DRAM_CTL16_TMRD(v)   (((v) << 24) & BM_DRAM_CTL16_TMRD)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL16_TMRD(v)   BF_CS1(DRAM_CTL16, TMRD, v)
#endif

//--- Register HW_DRAM_CTL16, field LOWPOWER_CONTROL

#define BP_DRAM_CTL16_LOWPOWER_CONTROL      16
#define BM_DRAM_CTL16_LOWPOWER_CONTROL      0x001F0000

#define BF_DRAM_CTL16_LOWPOWER_CONTROL(v)   (((v) << 16) & BM_DRAM_CTL16_LOWPOWER_CONTROL)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL16_LOWPOWER_CONTROL(v)   BF_CS1(DRAM_CTL16, LOWPOWER_CONTROL, v)
#endif

//--- Register HW_DRAM_CTL16, field LOWPOWER_AUTO_ENABLE

#define BP_DRAM_CTL16_LOWPOWER_AUTO_ENABLE      8
#define BM_DRAM_CTL16_LOWPOWER_AUTO_ENABLE      0x00001F00

#define BF_DRAM_CTL16_LOWPOWER_AUTO_ENABLE(v)   (((v) << 8) & BM_DRAM_CTL16_LOWPOWER_AUTO_ENABLE)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL16_LOWPOWER_AUTO_ENABLE(v)   BF_CS1(DRAM_CTL16, LOWPOWER_AUTO_ENABLE, v)
#endif

//--- Register HW_DRAM_CTL16, field INT_ACK

#define BP_DRAM_CTL16_INT_ACK      0
#define BM_DRAM_CTL16_INT_ACK      0x0000000F

#define BF_DRAM_CTL16_INT_ACK(v)   (((v) << 0) & BM_DRAM_CTL16_INT_ACK)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL16_INT_ACK(v)   BF_CS1(DRAM_CTL16, INT_ACK, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DRAM_CTL17 - DRAM Control Register 17
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned TRC              :  5;
        unsigned RSVD1            :  3;
        reg8_t   DLL_INCREMENT;
        reg8_t   DLL_LOCK;
        reg8_t   DLL_START_POINT;
    } B;
} hw_dram_ctl17_t;
#endif


//
// constants & macros for entire HW_DRAM_CTL17 register
//

#define HW_DRAM_CTL17_ADDR      (REGS_DRAM_BASE + 0x00000044)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL17           (*(volatile hw_dram_ctl17_t *) HW_DRAM_CTL17_ADDR)
#define HW_DRAM_CTL17_RD()      (HW_DRAM_CTL17.U)
#define HW_DRAM_CTL17_WR(v)     (HW_DRAM_CTL17.U = (v))
#define HW_DRAM_CTL17_SET(v)    (HW_DRAM_CTL17_WR(HW_DRAM_CTL17_RD() |  (v)))
#define HW_DRAM_CTL17_CLR(v)    (HW_DRAM_CTL17_WR(HW_DRAM_CTL17_RD() & ~(v)))
#define HW_DRAM_CTL17_TOG(v)    (HW_DRAM_CTL17_WR(HW_DRAM_CTL17_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DRAM_CTL17 bitfields
//

//--- Register HW_DRAM_CTL17, field DLL_START_POINT

#define BP_DRAM_CTL17_DLL_START_POINT      24
#define BM_DRAM_CTL17_DLL_START_POINT      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL17_DLL_START_POINT(v)   ((((reg32_t) v) << 24) & BM_DRAM_CTL17_DLL_START_POINT)
#else
#define BF_DRAM_CTL17_DLL_START_POINT(v)   (((v) << 24) & BM_DRAM_CTL17_DLL_START_POINT)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL17_DLL_START_POINT(v)   (HW_DRAM_CTL17.B.DLL_START_POINT = (v))
#endif

//--- Register HW_DRAM_CTL17, field DLL_LOCK

#define BP_DRAM_CTL17_DLL_LOCK      16
#define BM_DRAM_CTL17_DLL_LOCK      0x00FF0000

#define BF_DRAM_CTL17_DLL_LOCK(v)   (((v) << 16) & BM_DRAM_CTL17_DLL_LOCK)

//--- Register HW_DRAM_CTL17, field DLL_INCREMENT

#define BP_DRAM_CTL17_DLL_INCREMENT      8
#define BM_DRAM_CTL17_DLL_INCREMENT      0x0000FF00

#define BF_DRAM_CTL17_DLL_INCREMENT(v)   (((v) << 8) & BM_DRAM_CTL17_DLL_INCREMENT)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL17_DLL_INCREMENT(v)   (HW_DRAM_CTL17.B.DLL_INCREMENT = (v))
#endif

//--- Register HW_DRAM_CTL17, field TRC

#define BP_DRAM_CTL17_TRC      0
#define BM_DRAM_CTL17_TRC      0x0000001F

#define BF_DRAM_CTL17_TRC(v)   (((v) << 0) & BM_DRAM_CTL17_TRC)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL17_TRC(v)   BF_CS1(DRAM_CTL17, TRC, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DRAM_CTL18 - DRAM Control Register 18
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned INT_MASK         :  5;
        unsigned RSVD1            :  3;
        unsigned INT_STATUS       :  5;
        unsigned RSVD2            :  3;
        unsigned DLL_DQS_DELAY_0  :  7;
        unsigned RSVD3            :  1;
        unsigned DLL_DQS_DELAY_1  :  7;
        unsigned RSVD4            :  1;
    } B;
} hw_dram_ctl18_t;
#endif


//
// constants & macros for entire HW_DRAM_CTL18 register
//

#define HW_DRAM_CTL18_ADDR      (REGS_DRAM_BASE + 0x00000048)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL18           (*(volatile hw_dram_ctl18_t *) HW_DRAM_CTL18_ADDR)
#define HW_DRAM_CTL18_RD()      (HW_DRAM_CTL18.U)
#define HW_DRAM_CTL18_WR(v)     (HW_DRAM_CTL18.U = (v))
#define HW_DRAM_CTL18_SET(v)    (HW_DRAM_CTL18_WR(HW_DRAM_CTL18_RD() |  (v)))
#define HW_DRAM_CTL18_CLR(v)    (HW_DRAM_CTL18_WR(HW_DRAM_CTL18_RD() & ~(v)))
#define HW_DRAM_CTL18_TOG(v)    (HW_DRAM_CTL18_WR(HW_DRAM_CTL18_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DRAM_CTL18 bitfields
//

//--- Register HW_DRAM_CTL18, field DLL_DQS_DELAY_1

#define BP_DRAM_CTL18_DLL_DQS_DELAY_1      24
#define BM_DRAM_CTL18_DLL_DQS_DELAY_1      0x7F000000

#define BF_DRAM_CTL18_DLL_DQS_DELAY_1(v)   (((v) << 24) & BM_DRAM_CTL18_DLL_DQS_DELAY_1)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL18_DLL_DQS_DELAY_1(v)   BF_CS1(DRAM_CTL18, DLL_DQS_DELAY_1, v)
#endif

//--- Register HW_DRAM_CTL18, field DLL_DQS_DELAY_0

#define BP_DRAM_CTL18_DLL_DQS_DELAY_0      16
#define BM_DRAM_CTL18_DLL_DQS_DELAY_0      0x007F0000

#define BF_DRAM_CTL18_DLL_DQS_DELAY_0(v)   (((v) << 16) & BM_DRAM_CTL18_DLL_DQS_DELAY_0)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL18_DLL_DQS_DELAY_0(v)   BF_CS1(DRAM_CTL18, DLL_DQS_DELAY_0, v)
#endif

//--- Register HW_DRAM_CTL18, field INT_STATUS

#define BP_DRAM_CTL18_INT_STATUS      8
#define BM_DRAM_CTL18_INT_STATUS      0x00001F00

#define BF_DRAM_CTL18_INT_STATUS(v)   (((v) << 8) & BM_DRAM_CTL18_INT_STATUS)

//--- Register HW_DRAM_CTL18, field INT_MASK

#define BP_DRAM_CTL18_INT_MASK      0
#define BM_DRAM_CTL18_INT_MASK      0x0000001F

#define BF_DRAM_CTL18_INT_MASK(v)   (((v) << 0) & BM_DRAM_CTL18_INT_MASK)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL18_INT_MASK(v)   BF_CS1(DRAM_CTL18, INT_MASK, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DRAM_CTL19 - DRAM Control Register 19
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg8_t   DLL_DQS_DELAY_BYPASS_0;
        reg8_t   DLL_DQS_DELAY_BYPASS_1;
        unsigned DQS_OUT_SHIFT           :  7;
        unsigned RSVD1                   :  1;
        reg8_t   DQS_OUT_SHIFT_BYPASS;
    } B;
} hw_dram_ctl19_t;
#endif


//
// constants & macros for entire HW_DRAM_CTL19 register
//

#define HW_DRAM_CTL19_ADDR      (REGS_DRAM_BASE + 0x0000004C)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL19           (*(volatile hw_dram_ctl19_t *) HW_DRAM_CTL19_ADDR)
#define HW_DRAM_CTL19_RD()      (HW_DRAM_CTL19.U)
#define HW_DRAM_CTL19_WR(v)     (HW_DRAM_CTL19.U = (v))
#define HW_DRAM_CTL19_SET(v)    (HW_DRAM_CTL19_WR(HW_DRAM_CTL19_RD() |  (v)))
#define HW_DRAM_CTL19_CLR(v)    (HW_DRAM_CTL19_WR(HW_DRAM_CTL19_RD() & ~(v)))
#define HW_DRAM_CTL19_TOG(v)    (HW_DRAM_CTL19_WR(HW_DRAM_CTL19_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DRAM_CTL19 bitfields
//

//--- Register HW_DRAM_CTL19, field DQS_OUT_SHIFT_BYPASS

#define BP_DRAM_CTL19_DQS_OUT_SHIFT_BYPASS      24
#define BM_DRAM_CTL19_DQS_OUT_SHIFT_BYPASS      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL19_DQS_OUT_SHIFT_BYPASS(v)   ((((reg32_t) v) << 24) & BM_DRAM_CTL19_DQS_OUT_SHIFT_BYPASS)
#else
#define BF_DRAM_CTL19_DQS_OUT_SHIFT_BYPASS(v)   (((v) << 24) & BM_DRAM_CTL19_DQS_OUT_SHIFT_BYPASS)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL19_DQS_OUT_SHIFT_BYPASS(v)   (HW_DRAM_CTL19.B.DQS_OUT_SHIFT_BYPASS = (v))
#endif

//--- Register HW_DRAM_CTL19, field DQS_OUT_SHIFT

#define BP_DRAM_CTL19_DQS_OUT_SHIFT      16
#define BM_DRAM_CTL19_DQS_OUT_SHIFT      0x007F0000

#define BF_DRAM_CTL19_DQS_OUT_SHIFT(v)   (((v) << 16) & BM_DRAM_CTL19_DQS_OUT_SHIFT)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL19_DQS_OUT_SHIFT(v)   BF_CS1(DRAM_CTL19, DQS_OUT_SHIFT, v)
#endif

//--- Register HW_DRAM_CTL19, field DLL_DQS_DELAY_BYPASS_1

#define BP_DRAM_CTL19_DLL_DQS_DELAY_BYPASS_1      8
#define BM_DRAM_CTL19_DLL_DQS_DELAY_BYPASS_1      0x0000FF00

#define BF_DRAM_CTL19_DLL_DQS_DELAY_BYPASS_1(v)   (((v) << 8) & BM_DRAM_CTL19_DLL_DQS_DELAY_BYPASS_1)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL19_DLL_DQS_DELAY_BYPASS_1(v)   (HW_DRAM_CTL19.B.DLL_DQS_DELAY_BYPASS_1 = (v))
#endif

//--- Register HW_DRAM_CTL19, field DLL_DQS_DELAY_BYPASS_0

#define BP_DRAM_CTL19_DLL_DQS_DELAY_BYPASS_0      0
#define BM_DRAM_CTL19_DLL_DQS_DELAY_BYPASS_0      0x000000FF

#define BF_DRAM_CTL19_DLL_DQS_DELAY_BYPASS_0(v)   (((v) << 0) & BM_DRAM_CTL19_DLL_DQS_DELAY_BYPASS_0)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL19_DLL_DQS_DELAY_BYPASS_0(v)   (HW_DRAM_CTL19.B.DLL_DQS_DELAY_BYPASS_0 = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DRAM_CTL20 - DRAM Control Register 20
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned WR_DQS_SHIFT         :  7;
        unsigned RSVD1                :  1;
        reg8_t   WR_DQS_SHIFT_BYPASS;
        reg8_t   TRAS_MIN;
        reg8_t   TRCD_INT;
    } B;
} hw_dram_ctl20_t;
#endif


//
// constants & macros for entire HW_DRAM_CTL20 register
//

#define HW_DRAM_CTL20_ADDR      (REGS_DRAM_BASE + 0x00000050)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL20           (*(volatile hw_dram_ctl20_t *) HW_DRAM_CTL20_ADDR)
#define HW_DRAM_CTL20_RD()      (HW_DRAM_CTL20.U)
#define HW_DRAM_CTL20_WR(v)     (HW_DRAM_CTL20.U = (v))
#define HW_DRAM_CTL20_SET(v)    (HW_DRAM_CTL20_WR(HW_DRAM_CTL20_RD() |  (v)))
#define HW_DRAM_CTL20_CLR(v)    (HW_DRAM_CTL20_WR(HW_DRAM_CTL20_RD() & ~(v)))
#define HW_DRAM_CTL20_TOG(v)    (HW_DRAM_CTL20_WR(HW_DRAM_CTL20_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DRAM_CTL20 bitfields
//

//--- Register HW_DRAM_CTL20, field TRCD_INT

#define BP_DRAM_CTL20_TRCD_INT      24
#define BM_DRAM_CTL20_TRCD_INT      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL20_TRCD_INT(v)   ((((reg32_t) v) << 24) & BM_DRAM_CTL20_TRCD_INT)
#else
#define BF_DRAM_CTL20_TRCD_INT(v)   (((v) << 24) & BM_DRAM_CTL20_TRCD_INT)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL20_TRCD_INT(v)   (HW_DRAM_CTL20.B.TRCD_INT = (v))
#endif

//--- Register HW_DRAM_CTL20, field TRAS_MIN

#define BP_DRAM_CTL20_TRAS_MIN      16
#define BM_DRAM_CTL20_TRAS_MIN      0x00FF0000

#define BF_DRAM_CTL20_TRAS_MIN(v)   (((v) << 16) & BM_DRAM_CTL20_TRAS_MIN)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL20_TRAS_MIN(v)   (HW_DRAM_CTL20.B.TRAS_MIN = (v))
#endif

//--- Register HW_DRAM_CTL20, field WR_DQS_SHIFT_BYPASS

#define BP_DRAM_CTL20_WR_DQS_SHIFT_BYPASS      8
#define BM_DRAM_CTL20_WR_DQS_SHIFT_BYPASS      0x0000FF00

#define BF_DRAM_CTL20_WR_DQS_SHIFT_BYPASS(v)   (((v) << 8) & BM_DRAM_CTL20_WR_DQS_SHIFT_BYPASS)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL20_WR_DQS_SHIFT_BYPASS(v)   (HW_DRAM_CTL20.B.WR_DQS_SHIFT_BYPASS = (v))
#endif

//--- Register HW_DRAM_CTL20, field WR_DQS_SHIFT

#define BP_DRAM_CTL20_WR_DQS_SHIFT      0
#define BM_DRAM_CTL20_WR_DQS_SHIFT      0x0000007F

#define BF_DRAM_CTL20_WR_DQS_SHIFT(v)   (((v) << 0) & BM_DRAM_CTL20_WR_DQS_SHIFT)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL20_WR_DQS_SHIFT(v)   BF_CS1(DRAM_CTL20, WR_DQS_SHIFT, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DRAM_CTL21 - DRAM Control Register 21
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg8_t   TRFC;
        unsigned OUT_OF_RANGE_LENGTH  : 10;
        unsigned RSVD1                :  6;
        reg8_t   OBSOLETE;
    } B;
} hw_dram_ctl21_t;
#endif


//
// constants & macros for entire HW_DRAM_CTL21 register
//

#define HW_DRAM_CTL21_ADDR      (REGS_DRAM_BASE + 0x00000054)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL21           (*(volatile hw_dram_ctl21_t *) HW_DRAM_CTL21_ADDR)
#define HW_DRAM_CTL21_RD()      (HW_DRAM_CTL21.U)
#define HW_DRAM_CTL21_WR(v)     (HW_DRAM_CTL21.U = (v))
#define HW_DRAM_CTL21_SET(v)    (HW_DRAM_CTL21_WR(HW_DRAM_CTL21_RD() |  (v)))
#define HW_DRAM_CTL21_CLR(v)    (HW_DRAM_CTL21_WR(HW_DRAM_CTL21_RD() & ~(v)))
#define HW_DRAM_CTL21_TOG(v)    (HW_DRAM_CTL21_WR(HW_DRAM_CTL21_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DRAM_CTL21 bitfields
//

//--- Register HW_DRAM_CTL21, field OUT_OF_RANGE_LENGTH

#define BP_DRAM_CTL21_OUT_OF_RANGE_LENGTH      8
#define BM_DRAM_CTL21_OUT_OF_RANGE_LENGTH      0x0003FF00

#define BF_DRAM_CTL21_OUT_OF_RANGE_LENGTH(v)   (((v) << 8) & BM_DRAM_CTL21_OUT_OF_RANGE_LENGTH)

//--- Register HW_DRAM_CTL21, field TRFC

#define BP_DRAM_CTL21_TRFC      0
#define BM_DRAM_CTL21_TRFC      0x000000FF

#define BF_DRAM_CTL21_TRFC(v)   (((v) << 0) & BM_DRAM_CTL21_TRFC)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL21_TRFC(v)   (HW_DRAM_CTL21.B.TRFC = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DRAM_CTL22 - DRAM Control Register 22
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned AHB0_RDCNT  : 11;
        unsigned RSVD1       :  5;
        unsigned AHB0_WRCNT  : 11;
        unsigned RSVD2       :  5;
    } B;
} hw_dram_ctl22_t;
#endif


//
// constants & macros for entire HW_DRAM_CTL22 register
//

#define HW_DRAM_CTL22_ADDR      (REGS_DRAM_BASE + 0x00000058)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL22           (*(volatile hw_dram_ctl22_t *) HW_DRAM_CTL22_ADDR)
#define HW_DRAM_CTL22_RD()      (HW_DRAM_CTL22.U)
#define HW_DRAM_CTL22_WR(v)     (HW_DRAM_CTL22.U = (v))
#define HW_DRAM_CTL22_SET(v)    (HW_DRAM_CTL22_WR(HW_DRAM_CTL22_RD() |  (v)))
#define HW_DRAM_CTL22_CLR(v)    (HW_DRAM_CTL22_WR(HW_DRAM_CTL22_RD() & ~(v)))
#define HW_DRAM_CTL22_TOG(v)    (HW_DRAM_CTL22_WR(HW_DRAM_CTL22_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DRAM_CTL22 bitfields
//

//--- Register HW_DRAM_CTL22, field AHB0_WRCNT

#define BP_DRAM_CTL22_AHB0_WRCNT      16
#define BM_DRAM_CTL22_AHB0_WRCNT      0x07FF0000

#define BF_DRAM_CTL22_AHB0_WRCNT(v)   (((v) << 16) & BM_DRAM_CTL22_AHB0_WRCNT)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL22_AHB0_WRCNT(v)   BF_CS1(DRAM_CTL22, AHB0_WRCNT, v)
#endif

//--- Register HW_DRAM_CTL22, field AHB0_RDCNT

#define BP_DRAM_CTL22_AHB0_RDCNT      0
#define BM_DRAM_CTL22_AHB0_RDCNT      0x000007FF

#define BF_DRAM_CTL22_AHB0_RDCNT(v)   (((v) << 0) & BM_DRAM_CTL22_AHB0_RDCNT)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL22_AHB0_RDCNT(v)   BF_CS1(DRAM_CTL22, AHB0_RDCNT, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DRAM_CTL23 - DRAM Control Register 23
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned AHB1_RDCNT  : 11;
        unsigned RSVD1       :  5;
        unsigned AHB1_WRCNT  : 11;
        unsigned RSVD2       :  5;
    } B;
} hw_dram_ctl23_t;
#endif


//
// constants & macros for entire HW_DRAM_CTL23 register
//

#define HW_DRAM_CTL23_ADDR      (REGS_DRAM_BASE + 0x0000005C)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL23           (*(volatile hw_dram_ctl23_t *) HW_DRAM_CTL23_ADDR)
#define HW_DRAM_CTL23_RD()      (HW_DRAM_CTL23.U)
#define HW_DRAM_CTL23_WR(v)     (HW_DRAM_CTL23.U = (v))
#define HW_DRAM_CTL23_SET(v)    (HW_DRAM_CTL23_WR(HW_DRAM_CTL23_RD() |  (v)))
#define HW_DRAM_CTL23_CLR(v)    (HW_DRAM_CTL23_WR(HW_DRAM_CTL23_RD() & ~(v)))
#define HW_DRAM_CTL23_TOG(v)    (HW_DRAM_CTL23_WR(HW_DRAM_CTL23_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DRAM_CTL23 bitfields
//

//--- Register HW_DRAM_CTL23, field AHB1_WRCNT

#define BP_DRAM_CTL23_AHB1_WRCNT      16
#define BM_DRAM_CTL23_AHB1_WRCNT      0x07FF0000

#define BF_DRAM_CTL23_AHB1_WRCNT(v)   (((v) << 16) & BM_DRAM_CTL23_AHB1_WRCNT)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL23_AHB1_WRCNT(v)   BF_CS1(DRAM_CTL23, AHB1_WRCNT, v)
#endif

//--- Register HW_DRAM_CTL23, field AHB1_RDCNT

#define BP_DRAM_CTL23_AHB1_RDCNT      0
#define BM_DRAM_CTL23_AHB1_RDCNT      0x000007FF

#define BF_DRAM_CTL23_AHB1_RDCNT(v)   (((v) << 0) & BM_DRAM_CTL23_AHB1_RDCNT)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL23_AHB1_RDCNT(v)   BF_CS1(DRAM_CTL23, AHB1_RDCNT, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DRAM_CTL24 - DRAM Control Register 24
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned AHB2_RDCNT  : 11;
        unsigned RSVD1       :  5;
        unsigned AHB2_WRCNT  : 11;
        unsigned RSVD2       :  5;
    } B;
} hw_dram_ctl24_t;
#endif


//
// constants & macros for entire HW_DRAM_CTL24 register
//

#define HW_DRAM_CTL24_ADDR      (REGS_DRAM_BASE + 0x00000060)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL24           (*(volatile hw_dram_ctl24_t *) HW_DRAM_CTL24_ADDR)
#define HW_DRAM_CTL24_RD()      (HW_DRAM_CTL24.U)
#define HW_DRAM_CTL24_WR(v)     (HW_DRAM_CTL24.U = (v))
#define HW_DRAM_CTL24_SET(v)    (HW_DRAM_CTL24_WR(HW_DRAM_CTL24_RD() |  (v)))
#define HW_DRAM_CTL24_CLR(v)    (HW_DRAM_CTL24_WR(HW_DRAM_CTL24_RD() & ~(v)))
#define HW_DRAM_CTL24_TOG(v)    (HW_DRAM_CTL24_WR(HW_DRAM_CTL24_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DRAM_CTL24 bitfields
//

//--- Register HW_DRAM_CTL24, field AHB2_WRCNT

#define BP_DRAM_CTL24_AHB2_WRCNT      16
#define BM_DRAM_CTL24_AHB2_WRCNT      0x07FF0000

#define BF_DRAM_CTL24_AHB2_WRCNT(v)   (((v) << 16) & BM_DRAM_CTL24_AHB2_WRCNT)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL24_AHB2_WRCNT(v)   BF_CS1(DRAM_CTL24, AHB2_WRCNT, v)
#endif

//--- Register HW_DRAM_CTL24, field AHB2_RDCNT

#define BP_DRAM_CTL24_AHB2_RDCNT      0
#define BM_DRAM_CTL24_AHB2_RDCNT      0x000007FF

#define BF_DRAM_CTL24_AHB2_RDCNT(v)   (((v) << 0) & BM_DRAM_CTL24_AHB2_RDCNT)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL24_AHB2_RDCNT(v)   BF_CS1(DRAM_CTL24, AHB2_RDCNT, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DRAM_CTL25 - DRAM Control Register 25
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned AHB3_RDCNT  : 11;
        unsigned RSVD1       :  5;
        unsigned AHB3_WRCNT  : 11;
        unsigned RSVD2       :  5;
    } B;
} hw_dram_ctl25_t;
#endif


//
// constants & macros for entire HW_DRAM_CTL25 register
//

#define HW_DRAM_CTL25_ADDR      (REGS_DRAM_BASE + 0x00000064)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL25           (*(volatile hw_dram_ctl25_t *) HW_DRAM_CTL25_ADDR)
#define HW_DRAM_CTL25_RD()      (HW_DRAM_CTL25.U)
#define HW_DRAM_CTL25_WR(v)     (HW_DRAM_CTL25.U = (v))
#define HW_DRAM_CTL25_SET(v)    (HW_DRAM_CTL25_WR(HW_DRAM_CTL25_RD() |  (v)))
#define HW_DRAM_CTL25_CLR(v)    (HW_DRAM_CTL25_WR(HW_DRAM_CTL25_RD() & ~(v)))
#define HW_DRAM_CTL25_TOG(v)    (HW_DRAM_CTL25_WR(HW_DRAM_CTL25_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DRAM_CTL25 bitfields
//

//--- Register HW_DRAM_CTL25, field AHB3_WRCNT

#define BP_DRAM_CTL25_AHB3_WRCNT      16
#define BM_DRAM_CTL25_AHB3_WRCNT      0x07FF0000

#define BF_DRAM_CTL25_AHB3_WRCNT(v)   (((v) << 16) & BM_DRAM_CTL25_AHB3_WRCNT)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL25_AHB3_WRCNT(v)   BF_CS1(DRAM_CTL25, AHB3_WRCNT, v)
#endif

//--- Register HW_DRAM_CTL25, field AHB3_RDCNT

#define BP_DRAM_CTL25_AHB3_RDCNT      0
#define BM_DRAM_CTL25_AHB3_RDCNT      0x000007FF

#define BF_DRAM_CTL25_AHB3_RDCNT(v)   (((v) << 0) & BM_DRAM_CTL25_AHB3_RDCNT)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL25_AHB3_RDCNT(v)   BF_CS1(DRAM_CTL25, AHB3_RDCNT, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DRAM_CTL26 - DRAM Control Register 26
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned TREF      : 12;
        unsigned RSVD1     :  4;
        reg16_t  OBSOLETE;
    } B;
} hw_dram_ctl26_t;
#endif


//
// constants & macros for entire HW_DRAM_CTL26 register
//

#define HW_DRAM_CTL26_ADDR      (REGS_DRAM_BASE + 0x00000068)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL26           (*(volatile hw_dram_ctl26_t *) HW_DRAM_CTL26_ADDR)
#define HW_DRAM_CTL26_RD()      (HW_DRAM_CTL26.U)
#define HW_DRAM_CTL26_WR(v)     (HW_DRAM_CTL26.U = (v))
#define HW_DRAM_CTL26_SET(v)    (HW_DRAM_CTL26_WR(HW_DRAM_CTL26_RD() |  (v)))
#define HW_DRAM_CTL26_CLR(v)    (HW_DRAM_CTL26_WR(HW_DRAM_CTL26_RD() & ~(v)))
#define HW_DRAM_CTL26_TOG(v)    (HW_DRAM_CTL26_WR(HW_DRAM_CTL26_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DRAM_CTL26 bitfields
//

//--- Register HW_DRAM_CTL26, field TREF

#define BP_DRAM_CTL26_TREF      0
#define BM_DRAM_CTL26_TREF      0x00000FFF

#define BF_DRAM_CTL26_TREF(v)   (((v) << 0) & BM_DRAM_CTL26_TREF)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL26_TREF(v)   BF_CS1(DRAM_CTL26, TREF, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DRAM_CTL27 - DRAM Control Register 27
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  OBSOLETE;
    } B;
} hw_dram_ctl27_t;
#endif


//
// constants & macros for entire HW_DRAM_CTL27 register
//

#define HW_DRAM_CTL27_ADDR      (REGS_DRAM_BASE + 0x0000006C)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL27           (*(volatile hw_dram_ctl27_t *) HW_DRAM_CTL27_ADDR)
#define HW_DRAM_CTL27_RD()      (HW_DRAM_CTL27.U)
#endif


//
// constants & macros for individual HW_DRAM_CTL27 bitfields
//


////////////////////////////////////////////////////////////////////////////////
//// HW_DRAM_CTL28 - DRAM Control Register 28
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  OBSOLETE;
    } B;
} hw_dram_ctl28_t;
#endif


//
// constants & macros for entire HW_DRAM_CTL28 register
//

#define HW_DRAM_CTL28_ADDR      (REGS_DRAM_BASE + 0x00000070)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL28           (*(volatile hw_dram_ctl28_t *) HW_DRAM_CTL28_ADDR)
#define HW_DRAM_CTL28_RD()      (HW_DRAM_CTL28.U)
#endif


//
// constants & macros for individual HW_DRAM_CTL28 bitfields
//


////////////////////////////////////////////////////////////////////////////////
//// HW_DRAM_CTL29 - DRAM Control Register 29
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg16_t  LOWPOWER_EXTERNAL_CNT;
        reg16_t  LOWPOWER_INTERNAL_CNT;
    } B;
} hw_dram_ctl29_t;
#endif


//
// constants & macros for entire HW_DRAM_CTL29 register
//

#define HW_DRAM_CTL29_ADDR      (REGS_DRAM_BASE + 0x00000074)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL29           (*(volatile hw_dram_ctl29_t *) HW_DRAM_CTL29_ADDR)
#define HW_DRAM_CTL29_RD()      (HW_DRAM_CTL29.U)
#define HW_DRAM_CTL29_WR(v)     (HW_DRAM_CTL29.U = (v))
#define HW_DRAM_CTL29_SET(v)    (HW_DRAM_CTL29_WR(HW_DRAM_CTL29_RD() |  (v)))
#define HW_DRAM_CTL29_CLR(v)    (HW_DRAM_CTL29_WR(HW_DRAM_CTL29_RD() & ~(v)))
#define HW_DRAM_CTL29_TOG(v)    (HW_DRAM_CTL29_WR(HW_DRAM_CTL29_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DRAM_CTL29 bitfields
//

//--- Register HW_DRAM_CTL29, field LOWPOWER_INTERNAL_CNT

#define BP_DRAM_CTL29_LOWPOWER_INTERNAL_CNT      16
#define BM_DRAM_CTL29_LOWPOWER_INTERNAL_CNT      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL29_LOWPOWER_INTERNAL_CNT(v)   ((((reg32_t) v) << 16) & BM_DRAM_CTL29_LOWPOWER_INTERNAL_CNT)
#else
#define BF_DRAM_CTL29_LOWPOWER_INTERNAL_CNT(v)   (((v) << 16) & BM_DRAM_CTL29_LOWPOWER_INTERNAL_CNT)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL29_LOWPOWER_INTERNAL_CNT(v)   (HW_DRAM_CTL29.B.LOWPOWER_INTERNAL_CNT = (v))
#endif

//--- Register HW_DRAM_CTL29, field LOWPOWER_EXTERNAL_CNT

#define BP_DRAM_CTL29_LOWPOWER_EXTERNAL_CNT      0
#define BM_DRAM_CTL29_LOWPOWER_EXTERNAL_CNT      0x0000FFFF

#define BF_DRAM_CTL29_LOWPOWER_EXTERNAL_CNT(v)   (((v) << 0) & BM_DRAM_CTL29_LOWPOWER_EXTERNAL_CNT)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL29_LOWPOWER_EXTERNAL_CNT(v)   (HW_DRAM_CTL29.B.LOWPOWER_EXTERNAL_CNT = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DRAM_CTL30 - DRAM Control Register 30
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg16_t  LOWPOWER_POWER_DOWN_CNT;
        reg16_t  LOWPOWER_REFRESH_HOLD;
    } B;
} hw_dram_ctl30_t;
#endif


//
// constants & macros for entire HW_DRAM_CTL30 register
//

#define HW_DRAM_CTL30_ADDR      (REGS_DRAM_BASE + 0x00000078)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL30           (*(volatile hw_dram_ctl30_t *) HW_DRAM_CTL30_ADDR)
#define HW_DRAM_CTL30_RD()      (HW_DRAM_CTL30.U)
#define HW_DRAM_CTL30_WR(v)     (HW_DRAM_CTL30.U = (v))
#define HW_DRAM_CTL30_SET(v)    (HW_DRAM_CTL30_WR(HW_DRAM_CTL30_RD() |  (v)))
#define HW_DRAM_CTL30_CLR(v)    (HW_DRAM_CTL30_WR(HW_DRAM_CTL30_RD() & ~(v)))
#define HW_DRAM_CTL30_TOG(v)    (HW_DRAM_CTL30_WR(HW_DRAM_CTL30_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DRAM_CTL30 bitfields
//

//--- Register HW_DRAM_CTL30, field LOWPOWER_REFRESH_HOLD

#define BP_DRAM_CTL30_LOWPOWER_REFRESH_HOLD      16
#define BM_DRAM_CTL30_LOWPOWER_REFRESH_HOLD      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL30_LOWPOWER_REFRESH_HOLD(v)   ((((reg32_t) v) << 16) & BM_DRAM_CTL30_LOWPOWER_REFRESH_HOLD)
#else
#define BF_DRAM_CTL30_LOWPOWER_REFRESH_HOLD(v)   (((v) << 16) & BM_DRAM_CTL30_LOWPOWER_REFRESH_HOLD)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL30_LOWPOWER_REFRESH_HOLD(v)   (HW_DRAM_CTL30.B.LOWPOWER_REFRESH_HOLD = (v))
#endif

//--- Register HW_DRAM_CTL30, field LOWPOWER_POWER_DOWN_CNT

#define BP_DRAM_CTL30_LOWPOWER_POWER_DOWN_CNT      0
#define BM_DRAM_CTL30_LOWPOWER_POWER_DOWN_CNT      0x0000FFFF

#define BF_DRAM_CTL30_LOWPOWER_POWER_DOWN_CNT(v)   (((v) << 0) & BM_DRAM_CTL30_LOWPOWER_POWER_DOWN_CNT)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL30_LOWPOWER_POWER_DOWN_CNT(v)   (HW_DRAM_CTL30.B.LOWPOWER_POWER_DOWN_CNT = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DRAM_CTL31 - DRAM Control Register 31
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg16_t  LOWPOWER_SELF_REFRESH_CNT;
        reg16_t  TDLL;
    } B;
} hw_dram_ctl31_t;
#endif


//
// constants & macros for entire HW_DRAM_CTL31 register
//

#define HW_DRAM_CTL31_ADDR      (REGS_DRAM_BASE + 0x0000007C)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL31           (*(volatile hw_dram_ctl31_t *) HW_DRAM_CTL31_ADDR)
#define HW_DRAM_CTL31_RD()      (HW_DRAM_CTL31.U)
#define HW_DRAM_CTL31_WR(v)     (HW_DRAM_CTL31.U = (v))
#define HW_DRAM_CTL31_SET(v)    (HW_DRAM_CTL31_WR(HW_DRAM_CTL31_RD() |  (v)))
#define HW_DRAM_CTL31_CLR(v)    (HW_DRAM_CTL31_WR(HW_DRAM_CTL31_RD() & ~(v)))
#define HW_DRAM_CTL31_TOG(v)    (HW_DRAM_CTL31_WR(HW_DRAM_CTL31_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DRAM_CTL31 bitfields
//

//--- Register HW_DRAM_CTL31, field TDLL

#define BP_DRAM_CTL31_TDLL      16
#define BM_DRAM_CTL31_TDLL      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL31_TDLL(v)   ((((reg32_t) v) << 16) & BM_DRAM_CTL31_TDLL)
#else
#define BF_DRAM_CTL31_TDLL(v)   (((v) << 16) & BM_DRAM_CTL31_TDLL)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL31_TDLL(v)   (HW_DRAM_CTL31.B.TDLL = (v))
#endif

//--- Register HW_DRAM_CTL31, field LOWPOWER_SELF_REFRESH_CNT

#define BP_DRAM_CTL31_LOWPOWER_SELF_REFRESH_CNT      0
#define BM_DRAM_CTL31_LOWPOWER_SELF_REFRESH_CNT      0x0000FFFF

#define BF_DRAM_CTL31_LOWPOWER_SELF_REFRESH_CNT(v)   (((v) << 0) & BM_DRAM_CTL31_LOWPOWER_SELF_REFRESH_CNT)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL31_LOWPOWER_SELF_REFRESH_CNT(v)   (HW_DRAM_CTL31.B.LOWPOWER_SELF_REFRESH_CNT = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DRAM_CTL32 - DRAM Control Register 32
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg16_t  TRAS_MAX;
        reg16_t  TXSNR;
    } B;
} hw_dram_ctl32_t;
#endif


//
// constants & macros for entire HW_DRAM_CTL32 register
//

#define HW_DRAM_CTL32_ADDR      (REGS_DRAM_BASE + 0x00000080)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL32           (*(volatile hw_dram_ctl32_t *) HW_DRAM_CTL32_ADDR)
#define HW_DRAM_CTL32_RD()      (HW_DRAM_CTL32.U)
#define HW_DRAM_CTL32_WR(v)     (HW_DRAM_CTL32.U = (v))
#define HW_DRAM_CTL32_SET(v)    (HW_DRAM_CTL32_WR(HW_DRAM_CTL32_RD() |  (v)))
#define HW_DRAM_CTL32_CLR(v)    (HW_DRAM_CTL32_WR(HW_DRAM_CTL32_RD() & ~(v)))
#define HW_DRAM_CTL32_TOG(v)    (HW_DRAM_CTL32_WR(HW_DRAM_CTL32_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DRAM_CTL32 bitfields
//

//--- Register HW_DRAM_CTL32, field TXSNR

#define BP_DRAM_CTL32_TXSNR      16
#define BM_DRAM_CTL32_TXSNR      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL32_TXSNR(v)   ((((reg32_t) v) << 16) & BM_DRAM_CTL32_TXSNR)
#else
#define BF_DRAM_CTL32_TXSNR(v)   (((v) << 16) & BM_DRAM_CTL32_TXSNR)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL32_TXSNR(v)   (HW_DRAM_CTL32.B.TXSNR = (v))
#endif

//--- Register HW_DRAM_CTL32, field TRAS_MAX

#define BP_DRAM_CTL32_TRAS_MAX      0
#define BM_DRAM_CTL32_TRAS_MAX      0x0000FFFF

#define BF_DRAM_CTL32_TRAS_MAX(v)   (((v) << 0) & BM_DRAM_CTL32_TRAS_MAX)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL32_TRAS_MAX(v)   (HW_DRAM_CTL32.B.TRAS_MAX = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DRAM_CTL33 - DRAM Control Register 33
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg16_t  TXSR;
        reg16_t  VERSION;
    } B;
} hw_dram_ctl33_t;
#endif


//
// constants & macros for entire HW_DRAM_CTL33 register
//

#define HW_DRAM_CTL33_ADDR      (REGS_DRAM_BASE + 0x00000084)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL33           (*(volatile hw_dram_ctl33_t *) HW_DRAM_CTL33_ADDR)
#define HW_DRAM_CTL33_RD()      (HW_DRAM_CTL33.U)
#define HW_DRAM_CTL33_WR(v)     (HW_DRAM_CTL33.U = (v))
#define HW_DRAM_CTL33_SET(v)    (HW_DRAM_CTL33_WR(HW_DRAM_CTL33_RD() |  (v)))
#define HW_DRAM_CTL33_CLR(v)    (HW_DRAM_CTL33_WR(HW_DRAM_CTL33_RD() & ~(v)))
#define HW_DRAM_CTL33_TOG(v)    (HW_DRAM_CTL33_WR(HW_DRAM_CTL33_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DRAM_CTL33 bitfields
//

//--- Register HW_DRAM_CTL33, field VERSION

#define BP_DRAM_CTL33_VERSION      16
#define BM_DRAM_CTL33_VERSION      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL33_VERSION(v)   ((((reg32_t) v) << 16) & BM_DRAM_CTL33_VERSION)
#else
#define BF_DRAM_CTL33_VERSION(v)   (((v) << 16) & BM_DRAM_CTL33_VERSION)
#endif

//--- Register HW_DRAM_CTL33, field TXSR

#define BP_DRAM_CTL33_TXSR      0
#define BM_DRAM_CTL33_TXSR      0x0000FFFF

#define BF_DRAM_CTL33_TXSR(v)   (((v) << 0) & BM_DRAM_CTL33_TXSR)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL33_TXSR(v)   (HW_DRAM_CTL33.B.TXSR = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DRAM_CTL34 - DRAM Control Register 34
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned TINIT  : 24;
        reg8_t   RSVD1;
    } B;
} hw_dram_ctl34_t;
#endif


//
// constants & macros for entire HW_DRAM_CTL34 register
//

#define HW_DRAM_CTL34_ADDR      (REGS_DRAM_BASE + 0x00000088)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL34           (*(volatile hw_dram_ctl34_t *) HW_DRAM_CTL34_ADDR)
#define HW_DRAM_CTL34_RD()      (HW_DRAM_CTL34.U)
#define HW_DRAM_CTL34_WR(v)     (HW_DRAM_CTL34.U = (v))
#define HW_DRAM_CTL34_SET(v)    (HW_DRAM_CTL34_WR(HW_DRAM_CTL34_RD() |  (v)))
#define HW_DRAM_CTL34_CLR(v)    (HW_DRAM_CTL34_WR(HW_DRAM_CTL34_RD() & ~(v)))
#define HW_DRAM_CTL34_TOG(v)    (HW_DRAM_CTL34_WR(HW_DRAM_CTL34_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DRAM_CTL34 bitfields
//

//--- Register HW_DRAM_CTL34, field TINIT

#define BP_DRAM_CTL34_TINIT      0
#define BM_DRAM_CTL34_TINIT      0x00FFFFFF

#define BF_DRAM_CTL34_TINIT(v)   (((v) << 0) & BM_DRAM_CTL34_TINIT)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL34_TINIT(v)   BF_CS1(DRAM_CTL34, TINIT, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DRAM_CTL35 - DRAM Control Register 35
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned OUT_OF_RANGE_ADDR  : 31;
        unsigned RSVD1              :  1;
    } B;
} hw_dram_ctl35_t;
#endif


//
// constants & macros for entire HW_DRAM_CTL35 register
//

#define HW_DRAM_CTL35_ADDR      (REGS_DRAM_BASE + 0x0000008C)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL35           (*(volatile hw_dram_ctl35_t *) HW_DRAM_CTL35_ADDR)
#define HW_DRAM_CTL35_RD()      (HW_DRAM_CTL35.U)
#endif


//
// constants & macros for individual HW_DRAM_CTL35 bitfields
//

//--- Register HW_DRAM_CTL35, field OUT_OF_RANGE_ADDR

#define BP_DRAM_CTL35_OUT_OF_RANGE_ADDR      0
#define BM_DRAM_CTL35_OUT_OF_RANGE_ADDR      0x7FFFFFFF

#define BF_DRAM_CTL35_OUT_OF_RANGE_ADDR(v)   (((v) << 0) & BM_DRAM_CTL35_OUT_OF_RANGE_ADDR)


////////////////////////////////////////////////////////////////////////////////
//// HW_DRAM_CTL36 - DRAM Control Register 36
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ACTIVE_AGING           :  1;
        unsigned RSVD1                  :  7;
        unsigned BUS_SHARE_ENABLE       :  1;
        unsigned RSVD2                  :  7;
        unsigned ENABLE_QUICK_SREFRESH  :  1;
        unsigned RSVD3                  :  7;
        unsigned PWRUP_SREFRESH_EXIT    :  1;
        unsigned RSVD4                  :  7;
    } B;
} hw_dram_ctl36_t;
#endif


//
// constants & macros for entire HW_DRAM_CTL36 register
//

#define HW_DRAM_CTL36_ADDR      (REGS_DRAM_BASE + 0x00000090)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL36           (*(volatile hw_dram_ctl36_t *) HW_DRAM_CTL36_ADDR)
#define HW_DRAM_CTL36_RD()      (HW_DRAM_CTL36.U)
#define HW_DRAM_CTL36_WR(v)     (HW_DRAM_CTL36.U = (v))
#define HW_DRAM_CTL36_SET(v)    (HW_DRAM_CTL36_WR(HW_DRAM_CTL36_RD() |  (v)))
#define HW_DRAM_CTL36_CLR(v)    (HW_DRAM_CTL36_WR(HW_DRAM_CTL36_RD() & ~(v)))
#define HW_DRAM_CTL36_TOG(v)    (HW_DRAM_CTL36_WR(HW_DRAM_CTL36_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DRAM_CTL36 bitfields
//

//--- Register HW_DRAM_CTL36, field PWRUP_SREFRESH_EXIT

#define BP_DRAM_CTL36_PWRUP_SREFRESH_EXIT      24
#define BM_DRAM_CTL36_PWRUP_SREFRESH_EXIT      0x01000000

#define BF_DRAM_CTL36_PWRUP_SREFRESH_EXIT(v)   (((v) << 24) & BM_DRAM_CTL36_PWRUP_SREFRESH_EXIT)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL36_PWRUP_SREFRESH_EXIT(v)   BF_CS1(DRAM_CTL36, PWRUP_SREFRESH_EXIT, v)
#endif

//--- Register HW_DRAM_CTL36, field ENABLE_QUICK_SREFRESH

#define BP_DRAM_CTL36_ENABLE_QUICK_SREFRESH      16
#define BM_DRAM_CTL36_ENABLE_QUICK_SREFRESH      0x00010000

#define BF_DRAM_CTL36_ENABLE_QUICK_SREFRESH(v)   (((v) << 16) & BM_DRAM_CTL36_ENABLE_QUICK_SREFRESH)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL36_ENABLE_QUICK_SREFRESH(v)   BF_CS1(DRAM_CTL36, ENABLE_QUICK_SREFRESH, v)
#endif

//--- Register HW_DRAM_CTL36, field BUS_SHARE_ENABLE

#define BP_DRAM_CTL36_BUS_SHARE_ENABLE      8
#define BM_DRAM_CTL36_BUS_SHARE_ENABLE      0x00000100

#define BF_DRAM_CTL36_BUS_SHARE_ENABLE(v)   (((v) << 8) & BM_DRAM_CTL36_BUS_SHARE_ENABLE)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL36_BUS_SHARE_ENABLE(v)   BF_CS1(DRAM_CTL36, BUS_SHARE_ENABLE, v)
#endif

//--- Register HW_DRAM_CTL36, field ACTIVE_AGING

#define BP_DRAM_CTL36_ACTIVE_AGING      0
#define BM_DRAM_CTL36_ACTIVE_AGING      0x00000001

#define BF_DRAM_CTL36_ACTIVE_AGING(v)   (((v) << 0) & BM_DRAM_CTL36_ACTIVE_AGING)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL36_ACTIVE_AGING(v)   BF_CS1(DRAM_CTL36, ACTIVE_AGING, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DRAM_CTL37 - DRAM Control Register 37
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned TREF_ENABLE        :  1;
        unsigned RSVD1              :  7;
        unsigned BUS_SHARE_TIMEOUT  : 10;
        unsigned RSVD2              :  6;
        reg8_t   OBSOLETE;
    } B;
} hw_dram_ctl37_t;
#endif


//
// constants & macros for entire HW_DRAM_CTL37 register
//

#define HW_DRAM_CTL37_ADDR      (REGS_DRAM_BASE + 0x00000094)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL37           (*(volatile hw_dram_ctl37_t *) HW_DRAM_CTL37_ADDR)
#define HW_DRAM_CTL37_RD()      (HW_DRAM_CTL37.U)
#define HW_DRAM_CTL37_WR(v)     (HW_DRAM_CTL37.U = (v))
#define HW_DRAM_CTL37_SET(v)    (HW_DRAM_CTL37_WR(HW_DRAM_CTL37_RD() |  (v)))
#define HW_DRAM_CTL37_CLR(v)    (HW_DRAM_CTL37_WR(HW_DRAM_CTL37_RD() & ~(v)))
#define HW_DRAM_CTL37_TOG(v)    (HW_DRAM_CTL37_WR(HW_DRAM_CTL37_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DRAM_CTL37 bitfields
//

//--- Register HW_DRAM_CTL37, field BUS_SHARE_TIMEOUT

#define BP_DRAM_CTL37_BUS_SHARE_TIMEOUT      8
#define BM_DRAM_CTL37_BUS_SHARE_TIMEOUT      0x0003FF00

#define BF_DRAM_CTL37_BUS_SHARE_TIMEOUT(v)   (((v) << 8) & BM_DRAM_CTL37_BUS_SHARE_TIMEOUT)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL37_BUS_SHARE_TIMEOUT(v)   BF_CS1(DRAM_CTL37, BUS_SHARE_TIMEOUT, v)
#endif

//--- Register HW_DRAM_CTL37, field TREF_ENABLE

#define BP_DRAM_CTL37_TREF_ENABLE      0
#define BM_DRAM_CTL37_TREF_ENABLE      0x00000001

#define BF_DRAM_CTL37_TREF_ENABLE(v)   (((v) << 0) & BM_DRAM_CTL37_TREF_ENABLE)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL37_TREF_ENABLE(v)   BF_CS1(DRAM_CTL37, TREF_ENABLE, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DRAM_CTL38 - DRAM Control Register 38
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned EMRS1_DATA    : 13;
        unsigned RSVD1         :  3;
        unsigned EMRS2_DATA_0  : 13;
        unsigned RSVD2         :  3;
    } B;
} hw_dram_ctl38_t;
#endif


//
// constants & macros for entire HW_DRAM_CTL38 register
//

#define HW_DRAM_CTL38_ADDR      (REGS_DRAM_BASE + 0x00000098)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL38           (*(volatile hw_dram_ctl38_t *) HW_DRAM_CTL38_ADDR)
#define HW_DRAM_CTL38_RD()      (HW_DRAM_CTL38.U)
#define HW_DRAM_CTL38_WR(v)     (HW_DRAM_CTL38.U = (v))
#define HW_DRAM_CTL38_SET(v)    (HW_DRAM_CTL38_WR(HW_DRAM_CTL38_RD() |  (v)))
#define HW_DRAM_CTL38_CLR(v)    (HW_DRAM_CTL38_WR(HW_DRAM_CTL38_RD() & ~(v)))
#define HW_DRAM_CTL38_TOG(v)    (HW_DRAM_CTL38_WR(HW_DRAM_CTL38_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DRAM_CTL38 bitfields
//

//--- Register HW_DRAM_CTL38, field EMRS2_DATA_0

#define BP_DRAM_CTL38_EMRS2_DATA_0      16
#define BM_DRAM_CTL38_EMRS2_DATA_0      0x1FFF0000

#define BF_DRAM_CTL38_EMRS2_DATA_0(v)   (((v) << 16) & BM_DRAM_CTL38_EMRS2_DATA_0)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL38_EMRS2_DATA_0(v)   BF_CS1(DRAM_CTL38, EMRS2_DATA_0, v)
#endif

//--- Register HW_DRAM_CTL38, field EMRS1_DATA

#define BP_DRAM_CTL38_EMRS1_DATA      0
#define BM_DRAM_CTL38_EMRS1_DATA      0x00001FFF

#define BF_DRAM_CTL38_EMRS1_DATA(v)   (((v) << 0) & BM_DRAM_CTL38_EMRS1_DATA)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL38_EMRS1_DATA(v)   BF_CS1(DRAM_CTL38, EMRS1_DATA, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DRAM_CTL39 - DRAM Control Register 39
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned EMRS2_DATA_1  : 13;
        unsigned RSVD1         :  3;
        unsigned EMRS2_DATA_2  : 13;
        unsigned RSVD2         :  3;
    } B;
} hw_dram_ctl39_t;
#endif


//
// constants & macros for entire HW_DRAM_CTL39 register
//

#define HW_DRAM_CTL39_ADDR      (REGS_DRAM_BASE + 0x0000009C)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL39           (*(volatile hw_dram_ctl39_t *) HW_DRAM_CTL39_ADDR)
#define HW_DRAM_CTL39_RD()      (HW_DRAM_CTL39.U)
#define HW_DRAM_CTL39_WR(v)     (HW_DRAM_CTL39.U = (v))
#define HW_DRAM_CTL39_SET(v)    (HW_DRAM_CTL39_WR(HW_DRAM_CTL39_RD() |  (v)))
#define HW_DRAM_CTL39_CLR(v)    (HW_DRAM_CTL39_WR(HW_DRAM_CTL39_RD() & ~(v)))
#define HW_DRAM_CTL39_TOG(v)    (HW_DRAM_CTL39_WR(HW_DRAM_CTL39_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DRAM_CTL39 bitfields
//

//--- Register HW_DRAM_CTL39, field EMRS2_DATA_2

#define BP_DRAM_CTL39_EMRS2_DATA_2      16
#define BM_DRAM_CTL39_EMRS2_DATA_2      0x1FFF0000

#define BF_DRAM_CTL39_EMRS2_DATA_2(v)   (((v) << 16) & BM_DRAM_CTL39_EMRS2_DATA_2)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL39_EMRS2_DATA_2(v)   BF_CS1(DRAM_CTL39, EMRS2_DATA_2, v)
#endif

//--- Register HW_DRAM_CTL39, field EMRS2_DATA_1

#define BP_DRAM_CTL39_EMRS2_DATA_1      0
#define BM_DRAM_CTL39_EMRS2_DATA_1      0x00001FFF

#define BF_DRAM_CTL39_EMRS2_DATA_1(v)   (((v) << 0) & BM_DRAM_CTL39_EMRS2_DATA_1)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL39_EMRS2_DATA_1(v)   BF_CS1(DRAM_CTL39, EMRS2_DATA_1, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_DRAM_CTL40 - DRAM Control Register 40
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned EMRS2_DATA_3  : 13;
        unsigned RSVD1         :  3;
        reg16_t  TPDEX;
    } B;
} hw_dram_ctl40_t;
#endif


//
// constants & macros for entire HW_DRAM_CTL40 register
//

#define HW_DRAM_CTL40_ADDR      (REGS_DRAM_BASE + 0x000000A0)

#ifndef __LANGUAGE_ASM__
#define HW_DRAM_CTL40           (*(volatile hw_dram_ctl40_t *) HW_DRAM_CTL40_ADDR)
#define HW_DRAM_CTL40_RD()      (HW_DRAM_CTL40.U)
#define HW_DRAM_CTL40_WR(v)     (HW_DRAM_CTL40.U = (v))
#define HW_DRAM_CTL40_SET(v)    (HW_DRAM_CTL40_WR(HW_DRAM_CTL40_RD() |  (v)))
#define HW_DRAM_CTL40_CLR(v)    (HW_DRAM_CTL40_WR(HW_DRAM_CTL40_RD() & ~(v)))
#define HW_DRAM_CTL40_TOG(v)    (HW_DRAM_CTL40_WR(HW_DRAM_CTL40_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_DRAM_CTL40 bitfields
//

//--- Register HW_DRAM_CTL40, field TPDEX

#define BP_DRAM_CTL40_TPDEX      16
#define BM_DRAM_CTL40_TPDEX      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_DRAM_CTL40_TPDEX(v)   ((((reg32_t) v) << 16) & BM_DRAM_CTL40_TPDEX)
#else
#define BF_DRAM_CTL40_TPDEX(v)   (((v) << 16) & BM_DRAM_CTL40_TPDEX)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL40_TPDEX(v)   (HW_DRAM_CTL40.B.TPDEX = (v))
#endif

//--- Register HW_DRAM_CTL40, field EMRS2_DATA_3

#define BP_DRAM_CTL40_EMRS2_DATA_3      0
#define BM_DRAM_CTL40_EMRS2_DATA_3      0x00001FFF

#define BF_DRAM_CTL40_EMRS2_DATA_3(v)   (((v) << 0) & BM_DRAM_CTL40_EMRS2_DATA_3)

#ifndef __LANGUAGE_ASM__
#define BW_DRAM_CTL40_EMRS2_DATA_3(v)   BF_CS1(DRAM_CTL40, EMRS2_DATA_3, v)
#endif


#endif // _REGSDRAM_H

////////////////////////////////////////////////////////////////////////////////
