/*
 * Copyright 2009 Freescale Semiconductor, Inc. All Rights Reserved.
 */

/*
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 */
////////////////////////////////////////////////////////////////////////////////
//
// WARNING!  THIS FILE IS AUTOMATICALLY GENERATED FROM XML.
//                DO NOT MODIFY THIS FILE DIRECTLY.
//
////////////////////////////////////////////////////////////////////////////////
//
// The following naming conventions are followed in this file.
//      XX_<module>_<regname>_<field>
//
// XX specifies the define / macro class
//      HW pertains to a register
//      BM indicates a Bit Mask
//      BF indicates a Bit Field macro
//
// <module> is the hardware module name which can be any of the following...
//      USB20 (Note when there is more than one copy of a given module, the
//      module name includes a number starting from 0 for the first instance
//      of that module)
//
// <regname> is the specific register within that module
//
// <field> is the specific bitfield within that <module>_<register>
//
// We also define the following...
//      hw_<module>_<regname>_t is typedef of anonymous union
//
////////////////////////////////////////////////////////////////////////////////

#ifndef _REGSIR_H
#define _REGSIR_H  1

#include "regs.h"

#ifndef REGS_IR_BASE
#define REGS_IR_BASE (REGS_BASE + 0x00078000)
#endif

////////////////////////////////////////////////////////////////////////////////
//// HW_IR_CTRL - IR Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RXEN         :  1;
        unsigned TXEN         :  1;
        unsigned TCEN         :  1;
        unsigned SIPEN        :  1;
        unsigned SIR_GAP      :  3;
        unsigned TC_TYPE      :  1;
        unsigned TC_TIME_DIV  :  6;
        unsigned RSVD1        :  5;
        unsigned SPEED        :  3;
        unsigned MODE         :  2;
        unsigned MTA          :  3;
        unsigned RSVD2        :  3;
        unsigned CLKGATE      :  1;
        unsigned SFTRST       :  1;
    } B;
} hw_ir_ctrl_t;
#endif


//
// constants & macros for entire HW_IR_CTRL register
//

#define HW_IR_CTRL_ADDR      (REGS_IR_BASE + 0x00000000)
#define HW_IR_CTRL_SET_ADDR  (REGS_IR_BASE + 0x00000004)
#define HW_IR_CTRL_CLR_ADDR  (REGS_IR_BASE + 0x00000008)
#define HW_IR_CTRL_TOG_ADDR  (REGS_IR_BASE + 0x0000000C)

#ifndef __LANGUAGE_ASM__
#define HW_IR_CTRL           (*(volatile hw_ir_ctrl_t *) HW_IR_CTRL_ADDR)
#define HW_IR_CTRL_RD()      (HW_IR_CTRL.U)
#define HW_IR_CTRL_WR(v)     (HW_IR_CTRL.U = (v))
#define HW_IR_CTRL_SET(v)    ((*(volatile reg32_t *) HW_IR_CTRL_SET_ADDR) = (v))
#define HW_IR_CTRL_CLR(v)    ((*(volatile reg32_t *) HW_IR_CTRL_CLR_ADDR) = (v))
#define HW_IR_CTRL_TOG(v)    ((*(volatile reg32_t *) HW_IR_CTRL_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_IR_CTRL bitfields
//

//--- Register HW_IR_CTRL, field SFTRST

#define BP_IR_CTRL_SFTRST      31
#define BM_IR_CTRL_SFTRST      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_IR_CTRL_SFTRST(v)   ((((reg32_t) v) << 31) & BM_IR_CTRL_SFTRST)
#else
#define BF_IR_CTRL_SFTRST(v)   (((v) << 31) & BM_IR_CTRL_SFTRST)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_IR_CTRL_SFTRST(v)   BF_CS1(IR_CTRL, SFTRST, v)
#endif

#define BV_IR_CTRL_SFTRST__RUN    0x0
#define BV_IR_CTRL_SFTRST__RESET  0x1

//--- Register HW_IR_CTRL, field CLKGATE

#define BP_IR_CTRL_CLKGATE      30
#define BM_IR_CTRL_CLKGATE      0x40000000

#define BF_IR_CTRL_CLKGATE(v)   (((v) << 30) & BM_IR_CTRL_CLKGATE)

#ifndef __LANGUAGE_ASM__
#define BW_IR_CTRL_CLKGATE(v)   BF_CS1(IR_CTRL, CLKGATE, v)
#endif

//--- Register HW_IR_CTRL, field MTA

#define BP_IR_CTRL_MTA      24
#define BM_IR_CTRL_MTA      0x07000000

#define BF_IR_CTRL_MTA(v)   (((v) << 24) & BM_IR_CTRL_MTA)

#ifndef __LANGUAGE_ASM__
#define BW_IR_CTRL_MTA(v)   BF_CS1(IR_CTRL, MTA, v)
#endif

#define BV_IR_CTRL_MTA__MTA_10MS   0x0
#define BV_IR_CTRL_MTA__MTA_5MS    0x1
#define BV_IR_CTRL_MTA__MTA_1MS    0x2
#define BV_IR_CTRL_MTA__MTA_500US  0x3
#define BV_IR_CTRL_MTA__MTA_100US  0x4
#define BV_IR_CTRL_MTA__MTA_50US   0x5
#define BV_IR_CTRL_MTA__MTA_10US   0x6
#define BV_IR_CTRL_MTA__MTA_0      0x7

//--- Register HW_IR_CTRL, field MODE

#define BP_IR_CTRL_MODE      22
#define BM_IR_CTRL_MODE      0x00C00000

#define BF_IR_CTRL_MODE(v)   (((v) << 22) & BM_IR_CTRL_MODE)

#ifndef __LANGUAGE_ASM__
#define BW_IR_CTRL_MODE(v)   BF_CS1(IR_CTRL, MODE, v)
#endif

#define BV_IR_CTRL_MODE__SIR   0x0
#define BV_IR_CTRL_MODE__MIR   0x1
#define BV_IR_CTRL_MODE__FIR   0x2
#define BV_IR_CTRL_MODE__VFIR  0x3

//--- Register HW_IR_CTRL, field SPEED

#define BP_IR_CTRL_SPEED      19
#define BM_IR_CTRL_SPEED      0x00380000

#define BF_IR_CTRL_SPEED(v)   (((v) << 19) & BM_IR_CTRL_SPEED)

#ifndef __LANGUAGE_ASM__
#define BW_IR_CTRL_SPEED(v)   BF_CS1(IR_CTRL, SPEED, v)
#endif

#define BV_IR_CTRL_SPEED__SPD000  0x0
#define BV_IR_CTRL_SPEED__SPD001  0x1
#define BV_IR_CTRL_SPEED__SPD010  0x2
#define BV_IR_CTRL_SPEED__SPD011  0x3
#define BV_IR_CTRL_SPEED__SPD100  0x4
#define BV_IR_CTRL_SPEED__SPD101  0x5

//--- Register HW_IR_CTRL, field TC_TIME_DIV

#define BP_IR_CTRL_TC_TIME_DIV      8
#define BM_IR_CTRL_TC_TIME_DIV      0x00003F00

#define BF_IR_CTRL_TC_TIME_DIV(v)   (((v) << 8) & BM_IR_CTRL_TC_TIME_DIV)

#ifndef __LANGUAGE_ASM__
#define BW_IR_CTRL_TC_TIME_DIV(v)   BF_CS1(IR_CTRL, TC_TIME_DIV, v)
#endif

//--- Register HW_IR_CTRL, field TC_TYPE

#define BP_IR_CTRL_TC_TYPE      7
#define BM_IR_CTRL_TC_TYPE      0x00000080

#define BF_IR_CTRL_TC_TYPE(v)   (((v) << 7) & BM_IR_CTRL_TC_TYPE)

#ifndef __LANGUAGE_ASM__
#define BW_IR_CTRL_TC_TYPE(v)   BF_CS1(IR_CTRL, TC_TYPE, v)
#endif

//--- Register HW_IR_CTRL, field SIR_GAP

#define BP_IR_CTRL_SIR_GAP      4
#define BM_IR_CTRL_SIR_GAP      0x00000070

#define BF_IR_CTRL_SIR_GAP(v)   (((v) << 4) & BM_IR_CTRL_SIR_GAP)

#ifndef __LANGUAGE_ASM__
#define BW_IR_CTRL_SIR_GAP(v)   BF_CS1(IR_CTRL, SIR_GAP, v)
#endif

#define BV_IR_CTRL_SIR_GAP__GAP_10K  0x0
#define BV_IR_CTRL_SIR_GAP__GAP_5K   0x1
#define BV_IR_CTRL_SIR_GAP__GAP_1K   0x2
#define BV_IR_CTRL_SIR_GAP__GAP_500  0x3
#define BV_IR_CTRL_SIR_GAP__GAP_100  0x4
#define BV_IR_CTRL_SIR_GAP__GAP_50   0x5
#define BV_IR_CTRL_SIR_GAP__GAP_10   0x6
#define BV_IR_CTRL_SIR_GAP__GAP_0    0x7

//--- Register HW_IR_CTRL, field SIPEN

#define BP_IR_CTRL_SIPEN      3
#define BM_IR_CTRL_SIPEN      0x00000008

#define BF_IR_CTRL_SIPEN(v)   (((v) << 3) & BM_IR_CTRL_SIPEN)

#ifndef __LANGUAGE_ASM__
#define BW_IR_CTRL_SIPEN(v)   BF_CS1(IR_CTRL, SIPEN, v)
#endif

//--- Register HW_IR_CTRL, field TCEN

#define BP_IR_CTRL_TCEN      2
#define BM_IR_CTRL_TCEN      0x00000004

#define BF_IR_CTRL_TCEN(v)   (((v) << 2) & BM_IR_CTRL_TCEN)

#ifndef __LANGUAGE_ASM__
#define BW_IR_CTRL_TCEN(v)   BF_CS1(IR_CTRL, TCEN, v)
#endif

//--- Register HW_IR_CTRL, field TXEN

#define BP_IR_CTRL_TXEN      1
#define BM_IR_CTRL_TXEN      0x00000002

#define BF_IR_CTRL_TXEN(v)   (((v) << 1) & BM_IR_CTRL_TXEN)

#ifndef __LANGUAGE_ASM__
#define BW_IR_CTRL_TXEN(v)   BF_CS1(IR_CTRL, TXEN, v)
#endif

//--- Register HW_IR_CTRL, field RXEN

#define BP_IR_CTRL_RXEN      0
#define BM_IR_CTRL_RXEN      0x00000001

#define BF_IR_CTRL_RXEN(v)   (((v) << 0) & BM_IR_CTRL_RXEN)

#ifndef __LANGUAGE_ASM__
#define BW_IR_CTRL_RXEN(v)   BF_CS1(IR_CTRL, RXEN, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_IR_TXDMA - IR Transmit DMA Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned XFER_COUNT  : 12;
        unsigned XBOFS       :  6;
        unsigned BOF_TYPE    :  1;
        unsigned NEW_SPEED   :  3;
        unsigned NEW_MODE    :  2;
        unsigned NEW_MTA     :  3;
        unsigned CHANGE      :  1;
        unsigned INT         :  1;
        unsigned EMPTY       :  1;
        unsigned RSVD2       :  1;
        unsigned RUN         :  1;
    } B;
} hw_ir_txdma_t;
#endif


//
// constants & macros for entire HW_IR_TXDMA register
//

#define HW_IR_TXDMA_ADDR      (REGS_IR_BASE + 0x00000010)
#define HW_IR_TXDMA_SET_ADDR  (REGS_IR_BASE + 0x00000014)
#define HW_IR_TXDMA_CLR_ADDR  (REGS_IR_BASE + 0x00000018)
#define HW_IR_TXDMA_TOG_ADDR  (REGS_IR_BASE + 0x0000001C)

#ifndef __LANGUAGE_ASM__
#define HW_IR_TXDMA           (*(volatile hw_ir_txdma_t *) HW_IR_TXDMA_ADDR)
#define HW_IR_TXDMA_RD()      (HW_IR_TXDMA.U)
#define HW_IR_TXDMA_WR(v)     (HW_IR_TXDMA.U = (v))
#define HW_IR_TXDMA_SET(v)    ((*(volatile reg32_t *) HW_IR_TXDMA_SET_ADDR) = (v))
#define HW_IR_TXDMA_CLR(v)    ((*(volatile reg32_t *) HW_IR_TXDMA_CLR_ADDR) = (v))
#define HW_IR_TXDMA_TOG(v)    ((*(volatile reg32_t *) HW_IR_TXDMA_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_IR_TXDMA bitfields
//

//--- Register HW_IR_TXDMA, field RUN

#define BP_IR_TXDMA_RUN      31
#define BM_IR_TXDMA_RUN      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_IR_TXDMA_RUN(v)   ((((reg32_t) v) << 31) & BM_IR_TXDMA_RUN)
#else
#define BF_IR_TXDMA_RUN(v)   (((v) << 31) & BM_IR_TXDMA_RUN)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_IR_TXDMA_RUN(v)   BF_CS1(IR_TXDMA, RUN, v)
#endif

//--- Register HW_IR_TXDMA, field EMPTY

#define BP_IR_TXDMA_EMPTY      29
#define BM_IR_TXDMA_EMPTY      0x20000000

#define BF_IR_TXDMA_EMPTY(v)   (((v) << 29) & BM_IR_TXDMA_EMPTY)

#ifndef __LANGUAGE_ASM__
#define BW_IR_TXDMA_EMPTY(v)   BF_CS1(IR_TXDMA, EMPTY, v)
#endif

//--- Register HW_IR_TXDMA, field INT

#define BP_IR_TXDMA_INT      28
#define BM_IR_TXDMA_INT      0x10000000

#define BF_IR_TXDMA_INT(v)   (((v) << 28) & BM_IR_TXDMA_INT)

#ifndef __LANGUAGE_ASM__
#define BW_IR_TXDMA_INT(v)   BF_CS1(IR_TXDMA, INT, v)
#endif

//--- Register HW_IR_TXDMA, field CHANGE

#define BP_IR_TXDMA_CHANGE      27
#define BM_IR_TXDMA_CHANGE      0x08000000

#define BF_IR_TXDMA_CHANGE(v)   (((v) << 27) & BM_IR_TXDMA_CHANGE)

#ifndef __LANGUAGE_ASM__
#define BW_IR_TXDMA_CHANGE(v)   BF_CS1(IR_TXDMA, CHANGE, v)
#endif

//--- Register HW_IR_TXDMA, field NEW_MTA

#define BP_IR_TXDMA_NEW_MTA      24
#define BM_IR_TXDMA_NEW_MTA      0x07000000

#define BF_IR_TXDMA_NEW_MTA(v)   (((v) << 24) & BM_IR_TXDMA_NEW_MTA)

#ifndef __LANGUAGE_ASM__
#define BW_IR_TXDMA_NEW_MTA(v)   BF_CS1(IR_TXDMA, NEW_MTA, v)
#endif

//--- Register HW_IR_TXDMA, field NEW_MODE

#define BP_IR_TXDMA_NEW_MODE      22
#define BM_IR_TXDMA_NEW_MODE      0x00C00000

#define BF_IR_TXDMA_NEW_MODE(v)   (((v) << 22) & BM_IR_TXDMA_NEW_MODE)

#ifndef __LANGUAGE_ASM__
#define BW_IR_TXDMA_NEW_MODE(v)   BF_CS1(IR_TXDMA, NEW_MODE, v)
#endif

//--- Register HW_IR_TXDMA, field NEW_SPEED

#define BP_IR_TXDMA_NEW_SPEED      19
#define BM_IR_TXDMA_NEW_SPEED      0x00380000

#define BF_IR_TXDMA_NEW_SPEED(v)   (((v) << 19) & BM_IR_TXDMA_NEW_SPEED)

#ifndef __LANGUAGE_ASM__
#define BW_IR_TXDMA_NEW_SPEED(v)   BF_CS1(IR_TXDMA, NEW_SPEED, v)
#endif

//--- Register HW_IR_TXDMA, field BOF_TYPE

#define BP_IR_TXDMA_BOF_TYPE      18
#define BM_IR_TXDMA_BOF_TYPE      0x00040000

#define BF_IR_TXDMA_BOF_TYPE(v)   (((v) << 18) & BM_IR_TXDMA_BOF_TYPE)

#ifndef __LANGUAGE_ASM__
#define BW_IR_TXDMA_BOF_TYPE(v)   BF_CS1(IR_TXDMA, BOF_TYPE, v)
#endif

//--- Register HW_IR_TXDMA, field XBOFS

#define BP_IR_TXDMA_XBOFS      12
#define BM_IR_TXDMA_XBOFS      0x0003F000

#define BF_IR_TXDMA_XBOFS(v)   (((v) << 12) & BM_IR_TXDMA_XBOFS)

#ifndef __LANGUAGE_ASM__
#define BW_IR_TXDMA_XBOFS(v)   BF_CS1(IR_TXDMA, XBOFS, v)
#endif

//--- Register HW_IR_TXDMA, field XFER_COUNT

#define BP_IR_TXDMA_XFER_COUNT      0
#define BM_IR_TXDMA_XFER_COUNT      0x00000FFF

#define BF_IR_TXDMA_XFER_COUNT(v)   (((v) << 0) & BM_IR_TXDMA_XFER_COUNT)

#ifndef __LANGUAGE_ASM__
#define BW_IR_TXDMA_XFER_COUNT(v)   BF_CS1(IR_TXDMA, XFER_COUNT, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_IR_RXDMA - IR Receive DMA Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned XFER_COUNT  : 10;
        unsigned RSVD        : 21;
        unsigned RUN         :  1;
    } B;
} hw_ir_rxdma_t;
#endif


//
// constants & macros for entire HW_IR_RXDMA register
//

#define HW_IR_RXDMA_ADDR      (REGS_IR_BASE + 0x00000020)
#define HW_IR_RXDMA_SET_ADDR  (REGS_IR_BASE + 0x00000024)
#define HW_IR_RXDMA_CLR_ADDR  (REGS_IR_BASE + 0x00000028)
#define HW_IR_RXDMA_TOG_ADDR  (REGS_IR_BASE + 0x0000002C)

#ifndef __LANGUAGE_ASM__
#define HW_IR_RXDMA           (*(volatile hw_ir_rxdma_t *) HW_IR_RXDMA_ADDR)
#define HW_IR_RXDMA_RD()      (HW_IR_RXDMA.U)
#define HW_IR_RXDMA_WR(v)     (HW_IR_RXDMA.U = (v))
#define HW_IR_RXDMA_SET(v)    ((*(volatile reg32_t *) HW_IR_RXDMA_SET_ADDR) = (v))
#define HW_IR_RXDMA_CLR(v)    ((*(volatile reg32_t *) HW_IR_RXDMA_CLR_ADDR) = (v))
#define HW_IR_RXDMA_TOG(v)    ((*(volatile reg32_t *) HW_IR_RXDMA_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_IR_RXDMA bitfields
//

//--- Register HW_IR_RXDMA, field RUN

#define BP_IR_RXDMA_RUN      31
#define BM_IR_RXDMA_RUN      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_IR_RXDMA_RUN(v)   ((((reg32_t) v) << 31) & BM_IR_RXDMA_RUN)
#else
#define BF_IR_RXDMA_RUN(v)   (((v) << 31) & BM_IR_RXDMA_RUN)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_IR_RXDMA_RUN(v)   BF_CS1(IR_RXDMA, RUN, v)
#endif

//--- Register HW_IR_RXDMA, field XFER_COUNT

#define BP_IR_RXDMA_XFER_COUNT      0
#define BM_IR_RXDMA_XFER_COUNT      0x000003FF

#define BF_IR_RXDMA_XFER_COUNT(v)   (((v) << 0) & BM_IR_RXDMA_XFER_COUNT)

#ifndef __LANGUAGE_ASM__
#define BW_IR_RXDMA_XFER_COUNT(v)   BF_CS1(IR_RXDMA, XFER_COUNT, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_IR_DBGCTRL - IR Debug Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned MIO_EN       :  1;
        unsigned MIO_SCLK     :  1;
        unsigned MIO_TX       :  1;
        unsigned MIO_RX       :  1;
        unsigned DUPLEX       :  1;
        unsigned INTLOOPBACK  :  1;
        unsigned TXINVERT     :  1;
        unsigned TXCRCOFF     :  1;
        unsigned TXFRMOFF     :  1;
        unsigned RXINVERT     :  1;
        unsigned RXCRCOFF     :  1;
        unsigned RXFRMOFF     :  1;
        unsigned VFIRSWZ      :  1;
        unsigned RSVD2        : 19;
    } B;
} hw_ir_dbgctrl_t;
#endif


//
// constants & macros for entire HW_IR_DBGCTRL register
//

#define HW_IR_DBGCTRL_ADDR      (REGS_IR_BASE + 0x00000030)
#define HW_IR_DBGCTRL_SET_ADDR  (REGS_IR_BASE + 0x00000034)
#define HW_IR_DBGCTRL_CLR_ADDR  (REGS_IR_BASE + 0x00000038)
#define HW_IR_DBGCTRL_TOG_ADDR  (REGS_IR_BASE + 0x0000003C)

#ifndef __LANGUAGE_ASM__
#define HW_IR_DBGCTRL           (*(volatile hw_ir_dbgctrl_t *) HW_IR_DBGCTRL_ADDR)
#define HW_IR_DBGCTRL_RD()      (HW_IR_DBGCTRL.U)
#define HW_IR_DBGCTRL_WR(v)     (HW_IR_DBGCTRL.U = (v))
#define HW_IR_DBGCTRL_SET(v)    ((*(volatile reg32_t *) HW_IR_DBGCTRL_SET_ADDR) = (v))
#define HW_IR_DBGCTRL_CLR(v)    ((*(volatile reg32_t *) HW_IR_DBGCTRL_CLR_ADDR) = (v))
#define HW_IR_DBGCTRL_TOG(v)    ((*(volatile reg32_t *) HW_IR_DBGCTRL_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_IR_DBGCTRL bitfields
//

//--- Register HW_IR_DBGCTRL, field VFIRSWZ

#define BP_IR_DBGCTRL_VFIRSWZ      12
#define BM_IR_DBGCTRL_VFIRSWZ      0x00001000

#define BF_IR_DBGCTRL_VFIRSWZ(v)   (((v) << 12) & BM_IR_DBGCTRL_VFIRSWZ)

#ifndef __LANGUAGE_ASM__
#define BW_IR_DBGCTRL_VFIRSWZ(v)   BF_CS1(IR_DBGCTRL, VFIRSWZ, v)
#endif

#define BV_IR_DBGCTRL_VFIRSWZ__NORMAL  0
#define BV_IR_DBGCTRL_VFIRSWZ__SWAP    1

//--- Register HW_IR_DBGCTRL, field RXFRMOFF

#define BP_IR_DBGCTRL_RXFRMOFF      11
#define BM_IR_DBGCTRL_RXFRMOFF      0x00000800

#define BF_IR_DBGCTRL_RXFRMOFF(v)   (((v) << 11) & BM_IR_DBGCTRL_RXFRMOFF)

#ifndef __LANGUAGE_ASM__
#define BW_IR_DBGCTRL_RXFRMOFF(v)   BF_CS1(IR_DBGCTRL, RXFRMOFF, v)
#endif

//--- Register HW_IR_DBGCTRL, field RXCRCOFF

#define BP_IR_DBGCTRL_RXCRCOFF      10
#define BM_IR_DBGCTRL_RXCRCOFF      0x00000400

#define BF_IR_DBGCTRL_RXCRCOFF(v)   (((v) << 10) & BM_IR_DBGCTRL_RXCRCOFF)

#ifndef __LANGUAGE_ASM__
#define BW_IR_DBGCTRL_RXCRCOFF(v)   BF_CS1(IR_DBGCTRL, RXCRCOFF, v)
#endif

//--- Register HW_IR_DBGCTRL, field RXINVERT

#define BP_IR_DBGCTRL_RXINVERT      9
#define BM_IR_DBGCTRL_RXINVERT      0x00000200

#define BF_IR_DBGCTRL_RXINVERT(v)   (((v) << 9) & BM_IR_DBGCTRL_RXINVERT)

#ifndef __LANGUAGE_ASM__
#define BW_IR_DBGCTRL_RXINVERT(v)   BF_CS1(IR_DBGCTRL, RXINVERT, v)
#endif

//--- Register HW_IR_DBGCTRL, field TXFRMOFF

#define BP_IR_DBGCTRL_TXFRMOFF      8
#define BM_IR_DBGCTRL_TXFRMOFF      0x00000100

#define BF_IR_DBGCTRL_TXFRMOFF(v)   (((v) << 8) & BM_IR_DBGCTRL_TXFRMOFF)

#ifndef __LANGUAGE_ASM__
#define BW_IR_DBGCTRL_TXFRMOFF(v)   BF_CS1(IR_DBGCTRL, TXFRMOFF, v)
#endif

//--- Register HW_IR_DBGCTRL, field TXCRCOFF

#define BP_IR_DBGCTRL_TXCRCOFF      7
#define BM_IR_DBGCTRL_TXCRCOFF      0x00000080

#define BF_IR_DBGCTRL_TXCRCOFF(v)   (((v) << 7) & BM_IR_DBGCTRL_TXCRCOFF)

#ifndef __LANGUAGE_ASM__
#define BW_IR_DBGCTRL_TXCRCOFF(v)   BF_CS1(IR_DBGCTRL, TXCRCOFF, v)
#endif

//--- Register HW_IR_DBGCTRL, field TXINVERT

#define BP_IR_DBGCTRL_TXINVERT      6
#define BM_IR_DBGCTRL_TXINVERT      0x00000040

#define BF_IR_DBGCTRL_TXINVERT(v)   (((v) << 6) & BM_IR_DBGCTRL_TXINVERT)

#ifndef __LANGUAGE_ASM__
#define BW_IR_DBGCTRL_TXINVERT(v)   BF_CS1(IR_DBGCTRL, TXINVERT, v)
#endif

//--- Register HW_IR_DBGCTRL, field INTLOOPBACK

#define BP_IR_DBGCTRL_INTLOOPBACK      5
#define BM_IR_DBGCTRL_INTLOOPBACK      0x00000020

#define BF_IR_DBGCTRL_INTLOOPBACK(v)   (((v) << 5) & BM_IR_DBGCTRL_INTLOOPBACK)

#ifndef __LANGUAGE_ASM__
#define BW_IR_DBGCTRL_INTLOOPBACK(v)   BF_CS1(IR_DBGCTRL, INTLOOPBACK, v)
#endif

//--- Register HW_IR_DBGCTRL, field DUPLEX

#define BP_IR_DBGCTRL_DUPLEX      4
#define BM_IR_DBGCTRL_DUPLEX      0x00000010

#define BF_IR_DBGCTRL_DUPLEX(v)   (((v) << 4) & BM_IR_DBGCTRL_DUPLEX)

#ifndef __LANGUAGE_ASM__
#define BW_IR_DBGCTRL_DUPLEX(v)   BF_CS1(IR_DBGCTRL, DUPLEX, v)
#endif

//--- Register HW_IR_DBGCTRL, field MIO_RX

#define BP_IR_DBGCTRL_MIO_RX      3
#define BM_IR_DBGCTRL_MIO_RX      0x00000008

#define BF_IR_DBGCTRL_MIO_RX(v)   (((v) << 3) & BM_IR_DBGCTRL_MIO_RX)

//--- Register HW_IR_DBGCTRL, field MIO_TX

#define BP_IR_DBGCTRL_MIO_TX      2
#define BM_IR_DBGCTRL_MIO_TX      0x00000004

#define BF_IR_DBGCTRL_MIO_TX(v)   (((v) << 2) & BM_IR_DBGCTRL_MIO_TX)

#ifndef __LANGUAGE_ASM__
#define BW_IR_DBGCTRL_MIO_TX(v)   BF_CS1(IR_DBGCTRL, MIO_TX, v)
#endif

//--- Register HW_IR_DBGCTRL, field MIO_SCLK

#define BP_IR_DBGCTRL_MIO_SCLK      1
#define BM_IR_DBGCTRL_MIO_SCLK      0x00000002

#define BF_IR_DBGCTRL_MIO_SCLK(v)   (((v) << 1) & BM_IR_DBGCTRL_MIO_SCLK)

#ifndef __LANGUAGE_ASM__
#define BW_IR_DBGCTRL_MIO_SCLK(v)   BF_CS1(IR_DBGCTRL, MIO_SCLK, v)
#endif

//--- Register HW_IR_DBGCTRL, field MIO_EN

#define BP_IR_DBGCTRL_MIO_EN      0
#define BM_IR_DBGCTRL_MIO_EN      0x00000001

#define BF_IR_DBGCTRL_MIO_EN(v)   (((v) << 0) & BM_IR_DBGCTRL_MIO_EN)

#ifndef __LANGUAGE_ASM__
#define BW_IR_DBGCTRL_MIO_EN(v)   BF_CS1(IR_DBGCTRL, MIO_EN, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_IR_INTR - IR Interrupt Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned TX_IRQ          :  1;
        unsigned RX_IRQ          :  1;
        unsigned TC_IRQ          :  1;
        unsigned TXUF_IRQ        :  1;
        unsigned RXOF_IRQ        :  1;
        unsigned SPEED_IRQ       :  1;
        unsigned RXABORT_IRQ     :  1;
        unsigned RSVD1           :  9;
        unsigned TX_IRQ_EN       :  1;
        unsigned RX_IRQ_EN       :  1;
        unsigned TC_IRQ_EN       :  1;
        unsigned TXUF_IRQ_EN     :  1;
        unsigned RXOF_IRQ_EN     :  1;
        unsigned SPEED_IRQ_EN    :  1;
        unsigned RXABORT_IRQ_EN  :  1;
        unsigned RSVD2           :  9;
    } B;
} hw_ir_intr_t;
#endif


//
// constants & macros for entire HW_IR_INTR register
//

#define HW_IR_INTR_ADDR      (REGS_IR_BASE + 0x00000040)
#define HW_IR_INTR_SET_ADDR  (REGS_IR_BASE + 0x00000044)
#define HW_IR_INTR_CLR_ADDR  (REGS_IR_BASE + 0x00000048)
#define HW_IR_INTR_TOG_ADDR  (REGS_IR_BASE + 0x0000004C)

#ifndef __LANGUAGE_ASM__
#define HW_IR_INTR           (*(volatile hw_ir_intr_t *) HW_IR_INTR_ADDR)
#define HW_IR_INTR_RD()      (HW_IR_INTR.U)
#define HW_IR_INTR_WR(v)     (HW_IR_INTR.U = (v))
#define HW_IR_INTR_SET(v)    ((*(volatile reg32_t *) HW_IR_INTR_SET_ADDR) = (v))
#define HW_IR_INTR_CLR(v)    ((*(volatile reg32_t *) HW_IR_INTR_CLR_ADDR) = (v))
#define HW_IR_INTR_TOG(v)    ((*(volatile reg32_t *) HW_IR_INTR_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_IR_INTR bitfields
//

//--- Register HW_IR_INTR, field RXABORT_IRQ_EN

#define BP_IR_INTR_RXABORT_IRQ_EN      22
#define BM_IR_INTR_RXABORT_IRQ_EN      0x00400000

#define BF_IR_INTR_RXABORT_IRQ_EN(v)   (((v) << 22) & BM_IR_INTR_RXABORT_IRQ_EN)

#ifndef __LANGUAGE_ASM__
#define BW_IR_INTR_RXABORT_IRQ_EN(v)   BF_CS1(IR_INTR, RXABORT_IRQ_EN, v)
#endif

#define BV_IR_INTR_RXABORT_IRQ_EN__DISABLED  0x0
#define BV_IR_INTR_RXABORT_IRQ_EN__ENABLED   0x1

//--- Register HW_IR_INTR, field SPEED_IRQ_EN

#define BP_IR_INTR_SPEED_IRQ_EN      21
#define BM_IR_INTR_SPEED_IRQ_EN      0x00200000

#define BF_IR_INTR_SPEED_IRQ_EN(v)   (((v) << 21) & BM_IR_INTR_SPEED_IRQ_EN)

#ifndef __LANGUAGE_ASM__
#define BW_IR_INTR_SPEED_IRQ_EN(v)   BF_CS1(IR_INTR, SPEED_IRQ_EN, v)
#endif

#define BV_IR_INTR_SPEED_IRQ_EN__DISABLED  0x0
#define BV_IR_INTR_SPEED_IRQ_EN__ENABLED   0x1

//--- Register HW_IR_INTR, field RXOF_IRQ_EN

#define BP_IR_INTR_RXOF_IRQ_EN      20
#define BM_IR_INTR_RXOF_IRQ_EN      0x00100000

#define BF_IR_INTR_RXOF_IRQ_EN(v)   (((v) << 20) & BM_IR_INTR_RXOF_IRQ_EN)

#ifndef __LANGUAGE_ASM__
#define BW_IR_INTR_RXOF_IRQ_EN(v)   BF_CS1(IR_INTR, RXOF_IRQ_EN, v)
#endif

#define BV_IR_INTR_RXOF_IRQ_EN__DISABLED  0x0
#define BV_IR_INTR_RXOF_IRQ_EN__ENABLED   0x1

//--- Register HW_IR_INTR, field TXUF_IRQ_EN

#define BP_IR_INTR_TXUF_IRQ_EN      19
#define BM_IR_INTR_TXUF_IRQ_EN      0x00080000

#define BF_IR_INTR_TXUF_IRQ_EN(v)   (((v) << 19) & BM_IR_INTR_TXUF_IRQ_EN)

#ifndef __LANGUAGE_ASM__
#define BW_IR_INTR_TXUF_IRQ_EN(v)   BF_CS1(IR_INTR, TXUF_IRQ_EN, v)
#endif

#define BV_IR_INTR_TXUF_IRQ_EN__DISABLED  0x0
#define BV_IR_INTR_TXUF_IRQ_EN__ENABLED   0x1

//--- Register HW_IR_INTR, field TC_IRQ_EN

#define BP_IR_INTR_TC_IRQ_EN      18
#define BM_IR_INTR_TC_IRQ_EN      0x00040000

#define BF_IR_INTR_TC_IRQ_EN(v)   (((v) << 18) & BM_IR_INTR_TC_IRQ_EN)

#ifndef __LANGUAGE_ASM__
#define BW_IR_INTR_TC_IRQ_EN(v)   BF_CS1(IR_INTR, TC_IRQ_EN, v)
#endif

#define BV_IR_INTR_TC_IRQ_EN__DISABLED  0x0
#define BV_IR_INTR_TC_IRQ_EN__ENABLED   0x1

//--- Register HW_IR_INTR, field RX_IRQ_EN

#define BP_IR_INTR_RX_IRQ_EN      17
#define BM_IR_INTR_RX_IRQ_EN      0x00020000

#define BF_IR_INTR_RX_IRQ_EN(v)   (((v) << 17) & BM_IR_INTR_RX_IRQ_EN)

#ifndef __LANGUAGE_ASM__
#define BW_IR_INTR_RX_IRQ_EN(v)   BF_CS1(IR_INTR, RX_IRQ_EN, v)
#endif

#define BV_IR_INTR_RX_IRQ_EN__DISABLED  0x0
#define BV_IR_INTR_RX_IRQ_EN__ENABLED   0x1

//--- Register HW_IR_INTR, field TX_IRQ_EN

#define BP_IR_INTR_TX_IRQ_EN      16
#define BM_IR_INTR_TX_IRQ_EN      0x00010000

#define BF_IR_INTR_TX_IRQ_EN(v)   (((v) << 16) & BM_IR_INTR_TX_IRQ_EN)

#ifndef __LANGUAGE_ASM__
#define BW_IR_INTR_TX_IRQ_EN(v)   BF_CS1(IR_INTR, TX_IRQ_EN, v)
#endif

#define BV_IR_INTR_TX_IRQ_EN__DISABLED  0x0
#define BV_IR_INTR_TX_IRQ_EN__ENABLED   0x1

//--- Register HW_IR_INTR, field RXABORT_IRQ

#define BP_IR_INTR_RXABORT_IRQ      6
#define BM_IR_INTR_RXABORT_IRQ      0x00000040

#define BF_IR_INTR_RXABORT_IRQ(v)   (((v) << 6) & BM_IR_INTR_RXABORT_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_IR_INTR_RXABORT_IRQ(v)   BF_CS1(IR_INTR, RXABORT_IRQ, v)
#endif

#define BV_IR_INTR_RXABORT_IRQ__NO_REQUEST  0x0
#define BV_IR_INTR_RXABORT_IRQ__REQUEST     0x1

//--- Register HW_IR_INTR, field SPEED_IRQ

#define BP_IR_INTR_SPEED_IRQ      5
#define BM_IR_INTR_SPEED_IRQ      0x00000020

#define BF_IR_INTR_SPEED_IRQ(v)   (((v) << 5) & BM_IR_INTR_SPEED_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_IR_INTR_SPEED_IRQ(v)   BF_CS1(IR_INTR, SPEED_IRQ, v)
#endif

#define BV_IR_INTR_SPEED_IRQ__NO_REQUEST  0x0
#define BV_IR_INTR_SPEED_IRQ__REQUEST     0x1

//--- Register HW_IR_INTR, field RXOF_IRQ

#define BP_IR_INTR_RXOF_IRQ      4
#define BM_IR_INTR_RXOF_IRQ      0x00000010

#define BF_IR_INTR_RXOF_IRQ(v)   (((v) << 4) & BM_IR_INTR_RXOF_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_IR_INTR_RXOF_IRQ(v)   BF_CS1(IR_INTR, RXOF_IRQ, v)
#endif

#define BV_IR_INTR_RXOF_IRQ__NO_REQUEST  0x0
#define BV_IR_INTR_RXOF_IRQ__REQUEST     0x1

//--- Register HW_IR_INTR, field TXUF_IRQ

#define BP_IR_INTR_TXUF_IRQ      3
#define BM_IR_INTR_TXUF_IRQ      0x00000008

#define BF_IR_INTR_TXUF_IRQ(v)   (((v) << 3) & BM_IR_INTR_TXUF_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_IR_INTR_TXUF_IRQ(v)   BF_CS1(IR_INTR, TXUF_IRQ, v)
#endif

#define BV_IR_INTR_TXUF_IRQ__NO_REQUEST  0x0
#define BV_IR_INTR_TXUF_IRQ__REQUEST     0x1

//--- Register HW_IR_INTR, field TC_IRQ

#define BP_IR_INTR_TC_IRQ      2
#define BM_IR_INTR_TC_IRQ      0x00000004

#define BF_IR_INTR_TC_IRQ(v)   (((v) << 2) & BM_IR_INTR_TC_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_IR_INTR_TC_IRQ(v)   BF_CS1(IR_INTR, TC_IRQ, v)
#endif

#define BV_IR_INTR_TC_IRQ__NO_REQUEST  0x0
#define BV_IR_INTR_TC_IRQ__REQUEST     0x1

//--- Register HW_IR_INTR, field RX_IRQ

#define BP_IR_INTR_RX_IRQ      1
#define BM_IR_INTR_RX_IRQ      0x00000002

#define BF_IR_INTR_RX_IRQ(v)   (((v) << 1) & BM_IR_INTR_RX_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_IR_INTR_RX_IRQ(v)   BF_CS1(IR_INTR, RX_IRQ, v)
#endif

#define BV_IR_INTR_RX_IRQ__NO_REQUEST  0x0
#define BV_IR_INTR_RX_IRQ__REQUEST     0x1

//--- Register HW_IR_INTR, field TX_IRQ

#define BP_IR_INTR_TX_IRQ      0
#define BM_IR_INTR_TX_IRQ      0x00000001

#define BF_IR_INTR_TX_IRQ(v)   (((v) << 0) & BM_IR_INTR_TX_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_IR_INTR_TX_IRQ(v)   BF_CS1(IR_INTR, TX_IRQ, v)
#endif

#define BV_IR_INTR_TX_IRQ__NO_REQUEST  0x0
#define BV_IR_INTR_TX_IRQ__REQUEST     0x1


////////////////////////////////////////////////////////////////////////////////
//// HW_IR_DATA - IR RX Data Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_ir_data_t;
#endif


//
// constants & macros for entire HW_IR_DATA register
//

#define HW_IR_DATA_ADDR      (REGS_IR_BASE + 0x00000050)

#ifndef __LANGUAGE_ASM__
#define HW_IR_DATA           (*(volatile hw_ir_data_t *) HW_IR_DATA_ADDR)
#define HW_IR_DATA_RD()      (HW_IR_DATA.U)
#define HW_IR_DATA_WR(v)     (HW_IR_DATA.U = (v))
#define HW_IR_DATA_SET(v)    (HW_IR_DATA_WR(HW_IR_DATA_RD() |  (v)))
#define HW_IR_DATA_CLR(v)    (HW_IR_DATA_WR(HW_IR_DATA_RD() & ~(v)))
#define HW_IR_DATA_TOG(v)    (HW_IR_DATA_WR(HW_IR_DATA_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_IR_DATA bitfields
//

//--- Register HW_IR_DATA, field DATA

#define BP_IR_DATA_DATA      0
#define BM_IR_DATA_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_IR_DATA_DATA(v)   ((reg32_t) v)
#else
#define BF_IR_DATA_DATA(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_IR_DATA_DATA(v)   (HW_IR_DATA.B.DATA = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_IR_STAT - IR Status Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned TX_ACTIVE        :  1;
        unsigned RX_ACTIVE        :  1;
        unsigned MEDIA_BUSY       :  1;
        unsigned RSVD1            : 13;
        unsigned TX_SUMMARY       :  1;
        unsigned RX_SUMMARY       :  1;
        unsigned TC_SUMMARY       :  1;
        unsigned TXUF_SUMMARY     :  1;
        unsigned RXOF_SUMMARY     :  1;
        unsigned SPEED_SUMMARY    :  1;
        unsigned RXABORT_SUMMARY  :  1;
        unsigned RSVD2            :  5;
        unsigned ANY_IRQ          :  1;
        unsigned MODE_ALLOWED     :  2;
        unsigned PRESENT          :  1;
    } B;
} hw_ir_stat_t;
#endif


//
// constants & macros for entire HW_IR_STAT register
//

#define HW_IR_STAT_ADDR      (REGS_IR_BASE + 0x00000060)

#ifndef __LANGUAGE_ASM__
#define HW_IR_STAT           (*(volatile hw_ir_stat_t *) HW_IR_STAT_ADDR)
#define HW_IR_STAT_RD()      (HW_IR_STAT.U)
#endif


//
// constants & macros for individual HW_IR_STAT bitfields
//

//--- Register HW_IR_STAT, field PRESENT

#define BP_IR_STAT_PRESENT      31
#define BM_IR_STAT_PRESENT      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_IR_STAT_PRESENT(v)   ((((reg32_t) v) << 31) & BM_IR_STAT_PRESENT)
#else
#define BF_IR_STAT_PRESENT(v)   (((v) << 31) & BM_IR_STAT_PRESENT)
#endif

#define BV_IR_STAT_PRESENT__UNAVAILABLE  0x0
#define BV_IR_STAT_PRESENT__AVAILABLE    0x1

//--- Register HW_IR_STAT, field MODE_ALLOWED

#define BP_IR_STAT_MODE_ALLOWED      29
#define BM_IR_STAT_MODE_ALLOWED      0x60000000

#define BF_IR_STAT_MODE_ALLOWED(v)   (((v) << 29) & BM_IR_STAT_MODE_ALLOWED)

#define BV_IR_STAT_MODE_ALLOWED__VFIR  0x0
#define BV_IR_STAT_MODE_ALLOWED__FIR   0x1
#define BV_IR_STAT_MODE_ALLOWED__MIR   0x2
#define BV_IR_STAT_MODE_ALLOWED__SIR   0x3

//--- Register HW_IR_STAT, field ANY_IRQ

#define BP_IR_STAT_ANY_IRQ      28
#define BM_IR_STAT_ANY_IRQ      0x10000000

#define BF_IR_STAT_ANY_IRQ(v)   (((v) << 28) & BM_IR_STAT_ANY_IRQ)

#define BV_IR_STAT_ANY_IRQ__NO_REQUEST  0x0
#define BV_IR_STAT_ANY_IRQ__REQUEST     0x1

//--- Register HW_IR_STAT, field RXABORT_SUMMARY

#define BP_IR_STAT_RXABORT_SUMMARY      22
#define BM_IR_STAT_RXABORT_SUMMARY      0x00400000

#define BF_IR_STAT_RXABORT_SUMMARY(v)   (((v) << 22) & BM_IR_STAT_RXABORT_SUMMARY)

#define BV_IR_STAT_RXABORT_SUMMARY__NO_REQUEST  0x0
#define BV_IR_STAT_RXABORT_SUMMARY__REQUEST     0x1

//--- Register HW_IR_STAT, field SPEED_SUMMARY

#define BP_IR_STAT_SPEED_SUMMARY      21
#define BM_IR_STAT_SPEED_SUMMARY      0x00200000

#define BF_IR_STAT_SPEED_SUMMARY(v)   (((v) << 21) & BM_IR_STAT_SPEED_SUMMARY)

#define BV_IR_STAT_SPEED_SUMMARY__NO_REQUEST  0x0
#define BV_IR_STAT_SPEED_SUMMARY__REQUEST     0x1

//--- Register HW_IR_STAT, field RXOF_SUMMARY

#define BP_IR_STAT_RXOF_SUMMARY      20
#define BM_IR_STAT_RXOF_SUMMARY      0x00100000

#define BF_IR_STAT_RXOF_SUMMARY(v)   (((v) << 20) & BM_IR_STAT_RXOF_SUMMARY)

#define BV_IR_STAT_RXOF_SUMMARY__NO_REQUEST  0x0
#define BV_IR_STAT_RXOF_SUMMARY__REQUEST     0x1

//--- Register HW_IR_STAT, field TXUF_SUMMARY

#define BP_IR_STAT_TXUF_SUMMARY      19
#define BM_IR_STAT_TXUF_SUMMARY      0x00080000

#define BF_IR_STAT_TXUF_SUMMARY(v)   (((v) << 19) & BM_IR_STAT_TXUF_SUMMARY)

#define BV_IR_STAT_TXUF_SUMMARY__NO_REQUEST  0x0
#define BV_IR_STAT_TXUF_SUMMARY__REQUEST     0x1

//--- Register HW_IR_STAT, field TC_SUMMARY

#define BP_IR_STAT_TC_SUMMARY      18
#define BM_IR_STAT_TC_SUMMARY      0x00040000

#define BF_IR_STAT_TC_SUMMARY(v)   (((v) << 18) & BM_IR_STAT_TC_SUMMARY)

#define BV_IR_STAT_TC_SUMMARY__NO_REQUEST  0x0
#define BV_IR_STAT_TC_SUMMARY__REQUEST     0x1

//--- Register HW_IR_STAT, field RX_SUMMARY

#define BP_IR_STAT_RX_SUMMARY      17
#define BM_IR_STAT_RX_SUMMARY      0x00020000

#define BF_IR_STAT_RX_SUMMARY(v)   (((v) << 17) & BM_IR_STAT_RX_SUMMARY)

#define BV_IR_STAT_RX_SUMMARY__NO_REQUEST  0x0
#define BV_IR_STAT_RX_SUMMARY__REQUEST     0x1

//--- Register HW_IR_STAT, field TX_SUMMARY

#define BP_IR_STAT_TX_SUMMARY      16
#define BM_IR_STAT_TX_SUMMARY      0x00010000

#define BF_IR_STAT_TX_SUMMARY(v)   (((v) << 16) & BM_IR_STAT_TX_SUMMARY)

#define BV_IR_STAT_TX_SUMMARY__NO_REQUEST  0x0
#define BV_IR_STAT_TX_SUMMARY__REQUEST     0x1

//--- Register HW_IR_STAT, field MEDIA_BUSY

#define BP_IR_STAT_MEDIA_BUSY      2
#define BM_IR_STAT_MEDIA_BUSY      0x00000004

#define BF_IR_STAT_MEDIA_BUSY(v)   (((v) << 2) & BM_IR_STAT_MEDIA_BUSY)

//--- Register HW_IR_STAT, field RX_ACTIVE

#define BP_IR_STAT_RX_ACTIVE      1
#define BM_IR_STAT_RX_ACTIVE      0x00000002

#define BF_IR_STAT_RX_ACTIVE(v)   (((v) << 1) & BM_IR_STAT_RX_ACTIVE)

//--- Register HW_IR_STAT, field TX_ACTIVE

#define BP_IR_STAT_TX_ACTIVE      0
#define BM_IR_STAT_TX_ACTIVE      0x00000001

#define BF_IR_STAT_TX_ACTIVE(v)   (((v) << 0) & BM_IR_STAT_TX_ACTIVE)


////////////////////////////////////////////////////////////////////////////////
//// HW_IR_TCCTRL - IR Transceiver Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned C         :  1;
        unsigned INDX      :  4;
        unsigned ADDR      :  3;
        reg8_t   DATA;
        reg8_t   EXT_DATA;
        unsigned TEMIC     :  1;
        unsigned RSVD      :  4;
        unsigned BUSY      :  1;
        unsigned GO        :  1;
        unsigned INIT      :  1;
    } B;
} hw_ir_tcctrl_t;
#endif


//
// constants & macros for entire HW_IR_TCCTRL register
//

#define HW_IR_TCCTRL_ADDR      (REGS_IR_BASE + 0x00000070)
#define HW_IR_TCCTRL_SET_ADDR  (REGS_IR_BASE + 0x00000074)
#define HW_IR_TCCTRL_CLR_ADDR  (REGS_IR_BASE + 0x00000078)
#define HW_IR_TCCTRL_TOG_ADDR  (REGS_IR_BASE + 0x0000007C)

#ifndef __LANGUAGE_ASM__
#define HW_IR_TCCTRL           (*(volatile hw_ir_tcctrl_t *) HW_IR_TCCTRL_ADDR)
#define HW_IR_TCCTRL_RD()      (HW_IR_TCCTRL.U)
#define HW_IR_TCCTRL_WR(v)     (HW_IR_TCCTRL.U = (v))
#define HW_IR_TCCTRL_SET(v)    ((*(volatile reg32_t *) HW_IR_TCCTRL_SET_ADDR) = (v))
#define HW_IR_TCCTRL_CLR(v)    ((*(volatile reg32_t *) HW_IR_TCCTRL_CLR_ADDR) = (v))
#define HW_IR_TCCTRL_TOG(v)    ((*(volatile reg32_t *) HW_IR_TCCTRL_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_IR_TCCTRL bitfields
//

//--- Register HW_IR_TCCTRL, field INIT

#define BP_IR_TCCTRL_INIT      31
#define BM_IR_TCCTRL_INIT      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_IR_TCCTRL_INIT(v)   ((((reg32_t) v) << 31) & BM_IR_TCCTRL_INIT)
#else
#define BF_IR_TCCTRL_INIT(v)   (((v) << 31) & BM_IR_TCCTRL_INIT)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_IR_TCCTRL_INIT(v)   BF_CS1(IR_TCCTRL, INIT, v)
#endif

//--- Register HW_IR_TCCTRL, field GO

#define BP_IR_TCCTRL_GO      30
#define BM_IR_TCCTRL_GO      0x40000000

#define BF_IR_TCCTRL_GO(v)   (((v) << 30) & BM_IR_TCCTRL_GO)

#ifndef __LANGUAGE_ASM__
#define BW_IR_TCCTRL_GO(v)   BF_CS1(IR_TCCTRL, GO, v)
#endif

//--- Register HW_IR_TCCTRL, field BUSY

#define BP_IR_TCCTRL_BUSY      29
#define BM_IR_TCCTRL_BUSY      0x20000000

#define BF_IR_TCCTRL_BUSY(v)   (((v) << 29) & BM_IR_TCCTRL_BUSY)

//--- Register HW_IR_TCCTRL, field TEMIC

#define BP_IR_TCCTRL_TEMIC      24
#define BM_IR_TCCTRL_TEMIC      0x01000000

#define BF_IR_TCCTRL_TEMIC(v)   (((v) << 24) & BM_IR_TCCTRL_TEMIC)

#ifndef __LANGUAGE_ASM__
#define BW_IR_TCCTRL_TEMIC(v)   BF_CS1(IR_TCCTRL, TEMIC, v)
#endif

#define BV_IR_TCCTRL_TEMIC__LOW   0x0
#define BV_IR_TCCTRL_TEMIC__HIGH  0x1

//--- Register HW_IR_TCCTRL, field EXT_DATA

#define BP_IR_TCCTRL_EXT_DATA      16
#define BM_IR_TCCTRL_EXT_DATA      0x00FF0000

#define BF_IR_TCCTRL_EXT_DATA(v)   (((v) << 16) & BM_IR_TCCTRL_EXT_DATA)

#ifndef __LANGUAGE_ASM__
#define BW_IR_TCCTRL_EXT_DATA(v)   (HW_IR_TCCTRL.B.EXT_DATA = (v))
#endif

//--- Register HW_IR_TCCTRL, field DATA

#define BP_IR_TCCTRL_DATA      8
#define BM_IR_TCCTRL_DATA      0x0000FF00

#define BF_IR_TCCTRL_DATA(v)   (((v) << 8) & BM_IR_TCCTRL_DATA)

#ifndef __LANGUAGE_ASM__
#define BW_IR_TCCTRL_DATA(v)   (HW_IR_TCCTRL.B.DATA = (v))
#endif

//--- Register HW_IR_TCCTRL, field ADDR

#define BP_IR_TCCTRL_ADDR      5
#define BM_IR_TCCTRL_ADDR      0x000000E0

#define BF_IR_TCCTRL_ADDR(v)   (((v) << 5) & BM_IR_TCCTRL_ADDR)

#ifndef __LANGUAGE_ASM__
#define BW_IR_TCCTRL_ADDR(v)   BF_CS1(IR_TCCTRL, ADDR, v)
#endif

//--- Register HW_IR_TCCTRL, field INDX

#define BP_IR_TCCTRL_INDX      1
#define BM_IR_TCCTRL_INDX      0x0000001E

#define BF_IR_TCCTRL_INDX(v)   (((v) << 1) & BM_IR_TCCTRL_INDX)

#ifndef __LANGUAGE_ASM__
#define BW_IR_TCCTRL_INDX(v)   BF_CS1(IR_TCCTRL, INDX, v)
#endif

//--- Register HW_IR_TCCTRL, field C

#define BP_IR_TCCTRL_C      0
#define BM_IR_TCCTRL_C      0x00000001

#define BF_IR_TCCTRL_C(v)   (((v) << 0) & BM_IR_TCCTRL_C)

#ifndef __LANGUAGE_ASM__
#define BW_IR_TCCTRL_C(v)   BF_CS1(IR_TCCTRL, C, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_IR_SI_READ - IR Serial Interface Read Data Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg8_t   DATA;
        unsigned ABORT  :  1;
        unsigned RSVD1  : 23;
    } B;
} hw_ir_si_read_t;
#endif


//
// constants & macros for entire HW_IR_SI_READ register
//

#define HW_IR_SI_READ_ADDR      (REGS_IR_BASE + 0x00000080)

#ifndef __LANGUAGE_ASM__
#define HW_IR_SI_READ           (*(volatile hw_ir_si_read_t *) HW_IR_SI_READ_ADDR)
#define HW_IR_SI_READ_RD()      (HW_IR_SI_READ.U)
#endif


//
// constants & macros for individual HW_IR_SI_READ bitfields
//

//--- Register HW_IR_SI_READ, field ABORT

#define BP_IR_SI_READ_ABORT      8
#define BM_IR_SI_READ_ABORT      0x00000100

#define BF_IR_SI_READ_ABORT(v)   (((v) << 8) & BM_IR_SI_READ_ABORT)

//--- Register HW_IR_SI_READ, field DATA

#define BP_IR_SI_READ_DATA      0
#define BM_IR_SI_READ_DATA      0x000000FF

#define BF_IR_SI_READ_DATA(v)   (((v) << 0) & BM_IR_SI_READ_DATA)


////////////////////////////////////////////////////////////////////////////////
//// HW_IR_DEBUG - IR Debug Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RXDMAREQ   :  1;
        unsigned TXDMAREQ   :  1;
        unsigned RXDMAEND   :  1;
        unsigned TXDMAEND   :  1;
        unsigned RXDMAKICK  :  1;
        unsigned TXDMAKICK  :  1;
        unsigned RSVD1      : 26;
    } B;
} hw_ir_debug_t;
#endif


//
// constants & macros for entire HW_IR_DEBUG register
//

#define HW_IR_DEBUG_ADDR      (REGS_IR_BASE + 0x00000090)

#ifndef __LANGUAGE_ASM__
#define HW_IR_DEBUG           (*(volatile hw_ir_debug_t *) HW_IR_DEBUG_ADDR)
#define HW_IR_DEBUG_RD()      (HW_IR_DEBUG.U)
#endif


//
// constants & macros for individual HW_IR_DEBUG bitfields
//

//--- Register HW_IR_DEBUG, field TXDMAKICK

#define BP_IR_DEBUG_TXDMAKICK      5
#define BM_IR_DEBUG_TXDMAKICK      0x00000020

#define BF_IR_DEBUG_TXDMAKICK(v)   (((v) << 5) & BM_IR_DEBUG_TXDMAKICK)

//--- Register HW_IR_DEBUG, field RXDMAKICK

#define BP_IR_DEBUG_RXDMAKICK      4
#define BM_IR_DEBUG_RXDMAKICK      0x00000010

#define BF_IR_DEBUG_RXDMAKICK(v)   (((v) << 4) & BM_IR_DEBUG_RXDMAKICK)

//--- Register HW_IR_DEBUG, field TXDMAEND

#define BP_IR_DEBUG_TXDMAEND      3
#define BM_IR_DEBUG_TXDMAEND      0x00000008

#define BF_IR_DEBUG_TXDMAEND(v)   (((v) << 3) & BM_IR_DEBUG_TXDMAEND)

//--- Register HW_IR_DEBUG, field RXDMAEND

#define BP_IR_DEBUG_RXDMAEND      2
#define BM_IR_DEBUG_RXDMAEND      0x00000004

#define BF_IR_DEBUG_RXDMAEND(v)   (((v) << 2) & BM_IR_DEBUG_RXDMAEND)

//--- Register HW_IR_DEBUG, field TXDMAREQ

#define BP_IR_DEBUG_TXDMAREQ      1
#define BM_IR_DEBUG_TXDMAREQ      0x00000002

#define BF_IR_DEBUG_TXDMAREQ(v)   (((v) << 1) & BM_IR_DEBUG_TXDMAREQ)

//--- Register HW_IR_DEBUG, field RXDMAREQ

#define BP_IR_DEBUG_RXDMAREQ      0
#define BM_IR_DEBUG_RXDMAREQ      0x00000001

#define BF_IR_DEBUG_RXDMAREQ(v)   (((v) << 0) & BM_IR_DEBUG_RXDMAREQ)


////////////////////////////////////////////////////////////////////////////////
//// HW_IR_VERSION - IR Version Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg16_t  STEP;
        reg8_t   MINOR;
        reg8_t   MAJOR;
    } B;
} hw_ir_version_t;
#endif


//
// constants & macros for entire HW_IR_VERSION register
//

#define HW_IR_VERSION_ADDR      (REGS_IR_BASE + 0x000000A0)

#ifndef __LANGUAGE_ASM__
#define HW_IR_VERSION           (*(volatile hw_ir_version_t *) HW_IR_VERSION_ADDR)
#define HW_IR_VERSION_RD()      (HW_IR_VERSION.U)
#endif


//
// constants & macros for individual HW_IR_VERSION bitfields
//

//--- Register HW_IR_VERSION, field MAJOR

#define BP_IR_VERSION_MAJOR      24
#define BM_IR_VERSION_MAJOR      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_IR_VERSION_MAJOR(v)   ((((reg32_t) v) << 24) & BM_IR_VERSION_MAJOR)
#else
#define BF_IR_VERSION_MAJOR(v)   (((v) << 24) & BM_IR_VERSION_MAJOR)
#endif

//--- Register HW_IR_VERSION, field MINOR

#define BP_IR_VERSION_MINOR      16
#define BM_IR_VERSION_MINOR      0x00FF0000

#define BF_IR_VERSION_MINOR(v)   (((v) << 16) & BM_IR_VERSION_MINOR)

//--- Register HW_IR_VERSION, field STEP

#define BP_IR_VERSION_STEP      0
#define BM_IR_VERSION_STEP      0x0000FFFF

#define BF_IR_VERSION_STEP(v)   (((v) << 0) & BM_IR_VERSION_STEP)


#endif // _REGSIR_H

////////////////////////////////////////////////////////////////////////////////
