/*
 * Copyright 2009 Freescale Semiconductor, Inc. All Rights Reserved.
 */

/*
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 */
////////////////////////////////////////////////////////////////////////////////
//
// WARNING!  THIS FILE IS AUTOMATICALLY GENERATED FROM XML.
//                DO NOT MODIFY THIS FILE DIRECTLY.
//
////////////////////////////////////////////////////////////////////////////////
//
// The following naming conventions are followed in this file.
//      XX_<module>_<regname>_<field>
//
// XX specifies the define / macro class
//      HW pertains to a register
//      BM indicates a Bit Mask
//      BF indicates a Bit Field macro
//
// <module> is the hardware module name which can be any of the following...
//      USB20 (Note when there is more than one copy of a given module, the
//      module name includes a number starting from 0 for the first instance
//      of that module)
//
// <regname> is the specific register within that module
//
// <field> is the specific bitfield within that <module>_<register>
//
// We also define the following...
//      hw_<module>_<regname>_t is typedef of anonymous union
//
////////////////////////////////////////////////////////////////////////////////

#ifndef _REGSPXP_H
#define _REGSPXP_H  1

#include "regs.h"

#ifndef REGS_PXP_BASE
#define REGS_PXP_BASE (REGS_BASE + 0x0002A000)
#endif

////////////////////////////////////////////////////////////////////////////////
//// HW_PXP_CTRL - PXP Control Register 0
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ENABLE                :  1;
        unsigned IRQ_ENABLE            :  1;
        unsigned ENABLE_LCD_HANDSHAKE  :  1;
        unsigned RSVD0                 :  1;
        unsigned OUTPUT_RGB_FORMAT     :  4;
        unsigned ROTATE                :  2;
        unsigned HFLIP                 :  1;
        unsigned VFLIP                 :  1;
        unsigned S0_FORMAT             :  4;
        unsigned SUBSAMPLE             :  1;
        unsigned UPSAMPLE              :  1;
        unsigned SCALE                 :  1;
        unsigned CROP                  :  1;
        unsigned DELTA                 :  1;
        unsigned IN_PLACE              :  1;
        unsigned ALPHA_OUTPUT          :  1;
        unsigned RSVD1                 :  1;
        unsigned INTERLACED_INPUT      :  2;
        unsigned INTERLACED_OUTPUT     :  2;
        unsigned RSVD2                 :  2;
        unsigned CLKGATE               :  1;
        unsigned SFTRST                :  1;
    } B;
} hw_pxp_ctrl_t;
#endif


//
// constants & macros for entire HW_PXP_CTRL register
//

#define HW_PXP_CTRL_ADDR      (REGS_PXP_BASE + 0x00000000)
#define HW_PXP_CTRL_SET_ADDR  (REGS_PXP_BASE + 0x00000004)
#define HW_PXP_CTRL_CLR_ADDR  (REGS_PXP_BASE + 0x00000008)
#define HW_PXP_CTRL_TOG_ADDR  (REGS_PXP_BASE + 0x0000000C)

#ifndef __LANGUAGE_ASM__
#define HW_PXP_CTRL           (*(volatile hw_pxp_ctrl_t *) HW_PXP_CTRL_ADDR)
#define HW_PXP_CTRL_RD()      (HW_PXP_CTRL.U)
#define HW_PXP_CTRL_WR(v)     (HW_PXP_CTRL.U = (v))
#define HW_PXP_CTRL_SET(v)    ((*(volatile reg32_t *) HW_PXP_CTRL_SET_ADDR) = (v))
#define HW_PXP_CTRL_CLR(v)    ((*(volatile reg32_t *) HW_PXP_CTRL_CLR_ADDR) = (v))
#define HW_PXP_CTRL_TOG(v)    ((*(volatile reg32_t *) HW_PXP_CTRL_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_PXP_CTRL bitfields
//

//--- Register HW_PXP_CTRL, field SFTRST

#define BP_PXP_CTRL_SFTRST      31
#define BM_PXP_CTRL_SFTRST      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_PXP_CTRL_SFTRST(v)   ((((reg32_t) v) << 31) & BM_PXP_CTRL_SFTRST)
#else
#define BF_PXP_CTRL_SFTRST(v)   (((v) << 31) & BM_PXP_CTRL_SFTRST)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_PXP_CTRL_SFTRST(v)   BF_CS1(PXP_CTRL, SFTRST, v)
#endif

//--- Register HW_PXP_CTRL, field CLKGATE

#define BP_PXP_CTRL_CLKGATE      30
#define BM_PXP_CTRL_CLKGATE      0x40000000

#define BF_PXP_CTRL_CLKGATE(v)   (((v) << 30) & BM_PXP_CTRL_CLKGATE)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_CTRL_CLKGATE(v)   BF_CS1(PXP_CTRL, CLKGATE, v)
#endif

//--- Register HW_PXP_CTRL, field INTERLACED_OUTPUT

#define BP_PXP_CTRL_INTERLACED_OUTPUT      26
#define BM_PXP_CTRL_INTERLACED_OUTPUT      0x0C000000

#define BF_PXP_CTRL_INTERLACED_OUTPUT(v)   (((v) << 26) & BM_PXP_CTRL_INTERLACED_OUTPUT)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_CTRL_INTERLACED_OUTPUT(v)   BF_CS1(PXP_CTRL, INTERLACED_OUTPUT, v)
#endif

#define BV_PXP_CTRL_INTERLACED_OUTPUT__PROGRESSIVE  0x0
#define BV_PXP_CTRL_INTERLACED_OUTPUT__FIELD0       0x1
#define BV_PXP_CTRL_INTERLACED_OUTPUT__FIELD1       0x2
#define BV_PXP_CTRL_INTERLACED_OUTPUT__INTERLACED   0x3

//--- Register HW_PXP_CTRL, field INTERLACED_INPUT

#define BP_PXP_CTRL_INTERLACED_INPUT      24
#define BM_PXP_CTRL_INTERLACED_INPUT      0x03000000

#define BF_PXP_CTRL_INTERLACED_INPUT(v)   (((v) << 24) & BM_PXP_CTRL_INTERLACED_INPUT)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_CTRL_INTERLACED_INPUT(v)   BF_CS1(PXP_CTRL, INTERLACED_INPUT, v)
#endif

#define BV_PXP_CTRL_INTERLACED_INPUT__PROGRESSIVE  0x0
#define BV_PXP_CTRL_INTERLACED_INPUT__FIELD0       0x2
#define BV_PXP_CTRL_INTERLACED_INPUT__FIELD1       0x3

//--- Register HW_PXP_CTRL, field ALPHA_OUTPUT

#define BP_PXP_CTRL_ALPHA_OUTPUT      22
#define BM_PXP_CTRL_ALPHA_OUTPUT      0x00400000

#define BF_PXP_CTRL_ALPHA_OUTPUT(v)   (((v) << 22) & BM_PXP_CTRL_ALPHA_OUTPUT)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_CTRL_ALPHA_OUTPUT(v)   BF_CS1(PXP_CTRL, ALPHA_OUTPUT, v)
#endif

//--- Register HW_PXP_CTRL, field IN_PLACE

#define BP_PXP_CTRL_IN_PLACE      21
#define BM_PXP_CTRL_IN_PLACE      0x00200000

#define BF_PXP_CTRL_IN_PLACE(v)   (((v) << 21) & BM_PXP_CTRL_IN_PLACE)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_CTRL_IN_PLACE(v)   BF_CS1(PXP_CTRL, IN_PLACE, v)
#endif

//--- Register HW_PXP_CTRL, field DELTA

#define BP_PXP_CTRL_DELTA      20
#define BM_PXP_CTRL_DELTA      0x00100000

#define BF_PXP_CTRL_DELTA(v)   (((v) << 20) & BM_PXP_CTRL_DELTA)

//--- Register HW_PXP_CTRL, field CROP

#define BP_PXP_CTRL_CROP      19
#define BM_PXP_CTRL_CROP      0x00080000

#define BF_PXP_CTRL_CROP(v)   (((v) << 19) & BM_PXP_CTRL_CROP)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_CTRL_CROP(v)   BF_CS1(PXP_CTRL, CROP, v)
#endif

//--- Register HW_PXP_CTRL, field SCALE

#define BP_PXP_CTRL_SCALE      18
#define BM_PXP_CTRL_SCALE      0x00040000

#define BF_PXP_CTRL_SCALE(v)   (((v) << 18) & BM_PXP_CTRL_SCALE)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_CTRL_SCALE(v)   BF_CS1(PXP_CTRL, SCALE, v)
#endif

//--- Register HW_PXP_CTRL, field UPSAMPLE

#define BP_PXP_CTRL_UPSAMPLE      17
#define BM_PXP_CTRL_UPSAMPLE      0x00020000

#define BF_PXP_CTRL_UPSAMPLE(v)   (((v) << 17) & BM_PXP_CTRL_UPSAMPLE)

//--- Register HW_PXP_CTRL, field SUBSAMPLE

#define BP_PXP_CTRL_SUBSAMPLE      16
#define BM_PXP_CTRL_SUBSAMPLE      0x00010000

#define BF_PXP_CTRL_SUBSAMPLE(v)   (((v) << 16) & BM_PXP_CTRL_SUBSAMPLE)

//--- Register HW_PXP_CTRL, field S0_FORMAT

#define BP_PXP_CTRL_S0_FORMAT      12
#define BM_PXP_CTRL_S0_FORMAT      0x0000F000

#define BF_PXP_CTRL_S0_FORMAT(v)   (((v) << 12) & BM_PXP_CTRL_S0_FORMAT)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_CTRL_S0_FORMAT(v)   BF_CS1(PXP_CTRL, S0_FORMAT, v)
#endif

#define BV_PXP_CTRL_S0_FORMAT__RGB888  0x1
#define BV_PXP_CTRL_S0_FORMAT__RGB565  0x4
#define BV_PXP_CTRL_S0_FORMAT__RGB555  0x5
#define BV_PXP_CTRL_S0_FORMAT__YUV422  0x8
#define BV_PXP_CTRL_S0_FORMAT__YUV420  0x9

//--- Register HW_PXP_CTRL, field VFLIP

#define BP_PXP_CTRL_VFLIP      11
#define BM_PXP_CTRL_VFLIP      0x00000800

#define BF_PXP_CTRL_VFLIP(v)   (((v) << 11) & BM_PXP_CTRL_VFLIP)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_CTRL_VFLIP(v)   BF_CS1(PXP_CTRL, VFLIP, v)
#endif

//--- Register HW_PXP_CTRL, field HFLIP

#define BP_PXP_CTRL_HFLIP      10
#define BM_PXP_CTRL_HFLIP      0x00000400

#define BF_PXP_CTRL_HFLIP(v)   (((v) << 10) & BM_PXP_CTRL_HFLIP)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_CTRL_HFLIP(v)   BF_CS1(PXP_CTRL, HFLIP, v)
#endif

//--- Register HW_PXP_CTRL, field ROTATE

#define BP_PXP_CTRL_ROTATE      8
#define BM_PXP_CTRL_ROTATE      0x00000300

#define BF_PXP_CTRL_ROTATE(v)   (((v) << 8) & BM_PXP_CTRL_ROTATE)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_CTRL_ROTATE(v)   BF_CS1(PXP_CTRL, ROTATE, v)
#endif

#define BV_PXP_CTRL_ROTATE__ROT_0    0x0
#define BV_PXP_CTRL_ROTATE__ROT_90   0x1
#define BV_PXP_CTRL_ROTATE__ROT_180  0x2
#define BV_PXP_CTRL_ROTATE__ROT_270  0x3

//--- Register HW_PXP_CTRL, field OUTPUT_RGB_FORMAT

#define BP_PXP_CTRL_OUTPUT_RGB_FORMAT      4
#define BM_PXP_CTRL_OUTPUT_RGB_FORMAT      0x000000F0

#define BF_PXP_CTRL_OUTPUT_RGB_FORMAT(v)   (((v) << 4) & BM_PXP_CTRL_OUTPUT_RGB_FORMAT)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_CTRL_OUTPUT_RGB_FORMAT(v)   BF_CS1(PXP_CTRL, OUTPUT_RGB_FORMAT, v)
#endif

#define BV_PXP_CTRL_OUTPUT_RGB_FORMAT__ARGB8888  0x0
#define BV_PXP_CTRL_OUTPUT_RGB_FORMAT__RGB888    0x1
#define BV_PXP_CTRL_OUTPUT_RGB_FORMAT__RGB888P   0x2
#define BV_PXP_CTRL_OUTPUT_RGB_FORMAT__ARGB1555  0x3
#define BV_PXP_CTRL_OUTPUT_RGB_FORMAT__RGB565    0x4
#define BV_PXP_CTRL_OUTPUT_RGB_FORMAT__RGB555    0x5

//--- Register HW_PXP_CTRL, field ENABLE_LCD_HANDSHAKE

#define BP_PXP_CTRL_ENABLE_LCD_HANDSHAKE      2
#define BM_PXP_CTRL_ENABLE_LCD_HANDSHAKE      0x00000004

#define BF_PXP_CTRL_ENABLE_LCD_HANDSHAKE(v)   (((v) << 2) & BM_PXP_CTRL_ENABLE_LCD_HANDSHAKE)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_CTRL_ENABLE_LCD_HANDSHAKE(v)   BF_CS1(PXP_CTRL, ENABLE_LCD_HANDSHAKE, v)
#endif

//--- Register HW_PXP_CTRL, field IRQ_ENABLE

#define BP_PXP_CTRL_IRQ_ENABLE      1
#define BM_PXP_CTRL_IRQ_ENABLE      0x00000002

#define BF_PXP_CTRL_IRQ_ENABLE(v)   (((v) << 1) & BM_PXP_CTRL_IRQ_ENABLE)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_CTRL_IRQ_ENABLE(v)   BF_CS1(PXP_CTRL, IRQ_ENABLE, v)
#endif

//--- Register HW_PXP_CTRL, field ENABLE

#define BP_PXP_CTRL_ENABLE      0
#define BM_PXP_CTRL_ENABLE      0x00000001

#define BF_PXP_CTRL_ENABLE(v)   (((v) << 0) & BM_PXP_CTRL_ENABLE)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_CTRL_ENABLE(v)   BF_CS1(PXP_CTRL, ENABLE, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_PXP_STAT - PXP Status Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IRQ              :  1;
        unsigned AXI_WRITE_ERROR  :  1;
        unsigned AXI_READ_ERROR   :  1;
        unsigned RSVD1            :  1;
        unsigned AXI_ERROR_ID     :  4;
        reg8_t   RSVD2;
        reg8_t   BLOCKY;
        reg8_t   BLOCKX;
    } B;
} hw_pxp_stat_t;
#endif


//
// constants & macros for entire HW_PXP_STAT register
//

#define HW_PXP_STAT_ADDR      (REGS_PXP_BASE + 0x00000010)
#define HW_PXP_STAT_SET_ADDR  (REGS_PXP_BASE + 0x00000014)
#define HW_PXP_STAT_CLR_ADDR  (REGS_PXP_BASE + 0x00000018)
#define HW_PXP_STAT_TOG_ADDR  (REGS_PXP_BASE + 0x0000001C)

#ifndef __LANGUAGE_ASM__
#define HW_PXP_STAT           (*(volatile hw_pxp_stat_t *) HW_PXP_STAT_ADDR)
#define HW_PXP_STAT_RD()      (HW_PXP_STAT.U)
#define HW_PXP_STAT_WR(v)     (HW_PXP_STAT.U = (v))
#define HW_PXP_STAT_SET(v)    ((*(volatile reg32_t *) HW_PXP_STAT_SET_ADDR) = (v))
#define HW_PXP_STAT_CLR(v)    ((*(volatile reg32_t *) HW_PXP_STAT_CLR_ADDR) = (v))
#define HW_PXP_STAT_TOG(v)    ((*(volatile reg32_t *) HW_PXP_STAT_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_PXP_STAT bitfields
//

//--- Register HW_PXP_STAT, field BLOCKX

#define BP_PXP_STAT_BLOCKX      24
#define BM_PXP_STAT_BLOCKX      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_PXP_STAT_BLOCKX(v)   ((((reg32_t) v) << 24) & BM_PXP_STAT_BLOCKX)
#else
#define BF_PXP_STAT_BLOCKX(v)   (((v) << 24) & BM_PXP_STAT_BLOCKX)
#endif

//--- Register HW_PXP_STAT, field BLOCKY

#define BP_PXP_STAT_BLOCKY      16
#define BM_PXP_STAT_BLOCKY      0x00FF0000

#define BF_PXP_STAT_BLOCKY(v)   (((v) << 16) & BM_PXP_STAT_BLOCKY)

//--- Register HW_PXP_STAT, field AXI_ERROR_ID

#define BP_PXP_STAT_AXI_ERROR_ID      4
#define BM_PXP_STAT_AXI_ERROR_ID      0x000000F0

#define BF_PXP_STAT_AXI_ERROR_ID(v)   (((v) << 4) & BM_PXP_STAT_AXI_ERROR_ID)

//--- Register HW_PXP_STAT, field AXI_READ_ERROR

#define BP_PXP_STAT_AXI_READ_ERROR      2
#define BM_PXP_STAT_AXI_READ_ERROR      0x00000004

#define BF_PXP_STAT_AXI_READ_ERROR(v)   (((v) << 2) & BM_PXP_STAT_AXI_READ_ERROR)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_STAT_AXI_READ_ERROR(v)   BF_CS1(PXP_STAT, AXI_READ_ERROR, v)
#endif

//--- Register HW_PXP_STAT, field AXI_WRITE_ERROR

#define BP_PXP_STAT_AXI_WRITE_ERROR      1
#define BM_PXP_STAT_AXI_WRITE_ERROR      0x00000002

#define BF_PXP_STAT_AXI_WRITE_ERROR(v)   (((v) << 1) & BM_PXP_STAT_AXI_WRITE_ERROR)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_STAT_AXI_WRITE_ERROR(v)   BF_CS1(PXP_STAT, AXI_WRITE_ERROR, v)
#endif

//--- Register HW_PXP_STAT, field IRQ

#define BP_PXP_STAT_IRQ      0
#define BM_PXP_STAT_IRQ      0x00000001

#define BF_PXP_STAT_IRQ(v)   (((v) << 0) & BM_PXP_STAT_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_STAT_IRQ(v)   BF_CS1(PXP_STAT, IRQ, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_PXP_RGBBUF - RGB Output Frame Buffer Pointer
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  ADDR;
    } B;
} hw_pxp_rgbbuf_t;
#endif


//
// constants & macros for entire HW_PXP_RGBBUF register
//

#define HW_PXP_RGBBUF_ADDR      (REGS_PXP_BASE + 0x00000020)

#ifndef __LANGUAGE_ASM__
#define HW_PXP_RGBBUF           (*(volatile hw_pxp_rgbbuf_t *) HW_PXP_RGBBUF_ADDR)
#define HW_PXP_RGBBUF_RD()      (HW_PXP_RGBBUF.U)
#define HW_PXP_RGBBUF_WR(v)     (HW_PXP_RGBBUF.U = (v))
#define HW_PXP_RGBBUF_SET(v)    (HW_PXP_RGBBUF_WR(HW_PXP_RGBBUF_RD() |  (v)))
#define HW_PXP_RGBBUF_CLR(v)    (HW_PXP_RGBBUF_WR(HW_PXP_RGBBUF_RD() & ~(v)))
#define HW_PXP_RGBBUF_TOG(v)    (HW_PXP_RGBBUF_WR(HW_PXP_RGBBUF_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_PXP_RGBBUF bitfields
//

//--- Register HW_PXP_RGBBUF, field ADDR

#define BP_PXP_RGBBUF_ADDR      0
#define BM_PXP_RGBBUF_ADDR      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_PXP_RGBBUF_ADDR(v)   ((reg32_t) v)
#else
#define BF_PXP_RGBBUF_ADDR(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_PXP_RGBBUF_ADDR(v)   (HW_PXP_RGBBUF.B.ADDR = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_PXP_RGBBUF2 - RGB Output Frame Buffer Pointer
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  ADDR;
    } B;
} hw_pxp_rgbbuf2_t;
#endif


//
// constants & macros for entire HW_PXP_RGBBUF2 register
//

#define HW_PXP_RGBBUF2_ADDR      (REGS_PXP_BASE + 0x00000030)

#ifndef __LANGUAGE_ASM__
#define HW_PXP_RGBBUF2           (*(volatile hw_pxp_rgbbuf2_t *) HW_PXP_RGBBUF2_ADDR)
#define HW_PXP_RGBBUF2_RD()      (HW_PXP_RGBBUF2.U)
#define HW_PXP_RGBBUF2_WR(v)     (HW_PXP_RGBBUF2.U = (v))
#define HW_PXP_RGBBUF2_SET(v)    (HW_PXP_RGBBUF2_WR(HW_PXP_RGBBUF2_RD() |  (v)))
#define HW_PXP_RGBBUF2_CLR(v)    (HW_PXP_RGBBUF2_WR(HW_PXP_RGBBUF2_RD() & ~(v)))
#define HW_PXP_RGBBUF2_TOG(v)    (HW_PXP_RGBBUF2_WR(HW_PXP_RGBBUF2_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_PXP_RGBBUF2 bitfields
//

//--- Register HW_PXP_RGBBUF2, field ADDR

#define BP_PXP_RGBBUF2_ADDR      0
#define BM_PXP_RGBBUF2_ADDR      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_PXP_RGBBUF2_ADDR(v)   ((reg32_t) v)
#else
#define BF_PXP_RGBBUF2_ADDR(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_PXP_RGBBUF2_ADDR(v)   (HW_PXP_RGBBUF2.B.ADDR = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_PXP_RGBSIZE - PXP Output Buffer Size
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned HEIGHT  : 12;
        unsigned WIDTH   : 12;
        reg8_t   ALPHA;
    } B;
} hw_pxp_rgbsize_t;
#endif


//
// constants & macros for entire HW_PXP_RGBSIZE register
//

#define HW_PXP_RGBSIZE_ADDR      (REGS_PXP_BASE + 0x00000040)

#ifndef __LANGUAGE_ASM__
#define HW_PXP_RGBSIZE           (*(volatile hw_pxp_rgbsize_t *) HW_PXP_RGBSIZE_ADDR)
#define HW_PXP_RGBSIZE_RD()      (HW_PXP_RGBSIZE.U)
#define HW_PXP_RGBSIZE_WR(v)     (HW_PXP_RGBSIZE.U = (v))
#define HW_PXP_RGBSIZE_SET(v)    (HW_PXP_RGBSIZE_WR(HW_PXP_RGBSIZE_RD() |  (v)))
#define HW_PXP_RGBSIZE_CLR(v)    (HW_PXP_RGBSIZE_WR(HW_PXP_RGBSIZE_RD() & ~(v)))
#define HW_PXP_RGBSIZE_TOG(v)    (HW_PXP_RGBSIZE_WR(HW_PXP_RGBSIZE_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_PXP_RGBSIZE bitfields
//

//--- Register HW_PXP_RGBSIZE, field ALPHA

#define BP_PXP_RGBSIZE_ALPHA      24
#define BM_PXP_RGBSIZE_ALPHA      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_PXP_RGBSIZE_ALPHA(v)   ((((reg32_t) v) << 24) & BM_PXP_RGBSIZE_ALPHA)
#else
#define BF_PXP_RGBSIZE_ALPHA(v)   (((v) << 24) & BM_PXP_RGBSIZE_ALPHA)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_PXP_RGBSIZE_ALPHA(v)   (HW_PXP_RGBSIZE.B.ALPHA = (v))
#endif

//--- Register HW_PXP_RGBSIZE, field WIDTH

#define BP_PXP_RGBSIZE_WIDTH      12
#define BM_PXP_RGBSIZE_WIDTH      0x00FFF000

#define BF_PXP_RGBSIZE_WIDTH(v)   (((v) << 12) & BM_PXP_RGBSIZE_WIDTH)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_RGBSIZE_WIDTH(v)   BF_CS1(PXP_RGBSIZE, WIDTH, v)
#endif

//--- Register HW_PXP_RGBSIZE, field HEIGHT

#define BP_PXP_RGBSIZE_HEIGHT      0
#define BM_PXP_RGBSIZE_HEIGHT      0x00000FFF

#define BF_PXP_RGBSIZE_HEIGHT(v)   (((v) << 0) & BM_PXP_RGBSIZE_HEIGHT)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_RGBSIZE_HEIGHT(v)   BF_CS1(PXP_RGBSIZE, HEIGHT, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_PXP_S0BUF - PXP Source 0 (video) Input Buffer Pointer
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  ADDR;
    } B;
} hw_pxp_s0buf_t;
#endif


//
// constants & macros for entire HW_PXP_S0BUF register
//

#define HW_PXP_S0BUF_ADDR      (REGS_PXP_BASE + 0x00000050)

#ifndef __LANGUAGE_ASM__
#define HW_PXP_S0BUF           (*(volatile hw_pxp_s0buf_t *) HW_PXP_S0BUF_ADDR)
#define HW_PXP_S0BUF_RD()      (HW_PXP_S0BUF.U)
#define HW_PXP_S0BUF_WR(v)     (HW_PXP_S0BUF.U = (v))
#define HW_PXP_S0BUF_SET(v)    (HW_PXP_S0BUF_WR(HW_PXP_S0BUF_RD() |  (v)))
#define HW_PXP_S0BUF_CLR(v)    (HW_PXP_S0BUF_WR(HW_PXP_S0BUF_RD() & ~(v)))
#define HW_PXP_S0BUF_TOG(v)    (HW_PXP_S0BUF_WR(HW_PXP_S0BUF_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_PXP_S0BUF bitfields
//

//--- Register HW_PXP_S0BUF, field ADDR

#define BP_PXP_S0BUF_ADDR      0
#define BM_PXP_S0BUF_ADDR      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_PXP_S0BUF_ADDR(v)   ((reg32_t) v)
#else
#define BF_PXP_S0BUF_ADDR(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_PXP_S0BUF_ADDR(v)   (HW_PXP_S0BUF.B.ADDR = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_PXP_S0UBUF - Source 0 U/Cb Input Buffer Pointer
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  ADDR;
    } B;
} hw_pxp_s0ubuf_t;
#endif


//
// constants & macros for entire HW_PXP_S0UBUF register
//

#define HW_PXP_S0UBUF_ADDR      (REGS_PXP_BASE + 0x00000060)

#ifndef __LANGUAGE_ASM__
#define HW_PXP_S0UBUF           (*(volatile hw_pxp_s0ubuf_t *) HW_PXP_S0UBUF_ADDR)
#define HW_PXP_S0UBUF_RD()      (HW_PXP_S0UBUF.U)
#define HW_PXP_S0UBUF_WR(v)     (HW_PXP_S0UBUF.U = (v))
#define HW_PXP_S0UBUF_SET(v)    (HW_PXP_S0UBUF_WR(HW_PXP_S0UBUF_RD() |  (v)))
#define HW_PXP_S0UBUF_CLR(v)    (HW_PXP_S0UBUF_WR(HW_PXP_S0UBUF_RD() & ~(v)))
#define HW_PXP_S0UBUF_TOG(v)    (HW_PXP_S0UBUF_WR(HW_PXP_S0UBUF_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_PXP_S0UBUF bitfields
//

//--- Register HW_PXP_S0UBUF, field ADDR

#define BP_PXP_S0UBUF_ADDR      0
#define BM_PXP_S0UBUF_ADDR      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_PXP_S0UBUF_ADDR(v)   ((reg32_t) v)
#else
#define BF_PXP_S0UBUF_ADDR(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_PXP_S0UBUF_ADDR(v)   (HW_PXP_S0UBUF.B.ADDR = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_PXP_S0VBUF - Source 0 V/Cr Input Buffer Pointer
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  ADDR;
    } B;
} hw_pxp_s0vbuf_t;
#endif


//
// constants & macros for entire HW_PXP_S0VBUF register
//

#define HW_PXP_S0VBUF_ADDR      (REGS_PXP_BASE + 0x00000070)

#ifndef __LANGUAGE_ASM__
#define HW_PXP_S0VBUF           (*(volatile hw_pxp_s0vbuf_t *) HW_PXP_S0VBUF_ADDR)
#define HW_PXP_S0VBUF_RD()      (HW_PXP_S0VBUF.U)
#define HW_PXP_S0VBUF_WR(v)     (HW_PXP_S0VBUF.U = (v))
#define HW_PXP_S0VBUF_SET(v)    (HW_PXP_S0VBUF_WR(HW_PXP_S0VBUF_RD() |  (v)))
#define HW_PXP_S0VBUF_CLR(v)    (HW_PXP_S0VBUF_WR(HW_PXP_S0VBUF_RD() & ~(v)))
#define HW_PXP_S0VBUF_TOG(v)    (HW_PXP_S0VBUF_WR(HW_PXP_S0VBUF_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_PXP_S0VBUF bitfields
//

//--- Register HW_PXP_S0VBUF, field ADDR

#define BP_PXP_S0VBUF_ADDR      0
#define BM_PXP_S0VBUF_ADDR      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_PXP_S0VBUF_ADDR(v)   ((reg32_t) v)
#else
#define BF_PXP_S0VBUF_ADDR(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_PXP_S0VBUF_ADDR(v)   (HW_PXP_S0VBUF.B.ADDR = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_PXP_S0PARAM - PXP Source 0 (video) Buffer Parameters
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg8_t   HEIGHT;
        reg8_t   WIDTH;
        reg8_t   YBASE;
        reg8_t   XBASE;
    } B;
} hw_pxp_s0param_t;
#endif


//
// constants & macros for entire HW_PXP_S0PARAM register
//

#define HW_PXP_S0PARAM_ADDR      (REGS_PXP_BASE + 0x00000080)

#ifndef __LANGUAGE_ASM__
#define HW_PXP_S0PARAM           (*(volatile hw_pxp_s0param_t *) HW_PXP_S0PARAM_ADDR)
#define HW_PXP_S0PARAM_RD()      (HW_PXP_S0PARAM.U)
#define HW_PXP_S0PARAM_WR(v)     (HW_PXP_S0PARAM.U = (v))
#define HW_PXP_S0PARAM_SET(v)    (HW_PXP_S0PARAM_WR(HW_PXP_S0PARAM_RD() |  (v)))
#define HW_PXP_S0PARAM_CLR(v)    (HW_PXP_S0PARAM_WR(HW_PXP_S0PARAM_RD() & ~(v)))
#define HW_PXP_S0PARAM_TOG(v)    (HW_PXP_S0PARAM_WR(HW_PXP_S0PARAM_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_PXP_S0PARAM bitfields
//

//--- Register HW_PXP_S0PARAM, field XBASE

#define BP_PXP_S0PARAM_XBASE      24
#define BM_PXP_S0PARAM_XBASE      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_PXP_S0PARAM_XBASE(v)   ((((reg32_t) v) << 24) & BM_PXP_S0PARAM_XBASE)
#else
#define BF_PXP_S0PARAM_XBASE(v)   (((v) << 24) & BM_PXP_S0PARAM_XBASE)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_PXP_S0PARAM_XBASE(v)   (HW_PXP_S0PARAM.B.XBASE = (v))
#endif

//--- Register HW_PXP_S0PARAM, field YBASE

#define BP_PXP_S0PARAM_YBASE      16
#define BM_PXP_S0PARAM_YBASE      0x00FF0000

#define BF_PXP_S0PARAM_YBASE(v)   (((v) << 16) & BM_PXP_S0PARAM_YBASE)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_S0PARAM_YBASE(v)   (HW_PXP_S0PARAM.B.YBASE = (v))
#endif

//--- Register HW_PXP_S0PARAM, field WIDTH

#define BP_PXP_S0PARAM_WIDTH      8
#define BM_PXP_S0PARAM_WIDTH      0x0000FF00

#define BF_PXP_S0PARAM_WIDTH(v)   (((v) << 8) & BM_PXP_S0PARAM_WIDTH)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_S0PARAM_WIDTH(v)   (HW_PXP_S0PARAM.B.WIDTH = (v))
#endif

//--- Register HW_PXP_S0PARAM, field HEIGHT

#define BP_PXP_S0PARAM_HEIGHT      0
#define BM_PXP_S0PARAM_HEIGHT      0x000000FF

#define BF_PXP_S0PARAM_HEIGHT(v)   (((v) << 0) & BM_PXP_S0PARAM_HEIGHT)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_S0PARAM_HEIGHT(v)   (HW_PXP_S0PARAM.B.HEIGHT = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_PXP_S0BACKGROUND - Source 0 Background Color
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  COLOR;
    } B;
} hw_pxp_s0background_t;
#endif


//
// constants & macros for entire HW_PXP_S0BACKGROUND register
//

#define HW_PXP_S0BACKGROUND_ADDR      (REGS_PXP_BASE + 0x00000090)

#ifndef __LANGUAGE_ASM__
#define HW_PXP_S0BACKGROUND           (*(volatile hw_pxp_s0background_t *) HW_PXP_S0BACKGROUND_ADDR)
#define HW_PXP_S0BACKGROUND_RD()      (HW_PXP_S0BACKGROUND.U)
#define HW_PXP_S0BACKGROUND_WR(v)     (HW_PXP_S0BACKGROUND.U = (v))
#define HW_PXP_S0BACKGROUND_SET(v)    (HW_PXP_S0BACKGROUND_WR(HW_PXP_S0BACKGROUND_RD() |  (v)))
#define HW_PXP_S0BACKGROUND_CLR(v)    (HW_PXP_S0BACKGROUND_WR(HW_PXP_S0BACKGROUND_RD() & ~(v)))
#define HW_PXP_S0BACKGROUND_TOG(v)    (HW_PXP_S0BACKGROUND_WR(HW_PXP_S0BACKGROUND_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_PXP_S0BACKGROUND bitfields
//

//--- Register HW_PXP_S0BACKGROUND, field COLOR

#define BP_PXP_S0BACKGROUND_COLOR      0
#define BM_PXP_S0BACKGROUND_COLOR      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_PXP_S0BACKGROUND_COLOR(v)   ((reg32_t) v)
#else
#define BF_PXP_S0BACKGROUND_COLOR(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_PXP_S0BACKGROUND_COLOR(v)   (HW_PXP_S0BACKGROUND.B.COLOR = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_PXP_S0CROP - Source 0 Cropping Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg8_t   HEIGHT;
        reg8_t   WIDTH;
        reg8_t   YBASE;
        reg8_t   XBASE;
    } B;
} hw_pxp_s0crop_t;
#endif


//
// constants & macros for entire HW_PXP_S0CROP register
//

#define HW_PXP_S0CROP_ADDR      (REGS_PXP_BASE + 0x000000A0)

#ifndef __LANGUAGE_ASM__
#define HW_PXP_S0CROP           (*(volatile hw_pxp_s0crop_t *) HW_PXP_S0CROP_ADDR)
#define HW_PXP_S0CROP_RD()      (HW_PXP_S0CROP.U)
#define HW_PXP_S0CROP_WR(v)     (HW_PXP_S0CROP.U = (v))
#define HW_PXP_S0CROP_SET(v)    (HW_PXP_S0CROP_WR(HW_PXP_S0CROP_RD() |  (v)))
#define HW_PXP_S0CROP_CLR(v)    (HW_PXP_S0CROP_WR(HW_PXP_S0CROP_RD() & ~(v)))
#define HW_PXP_S0CROP_TOG(v)    (HW_PXP_S0CROP_WR(HW_PXP_S0CROP_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_PXP_S0CROP bitfields
//

//--- Register HW_PXP_S0CROP, field XBASE

#define BP_PXP_S0CROP_XBASE      24
#define BM_PXP_S0CROP_XBASE      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_PXP_S0CROP_XBASE(v)   ((((reg32_t) v) << 24) & BM_PXP_S0CROP_XBASE)
#else
#define BF_PXP_S0CROP_XBASE(v)   (((v) << 24) & BM_PXP_S0CROP_XBASE)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_PXP_S0CROP_XBASE(v)   (HW_PXP_S0CROP.B.XBASE = (v))
#endif

//--- Register HW_PXP_S0CROP, field YBASE

#define BP_PXP_S0CROP_YBASE      16
#define BM_PXP_S0CROP_YBASE      0x00FF0000

#define BF_PXP_S0CROP_YBASE(v)   (((v) << 16) & BM_PXP_S0CROP_YBASE)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_S0CROP_YBASE(v)   (HW_PXP_S0CROP.B.YBASE = (v))
#endif

//--- Register HW_PXP_S0CROP, field WIDTH

#define BP_PXP_S0CROP_WIDTH      8
#define BM_PXP_S0CROP_WIDTH      0x0000FF00

#define BF_PXP_S0CROP_WIDTH(v)   (((v) << 8) & BM_PXP_S0CROP_WIDTH)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_S0CROP_WIDTH(v)   (HW_PXP_S0CROP.B.WIDTH = (v))
#endif

//--- Register HW_PXP_S0CROP, field HEIGHT

#define BP_PXP_S0CROP_HEIGHT      0
#define BM_PXP_S0CROP_HEIGHT      0x000000FF

#define BF_PXP_S0CROP_HEIGHT(v)   (((v) << 0) & BM_PXP_S0CROP_HEIGHT)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_S0CROP_HEIGHT(v)   (HW_PXP_S0CROP.B.HEIGHT = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_PXP_S0SCALE - Source 0 Scale Factor Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned XSCALE  : 14;
        unsigned RSVD1   :  2;
        unsigned YSCALE  : 14;
        unsigned RSVD2   :  2;
    } B;
} hw_pxp_s0scale_t;
#endif


//
// constants & macros for entire HW_PXP_S0SCALE register
//

#define HW_PXP_S0SCALE_ADDR      (REGS_PXP_BASE + 0x000000B0)

#ifndef __LANGUAGE_ASM__
#define HW_PXP_S0SCALE           (*(volatile hw_pxp_s0scale_t *) HW_PXP_S0SCALE_ADDR)
#define HW_PXP_S0SCALE_RD()      (HW_PXP_S0SCALE.U)
#define HW_PXP_S0SCALE_WR(v)     (HW_PXP_S0SCALE.U = (v))
#define HW_PXP_S0SCALE_SET(v)    (HW_PXP_S0SCALE_WR(HW_PXP_S0SCALE_RD() |  (v)))
#define HW_PXP_S0SCALE_CLR(v)    (HW_PXP_S0SCALE_WR(HW_PXP_S0SCALE_RD() & ~(v)))
#define HW_PXP_S0SCALE_TOG(v)    (HW_PXP_S0SCALE_WR(HW_PXP_S0SCALE_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_PXP_S0SCALE bitfields
//

//--- Register HW_PXP_S0SCALE, field YSCALE

#define BP_PXP_S0SCALE_YSCALE      16
#define BM_PXP_S0SCALE_YSCALE      0x3FFF0000

#define BF_PXP_S0SCALE_YSCALE(v)   (((v) << 16) & BM_PXP_S0SCALE_YSCALE)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_S0SCALE_YSCALE(v)   BF_CS1(PXP_S0SCALE, YSCALE, v)
#endif

//--- Register HW_PXP_S0SCALE, field XSCALE

#define BP_PXP_S0SCALE_XSCALE      0
#define BM_PXP_S0SCALE_XSCALE      0x00003FFF

#define BF_PXP_S0SCALE_XSCALE(v)   (((v) << 0) & BM_PXP_S0SCALE_XSCALE)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_S0SCALE_XSCALE(v)   BF_CS1(PXP_S0SCALE, XSCALE, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_PXP_S0OFFSET - Source 0 Scale Offset Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned XOFFSET  : 12;
        unsigned RSVD1    :  4;
        unsigned YOFFSET  : 12;
        unsigned RSVD2    :  4;
    } B;
} hw_pxp_s0offset_t;
#endif


//
// constants & macros for entire HW_PXP_S0OFFSET register
//

#define HW_PXP_S0OFFSET_ADDR      (REGS_PXP_BASE + 0x000000C0)

#ifndef __LANGUAGE_ASM__
#define HW_PXP_S0OFFSET           (*(volatile hw_pxp_s0offset_t *) HW_PXP_S0OFFSET_ADDR)
#define HW_PXP_S0OFFSET_RD()      (HW_PXP_S0OFFSET.U)
#define HW_PXP_S0OFFSET_WR(v)     (HW_PXP_S0OFFSET.U = (v))
#define HW_PXP_S0OFFSET_SET(v)    (HW_PXP_S0OFFSET_WR(HW_PXP_S0OFFSET_RD() |  (v)))
#define HW_PXP_S0OFFSET_CLR(v)    (HW_PXP_S0OFFSET_WR(HW_PXP_S0OFFSET_RD() & ~(v)))
#define HW_PXP_S0OFFSET_TOG(v)    (HW_PXP_S0OFFSET_WR(HW_PXP_S0OFFSET_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_PXP_S0OFFSET bitfields
//

//--- Register HW_PXP_S0OFFSET, field YOFFSET

#define BP_PXP_S0OFFSET_YOFFSET      16
#define BM_PXP_S0OFFSET_YOFFSET      0x0FFF0000

#define BF_PXP_S0OFFSET_YOFFSET(v)   (((v) << 16) & BM_PXP_S0OFFSET_YOFFSET)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_S0OFFSET_YOFFSET(v)   BF_CS1(PXP_S0OFFSET, YOFFSET, v)
#endif

//--- Register HW_PXP_S0OFFSET, field XOFFSET

#define BP_PXP_S0OFFSET_XOFFSET      0
#define BM_PXP_S0OFFSET_XOFFSET      0x00000FFF

#define BF_PXP_S0OFFSET_XOFFSET(v)   (((v) << 0) & BM_PXP_S0OFFSET_XOFFSET)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_S0OFFSET_XOFFSET(v)   BF_CS1(PXP_S0OFFSET, XOFFSET, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_PXP_CSCCOEFF0 - Color Space Conversion Coefficient Register 0
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned Y_OFFSET    :  9;
        unsigned UV_OFFSET   :  9;
        unsigned C0          : 11;
        unsigned RSVD1       :  2;
        unsigned YCBCR_MODE  :  1;
    } B;
} hw_pxp_csccoeff0_t;
#endif


//
// constants & macros for entire HW_PXP_CSCCOEFF0 register
//

#define HW_PXP_CSCCOEFF0_ADDR      (REGS_PXP_BASE + 0x000000D0)

#ifndef __LANGUAGE_ASM__
#define HW_PXP_CSCCOEFF0           (*(volatile hw_pxp_csccoeff0_t *) HW_PXP_CSCCOEFF0_ADDR)
#define HW_PXP_CSCCOEFF0_RD()      (HW_PXP_CSCCOEFF0.U)
#define HW_PXP_CSCCOEFF0_WR(v)     (HW_PXP_CSCCOEFF0.U = (v))
#define HW_PXP_CSCCOEFF0_SET(v)    (HW_PXP_CSCCOEFF0_WR(HW_PXP_CSCCOEFF0_RD() |  (v)))
#define HW_PXP_CSCCOEFF0_CLR(v)    (HW_PXP_CSCCOEFF0_WR(HW_PXP_CSCCOEFF0_RD() & ~(v)))
#define HW_PXP_CSCCOEFF0_TOG(v)    (HW_PXP_CSCCOEFF0_WR(HW_PXP_CSCCOEFF0_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_PXP_CSCCOEFF0 bitfields
//

//--- Register HW_PXP_CSCCOEFF0, field YCBCR_MODE

#define BP_PXP_CSCCOEFF0_YCBCR_MODE      31
#define BM_PXP_CSCCOEFF0_YCBCR_MODE      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_PXP_CSCCOEFF0_YCBCR_MODE(v)   ((((reg32_t) v) << 31) & BM_PXP_CSCCOEFF0_YCBCR_MODE)
#else
#define BF_PXP_CSCCOEFF0_YCBCR_MODE(v)   (((v) << 31) & BM_PXP_CSCCOEFF0_YCBCR_MODE)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_PXP_CSCCOEFF0_YCBCR_MODE(v)   BF_CS1(PXP_CSCCOEFF0, YCBCR_MODE, v)
#endif

//--- Register HW_PXP_CSCCOEFF0, field C0

#define BP_PXP_CSCCOEFF0_C0      18
#define BM_PXP_CSCCOEFF0_C0      0x1FFC0000

#define BF_PXP_CSCCOEFF0_C0(v)   (((v) << 18) & BM_PXP_CSCCOEFF0_C0)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_CSCCOEFF0_C0(v)   BF_CS1(PXP_CSCCOEFF0, C0, v)
#endif

//--- Register HW_PXP_CSCCOEFF0, field UV_OFFSET

#define BP_PXP_CSCCOEFF0_UV_OFFSET      9
#define BM_PXP_CSCCOEFF0_UV_OFFSET      0x0003FE00

#define BF_PXP_CSCCOEFF0_UV_OFFSET(v)   (((v) << 9) & BM_PXP_CSCCOEFF0_UV_OFFSET)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_CSCCOEFF0_UV_OFFSET(v)   BF_CS1(PXP_CSCCOEFF0, UV_OFFSET, v)
#endif

//--- Register HW_PXP_CSCCOEFF0, field Y_OFFSET

#define BP_PXP_CSCCOEFF0_Y_OFFSET      0
#define BM_PXP_CSCCOEFF0_Y_OFFSET      0x000001FF

#define BF_PXP_CSCCOEFF0_Y_OFFSET(v)   (((v) << 0) & BM_PXP_CSCCOEFF0_Y_OFFSET)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_CSCCOEFF0_Y_OFFSET(v)   BF_CS1(PXP_CSCCOEFF0, Y_OFFSET, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_PXP_CSCCOEFF1 - Color Space Conversion Coefficient Register 1
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned C4     : 11;
        unsigned RSVD0  :  5;
        unsigned C1     : 11;
        unsigned RSVD1  :  5;
    } B;
} hw_pxp_csccoeff1_t;
#endif


//
// constants & macros for entire HW_PXP_CSCCOEFF1 register
//

#define HW_PXP_CSCCOEFF1_ADDR      (REGS_PXP_BASE + 0x000000E0)

#ifndef __LANGUAGE_ASM__
#define HW_PXP_CSCCOEFF1           (*(volatile hw_pxp_csccoeff1_t *) HW_PXP_CSCCOEFF1_ADDR)
#define HW_PXP_CSCCOEFF1_RD()      (HW_PXP_CSCCOEFF1.U)
#define HW_PXP_CSCCOEFF1_WR(v)     (HW_PXP_CSCCOEFF1.U = (v))
#define HW_PXP_CSCCOEFF1_SET(v)    (HW_PXP_CSCCOEFF1_WR(HW_PXP_CSCCOEFF1_RD() |  (v)))
#define HW_PXP_CSCCOEFF1_CLR(v)    (HW_PXP_CSCCOEFF1_WR(HW_PXP_CSCCOEFF1_RD() & ~(v)))
#define HW_PXP_CSCCOEFF1_TOG(v)    (HW_PXP_CSCCOEFF1_WR(HW_PXP_CSCCOEFF1_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_PXP_CSCCOEFF1 bitfields
//

//--- Register HW_PXP_CSCCOEFF1, field C1

#define BP_PXP_CSCCOEFF1_C1      16
#define BM_PXP_CSCCOEFF1_C1      0x07FF0000

#define BF_PXP_CSCCOEFF1_C1(v)   (((v) << 16) & BM_PXP_CSCCOEFF1_C1)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_CSCCOEFF1_C1(v)   BF_CS1(PXP_CSCCOEFF1, C1, v)
#endif

//--- Register HW_PXP_CSCCOEFF1, field C4

#define BP_PXP_CSCCOEFF1_C4      0
#define BM_PXP_CSCCOEFF1_C4      0x000007FF

#define BF_PXP_CSCCOEFF1_C4(v)   (((v) << 0) & BM_PXP_CSCCOEFF1_C4)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_CSCCOEFF1_C4(v)   BF_CS1(PXP_CSCCOEFF1, C4, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_PXP_CSCCOEFF2 - Color Space Conversion Coefficient Register 2
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned C3     : 11;
        unsigned RSVD0  :  5;
        unsigned C2     : 11;
        unsigned RSVD1  :  5;
    } B;
} hw_pxp_csccoeff2_t;
#endif


//
// constants & macros for entire HW_PXP_CSCCOEFF2 register
//

#define HW_PXP_CSCCOEFF2_ADDR      (REGS_PXP_BASE + 0x000000F0)

#ifndef __LANGUAGE_ASM__
#define HW_PXP_CSCCOEFF2           (*(volatile hw_pxp_csccoeff2_t *) HW_PXP_CSCCOEFF2_ADDR)
#define HW_PXP_CSCCOEFF2_RD()      (HW_PXP_CSCCOEFF2.U)
#define HW_PXP_CSCCOEFF2_WR(v)     (HW_PXP_CSCCOEFF2.U = (v))
#define HW_PXP_CSCCOEFF2_SET(v)    (HW_PXP_CSCCOEFF2_WR(HW_PXP_CSCCOEFF2_RD() |  (v)))
#define HW_PXP_CSCCOEFF2_CLR(v)    (HW_PXP_CSCCOEFF2_WR(HW_PXP_CSCCOEFF2_RD() & ~(v)))
#define HW_PXP_CSCCOEFF2_TOG(v)    (HW_PXP_CSCCOEFF2_WR(HW_PXP_CSCCOEFF2_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_PXP_CSCCOEFF2 bitfields
//

//--- Register HW_PXP_CSCCOEFF2, field C2

#define BP_PXP_CSCCOEFF2_C2      16
#define BM_PXP_CSCCOEFF2_C2      0x07FF0000

#define BF_PXP_CSCCOEFF2_C2(v)   (((v) << 16) & BM_PXP_CSCCOEFF2_C2)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_CSCCOEFF2_C2(v)   BF_CS1(PXP_CSCCOEFF2, C2, v)
#endif

//--- Register HW_PXP_CSCCOEFF2, field C3

#define BP_PXP_CSCCOEFF2_C3      0
#define BM_PXP_CSCCOEFF2_C3      0x000007FF

#define BF_PXP_CSCCOEFF2_C3(v)   (((v) << 0) & BM_PXP_CSCCOEFF2_C3)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_CSCCOEFF2_C3(v)   BF_CS1(PXP_CSCCOEFF2, C3, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_PXP_NEXT - PXP Next Frame Pointer
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ENABLED  :  1;
        unsigned RSVD     :  1;
        unsigned POINTER  : 30;
    } B;
} hw_pxp_next_t;
#endif


//
// constants & macros for entire HW_PXP_NEXT register
//

#define HW_PXP_NEXT_ADDR      (REGS_PXP_BASE + 0x00000100)
#define HW_PXP_NEXT_SET_ADDR  (REGS_PXP_BASE + 0x00000104)
#define HW_PXP_NEXT_CLR_ADDR  (REGS_PXP_BASE + 0x00000108)
#define HW_PXP_NEXT_TOG_ADDR  (REGS_PXP_BASE + 0x0000010C)

#ifndef __LANGUAGE_ASM__
#define HW_PXP_NEXT           (*(volatile hw_pxp_next_t *) HW_PXP_NEXT_ADDR)
#define HW_PXP_NEXT_RD()      (HW_PXP_NEXT.U)
#define HW_PXP_NEXT_WR(v)     (HW_PXP_NEXT.U = (v))
#define HW_PXP_NEXT_SET(v)    ((*(volatile reg32_t *) HW_PXP_NEXT_SET_ADDR) = (v))
#define HW_PXP_NEXT_CLR(v)    ((*(volatile reg32_t *) HW_PXP_NEXT_CLR_ADDR) = (v))
#define HW_PXP_NEXT_TOG(v)    ((*(volatile reg32_t *) HW_PXP_NEXT_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_PXP_NEXT bitfields
//

//--- Register HW_PXP_NEXT, field POINTER

#define BP_PXP_NEXT_POINTER      2
#define BM_PXP_NEXT_POINTER      0xFFFFFFFC

#ifndef __LANGUAGE_ASM__
#define BF_PXP_NEXT_POINTER(v)   ((((reg32_t) v) << 2) & BM_PXP_NEXT_POINTER)
#else
#define BF_PXP_NEXT_POINTER(v)   (((v) << 2) & BM_PXP_NEXT_POINTER)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_PXP_NEXT_POINTER(v)   BF_CS1(PXP_NEXT, POINTER, v)
#endif

//--- Register HW_PXP_NEXT, field ENABLED

#define BP_PXP_NEXT_ENABLED      0
#define BM_PXP_NEXT_ENABLED      0x00000001

#define BF_PXP_NEXT_ENABLED(v)   (((v) << 0) & BM_PXP_NEXT_ENABLED)


////////////////////////////////////////////////////////////////////////////////
//// HW_PXP_PAGETABLE - PXP Page Table Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ENABLE  :  1;
        unsigned FLUSH   :  1;
        unsigned RSVD1   : 12;
        unsigned BASE    : 18;
    } B;
} hw_pxp_pagetable_t;
#endif


//
// constants & macros for entire HW_PXP_PAGETABLE register
//

#define HW_PXP_PAGETABLE_ADDR      (REGS_PXP_BASE + 0x00000170)

#ifndef __LANGUAGE_ASM__
#define HW_PXP_PAGETABLE           (*(volatile hw_pxp_pagetable_t *) HW_PXP_PAGETABLE_ADDR)
#define HW_PXP_PAGETABLE_RD()      (HW_PXP_PAGETABLE.U)
#define HW_PXP_PAGETABLE_WR(v)     (HW_PXP_PAGETABLE.U = (v))
#define HW_PXP_PAGETABLE_SET(v)    (HW_PXP_PAGETABLE_WR(HW_PXP_PAGETABLE_RD() |  (v)))
#define HW_PXP_PAGETABLE_CLR(v)    (HW_PXP_PAGETABLE_WR(HW_PXP_PAGETABLE_RD() & ~(v)))
#define HW_PXP_PAGETABLE_TOG(v)    (HW_PXP_PAGETABLE_WR(HW_PXP_PAGETABLE_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_PXP_PAGETABLE bitfields
//

//--- Register HW_PXP_PAGETABLE, field BASE

#define BP_PXP_PAGETABLE_BASE      14
#define BM_PXP_PAGETABLE_BASE      0xFFFFC000

#ifndef __LANGUAGE_ASM__
#define BF_PXP_PAGETABLE_BASE(v)   ((((reg32_t) v) << 14) & BM_PXP_PAGETABLE_BASE)
#else
#define BF_PXP_PAGETABLE_BASE(v)   (((v) << 14) & BM_PXP_PAGETABLE_BASE)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_PXP_PAGETABLE_BASE(v)   BF_CS1(PXP_PAGETABLE, BASE, v)
#endif

//--- Register HW_PXP_PAGETABLE, field FLUSH

#define BP_PXP_PAGETABLE_FLUSH      1
#define BM_PXP_PAGETABLE_FLUSH      0x00000002

#define BF_PXP_PAGETABLE_FLUSH(v)   (((v) << 1) & BM_PXP_PAGETABLE_FLUSH)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_PAGETABLE_FLUSH(v)   BF_CS1(PXP_PAGETABLE, FLUSH, v)
#endif

//--- Register HW_PXP_PAGETABLE, field ENABLE

#define BP_PXP_PAGETABLE_ENABLE      0
#define BM_PXP_PAGETABLE_ENABLE      0x00000001

#define BF_PXP_PAGETABLE_ENABLE(v)   (((v) << 0) & BM_PXP_PAGETABLE_ENABLE)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_PAGETABLE_ENABLE(v)   BF_CS1(PXP_PAGETABLE, ENABLE, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_PXP_S0COLORKEYLOW - PXP S0 Color Key Low
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PIXEL  : 24;
        reg8_t   RSVD1;
    } B;
} hw_pxp_s0colorkeylow_t;
#endif


//
// constants & macros for entire HW_PXP_S0COLORKEYLOW register
//

#define HW_PXP_S0COLORKEYLOW_ADDR      (REGS_PXP_BASE + 0x00000180)

#ifndef __LANGUAGE_ASM__
#define HW_PXP_S0COLORKEYLOW           (*(volatile hw_pxp_s0colorkeylow_t *) HW_PXP_S0COLORKEYLOW_ADDR)
#define HW_PXP_S0COLORKEYLOW_RD()      (HW_PXP_S0COLORKEYLOW.U)
#define HW_PXP_S0COLORKEYLOW_WR(v)     (HW_PXP_S0COLORKEYLOW.U = (v))
#define HW_PXP_S0COLORKEYLOW_SET(v)    (HW_PXP_S0COLORKEYLOW_WR(HW_PXP_S0COLORKEYLOW_RD() |  (v)))
#define HW_PXP_S0COLORKEYLOW_CLR(v)    (HW_PXP_S0COLORKEYLOW_WR(HW_PXP_S0COLORKEYLOW_RD() & ~(v)))
#define HW_PXP_S0COLORKEYLOW_TOG(v)    (HW_PXP_S0COLORKEYLOW_WR(HW_PXP_S0COLORKEYLOW_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_PXP_S0COLORKEYLOW bitfields
//

//--- Register HW_PXP_S0COLORKEYLOW, field PIXEL

#define BP_PXP_S0COLORKEYLOW_PIXEL      0
#define BM_PXP_S0COLORKEYLOW_PIXEL      0x00FFFFFF

#define BF_PXP_S0COLORKEYLOW_PIXEL(v)   (((v) << 0) & BM_PXP_S0COLORKEYLOW_PIXEL)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_S0COLORKEYLOW_PIXEL(v)   BF_CS1(PXP_S0COLORKEYLOW, PIXEL, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_PXP_S0COLORKEYHIGH - PXP S0 Color Key High
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PIXEL  : 24;
        reg8_t   RSVD1;
    } B;
} hw_pxp_s0colorkeyhigh_t;
#endif


//
// constants & macros for entire HW_PXP_S0COLORKEYHIGH register
//

#define HW_PXP_S0COLORKEYHIGH_ADDR      (REGS_PXP_BASE + 0x00000190)

#ifndef __LANGUAGE_ASM__
#define HW_PXP_S0COLORKEYHIGH           (*(volatile hw_pxp_s0colorkeyhigh_t *) HW_PXP_S0COLORKEYHIGH_ADDR)
#define HW_PXP_S0COLORKEYHIGH_RD()      (HW_PXP_S0COLORKEYHIGH.U)
#define HW_PXP_S0COLORKEYHIGH_WR(v)     (HW_PXP_S0COLORKEYHIGH.U = (v))
#define HW_PXP_S0COLORKEYHIGH_SET(v)    (HW_PXP_S0COLORKEYHIGH_WR(HW_PXP_S0COLORKEYHIGH_RD() |  (v)))
#define HW_PXP_S0COLORKEYHIGH_CLR(v)    (HW_PXP_S0COLORKEYHIGH_WR(HW_PXP_S0COLORKEYHIGH_RD() & ~(v)))
#define HW_PXP_S0COLORKEYHIGH_TOG(v)    (HW_PXP_S0COLORKEYHIGH_WR(HW_PXP_S0COLORKEYHIGH_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_PXP_S0COLORKEYHIGH bitfields
//

//--- Register HW_PXP_S0COLORKEYHIGH, field PIXEL

#define BP_PXP_S0COLORKEYHIGH_PIXEL      0
#define BM_PXP_S0COLORKEYHIGH_PIXEL      0x00FFFFFF

#define BF_PXP_S0COLORKEYHIGH_PIXEL(v)   (((v) << 0) & BM_PXP_S0COLORKEYHIGH_PIXEL)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_S0COLORKEYHIGH_PIXEL(v)   BF_CS1(PXP_S0COLORKEYHIGH, PIXEL, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_PXP_OLCOLORKEYLOW - PXP Overlay Color Key Low
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PIXEL  : 24;
        reg8_t   RSVD1;
    } B;
} hw_pxp_olcolorkeylow_t;
#endif


//
// constants & macros for entire HW_PXP_OLCOLORKEYLOW register
//

#define HW_PXP_OLCOLORKEYLOW_ADDR      (REGS_PXP_BASE + 0x000001A0)

#ifndef __LANGUAGE_ASM__
#define HW_PXP_OLCOLORKEYLOW           (*(volatile hw_pxp_olcolorkeylow_t *) HW_PXP_OLCOLORKEYLOW_ADDR)
#define HW_PXP_OLCOLORKEYLOW_RD()      (HW_PXP_OLCOLORKEYLOW.U)
#define HW_PXP_OLCOLORKEYLOW_WR(v)     (HW_PXP_OLCOLORKEYLOW.U = (v))
#define HW_PXP_OLCOLORKEYLOW_SET(v)    (HW_PXP_OLCOLORKEYLOW_WR(HW_PXP_OLCOLORKEYLOW_RD() |  (v)))
#define HW_PXP_OLCOLORKEYLOW_CLR(v)    (HW_PXP_OLCOLORKEYLOW_WR(HW_PXP_OLCOLORKEYLOW_RD() & ~(v)))
#define HW_PXP_OLCOLORKEYLOW_TOG(v)    (HW_PXP_OLCOLORKEYLOW_WR(HW_PXP_OLCOLORKEYLOW_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_PXP_OLCOLORKEYLOW bitfields
//

//--- Register HW_PXP_OLCOLORKEYLOW, field PIXEL

#define BP_PXP_OLCOLORKEYLOW_PIXEL      0
#define BM_PXP_OLCOLORKEYLOW_PIXEL      0x00FFFFFF

#define BF_PXP_OLCOLORKEYLOW_PIXEL(v)   (((v) << 0) & BM_PXP_OLCOLORKEYLOW_PIXEL)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_OLCOLORKEYLOW_PIXEL(v)   BF_CS1(PXP_OLCOLORKEYLOW, PIXEL, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_PXP_OLCOLORKEYHIGH - PXP Overlay Color Key High
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PIXEL  : 24;
        reg8_t   RSVD1;
    } B;
} hw_pxp_olcolorkeyhigh_t;
#endif


//
// constants & macros for entire HW_PXP_OLCOLORKEYHIGH register
//

#define HW_PXP_OLCOLORKEYHIGH_ADDR      (REGS_PXP_BASE + 0x000001B0)

#ifndef __LANGUAGE_ASM__
#define HW_PXP_OLCOLORKEYHIGH           (*(volatile hw_pxp_olcolorkeyhigh_t *) HW_PXP_OLCOLORKEYHIGH_ADDR)
#define HW_PXP_OLCOLORKEYHIGH_RD()      (HW_PXP_OLCOLORKEYHIGH.U)
#define HW_PXP_OLCOLORKEYHIGH_WR(v)     (HW_PXP_OLCOLORKEYHIGH.U = (v))
#define HW_PXP_OLCOLORKEYHIGH_SET(v)    (HW_PXP_OLCOLORKEYHIGH_WR(HW_PXP_OLCOLORKEYHIGH_RD() |  (v)))
#define HW_PXP_OLCOLORKEYHIGH_CLR(v)    (HW_PXP_OLCOLORKEYHIGH_WR(HW_PXP_OLCOLORKEYHIGH_RD() & ~(v)))
#define HW_PXP_OLCOLORKEYHIGH_TOG(v)    (HW_PXP_OLCOLORKEYHIGH_WR(HW_PXP_OLCOLORKEYHIGH_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_PXP_OLCOLORKEYHIGH bitfields
//

//--- Register HW_PXP_OLCOLORKEYHIGH, field PIXEL

#define BP_PXP_OLCOLORKEYHIGH_PIXEL      0
#define BM_PXP_OLCOLORKEYHIGH_PIXEL      0x00FFFFFF

#define BF_PXP_OLCOLORKEYHIGH_PIXEL(v)   (((v) << 0) & BM_PXP_OLCOLORKEYHIGH_PIXEL)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_OLCOLORKEYHIGH_PIXEL(v)   BF_CS1(PXP_OLCOLORKEYHIGH, PIXEL, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_PXP_DEBUGCTRL - PXP Debug Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg8_t   SELECT;
        unsigned RESET_TLB_STATS  :  1;
        unsigned RSVD             : 23;
    } B;
} hw_pxp_debugctrl_t;
#endif


//
// constants & macros for entire HW_PXP_DEBUGCTRL register
//

#define HW_PXP_DEBUGCTRL_ADDR      (REGS_PXP_BASE + 0x000001D0)

#ifndef __LANGUAGE_ASM__
#define HW_PXP_DEBUGCTRL           (*(volatile hw_pxp_debugctrl_t *) HW_PXP_DEBUGCTRL_ADDR)
#define HW_PXP_DEBUGCTRL_RD()      (HW_PXP_DEBUGCTRL.U)
#define HW_PXP_DEBUGCTRL_WR(v)     (HW_PXP_DEBUGCTRL.U = (v))
#define HW_PXP_DEBUGCTRL_SET(v)    (HW_PXP_DEBUGCTRL_WR(HW_PXP_DEBUGCTRL_RD() |  (v)))
#define HW_PXP_DEBUGCTRL_CLR(v)    (HW_PXP_DEBUGCTRL_WR(HW_PXP_DEBUGCTRL_RD() & ~(v)))
#define HW_PXP_DEBUGCTRL_TOG(v)    (HW_PXP_DEBUGCTRL_WR(HW_PXP_DEBUGCTRL_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_PXP_DEBUGCTRL bitfields
//

//--- Register HW_PXP_DEBUGCTRL, field RESET_TLB_STATS

#define BP_PXP_DEBUGCTRL_RESET_TLB_STATS      8
#define BM_PXP_DEBUGCTRL_RESET_TLB_STATS      0x00000100

#define BF_PXP_DEBUGCTRL_RESET_TLB_STATS(v)   (((v) << 8) & BM_PXP_DEBUGCTRL_RESET_TLB_STATS)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_DEBUGCTRL_RESET_TLB_STATS(v)   BF_CS1(PXP_DEBUGCTRL, RESET_TLB_STATS, v)
#endif

//--- Register HW_PXP_DEBUGCTRL, field SELECT

#define BP_PXP_DEBUGCTRL_SELECT      0
#define BM_PXP_DEBUGCTRL_SELECT      0x000000FF

#define BF_PXP_DEBUGCTRL_SELECT(v)   (((v) << 0) & BM_PXP_DEBUGCTRL_SELECT)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_DEBUGCTRL_SELECT(v)   (HW_PXP_DEBUGCTRL.B.SELECT = (v))
#endif

#define BV_PXP_DEBUGCTRL_SELECT__NONE      0x0
#define BV_PXP_DEBUGCTRL_SELECT__CTRL      0x1
#define BV_PXP_DEBUGCTRL_SELECT__S0REGS    0x2
#define BV_PXP_DEBUGCTRL_SELECT__S0BAX     0x3
#define BV_PXP_DEBUGCTRL_SELECT__S0BAY     0x4
#define BV_PXP_DEBUGCTRL_SELECT__PXBUF     0x5
#define BV_PXP_DEBUGCTRL_SELECT__ROTATION  0x6
#define BV_PXP_DEBUGCTRL_SELECT__ROTBUF0   0x7
#define BV_PXP_DEBUGCTRL_SELECT__ROTBUF1   0x8
#define BV_PXP_DEBUGCTRL_SELECT__TLBCOUNT  0xF0
#define BV_PXP_DEBUGCTRL_SELECT__TLBHIT    0xF1
#define BV_PXP_DEBUGCTRL_SELECT__TLBMISS   0xF2
#define BV_PXP_DEBUGCTRL_SELECT__TLBLAT    0xF3
#define BV_PXP_DEBUGCTRL_SELECT__TLBSTATE  0xF8


////////////////////////////////////////////////////////////////////////////////
//// HW_PXP_DEBUG - PXP Debug Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_pxp_debug_t;
#endif


//
// constants & macros for entire HW_PXP_DEBUG register
//

#define HW_PXP_DEBUG_ADDR      (REGS_PXP_BASE + 0x000001E0)

#ifndef __LANGUAGE_ASM__
#define HW_PXP_DEBUG           (*(volatile hw_pxp_debug_t *) HW_PXP_DEBUG_ADDR)
#define HW_PXP_DEBUG_RD()      (HW_PXP_DEBUG.U)
#endif


//
// constants & macros for individual HW_PXP_DEBUG bitfields
//

//--- Register HW_PXP_DEBUG, field DATA

#define BP_PXP_DEBUG_DATA      0
#define BM_PXP_DEBUG_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_PXP_DEBUG_DATA(v)   ((reg32_t) v)
#else
#define BF_PXP_DEBUG_DATA(v)   (v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_PXP_VERSION - PXP Version Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg16_t  STEP;
        reg8_t   MINOR;
        reg8_t   MAJOR;
    } B;
} hw_pxp_version_t;
#endif


//
// constants & macros for entire HW_PXP_VERSION register
//

#define HW_PXP_VERSION_ADDR      (REGS_PXP_BASE + 0x000001F0)

#ifndef __LANGUAGE_ASM__
#define HW_PXP_VERSION           (*(volatile hw_pxp_version_t *) HW_PXP_VERSION_ADDR)
#define HW_PXP_VERSION_RD()      (HW_PXP_VERSION.U)
#endif


//
// constants & macros for individual HW_PXP_VERSION bitfields
//

//--- Register HW_PXP_VERSION, field MAJOR

#define BP_PXP_VERSION_MAJOR      24
#define BM_PXP_VERSION_MAJOR      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_PXP_VERSION_MAJOR(v)   ((((reg32_t) v) << 24) & BM_PXP_VERSION_MAJOR)
#else
#define BF_PXP_VERSION_MAJOR(v)   (((v) << 24) & BM_PXP_VERSION_MAJOR)
#endif

//--- Register HW_PXP_VERSION, field MINOR

#define BP_PXP_VERSION_MINOR      16
#define BM_PXP_VERSION_MINOR      0x00FF0000

#define BF_PXP_VERSION_MINOR(v)   (((v) << 16) & BM_PXP_VERSION_MINOR)

//--- Register HW_PXP_VERSION, field STEP

#define BP_PXP_VERSION_STEP      0
#define BM_PXP_VERSION_STEP      0x0000FFFF

#define BF_PXP_VERSION_STEP(v)   (((v) << 0) & BM_PXP_VERSION_STEP)


////////////////////////////////////////////////////////////////////////////////
//// multi-register-define name HW_PXP_OLn : base 0x8002A200 : count 8 : offset 0x40
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  ADDR;
    } B;
} hw_pxp_oln_t;
#endif


//
// constants & macros for entire HW_PXP_OLn multi-register
//

#define HW_PXP_OLn_COUNT        8
#define HW_PXP_OLn_ADDR(n)      (REGS_PXP_BASE + 0x00000200 + ((n) * 0x40))

#ifndef __LANGUAGE_ASM__
#define HW_PXP_OLn(n)           (*(volatile hw_pxp_oln_t *) HW_PXP_OLn_ADDR(n))
#define HW_PXP_OLn_RD(n)        (HW_PXP_OLn(n).U)
#define HW_PXP_OLn_WR(n, v)     (HW_PXP_OLn(n).U = (v))
#define HW_PXP_OLn_SET(n, v)    (HW_PXP_OLn_WR(n, HW_PXP_OLn_RD(n) |  (v)))
#define HW_PXP_OLn_CLR(n, v)    (HW_PXP_OLn_WR(n, HW_PXP_OLn_RD(n) & ~(v)))
#define HW_PXP_OLn_TOG(n, v)    (HW_PXP_OLn_WR(n, HW_PXP_OLn_RD(n) ^  (v)))
#endif


//
// constants & macros for individual HW_PXP_OLn multi-register bitfields
//

//--- Register HW_PXP_OLn, field ADDR

#define BP_PXP_OLn_ADDR      0
#define BM_PXP_OLn_ADDR      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_PXP_OLn_ADDR(v)   ((reg32_t) v)
#else
#define BF_PXP_OLn_ADDR(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_PXP_OLn_ADDR(n, v)  (HW_PXP_OLn(n).B.ADDR = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// multi-register-define name HW_PXP_OLnSIZE : base 0x8002A210 : count 8 : offset 0x40
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg8_t   HEIGHT;
        reg8_t   WIDTH;
        reg8_t   YBASE;
        reg8_t   XBASE;
    } B;
} hw_pxp_olnsize_t;
#endif


//
// constants & macros for entire HW_PXP_OLnSIZE multi-register
//

#define HW_PXP_OLnSIZE_COUNT        8
#define HW_PXP_OLnSIZE_ADDR(n)      (REGS_PXP_BASE + 0x00000210 + ((n) * 0x40))

#ifndef __LANGUAGE_ASM__
#define HW_PXP_OLnSIZE(n)           (*(volatile hw_pxp_olnsize_t *) HW_PXP_OLnSIZE_ADDR(n))
#define HW_PXP_OLnSIZE_RD(n)        (HW_PXP_OLnSIZE(n).U)
#define HW_PXP_OLnSIZE_WR(n, v)     (HW_PXP_OLnSIZE(n).U = (v))
#define HW_PXP_OLnSIZE_SET(n, v)    (HW_PXP_OLnSIZE_WR(n, HW_PXP_OLnSIZE_RD(n) |  (v)))
#define HW_PXP_OLnSIZE_CLR(n, v)    (HW_PXP_OLnSIZE_WR(n, HW_PXP_OLnSIZE_RD(n) & ~(v)))
#define HW_PXP_OLnSIZE_TOG(n, v)    (HW_PXP_OLnSIZE_WR(n, HW_PXP_OLnSIZE_RD(n) ^  (v)))
#endif


//
// constants & macros for individual HW_PXP_OLnSIZE multi-register bitfields
//

//--- Register HW_PXP_OLnSIZE, field XBASE

#define BP_PXP_OLnSIZE_XBASE      24
#define BM_PXP_OLnSIZE_XBASE      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_PXP_OLnSIZE_XBASE(v)   ((((reg32_t) v) << 24) & BM_PXP_OLnSIZE_XBASE)
#else
#define BF_PXP_OLnSIZE_XBASE(v)   (((v) << 24) & BM_PXP_OLnSIZE_XBASE)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_PXP_OLnSIZE_XBASE(n, v)  (HW_PXP_OLnSIZE(n).B.XBASE = (v))
#endif

//--- Register HW_PXP_OLnSIZE, field YBASE

#define BP_PXP_OLnSIZE_YBASE      16
#define BM_PXP_OLnSIZE_YBASE      0x00FF0000

#define BF_PXP_OLnSIZE_YBASE(v)   (((v) << 16) & BM_PXP_OLnSIZE_YBASE)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_OLnSIZE_YBASE(n, v)  (HW_PXP_OLnSIZE(n).B.YBASE = (v))
#endif

//--- Register HW_PXP_OLnSIZE, field WIDTH

#define BP_PXP_OLnSIZE_WIDTH      8
#define BM_PXP_OLnSIZE_WIDTH      0x0000FF00

#define BF_PXP_OLnSIZE_WIDTH(v)   (((v) << 8) & BM_PXP_OLnSIZE_WIDTH)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_OLnSIZE_WIDTH(n, v)  (HW_PXP_OLnSIZE(n).B.WIDTH = (v))
#endif

//--- Register HW_PXP_OLnSIZE, field HEIGHT

#define BP_PXP_OLnSIZE_HEIGHT      0
#define BM_PXP_OLnSIZE_HEIGHT      0x000000FF

#define BF_PXP_OLnSIZE_HEIGHT(v)   (((v) << 0) & BM_PXP_OLnSIZE_HEIGHT)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_OLnSIZE_HEIGHT(n, v)  (HW_PXP_OLnSIZE(n).B.HEIGHT = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// multi-register-define name HW_PXP_OLnPARAM : base 0x8002A220 : count 8 : offset 0x40
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ENABLE           :  1;
        unsigned ALPHA_CNTL       :  2;
        unsigned ENABLE_COLORKEY  :  1;
        unsigned FORMAT           :  4;
        reg8_t   ALPHA;
        unsigned ROP              :  4;
        unsigned RSVD1            : 12;
    } B;
} hw_pxp_olnparam_t;
#endif


//
// constants & macros for entire HW_PXP_OLnPARAM multi-register
//

#define HW_PXP_OLnPARAM_COUNT        8
#define HW_PXP_OLnPARAM_ADDR(n)      (REGS_PXP_BASE + 0x00000220 + ((n) * 0x40))

#ifndef __LANGUAGE_ASM__
#define HW_PXP_OLnPARAM(n)           (*(volatile hw_pxp_olnparam_t *) HW_PXP_OLnPARAM_ADDR(n))
#define HW_PXP_OLnPARAM_RD(n)        (HW_PXP_OLnPARAM(n).U)
#define HW_PXP_OLnPARAM_WR(n, v)     (HW_PXP_OLnPARAM(n).U = (v))
#define HW_PXP_OLnPARAM_SET(n, v)    (HW_PXP_OLnPARAM_WR(n, HW_PXP_OLnPARAM_RD(n) |  (v)))
#define HW_PXP_OLnPARAM_CLR(n, v)    (HW_PXP_OLnPARAM_WR(n, HW_PXP_OLnPARAM_RD(n) & ~(v)))
#define HW_PXP_OLnPARAM_TOG(n, v)    (HW_PXP_OLnPARAM_WR(n, HW_PXP_OLnPARAM_RD(n) ^  (v)))
#endif


//
// constants & macros for individual HW_PXP_OLnPARAM multi-register bitfields
//

//--- Register HW_PXP_OLnPARAM, field ROP

#define BP_PXP_OLnPARAM_ROP      16
#define BM_PXP_OLnPARAM_ROP      0x000F0000

#define BF_PXP_OLnPARAM_ROP(v)   (((v) << 16) & BM_PXP_OLnPARAM_ROP)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_OLnPARAM_ROP(n, v)  BF_CS1n(PXP_OLnPARAM, n, ROP, v)
#endif

#define BV_PXP_OLnPARAM_ROP__MASKOL      0x0
#define BV_PXP_OLnPARAM_ROP__MASKNOTOL   0x1
#define BV_PXP_OLnPARAM_ROP__MASKOLNOT   0x2
#define BV_PXP_OLnPARAM_ROP__MERGEOL     0x3
#define BV_PXP_OLnPARAM_ROP__MERGENOTOL  0x4
#define BV_PXP_OLnPARAM_ROP__MERGEOLNOT  0x5
#define BV_PXP_OLnPARAM_ROP__NOTCOPYOL   0x6
#define BV_PXP_OLnPARAM_ROP__NOT         0x7
#define BV_PXP_OLnPARAM_ROP__NOTMASKOL   0x8
#define BV_PXP_OLnPARAM_ROP__NOTMERGEOL  0x9
#define BV_PXP_OLnPARAM_ROP__XOROL       0xA
#define BV_PXP_OLnPARAM_ROP__NOTXOROL    0xB

//--- Register HW_PXP_OLnPARAM, field ALPHA

#define BP_PXP_OLnPARAM_ALPHA      8
#define BM_PXP_OLnPARAM_ALPHA      0x0000FF00

#define BF_PXP_OLnPARAM_ALPHA(v)   (((v) << 8) & BM_PXP_OLnPARAM_ALPHA)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_OLnPARAM_ALPHA(n, v)  (HW_PXP_OLnPARAM(n).B.ALPHA = (v))
#endif

//--- Register HW_PXP_OLnPARAM, field FORMAT

#define BP_PXP_OLnPARAM_FORMAT      4
#define BM_PXP_OLnPARAM_FORMAT      0x000000F0

#define BF_PXP_OLnPARAM_FORMAT(v)   (((v) << 4) & BM_PXP_OLnPARAM_FORMAT)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_OLnPARAM_FORMAT(n, v)  BF_CS1n(PXP_OLnPARAM, n, FORMAT, v)
#endif

#define BV_PXP_OLnPARAM_FORMAT__ARGB8888  0x0
#define BV_PXP_OLnPARAM_FORMAT__RGB888    0x1
#define BV_PXP_OLnPARAM_FORMAT__ARGB1555  0x3
#define BV_PXP_OLnPARAM_FORMAT__RGB565    0x4
#define BV_PXP_OLnPARAM_FORMAT__RGB555    0x5

//--- Register HW_PXP_OLnPARAM, field ENABLE_COLORKEY

#define BP_PXP_OLnPARAM_ENABLE_COLORKEY      3
#define BM_PXP_OLnPARAM_ENABLE_COLORKEY      0x00000008

#define BF_PXP_OLnPARAM_ENABLE_COLORKEY(v)   (((v) << 3) & BM_PXP_OLnPARAM_ENABLE_COLORKEY)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_OLnPARAM_ENABLE_COLORKEY(n, v)  BF_CS1n(PXP_OLnPARAM, n, ENABLE_COLORKEY, v)
#endif

//--- Register HW_PXP_OLnPARAM, field ALPHA_CNTL

#define BP_PXP_OLnPARAM_ALPHA_CNTL      1
#define BM_PXP_OLnPARAM_ALPHA_CNTL      0x00000006

#define BF_PXP_OLnPARAM_ALPHA_CNTL(v)   (((v) << 1) & BM_PXP_OLnPARAM_ALPHA_CNTL)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_OLnPARAM_ALPHA_CNTL(n, v)  BF_CS1n(PXP_OLnPARAM, n, ALPHA_CNTL, v)
#endif

#define BV_PXP_OLnPARAM_ALPHA_CNTL__Embedded  0x0
#define BV_PXP_OLnPARAM_ALPHA_CNTL__Override  0x1
#define BV_PXP_OLnPARAM_ALPHA_CNTL__Multiply  0x2
#define BV_PXP_OLnPARAM_ALPHA_CNTL__ROPs      0x3

//--- Register HW_PXP_OLnPARAM, field ENABLE

#define BP_PXP_OLnPARAM_ENABLE      0
#define BM_PXP_OLnPARAM_ENABLE      0x00000001

#define BF_PXP_OLnPARAM_ENABLE(v)   (((v) << 0) & BM_PXP_OLnPARAM_ENABLE)

#ifndef __LANGUAGE_ASM__
#define BW_PXP_OLnPARAM_ENABLE(n, v)  BF_CS1n(PXP_OLnPARAM, n, ENABLE, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// multi-register-define name HW_PXP_OLnPARAM2 : base 0x8002A230 : count 8 : offset 0x40
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  RSVD;
    } B;
} hw_pxp_olnparam2_t;
#endif


//
// constants & macros for entire HW_PXP_OLnPARAM2 multi-register
//

#define HW_PXP_OLnPARAM2_COUNT        8
#define HW_PXP_OLnPARAM2_ADDR(n)      (REGS_PXP_BASE + 0x00000230 + ((n) * 0x40))

#ifndef __LANGUAGE_ASM__
#define HW_PXP_OLnPARAM2(n)           (*(volatile hw_pxp_olnparam2_t *) HW_PXP_OLnPARAM2_ADDR(n))
#define HW_PXP_OLnPARAM2_RD(n)        (HW_PXP_OLnPARAM2(n).U)
#endif


//
// constants & macros for individual HW_PXP_OLnPARAM2 multi-register bitfields
//


#endif // _REGSPXP_H

////////////////////////////////////////////////////////////////////////////////
