/*
 * Copyright 2009 Freescale Semiconductor, Inc. All Rights Reserved.
 */

/*
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 */
////////////////////////////////////////////////////////////////////////////////
//
// WARNING!  THIS FILE IS AUTOMATICALLY GENERATED FROM XML.
//                DO NOT MODIFY THIS FILE DIRECTLY.
//
////////////////////////////////////////////////////////////////////////////////
//
// The following naming conventions are followed in this file.
//      XX_<module>_<regname>_<field>
//
// XX specifies the define / macro class
//      HW pertains to a register
//      BM indicates a Bit Mask
//      BF indicates a Bit Field macro
//
// <module> is the hardware module name which can be any of the following...
//      USB20 (Note when there is more than one copy of a given module, the
//      module name includes a number starting from 0 for the first instance
//      of that module)
//
// <regname> is the specific register within that module
//
// <field> is the specific bitfield within that <module>_<register>
//
// We also define the following...
//      hw_<module>_<regname>_t is typedef of anonymous union
//
////////////////////////////////////////////////////////////////////////////////

#ifndef _REGSSSP_H
#define _REGSSSP_H  1

#include "regs.h"

#ifndef REGS_SSP_BASE
#define REGS_SSP_BASE (REGS_BASE + 0x00010000)
#endif

////////////////////////////////////////////////////////////////////////////////
//// HW_SSP_CTRL0 - SSP Control Register 0
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg16_t  XFER_COUNT;
        unsigned ENABLE          :  1;
        unsigned GET_RESP        :  1;
        unsigned CHECK_RESP      :  1;
        unsigned LONG_RESP       :  1;
        unsigned WAIT_FOR_CMD    :  1;
        unsigned WAIT_FOR_IRQ    :  1;
        unsigned BUS_WIDTH       :  2;
        unsigned DATA_XFER       :  1;
        unsigned READ            :  1;
        unsigned IGNORE_CRC      :  1;
        unsigned LOCK_CS         :  1;
        unsigned SDIO_IRQ_CHECK  :  1;
        unsigned RUN             :  1;
        unsigned CLKGATE         :  1;
        unsigned SFTRST          :  1;
    } B;
} hw_ssp_ctrl0_t;
#endif


//
// constants & macros for entire HW_SSP_CTRL0 register
//

#define HW_SSP_CTRL0_ADDR      (REGS_SSP_BASE + 0x00000000)
#define HW_SSP_CTRL0_SET_ADDR  (REGS_SSP_BASE + 0x00000004)
#define HW_SSP_CTRL0_CLR_ADDR  (REGS_SSP_BASE + 0x00000008)
#define HW_SSP_CTRL0_TOG_ADDR  (REGS_SSP_BASE + 0x0000000C)

#ifndef __LANGUAGE_ASM__
#define HW_SSP_CTRL0           (*(volatile hw_ssp_ctrl0_t *) HW_SSP_CTRL0_ADDR)
#define HW_SSP_CTRL0_RD()      (HW_SSP_CTRL0.U)
#define HW_SSP_CTRL0_WR(v)     (HW_SSP_CTRL0.U = (v))
#define HW_SSP_CTRL0_SET(v)    ((*(volatile reg32_t *) HW_SSP_CTRL0_SET_ADDR) = (v))
#define HW_SSP_CTRL0_CLR(v)    ((*(volatile reg32_t *) HW_SSP_CTRL0_CLR_ADDR) = (v))
#define HW_SSP_CTRL0_TOG(v)    ((*(volatile reg32_t *) HW_SSP_CTRL0_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_SSP_CTRL0 bitfields
//

//--- Register HW_SSP_CTRL0, field SFTRST

#define BP_SSP_CTRL0_SFTRST      31
#define BM_SSP_CTRL0_SFTRST      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_SSP_CTRL0_SFTRST(v)   ((((reg32_t) v) << 31) & BM_SSP_CTRL0_SFTRST)
#else
#define BF_SSP_CTRL0_SFTRST(v)   (((v) << 31) & BM_SSP_CTRL0_SFTRST)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL0_SFTRST(v)   BF_CS1(SSP_CTRL0, SFTRST, v)
#endif

//--- Register HW_SSP_CTRL0, field CLKGATE

#define BP_SSP_CTRL0_CLKGATE      30
#define BM_SSP_CTRL0_CLKGATE      0x40000000

#define BF_SSP_CTRL0_CLKGATE(v)   (((v) << 30) & BM_SSP_CTRL0_CLKGATE)

#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL0_CLKGATE(v)   BF_CS1(SSP_CTRL0, CLKGATE, v)
#endif

//--- Register HW_SSP_CTRL0, field RUN

#define BP_SSP_CTRL0_RUN      29
#define BM_SSP_CTRL0_RUN      0x20000000

#define BF_SSP_CTRL0_RUN(v)   (((v) << 29) & BM_SSP_CTRL0_RUN)

#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL0_RUN(v)   BF_CS1(SSP_CTRL0, RUN, v)
#endif

//--- Register HW_SSP_CTRL0, field SDIO_IRQ_CHECK

#define BP_SSP_CTRL0_SDIO_IRQ_CHECK      28
#define BM_SSP_CTRL0_SDIO_IRQ_CHECK      0x10000000

#define BF_SSP_CTRL0_SDIO_IRQ_CHECK(v)   (((v) << 28) & BM_SSP_CTRL0_SDIO_IRQ_CHECK)

#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL0_SDIO_IRQ_CHECK(v)   BF_CS1(SSP_CTRL0, SDIO_IRQ_CHECK, v)
#endif

//--- Register HW_SSP_CTRL0, field LOCK_CS

#define BP_SSP_CTRL0_LOCK_CS      27
#define BM_SSP_CTRL0_LOCK_CS      0x08000000

#define BF_SSP_CTRL0_LOCK_CS(v)   (((v) << 27) & BM_SSP_CTRL0_LOCK_CS)

#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL0_LOCK_CS(v)   BF_CS1(SSP_CTRL0, LOCK_CS, v)
#endif

//--- Register HW_SSP_CTRL0, field IGNORE_CRC

#define BP_SSP_CTRL0_IGNORE_CRC      26
#define BM_SSP_CTRL0_IGNORE_CRC      0x04000000

#define BF_SSP_CTRL0_IGNORE_CRC(v)   (((v) << 26) & BM_SSP_CTRL0_IGNORE_CRC)

#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL0_IGNORE_CRC(v)   BF_CS1(SSP_CTRL0, IGNORE_CRC, v)
#endif

//--- Register HW_SSP_CTRL0, field READ

#define BP_SSP_CTRL0_READ      25
#define BM_SSP_CTRL0_READ      0x02000000

#define BF_SSP_CTRL0_READ(v)   (((v) << 25) & BM_SSP_CTRL0_READ)

#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL0_READ(v)   BF_CS1(SSP_CTRL0, READ, v)
#endif

//--- Register HW_SSP_CTRL0, field DATA_XFER

#define BP_SSP_CTRL0_DATA_XFER      24
#define BM_SSP_CTRL0_DATA_XFER      0x01000000

#define BF_SSP_CTRL0_DATA_XFER(v)   (((v) << 24) & BM_SSP_CTRL0_DATA_XFER)

#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL0_DATA_XFER(v)   BF_CS1(SSP_CTRL0, DATA_XFER, v)
#endif

//--- Register HW_SSP_CTRL0, field BUS_WIDTH

#define BP_SSP_CTRL0_BUS_WIDTH      22
#define BM_SSP_CTRL0_BUS_WIDTH      0x00C00000

#define BF_SSP_CTRL0_BUS_WIDTH(v)   (((v) << 22) & BM_SSP_CTRL0_BUS_WIDTH)

#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL0_BUS_WIDTH(v)   BF_CS1(SSP_CTRL0, BUS_WIDTH, v)
#endif

#define BV_SSP_CTRL0_BUS_WIDTH__ONE_BIT    0x0
#define BV_SSP_CTRL0_BUS_WIDTH__FOUR_BIT   0x1
#define BV_SSP_CTRL0_BUS_WIDTH__EIGHT_BIT  0x2

//--- Register HW_SSP_CTRL0, field WAIT_FOR_IRQ

#define BP_SSP_CTRL0_WAIT_FOR_IRQ      21
#define BM_SSP_CTRL0_WAIT_FOR_IRQ      0x00200000

#define BF_SSP_CTRL0_WAIT_FOR_IRQ(v)   (((v) << 21) & BM_SSP_CTRL0_WAIT_FOR_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL0_WAIT_FOR_IRQ(v)   BF_CS1(SSP_CTRL0, WAIT_FOR_IRQ, v)
#endif

//--- Register HW_SSP_CTRL0, field WAIT_FOR_CMD

#define BP_SSP_CTRL0_WAIT_FOR_CMD      20
#define BM_SSP_CTRL0_WAIT_FOR_CMD      0x00100000

#define BF_SSP_CTRL0_WAIT_FOR_CMD(v)   (((v) << 20) & BM_SSP_CTRL0_WAIT_FOR_CMD)

#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL0_WAIT_FOR_CMD(v)   BF_CS1(SSP_CTRL0, WAIT_FOR_CMD, v)
#endif

//--- Register HW_SSP_CTRL0, field LONG_RESP

#define BP_SSP_CTRL0_LONG_RESP      19
#define BM_SSP_CTRL0_LONG_RESP      0x00080000

#define BF_SSP_CTRL0_LONG_RESP(v)   (((v) << 19) & BM_SSP_CTRL0_LONG_RESP)

#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL0_LONG_RESP(v)   BF_CS1(SSP_CTRL0, LONG_RESP, v)
#endif

//--- Register HW_SSP_CTRL0, field CHECK_RESP

#define BP_SSP_CTRL0_CHECK_RESP      18
#define BM_SSP_CTRL0_CHECK_RESP      0x00040000

#define BF_SSP_CTRL0_CHECK_RESP(v)   (((v) << 18) & BM_SSP_CTRL0_CHECK_RESP)

#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL0_CHECK_RESP(v)   BF_CS1(SSP_CTRL0, CHECK_RESP, v)
#endif

//--- Register HW_SSP_CTRL0, field GET_RESP

#define BP_SSP_CTRL0_GET_RESP      17
#define BM_SSP_CTRL0_GET_RESP      0x00020000

#define BF_SSP_CTRL0_GET_RESP(v)   (((v) << 17) & BM_SSP_CTRL0_GET_RESP)

#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL0_GET_RESP(v)   BF_CS1(SSP_CTRL0, GET_RESP, v)
#endif

//--- Register HW_SSP_CTRL0, field ENABLE

#define BP_SSP_CTRL0_ENABLE      16
#define BM_SSP_CTRL0_ENABLE      0x00010000

#define BF_SSP_CTRL0_ENABLE(v)   (((v) << 16) & BM_SSP_CTRL0_ENABLE)

#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL0_ENABLE(v)   BF_CS1(SSP_CTRL0, ENABLE, v)
#endif

//--- Register HW_SSP_CTRL0, field XFER_COUNT

#define BP_SSP_CTRL0_XFER_COUNT      0
#define BM_SSP_CTRL0_XFER_COUNT      0x0000FFFF

#define BF_SSP_CTRL0_XFER_COUNT(v)   (((v) << 0) & BM_SSP_CTRL0_XFER_COUNT)

#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL0_XFER_COUNT(v)   (HW_SSP_CTRL0.B.XFER_COUNT = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SSP_CMD0 - SD/MMC and MS Command Register 0
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg8_t   CMD;
        reg8_t   BLOCK_COUNT;
        unsigned BLOCK_SIZE      :  4;
        unsigned APPEND_8CYC     :  1;
        unsigned CONT_CLKING_EN  :  1;
        unsigned SLOW_CLKING_EN  :  1;
        unsigned RSVD0           :  9;
    } B;
} hw_ssp_cmd0_t;
#endif


//
// constants & macros for entire HW_SSP_CMD0 register
//

#define HW_SSP_CMD0_ADDR      (REGS_SSP_BASE + 0x00000010)
#define HW_SSP_CMD0_SET_ADDR  (REGS_SSP_BASE + 0x00000014)
#define HW_SSP_CMD0_CLR_ADDR  (REGS_SSP_BASE + 0x00000018)
#define HW_SSP_CMD0_TOG_ADDR  (REGS_SSP_BASE + 0x0000001C)

#ifndef __LANGUAGE_ASM__
#define HW_SSP_CMD0           (*(volatile hw_ssp_cmd0_t *) HW_SSP_CMD0_ADDR)
#define HW_SSP_CMD0_RD()      (HW_SSP_CMD0.U)
#define HW_SSP_CMD0_WR(v)     (HW_SSP_CMD0.U = (v))
#define HW_SSP_CMD0_SET(v)    ((*(volatile reg32_t *) HW_SSP_CMD0_SET_ADDR) = (v))
#define HW_SSP_CMD0_CLR(v)    ((*(volatile reg32_t *) HW_SSP_CMD0_CLR_ADDR) = (v))
#define HW_SSP_CMD0_TOG(v)    ((*(volatile reg32_t *) HW_SSP_CMD0_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_SSP_CMD0 bitfields
//

//--- Register HW_SSP_CMD0, field SLOW_CLKING_EN

#define BP_SSP_CMD0_SLOW_CLKING_EN      22
#define BM_SSP_CMD0_SLOW_CLKING_EN      0x00400000

#define BF_SSP_CMD0_SLOW_CLKING_EN(v)   (((v) << 22) & BM_SSP_CMD0_SLOW_CLKING_EN)

#ifndef __LANGUAGE_ASM__
#define BW_SSP_CMD0_SLOW_CLKING_EN(v)   BF_CS1(SSP_CMD0, SLOW_CLKING_EN, v)
#endif

//--- Register HW_SSP_CMD0, field CONT_CLKING_EN

#define BP_SSP_CMD0_CONT_CLKING_EN      21
#define BM_SSP_CMD0_CONT_CLKING_EN      0x00200000

#define BF_SSP_CMD0_CONT_CLKING_EN(v)   (((v) << 21) & BM_SSP_CMD0_CONT_CLKING_EN)

#ifndef __LANGUAGE_ASM__
#define BW_SSP_CMD0_CONT_CLKING_EN(v)   BF_CS1(SSP_CMD0, CONT_CLKING_EN, v)
#endif

//--- Register HW_SSP_CMD0, field APPEND_8CYC

#define BP_SSP_CMD0_APPEND_8CYC      20
#define BM_SSP_CMD0_APPEND_8CYC      0x00100000

#define BF_SSP_CMD0_APPEND_8CYC(v)   (((v) << 20) & BM_SSP_CMD0_APPEND_8CYC)

#ifndef __LANGUAGE_ASM__
#define BW_SSP_CMD0_APPEND_8CYC(v)   BF_CS1(SSP_CMD0, APPEND_8CYC, v)
#endif

//--- Register HW_SSP_CMD0, field BLOCK_SIZE

#define BP_SSP_CMD0_BLOCK_SIZE      16
#define BM_SSP_CMD0_BLOCK_SIZE      0x000F0000

#define BF_SSP_CMD0_BLOCK_SIZE(v)   (((v) << 16) & BM_SSP_CMD0_BLOCK_SIZE)

#ifndef __LANGUAGE_ASM__
#define BW_SSP_CMD0_BLOCK_SIZE(v)   BF_CS1(SSP_CMD0, BLOCK_SIZE, v)
#endif

//--- Register HW_SSP_CMD0, field BLOCK_COUNT

#define BP_SSP_CMD0_BLOCK_COUNT      8
#define BM_SSP_CMD0_BLOCK_COUNT      0x0000FF00

#define BF_SSP_CMD0_BLOCK_COUNT(v)   (((v) << 8) & BM_SSP_CMD0_BLOCK_COUNT)

#ifndef __LANGUAGE_ASM__
#define BW_SSP_CMD0_BLOCK_COUNT(v)   (HW_SSP_CMD0.B.BLOCK_COUNT = (v))
#endif

//--- Register HW_SSP_CMD0, field CMD

#define BP_SSP_CMD0_CMD      0
#define BM_SSP_CMD0_CMD      0x000000FF

#define BF_SSP_CMD0_CMD(v)   (((v) << 0) & BM_SSP_CMD0_CMD)

#ifndef __LANGUAGE_ASM__
#define BW_SSP_CMD0_CMD(v)   (HW_SSP_CMD0.B.CMD = (v))
#endif

#define BV_SSP_CMD0_CMD__MMC_GO_IDLE_STATE         0x00
#define BV_SSP_CMD0_CMD__MMC_SEND_OP_COND          0x01
#define BV_SSP_CMD0_CMD__MMC_ALL_SEND_CID          0x02
#define BV_SSP_CMD0_CMD__MMC_SET_RELATIVE_ADDR     0x03
#define BV_SSP_CMD0_CMD__MMC_SET_DSR               0x04
#define BV_SSP_CMD0_CMD__MMC_RESERVED_5            0x05
#define BV_SSP_CMD0_CMD__MMC_SWITCH                0x06
#define BV_SSP_CMD0_CMD__MMC_SELECT_DESELECT_CARD  0x07
#define BV_SSP_CMD0_CMD__MMC_SEND_EXT_CSD          0x08
#define BV_SSP_CMD0_CMD__MMC_SEND_CSD              0x09
#define BV_SSP_CMD0_CMD__MMC_SEND_CID              0x0A
#define BV_SSP_CMD0_CMD__MMC_READ_DAT_UNTIL_STOP   0x0B
#define BV_SSP_CMD0_CMD__MMC_STOP_TRANSMISSION     0x0C
#define BV_SSP_CMD0_CMD__MMC_SEND_STATUS           0x0D
#define BV_SSP_CMD0_CMD__MMC_BUSTEST_R             0x0E
#define BV_SSP_CMD0_CMD__MMC_GO_INACTIVE_STATE     0x0F
#define BV_SSP_CMD0_CMD__MMC_SET_BLOCKLEN          0x10
#define BV_SSP_CMD0_CMD__MMC_READ_SINGLE_BLOCK     0x11
#define BV_SSP_CMD0_CMD__MMC_READ_MULTIPLE_BLOCK   0x12
#define BV_SSP_CMD0_CMD__MMC_BUSTEST_W             0x13
#define BV_SSP_CMD0_CMD__MMC_WRITE_DAT_UNTIL_STOP  0x14
#define BV_SSP_CMD0_CMD__MMC_SET_BLOCK_COUNT       0x17
#define BV_SSP_CMD0_CMD__MMC_WRITE_BLOCK           0x18
#define BV_SSP_CMD0_CMD__MMC_WRITE_MULTIPLE_BLOCK  0x19
#define BV_SSP_CMD0_CMD__MMC_PROGRAM_CID           0x1A
#define BV_SSP_CMD0_CMD__MMC_PROGRAM_CSD           0x1B
#define BV_SSP_CMD0_CMD__MMC_SET_WRITE_PROT        0x1C
#define BV_SSP_CMD0_CMD__MMC_CLR_WRITE_PROT        0x1D
#define BV_SSP_CMD0_CMD__MMC_SEND_WRITE_PROT       0x1E
#define BV_SSP_CMD0_CMD__MMC_ERASE_GROUP_START     0x23
#define BV_SSP_CMD0_CMD__MMC_ERASE_GROUP_END       0x24
#define BV_SSP_CMD0_CMD__MMC_ERASE                 0x26
#define BV_SSP_CMD0_CMD__MMC_FAST_IO               0x27
#define BV_SSP_CMD0_CMD__MMC_GO_IRQ_STATE          0x28
#define BV_SSP_CMD0_CMD__MMC_LOCK_UNLOCK           0x2A
#define BV_SSP_CMD0_CMD__MMC_APP_CMD               0x37
#define BV_SSP_CMD0_CMD__MMC_GEN_CMD               0x38
#define BV_SSP_CMD0_CMD__SD_GO_IDLE_STATE          0x00
#define BV_SSP_CMD0_CMD__SD_ALL_SEND_CID           0x02
#define BV_SSP_CMD0_CMD__SD_SEND_RELATIVE_ADDR     0x03
#define BV_SSP_CMD0_CMD__SD_SET_DSR                0x04
#define BV_SSP_CMD0_CMD__SD_IO_SEND_OP_COND        0x05
#define BV_SSP_CMD0_CMD__SD_SELECT_DESELECT_CARD   0x07
#define BV_SSP_CMD0_CMD__SD_SEND_CSD               0x09
#define BV_SSP_CMD0_CMD__SD_SEND_CID               0x0A
#define BV_SSP_CMD0_CMD__SD_STOP_TRANSMISSION      0x0C
#define BV_SSP_CMD0_CMD__SD_SEND_STATUS            0x0D
#define BV_SSP_CMD0_CMD__SD_GO_INACTIVE_STATE      0x0F
#define BV_SSP_CMD0_CMD__SD_SET_BLOCKLEN           0x10
#define BV_SSP_CMD0_CMD__SD_READ_SINGLE_BLOCK      0x11
#define BV_SSP_CMD0_CMD__SD_READ_MULTIPLE_BLOCK    0x12
#define BV_SSP_CMD0_CMD__SD_WRITE_BLOCK            0x18
#define BV_SSP_CMD0_CMD__SD_WRITE_MULTIPLE_BLOCK   0x19
#define BV_SSP_CMD0_CMD__SD_PROGRAM_CSD            0x1B
#define BV_SSP_CMD0_CMD__SD_SET_WRITE_PROT         0x1C
#define BV_SSP_CMD0_CMD__SD_CLR_WRITE_PROT         0x1D
#define BV_SSP_CMD0_CMD__SD_SEND_WRITE_PROT        0x1E
#define BV_SSP_CMD0_CMD__SD_ERASE_WR_BLK_START     0x20
#define BV_SSP_CMD0_CMD__SD_ERASE_WR_BLK_END       0x21
#define BV_SSP_CMD0_CMD__SD_ERASE_GROUP_START      0x23
#define BV_SSP_CMD0_CMD__SD_ERASE_GROUP_END        0x24
#define BV_SSP_CMD0_CMD__SD_ERASE                  0x26
#define BV_SSP_CMD0_CMD__SD_LOCK_UNLOCK            0x2A
#define BV_SSP_CMD0_CMD__SD_IO_RW_DIRECT           0x34
#define BV_SSP_CMD0_CMD__SD_IO_RW_EXTENDED         0x35
#define BV_SSP_CMD0_CMD__SD_APP_CMD                0x37
#define BV_SSP_CMD0_CMD__SD_GEN_CMD                0x38


////////////////////////////////////////////////////////////////////////////////
//// HW_SSP_CMD1 - SD/MMC Command Register 1
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  CMD_ARG;
    } B;
} hw_ssp_cmd1_t;
#endif


//
// constants & macros for entire HW_SSP_CMD1 register
//

#define HW_SSP_CMD1_ADDR      (REGS_SSP_BASE + 0x00000020)

#ifndef __LANGUAGE_ASM__
#define HW_SSP_CMD1           (*(volatile hw_ssp_cmd1_t *) HW_SSP_CMD1_ADDR)
#define HW_SSP_CMD1_RD()      (HW_SSP_CMD1.U)
#define HW_SSP_CMD1_WR(v)     (HW_SSP_CMD1.U = (v))
#define HW_SSP_CMD1_SET(v)    (HW_SSP_CMD1_WR(HW_SSP_CMD1_RD() |  (v)))
#define HW_SSP_CMD1_CLR(v)    (HW_SSP_CMD1_WR(HW_SSP_CMD1_RD() & ~(v)))
#define HW_SSP_CMD1_TOG(v)    (HW_SSP_CMD1_WR(HW_SSP_CMD1_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_SSP_CMD1 bitfields
//

//--- Register HW_SSP_CMD1, field CMD_ARG

#define BP_SSP_CMD1_CMD_ARG      0
#define BM_SSP_CMD1_CMD_ARG      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SSP_CMD1_CMD_ARG(v)   ((reg32_t) v)
#else
#define BF_SSP_CMD1_CMD_ARG(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_SSP_CMD1_CMD_ARG(v)   (HW_SSP_CMD1.B.CMD_ARG = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SSP_COMPREF - SD/MMC and MS Compare Reference
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  REFERENCE;
    } B;
} hw_ssp_compref_t;
#endif


//
// constants & macros for entire HW_SSP_COMPREF register
//

#define HW_SSP_COMPREF_ADDR      (REGS_SSP_BASE + 0x00000030)

#ifndef __LANGUAGE_ASM__
#define HW_SSP_COMPREF           (*(volatile hw_ssp_compref_t *) HW_SSP_COMPREF_ADDR)
#define HW_SSP_COMPREF_RD()      (HW_SSP_COMPREF.U)
#define HW_SSP_COMPREF_WR(v)     (HW_SSP_COMPREF.U = (v))
#define HW_SSP_COMPREF_SET(v)    (HW_SSP_COMPREF_WR(HW_SSP_COMPREF_RD() |  (v)))
#define HW_SSP_COMPREF_CLR(v)    (HW_SSP_COMPREF_WR(HW_SSP_COMPREF_RD() & ~(v)))
#define HW_SSP_COMPREF_TOG(v)    (HW_SSP_COMPREF_WR(HW_SSP_COMPREF_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_SSP_COMPREF bitfields
//

//--- Register HW_SSP_COMPREF, field REFERENCE

#define BP_SSP_COMPREF_REFERENCE      0
#define BM_SSP_COMPREF_REFERENCE      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SSP_COMPREF_REFERENCE(v)   ((reg32_t) v)
#else
#define BF_SSP_COMPREF_REFERENCE(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_SSP_COMPREF_REFERENCE(v)   (HW_SSP_COMPREF.B.REFERENCE = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SSP_COMPMASK - SD/MMC and MS compare mask
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  MASK;
    } B;
} hw_ssp_compmask_t;
#endif


//
// constants & macros for entire HW_SSP_COMPMASK register
//

#define HW_SSP_COMPMASK_ADDR      (REGS_SSP_BASE + 0x00000040)

#ifndef __LANGUAGE_ASM__
#define HW_SSP_COMPMASK           (*(volatile hw_ssp_compmask_t *) HW_SSP_COMPMASK_ADDR)
#define HW_SSP_COMPMASK_RD()      (HW_SSP_COMPMASK.U)
#define HW_SSP_COMPMASK_WR(v)     (HW_SSP_COMPMASK.U = (v))
#define HW_SSP_COMPMASK_SET(v)    (HW_SSP_COMPMASK_WR(HW_SSP_COMPMASK_RD() |  (v)))
#define HW_SSP_COMPMASK_CLR(v)    (HW_SSP_COMPMASK_WR(HW_SSP_COMPMASK_RD() & ~(v)))
#define HW_SSP_COMPMASK_TOG(v)    (HW_SSP_COMPMASK_WR(HW_SSP_COMPMASK_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_SSP_COMPMASK bitfields
//

//--- Register HW_SSP_COMPMASK, field MASK

#define BP_SSP_COMPMASK_MASK      0
#define BM_SSP_COMPMASK_MASK      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SSP_COMPMASK_MASK(v)   ((reg32_t) v)
#else
#define BF_SSP_COMPMASK_MASK(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_SSP_COMPMASK_MASK(v)   (HW_SSP_COMPMASK.B.MASK = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SSP_TIMING - SSP Timing Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg8_t   CLOCK_RATE;
        reg8_t   CLOCK_DIVIDE;
        reg16_t  TIMEOUT;
    } B;
} hw_ssp_timing_t;
#endif


//
// constants & macros for entire HW_SSP_TIMING register
//

#define HW_SSP_TIMING_ADDR      (REGS_SSP_BASE + 0x00000050)

#ifndef __LANGUAGE_ASM__
#define HW_SSP_TIMING           (*(volatile hw_ssp_timing_t *) HW_SSP_TIMING_ADDR)
#define HW_SSP_TIMING_RD()      (HW_SSP_TIMING.U)
#define HW_SSP_TIMING_WR(v)     (HW_SSP_TIMING.U = (v))
#define HW_SSP_TIMING_SET(v)    (HW_SSP_TIMING_WR(HW_SSP_TIMING_RD() |  (v)))
#define HW_SSP_TIMING_CLR(v)    (HW_SSP_TIMING_WR(HW_SSP_TIMING_RD() & ~(v)))
#define HW_SSP_TIMING_TOG(v)    (HW_SSP_TIMING_WR(HW_SSP_TIMING_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_SSP_TIMING bitfields
//

//--- Register HW_SSP_TIMING, field TIMEOUT

#define BP_SSP_TIMING_TIMEOUT      16
#define BM_SSP_TIMING_TIMEOUT      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_SSP_TIMING_TIMEOUT(v)   ((((reg32_t) v) << 16) & BM_SSP_TIMING_TIMEOUT)
#else
#define BF_SSP_TIMING_TIMEOUT(v)   (((v) << 16) & BM_SSP_TIMING_TIMEOUT)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_SSP_TIMING_TIMEOUT(v)   (HW_SSP_TIMING.B.TIMEOUT = (v))
#endif

//--- Register HW_SSP_TIMING, field CLOCK_DIVIDE

#define BP_SSP_TIMING_CLOCK_DIVIDE      8
#define BM_SSP_TIMING_CLOCK_DIVIDE      0x0000FF00

#define BF_SSP_TIMING_CLOCK_DIVIDE(v)   (((v) << 8) & BM_SSP_TIMING_CLOCK_DIVIDE)

#ifndef __LANGUAGE_ASM__
#define BW_SSP_TIMING_CLOCK_DIVIDE(v)   (HW_SSP_TIMING.B.CLOCK_DIVIDE = (v))
#endif

//--- Register HW_SSP_TIMING, field CLOCK_RATE

#define BP_SSP_TIMING_CLOCK_RATE      0
#define BM_SSP_TIMING_CLOCK_RATE      0x000000FF

#define BF_SSP_TIMING_CLOCK_RATE(v)   (((v) << 0) & BM_SSP_TIMING_CLOCK_RATE)

#ifndef __LANGUAGE_ASM__
#define BW_SSP_TIMING_CLOCK_RATE(v)   (HW_SSP_TIMING.B.CLOCK_RATE = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SSP_CTRL1 - SSP Control Register 1
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned SSP_MODE              :  4;
        unsigned WORD_LENGTH           :  4;
        unsigned SLAVE_MODE            :  1;
        unsigned POLARITY              :  1;
        unsigned PHASE                 :  1;
        unsigned SLAVE_OUT_DISABLE     :  1;
        unsigned CEATA_CCS_ERR_EN      :  1;
        unsigned DMA_ENABLE            :  1;
        unsigned FIFO_OVERRUN_IRQ_EN   :  1;
        unsigned FIFO_OVERRUN_IRQ      :  1;
        unsigned RECV_TIMEOUT_IRQ_EN   :  1;
        unsigned RECV_TIMEOUT_IRQ      :  1;
        unsigned CEATA_CCS_ERR_IRQ_EN  :  1;
        unsigned CEATA_CCS_ERR_IRQ     :  1;
        unsigned FIFO_UNDERRUN_EN      :  1;
        unsigned FIFO_UNDERRUN_IRQ     :  1;
        unsigned DATA_CRC_IRQ_EN       :  1;
        unsigned DATA_CRC_IRQ          :  1;
        unsigned DATA_TIMEOUT_IRQ_EN   :  1;
        unsigned DATA_TIMEOUT_IRQ      :  1;
        unsigned RESP_TIMEOUT_IRQ_EN   :  1;
        unsigned RESP_TIMEOUT_IRQ      :  1;
        unsigned RESP_ERR_IRQ_EN       :  1;
        unsigned RESP_ERR_IRQ          :  1;
        unsigned SDIO_IRQ_EN           :  1;
        unsigned SDIO_IRQ              :  1;
    } B;
} hw_ssp_ctrl1_t;
#endif


//
// constants & macros for entire HW_SSP_CTRL1 register
//

#define HW_SSP_CTRL1_ADDR      (REGS_SSP_BASE + 0x00000060)
#define HW_SSP_CTRL1_SET_ADDR  (REGS_SSP_BASE + 0x00000064)
#define HW_SSP_CTRL1_CLR_ADDR  (REGS_SSP_BASE + 0x00000068)
#define HW_SSP_CTRL1_TOG_ADDR  (REGS_SSP_BASE + 0x0000006C)

#ifndef __LANGUAGE_ASM__
#define HW_SSP_CTRL1           (*(volatile hw_ssp_ctrl1_t *) HW_SSP_CTRL1_ADDR)
#define HW_SSP_CTRL1_RD()      (HW_SSP_CTRL1.U)
#define HW_SSP_CTRL1_WR(v)     (HW_SSP_CTRL1.U = (v))
#define HW_SSP_CTRL1_SET(v)    ((*(volatile reg32_t *) HW_SSP_CTRL1_SET_ADDR) = (v))
#define HW_SSP_CTRL1_CLR(v)    ((*(volatile reg32_t *) HW_SSP_CTRL1_CLR_ADDR) = (v))
#define HW_SSP_CTRL1_TOG(v)    ((*(volatile reg32_t *) HW_SSP_CTRL1_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_SSP_CTRL1 bitfields
//

//--- Register HW_SSP_CTRL1, field SDIO_IRQ

#define BP_SSP_CTRL1_SDIO_IRQ      31
#define BM_SSP_CTRL1_SDIO_IRQ      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_SSP_CTRL1_SDIO_IRQ(v)   ((((reg32_t) v) << 31) & BM_SSP_CTRL1_SDIO_IRQ)
#else
#define BF_SSP_CTRL1_SDIO_IRQ(v)   (((v) << 31) & BM_SSP_CTRL1_SDIO_IRQ)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_SDIO_IRQ(v)   BF_CS1(SSP_CTRL1, SDIO_IRQ, v)
#endif

//--- Register HW_SSP_CTRL1, field SDIO_IRQ_EN

#define BP_SSP_CTRL1_SDIO_IRQ_EN      30
#define BM_SSP_CTRL1_SDIO_IRQ_EN      0x40000000

#define BF_SSP_CTRL1_SDIO_IRQ_EN(v)   (((v) << 30) & BM_SSP_CTRL1_SDIO_IRQ_EN)

#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_SDIO_IRQ_EN(v)   BF_CS1(SSP_CTRL1, SDIO_IRQ_EN, v)
#endif

//--- Register HW_SSP_CTRL1, field RESP_ERR_IRQ

#define BP_SSP_CTRL1_RESP_ERR_IRQ      29
#define BM_SSP_CTRL1_RESP_ERR_IRQ      0x20000000

#define BF_SSP_CTRL1_RESP_ERR_IRQ(v)   (((v) << 29) & BM_SSP_CTRL1_RESP_ERR_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_RESP_ERR_IRQ(v)   BF_CS1(SSP_CTRL1, RESP_ERR_IRQ, v)
#endif

//--- Register HW_SSP_CTRL1, field RESP_ERR_IRQ_EN

#define BP_SSP_CTRL1_RESP_ERR_IRQ_EN      28
#define BM_SSP_CTRL1_RESP_ERR_IRQ_EN      0x10000000

#define BF_SSP_CTRL1_RESP_ERR_IRQ_EN(v)   (((v) << 28) & BM_SSP_CTRL1_RESP_ERR_IRQ_EN)

#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_RESP_ERR_IRQ_EN(v)   BF_CS1(SSP_CTRL1, RESP_ERR_IRQ_EN, v)
#endif

//--- Register HW_SSP_CTRL1, field RESP_TIMEOUT_IRQ

#define BP_SSP_CTRL1_RESP_TIMEOUT_IRQ      27
#define BM_SSP_CTRL1_RESP_TIMEOUT_IRQ      0x08000000

#define BF_SSP_CTRL1_RESP_TIMEOUT_IRQ(v)   (((v) << 27) & BM_SSP_CTRL1_RESP_TIMEOUT_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_RESP_TIMEOUT_IRQ(v)   BF_CS1(SSP_CTRL1, RESP_TIMEOUT_IRQ, v)
#endif

//--- Register HW_SSP_CTRL1, field RESP_TIMEOUT_IRQ_EN

#define BP_SSP_CTRL1_RESP_TIMEOUT_IRQ_EN      26
#define BM_SSP_CTRL1_RESP_TIMEOUT_IRQ_EN      0x04000000

#define BF_SSP_CTRL1_RESP_TIMEOUT_IRQ_EN(v)   (((v) << 26) & BM_SSP_CTRL1_RESP_TIMEOUT_IRQ_EN)

#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_RESP_TIMEOUT_IRQ_EN(v)   BF_CS1(SSP_CTRL1, RESP_TIMEOUT_IRQ_EN, v)
#endif

//--- Register HW_SSP_CTRL1, field DATA_TIMEOUT_IRQ

#define BP_SSP_CTRL1_DATA_TIMEOUT_IRQ      25
#define BM_SSP_CTRL1_DATA_TIMEOUT_IRQ      0x02000000

#define BF_SSP_CTRL1_DATA_TIMEOUT_IRQ(v)   (((v) << 25) & BM_SSP_CTRL1_DATA_TIMEOUT_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_DATA_TIMEOUT_IRQ(v)   BF_CS1(SSP_CTRL1, DATA_TIMEOUT_IRQ, v)
#endif

//--- Register HW_SSP_CTRL1, field DATA_TIMEOUT_IRQ_EN

#define BP_SSP_CTRL1_DATA_TIMEOUT_IRQ_EN      24
#define BM_SSP_CTRL1_DATA_TIMEOUT_IRQ_EN      0x01000000

#define BF_SSP_CTRL1_DATA_TIMEOUT_IRQ_EN(v)   (((v) << 24) & BM_SSP_CTRL1_DATA_TIMEOUT_IRQ_EN)

#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_DATA_TIMEOUT_IRQ_EN(v)   BF_CS1(SSP_CTRL1, DATA_TIMEOUT_IRQ_EN, v)
#endif

//--- Register HW_SSP_CTRL1, field DATA_CRC_IRQ

#define BP_SSP_CTRL1_DATA_CRC_IRQ      23
#define BM_SSP_CTRL1_DATA_CRC_IRQ      0x00800000

#define BF_SSP_CTRL1_DATA_CRC_IRQ(v)   (((v) << 23) & BM_SSP_CTRL1_DATA_CRC_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_DATA_CRC_IRQ(v)   BF_CS1(SSP_CTRL1, DATA_CRC_IRQ, v)
#endif

//--- Register HW_SSP_CTRL1, field DATA_CRC_IRQ_EN

#define BP_SSP_CTRL1_DATA_CRC_IRQ_EN      22
#define BM_SSP_CTRL1_DATA_CRC_IRQ_EN      0x00400000

#define BF_SSP_CTRL1_DATA_CRC_IRQ_EN(v)   (((v) << 22) & BM_SSP_CTRL1_DATA_CRC_IRQ_EN)

#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_DATA_CRC_IRQ_EN(v)   BF_CS1(SSP_CTRL1, DATA_CRC_IRQ_EN, v)
#endif

//--- Register HW_SSP_CTRL1, field FIFO_UNDERRUN_IRQ

#define BP_SSP_CTRL1_FIFO_UNDERRUN_IRQ      21
#define BM_SSP_CTRL1_FIFO_UNDERRUN_IRQ      0x00200000

#define BF_SSP_CTRL1_FIFO_UNDERRUN_IRQ(v)   (((v) << 21) & BM_SSP_CTRL1_FIFO_UNDERRUN_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_FIFO_UNDERRUN_IRQ(v)   BF_CS1(SSP_CTRL1, FIFO_UNDERRUN_IRQ, v)
#endif

//--- Register HW_SSP_CTRL1, field FIFO_UNDERRUN_EN

#define BP_SSP_CTRL1_FIFO_UNDERRUN_EN      20
#define BM_SSP_CTRL1_FIFO_UNDERRUN_EN      0x00100000

#define BF_SSP_CTRL1_FIFO_UNDERRUN_EN(v)   (((v) << 20) & BM_SSP_CTRL1_FIFO_UNDERRUN_EN)

#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_FIFO_UNDERRUN_EN(v)   BF_CS1(SSP_CTRL1, FIFO_UNDERRUN_EN, v)
#endif

//--- Register HW_SSP_CTRL1, field CEATA_CCS_ERR_IRQ

#define BP_SSP_CTRL1_CEATA_CCS_ERR_IRQ      19
#define BM_SSP_CTRL1_CEATA_CCS_ERR_IRQ      0x00080000

#define BF_SSP_CTRL1_CEATA_CCS_ERR_IRQ(v)   (((v) << 19) & BM_SSP_CTRL1_CEATA_CCS_ERR_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_CEATA_CCS_ERR_IRQ(v)   BF_CS1(SSP_CTRL1, CEATA_CCS_ERR_IRQ, v)
#endif

//--- Register HW_SSP_CTRL1, field CEATA_CCS_ERR_IRQ_EN

#define BP_SSP_CTRL1_CEATA_CCS_ERR_IRQ_EN      18
#define BM_SSP_CTRL1_CEATA_CCS_ERR_IRQ_EN      0x00040000

#define BF_SSP_CTRL1_CEATA_CCS_ERR_IRQ_EN(v)   (((v) << 18) & BM_SSP_CTRL1_CEATA_CCS_ERR_IRQ_EN)

#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_CEATA_CCS_ERR_IRQ_EN(v)   BF_CS1(SSP_CTRL1, CEATA_CCS_ERR_IRQ_EN, v)
#endif

//--- Register HW_SSP_CTRL1, field RECV_TIMEOUT_IRQ

#define BP_SSP_CTRL1_RECV_TIMEOUT_IRQ      17
#define BM_SSP_CTRL1_RECV_TIMEOUT_IRQ      0x00020000

#define BF_SSP_CTRL1_RECV_TIMEOUT_IRQ(v)   (((v) << 17) & BM_SSP_CTRL1_RECV_TIMEOUT_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_RECV_TIMEOUT_IRQ(v)   BF_CS1(SSP_CTRL1, RECV_TIMEOUT_IRQ, v)
#endif

//--- Register HW_SSP_CTRL1, field RECV_TIMEOUT_IRQ_EN

#define BP_SSP_CTRL1_RECV_TIMEOUT_IRQ_EN      16
#define BM_SSP_CTRL1_RECV_TIMEOUT_IRQ_EN      0x00010000

#define BF_SSP_CTRL1_RECV_TIMEOUT_IRQ_EN(v)   (((v) << 16) & BM_SSP_CTRL1_RECV_TIMEOUT_IRQ_EN)

#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_RECV_TIMEOUT_IRQ_EN(v)   BF_CS1(SSP_CTRL1, RECV_TIMEOUT_IRQ_EN, v)
#endif

//--- Register HW_SSP_CTRL1, field FIFO_OVERRUN_IRQ

#define BP_SSP_CTRL1_FIFO_OVERRUN_IRQ      15
#define BM_SSP_CTRL1_FIFO_OVERRUN_IRQ      0x00008000

#define BF_SSP_CTRL1_FIFO_OVERRUN_IRQ(v)   (((v) << 15) & BM_SSP_CTRL1_FIFO_OVERRUN_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_FIFO_OVERRUN_IRQ(v)   BF_CS1(SSP_CTRL1, FIFO_OVERRUN_IRQ, v)
#endif

//--- Register HW_SSP_CTRL1, field FIFO_OVERRUN_IRQ_EN

#define BP_SSP_CTRL1_FIFO_OVERRUN_IRQ_EN      14
#define BM_SSP_CTRL1_FIFO_OVERRUN_IRQ_EN      0x00004000

#define BF_SSP_CTRL1_FIFO_OVERRUN_IRQ_EN(v)   (((v) << 14) & BM_SSP_CTRL1_FIFO_OVERRUN_IRQ_EN)

#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_FIFO_OVERRUN_IRQ_EN(v)   BF_CS1(SSP_CTRL1, FIFO_OVERRUN_IRQ_EN, v)
#endif

//--- Register HW_SSP_CTRL1, field DMA_ENABLE

#define BP_SSP_CTRL1_DMA_ENABLE      13
#define BM_SSP_CTRL1_DMA_ENABLE      0x00002000

#define BF_SSP_CTRL1_DMA_ENABLE(v)   (((v) << 13) & BM_SSP_CTRL1_DMA_ENABLE)

#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_DMA_ENABLE(v)   BF_CS1(SSP_CTRL1, DMA_ENABLE, v)
#endif

//--- Register HW_SSP_CTRL1, field CEATA_CCS_ERR_EN

#define BP_SSP_CTRL1_CEATA_CCS_ERR_EN      12
#define BM_SSP_CTRL1_CEATA_CCS_ERR_EN      0x00001000

#define BF_SSP_CTRL1_CEATA_CCS_ERR_EN(v)   (((v) << 12) & BM_SSP_CTRL1_CEATA_CCS_ERR_EN)

#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_CEATA_CCS_ERR_EN(v)   BF_CS1(SSP_CTRL1, CEATA_CCS_ERR_EN, v)
#endif

//--- Register HW_SSP_CTRL1, field SLAVE_OUT_DISABLE

#define BP_SSP_CTRL1_SLAVE_OUT_DISABLE      11
#define BM_SSP_CTRL1_SLAVE_OUT_DISABLE      0x00000800

#define BF_SSP_CTRL1_SLAVE_OUT_DISABLE(v)   (((v) << 11) & BM_SSP_CTRL1_SLAVE_OUT_DISABLE)

#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_SLAVE_OUT_DISABLE(v)   BF_CS1(SSP_CTRL1, SLAVE_OUT_DISABLE, v)
#endif

//--- Register HW_SSP_CTRL1, field PHASE

#define BP_SSP_CTRL1_PHASE      10
#define BM_SSP_CTRL1_PHASE      0x00000400

#define BF_SSP_CTRL1_PHASE(v)   (((v) << 10) & BM_SSP_CTRL1_PHASE)

#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_PHASE(v)   BF_CS1(SSP_CTRL1, PHASE, v)
#endif

//--- Register HW_SSP_CTRL1, field POLARITY

#define BP_SSP_CTRL1_POLARITY      9
#define BM_SSP_CTRL1_POLARITY      0x00000200

#define BF_SSP_CTRL1_POLARITY(v)   (((v) << 9) & BM_SSP_CTRL1_POLARITY)

#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_POLARITY(v)   BF_CS1(SSP_CTRL1, POLARITY, v)
#endif

//--- Register HW_SSP_CTRL1, field SLAVE_MODE

#define BP_SSP_CTRL1_SLAVE_MODE      8
#define BM_SSP_CTRL1_SLAVE_MODE      0x00000100

#define BF_SSP_CTRL1_SLAVE_MODE(v)   (((v) << 8) & BM_SSP_CTRL1_SLAVE_MODE)

#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_SLAVE_MODE(v)   BF_CS1(SSP_CTRL1, SLAVE_MODE, v)
#endif

//--- Register HW_SSP_CTRL1, field WORD_LENGTH

#define BP_SSP_CTRL1_WORD_LENGTH      4
#define BM_SSP_CTRL1_WORD_LENGTH      0x000000F0

#define BF_SSP_CTRL1_WORD_LENGTH(v)   (((v) << 4) & BM_SSP_CTRL1_WORD_LENGTH)

#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_WORD_LENGTH(v)   BF_CS1(SSP_CTRL1, WORD_LENGTH, v)
#endif

#define BV_SSP_CTRL1_WORD_LENGTH__RESERVED0     0x0
#define BV_SSP_CTRL1_WORD_LENGTH__RESERVED1     0x1
#define BV_SSP_CTRL1_WORD_LENGTH__RESERVED2     0x2
#define BV_SSP_CTRL1_WORD_LENGTH__FOUR_BITS     0x3
#define BV_SSP_CTRL1_WORD_LENGTH__EIGHT_BITS    0x7
#define BV_SSP_CTRL1_WORD_LENGTH__SIXTEEN_BITS  0xF

//--- Register HW_SSP_CTRL1, field SSP_MODE

#define BP_SSP_CTRL1_SSP_MODE      0
#define BM_SSP_CTRL1_SSP_MODE      0x0000000F

#define BF_SSP_CTRL1_SSP_MODE(v)   (((v) << 0) & BM_SSP_CTRL1_SSP_MODE)

#ifndef __LANGUAGE_ASM__
#define BW_SSP_CTRL1_SSP_MODE(v)   BF_CS1(SSP_CTRL1, SSP_MODE, v)
#endif

#define BV_SSP_CTRL1_SSP_MODE__SPI     0x0
#define BV_SSP_CTRL1_SSP_MODE__SSI     0x1
#define BV_SSP_CTRL1_SSP_MODE__SD_MMC  0x3
#define BV_SSP_CTRL1_SSP_MODE__MS      0x4
#define BV_SSP_CTRL1_SSP_MODE__CE_ATA  0x7


////////////////////////////////////////////////////////////////////////////////
//// HW_SSP_DATA - SSP Data Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  DATA;
    } B;
} hw_ssp_data_t;
#endif


//
// constants & macros for entire HW_SSP_DATA register
//

#define HW_SSP_DATA_ADDR      (REGS_SSP_BASE + 0x00000070)

#ifndef __LANGUAGE_ASM__
#define HW_SSP_DATA           (*(volatile hw_ssp_data_t *) HW_SSP_DATA_ADDR)
#define HW_SSP_DATA_RD()      (HW_SSP_DATA.U)
#define HW_SSP_DATA_WR(v)     (HW_SSP_DATA.U = (v))
#define HW_SSP_DATA_SET(v)    (HW_SSP_DATA_WR(HW_SSP_DATA_RD() |  (v)))
#define HW_SSP_DATA_CLR(v)    (HW_SSP_DATA_WR(HW_SSP_DATA_RD() & ~(v)))
#define HW_SSP_DATA_TOG(v)    (HW_SSP_DATA_WR(HW_SSP_DATA_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_SSP_DATA bitfields
//

//--- Register HW_SSP_DATA, field DATA

#define BP_SSP_DATA_DATA      0
#define BM_SSP_DATA_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SSP_DATA_DATA(v)   ((reg32_t) v)
#else
#define BF_SSP_DATA_DATA(v)   (v)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_SSP_DATA_DATA(v)   (HW_SSP_DATA.B.DATA = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SSP_SDRESP0 - SD/MMC Card Response Register 0
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  RESP0;
    } B;
} hw_ssp_sdresp0_t;
#endif


//
// constants & macros for entire HW_SSP_SDRESP0 register
//

#define HW_SSP_SDRESP0_ADDR      (REGS_SSP_BASE + 0x00000080)

#ifndef __LANGUAGE_ASM__
#define HW_SSP_SDRESP0           (*(volatile hw_ssp_sdresp0_t *) HW_SSP_SDRESP0_ADDR)
#define HW_SSP_SDRESP0_RD()      (HW_SSP_SDRESP0.U)
#endif


//
// constants & macros for individual HW_SSP_SDRESP0 bitfields
//

//--- Register HW_SSP_SDRESP0, field RESP0

#define BP_SSP_SDRESP0_RESP0      0
#define BM_SSP_SDRESP0_RESP0      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SSP_SDRESP0_RESP0(v)   ((reg32_t) v)
#else
#define BF_SSP_SDRESP0_RESP0(v)   (v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SSP_SDRESP1 - SD/MMC Card Response Register 1
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  RESP1;
    } B;
} hw_ssp_sdresp1_t;
#endif


//
// constants & macros for entire HW_SSP_SDRESP1 register
//

#define HW_SSP_SDRESP1_ADDR      (REGS_SSP_BASE + 0x00000090)

#ifndef __LANGUAGE_ASM__
#define HW_SSP_SDRESP1           (*(volatile hw_ssp_sdresp1_t *) HW_SSP_SDRESP1_ADDR)
#define HW_SSP_SDRESP1_RD()      (HW_SSP_SDRESP1.U)
#endif


//
// constants & macros for individual HW_SSP_SDRESP1 bitfields
//

//--- Register HW_SSP_SDRESP1, field RESP1

#define BP_SSP_SDRESP1_RESP1      0
#define BM_SSP_SDRESP1_RESP1      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SSP_SDRESP1_RESP1(v)   ((reg32_t) v)
#else
#define BF_SSP_SDRESP1_RESP1(v)   (v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SSP_SDRESP2 - SD/MMC Card Response Register 2
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  RESP2;
    } B;
} hw_ssp_sdresp2_t;
#endif


//
// constants & macros for entire HW_SSP_SDRESP2 register
//

#define HW_SSP_SDRESP2_ADDR      (REGS_SSP_BASE + 0x000000A0)

#ifndef __LANGUAGE_ASM__
#define HW_SSP_SDRESP2           (*(volatile hw_ssp_sdresp2_t *) HW_SSP_SDRESP2_ADDR)
#define HW_SSP_SDRESP2_RD()      (HW_SSP_SDRESP2.U)
#endif


//
// constants & macros for individual HW_SSP_SDRESP2 bitfields
//

//--- Register HW_SSP_SDRESP2, field RESP2

#define BP_SSP_SDRESP2_RESP2      0
#define BM_SSP_SDRESP2_RESP2      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SSP_SDRESP2_RESP2(v)   ((reg32_t) v)
#else
#define BF_SSP_SDRESP2_RESP2(v)   (v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SSP_SDRESP3 - SD/MMC Card Response Register 3
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg32_t  RESP3;
    } B;
} hw_ssp_sdresp3_t;
#endif


//
// constants & macros for entire HW_SSP_SDRESP3 register
//

#define HW_SSP_SDRESP3_ADDR      (REGS_SSP_BASE + 0x000000B0)

#ifndef __LANGUAGE_ASM__
#define HW_SSP_SDRESP3           (*(volatile hw_ssp_sdresp3_t *) HW_SSP_SDRESP3_ADDR)
#define HW_SSP_SDRESP3_RD()      (HW_SSP_SDRESP3.U)
#endif


//
// constants & macros for individual HW_SSP_SDRESP3 bitfields
//

//--- Register HW_SSP_SDRESP3, field RESP3

#define BP_SSP_SDRESP3_RESP3      0
#define BM_SSP_SDRESP3_RESP3      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_SSP_SDRESP3_RESP3(v)   ((reg32_t) v)
#else
#define BF_SSP_SDRESP3_RESP3(v)   (v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_SSP_STATUS - SSP Status Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BUSY               :  1;
        unsigned RSVD0              :  1;
        unsigned DATA_BUSY          :  1;
        unsigned CMD_BUSY           :  1;
        unsigned FIFO_UNDRFLW       :  1;
        unsigned FIFO_EMPTY         :  1;
        unsigned RSVD1              :  2;
        unsigned FIFO_FULL          :  1;
        unsigned FIFO_OVRFLW        :  1;
        unsigned CEATA_CCS_ERR      :  1;
        unsigned RECV_TIMEOUT_STAT  :  1;
        unsigned TIMEOUT            :  1;
        unsigned DATA_CRC_ERR       :  1;
        unsigned RESP_TIMEOUT       :  1;
        unsigned RESP_ERR           :  1;
        unsigned RESP_CRC_ERR       :  1;
        unsigned SDIO_IRQ           :  1;
        unsigned DMAEND             :  1;
        unsigned DMAREQ             :  1;
        unsigned DMATERM            :  1;
        unsigned DMASENSE           :  1;
        unsigned RSVD3              :  6;
        unsigned CARD_DETECT        :  1;
        unsigned SD_PRESENT         :  1;
        unsigned MS_PRESENT         :  1;
        unsigned PRESENT            :  1;
    } B;
} hw_ssp_status_t;
#endif


//
// constants & macros for entire HW_SSP_STATUS register
//

#define HW_SSP_STATUS_ADDR      (REGS_SSP_BASE + 0x000000C0)

#ifndef __LANGUAGE_ASM__
#define HW_SSP_STATUS           (*(volatile hw_ssp_status_t *) HW_SSP_STATUS_ADDR)
#define HW_SSP_STATUS_RD()      (HW_SSP_STATUS.U)
#endif


//
// constants & macros for individual HW_SSP_STATUS bitfields
//

//--- Register HW_SSP_STATUS, field PRESENT

#define BP_SSP_STATUS_PRESENT      31
#define BM_SSP_STATUS_PRESENT      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_SSP_STATUS_PRESENT(v)   ((((reg32_t) v) << 31) & BM_SSP_STATUS_PRESENT)
#else
#define BF_SSP_STATUS_PRESENT(v)   (((v) << 31) & BM_SSP_STATUS_PRESENT)
#endif

//--- Register HW_SSP_STATUS, field MS_PRESENT

#define BP_SSP_STATUS_MS_PRESENT      30
#define BM_SSP_STATUS_MS_PRESENT      0x40000000

#define BF_SSP_STATUS_MS_PRESENT(v)   (((v) << 30) & BM_SSP_STATUS_MS_PRESENT)

//--- Register HW_SSP_STATUS, field SD_PRESENT

#define BP_SSP_STATUS_SD_PRESENT      29
#define BM_SSP_STATUS_SD_PRESENT      0x20000000

#define BF_SSP_STATUS_SD_PRESENT(v)   (((v) << 29) & BM_SSP_STATUS_SD_PRESENT)

//--- Register HW_SSP_STATUS, field CARD_DETECT

#define BP_SSP_STATUS_CARD_DETECT      28
#define BM_SSP_STATUS_CARD_DETECT      0x10000000

#define BF_SSP_STATUS_CARD_DETECT(v)   (((v) << 28) & BM_SSP_STATUS_CARD_DETECT)

//--- Register HW_SSP_STATUS, field DMASENSE

#define BP_SSP_STATUS_DMASENSE      21
#define BM_SSP_STATUS_DMASENSE      0x00200000

#define BF_SSP_STATUS_DMASENSE(v)   (((v) << 21) & BM_SSP_STATUS_DMASENSE)

//--- Register HW_SSP_STATUS, field DMATERM

#define BP_SSP_STATUS_DMATERM      20
#define BM_SSP_STATUS_DMATERM      0x00100000

#define BF_SSP_STATUS_DMATERM(v)   (((v) << 20) & BM_SSP_STATUS_DMATERM)

//--- Register HW_SSP_STATUS, field DMAREQ

#define BP_SSP_STATUS_DMAREQ      19
#define BM_SSP_STATUS_DMAREQ      0x00080000

#define BF_SSP_STATUS_DMAREQ(v)   (((v) << 19) & BM_SSP_STATUS_DMAREQ)

//--- Register HW_SSP_STATUS, field DMAEND

#define BP_SSP_STATUS_DMAEND      18
#define BM_SSP_STATUS_DMAEND      0x00040000

#define BF_SSP_STATUS_DMAEND(v)   (((v) << 18) & BM_SSP_STATUS_DMAEND)

//--- Register HW_SSP_STATUS, field SDIO_IRQ

#define BP_SSP_STATUS_SDIO_IRQ      17
#define BM_SSP_STATUS_SDIO_IRQ      0x00020000

#define BF_SSP_STATUS_SDIO_IRQ(v)   (((v) << 17) & BM_SSP_STATUS_SDIO_IRQ)

//--- Register HW_SSP_STATUS, field RESP_CRC_ERR

#define BP_SSP_STATUS_RESP_CRC_ERR      16
#define BM_SSP_STATUS_RESP_CRC_ERR      0x00010000

#define BF_SSP_STATUS_RESP_CRC_ERR(v)   (((v) << 16) & BM_SSP_STATUS_RESP_CRC_ERR)

//--- Register HW_SSP_STATUS, field RESP_ERR

#define BP_SSP_STATUS_RESP_ERR      15
#define BM_SSP_STATUS_RESP_ERR      0x00008000

#define BF_SSP_STATUS_RESP_ERR(v)   (((v) << 15) & BM_SSP_STATUS_RESP_ERR)

//--- Register HW_SSP_STATUS, field RESP_TIMEOUT

#define BP_SSP_STATUS_RESP_TIMEOUT      14
#define BM_SSP_STATUS_RESP_TIMEOUT      0x00004000

#define BF_SSP_STATUS_RESP_TIMEOUT(v)   (((v) << 14) & BM_SSP_STATUS_RESP_TIMEOUT)

//--- Register HW_SSP_STATUS, field DATA_CRC_ERR

#define BP_SSP_STATUS_DATA_CRC_ERR      13
#define BM_SSP_STATUS_DATA_CRC_ERR      0x00002000

#define BF_SSP_STATUS_DATA_CRC_ERR(v)   (((v) << 13) & BM_SSP_STATUS_DATA_CRC_ERR)

//--- Register HW_SSP_STATUS, field TIMEOUT

#define BP_SSP_STATUS_TIMEOUT      12
#define BM_SSP_STATUS_TIMEOUT      0x00001000

#define BF_SSP_STATUS_TIMEOUT(v)   (((v) << 12) & BM_SSP_STATUS_TIMEOUT)

//--- Register HW_SSP_STATUS, field RECV_TIMEOUT_STAT

#define BP_SSP_STATUS_RECV_TIMEOUT_STAT      11
#define BM_SSP_STATUS_RECV_TIMEOUT_STAT      0x00000800

#define BF_SSP_STATUS_RECV_TIMEOUT_STAT(v)   (((v) << 11) & BM_SSP_STATUS_RECV_TIMEOUT_STAT)

//--- Register HW_SSP_STATUS, field CEATA_CCS_ERR

#define BP_SSP_STATUS_CEATA_CCS_ERR      10
#define BM_SSP_STATUS_CEATA_CCS_ERR      0x00000400

#define BF_SSP_STATUS_CEATA_CCS_ERR(v)   (((v) << 10) & BM_SSP_STATUS_CEATA_CCS_ERR)

//--- Register HW_SSP_STATUS, field FIFO_OVRFLW

#define BP_SSP_STATUS_FIFO_OVRFLW      9
#define BM_SSP_STATUS_FIFO_OVRFLW      0x00000200

#define BF_SSP_STATUS_FIFO_OVRFLW(v)   (((v) << 9) & BM_SSP_STATUS_FIFO_OVRFLW)

//--- Register HW_SSP_STATUS, field FIFO_FULL

#define BP_SSP_STATUS_FIFO_FULL      8
#define BM_SSP_STATUS_FIFO_FULL      0x00000100

#define BF_SSP_STATUS_FIFO_FULL(v)   (((v) << 8) & BM_SSP_STATUS_FIFO_FULL)

//--- Register HW_SSP_STATUS, field FIFO_EMPTY

#define BP_SSP_STATUS_FIFO_EMPTY      5
#define BM_SSP_STATUS_FIFO_EMPTY      0x00000020

#define BF_SSP_STATUS_FIFO_EMPTY(v)   (((v) << 5) & BM_SSP_STATUS_FIFO_EMPTY)

//--- Register HW_SSP_STATUS, field FIFO_UNDRFLW

#define BP_SSP_STATUS_FIFO_UNDRFLW      4
#define BM_SSP_STATUS_FIFO_UNDRFLW      0x00000010

#define BF_SSP_STATUS_FIFO_UNDRFLW(v)   (((v) << 4) & BM_SSP_STATUS_FIFO_UNDRFLW)

//--- Register HW_SSP_STATUS, field CMD_BUSY

#define BP_SSP_STATUS_CMD_BUSY      3
#define BM_SSP_STATUS_CMD_BUSY      0x00000008

#define BF_SSP_STATUS_CMD_BUSY(v)   (((v) << 3) & BM_SSP_STATUS_CMD_BUSY)

//--- Register HW_SSP_STATUS, field DATA_BUSY

#define BP_SSP_STATUS_DATA_BUSY      2
#define BM_SSP_STATUS_DATA_BUSY      0x00000004

#define BF_SSP_STATUS_DATA_BUSY(v)   (((v) << 2) & BM_SSP_STATUS_DATA_BUSY)

//--- Register HW_SSP_STATUS, field BUSY

#define BP_SSP_STATUS_BUSY      0
#define BM_SSP_STATUS_BUSY      0x00000001

#define BF_SSP_STATUS_BUSY(v)   (((v) << 0) & BM_SSP_STATUS_BUSY)


////////////////////////////////////////////////////////////////////////////////
//// HW_SSP_DEBUG - SSP Debug Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg8_t   SSP_RXD;
        unsigned SSP_RESP     :  1;
        unsigned SSP_CMD      :  1;
        unsigned CMD_SM       :  2;
        unsigned MMC_SM       :  4;
        unsigned DMA_SM       :  3;
        unsigned CMD_OE       :  1;
        unsigned MSTK_SM      :  4;
        unsigned DAT_SM       :  3;
        unsigned DATA_STALL   :  1;
        unsigned DATACRC_ERR  :  4;
    } B;
} hw_ssp_debug_t;
#endif


//
// constants & macros for entire HW_SSP_DEBUG register
//

#define HW_SSP_DEBUG_ADDR      (REGS_SSP_BASE + 0x00000100)

#ifndef __LANGUAGE_ASM__
#define HW_SSP_DEBUG           (*(volatile hw_ssp_debug_t *) HW_SSP_DEBUG_ADDR)
#define HW_SSP_DEBUG_RD()      (HW_SSP_DEBUG.U)
#endif


//
// constants & macros for individual HW_SSP_DEBUG bitfields
//

//--- Register HW_SSP_DEBUG, field DATACRC_ERR

#define BP_SSP_DEBUG_DATACRC_ERR      28
#define BM_SSP_DEBUG_DATACRC_ERR      0xF0000000

#ifndef __LANGUAGE_ASM__
#define BF_SSP_DEBUG_DATACRC_ERR(v)   ((((reg32_t) v) << 28) & BM_SSP_DEBUG_DATACRC_ERR)
#else
#define BF_SSP_DEBUG_DATACRC_ERR(v)   (((v) << 28) & BM_SSP_DEBUG_DATACRC_ERR)
#endif

//--- Register HW_SSP_DEBUG, field DATA_STALL

#define BP_SSP_DEBUG_DATA_STALL      27
#define BM_SSP_DEBUG_DATA_STALL      0x08000000

#define BF_SSP_DEBUG_DATA_STALL(v)   (((v) << 27) & BM_SSP_DEBUG_DATA_STALL)

//--- Register HW_SSP_DEBUG, field DAT_SM

#define BP_SSP_DEBUG_DAT_SM      24
#define BM_SSP_DEBUG_DAT_SM      0x07000000

#define BF_SSP_DEBUG_DAT_SM(v)   (((v) << 24) & BM_SSP_DEBUG_DAT_SM)

#define BV_SSP_DEBUG_DAT_SM__DSM_IDLE  0x0
#define BV_SSP_DEBUG_DAT_SM__DSM_WORD  0x2
#define BV_SSP_DEBUG_DAT_SM__DSM_CRC1  0x3
#define BV_SSP_DEBUG_DAT_SM__DSM_CRC2  0x4
#define BV_SSP_DEBUG_DAT_SM__DSM_END   0x5

//--- Register HW_SSP_DEBUG, field MSTK_SM

#define BP_SSP_DEBUG_MSTK_SM      20
#define BM_SSP_DEBUG_MSTK_SM      0x00F00000

#define BF_SSP_DEBUG_MSTK_SM(v)   (((v) << 20) & BM_SSP_DEBUG_MSTK_SM)

#define BV_SSP_DEBUG_MSTK_SM__MSTK_IDLE   0x0
#define BV_SSP_DEBUG_MSTK_SM__MSTK_CKON   0x1
#define BV_SSP_DEBUG_MSTK_SM__MSTK_BS1    0x2
#define BV_SSP_DEBUG_MSTK_SM__MSTK_TPC    0x3
#define BV_SSP_DEBUG_MSTK_SM__MSTK_BS2    0x4
#define BV_SSP_DEBUG_MSTK_SM__MSTK_HDSHK  0x5
#define BV_SSP_DEBUG_MSTK_SM__MSTK_BS3    0x6
#define BV_SSP_DEBUG_MSTK_SM__MSTK_RW     0x7
#define BV_SSP_DEBUG_MSTK_SM__MSTK_CRC1   0x8
#define BV_SSP_DEBUG_MSTK_SM__MSTK_CRC2   0x9
#define BV_SSP_DEBUG_MSTK_SM__MSTK_BS0    0xA
#define BV_SSP_DEBUG_MSTK_SM__MSTK_END1   0xB
#define BV_SSP_DEBUG_MSTK_SM__MSTK_END2W  0xC
#define BV_SSP_DEBUG_MSTK_SM__MSTK_END2R  0xD
#define BV_SSP_DEBUG_MSTK_SM__MSTK_DONE   0xE

//--- Register HW_SSP_DEBUG, field CMD_OE

#define BP_SSP_DEBUG_CMD_OE      19
#define BM_SSP_DEBUG_CMD_OE      0x00080000

#define BF_SSP_DEBUG_CMD_OE(v)   (((v) << 19) & BM_SSP_DEBUG_CMD_OE)

//--- Register HW_SSP_DEBUG, field DMA_SM

#define BP_SSP_DEBUG_DMA_SM      16
#define BM_SSP_DEBUG_DMA_SM      0x00070000

#define BF_SSP_DEBUG_DMA_SM(v)   (((v) << 16) & BM_SSP_DEBUG_DMA_SM)

#define BV_SSP_DEBUG_DMA_SM__DMA_IDLE    0x0
#define BV_SSP_DEBUG_DMA_SM__DMA_DMAREQ  0x1
#define BV_SSP_DEBUG_DMA_SM__DMA_DMAACK  0x2
#define BV_SSP_DEBUG_DMA_SM__DMA_STALL   0x3
#define BV_SSP_DEBUG_DMA_SM__DMA_BUSY    0x4
#define BV_SSP_DEBUG_DMA_SM__DMA_DONE    0x5
#define BV_SSP_DEBUG_DMA_SM__DMA_COUNT   0x6

//--- Register HW_SSP_DEBUG, field MMC_SM

#define BP_SSP_DEBUG_MMC_SM      12
#define BM_SSP_DEBUG_MMC_SM      0x0000F000

#define BF_SSP_DEBUG_MMC_SM(v)   (((v) << 12) & BM_SSP_DEBUG_MMC_SM)

#define BV_SSP_DEBUG_MMC_SM__MMC_IDLE  0x0
#define BV_SSP_DEBUG_MMC_SM__MMC_CMD   0x1
#define BV_SSP_DEBUG_MMC_SM__MMC_TRC   0x2
#define BV_SSP_DEBUG_MMC_SM__MMC_RESP  0x3
#define BV_SSP_DEBUG_MMC_SM__MMC_RPRX  0x4
#define BV_SSP_DEBUG_MMC_SM__MMC_TX    0x5
#define BV_SSP_DEBUG_MMC_SM__MMC_CTOK  0x6
#define BV_SSP_DEBUG_MMC_SM__MMC_RX    0x7
#define BV_SSP_DEBUG_MMC_SM__MMC_CCS   0x8
#define BV_SSP_DEBUG_MMC_SM__MMC_PUP   0x9
#define BV_SSP_DEBUG_MMC_SM__MMC_WAIT  0xA

//--- Register HW_SSP_DEBUG, field CMD_SM

#define BP_SSP_DEBUG_CMD_SM      10
#define BM_SSP_DEBUG_CMD_SM      0x00000C00

#define BF_SSP_DEBUG_CMD_SM(v)   (((v) << 10) & BM_SSP_DEBUG_CMD_SM)

#define BV_SSP_DEBUG_CMD_SM__CSM_IDLE   0x0
#define BV_SSP_DEBUG_CMD_SM__CSM_INDEX  0x1
#define BV_SSP_DEBUG_CMD_SM__CSM_ARG    0x2
#define BV_SSP_DEBUG_CMD_SM__CSM_CRC    0x3

//--- Register HW_SSP_DEBUG, field SSP_CMD

#define BP_SSP_DEBUG_SSP_CMD      9
#define BM_SSP_DEBUG_SSP_CMD      0x00000200

#define BF_SSP_DEBUG_SSP_CMD(v)   (((v) << 9) & BM_SSP_DEBUG_SSP_CMD)

//--- Register HW_SSP_DEBUG, field SSP_RESP

#define BP_SSP_DEBUG_SSP_RESP      8
#define BM_SSP_DEBUG_SSP_RESP      0x00000100

#define BF_SSP_DEBUG_SSP_RESP(v)   (((v) << 8) & BM_SSP_DEBUG_SSP_RESP)

//--- Register HW_SSP_DEBUG, field SSP_RXD

#define BP_SSP_DEBUG_SSP_RXD      0
#define BM_SSP_DEBUG_SSP_RXD      0x000000FF

#define BF_SSP_DEBUG_SSP_RXD(v)   (((v) << 0) & BM_SSP_DEBUG_SSP_RXD)


////////////////////////////////////////////////////////////////////////////////
//// HW_SSP_VERSION - SSP Version Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg16_t  STEP;
        reg8_t   MINOR;
        reg8_t   MAJOR;
    } B;
} hw_ssp_version_t;
#endif


//
// constants & macros for entire HW_SSP_VERSION register
//

#define HW_SSP_VERSION_ADDR      (REGS_SSP_BASE + 0x00000110)

#ifndef __LANGUAGE_ASM__
#define HW_SSP_VERSION           (*(volatile hw_ssp_version_t *) HW_SSP_VERSION_ADDR)
#define HW_SSP_VERSION_RD()      (HW_SSP_VERSION.U)
#endif


//
// constants & macros for individual HW_SSP_VERSION bitfields
//

//--- Register HW_SSP_VERSION, field MAJOR

#define BP_SSP_VERSION_MAJOR      24
#define BM_SSP_VERSION_MAJOR      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_SSP_VERSION_MAJOR(v)   ((((reg32_t) v) << 24) & BM_SSP_VERSION_MAJOR)
#else
#define BF_SSP_VERSION_MAJOR(v)   (((v) << 24) & BM_SSP_VERSION_MAJOR)
#endif

//--- Register HW_SSP_VERSION, field MINOR

#define BP_SSP_VERSION_MINOR      16
#define BM_SSP_VERSION_MINOR      0x00FF0000

#define BF_SSP_VERSION_MINOR(v)   (((v) << 16) & BM_SSP_VERSION_MINOR)

//--- Register HW_SSP_VERSION, field STEP

#define BP_SSP_VERSION_STEP      0
#define BM_SSP_VERSION_STEP      0x0000FFFF

#define BF_SSP_VERSION_STEP(v)   (((v) << 0) & BM_SSP_VERSION_STEP)


#endif // _REGSSSP_H

////////////////////////////////////////////////////////////////////////////////
