/*
 * Copyright 2009 Freescale Semiconductor, Inc. All Rights Reserved.
 */

/*
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 */
////////////////////////////////////////////////////////////////////////////////
//
// WARNING!  THIS FILE IS AUTOMATICALLY GENERATED FROM XML.
//                DO NOT MODIFY THIS FILE DIRECTLY.
//
////////////////////////////////////////////////////////////////////////////////
//
// The following naming conventions are followed in this file.
//      XX_<module>_<regname>_<field>
//
// XX specifies the define / macro class
//      HW pertains to a register
//      BM indicates a Bit Mask
//      BF indicates a Bit Field macro
//
// <module> is the hardware module name which can be any of the following...
//      USB20 (Note when there is more than one copy of a given module, the
//      module name includes a number starting from 0 for the first instance
//      of that module)
//
// <regname> is the specific register within that module
//
// <field> is the specific bitfield within that <module>_<register>
//
// We also define the following...
//      hw_<module>_<regname>_t is typedef of anonymous union
//
////////////////////////////////////////////////////////////////////////////////

#ifndef _REGSUSBPHY_H
#define _REGSUSBPHY_H  1

#include "regs.h"

#ifndef REGS_USBPHY_BASE
#define REGS_USBPHY_BASE (REGS_BASE + 0x0007C000)
#endif

////////////////////////////////////////////////////////////////////////////////
//// HW_USBPHY_PWD - USB PHY Power-Down Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSVD0       : 10;
        unsigned TXPWDFS     :  1;
        unsigned TXPWDIBIAS  :  1;
        unsigned TXPWDV2I    :  1;
        unsigned RSVD1       :  4;
        unsigned RXPWDENV    :  1;
        unsigned RXPWD1PT1   :  1;
        unsigned RXPWDDIFF   :  1;
        unsigned RXPWDRX     :  1;
        unsigned RSVD2       : 11;
    } B;
} hw_usbphy_pwd_t;
#endif


//
// constants & macros for entire HW_USBPHY_PWD register
//

#define HW_USBPHY_PWD_ADDR      (REGS_USBPHY_BASE + 0x00000000)
#define HW_USBPHY_PWD_SET_ADDR  (REGS_USBPHY_BASE + 0x00000004)
#define HW_USBPHY_PWD_CLR_ADDR  (REGS_USBPHY_BASE + 0x00000008)
#define HW_USBPHY_PWD_TOG_ADDR  (REGS_USBPHY_BASE + 0x0000000C)

#ifndef __LANGUAGE_ASM__
#define HW_USBPHY_PWD           (*(volatile hw_usbphy_pwd_t *) HW_USBPHY_PWD_ADDR)
#define HW_USBPHY_PWD_RD()      (HW_USBPHY_PWD.U)
#define HW_USBPHY_PWD_WR(v)     (HW_USBPHY_PWD.U = (v))
#define HW_USBPHY_PWD_SET(v)    ((*(volatile reg32_t *) HW_USBPHY_PWD_SET_ADDR) = (v))
#define HW_USBPHY_PWD_CLR(v)    ((*(volatile reg32_t *) HW_USBPHY_PWD_CLR_ADDR) = (v))
#define HW_USBPHY_PWD_TOG(v)    ((*(volatile reg32_t *) HW_USBPHY_PWD_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_USBPHY_PWD bitfields
//

//--- Register HW_USBPHY_PWD, field RXPWDRX

#define BP_USBPHY_PWD_RXPWDRX      20
#define BM_USBPHY_PWD_RXPWDRX      0x00100000

#define BF_USBPHY_PWD_RXPWDRX(v)   (((v) << 20) & BM_USBPHY_PWD_RXPWDRX)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_PWD_RXPWDRX(v)   BF_CS1(USBPHY_PWD, RXPWDRX, v)
#endif

//--- Register HW_USBPHY_PWD, field RXPWDDIFF

#define BP_USBPHY_PWD_RXPWDDIFF      19
#define BM_USBPHY_PWD_RXPWDDIFF      0x00080000

#define BF_USBPHY_PWD_RXPWDDIFF(v)   (((v) << 19) & BM_USBPHY_PWD_RXPWDDIFF)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_PWD_RXPWDDIFF(v)   BF_CS1(USBPHY_PWD, RXPWDDIFF, v)
#endif

//--- Register HW_USBPHY_PWD, field RXPWD1PT1

#define BP_USBPHY_PWD_RXPWD1PT1      18
#define BM_USBPHY_PWD_RXPWD1PT1      0x00040000

#define BF_USBPHY_PWD_RXPWD1PT1(v)   (((v) << 18) & BM_USBPHY_PWD_RXPWD1PT1)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_PWD_RXPWD1PT1(v)   BF_CS1(USBPHY_PWD, RXPWD1PT1, v)
#endif

//--- Register HW_USBPHY_PWD, field RXPWDENV

#define BP_USBPHY_PWD_RXPWDENV      17
#define BM_USBPHY_PWD_RXPWDENV      0x00020000

#define BF_USBPHY_PWD_RXPWDENV(v)   (((v) << 17) & BM_USBPHY_PWD_RXPWDENV)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_PWD_RXPWDENV(v)   BF_CS1(USBPHY_PWD, RXPWDENV, v)
#endif

//--- Register HW_USBPHY_PWD, field TXPWDV2I

#define BP_USBPHY_PWD_TXPWDV2I      12
#define BM_USBPHY_PWD_TXPWDV2I      0x00001000

#define BF_USBPHY_PWD_TXPWDV2I(v)   (((v) << 12) & BM_USBPHY_PWD_TXPWDV2I)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_PWD_TXPWDV2I(v)   BF_CS1(USBPHY_PWD, TXPWDV2I, v)
#endif

//--- Register HW_USBPHY_PWD, field TXPWDIBIAS

#define BP_USBPHY_PWD_TXPWDIBIAS      11
#define BM_USBPHY_PWD_TXPWDIBIAS      0x00000800

#define BF_USBPHY_PWD_TXPWDIBIAS(v)   (((v) << 11) & BM_USBPHY_PWD_TXPWDIBIAS)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_PWD_TXPWDIBIAS(v)   BF_CS1(USBPHY_PWD, TXPWDIBIAS, v)
#endif

//--- Register HW_USBPHY_PWD, field TXPWDFS

#define BP_USBPHY_PWD_TXPWDFS      10
#define BM_USBPHY_PWD_TXPWDFS      0x00000400

#define BF_USBPHY_PWD_TXPWDFS(v)   (((v) << 10) & BM_USBPHY_PWD_TXPWDFS)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_PWD_TXPWDFS(v)   BF_CS1(USBPHY_PWD, TXPWDFS, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_USBPHY_TX - USB PHY Transmitter Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned D_CAL                  :  4;
        unsigned RSVD0                  :  4;
        unsigned TXCAL45DN              :  4;
        unsigned RSVD1                  :  1;
        unsigned TXENCAL45DN            :  1;
        unsigned RSVD2                  :  2;
        unsigned TXCAL45DP              :  4;
        unsigned RSVD3                  :  1;
        unsigned TXENCAL45DP            :  1;
        unsigned RSVD4                  :  2;
        unsigned USBPHY_TX_SYNC_MUX     :  1;
        unsigned USBPHY_TX_SYNC_INVERT  :  1;
        unsigned USBPHY_TX_EDGECTRL     :  3;
        unsigned RSVD5                  :  3;
    } B;
} hw_usbphy_tx_t;
#endif


//
// constants & macros for entire HW_USBPHY_TX register
//

#define HW_USBPHY_TX_ADDR      (REGS_USBPHY_BASE + 0x00000010)
#define HW_USBPHY_TX_SET_ADDR  (REGS_USBPHY_BASE + 0x00000014)
#define HW_USBPHY_TX_CLR_ADDR  (REGS_USBPHY_BASE + 0x00000018)
#define HW_USBPHY_TX_TOG_ADDR  (REGS_USBPHY_BASE + 0x0000001C)

#ifndef __LANGUAGE_ASM__
#define HW_USBPHY_TX           (*(volatile hw_usbphy_tx_t *) HW_USBPHY_TX_ADDR)
#define HW_USBPHY_TX_RD()      (HW_USBPHY_TX.U)
#define HW_USBPHY_TX_WR(v)     (HW_USBPHY_TX.U = (v))
#define HW_USBPHY_TX_SET(v)    ((*(volatile reg32_t *) HW_USBPHY_TX_SET_ADDR) = (v))
#define HW_USBPHY_TX_CLR(v)    ((*(volatile reg32_t *) HW_USBPHY_TX_CLR_ADDR) = (v))
#define HW_USBPHY_TX_TOG(v)    ((*(volatile reg32_t *) HW_USBPHY_TX_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_USBPHY_TX bitfields
//

//--- Register HW_USBPHY_TX, field USBPHY_TX_EDGECTRL

#define BP_USBPHY_TX_USBPHY_TX_EDGECTRL      26
#define BM_USBPHY_TX_USBPHY_TX_EDGECTRL      0x1C000000

#define BF_USBPHY_TX_USBPHY_TX_EDGECTRL(v)   (((v) << 26) & BM_USBPHY_TX_USBPHY_TX_EDGECTRL)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_TX_USBPHY_TX_EDGECTRL(v)   BF_CS1(USBPHY_TX, USBPHY_TX_EDGECTRL, v)
#endif

//--- Register HW_USBPHY_TX, field USBPHY_TX_SYNC_INVERT

#define BP_USBPHY_TX_USBPHY_TX_SYNC_INVERT      25
#define BM_USBPHY_TX_USBPHY_TX_SYNC_INVERT      0x02000000

#define BF_USBPHY_TX_USBPHY_TX_SYNC_INVERT(v)   (((v) << 25) & BM_USBPHY_TX_USBPHY_TX_SYNC_INVERT)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_TX_USBPHY_TX_SYNC_INVERT(v)   BF_CS1(USBPHY_TX, USBPHY_TX_SYNC_INVERT, v)
#endif

//--- Register HW_USBPHY_TX, field USBPHY_TX_SYNC_MUX

#define BP_USBPHY_TX_USBPHY_TX_SYNC_MUX      24
#define BM_USBPHY_TX_USBPHY_TX_SYNC_MUX      0x01000000

#define BF_USBPHY_TX_USBPHY_TX_SYNC_MUX(v)   (((v) << 24) & BM_USBPHY_TX_USBPHY_TX_SYNC_MUX)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_TX_USBPHY_TX_SYNC_MUX(v)   BF_CS1(USBPHY_TX, USBPHY_TX_SYNC_MUX, v)
#endif

//--- Register HW_USBPHY_TX, field TXENCAL45DP

#define BP_USBPHY_TX_TXENCAL45DP      21
#define BM_USBPHY_TX_TXENCAL45DP      0x00200000

#define BF_USBPHY_TX_TXENCAL45DP(v)   (((v) << 21) & BM_USBPHY_TX_TXENCAL45DP)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_TX_TXENCAL45DP(v)   BF_CS1(USBPHY_TX, TXENCAL45DP, v)
#endif

//--- Register HW_USBPHY_TX, field TXCAL45DP

#define BP_USBPHY_TX_TXCAL45DP      16
#define BM_USBPHY_TX_TXCAL45DP      0x000F0000

#define BF_USBPHY_TX_TXCAL45DP(v)   (((v) << 16) & BM_USBPHY_TX_TXCAL45DP)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_TX_TXCAL45DP(v)   BF_CS1(USBPHY_TX, TXCAL45DP, v)
#endif

//--- Register HW_USBPHY_TX, field TXENCAL45DN

#define BP_USBPHY_TX_TXENCAL45DN      13
#define BM_USBPHY_TX_TXENCAL45DN      0x00002000

#define BF_USBPHY_TX_TXENCAL45DN(v)   (((v) << 13) & BM_USBPHY_TX_TXENCAL45DN)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_TX_TXENCAL45DN(v)   BF_CS1(USBPHY_TX, TXENCAL45DN, v)
#endif

//--- Register HW_USBPHY_TX, field TXCAL45DN

#define BP_USBPHY_TX_TXCAL45DN      8
#define BM_USBPHY_TX_TXCAL45DN      0x00000F00

#define BF_USBPHY_TX_TXCAL45DN(v)   (((v) << 8) & BM_USBPHY_TX_TXCAL45DN)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_TX_TXCAL45DN(v)   BF_CS1(USBPHY_TX, TXCAL45DN, v)
#endif

//--- Register HW_USBPHY_TX, field D_CAL

#define BP_USBPHY_TX_D_CAL      0
#define BM_USBPHY_TX_D_CAL      0x0000000F

#define BF_USBPHY_TX_D_CAL(v)   (((v) << 0) & BM_USBPHY_TX_D_CAL)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_TX_D_CAL(v)   BF_CS1(USBPHY_TX, D_CAL, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_USBPHY_RX - USB PHY Receiver Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ENVADJ     :  3;
        unsigned RSVD0      :  1;
        unsigned DISCONADJ  :  3;
        unsigned RSVD1      : 15;
        unsigned RXDBYPASS  :  1;
        unsigned RSVD2      :  9;
    } B;
} hw_usbphy_rx_t;
#endif


//
// constants & macros for entire HW_USBPHY_RX register
//

#define HW_USBPHY_RX_ADDR      (REGS_USBPHY_BASE + 0x00000020)
#define HW_USBPHY_RX_SET_ADDR  (REGS_USBPHY_BASE + 0x00000024)
#define HW_USBPHY_RX_CLR_ADDR  (REGS_USBPHY_BASE + 0x00000028)
#define HW_USBPHY_RX_TOG_ADDR  (REGS_USBPHY_BASE + 0x0000002C)

#ifndef __LANGUAGE_ASM__
#define HW_USBPHY_RX           (*(volatile hw_usbphy_rx_t *) HW_USBPHY_RX_ADDR)
#define HW_USBPHY_RX_RD()      (HW_USBPHY_RX.U)
#define HW_USBPHY_RX_WR(v)     (HW_USBPHY_RX.U = (v))
#define HW_USBPHY_RX_SET(v)    ((*(volatile reg32_t *) HW_USBPHY_RX_SET_ADDR) = (v))
#define HW_USBPHY_RX_CLR(v)    ((*(volatile reg32_t *) HW_USBPHY_RX_CLR_ADDR) = (v))
#define HW_USBPHY_RX_TOG(v)    ((*(volatile reg32_t *) HW_USBPHY_RX_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_USBPHY_RX bitfields
//

//--- Register HW_USBPHY_RX, field RXDBYPASS

#define BP_USBPHY_RX_RXDBYPASS      22
#define BM_USBPHY_RX_RXDBYPASS      0x00400000

#define BF_USBPHY_RX_RXDBYPASS(v)   (((v) << 22) & BM_USBPHY_RX_RXDBYPASS)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_RX_RXDBYPASS(v)   BF_CS1(USBPHY_RX, RXDBYPASS, v)
#endif

//--- Register HW_USBPHY_RX, field DISCONADJ

#define BP_USBPHY_RX_DISCONADJ      4
#define BM_USBPHY_RX_DISCONADJ      0x00000070

#define BF_USBPHY_RX_DISCONADJ(v)   (((v) << 4) & BM_USBPHY_RX_DISCONADJ)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_RX_DISCONADJ(v)   BF_CS1(USBPHY_RX, DISCONADJ, v)
#endif

//--- Register HW_USBPHY_RX, field ENVADJ

#define BP_USBPHY_RX_ENVADJ      0
#define BM_USBPHY_RX_ENVADJ      0x00000007

#define BF_USBPHY_RX_ENVADJ(v)   (((v) << 0) & BM_USBPHY_RX_ENVADJ)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_RX_ENVADJ(v)   BF_CS1(USBPHY_RX, ENVADJ, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_USBPHY_CTRL - USB PHY General Control Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSVD0                 :  1;
        unsigned ENHOSTDISCONDETECT    :  1;
        unsigned ENIRQHOSTDISCON       :  1;
        unsigned HOSTDISCONDETECT_IRQ  :  1;
        unsigned ENDEVPLUGINDETECT     :  1;
        unsigned DEVPLUGIN_POLARITY    :  1;
        unsigned RSVD1                 :  1;
        unsigned ENOTGIDDETECT         :  1;
        unsigned RSVD2                 :  1;
        unsigned ENIRQRESUMEDETECT     :  1;
        unsigned RESUME_IRQ            :  1;
        unsigned ENIRQDEVPLUGIN        :  1;
        unsigned DEVPLUGIN_IRQ         :  1;
        unsigned DATA_ON_LRADC         :  1;
        unsigned RSVD3                 : 14;
        unsigned HOST_FORCE_LS_SE0     :  1;
        unsigned UTMI_SUSPENDM         :  1;
        unsigned CLKGATE               :  1;
        unsigned SFTRST                :  1;
    } B;
} hw_usbphy_ctrl_t;
#endif


//
// constants & macros for entire HW_USBPHY_CTRL register
//

#define HW_USBPHY_CTRL_ADDR      (REGS_USBPHY_BASE + 0x00000030)
#define HW_USBPHY_CTRL_SET_ADDR  (REGS_USBPHY_BASE + 0x00000034)
#define HW_USBPHY_CTRL_CLR_ADDR  (REGS_USBPHY_BASE + 0x00000038)
#define HW_USBPHY_CTRL_TOG_ADDR  (REGS_USBPHY_BASE + 0x0000003C)

#ifndef __LANGUAGE_ASM__
#define HW_USBPHY_CTRL           (*(volatile hw_usbphy_ctrl_t *) HW_USBPHY_CTRL_ADDR)
#define HW_USBPHY_CTRL_RD()      (HW_USBPHY_CTRL.U)
#define HW_USBPHY_CTRL_WR(v)     (HW_USBPHY_CTRL.U = (v))
#define HW_USBPHY_CTRL_SET(v)    ((*(volatile reg32_t *) HW_USBPHY_CTRL_SET_ADDR) = (v))
#define HW_USBPHY_CTRL_CLR(v)    ((*(volatile reg32_t *) HW_USBPHY_CTRL_CLR_ADDR) = (v))
#define HW_USBPHY_CTRL_TOG(v)    ((*(volatile reg32_t *) HW_USBPHY_CTRL_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_USBPHY_CTRL bitfields
//

//--- Register HW_USBPHY_CTRL, field SFTRST

#define BP_USBPHY_CTRL_SFTRST      31
#define BM_USBPHY_CTRL_SFTRST      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_USBPHY_CTRL_SFTRST(v)   ((((reg32_t) v) << 31) & BM_USBPHY_CTRL_SFTRST)
#else
#define BF_USBPHY_CTRL_SFTRST(v)   (((v) << 31) & BM_USBPHY_CTRL_SFTRST)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_CTRL_SFTRST(v)   BF_CS1(USBPHY_CTRL, SFTRST, v)
#endif

//--- Register HW_USBPHY_CTRL, field CLKGATE

#define BP_USBPHY_CTRL_CLKGATE      30
#define BM_USBPHY_CTRL_CLKGATE      0x40000000

#define BF_USBPHY_CTRL_CLKGATE(v)   (((v) << 30) & BM_USBPHY_CTRL_CLKGATE)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_CTRL_CLKGATE(v)   BF_CS1(USBPHY_CTRL, CLKGATE, v)
#endif

//--- Register HW_USBPHY_CTRL, field UTMI_SUSPENDM

#define BP_USBPHY_CTRL_UTMI_SUSPENDM      29
#define BM_USBPHY_CTRL_UTMI_SUSPENDM      0x20000000

#define BF_USBPHY_CTRL_UTMI_SUSPENDM(v)   (((v) << 29) & BM_USBPHY_CTRL_UTMI_SUSPENDM)

//--- Register HW_USBPHY_CTRL, field HOST_FORCE_LS_SE0

#define BP_USBPHY_CTRL_HOST_FORCE_LS_SE0      28
#define BM_USBPHY_CTRL_HOST_FORCE_LS_SE0      0x10000000

#define BF_USBPHY_CTRL_HOST_FORCE_LS_SE0(v)   (((v) << 28) & BM_USBPHY_CTRL_HOST_FORCE_LS_SE0)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_CTRL_HOST_FORCE_LS_SE0(v)   BF_CS1(USBPHY_CTRL, HOST_FORCE_LS_SE0, v)
#endif

//--- Register HW_USBPHY_CTRL, field DATA_ON_LRADC

#define BP_USBPHY_CTRL_DATA_ON_LRADC      13
#define BM_USBPHY_CTRL_DATA_ON_LRADC      0x00002000

#define BF_USBPHY_CTRL_DATA_ON_LRADC(v)   (((v) << 13) & BM_USBPHY_CTRL_DATA_ON_LRADC)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_CTRL_DATA_ON_LRADC(v)   BF_CS1(USBPHY_CTRL, DATA_ON_LRADC, v)
#endif

//--- Register HW_USBPHY_CTRL, field DEVPLUGIN_IRQ

#define BP_USBPHY_CTRL_DEVPLUGIN_IRQ      12
#define BM_USBPHY_CTRL_DEVPLUGIN_IRQ      0x00001000

#define BF_USBPHY_CTRL_DEVPLUGIN_IRQ(v)   (((v) << 12) & BM_USBPHY_CTRL_DEVPLUGIN_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_CTRL_DEVPLUGIN_IRQ(v)   BF_CS1(USBPHY_CTRL, DEVPLUGIN_IRQ, v)
#endif

//--- Register HW_USBPHY_CTRL, field ENIRQDEVPLUGIN

#define BP_USBPHY_CTRL_ENIRQDEVPLUGIN      11
#define BM_USBPHY_CTRL_ENIRQDEVPLUGIN      0x00000800

#define BF_USBPHY_CTRL_ENIRQDEVPLUGIN(v)   (((v) << 11) & BM_USBPHY_CTRL_ENIRQDEVPLUGIN)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_CTRL_ENIRQDEVPLUGIN(v)   BF_CS1(USBPHY_CTRL, ENIRQDEVPLUGIN, v)
#endif

//--- Register HW_USBPHY_CTRL, field RESUME_IRQ

#define BP_USBPHY_CTRL_RESUME_IRQ      10
#define BM_USBPHY_CTRL_RESUME_IRQ      0x00000400

#define BF_USBPHY_CTRL_RESUME_IRQ(v)   (((v) << 10) & BM_USBPHY_CTRL_RESUME_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_CTRL_RESUME_IRQ(v)   BF_CS1(USBPHY_CTRL, RESUME_IRQ, v)
#endif

//--- Register HW_USBPHY_CTRL, field ENIRQRESUMEDETECT

#define BP_USBPHY_CTRL_ENIRQRESUMEDETECT      9
#define BM_USBPHY_CTRL_ENIRQRESUMEDETECT      0x00000200

#define BF_USBPHY_CTRL_ENIRQRESUMEDETECT(v)   (((v) << 9) & BM_USBPHY_CTRL_ENIRQRESUMEDETECT)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_CTRL_ENIRQRESUMEDETECT(v)   BF_CS1(USBPHY_CTRL, ENIRQRESUMEDETECT, v)
#endif

//--- Register HW_USBPHY_CTRL, field ENOTGIDDETECT

#define BP_USBPHY_CTRL_ENOTGIDDETECT      7
#define BM_USBPHY_CTRL_ENOTGIDDETECT      0x00000080

#define BF_USBPHY_CTRL_ENOTGIDDETECT(v)   (((v) << 7) & BM_USBPHY_CTRL_ENOTGIDDETECT)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_CTRL_ENOTGIDDETECT(v)   BF_CS1(USBPHY_CTRL, ENOTGIDDETECT, v)
#endif

//--- Register HW_USBPHY_CTRL, field DEVPLUGIN_POLARITY

#define BP_USBPHY_CTRL_DEVPLUGIN_POLARITY      5
#define BM_USBPHY_CTRL_DEVPLUGIN_POLARITY      0x00000020

#define BF_USBPHY_CTRL_DEVPLUGIN_POLARITY(v)   (((v) << 5) & BM_USBPHY_CTRL_DEVPLUGIN_POLARITY)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_CTRL_DEVPLUGIN_POLARITY(v)   BF_CS1(USBPHY_CTRL, DEVPLUGIN_POLARITY, v)
#endif

//--- Register HW_USBPHY_CTRL, field ENDEVPLUGINDETECT

#define BP_USBPHY_CTRL_ENDEVPLUGINDETECT      4
#define BM_USBPHY_CTRL_ENDEVPLUGINDETECT      0x00000010

#define BF_USBPHY_CTRL_ENDEVPLUGINDETECT(v)   (((v) << 4) & BM_USBPHY_CTRL_ENDEVPLUGINDETECT)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_CTRL_ENDEVPLUGINDETECT(v)   BF_CS1(USBPHY_CTRL, ENDEVPLUGINDETECT, v)
#endif

//--- Register HW_USBPHY_CTRL, field HOSTDISCONDETECT_IRQ

#define BP_USBPHY_CTRL_HOSTDISCONDETECT_IRQ      3
#define BM_USBPHY_CTRL_HOSTDISCONDETECT_IRQ      0x00000008

#define BF_USBPHY_CTRL_HOSTDISCONDETECT_IRQ(v)   (((v) << 3) & BM_USBPHY_CTRL_HOSTDISCONDETECT_IRQ)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_CTRL_HOSTDISCONDETECT_IRQ(v)   BF_CS1(USBPHY_CTRL, HOSTDISCONDETECT_IRQ, v)
#endif

//--- Register HW_USBPHY_CTRL, field ENIRQHOSTDISCON

#define BP_USBPHY_CTRL_ENIRQHOSTDISCON      2
#define BM_USBPHY_CTRL_ENIRQHOSTDISCON      0x00000004

#define BF_USBPHY_CTRL_ENIRQHOSTDISCON(v)   (((v) << 2) & BM_USBPHY_CTRL_ENIRQHOSTDISCON)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_CTRL_ENIRQHOSTDISCON(v)   BF_CS1(USBPHY_CTRL, ENIRQHOSTDISCON, v)
#endif

//--- Register HW_USBPHY_CTRL, field ENHOSTDISCONDETECT

#define BP_USBPHY_CTRL_ENHOSTDISCONDETECT      1
#define BM_USBPHY_CTRL_ENHOSTDISCONDETECT      0x00000002

#define BF_USBPHY_CTRL_ENHOSTDISCONDETECT(v)   (((v) << 1) & BM_USBPHY_CTRL_ENHOSTDISCONDETECT)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_CTRL_ENHOSTDISCONDETECT(v)   BF_CS1(USBPHY_CTRL, ENHOSTDISCONDETECT, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_USBPHY_STATUS - USB PHY Status Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSVD0                    :  3;
        unsigned HOSTDISCONDETECT_STATUS  :  1;
        unsigned RSVD1                    :  2;
        unsigned DEVPLUGIN_STATUS         :  1;
        unsigned RSVD2                    :  1;
        unsigned OTGID_STATUS             :  1;
        unsigned RSVD3                    :  1;
        unsigned RESUME_STATUS            :  1;
        unsigned RSVD4                    : 21;
    } B;
} hw_usbphy_status_t;
#endif


//
// constants & macros for entire HW_USBPHY_STATUS register
//

#define HW_USBPHY_STATUS_ADDR      (REGS_USBPHY_BASE + 0x00000040)

#ifndef __LANGUAGE_ASM__
#define HW_USBPHY_STATUS           (*(volatile hw_usbphy_status_t *) HW_USBPHY_STATUS_ADDR)
#define HW_USBPHY_STATUS_RD()      (HW_USBPHY_STATUS.U)
#define HW_USBPHY_STATUS_WR(v)     (HW_USBPHY_STATUS.U = (v))
#define HW_USBPHY_STATUS_SET(v)    (HW_USBPHY_STATUS_WR(HW_USBPHY_STATUS_RD() |  (v)))
#define HW_USBPHY_STATUS_CLR(v)    (HW_USBPHY_STATUS_WR(HW_USBPHY_STATUS_RD() & ~(v)))
#define HW_USBPHY_STATUS_TOG(v)    (HW_USBPHY_STATUS_WR(HW_USBPHY_STATUS_RD() ^  (v)))
#endif


//
// constants & macros for individual HW_USBPHY_STATUS bitfields
//

//--- Register HW_USBPHY_STATUS, field RESUME_STATUS

#define BP_USBPHY_STATUS_RESUME_STATUS      10
#define BM_USBPHY_STATUS_RESUME_STATUS      0x00000400

#define BF_USBPHY_STATUS_RESUME_STATUS(v)   (((v) << 10) & BM_USBPHY_STATUS_RESUME_STATUS)

//--- Register HW_USBPHY_STATUS, field OTGID_STATUS

#define BP_USBPHY_STATUS_OTGID_STATUS      8
#define BM_USBPHY_STATUS_OTGID_STATUS      0x00000100

#define BF_USBPHY_STATUS_OTGID_STATUS(v)   (((v) << 8) & BM_USBPHY_STATUS_OTGID_STATUS)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_STATUS_OTGID_STATUS(v)   BF_CS1(USBPHY_STATUS, OTGID_STATUS, v)
#endif

//--- Register HW_USBPHY_STATUS, field DEVPLUGIN_STATUS

#define BP_USBPHY_STATUS_DEVPLUGIN_STATUS      6
#define BM_USBPHY_STATUS_DEVPLUGIN_STATUS      0x00000040

#define BF_USBPHY_STATUS_DEVPLUGIN_STATUS(v)   (((v) << 6) & BM_USBPHY_STATUS_DEVPLUGIN_STATUS)

//--- Register HW_USBPHY_STATUS, field HOSTDISCONDETECT_STATUS

#define BP_USBPHY_STATUS_HOSTDISCONDETECT_STATUS      3
#define BM_USBPHY_STATUS_HOSTDISCONDETECT_STATUS      0x00000008

#define BF_USBPHY_STATUS_HOSTDISCONDETECT_STATUS(v)   (((v) << 3) & BM_USBPHY_STATUS_HOSTDISCONDETECT_STATUS)


////////////////////////////////////////////////////////////////////////////////
//// HW_USBPHY_DEBUG - USB PHY Debug Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned OTGIDPIOLOCK          :  1;
        unsigned DEBUG_INTERFACE_HOLD  :  1;
        unsigned HSTPULLDOWN           :  2;
        unsigned ENHSTPULLDOWN         :  2;
        unsigned RSVD0                 :  2;
        unsigned TX2RXCOUNT            :  4;
        unsigned ENTX2RXCOUNT          :  1;
        unsigned RSVD1                 :  3;
        unsigned SQUELCHRESETCOUNT     :  5;
        unsigned RSVD2                 :  3;
        unsigned ENSQUELCHRESET        :  1;
        unsigned SQUELCHRESETLENGTH    :  4;
        unsigned HOST_RESUME_DEBUG     :  1;
        unsigned CLKGATE               :  1;
        unsigned RSVD3                 :  1;
    } B;
} hw_usbphy_debug_t;
#endif


//
// constants & macros for entire HW_USBPHY_DEBUG register
//

#define HW_USBPHY_DEBUG_ADDR      (REGS_USBPHY_BASE + 0x00000050)
#define HW_USBPHY_DEBUG_SET_ADDR  (REGS_USBPHY_BASE + 0x00000054)
#define HW_USBPHY_DEBUG_CLR_ADDR  (REGS_USBPHY_BASE + 0x00000058)
#define HW_USBPHY_DEBUG_TOG_ADDR  (REGS_USBPHY_BASE + 0x0000005C)

#ifndef __LANGUAGE_ASM__
#define HW_USBPHY_DEBUG           (*(volatile hw_usbphy_debug_t *) HW_USBPHY_DEBUG_ADDR)
#define HW_USBPHY_DEBUG_RD()      (HW_USBPHY_DEBUG.U)
#define HW_USBPHY_DEBUG_WR(v)     (HW_USBPHY_DEBUG.U = (v))
#define HW_USBPHY_DEBUG_SET(v)    ((*(volatile reg32_t *) HW_USBPHY_DEBUG_SET_ADDR) = (v))
#define HW_USBPHY_DEBUG_CLR(v)    ((*(volatile reg32_t *) HW_USBPHY_DEBUG_CLR_ADDR) = (v))
#define HW_USBPHY_DEBUG_TOG(v)    ((*(volatile reg32_t *) HW_USBPHY_DEBUG_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_USBPHY_DEBUG bitfields
//

//--- Register HW_USBPHY_DEBUG, field CLKGATE

#define BP_USBPHY_DEBUG_CLKGATE      30
#define BM_USBPHY_DEBUG_CLKGATE      0x40000000

#define BF_USBPHY_DEBUG_CLKGATE(v)   (((v) << 30) & BM_USBPHY_DEBUG_CLKGATE)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_DEBUG_CLKGATE(v)   BF_CS1(USBPHY_DEBUG, CLKGATE, v)
#endif

//--- Register HW_USBPHY_DEBUG, field HOST_RESUME_DEBUG

#define BP_USBPHY_DEBUG_HOST_RESUME_DEBUG      29
#define BM_USBPHY_DEBUG_HOST_RESUME_DEBUG      0x20000000

#define BF_USBPHY_DEBUG_HOST_RESUME_DEBUG(v)   (((v) << 29) & BM_USBPHY_DEBUG_HOST_RESUME_DEBUG)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_DEBUG_HOST_RESUME_DEBUG(v)   BF_CS1(USBPHY_DEBUG, HOST_RESUME_DEBUG, v)
#endif

//--- Register HW_USBPHY_DEBUG, field SQUELCHRESETLENGTH

#define BP_USBPHY_DEBUG_SQUELCHRESETLENGTH      25
#define BM_USBPHY_DEBUG_SQUELCHRESETLENGTH      0x1E000000

#define BF_USBPHY_DEBUG_SQUELCHRESETLENGTH(v)   (((v) << 25) & BM_USBPHY_DEBUG_SQUELCHRESETLENGTH)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_DEBUG_SQUELCHRESETLENGTH(v)   BF_CS1(USBPHY_DEBUG, SQUELCHRESETLENGTH, v)
#endif

//--- Register HW_USBPHY_DEBUG, field ENSQUELCHRESET

#define BP_USBPHY_DEBUG_ENSQUELCHRESET      24
#define BM_USBPHY_DEBUG_ENSQUELCHRESET      0x01000000

#define BF_USBPHY_DEBUG_ENSQUELCHRESET(v)   (((v) << 24) & BM_USBPHY_DEBUG_ENSQUELCHRESET)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_DEBUG_ENSQUELCHRESET(v)   BF_CS1(USBPHY_DEBUG, ENSQUELCHRESET, v)
#endif

//--- Register HW_USBPHY_DEBUG, field SQUELCHRESETCOUNT

#define BP_USBPHY_DEBUG_SQUELCHRESETCOUNT      16
#define BM_USBPHY_DEBUG_SQUELCHRESETCOUNT      0x001F0000

#define BF_USBPHY_DEBUG_SQUELCHRESETCOUNT(v)   (((v) << 16) & BM_USBPHY_DEBUG_SQUELCHRESETCOUNT)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_DEBUG_SQUELCHRESETCOUNT(v)   BF_CS1(USBPHY_DEBUG, SQUELCHRESETCOUNT, v)
#endif

//--- Register HW_USBPHY_DEBUG, field ENTX2RXCOUNT

#define BP_USBPHY_DEBUG_ENTX2RXCOUNT      12
#define BM_USBPHY_DEBUG_ENTX2RXCOUNT      0x00001000

#define BF_USBPHY_DEBUG_ENTX2RXCOUNT(v)   (((v) << 12) & BM_USBPHY_DEBUG_ENTX2RXCOUNT)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_DEBUG_ENTX2RXCOUNT(v)   BF_CS1(USBPHY_DEBUG, ENTX2RXCOUNT, v)
#endif

//--- Register HW_USBPHY_DEBUG, field TX2RXCOUNT

#define BP_USBPHY_DEBUG_TX2RXCOUNT      8
#define BM_USBPHY_DEBUG_TX2RXCOUNT      0x00000F00

#define BF_USBPHY_DEBUG_TX2RXCOUNT(v)   (((v) << 8) & BM_USBPHY_DEBUG_TX2RXCOUNT)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_DEBUG_TX2RXCOUNT(v)   BF_CS1(USBPHY_DEBUG, TX2RXCOUNT, v)
#endif

//--- Register HW_USBPHY_DEBUG, field ENHSTPULLDOWN

#define BP_USBPHY_DEBUG_ENHSTPULLDOWN      4
#define BM_USBPHY_DEBUG_ENHSTPULLDOWN      0x00000030

#define BF_USBPHY_DEBUG_ENHSTPULLDOWN(v)   (((v) << 4) & BM_USBPHY_DEBUG_ENHSTPULLDOWN)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_DEBUG_ENHSTPULLDOWN(v)   BF_CS1(USBPHY_DEBUG, ENHSTPULLDOWN, v)
#endif

//--- Register HW_USBPHY_DEBUG, field HSTPULLDOWN

#define BP_USBPHY_DEBUG_HSTPULLDOWN      2
#define BM_USBPHY_DEBUG_HSTPULLDOWN      0x0000000C

#define BF_USBPHY_DEBUG_HSTPULLDOWN(v)   (((v) << 2) & BM_USBPHY_DEBUG_HSTPULLDOWN)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_DEBUG_HSTPULLDOWN(v)   BF_CS1(USBPHY_DEBUG, HSTPULLDOWN, v)
#endif

//--- Register HW_USBPHY_DEBUG, field DEBUG_INTERFACE_HOLD

#define BP_USBPHY_DEBUG_DEBUG_INTERFACE_HOLD      1
#define BM_USBPHY_DEBUG_DEBUG_INTERFACE_HOLD      0x00000002

#define BF_USBPHY_DEBUG_DEBUG_INTERFACE_HOLD(v)   (((v) << 1) & BM_USBPHY_DEBUG_DEBUG_INTERFACE_HOLD)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_DEBUG_DEBUG_INTERFACE_HOLD(v)   BF_CS1(USBPHY_DEBUG, DEBUG_INTERFACE_HOLD, v)
#endif

//--- Register HW_USBPHY_DEBUG, field OTGIDPIOLOCK

#define BP_USBPHY_DEBUG_OTGIDPIOLOCK      0
#define BM_USBPHY_DEBUG_OTGIDPIOLOCK      0x00000001

#define BF_USBPHY_DEBUG_OTGIDPIOLOCK(v)   (((v) << 0) & BM_USBPHY_DEBUG_OTGIDPIOLOCK)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_DEBUG_OTGIDPIOLOCK(v)   BF_CS1(USBPHY_DEBUG, OTGIDPIOLOCK, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_USBPHY_DEBUG0_STATUS - UTMI Debug Status Register 0
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg16_t  LOOP_BACK_FAIL_COUNT;
        unsigned UTMI_RXERROR_FAIL_COUNT  : 10;
        unsigned SQUELCH_COUNT            :  6;
    } B;
} hw_usbphy_debug0_status_t;
#endif


//
// constants & macros for entire HW_USBPHY_DEBUG0_STATUS register
//

#define HW_USBPHY_DEBUG0_STATUS_ADDR      (REGS_USBPHY_BASE + 0x00000060)

#ifndef __LANGUAGE_ASM__
#define HW_USBPHY_DEBUG0_STATUS           (*(volatile hw_usbphy_debug0_status_t *) HW_USBPHY_DEBUG0_STATUS_ADDR)
#define HW_USBPHY_DEBUG0_STATUS_RD()      (HW_USBPHY_DEBUG0_STATUS.U)
#endif


//
// constants & macros for individual HW_USBPHY_DEBUG0_STATUS bitfields
//

//--- Register HW_USBPHY_DEBUG0_STATUS, field SQUELCH_COUNT

#define BP_USBPHY_DEBUG0_STATUS_SQUELCH_COUNT      26
#define BM_USBPHY_DEBUG0_STATUS_SQUELCH_COUNT      0xFC000000

#ifndef __LANGUAGE_ASM__
#define BF_USBPHY_DEBUG0_STATUS_SQUELCH_COUNT(v)   ((((reg32_t) v) << 26) & BM_USBPHY_DEBUG0_STATUS_SQUELCH_COUNT)
#else
#define BF_USBPHY_DEBUG0_STATUS_SQUELCH_COUNT(v)   (((v) << 26) & BM_USBPHY_DEBUG0_STATUS_SQUELCH_COUNT)
#endif

//--- Register HW_USBPHY_DEBUG0_STATUS, field UTMI_RXERROR_FAIL_COUNT

#define BP_USBPHY_DEBUG0_STATUS_UTMI_RXERROR_FAIL_COUNT      16
#define BM_USBPHY_DEBUG0_STATUS_UTMI_RXERROR_FAIL_COUNT      0x03FF0000

#define BF_USBPHY_DEBUG0_STATUS_UTMI_RXERROR_FAIL_COUNT(v)   (((v) << 16) & BM_USBPHY_DEBUG0_STATUS_UTMI_RXERROR_FAIL_COUNT)

//--- Register HW_USBPHY_DEBUG0_STATUS, field LOOP_BACK_FAIL_COUNT

#define BP_USBPHY_DEBUG0_STATUS_LOOP_BACK_FAIL_COUNT      0
#define BM_USBPHY_DEBUG0_STATUS_LOOP_BACK_FAIL_COUNT      0x0000FFFF

#define BF_USBPHY_DEBUG0_STATUS_LOOP_BACK_FAIL_COUNT(v)   (((v) << 0) & BM_USBPHY_DEBUG0_STATUS_LOOP_BACK_FAIL_COUNT)


////////////////////////////////////////////////////////////////////////////////
//// HW_USBPHY_DEBUG1 - UTMI Debug Status Register 1
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DBG_ADDRESS  :  4;
        unsigned RSVD0        :  8;
        unsigned ENTX2TX      :  1;
        unsigned ENTAILADJVD  :  2;
        unsigned RSVD1        : 17;
    } B;
} hw_usbphy_debug1_t;
#endif


//
// constants & macros for entire HW_USBPHY_DEBUG1 register
//

#define HW_USBPHY_DEBUG1_ADDR      (REGS_USBPHY_BASE + 0x00000070)
#define HW_USBPHY_DEBUG1_SET_ADDR  (REGS_USBPHY_BASE + 0x00000074)
#define HW_USBPHY_DEBUG1_CLR_ADDR  (REGS_USBPHY_BASE + 0x00000078)
#define HW_USBPHY_DEBUG1_TOG_ADDR  (REGS_USBPHY_BASE + 0x0000007C)

#ifndef __LANGUAGE_ASM__
#define HW_USBPHY_DEBUG1           (*(volatile hw_usbphy_debug1_t *) HW_USBPHY_DEBUG1_ADDR)
#define HW_USBPHY_DEBUG1_RD()      (HW_USBPHY_DEBUG1.U)
#define HW_USBPHY_DEBUG1_WR(v)     (HW_USBPHY_DEBUG1.U = (v))
#define HW_USBPHY_DEBUG1_SET(v)    ((*(volatile reg32_t *) HW_USBPHY_DEBUG1_SET_ADDR) = (v))
#define HW_USBPHY_DEBUG1_CLR(v)    ((*(volatile reg32_t *) HW_USBPHY_DEBUG1_CLR_ADDR) = (v))
#define HW_USBPHY_DEBUG1_TOG(v)    ((*(volatile reg32_t *) HW_USBPHY_DEBUG1_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_USBPHY_DEBUG1 bitfields
//

//--- Register HW_USBPHY_DEBUG1, field ENTAILADJVD

#define BP_USBPHY_DEBUG1_ENTAILADJVD      13
#define BM_USBPHY_DEBUG1_ENTAILADJVD      0x00006000

#define BF_USBPHY_DEBUG1_ENTAILADJVD(v)   (((v) << 13) & BM_USBPHY_DEBUG1_ENTAILADJVD)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_DEBUG1_ENTAILADJVD(v)   BF_CS1(USBPHY_DEBUG1, ENTAILADJVD, v)
#endif

//--- Register HW_USBPHY_DEBUG1, field ENTX2TX

#define BP_USBPHY_DEBUG1_ENTX2TX      12
#define BM_USBPHY_DEBUG1_ENTX2TX      0x00001000

#define BF_USBPHY_DEBUG1_ENTX2TX(v)   (((v) << 12) & BM_USBPHY_DEBUG1_ENTX2TX)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_DEBUG1_ENTX2TX(v)   BF_CS1(USBPHY_DEBUG1, ENTX2TX, v)
#endif

//--- Register HW_USBPHY_DEBUG1, field DBG_ADDRESS

#define BP_USBPHY_DEBUG1_DBG_ADDRESS      0
#define BM_USBPHY_DEBUG1_DBG_ADDRESS      0x0000000F

#define BF_USBPHY_DEBUG1_DBG_ADDRESS(v)   (((v) << 0) & BM_USBPHY_DEBUG1_DBG_ADDRESS)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_DEBUG1_DBG_ADDRESS(v)   BF_CS1(USBPHY_DEBUG1, DBG_ADDRESS, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_USBPHY_VERSION - UTMI RTL Version
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg16_t  STEP;
        reg8_t   MINOR;
        reg8_t   MAJOR;
    } B;
} hw_usbphy_version_t;
#endif


//
// constants & macros for entire HW_USBPHY_VERSION register
//

#define HW_USBPHY_VERSION_ADDR      (REGS_USBPHY_BASE + 0x00000080)

#ifndef __LANGUAGE_ASM__
#define HW_USBPHY_VERSION           (*(volatile hw_usbphy_version_t *) HW_USBPHY_VERSION_ADDR)
#define HW_USBPHY_VERSION_RD()      (HW_USBPHY_VERSION.U)
#endif


//
// constants & macros for individual HW_USBPHY_VERSION bitfields
//

//--- Register HW_USBPHY_VERSION, field MAJOR

#define BP_USBPHY_VERSION_MAJOR      24
#define BM_USBPHY_VERSION_MAJOR      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_USBPHY_VERSION_MAJOR(v)   ((((reg32_t) v) << 24) & BM_USBPHY_VERSION_MAJOR)
#else
#define BF_USBPHY_VERSION_MAJOR(v)   (((v) << 24) & BM_USBPHY_VERSION_MAJOR)
#endif

//--- Register HW_USBPHY_VERSION, field MINOR

#define BP_USBPHY_VERSION_MINOR      16
#define BM_USBPHY_VERSION_MINOR      0x00FF0000

#define BF_USBPHY_VERSION_MINOR(v)   (((v) << 16) & BM_USBPHY_VERSION_MINOR)

//--- Register HW_USBPHY_VERSION, field STEP

#define BP_USBPHY_VERSION_STEP      0
#define BM_USBPHY_VERSION_STEP      0x0000FFFF

#define BF_USBPHY_VERSION_STEP(v)   (((v) << 0) & BM_USBPHY_VERSION_STEP)


////////////////////////////////////////////////////////////////////////////////
//// HW_USBPHY_IP - USB PHY IP Block Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PLL_POWER        :  1;
        unsigned PLL_LOCKED       :  1;
        unsigned EN_USB_CLKS      :  1;
        unsigned RSVD0            : 13;
        unsigned ANALOG_TESTMODE  :  1;
        unsigned TSTI_TX_DM       :  1;
        unsigned TSTI_TX_DP       :  1;
        unsigned CP_SEL           :  2;
        unsigned LFR_SEL          :  2;
        unsigned DIV_SEL          :  2;
        unsigned RSVD1            :  7;
    } B;
} hw_usbphy_ip_t;
#endif


//
// constants & macros for entire HW_USBPHY_IP register
//

#define HW_USBPHY_IP_ADDR      (REGS_USBPHY_BASE + 0x00000090)
#define HW_USBPHY_IP_SET_ADDR  (REGS_USBPHY_BASE + 0x00000094)
#define HW_USBPHY_IP_CLR_ADDR  (REGS_USBPHY_BASE + 0x00000098)
#define HW_USBPHY_IP_TOG_ADDR  (REGS_USBPHY_BASE + 0x0000009C)

#ifndef __LANGUAGE_ASM__
#define HW_USBPHY_IP           (*(volatile hw_usbphy_ip_t *) HW_USBPHY_IP_ADDR)
#define HW_USBPHY_IP_RD()      (HW_USBPHY_IP.U)
#define HW_USBPHY_IP_WR(v)     (HW_USBPHY_IP.U = (v))
#define HW_USBPHY_IP_SET(v)    ((*(volatile reg32_t *) HW_USBPHY_IP_SET_ADDR) = (v))
#define HW_USBPHY_IP_CLR(v)    ((*(volatile reg32_t *) HW_USBPHY_IP_CLR_ADDR) = (v))
#define HW_USBPHY_IP_TOG(v)    ((*(volatile reg32_t *) HW_USBPHY_IP_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_USBPHY_IP bitfields
//

//--- Register HW_USBPHY_IP, field DIV_SEL

#define BP_USBPHY_IP_DIV_SEL      23
#define BM_USBPHY_IP_DIV_SEL      0x01800000

#define BF_USBPHY_IP_DIV_SEL(v)   (((v) << 23) & BM_USBPHY_IP_DIV_SEL)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_IP_DIV_SEL(v)   BF_CS1(USBPHY_IP, DIV_SEL, v)
#endif

#define BV_USBPHY_IP_DIV_SEL__DEFAULT    0x0
#define BV_USBPHY_IP_DIV_SEL__LOWER      0x1
#define BV_USBPHY_IP_DIV_SEL__LOWEST     0x2
#define BV_USBPHY_IP_DIV_SEL__UNDEFINED  0x3

//--- Register HW_USBPHY_IP, field LFR_SEL

#define BP_USBPHY_IP_LFR_SEL      21
#define BM_USBPHY_IP_LFR_SEL      0x00600000

#define BF_USBPHY_IP_LFR_SEL(v)   (((v) << 21) & BM_USBPHY_IP_LFR_SEL)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_IP_LFR_SEL(v)   BF_CS1(USBPHY_IP, LFR_SEL, v)
#endif

#define BV_USBPHY_IP_LFR_SEL__DEFAULT    0x0
#define BV_USBPHY_IP_LFR_SEL__TIMES_2    0x1
#define BV_USBPHY_IP_LFR_SEL__TIMES_05   0x2
#define BV_USBPHY_IP_LFR_SEL__UNDEFINED  0x3

//--- Register HW_USBPHY_IP, field CP_SEL

#define BP_USBPHY_IP_CP_SEL      19
#define BM_USBPHY_IP_CP_SEL      0x00180000

#define BF_USBPHY_IP_CP_SEL(v)   (((v) << 19) & BM_USBPHY_IP_CP_SEL)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_IP_CP_SEL(v)   BF_CS1(USBPHY_IP, CP_SEL, v)
#endif

#define BV_USBPHY_IP_CP_SEL__DEFAULT    0x0
#define BV_USBPHY_IP_CP_SEL__TIMES_2    0x1
#define BV_USBPHY_IP_CP_SEL__TIMES_05   0x2
#define BV_USBPHY_IP_CP_SEL__UNDEFINED  0x3

//--- Register HW_USBPHY_IP, field TSTI_TX_DP

#define BP_USBPHY_IP_TSTI_TX_DP      18
#define BM_USBPHY_IP_TSTI_TX_DP      0x00040000

#define BF_USBPHY_IP_TSTI_TX_DP(v)   (((v) << 18) & BM_USBPHY_IP_TSTI_TX_DP)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_IP_TSTI_TX_DP(v)   BF_CS1(USBPHY_IP, TSTI_TX_DP, v)
#endif

//--- Register HW_USBPHY_IP, field TSTI_TX_DM

#define BP_USBPHY_IP_TSTI_TX_DM      17
#define BM_USBPHY_IP_TSTI_TX_DM      0x00020000

#define BF_USBPHY_IP_TSTI_TX_DM(v)   (((v) << 17) & BM_USBPHY_IP_TSTI_TX_DM)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_IP_TSTI_TX_DM(v)   BF_CS1(USBPHY_IP, TSTI_TX_DM, v)
#endif

//--- Register HW_USBPHY_IP, field ANALOG_TESTMODE

#define BP_USBPHY_IP_ANALOG_TESTMODE      16
#define BM_USBPHY_IP_ANALOG_TESTMODE      0x00010000

#define BF_USBPHY_IP_ANALOG_TESTMODE(v)   (((v) << 16) & BM_USBPHY_IP_ANALOG_TESTMODE)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_IP_ANALOG_TESTMODE(v)   BF_CS1(USBPHY_IP, ANALOG_TESTMODE, v)
#endif

//--- Register HW_USBPHY_IP, field EN_USB_CLKS

#define BP_USBPHY_IP_EN_USB_CLKS      2
#define BM_USBPHY_IP_EN_USB_CLKS      0x00000004

#define BF_USBPHY_IP_EN_USB_CLKS(v)   (((v) << 2) & BM_USBPHY_IP_EN_USB_CLKS)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_IP_EN_USB_CLKS(v)   BF_CS1(USBPHY_IP, EN_USB_CLKS, v)
#endif

//--- Register HW_USBPHY_IP, field PLL_LOCKED

#define BP_USBPHY_IP_PLL_LOCKED      1
#define BM_USBPHY_IP_PLL_LOCKED      0x00000002

#define BF_USBPHY_IP_PLL_LOCKED(v)   (((v) << 1) & BM_USBPHY_IP_PLL_LOCKED)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_IP_PLL_LOCKED(v)   BF_CS1(USBPHY_IP, PLL_LOCKED, v)
#endif

//--- Register HW_USBPHY_IP, field PLL_POWER

#define BP_USBPHY_IP_PLL_POWER      0
#define BM_USBPHY_IP_PLL_POWER      0x00000001

#define BF_USBPHY_IP_PLL_POWER(v)   (((v) << 0) & BM_USBPHY_IP_PLL_POWER)

#ifndef __LANGUAGE_ASM__
#define BW_USBPHY_IP_PLL_POWER(v)   BF_CS1(USBPHY_IP, PLL_POWER, v)
#endif


#endif // _REGSUSBPHY_H

////////////////////////////////////////////////////////////////////////////////
