/*
 * Copyright 2008-2009 Freescale Semiconductor, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

 * WARNING!  THIS FILE IS AUTOMATICALLY GENERATED FROM XML.
 *                DO NOT MODIFY THIS FILE DIRECTLY.
 *
 * Xml Revision: 1.54
 *
 * Template revision: 26195
 *
 *
 * The following naming conventions are followed in this file.
 *      XX_<module>_<regname>_<field>
 *
 * XX specifies the define / macro class
 *      HW pertains to a register
 *      BM indicates a Bit Mask
 *      BF indicates a Bit Field macro
 *
 * <module> is the hardware module name which can be any of the following...
 *      USB20 (Note when there is more than one copy of a given module, the
 *      module name includes a number starting from 0 for the first instance
 *      of that module)
 *
 * <regname> is the specific register within that module
 *
 * <field> is the specific bitfield within that <module>_<register>
 *
 * We also define the following...
 *      hw_<module>_<regname>_t is typedef of anonymous union
 *
 */

#ifndef _I2C_H
#define _I2C_H  1

#include "regs.h"

#ifndef REGS_I2C_BASE
#define REGS_I2C0_BASE (REGS_BASE + 0x58000)
#define REGS_I2C1_BASE (REGS_BASE + 0x5a000)
#define REGS_I2C_BASE(x) ( x == 0 ? REGS_I2C0_BASE : x == 1 ? REGS_I2C1_BASE : 0xffff0000)
#endif

/*
 * HW_I2C_CTRL0 - I2C Control Register 0
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned XFER_COUNT            : 16;
        unsigned DIRECTION             :  1;
        unsigned MASTER_MODE           :  1;
        unsigned SLAVE_ADDRESS_ENABLE  :  1;
        unsigned PRE_SEND_START        :  1;
        unsigned POST_SEND_STOP        :  1;
        unsigned RETAIN_CLOCK          :  1;
        unsigned CLOCK_HELD            :  1;
        unsigned MULTI_MASTER          :  1;
        unsigned RSVD1                 :  1;
        unsigned SEND_NAK_ON_LAST      :  1;
        unsigned ACKNOWLEDGE           :  1;
        unsigned PRE_ACK               :  1;
        unsigned RSVD2                 :  1;
        unsigned RUN                   :  1;
        unsigned CLKGATE               :  1;
        unsigned SFTRST                :  1;
    } B;
} hw_i2c_ctrl0_t;
#endif

/*
 * constants & macros for entire multi-block HW_I2C_CTRL0 register
 */
#define HW_I2C_CTRL0_ADDR(x)      (REGS_I2C_BASE(x) + 0x0)
#define HW_I2C_CTRL0_SET_ADDR(x)  (HW_I2C_CTRL0_ADDR(x) + 4)
#define HW_I2C_CTRL0_CLR_ADDR(x)  (HW_I2C_CTRL0_ADDR(x) + 8)
#define HW_I2C_CTRL0_TOG_ADDR(x)  (HW_I2C_CTRL0_ADDR(x) + 12)

#ifndef __LANGUAGE_ASM__
#define HW_I2C_CTRL0(x)           (*(volatile hw_i2c_ctrl0_t *) HW_I2C_CTRL0_ADDR(x))
#define HW_I2C_CTRL0_RD(x)      (HW_I2C_CTRL0(x).U)
#define HW_I2C_CTRL0_WR(x, v)     (HW_I2C_CTRL0(x).U = (v))
#define HW_I2C_CTRL0_SET(x, v)    ((*(volatile reg32_t *) HW_I2C_CTRL0_SET_ADDR(x)) = (v))
#define HW_I2C_CTRL0_CLR(x, v)    ((*(volatile reg32_t *) HW_I2C_CTRL0_CLR_ADDR(x)) = (v))
#define HW_I2C_CTRL0_TOG(x, v)    ((*(volatile reg32_t *) HW_I2C_CTRL0_TOG_ADDR(x)) = (v))
#endif


/*
 * constants & macros for individual HW_I2C_CTRL0 bitfields
 */
/* --- Register HW_I2C_CTRL0, field SFTRST */

#define BP_I2C_CTRL0_SFTRST      31
#define BM_I2C_CTRL0_SFTRST      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_I2C_CTRL0_SFTRST(v)   ((((reg32_t) v) << 31) & BM_I2C_CTRL0_SFTRST)
#else
#define BF_I2C_CTRL0_SFTRST(v)   (((v) << 31) & BM_I2C_CTRL0_SFTRST)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_I2C_CTRL0_SFTRST(n, v)   BFn_CS1(I2C_CTRL0, n, SFTRST, v)
#endif

#define BV_I2C_CTRL0_SFTRST__RUN    0x0
#define BV_I2C_CTRL0_SFTRST__RESET  0x1

/* --- Register HW_I2C_CTRL0, field CLKGATE */

#define BP_I2C_CTRL0_CLKGATE      30
#define BM_I2C_CTRL0_CLKGATE      0x40000000

#define BF_I2C_CTRL0_CLKGATE(v)   (((v) << 30) & BM_I2C_CTRL0_CLKGATE)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_CTRL0_CLKGATE(n, v)   BFn_CS1(I2C_CTRL0, n, CLKGATE, v)
#endif

#define BV_I2C_CTRL0_CLKGATE__RUN      0x0
#define BV_I2C_CTRL0_CLKGATE__NO_CLKS  0x1

/* --- Register HW_I2C_CTRL0, field RUN */

#define BP_I2C_CTRL0_RUN      29
#define BM_I2C_CTRL0_RUN      0x20000000

#define BF_I2C_CTRL0_RUN(v)   (((v) << 29) & BM_I2C_CTRL0_RUN)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_CTRL0_RUN(n, v)   BFn_CS1(I2C_CTRL0, n, RUN, v)
#endif

#define BV_I2C_CTRL0_RUN__HALT  0x0
#define BV_I2C_CTRL0_RUN__RUN   0x1

/* --- Register HW_I2C_CTRL0, field RSVD2 */

#define BP_I2C_CTRL0_RSVD2      28
#define BM_I2C_CTRL0_RSVD2      0x10000000

#define BF_I2C_CTRL0_RSVD2(v)   (((v) << 28) & BM_I2C_CTRL0_RSVD2)
/* --- Register HW_I2C_CTRL0, field PRE_ACK */

#define BP_I2C_CTRL0_PRE_ACK      27
#define BM_I2C_CTRL0_PRE_ACK      0x08000000

#define BF_I2C_CTRL0_PRE_ACK(v)   (((v) << 27) & BM_I2C_CTRL0_PRE_ACK)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_CTRL0_PRE_ACK(n, v)   BFn_CS1(I2C_CTRL0, n, PRE_ACK, v)
#endif

/* --- Register HW_I2C_CTRL0, field ACKNOWLEDGE */

#define BP_I2C_CTRL0_ACKNOWLEDGE      26
#define BM_I2C_CTRL0_ACKNOWLEDGE      0x04000000

#define BF_I2C_CTRL0_ACKNOWLEDGE(v)   (((v) << 26) & BM_I2C_CTRL0_ACKNOWLEDGE)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_CTRL0_ACKNOWLEDGE(n, v)   BFn_CS1(I2C_CTRL0, n, ACKNOWLEDGE, v)
#endif

#define BV_I2C_CTRL0_ACKNOWLEDGE__SNAK  0x0
#define BV_I2C_CTRL0_ACKNOWLEDGE__ACK   0x1

/* --- Register HW_I2C_CTRL0, field SEND_NAK_ON_LAST */

#define BP_I2C_CTRL0_SEND_NAK_ON_LAST      25
#define BM_I2C_CTRL0_SEND_NAK_ON_LAST      0x02000000

#define BF_I2C_CTRL0_SEND_NAK_ON_LAST(v)   (((v) << 25) & BM_I2C_CTRL0_SEND_NAK_ON_LAST)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_CTRL0_SEND_NAK_ON_LAST(n, v)   BFn_CS1(I2C_CTRL0, n, SEND_NAK_ON_LAST, v)
#endif

#define BV_I2C_CTRL0_SEND_NAK_ON_LAST__ACK_IT  0x0
#define BV_I2C_CTRL0_SEND_NAK_ON_LAST__NAK_IT  0x1

/* --- Register HW_I2C_CTRL0, field RSVD1 */

#define BP_I2C_CTRL0_RSVD1      24
#define BM_I2C_CTRL0_RSVD1      0x01000000

#define BF_I2C_CTRL0_RSVD1(v)   (((v) << 24) & BM_I2C_CTRL0_RSVD1)
/* --- Register HW_I2C_CTRL0, field MULTI_MASTER */

#define BP_I2C_CTRL0_MULTI_MASTER      23
#define BM_I2C_CTRL0_MULTI_MASTER      0x00800000

#define BF_I2C_CTRL0_MULTI_MASTER(v)   (((v) << 23) & BM_I2C_CTRL0_MULTI_MASTER)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_CTRL0_MULTI_MASTER(n, v)   BFn_CS1(I2C_CTRL0, n, MULTI_MASTER, v)
#endif

#define BV_I2C_CTRL0_MULTI_MASTER__SINGLE    0x0
#define BV_I2C_CTRL0_MULTI_MASTER__MULTIPLE  0x1

/* --- Register HW_I2C_CTRL0, field CLOCK_HELD */

#define BP_I2C_CTRL0_CLOCK_HELD      22
#define BM_I2C_CTRL0_CLOCK_HELD      0x00400000

#define BF_I2C_CTRL0_CLOCK_HELD(v)   (((v) << 22) & BM_I2C_CTRL0_CLOCK_HELD)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_CTRL0_CLOCK_HELD(n, v)   BFn_CS1(I2C_CTRL0, n, CLOCK_HELD, v)
#endif

#define BV_I2C_CTRL0_CLOCK_HELD__RELEASE   0x0
#define BV_I2C_CTRL0_CLOCK_HELD__HELD_LOW  0x1

/* --- Register HW_I2C_CTRL0, field RETAIN_CLOCK */

#define BP_I2C_CTRL0_RETAIN_CLOCK      21
#define BM_I2C_CTRL0_RETAIN_CLOCK      0x00200000

#define BF_I2C_CTRL0_RETAIN_CLOCK(v)   (((v) << 21) & BM_I2C_CTRL0_RETAIN_CLOCK)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_CTRL0_RETAIN_CLOCK(n, v)   BFn_CS1(I2C_CTRL0, n, RETAIN_CLOCK, v)
#endif

#define BV_I2C_CTRL0_RETAIN_CLOCK__RELEASE   0x0
#define BV_I2C_CTRL0_RETAIN_CLOCK__HOLD_LOW  0x1

/* --- Register HW_I2C_CTRL0, field POST_SEND_STOP */

#define BP_I2C_CTRL0_POST_SEND_STOP      20
#define BM_I2C_CTRL0_POST_SEND_STOP      0x00100000

#define BF_I2C_CTRL0_POST_SEND_STOP(v)   (((v) << 20) & BM_I2C_CTRL0_POST_SEND_STOP)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_CTRL0_POST_SEND_STOP(n, v)   BFn_CS1(I2C_CTRL0, n, POST_SEND_STOP, v)
#endif

#define BV_I2C_CTRL0_POST_SEND_STOP__NO_STOP    0x0
#define BV_I2C_CTRL0_POST_SEND_STOP__SEND_STOP  0x1

/* --- Register HW_I2C_CTRL0, field PRE_SEND_START */

#define BP_I2C_CTRL0_PRE_SEND_START      19
#define BM_I2C_CTRL0_PRE_SEND_START      0x00080000

#define BF_I2C_CTRL0_PRE_SEND_START(v)   (((v) << 19) & BM_I2C_CTRL0_PRE_SEND_START)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_CTRL0_PRE_SEND_START(n, v)   BFn_CS1(I2C_CTRL0, n, PRE_SEND_START, v)
#endif

#define BV_I2C_CTRL0_PRE_SEND_START__NO_START    0x0
#define BV_I2C_CTRL0_PRE_SEND_START__SEND_START  0x1

/* --- Register HW_I2C_CTRL0, field SLAVE_ADDRESS_ENABLE */

#define BP_I2C_CTRL0_SLAVE_ADDRESS_ENABLE      18
#define BM_I2C_CTRL0_SLAVE_ADDRESS_ENABLE      0x00040000

#define BF_I2C_CTRL0_SLAVE_ADDRESS_ENABLE(v)   (((v) << 18) & BM_I2C_CTRL0_SLAVE_ADDRESS_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_CTRL0_SLAVE_ADDRESS_ENABLE(n, v)   BFn_CS1(I2C_CTRL0, n, SLAVE_ADDRESS_ENABLE, v)
#endif

#define BV_I2C_CTRL0_SLAVE_ADDRESS_ENABLE__DISABLED  0x0
#define BV_I2C_CTRL0_SLAVE_ADDRESS_ENABLE__ENABLED   0x1

/* --- Register HW_I2C_CTRL0, field MASTER_MODE */

#define BP_I2C_CTRL0_MASTER_MODE      17
#define BM_I2C_CTRL0_MASTER_MODE      0x00020000

#define BF_I2C_CTRL0_MASTER_MODE(v)   (((v) << 17) & BM_I2C_CTRL0_MASTER_MODE)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_CTRL0_MASTER_MODE(n, v)   BFn_CS1(I2C_CTRL0, n, MASTER_MODE, v)
#endif

#define BV_I2C_CTRL0_MASTER_MODE__SLAVE   0x0
#define BV_I2C_CTRL0_MASTER_MODE__MASTER  0x1

/* --- Register HW_I2C_CTRL0, field DIRECTION */

#define BP_I2C_CTRL0_DIRECTION      16
#define BM_I2C_CTRL0_DIRECTION      0x00010000

#define BF_I2C_CTRL0_DIRECTION(v)   (((v) << 16) & BM_I2C_CTRL0_DIRECTION)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_CTRL0_DIRECTION(n, v)   BFn_CS1(I2C_CTRL0, n, DIRECTION, v)
#endif

#define BV_I2C_CTRL0_DIRECTION__RECEIVE   0x0
#define BV_I2C_CTRL0_DIRECTION__TRANSMIT  0x1

/* --- Register HW_I2C_CTRL0, field XFER_COUNT */

#define BP_I2C_CTRL0_XFER_COUNT      0
#define BM_I2C_CTRL0_XFER_COUNT      0x0000FFFF

#define BF_I2C_CTRL0_XFER_COUNT(v)   (((v) << 0) & BM_I2C_CTRL0_XFER_COUNT)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_CTRL0_XFER_COUNT(n, v)   (HW_I2C_CTRL0(n).B.XFER_COUNT = (v))
#endif



/*
 * HW_I2C_TIMING0 - I2C Timing Register 0
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RCV_COUNT   : 10;
        unsigned RSVD1       :  6;
        unsigned HIGH_COUNT  : 10;
        unsigned RSVD2       :  6;
    } B;
} hw_i2c_timing0_t;
#endif

/*
 * constants & macros for entire multi-block HW_I2C_TIMING0 register
 */
#define HW_I2C_TIMING0_ADDR(x)      (REGS_I2C_BASE(x) + 0x10)
#define HW_I2C_TIMING0_SET_ADDR(x)  (HW_I2C_TIMING0_ADDR(x) + 4)
#define HW_I2C_TIMING0_CLR_ADDR(x)  (HW_I2C_TIMING0_ADDR(x) + 8)
#define HW_I2C_TIMING0_TOG_ADDR(x)  (HW_I2C_TIMING0_ADDR(x) + 12)

#ifndef __LANGUAGE_ASM__
#define HW_I2C_TIMING0(x)           (*(volatile hw_i2c_timing0_t *) HW_I2C_TIMING0_ADDR(x))
#define HW_I2C_TIMING0_RD(x)      (HW_I2C_TIMING0(x).U)
#define HW_I2C_TIMING0_WR(x, v)     (HW_I2C_TIMING0(x).U = (v))
#define HW_I2C_TIMING0_SET(x, v)    ((*(volatile reg32_t *) HW_I2C_TIMING0_SET_ADDR(x)) = (v))
#define HW_I2C_TIMING0_CLR(x, v)    ((*(volatile reg32_t *) HW_I2C_TIMING0_CLR_ADDR(x)) = (v))
#define HW_I2C_TIMING0_TOG(x, v)    ((*(volatile reg32_t *) HW_I2C_TIMING0_TOG_ADDR(x)) = (v))
#endif


/*
 * constants & macros for individual HW_I2C_TIMING0 bitfields
 */
/* --- Register HW_I2C_TIMING0, field RSVD2 */

#define BP_I2C_TIMING0_RSVD2      26
#define BM_I2C_TIMING0_RSVD2      0xFC000000

#ifndef __LANGUAGE_ASM__
#define BF_I2C_TIMING0_RSVD2(v)   ((((reg32_t) v) << 26) & BM_I2C_TIMING0_RSVD2)
#else
#define BF_I2C_TIMING0_RSVD2(v)   (((v) << 26) & BM_I2C_TIMING0_RSVD2)
#endif
/* --- Register HW_I2C_TIMING0, field HIGH_COUNT */

#define BP_I2C_TIMING0_HIGH_COUNT      16
#define BM_I2C_TIMING0_HIGH_COUNT      0x03FF0000

#define BF_I2C_TIMING0_HIGH_COUNT(v)   (((v) << 16) & BM_I2C_TIMING0_HIGH_COUNT)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_TIMING0_HIGH_COUNT(n, v)   BFn_CS1(I2C_TIMING0, n, HIGH_COUNT, v)
#endif

/* --- Register HW_I2C_TIMING0, field RSVD1 */

#define BP_I2C_TIMING0_RSVD1      10
#define BM_I2C_TIMING0_RSVD1      0x0000FC00

#define BF_I2C_TIMING0_RSVD1(v)   (((v) << 10) & BM_I2C_TIMING0_RSVD1)
/* --- Register HW_I2C_TIMING0, field RCV_COUNT */

#define BP_I2C_TIMING0_RCV_COUNT      0
#define BM_I2C_TIMING0_RCV_COUNT      0x000003FF

#define BF_I2C_TIMING0_RCV_COUNT(v)   (((v) << 0) & BM_I2C_TIMING0_RCV_COUNT)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_TIMING0_RCV_COUNT(n, v)   BFn_CS1(I2C_TIMING0, n, RCV_COUNT, v)
#endif



/*
 * HW_I2C_TIMING1 - I2C Timing Register 1
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned XMIT_COUNT  : 10;
        unsigned RSVD1       :  6;
        unsigned LOW_COUNT   : 10;
        unsigned RSVD2       :  6;
    } B;
} hw_i2c_timing1_t;
#endif

/*
 * constants & macros for entire multi-block HW_I2C_TIMING1 register
 */
#define HW_I2C_TIMING1_ADDR(x)      (REGS_I2C_BASE(x) + 0x20)
#define HW_I2C_TIMING1_SET_ADDR(x)  (HW_I2C_TIMING1_ADDR(x) + 4)
#define HW_I2C_TIMING1_CLR_ADDR(x)  (HW_I2C_TIMING1_ADDR(x) + 8)
#define HW_I2C_TIMING1_TOG_ADDR(x)  (HW_I2C_TIMING1_ADDR(x) + 12)

#ifndef __LANGUAGE_ASM__
#define HW_I2C_TIMING1(x)           (*(volatile hw_i2c_timing1_t *) HW_I2C_TIMING1_ADDR(x))
#define HW_I2C_TIMING1_RD(x)      (HW_I2C_TIMING1(x).U)
#define HW_I2C_TIMING1_WR(x, v)     (HW_I2C_TIMING1(x).U = (v))
#define HW_I2C_TIMING1_SET(x, v)    ((*(volatile reg32_t *) HW_I2C_TIMING1_SET_ADDR(x)) = (v))
#define HW_I2C_TIMING1_CLR(x, v)    ((*(volatile reg32_t *) HW_I2C_TIMING1_CLR_ADDR(x)) = (v))
#define HW_I2C_TIMING1_TOG(x, v)    ((*(volatile reg32_t *) HW_I2C_TIMING1_TOG_ADDR(x)) = (v))
#endif


/*
 * constants & macros for individual HW_I2C_TIMING1 bitfields
 */
/* --- Register HW_I2C_TIMING1, field RSVD2 */

#define BP_I2C_TIMING1_RSVD2      26
#define BM_I2C_TIMING1_RSVD2      0xFC000000

#ifndef __LANGUAGE_ASM__
#define BF_I2C_TIMING1_RSVD2(v)   ((((reg32_t) v) << 26) & BM_I2C_TIMING1_RSVD2)
#else
#define BF_I2C_TIMING1_RSVD2(v)   (((v) << 26) & BM_I2C_TIMING1_RSVD2)
#endif
/* --- Register HW_I2C_TIMING1, field LOW_COUNT */

#define BP_I2C_TIMING1_LOW_COUNT      16
#define BM_I2C_TIMING1_LOW_COUNT      0x03FF0000

#define BF_I2C_TIMING1_LOW_COUNT(v)   (((v) << 16) & BM_I2C_TIMING1_LOW_COUNT)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_TIMING1_LOW_COUNT(n, v)   BFn_CS1(I2C_TIMING1, n, LOW_COUNT, v)
#endif

/* --- Register HW_I2C_TIMING1, field RSVD1 */

#define BP_I2C_TIMING1_RSVD1      10
#define BM_I2C_TIMING1_RSVD1      0x0000FC00

#define BF_I2C_TIMING1_RSVD1(v)   (((v) << 10) & BM_I2C_TIMING1_RSVD1)
/* --- Register HW_I2C_TIMING1, field XMIT_COUNT */

#define BP_I2C_TIMING1_XMIT_COUNT      0
#define BM_I2C_TIMING1_XMIT_COUNT      0x000003FF

#define BF_I2C_TIMING1_XMIT_COUNT(v)   (((v) << 0) & BM_I2C_TIMING1_XMIT_COUNT)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_TIMING1_XMIT_COUNT(n, v)   BFn_CS1(I2C_TIMING1, n, XMIT_COUNT, v)
#endif



/*
 * HW_I2C_TIMING2 - I2C Timing Register 2
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned LEADIN_COUNT  : 10;
        unsigned RSVD1         :  6;
        unsigned BUS_FREE      : 10;
        unsigned RSVD2         :  6;
    } B;
} hw_i2c_timing2_t;
#endif

/*
 * constants & macros for entire multi-block HW_I2C_TIMING2 register
 */
#define HW_I2C_TIMING2_ADDR(x)      (REGS_I2C_BASE(x) + 0x30)
#define HW_I2C_TIMING2_SET_ADDR(x)  (HW_I2C_TIMING2_ADDR(x) + 4)
#define HW_I2C_TIMING2_CLR_ADDR(x)  (HW_I2C_TIMING2_ADDR(x) + 8)
#define HW_I2C_TIMING2_TOG_ADDR(x)  (HW_I2C_TIMING2_ADDR(x) + 12)

#ifndef __LANGUAGE_ASM__
#define HW_I2C_TIMING2(x)           (*(volatile hw_i2c_timing2_t *) HW_I2C_TIMING2_ADDR(x))
#define HW_I2C_TIMING2_RD(x)      (HW_I2C_TIMING2(x).U)
#define HW_I2C_TIMING2_WR(x, v)     (HW_I2C_TIMING2(x).U = (v))
#define HW_I2C_TIMING2_SET(x, v)    ((*(volatile reg32_t *) HW_I2C_TIMING2_SET_ADDR(x)) = (v))
#define HW_I2C_TIMING2_CLR(x, v)    ((*(volatile reg32_t *) HW_I2C_TIMING2_CLR_ADDR(x)) = (v))
#define HW_I2C_TIMING2_TOG(x, v)    ((*(volatile reg32_t *) HW_I2C_TIMING2_TOG_ADDR(x)) = (v))
#endif


/*
 * constants & macros for individual HW_I2C_TIMING2 bitfields
 */
/* --- Register HW_I2C_TIMING2, field RSVD2 */

#define BP_I2C_TIMING2_RSVD2      26
#define BM_I2C_TIMING2_RSVD2      0xFC000000

#ifndef __LANGUAGE_ASM__
#define BF_I2C_TIMING2_RSVD2(v)   ((((reg32_t) v) << 26) & BM_I2C_TIMING2_RSVD2)
#else
#define BF_I2C_TIMING2_RSVD2(v)   (((v) << 26) & BM_I2C_TIMING2_RSVD2)
#endif
/* --- Register HW_I2C_TIMING2, field BUS_FREE */

#define BP_I2C_TIMING2_BUS_FREE      16
#define BM_I2C_TIMING2_BUS_FREE      0x03FF0000

#define BF_I2C_TIMING2_BUS_FREE(v)   (((v) << 16) & BM_I2C_TIMING2_BUS_FREE)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_TIMING2_BUS_FREE(n, v)   BFn_CS1(I2C_TIMING2, n, BUS_FREE, v)
#endif

/* --- Register HW_I2C_TIMING2, field RSVD1 */

#define BP_I2C_TIMING2_RSVD1      10
#define BM_I2C_TIMING2_RSVD1      0x0000FC00

#define BF_I2C_TIMING2_RSVD1(v)   (((v) << 10) & BM_I2C_TIMING2_RSVD1)
/* --- Register HW_I2C_TIMING2, field LEADIN_COUNT */

#define BP_I2C_TIMING2_LEADIN_COUNT      0
#define BM_I2C_TIMING2_LEADIN_COUNT      0x000003FF

#define BF_I2C_TIMING2_LEADIN_COUNT(v)   (((v) << 0) & BM_I2C_TIMING2_LEADIN_COUNT)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_TIMING2_LEADIN_COUNT(n, v)   BFn_CS1(I2C_TIMING2, n, LEADIN_COUNT, v)
#endif



/*
 * HW_I2C_CTRL1 - I2C Control Register 1
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned SLAVE_IRQ                  :  1;
        unsigned SLAVE_STOP_IRQ             :  1;
        unsigned MASTER_LOSS_IRQ            :  1;
        unsigned EARLY_TERM_IRQ             :  1;
        unsigned OVERSIZE_XFER_TERM_IRQ     :  1;
        unsigned NO_SLAVE_ACK_IRQ           :  1;
        unsigned DATA_ENGINE_CMPLT_IRQ      :  1;
        unsigned BUS_FREE_IRQ               :  1;
        unsigned SLAVE_IRQ_EN               :  1;
        unsigned SLAVE_STOP_IRQ_EN          :  1;
        unsigned MASTER_LOSS_IRQ_EN         :  1;
        unsigned EARLY_TERM_IRQ_EN          :  1;
        unsigned OVERSIZE_XFER_TERM_IRQ_EN  :  1;
        unsigned NO_SLAVE_ACK_IRQ_EN        :  1;
        unsigned DATA_ENGINE_CMPLT_IRQ_EN   :  1;
        unsigned BUS_FREE_IRQ_EN            :  1;
        unsigned SLAVE_ADDRESS_BYTE         :  8;
        unsigned BCAST_SLAVE_EN             :  1;
        unsigned FORCE_CLK_IDLE             :  1;
        unsigned FORCE_DATA_IDLE            :  1;
        unsigned ACK_MODE                   :  1;
        unsigned CLR_GOT_A_NAK              :  1;
        unsigned WR_QUEUE_IRQ               :  1;
        unsigned RD_QUEUE_IRQ               :  1;
        unsigned RSVD1                      :  1;
    } B;
} hw_i2c_ctrl1_t;
#endif

/*
 * constants & macros for entire multi-block HW_I2C_CTRL1 register
 */
#define HW_I2C_CTRL1_ADDR(x)      (REGS_I2C_BASE(x) + 0x40)
#define HW_I2C_CTRL1_SET_ADDR(x)  (HW_I2C_CTRL1_ADDR(x) + 4)
#define HW_I2C_CTRL1_CLR_ADDR(x)  (HW_I2C_CTRL1_ADDR(x) + 8)
#define HW_I2C_CTRL1_TOG_ADDR(x)  (HW_I2C_CTRL1_ADDR(x) + 12)

#ifndef __LANGUAGE_ASM__
#define HW_I2C_CTRL1(x)           (*(volatile hw_i2c_ctrl1_t *) HW_I2C_CTRL1_ADDR(x))
#define HW_I2C_CTRL1_RD(x)      (HW_I2C_CTRL1(x).U)
#define HW_I2C_CTRL1_WR(x, v)     (HW_I2C_CTRL1(x).U = (v))
#define HW_I2C_CTRL1_SET(x, v)    ((*(volatile reg32_t *) HW_I2C_CTRL1_SET_ADDR(x)) = (v))
#define HW_I2C_CTRL1_CLR(x, v)    ((*(volatile reg32_t *) HW_I2C_CTRL1_CLR_ADDR(x)) = (v))
#define HW_I2C_CTRL1_TOG(x, v)    ((*(volatile reg32_t *) HW_I2C_CTRL1_TOG_ADDR(x)) = (v))
#endif


/*
 * constants & macros for individual HW_I2C_CTRL1 bitfields
 */
/* --- Register HW_I2C_CTRL1, field RSVD1 */

#define BP_I2C_CTRL1_RSVD1      31
#define BM_I2C_CTRL1_RSVD1      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_I2C_CTRL1_RSVD1(v)   ((((reg32_t) v) << 31) & BM_I2C_CTRL1_RSVD1)
#else
#define BF_I2C_CTRL1_RSVD1(v)   (((v) << 31) & BM_I2C_CTRL1_RSVD1)
#endif
/* --- Register HW_I2C_CTRL1, field RD_QUEUE_IRQ */

#define BP_I2C_CTRL1_RD_QUEUE_IRQ      30
#define BM_I2C_CTRL1_RD_QUEUE_IRQ      0x40000000

#define BF_I2C_CTRL1_RD_QUEUE_IRQ(v)   (((v) << 30) & BM_I2C_CTRL1_RD_QUEUE_IRQ)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_CTRL1_RD_QUEUE_IRQ(n, v)   BFn_CS1(I2C_CTRL1, n, RD_QUEUE_IRQ, v)
#endif

#define BV_I2C_CTRL1_RD_QUEUE_IRQ__NO_REQUEST  0x0
#define BV_I2C_CTRL1_RD_QUEUE_IRQ__REQUEST     0x1

/* --- Register HW_I2C_CTRL1, field WR_QUEUE_IRQ */

#define BP_I2C_CTRL1_WR_QUEUE_IRQ      29
#define BM_I2C_CTRL1_WR_QUEUE_IRQ      0x20000000

#define BF_I2C_CTRL1_WR_QUEUE_IRQ(v)   (((v) << 29) & BM_I2C_CTRL1_WR_QUEUE_IRQ)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_CTRL1_WR_QUEUE_IRQ(n, v)   BFn_CS1(I2C_CTRL1, n, WR_QUEUE_IRQ, v)
#endif

#define BV_I2C_CTRL1_WR_QUEUE_IRQ__NO_REQUEST  0x0
#define BV_I2C_CTRL1_WR_QUEUE_IRQ__REQUEST     0x1

/* --- Register HW_I2C_CTRL1, field CLR_GOT_A_NAK */

#define BP_I2C_CTRL1_CLR_GOT_A_NAK      28
#define BM_I2C_CTRL1_CLR_GOT_A_NAK      0x10000000

#define BF_I2C_CTRL1_CLR_GOT_A_NAK(v)   (((v) << 28) & BM_I2C_CTRL1_CLR_GOT_A_NAK)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_CTRL1_CLR_GOT_A_NAK(n, v)   BFn_CS1(I2C_CTRL1, n, CLR_GOT_A_NAK, v)
#endif

#define BV_I2C_CTRL1_CLR_GOT_A_NAK__DO_NOTHING  0x0
#define BV_I2C_CTRL1_CLR_GOT_A_NAK__CLEAR       0x1

/* --- Register HW_I2C_CTRL1, field ACK_MODE */

#define BP_I2C_CTRL1_ACK_MODE      27
#define BM_I2C_CTRL1_ACK_MODE      0x08000000

#define BF_I2C_CTRL1_ACK_MODE(v)   (((v) << 27) & BM_I2C_CTRL1_ACK_MODE)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_CTRL1_ACK_MODE(n, v)   BFn_CS1(I2C_CTRL1, n, ACK_MODE, v)
#endif

#define BV_I2C_CTRL1_ACK_MODE__ACK_AFTER_HOLD_LOW   0x0
#define BV_I2C_CTRL1_ACK_MODE__ACK_BEFORE_HOLD_LOW  0x1

/* --- Register HW_I2C_CTRL1, field FORCE_DATA_IDLE */

#define BP_I2C_CTRL1_FORCE_DATA_IDLE      26
#define BM_I2C_CTRL1_FORCE_DATA_IDLE      0x04000000

#define BF_I2C_CTRL1_FORCE_DATA_IDLE(v)   (((v) << 26) & BM_I2C_CTRL1_FORCE_DATA_IDLE)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_CTRL1_FORCE_DATA_IDLE(n, v)   BFn_CS1(I2C_CTRL1, n, FORCE_DATA_IDLE, v)
#endif

/* --- Register HW_I2C_CTRL1, field FORCE_CLK_IDLE */

#define BP_I2C_CTRL1_FORCE_CLK_IDLE      25
#define BM_I2C_CTRL1_FORCE_CLK_IDLE      0x02000000

#define BF_I2C_CTRL1_FORCE_CLK_IDLE(v)   (((v) << 25) & BM_I2C_CTRL1_FORCE_CLK_IDLE)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_CTRL1_FORCE_CLK_IDLE(n, v)   BFn_CS1(I2C_CTRL1, n, FORCE_CLK_IDLE, v)
#endif

/* --- Register HW_I2C_CTRL1, field BCAST_SLAVE_EN */

#define BP_I2C_CTRL1_BCAST_SLAVE_EN      24
#define BM_I2C_CTRL1_BCAST_SLAVE_EN      0x01000000

#define BF_I2C_CTRL1_BCAST_SLAVE_EN(v)   (((v) << 24) & BM_I2C_CTRL1_BCAST_SLAVE_EN)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_CTRL1_BCAST_SLAVE_EN(n, v)   BFn_CS1(I2C_CTRL1, n, BCAST_SLAVE_EN, v)
#endif

#define BV_I2C_CTRL1_BCAST_SLAVE_EN__NO_BCAST     0x0
#define BV_I2C_CTRL1_BCAST_SLAVE_EN__WATCH_BCAST  0x1

/* --- Register HW_I2C_CTRL1, field SLAVE_ADDRESS_BYTE */

#define BP_I2C_CTRL1_SLAVE_ADDRESS_BYTE      16
#define BM_I2C_CTRL1_SLAVE_ADDRESS_BYTE      0x00FF0000

#define BF_I2C_CTRL1_SLAVE_ADDRESS_BYTE(v)   (((v) << 16) & BM_I2C_CTRL1_SLAVE_ADDRESS_BYTE)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_CTRL1_SLAVE_ADDRESS_BYTE(n, v)   (HW_I2C_CTRL1(n).B.SLAVE_ADDRESS_BYTE = (v))
#endif

/* --- Register HW_I2C_CTRL1, field BUS_FREE_IRQ_EN */

#define BP_I2C_CTRL1_BUS_FREE_IRQ_EN      15
#define BM_I2C_CTRL1_BUS_FREE_IRQ_EN      0x00008000

#define BF_I2C_CTRL1_BUS_FREE_IRQ_EN(v)   (((v) << 15) & BM_I2C_CTRL1_BUS_FREE_IRQ_EN)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_CTRL1_BUS_FREE_IRQ_EN(n, v)   BFn_CS1(I2C_CTRL1, n, BUS_FREE_IRQ_EN, v)
#endif

#define BV_I2C_CTRL1_BUS_FREE_IRQ_EN__DISABLED  0x0
#define BV_I2C_CTRL1_BUS_FREE_IRQ_EN__ENABLED   0x1

/* --- Register HW_I2C_CTRL1, field DATA_ENGINE_CMPLT_IRQ_EN */

#define BP_I2C_CTRL1_DATA_ENGINE_CMPLT_IRQ_EN      14
#define BM_I2C_CTRL1_DATA_ENGINE_CMPLT_IRQ_EN      0x00004000

#define BF_I2C_CTRL1_DATA_ENGINE_CMPLT_IRQ_EN(v)   (((v) << 14) & BM_I2C_CTRL1_DATA_ENGINE_CMPLT_IRQ_EN)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_CTRL1_DATA_ENGINE_CMPLT_IRQ_EN(n, v)   BFn_CS1(I2C_CTRL1, n, DATA_ENGINE_CMPLT_IRQ_EN, v)
#endif

#define BV_I2C_CTRL1_DATA_ENGINE_CMPLT_IRQ_EN__DISABLED  0x0
#define BV_I2C_CTRL1_DATA_ENGINE_CMPLT_IRQ_EN__ENABLED   0x1

/* --- Register HW_I2C_CTRL1, field NO_SLAVE_ACK_IRQ_EN */

#define BP_I2C_CTRL1_NO_SLAVE_ACK_IRQ_EN      13
#define BM_I2C_CTRL1_NO_SLAVE_ACK_IRQ_EN      0x00002000

#define BF_I2C_CTRL1_NO_SLAVE_ACK_IRQ_EN(v)   (((v) << 13) & BM_I2C_CTRL1_NO_SLAVE_ACK_IRQ_EN)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_CTRL1_NO_SLAVE_ACK_IRQ_EN(n, v)   BFn_CS1(I2C_CTRL1, n, NO_SLAVE_ACK_IRQ_EN, v)
#endif

#define BV_I2C_CTRL1_NO_SLAVE_ACK_IRQ_EN__DISABLED  0x0
#define BV_I2C_CTRL1_NO_SLAVE_ACK_IRQ_EN__ENABLED   0x1

/* --- Register HW_I2C_CTRL1, field OVERSIZE_XFER_TERM_IRQ_EN */

#define BP_I2C_CTRL1_OVERSIZE_XFER_TERM_IRQ_EN      12
#define BM_I2C_CTRL1_OVERSIZE_XFER_TERM_IRQ_EN      0x00001000

#define BF_I2C_CTRL1_OVERSIZE_XFER_TERM_IRQ_EN(v)   (((v) << 12) & BM_I2C_CTRL1_OVERSIZE_XFER_TERM_IRQ_EN)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_CTRL1_OVERSIZE_XFER_TERM_IRQ_EN(n, v)   BFn_CS1(I2C_CTRL1, n, OVERSIZE_XFER_TERM_IRQ_EN, v)
#endif

#define BV_I2C_CTRL1_OVERSIZE_XFER_TERM_IRQ_EN__DISABLED  0x0
#define BV_I2C_CTRL1_OVERSIZE_XFER_TERM_IRQ_EN__ENABLED   0x1

/* --- Register HW_I2C_CTRL1, field EARLY_TERM_IRQ_EN */

#define BP_I2C_CTRL1_EARLY_TERM_IRQ_EN      11
#define BM_I2C_CTRL1_EARLY_TERM_IRQ_EN      0x00000800

#define BF_I2C_CTRL1_EARLY_TERM_IRQ_EN(v)   (((v) << 11) & BM_I2C_CTRL1_EARLY_TERM_IRQ_EN)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_CTRL1_EARLY_TERM_IRQ_EN(n, v)   BFn_CS1(I2C_CTRL1, n, EARLY_TERM_IRQ_EN, v)
#endif

#define BV_I2C_CTRL1_EARLY_TERM_IRQ_EN__DISABLED  0x0
#define BV_I2C_CTRL1_EARLY_TERM_IRQ_EN__ENABLED   0x1

/* --- Register HW_I2C_CTRL1, field MASTER_LOSS_IRQ_EN */

#define BP_I2C_CTRL1_MASTER_LOSS_IRQ_EN      10
#define BM_I2C_CTRL1_MASTER_LOSS_IRQ_EN      0x00000400

#define BF_I2C_CTRL1_MASTER_LOSS_IRQ_EN(v)   (((v) << 10) & BM_I2C_CTRL1_MASTER_LOSS_IRQ_EN)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_CTRL1_MASTER_LOSS_IRQ_EN(n, v)   BFn_CS1(I2C_CTRL1, n, MASTER_LOSS_IRQ_EN, v)
#endif

#define BV_I2C_CTRL1_MASTER_LOSS_IRQ_EN__DISABLED  0x0
#define BV_I2C_CTRL1_MASTER_LOSS_IRQ_EN__ENABLED   0x1

/* --- Register HW_I2C_CTRL1, field SLAVE_STOP_IRQ_EN */

#define BP_I2C_CTRL1_SLAVE_STOP_IRQ_EN      9
#define BM_I2C_CTRL1_SLAVE_STOP_IRQ_EN      0x00000200

#define BF_I2C_CTRL1_SLAVE_STOP_IRQ_EN(v)   (((v) << 9) & BM_I2C_CTRL1_SLAVE_STOP_IRQ_EN)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_CTRL1_SLAVE_STOP_IRQ_EN(n, v)   BFn_CS1(I2C_CTRL1, n, SLAVE_STOP_IRQ_EN, v)
#endif

#define BV_I2C_CTRL1_SLAVE_STOP_IRQ_EN__DISABLED  0x0
#define BV_I2C_CTRL1_SLAVE_STOP_IRQ_EN__ENABLED   0x1

/* --- Register HW_I2C_CTRL1, field SLAVE_IRQ_EN */

#define BP_I2C_CTRL1_SLAVE_IRQ_EN      8
#define BM_I2C_CTRL1_SLAVE_IRQ_EN      0x00000100

#define BF_I2C_CTRL1_SLAVE_IRQ_EN(v)   (((v) << 8) & BM_I2C_CTRL1_SLAVE_IRQ_EN)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_CTRL1_SLAVE_IRQ_EN(n, v)   BFn_CS1(I2C_CTRL1, n, SLAVE_IRQ_EN, v)
#endif

#define BV_I2C_CTRL1_SLAVE_IRQ_EN__DISABLED  0x0
#define BV_I2C_CTRL1_SLAVE_IRQ_EN__ENABLED   0x1

/* --- Register HW_I2C_CTRL1, field BUS_FREE_IRQ */

#define BP_I2C_CTRL1_BUS_FREE_IRQ      7
#define BM_I2C_CTRL1_BUS_FREE_IRQ      0x00000080

#define BF_I2C_CTRL1_BUS_FREE_IRQ(v)   (((v) << 7) & BM_I2C_CTRL1_BUS_FREE_IRQ)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_CTRL1_BUS_FREE_IRQ(n, v)   BFn_CS1(I2C_CTRL1, n, BUS_FREE_IRQ, v)
#endif

#define BV_I2C_CTRL1_BUS_FREE_IRQ__NO_REQUEST  0x0
#define BV_I2C_CTRL1_BUS_FREE_IRQ__REQUEST     0x1

/* --- Register HW_I2C_CTRL1, field DATA_ENGINE_CMPLT_IRQ */

#define BP_I2C_CTRL1_DATA_ENGINE_CMPLT_IRQ      6
#define BM_I2C_CTRL1_DATA_ENGINE_CMPLT_IRQ      0x00000040

#define BF_I2C_CTRL1_DATA_ENGINE_CMPLT_IRQ(v)   (((v) << 6) & BM_I2C_CTRL1_DATA_ENGINE_CMPLT_IRQ)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_CTRL1_DATA_ENGINE_CMPLT_IRQ(n, v)   BFn_CS1(I2C_CTRL1, n, DATA_ENGINE_CMPLT_IRQ, v)
#endif

#define BV_I2C_CTRL1_DATA_ENGINE_CMPLT_IRQ__NO_REQUEST  0x0
#define BV_I2C_CTRL1_DATA_ENGINE_CMPLT_IRQ__REQUEST     0x1

/* --- Register HW_I2C_CTRL1, field NO_SLAVE_ACK_IRQ */

#define BP_I2C_CTRL1_NO_SLAVE_ACK_IRQ      5
#define BM_I2C_CTRL1_NO_SLAVE_ACK_IRQ      0x00000020

#define BF_I2C_CTRL1_NO_SLAVE_ACK_IRQ(v)   (((v) << 5) & BM_I2C_CTRL1_NO_SLAVE_ACK_IRQ)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_CTRL1_NO_SLAVE_ACK_IRQ(n, v)   BFn_CS1(I2C_CTRL1, n, NO_SLAVE_ACK_IRQ, v)
#endif

#define BV_I2C_CTRL1_NO_SLAVE_ACK_IRQ__NO_REQUEST  0x0
#define BV_I2C_CTRL1_NO_SLAVE_ACK_IRQ__REQUEST     0x1

/* --- Register HW_I2C_CTRL1, field OVERSIZE_XFER_TERM_IRQ */

#define BP_I2C_CTRL1_OVERSIZE_XFER_TERM_IRQ      4
#define BM_I2C_CTRL1_OVERSIZE_XFER_TERM_IRQ      0x00000010

#define BF_I2C_CTRL1_OVERSIZE_XFER_TERM_IRQ(v)   (((v) << 4) & BM_I2C_CTRL1_OVERSIZE_XFER_TERM_IRQ)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_CTRL1_OVERSIZE_XFER_TERM_IRQ(n, v)   BFn_CS1(I2C_CTRL1, n, OVERSIZE_XFER_TERM_IRQ, v)
#endif

#define BV_I2C_CTRL1_OVERSIZE_XFER_TERM_IRQ__NO_REQUEST  0x0
#define BV_I2C_CTRL1_OVERSIZE_XFER_TERM_IRQ__REQUEST     0x1

/* --- Register HW_I2C_CTRL1, field EARLY_TERM_IRQ */

#define BP_I2C_CTRL1_EARLY_TERM_IRQ      3
#define BM_I2C_CTRL1_EARLY_TERM_IRQ      0x00000008

#define BF_I2C_CTRL1_EARLY_TERM_IRQ(v)   (((v) << 3) & BM_I2C_CTRL1_EARLY_TERM_IRQ)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_CTRL1_EARLY_TERM_IRQ(n, v)   BFn_CS1(I2C_CTRL1, n, EARLY_TERM_IRQ, v)
#endif

#define BV_I2C_CTRL1_EARLY_TERM_IRQ__NO_REQUEST  0x0
#define BV_I2C_CTRL1_EARLY_TERM_IRQ__REQUEST     0x1

/* --- Register HW_I2C_CTRL1, field MASTER_LOSS_IRQ */

#define BP_I2C_CTRL1_MASTER_LOSS_IRQ      2
#define BM_I2C_CTRL1_MASTER_LOSS_IRQ      0x00000004

#define BF_I2C_CTRL1_MASTER_LOSS_IRQ(v)   (((v) << 2) & BM_I2C_CTRL1_MASTER_LOSS_IRQ)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_CTRL1_MASTER_LOSS_IRQ(n, v)   BFn_CS1(I2C_CTRL1, n, MASTER_LOSS_IRQ, v)
#endif

#define BV_I2C_CTRL1_MASTER_LOSS_IRQ__NO_REQUEST  0x0
#define BV_I2C_CTRL1_MASTER_LOSS_IRQ__REQUEST     0x1

/* --- Register HW_I2C_CTRL1, field SLAVE_STOP_IRQ */

#define BP_I2C_CTRL1_SLAVE_STOP_IRQ      1
#define BM_I2C_CTRL1_SLAVE_STOP_IRQ      0x00000002

#define BF_I2C_CTRL1_SLAVE_STOP_IRQ(v)   (((v) << 1) & BM_I2C_CTRL1_SLAVE_STOP_IRQ)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_CTRL1_SLAVE_STOP_IRQ(n, v)   BFn_CS1(I2C_CTRL1, n, SLAVE_STOP_IRQ, v)
#endif

#define BV_I2C_CTRL1_SLAVE_STOP_IRQ__NO_REQUEST  0x0
#define BV_I2C_CTRL1_SLAVE_STOP_IRQ__REQUEST     0x1

/* --- Register HW_I2C_CTRL1, field SLAVE_IRQ */

#define BP_I2C_CTRL1_SLAVE_IRQ      0
#define BM_I2C_CTRL1_SLAVE_IRQ      0x00000001

#define BF_I2C_CTRL1_SLAVE_IRQ(v)   (((v) << 0) & BM_I2C_CTRL1_SLAVE_IRQ)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_CTRL1_SLAVE_IRQ(n, v)   BFn_CS1(I2C_CTRL1, n, SLAVE_IRQ, v)
#endif

#define BV_I2C_CTRL1_SLAVE_IRQ__NO_REQUEST  0x0
#define BV_I2C_CTRL1_SLAVE_IRQ__REQUEST     0x1



/*
 * HW_I2C_STAT - I2C Status Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned SLAVE_IRQ_SUMMARY               :  1;
        unsigned SLAVE_STOP_IRQ_SUMMARY          :  1;
        unsigned MASTER_LOSS_IRQ_SUMMARY         :  1;
        unsigned EARLY_TERM_IRQ_SUMMARY          :  1;
        unsigned OVERSIZE_XFER_TERM_IRQ_SUMMARY  :  1;
        unsigned NO_SLAVE_ACK_IRQ_SUMMARY        :  1;
        unsigned DATA_ENGINE_CMPLT_IRQ_SUMMARY   :  1;
        unsigned BUS_FREE_IRQ_SUMMARY            :  1;
        unsigned SLAVE_BUSY                      :  1;
        unsigned DATA_ENGINE_BUSY                :  1;
        unsigned CLK_GEN_BUSY                    :  1;
        unsigned BUS_BUSY                        :  1;
        unsigned DATA_ENGINE_DMA_WAIT            :  1;
        unsigned SLAVE_SEARCHING                 :  1;
        unsigned SLAVE_FOUND                     :  1;
        unsigned SLAVE_ADDR_EQ_ZERO              :  1;
        unsigned RCVD_SLAVE_ADDR                 :  8;
        unsigned RSVD1                           :  4;
        unsigned GOT_A_NAK                       :  1;
        unsigned ANY_ENABLED_IRQ                 :  1;
        unsigned SLAVE_PRESENT                   :  1;
        unsigned MASTER_PRESENT                  :  1;
    } B;
} hw_i2c_stat_t;
#endif

/*
 * constants & macros for entire multi-block HW_I2C_STAT register
 */
#define HW_I2C_STAT_ADDR(x)      (REGS_I2C_BASE(x) + 0x50)

#ifndef __LANGUAGE_ASM__
#define HW_I2C_STAT(x)           (*(volatile hw_i2c_stat_t *) HW_I2C_STAT_ADDR(x))
#define HW_I2C_STAT_RD(x)      (HW_I2C_STAT(x).U)
#endif


/*
 * constants & macros for individual HW_I2C_STAT bitfields
 */
/* --- Register HW_I2C_STAT, field MASTER_PRESENT */

#define BP_I2C_STAT_MASTER_PRESENT      31
#define BM_I2C_STAT_MASTER_PRESENT      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_I2C_STAT_MASTER_PRESENT(v)   ((((reg32_t) v) << 31) & BM_I2C_STAT_MASTER_PRESENT)
#else
#define BF_I2C_STAT_MASTER_PRESENT(v)   (((v) << 31) & BM_I2C_STAT_MASTER_PRESENT)
#endif
#define BV_I2C_STAT_MASTER_PRESENT__UNAVAILABLE  0x0
#define BV_I2C_STAT_MASTER_PRESENT__AVAILABLE    0x1

/* --- Register HW_I2C_STAT, field SLAVE_PRESENT */

#define BP_I2C_STAT_SLAVE_PRESENT      30
#define BM_I2C_STAT_SLAVE_PRESENT      0x40000000

#define BF_I2C_STAT_SLAVE_PRESENT(v)   (((v) << 30) & BM_I2C_STAT_SLAVE_PRESENT)
#define BV_I2C_STAT_SLAVE_PRESENT__UNAVAILABLE  0x0
#define BV_I2C_STAT_SLAVE_PRESENT__AVAILABLE    0x1

/* --- Register HW_I2C_STAT, field ANY_ENABLED_IRQ */

#define BP_I2C_STAT_ANY_ENABLED_IRQ      29
#define BM_I2C_STAT_ANY_ENABLED_IRQ      0x20000000

#define BF_I2C_STAT_ANY_ENABLED_IRQ(v)   (((v) << 29) & BM_I2C_STAT_ANY_ENABLED_IRQ)
#define BV_I2C_STAT_ANY_ENABLED_IRQ__NO_REQUESTS           0x0
#define BV_I2C_STAT_ANY_ENABLED_IRQ__AT_LEAST_ONE_REQUEST  0x1

/* --- Register HW_I2C_STAT, field GOT_A_NAK */

#define BP_I2C_STAT_GOT_A_NAK      28
#define BM_I2C_STAT_GOT_A_NAK      0x10000000

#define BF_I2C_STAT_GOT_A_NAK(v)   (((v) << 28) & BM_I2C_STAT_GOT_A_NAK)
#define BV_I2C_STAT_GOT_A_NAK__NO_NAK        0x0
#define BV_I2C_STAT_GOT_A_NAK__DETECTED_NAK  0x1

/* --- Register HW_I2C_STAT, field RSVD1 */

#define BP_I2C_STAT_RSVD1      24
#define BM_I2C_STAT_RSVD1      0x0F000000

#define BF_I2C_STAT_RSVD1(v)   (((v) << 24) & BM_I2C_STAT_RSVD1)
/* --- Register HW_I2C_STAT, field RCVD_SLAVE_ADDR */

#define BP_I2C_STAT_RCVD_SLAVE_ADDR      16
#define BM_I2C_STAT_RCVD_SLAVE_ADDR      0x00FF0000

#define BF_I2C_STAT_RCVD_SLAVE_ADDR(v)   (((v) << 16) & BM_I2C_STAT_RCVD_SLAVE_ADDR)
/* --- Register HW_I2C_STAT, field SLAVE_ADDR_EQ_ZERO */

#define BP_I2C_STAT_SLAVE_ADDR_EQ_ZERO      15
#define BM_I2C_STAT_SLAVE_ADDR_EQ_ZERO      0x00008000

#define BF_I2C_STAT_SLAVE_ADDR_EQ_ZERO(v)   (((v) << 15) & BM_I2C_STAT_SLAVE_ADDR_EQ_ZERO)
#define BV_I2C_STAT_SLAVE_ADDR_EQ_ZERO__ZERO_NOT_MATCHED  0x0
#define BV_I2C_STAT_SLAVE_ADDR_EQ_ZERO__WAS_ZERO          0x1

/* --- Register HW_I2C_STAT, field SLAVE_FOUND */

#define BP_I2C_STAT_SLAVE_FOUND      14
#define BM_I2C_STAT_SLAVE_FOUND      0x00004000

#define BF_I2C_STAT_SLAVE_FOUND(v)   (((v) << 14) & BM_I2C_STAT_SLAVE_FOUND)
#define BV_I2C_STAT_SLAVE_FOUND__IDLE     0x0
#define BV_I2C_STAT_SLAVE_FOUND__WAITING  0x1

/* --- Register HW_I2C_STAT, field SLAVE_SEARCHING */

#define BP_I2C_STAT_SLAVE_SEARCHING      13
#define BM_I2C_STAT_SLAVE_SEARCHING      0x00002000

#define BF_I2C_STAT_SLAVE_SEARCHING(v)   (((v) << 13) & BM_I2C_STAT_SLAVE_SEARCHING)
#define BV_I2C_STAT_SLAVE_SEARCHING__IDLE    0x0
#define BV_I2C_STAT_SLAVE_SEARCHING__ACTIVE  0x1

/* --- Register HW_I2C_STAT, field DATA_ENGINE_DMA_WAIT */

#define BP_I2C_STAT_DATA_ENGINE_DMA_WAIT      12
#define BM_I2C_STAT_DATA_ENGINE_DMA_WAIT      0x00001000

#define BF_I2C_STAT_DATA_ENGINE_DMA_WAIT(v)   (((v) << 12) & BM_I2C_STAT_DATA_ENGINE_DMA_WAIT)
#define BV_I2C_STAT_DATA_ENGINE_DMA_WAIT__CONTINUE  0x0
#define BV_I2C_STAT_DATA_ENGINE_DMA_WAIT__WAITING   0x1

/* --- Register HW_I2C_STAT, field BUS_BUSY */

#define BP_I2C_STAT_BUS_BUSY      11
#define BM_I2C_STAT_BUS_BUSY      0x00000800

#define BF_I2C_STAT_BUS_BUSY(v)   (((v) << 11) & BM_I2C_STAT_BUS_BUSY)
#define BV_I2C_STAT_BUS_BUSY__IDLE  0x0
#define BV_I2C_STAT_BUS_BUSY__BUSY  0x1

/* --- Register HW_I2C_STAT, field CLK_GEN_BUSY */

#define BP_I2C_STAT_CLK_GEN_BUSY      10
#define BM_I2C_STAT_CLK_GEN_BUSY      0x00000400

#define BF_I2C_STAT_CLK_GEN_BUSY(v)   (((v) << 10) & BM_I2C_STAT_CLK_GEN_BUSY)
#define BV_I2C_STAT_CLK_GEN_BUSY__IDLE  0x0
#define BV_I2C_STAT_CLK_GEN_BUSY__BUSY  0x1

/* --- Register HW_I2C_STAT, field DATA_ENGINE_BUSY */

#define BP_I2C_STAT_DATA_ENGINE_BUSY      9
#define BM_I2C_STAT_DATA_ENGINE_BUSY      0x00000200

#define BF_I2C_STAT_DATA_ENGINE_BUSY(v)   (((v) << 9) & BM_I2C_STAT_DATA_ENGINE_BUSY)
#define BV_I2C_STAT_DATA_ENGINE_BUSY__IDLE  0x0
#define BV_I2C_STAT_DATA_ENGINE_BUSY__BUSY  0x1

/* --- Register HW_I2C_STAT, field SLAVE_BUSY */

#define BP_I2C_STAT_SLAVE_BUSY      8
#define BM_I2C_STAT_SLAVE_BUSY      0x00000100

#define BF_I2C_STAT_SLAVE_BUSY(v)   (((v) << 8) & BM_I2C_STAT_SLAVE_BUSY)
#define BV_I2C_STAT_SLAVE_BUSY__IDLE  0x0
#define BV_I2C_STAT_SLAVE_BUSY__BUSY  0x1

/* --- Register HW_I2C_STAT, field BUS_FREE_IRQ_SUMMARY */

#define BP_I2C_STAT_BUS_FREE_IRQ_SUMMARY      7
#define BM_I2C_STAT_BUS_FREE_IRQ_SUMMARY      0x00000080

#define BF_I2C_STAT_BUS_FREE_IRQ_SUMMARY(v)   (((v) << 7) & BM_I2C_STAT_BUS_FREE_IRQ_SUMMARY)
#define BV_I2C_STAT_BUS_FREE_IRQ_SUMMARY__NO_REQUEST  0x0
#define BV_I2C_STAT_BUS_FREE_IRQ_SUMMARY__REQUEST     0x1

/* --- Register HW_I2C_STAT, field DATA_ENGINE_CMPLT_IRQ_SUMMARY */

#define BP_I2C_STAT_DATA_ENGINE_CMPLT_IRQ_SUMMARY      6
#define BM_I2C_STAT_DATA_ENGINE_CMPLT_IRQ_SUMMARY      0x00000040

#define BF_I2C_STAT_DATA_ENGINE_CMPLT_IRQ_SUMMARY(v)   (((v) << 6) & BM_I2C_STAT_DATA_ENGINE_CMPLT_IRQ_SUMMARY)
#define BV_I2C_STAT_DATA_ENGINE_CMPLT_IRQ_SUMMARY__NO_REQUEST  0x0
#define BV_I2C_STAT_DATA_ENGINE_CMPLT_IRQ_SUMMARY__REQUEST     0x1

/* --- Register HW_I2C_STAT, field NO_SLAVE_ACK_IRQ_SUMMARY */

#define BP_I2C_STAT_NO_SLAVE_ACK_IRQ_SUMMARY      5
#define BM_I2C_STAT_NO_SLAVE_ACK_IRQ_SUMMARY      0x00000020

#define BF_I2C_STAT_NO_SLAVE_ACK_IRQ_SUMMARY(v)   (((v) << 5) & BM_I2C_STAT_NO_SLAVE_ACK_IRQ_SUMMARY)
#define BV_I2C_STAT_NO_SLAVE_ACK_IRQ_SUMMARY__NO_REQUEST  0x0
#define BV_I2C_STAT_NO_SLAVE_ACK_IRQ_SUMMARY__REQUEST     0x1

/* --- Register HW_I2C_STAT, field OVERSIZE_XFER_TERM_IRQ_SUMMARY */

#define BP_I2C_STAT_OVERSIZE_XFER_TERM_IRQ_SUMMARY      4
#define BM_I2C_STAT_OVERSIZE_XFER_TERM_IRQ_SUMMARY      0x00000010

#define BF_I2C_STAT_OVERSIZE_XFER_TERM_IRQ_SUMMARY(v)   (((v) << 4) & BM_I2C_STAT_OVERSIZE_XFER_TERM_IRQ_SUMMARY)
#define BV_I2C_STAT_OVERSIZE_XFER_TERM_IRQ_SUMMARY__NO_REQUEST  0x0
#define BV_I2C_STAT_OVERSIZE_XFER_TERM_IRQ_SUMMARY__REQUEST     0x1

/* --- Register HW_I2C_STAT, field EARLY_TERM_IRQ_SUMMARY */

#define BP_I2C_STAT_EARLY_TERM_IRQ_SUMMARY      3
#define BM_I2C_STAT_EARLY_TERM_IRQ_SUMMARY      0x00000008

#define BF_I2C_STAT_EARLY_TERM_IRQ_SUMMARY(v)   (((v) << 3) & BM_I2C_STAT_EARLY_TERM_IRQ_SUMMARY)
#define BV_I2C_STAT_EARLY_TERM_IRQ_SUMMARY__NO_REQUEST  0x0
#define BV_I2C_STAT_EARLY_TERM_IRQ_SUMMARY__REQUEST     0x1

/* --- Register HW_I2C_STAT, field MASTER_LOSS_IRQ_SUMMARY */

#define BP_I2C_STAT_MASTER_LOSS_IRQ_SUMMARY      2
#define BM_I2C_STAT_MASTER_LOSS_IRQ_SUMMARY      0x00000004

#define BF_I2C_STAT_MASTER_LOSS_IRQ_SUMMARY(v)   (((v) << 2) & BM_I2C_STAT_MASTER_LOSS_IRQ_SUMMARY)
#define BV_I2C_STAT_MASTER_LOSS_IRQ_SUMMARY__NO_REQUEST  0x0
#define BV_I2C_STAT_MASTER_LOSS_IRQ_SUMMARY__REQUEST     0x1

/* --- Register HW_I2C_STAT, field SLAVE_STOP_IRQ_SUMMARY */

#define BP_I2C_STAT_SLAVE_STOP_IRQ_SUMMARY      1
#define BM_I2C_STAT_SLAVE_STOP_IRQ_SUMMARY      0x00000002

#define BF_I2C_STAT_SLAVE_STOP_IRQ_SUMMARY(v)   (((v) << 1) & BM_I2C_STAT_SLAVE_STOP_IRQ_SUMMARY)
#define BV_I2C_STAT_SLAVE_STOP_IRQ_SUMMARY__NO_REQUEST  0x0
#define BV_I2C_STAT_SLAVE_STOP_IRQ_SUMMARY__REQUEST     0x1

/* --- Register HW_I2C_STAT, field SLAVE_IRQ_SUMMARY */

#define BP_I2C_STAT_SLAVE_IRQ_SUMMARY      0
#define BM_I2C_STAT_SLAVE_IRQ_SUMMARY      0x00000001

#define BF_I2C_STAT_SLAVE_IRQ_SUMMARY(v)   (((v) << 0) & BM_I2C_STAT_SLAVE_IRQ_SUMMARY)
#define BV_I2C_STAT_SLAVE_IRQ_SUMMARY__NO_REQUEST  0x0
#define BV_I2C_STAT_SLAVE_IRQ_SUMMARY__REQUEST     0x1



/*
 * HW_I2C_QUEUECTRL - I2C Queue control reg.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned WR_QUEUE_IRQ_EN  :  1;
        unsigned RD_QUEUE_IRQ_EN  :  1;
        unsigned PIO_QUEUE_MODE   :  1;
        unsigned WR_CLEAR         :  1;
        unsigned RD_CLEAR         :  1;
        unsigned QUEUE_RUN        :  1;
        unsigned RSVD1            :  2;
        unsigned WR_THRESH        :  5;
        unsigned RSVD2            :  3;
        unsigned RD_THRESH        :  5;
        unsigned RSVD3            : 11;
    } B;
} hw_i2c_queuectrl_t;
#endif

/*
 * constants & macros for entire multi-block HW_I2C_QUEUECTRL register
 */
#define HW_I2C_QUEUECTRL_ADDR(x)      (REGS_I2C_BASE(x) + 0x60)
#define HW_I2C_QUEUECTRL_SET_ADDR(x)  (HW_I2C_QUEUECTRL_ADDR(x) + 4)
#define HW_I2C_QUEUECTRL_CLR_ADDR(x)  (HW_I2C_QUEUECTRL_ADDR(x) + 8)
#define HW_I2C_QUEUECTRL_TOG_ADDR(x)  (HW_I2C_QUEUECTRL_ADDR(x) + 12)

#ifndef __LANGUAGE_ASM__
#define HW_I2C_QUEUECTRL(x)           (*(volatile hw_i2c_queuectrl_t *) HW_I2C_QUEUECTRL_ADDR(x))
#define HW_I2C_QUEUECTRL_RD(x)      (HW_I2C_QUEUECTRL(x).U)
#define HW_I2C_QUEUECTRL_WR(x, v)     (HW_I2C_QUEUECTRL(x).U = (v))
#define HW_I2C_QUEUECTRL_SET(x, v)    ((*(volatile reg32_t *) HW_I2C_QUEUECTRL_SET_ADDR(x)) = (v))
#define HW_I2C_QUEUECTRL_CLR(x, v)    ((*(volatile reg32_t *) HW_I2C_QUEUECTRL_CLR_ADDR(x)) = (v))
#define HW_I2C_QUEUECTRL_TOG(x, v)    ((*(volatile reg32_t *) HW_I2C_QUEUECTRL_TOG_ADDR(x)) = (v))
#endif


/*
 * constants & macros for individual HW_I2C_QUEUECTRL bitfields
 */
/* --- Register HW_I2C_QUEUECTRL, field RSVD3 */

#define BP_I2C_QUEUECTRL_RSVD3      21
#define BM_I2C_QUEUECTRL_RSVD3      0xFFE00000

#ifndef __LANGUAGE_ASM__
#define BF_I2C_QUEUECTRL_RSVD3(v)   ((((reg32_t) v) << 21) & BM_I2C_QUEUECTRL_RSVD3)
#else
#define BF_I2C_QUEUECTRL_RSVD3(v)   (((v) << 21) & BM_I2C_QUEUECTRL_RSVD3)
#endif
/* --- Register HW_I2C_QUEUECTRL, field RD_THRESH */

#define BP_I2C_QUEUECTRL_RD_THRESH      16
#define BM_I2C_QUEUECTRL_RD_THRESH      0x001F0000

#define BF_I2C_QUEUECTRL_RD_THRESH(v)   (((v) << 16) & BM_I2C_QUEUECTRL_RD_THRESH)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_QUEUECTRL_RD_THRESH(n, v)   BFn_CS1(I2C_QUEUECTRL, n, RD_THRESH, v)
#endif

/* --- Register HW_I2C_QUEUECTRL, field RSVD2 */

#define BP_I2C_QUEUECTRL_RSVD2      13
#define BM_I2C_QUEUECTRL_RSVD2      0x0000E000

#define BF_I2C_QUEUECTRL_RSVD2(v)   (((v) << 13) & BM_I2C_QUEUECTRL_RSVD2)
/* --- Register HW_I2C_QUEUECTRL, field WR_THRESH */

#define BP_I2C_QUEUECTRL_WR_THRESH      8
#define BM_I2C_QUEUECTRL_WR_THRESH      0x00001F00

#define BF_I2C_QUEUECTRL_WR_THRESH(v)   (((v) << 8) & BM_I2C_QUEUECTRL_WR_THRESH)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_QUEUECTRL_WR_THRESH(n, v)   BFn_CS1(I2C_QUEUECTRL, n, WR_THRESH, v)
#endif

/* --- Register HW_I2C_QUEUECTRL, field RSVD1 */

#define BP_I2C_QUEUECTRL_RSVD1      6
#define BM_I2C_QUEUECTRL_RSVD1      0x000000C0

#define BF_I2C_QUEUECTRL_RSVD1(v)   (((v) << 6) & BM_I2C_QUEUECTRL_RSVD1)
/* --- Register HW_I2C_QUEUECTRL, field QUEUE_RUN */

#define BP_I2C_QUEUECTRL_QUEUE_RUN      5
#define BM_I2C_QUEUECTRL_QUEUE_RUN      0x00000020

#define BF_I2C_QUEUECTRL_QUEUE_RUN(v)   (((v) << 5) & BM_I2C_QUEUECTRL_QUEUE_RUN)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_QUEUECTRL_QUEUE_RUN(n, v)   BFn_CS1(I2C_QUEUECTRL, n, QUEUE_RUN, v)
#endif

#define BV_I2C_QUEUECTRL_QUEUE_RUN__STOP   0x0
#define BV_I2C_QUEUECTRL_QUEUE_RUN__START  0x1

/* --- Register HW_I2C_QUEUECTRL, field RD_CLEAR */

#define BP_I2C_QUEUECTRL_RD_CLEAR      4
#define BM_I2C_QUEUECTRL_RD_CLEAR      0x00000010

#define BF_I2C_QUEUECTRL_RD_CLEAR(v)   (((v) << 4) & BM_I2C_QUEUECTRL_RD_CLEAR)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_QUEUECTRL_RD_CLEAR(n, v)   BFn_CS1(I2C_QUEUECTRL, n, RD_CLEAR, v)
#endif

/* --- Register HW_I2C_QUEUECTRL, field WR_CLEAR */

#define BP_I2C_QUEUECTRL_WR_CLEAR      3
#define BM_I2C_QUEUECTRL_WR_CLEAR      0x00000008

#define BF_I2C_QUEUECTRL_WR_CLEAR(v)   (((v) << 3) & BM_I2C_QUEUECTRL_WR_CLEAR)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_QUEUECTRL_WR_CLEAR(n, v)   BFn_CS1(I2C_QUEUECTRL, n, WR_CLEAR, v)
#endif

/* --- Register HW_I2C_QUEUECTRL, field PIO_QUEUE_MODE */

#define BP_I2C_QUEUECTRL_PIO_QUEUE_MODE      2
#define BM_I2C_QUEUECTRL_PIO_QUEUE_MODE      0x00000004

#define BF_I2C_QUEUECTRL_PIO_QUEUE_MODE(v)   (((v) << 2) & BM_I2C_QUEUECTRL_PIO_QUEUE_MODE)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_QUEUECTRL_PIO_QUEUE_MODE(n, v)   BFn_CS1(I2C_QUEUECTRL, n, PIO_QUEUE_MODE, v)
#endif

/* --- Register HW_I2C_QUEUECTRL, field RD_QUEUE_IRQ_EN */

#define BP_I2C_QUEUECTRL_RD_QUEUE_IRQ_EN      1
#define BM_I2C_QUEUECTRL_RD_QUEUE_IRQ_EN      0x00000002

#define BF_I2C_QUEUECTRL_RD_QUEUE_IRQ_EN(v)   (((v) << 1) & BM_I2C_QUEUECTRL_RD_QUEUE_IRQ_EN)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_QUEUECTRL_RD_QUEUE_IRQ_EN(n, v)   BFn_CS1(I2C_QUEUECTRL, n, RD_QUEUE_IRQ_EN, v)
#endif

#define BV_I2C_QUEUECTRL_RD_QUEUE_IRQ_EN__DISABLED  0x0
#define BV_I2C_QUEUECTRL_RD_QUEUE_IRQ_EN__ENABLED   0x1

/* --- Register HW_I2C_QUEUECTRL, field WR_QUEUE_IRQ_EN */

#define BP_I2C_QUEUECTRL_WR_QUEUE_IRQ_EN      0
#define BM_I2C_QUEUECTRL_WR_QUEUE_IRQ_EN      0x00000001

#define BF_I2C_QUEUECTRL_WR_QUEUE_IRQ_EN(v)   (((v) << 0) & BM_I2C_QUEUECTRL_WR_QUEUE_IRQ_EN)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_QUEUECTRL_WR_QUEUE_IRQ_EN(n, v)   BFn_CS1(I2C_QUEUECTRL, n, WR_QUEUE_IRQ_EN, v)
#endif

#define BV_I2C_QUEUECTRL_WR_QUEUE_IRQ_EN__DISABLED  0x0
#define BV_I2C_QUEUECTRL_WR_QUEUE_IRQ_EN__ENABLED   0x1



/*
 * HW_I2C_QUEUESTAT - I2C Queue Status Register.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned WR_QUEUE_CNT    :  5;
        unsigned WR_QUEUE_EMPTY  :  1;
        unsigned WR_QUEUE_FULL   :  1;
        unsigned RSVD1           :  1;
        unsigned RD_QUEUE_CNT    :  5;
        unsigned RD_QUEUE_EMPTY  :  1;
        unsigned RD_QUEUE_FULL   :  1;
        unsigned RSVD2           : 17;
    } B;
} hw_i2c_queuestat_t;
#endif

/*
 * constants & macros for entire multi-block HW_I2C_QUEUESTAT register
 */
#define HW_I2C_QUEUESTAT_ADDR(x)      (REGS_I2C_BASE(x) + 0x70)

#ifndef __LANGUAGE_ASM__
#define HW_I2C_QUEUESTAT(x)           (*(volatile hw_i2c_queuestat_t *) HW_I2C_QUEUESTAT_ADDR(x))
#define HW_I2C_QUEUESTAT_RD(x)      (HW_I2C_QUEUESTAT(x).U)
#endif


/*
 * constants & macros for individual HW_I2C_QUEUESTAT bitfields
 */
/* --- Register HW_I2C_QUEUESTAT, field RSVD2 */

#define BP_I2C_QUEUESTAT_RSVD2      15
#define BM_I2C_QUEUESTAT_RSVD2      0xFFFF8000

#ifndef __LANGUAGE_ASM__
#define BF_I2C_QUEUESTAT_RSVD2(v)   ((((reg32_t) v) << 15) & BM_I2C_QUEUESTAT_RSVD2)
#else
#define BF_I2C_QUEUESTAT_RSVD2(v)   (((v) << 15) & BM_I2C_QUEUESTAT_RSVD2)
#endif
/* --- Register HW_I2C_QUEUESTAT, field RD_QUEUE_FULL */

#define BP_I2C_QUEUESTAT_RD_QUEUE_FULL      14
#define BM_I2C_QUEUESTAT_RD_QUEUE_FULL      0x00004000

#define BF_I2C_QUEUESTAT_RD_QUEUE_FULL(v)   (((v) << 14) & BM_I2C_QUEUESTAT_RD_QUEUE_FULL)
/* --- Register HW_I2C_QUEUESTAT, field RD_QUEUE_EMPTY */

#define BP_I2C_QUEUESTAT_RD_QUEUE_EMPTY      13
#define BM_I2C_QUEUESTAT_RD_QUEUE_EMPTY      0x00002000

#define BF_I2C_QUEUESTAT_RD_QUEUE_EMPTY(v)   (((v) << 13) & BM_I2C_QUEUESTAT_RD_QUEUE_EMPTY)
/* --- Register HW_I2C_QUEUESTAT, field RD_QUEUE_CNT */

#define BP_I2C_QUEUESTAT_RD_QUEUE_CNT      8
#define BM_I2C_QUEUESTAT_RD_QUEUE_CNT      0x00001F00

#define BF_I2C_QUEUESTAT_RD_QUEUE_CNT(v)   (((v) << 8) & BM_I2C_QUEUESTAT_RD_QUEUE_CNT)
/* --- Register HW_I2C_QUEUESTAT, field RSVD1 */

#define BP_I2C_QUEUESTAT_RSVD1      7
#define BM_I2C_QUEUESTAT_RSVD1      0x00000080

#define BF_I2C_QUEUESTAT_RSVD1(v)   (((v) << 7) & BM_I2C_QUEUESTAT_RSVD1)
/* --- Register HW_I2C_QUEUESTAT, field WR_QUEUE_FULL */

#define BP_I2C_QUEUESTAT_WR_QUEUE_FULL      6
#define BM_I2C_QUEUESTAT_WR_QUEUE_FULL      0x00000040

#define BF_I2C_QUEUESTAT_WR_QUEUE_FULL(v)   (((v) << 6) & BM_I2C_QUEUESTAT_WR_QUEUE_FULL)
/* --- Register HW_I2C_QUEUESTAT, field WR_QUEUE_EMPTY */

#define BP_I2C_QUEUESTAT_WR_QUEUE_EMPTY      5
#define BM_I2C_QUEUESTAT_WR_QUEUE_EMPTY      0x00000020

#define BF_I2C_QUEUESTAT_WR_QUEUE_EMPTY(v)   (((v) << 5) & BM_I2C_QUEUESTAT_WR_QUEUE_EMPTY)
/* --- Register HW_I2C_QUEUESTAT, field WR_QUEUE_CNT */

#define BP_I2C_QUEUESTAT_WR_QUEUE_CNT      0
#define BM_I2C_QUEUESTAT_WR_QUEUE_CNT      0x0000001F

#define BF_I2C_QUEUESTAT_WR_QUEUE_CNT(v)   (((v) << 0) & BM_I2C_QUEUESTAT_WR_QUEUE_CNT)


/*
 * HW_I2C_QUEUECMD - I2C Queue command reg
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned XFER_COUNT            : 16;
        unsigned DIRECTION             :  1;
        unsigned MASTER_MODE           :  1;
        unsigned SLAVE_ADDRESS_ENABLE  :  1;
        unsigned PRE_SEND_START        :  1;
        unsigned POST_SEND_STOP        :  1;
        unsigned RETAIN_CLOCK          :  1;
        unsigned CLOCK_HELD            :  1;
        unsigned MULTI_MASTER          :  1;
        unsigned RSVD1                 :  1;
        unsigned SEND_NAK_ON_LAST      :  1;
        unsigned ACKNOWLEDGE           :  1;
        unsigned PRE_ACK               :  1;
        unsigned RSVD2                 :  4;
    } B;
} hw_i2c_queuecmd_t;
#endif

/*
 * constants & macros for entire multi-block HW_I2C_QUEUECMD register
 */
#define HW_I2C_QUEUECMD_ADDR(x)      (REGS_I2C_BASE(x) + 0x80)
#define HW_I2C_QUEUECMD_SET_ADDR(x)  (HW_I2C_QUEUECMD_ADDR(x) + 4)
#define HW_I2C_QUEUECMD_CLR_ADDR(x)  (HW_I2C_QUEUECMD_ADDR(x) + 8)
#define HW_I2C_QUEUECMD_TOG_ADDR(x)  (HW_I2C_QUEUECMD_ADDR(x) + 12)

#ifndef __LANGUAGE_ASM__
#define HW_I2C_QUEUECMD(x)           (*(volatile hw_i2c_queuecmd_t *) HW_I2C_QUEUECMD_ADDR(x))
#define HW_I2C_QUEUECMD_RD(x)      (HW_I2C_QUEUECMD(x).U)
#define HW_I2C_QUEUECMD_WR(x, v)     (HW_I2C_QUEUECMD(x).U = (v))
#define HW_I2C_QUEUECMD_SET(x, v)    ((*(volatile reg32_t *) HW_I2C_QUEUECMD_SET_ADDR(x)) = (v))
#define HW_I2C_QUEUECMD_CLR(x, v)    ((*(volatile reg32_t *) HW_I2C_QUEUECMD_CLR_ADDR(x)) = (v))
#define HW_I2C_QUEUECMD_TOG(x, v)    ((*(volatile reg32_t *) HW_I2C_QUEUECMD_TOG_ADDR(x)) = (v))
#endif


/*
 * constants & macros for individual HW_I2C_QUEUECMD bitfields
 */
/* --- Register HW_I2C_QUEUECMD, field RSVD2 */

#define BP_I2C_QUEUECMD_RSVD2      28
#define BM_I2C_QUEUECMD_RSVD2      0xF0000000

#ifndef __LANGUAGE_ASM__
#define BF_I2C_QUEUECMD_RSVD2(v)   ((((reg32_t) v) << 28) & BM_I2C_QUEUECMD_RSVD2)
#else
#define BF_I2C_QUEUECMD_RSVD2(v)   (((v) << 28) & BM_I2C_QUEUECMD_RSVD2)
#endif
/* --- Register HW_I2C_QUEUECMD, field PRE_ACK */

#define BP_I2C_QUEUECMD_PRE_ACK      27
#define BM_I2C_QUEUECMD_PRE_ACK      0x08000000

#define BF_I2C_QUEUECMD_PRE_ACK(v)   (((v) << 27) & BM_I2C_QUEUECMD_PRE_ACK)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_QUEUECMD_PRE_ACK(n, v)   BFn_CS1(I2C_QUEUECMD, n, PRE_ACK, v)
#endif

/* --- Register HW_I2C_QUEUECMD, field ACKNOWLEDGE */

#define BP_I2C_QUEUECMD_ACKNOWLEDGE      26
#define BM_I2C_QUEUECMD_ACKNOWLEDGE      0x04000000

#define BF_I2C_QUEUECMD_ACKNOWLEDGE(v)   (((v) << 26) & BM_I2C_QUEUECMD_ACKNOWLEDGE)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_QUEUECMD_ACKNOWLEDGE(n, v)   BFn_CS1(I2C_QUEUECMD, n, ACKNOWLEDGE, v)
#endif

#define BV_I2C_QUEUECMD_ACKNOWLEDGE__SNAK  0x0
#define BV_I2C_QUEUECMD_ACKNOWLEDGE__ACK   0x1

/* --- Register HW_I2C_QUEUECMD, field SEND_NAK_ON_LAST */

#define BP_I2C_QUEUECMD_SEND_NAK_ON_LAST      25
#define BM_I2C_QUEUECMD_SEND_NAK_ON_LAST      0x02000000

#define BF_I2C_QUEUECMD_SEND_NAK_ON_LAST(v)   (((v) << 25) & BM_I2C_QUEUECMD_SEND_NAK_ON_LAST)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_QUEUECMD_SEND_NAK_ON_LAST(n, v)   BFn_CS1(I2C_QUEUECMD, n, SEND_NAK_ON_LAST, v)
#endif

#define BV_I2C_QUEUECMD_SEND_NAK_ON_LAST__ACK_IT  0x0
#define BV_I2C_QUEUECMD_SEND_NAK_ON_LAST__NAK_IT  0x1

/* --- Register HW_I2C_QUEUECMD, field RSVD1 */

#define BP_I2C_QUEUECMD_RSVD1      24
#define BM_I2C_QUEUECMD_RSVD1      0x01000000

#define BF_I2C_QUEUECMD_RSVD1(v)   (((v) << 24) & BM_I2C_QUEUECMD_RSVD1)
/* --- Register HW_I2C_QUEUECMD, field MULTI_MASTER */

#define BP_I2C_QUEUECMD_MULTI_MASTER      23
#define BM_I2C_QUEUECMD_MULTI_MASTER      0x00800000

#define BF_I2C_QUEUECMD_MULTI_MASTER(v)   (((v) << 23) & BM_I2C_QUEUECMD_MULTI_MASTER)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_QUEUECMD_MULTI_MASTER(n, v)   BFn_CS1(I2C_QUEUECMD, n, MULTI_MASTER, v)
#endif

#define BV_I2C_QUEUECMD_MULTI_MASTER__SINGLE    0x0
#define BV_I2C_QUEUECMD_MULTI_MASTER__MULTIPLE  0x1

/* --- Register HW_I2C_QUEUECMD, field CLOCK_HELD */

#define BP_I2C_QUEUECMD_CLOCK_HELD      22
#define BM_I2C_QUEUECMD_CLOCK_HELD      0x00400000

#define BF_I2C_QUEUECMD_CLOCK_HELD(v)   (((v) << 22) & BM_I2C_QUEUECMD_CLOCK_HELD)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_QUEUECMD_CLOCK_HELD(n, v)   BFn_CS1(I2C_QUEUECMD, n, CLOCK_HELD, v)
#endif

#define BV_I2C_QUEUECMD_CLOCK_HELD__RELEASE   0x0
#define BV_I2C_QUEUECMD_CLOCK_HELD__HELD_LOW  0x1

/* --- Register HW_I2C_QUEUECMD, field RETAIN_CLOCK */

#define BP_I2C_QUEUECMD_RETAIN_CLOCK      21
#define BM_I2C_QUEUECMD_RETAIN_CLOCK      0x00200000

#define BF_I2C_QUEUECMD_RETAIN_CLOCK(v)   (((v) << 21) & BM_I2C_QUEUECMD_RETAIN_CLOCK)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_QUEUECMD_RETAIN_CLOCK(n, v)   BFn_CS1(I2C_QUEUECMD, n, RETAIN_CLOCK, v)
#endif

#define BV_I2C_QUEUECMD_RETAIN_CLOCK__RELEASE   0x0
#define BV_I2C_QUEUECMD_RETAIN_CLOCK__HOLD_LOW  0x1

/* --- Register HW_I2C_QUEUECMD, field POST_SEND_STOP */

#define BP_I2C_QUEUECMD_POST_SEND_STOP      20
#define BM_I2C_QUEUECMD_POST_SEND_STOP      0x00100000

#define BF_I2C_QUEUECMD_POST_SEND_STOP(v)   (((v) << 20) & BM_I2C_QUEUECMD_POST_SEND_STOP)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_QUEUECMD_POST_SEND_STOP(n, v)   BFn_CS1(I2C_QUEUECMD, n, POST_SEND_STOP, v)
#endif

#define BV_I2C_QUEUECMD_POST_SEND_STOP__NO_STOP    0x0
#define BV_I2C_QUEUECMD_POST_SEND_STOP__SEND_STOP  0x1

/* --- Register HW_I2C_QUEUECMD, field PRE_SEND_START */

#define BP_I2C_QUEUECMD_PRE_SEND_START      19
#define BM_I2C_QUEUECMD_PRE_SEND_START      0x00080000

#define BF_I2C_QUEUECMD_PRE_SEND_START(v)   (((v) << 19) & BM_I2C_QUEUECMD_PRE_SEND_START)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_QUEUECMD_PRE_SEND_START(n, v)   BFn_CS1(I2C_QUEUECMD, n, PRE_SEND_START, v)
#endif

#define BV_I2C_QUEUECMD_PRE_SEND_START__NO_START    0x0
#define BV_I2C_QUEUECMD_PRE_SEND_START__SEND_START  0x1

/* --- Register HW_I2C_QUEUECMD, field SLAVE_ADDRESS_ENABLE */

#define BP_I2C_QUEUECMD_SLAVE_ADDRESS_ENABLE      18
#define BM_I2C_QUEUECMD_SLAVE_ADDRESS_ENABLE      0x00040000

#define BF_I2C_QUEUECMD_SLAVE_ADDRESS_ENABLE(v)   (((v) << 18) & BM_I2C_QUEUECMD_SLAVE_ADDRESS_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_QUEUECMD_SLAVE_ADDRESS_ENABLE(n, v)   BFn_CS1(I2C_QUEUECMD, n, SLAVE_ADDRESS_ENABLE, v)
#endif

#define BV_I2C_QUEUECMD_SLAVE_ADDRESS_ENABLE__DISABLED  0x0
#define BV_I2C_QUEUECMD_SLAVE_ADDRESS_ENABLE__ENABLED   0x1

/* --- Register HW_I2C_QUEUECMD, field MASTER_MODE */

#define BP_I2C_QUEUECMD_MASTER_MODE      17
#define BM_I2C_QUEUECMD_MASTER_MODE      0x00020000

#define BF_I2C_QUEUECMD_MASTER_MODE(v)   (((v) << 17) & BM_I2C_QUEUECMD_MASTER_MODE)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_QUEUECMD_MASTER_MODE(n, v)   BFn_CS1(I2C_QUEUECMD, n, MASTER_MODE, v)
#endif

#define BV_I2C_QUEUECMD_MASTER_MODE__SLAVE   0x0
#define BV_I2C_QUEUECMD_MASTER_MODE__MASTER  0x1

/* --- Register HW_I2C_QUEUECMD, field DIRECTION */

#define BP_I2C_QUEUECMD_DIRECTION      16
#define BM_I2C_QUEUECMD_DIRECTION      0x00010000

#define BF_I2C_QUEUECMD_DIRECTION(v)   (((v) << 16) & BM_I2C_QUEUECMD_DIRECTION)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_QUEUECMD_DIRECTION(n, v)   BFn_CS1(I2C_QUEUECMD, n, DIRECTION, v)
#endif

#define BV_I2C_QUEUECMD_DIRECTION__RECEIVE   0x0
#define BV_I2C_QUEUECMD_DIRECTION__TRANSMIT  0x1

/* --- Register HW_I2C_QUEUECMD, field XFER_COUNT */

#define BP_I2C_QUEUECMD_XFER_COUNT      0
#define BM_I2C_QUEUECMD_XFER_COUNT      0x0000FFFF

#define BF_I2C_QUEUECMD_XFER_COUNT(v)   (((v) << 0) & BM_I2C_QUEUECMD_XFER_COUNT)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_QUEUECMD_XFER_COUNT(n, v)   (HW_I2C_QUEUECMD(n).B.XFER_COUNT = (v))
#endif



/*
 * HW_I2C_QUEUEDATA - I2C Controller Read Data Register for queue mode only.
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DATA  : 32;
    } B;
} hw_i2c_queuedata_t;
#endif

/*
 * constants & macros for entire multi-block HW_I2C_QUEUEDATA register
 */
#define HW_I2C_QUEUEDATA_ADDR(x)      (REGS_I2C_BASE(x) + 0x90)

#ifndef __LANGUAGE_ASM__
#define HW_I2C_QUEUEDATA(x)           (*(volatile hw_i2c_queuedata_t *) HW_I2C_QUEUEDATA_ADDR(x))
#define HW_I2C_QUEUEDATA_RD(x)      (HW_I2C_QUEUEDATA(x).U)
#endif


/*
 * constants & macros for individual HW_I2C_QUEUEDATA bitfields
 */
/* --- Register HW_I2C_QUEUEDATA, field DATA */

#define BP_I2C_QUEUEDATA_DATA      0
#define BM_I2C_QUEUEDATA_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_I2C_QUEUEDATA_DATA(v)   ((reg32_t) v)
#else
#define BF_I2C_QUEUEDATA_DATA(v)   (v)
#endif


/*
 * HW_I2C_DATA - I2C Controller DMA Read and Write Data Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DATA  : 32;
    } B;
} hw_i2c_data_t;
#endif

/*
 * constants & macros for entire multi-block HW_I2C_DATA register
 */
#define HW_I2C_DATA_ADDR(x)      (REGS_I2C_BASE(x) + 0xa0)

#ifndef __LANGUAGE_ASM__
#define HW_I2C_DATA(x)           (*(volatile hw_i2c_data_t *) HW_I2C_DATA_ADDR(x))
#define HW_I2C_DATA_RD(x)      (HW_I2C_DATA(x).U)
#define HW_I2C_DATA_WR(x, v)     (HW_I2C_DATA(x).U = (v))
#define HW_I2C_DATA_SET(x, v)    (HW_I2C_DATA_WR(x, HW_I2C_DATA_RD(x) |  (v)))
#define HW_I2C_DATA_CLR(x, v)    (HW_I2C_DATA_WR(x, HW_I2C_DATA_RD(x) & ~(v)))
#define HW_I2C_DATA_TOG(x, v)    (HW_I2C_DATA_WR(x, HW_I2C_DATA_RD(x) ^  (v)))
#endif


/*
 * constants & macros for individual HW_I2C_DATA bitfields
 */
/* --- Register HW_I2C_DATA, field DATA */

#define BP_I2C_DATA_DATA      0
#define BM_I2C_DATA_DATA      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_I2C_DATA_DATA(v)   ((reg32_t) v)
#else
#define BF_I2C_DATA_DATA(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_I2C_DATA_DATA(n, v)   (HW_I2C_DATA(n).B.DATA = (v))
#endif



/*
 * HW_I2C_DEBUG0 - I2C Device Debug Register 0
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned SLAVE_STATE     : 10;
        unsigned SLAVE_HOLD_CLK  :  1;
        unsigned STATE_LATCH     :  1;
        unsigned CHANGE_TOGGLE   :  1;
        unsigned GRAB_TOGGLE     :  1;
        unsigned STOP_TOGGLE     :  1;
        unsigned START_TOGGLE    :  1;
        unsigned DMA_STATE       : 10;
        unsigned STATE_VALUE     :  2;
        unsigned DMATERMINATE    :  1;
        unsigned DMAKICK         :  1;
        unsigned DMAENDCMD       :  1;
        unsigned DMAREQ          :  1;
    } B;
} hw_i2c_debug0_t;
#endif

/*
 * constants & macros for entire multi-block HW_I2C_DEBUG0 register
 */
#define HW_I2C_DEBUG0_ADDR(x)      (REGS_I2C_BASE(x) + 0xb0)
#define HW_I2C_DEBUG0_SET_ADDR(x)  (HW_I2C_DEBUG0_ADDR(x) + 4)
#define HW_I2C_DEBUG0_CLR_ADDR(x)  (HW_I2C_DEBUG0_ADDR(x) + 8)
#define HW_I2C_DEBUG0_TOG_ADDR(x)  (HW_I2C_DEBUG0_ADDR(x) + 12)

#ifndef __LANGUAGE_ASM__
#define HW_I2C_DEBUG0(x)           (*(volatile hw_i2c_debug0_t *) HW_I2C_DEBUG0_ADDR(x))
#define HW_I2C_DEBUG0_RD(x)      (HW_I2C_DEBUG0(x).U)
#define HW_I2C_DEBUG0_WR(x, v)     (HW_I2C_DEBUG0(x).U = (v))
#define HW_I2C_DEBUG0_SET(x, v)    ((*(volatile reg32_t *) HW_I2C_DEBUG0_SET_ADDR(x)) = (v))
#define HW_I2C_DEBUG0_CLR(x, v)    ((*(volatile reg32_t *) HW_I2C_DEBUG0_CLR_ADDR(x)) = (v))
#define HW_I2C_DEBUG0_TOG(x, v)    ((*(volatile reg32_t *) HW_I2C_DEBUG0_TOG_ADDR(x)) = (v))
#endif


/*
 * constants & macros for individual HW_I2C_DEBUG0 bitfields
 */
/* --- Register HW_I2C_DEBUG0, field DMAREQ */

#define BP_I2C_DEBUG0_DMAREQ      31
#define BM_I2C_DEBUG0_DMAREQ      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_I2C_DEBUG0_DMAREQ(v)   ((((reg32_t) v) << 31) & BM_I2C_DEBUG0_DMAREQ)
#else
#define BF_I2C_DEBUG0_DMAREQ(v)   (((v) << 31) & BM_I2C_DEBUG0_DMAREQ)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_I2C_DEBUG0_DMAREQ(n, v)   BFn_CS1(I2C_DEBUG0, n, DMAREQ, v)
#endif

/* --- Register HW_I2C_DEBUG0, field DMAENDCMD */

#define BP_I2C_DEBUG0_DMAENDCMD      30
#define BM_I2C_DEBUG0_DMAENDCMD      0x40000000

#define BF_I2C_DEBUG0_DMAENDCMD(v)   (((v) << 30) & BM_I2C_DEBUG0_DMAENDCMD)
/* --- Register HW_I2C_DEBUG0, field DMAKICK */

#define BP_I2C_DEBUG0_DMAKICK      29
#define BM_I2C_DEBUG0_DMAKICK      0x20000000

#define BF_I2C_DEBUG0_DMAKICK(v)   (((v) << 29) & BM_I2C_DEBUG0_DMAKICK)
/* --- Register HW_I2C_DEBUG0, field DMATERMINATE */

#define BP_I2C_DEBUG0_DMATERMINATE      28
#define BM_I2C_DEBUG0_DMATERMINATE      0x10000000

#define BF_I2C_DEBUG0_DMATERMINATE(v)   (((v) << 28) & BM_I2C_DEBUG0_DMATERMINATE)
/* --- Register HW_I2C_DEBUG0, field STATE_VALUE */

#define BP_I2C_DEBUG0_STATE_VALUE      26
#define BM_I2C_DEBUG0_STATE_VALUE      0x0C000000

#define BF_I2C_DEBUG0_STATE_VALUE(v)   (((v) << 26) & BM_I2C_DEBUG0_STATE_VALUE)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_DEBUG0_STATE_VALUE(n, v)   BFn_CS1(I2C_DEBUG0, n, STATE_VALUE, v)
#endif

/* --- Register HW_I2C_DEBUG0, field DMA_STATE */

#define BP_I2C_DEBUG0_DMA_STATE      16
#define BM_I2C_DEBUG0_DMA_STATE      0x03FF0000

#define BF_I2C_DEBUG0_DMA_STATE(v)   (((v) << 16) & BM_I2C_DEBUG0_DMA_STATE)
/* --- Register HW_I2C_DEBUG0, field START_TOGGLE */

#define BP_I2C_DEBUG0_START_TOGGLE      15
#define BM_I2C_DEBUG0_START_TOGGLE      0x00008000

#define BF_I2C_DEBUG0_START_TOGGLE(v)   (((v) << 15) & BM_I2C_DEBUG0_START_TOGGLE)
/* --- Register HW_I2C_DEBUG0, field STOP_TOGGLE */

#define BP_I2C_DEBUG0_STOP_TOGGLE      14
#define BM_I2C_DEBUG0_STOP_TOGGLE      0x00004000

#define BF_I2C_DEBUG0_STOP_TOGGLE(v)   (((v) << 14) & BM_I2C_DEBUG0_STOP_TOGGLE)
/* --- Register HW_I2C_DEBUG0, field GRAB_TOGGLE */

#define BP_I2C_DEBUG0_GRAB_TOGGLE      13
#define BM_I2C_DEBUG0_GRAB_TOGGLE      0x00002000

#define BF_I2C_DEBUG0_GRAB_TOGGLE(v)   (((v) << 13) & BM_I2C_DEBUG0_GRAB_TOGGLE)
/* --- Register HW_I2C_DEBUG0, field CHANGE_TOGGLE */

#define BP_I2C_DEBUG0_CHANGE_TOGGLE      12
#define BM_I2C_DEBUG0_CHANGE_TOGGLE      0x00001000

#define BF_I2C_DEBUG0_CHANGE_TOGGLE(v)   (((v) << 12) & BM_I2C_DEBUG0_CHANGE_TOGGLE)
/* --- Register HW_I2C_DEBUG0, field STATE_LATCH */

#define BP_I2C_DEBUG0_STATE_LATCH      11
#define BM_I2C_DEBUG0_STATE_LATCH      0x00000800

#define BF_I2C_DEBUG0_STATE_LATCH(v)   (((v) << 11) & BM_I2C_DEBUG0_STATE_LATCH)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_DEBUG0_STATE_LATCH(n, v)   BFn_CS1(I2C_DEBUG0, n, STATE_LATCH, v)
#endif

/* --- Register HW_I2C_DEBUG0, field SLAVE_HOLD_CLK */

#define BP_I2C_DEBUG0_SLAVE_HOLD_CLK      10
#define BM_I2C_DEBUG0_SLAVE_HOLD_CLK      0x00000400

#define BF_I2C_DEBUG0_SLAVE_HOLD_CLK(v)   (((v) << 10) & BM_I2C_DEBUG0_SLAVE_HOLD_CLK)
/* --- Register HW_I2C_DEBUG0, field SLAVE_STATE */

#define BP_I2C_DEBUG0_SLAVE_STATE      0
#define BM_I2C_DEBUG0_SLAVE_STATE      0x000003FF

#define BF_I2C_DEBUG0_SLAVE_STATE(v)   (((v) << 0) & BM_I2C_DEBUG0_SLAVE_STATE)


/*
 * HW_I2C_DEBUG1 - I2C Device Debug Register 1
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned FORCE_I2C_CLK_OE   :  1;
        unsigned FORCE_I2C_DATA_OE  :  1;
        unsigned FORCE_RCV_ACK      :  1;
        unsigned FORCE_ARB_LOSS     :  1;
        unsigned FORCE_CLK_ON       :  1;
        unsigned RSVD1              :  3;
        unsigned LOCAL_SLAVE_TEST   :  1;
        unsigned LST_MODE           :  2;
        unsigned RSVD2              :  5;
        unsigned CLK_GEN_STATE      :  8;
        unsigned DMA_BYTE_ENABLES   :  4;
        unsigned RSVD4              :  2;
        unsigned I2C_DATA_IN        :  1;
        unsigned I2C_CLK_IN         :  1;
    } B;
} hw_i2c_debug1_t;
#endif

/*
 * constants & macros for entire multi-block HW_I2C_DEBUG1 register
 */
#define HW_I2C_DEBUG1_ADDR(x)      (REGS_I2C_BASE(x) + 0xc0)
#define HW_I2C_DEBUG1_SET_ADDR(x)  (HW_I2C_DEBUG1_ADDR(x) + 4)
#define HW_I2C_DEBUG1_CLR_ADDR(x)  (HW_I2C_DEBUG1_ADDR(x) + 8)
#define HW_I2C_DEBUG1_TOG_ADDR(x)  (HW_I2C_DEBUG1_ADDR(x) + 12)

#ifndef __LANGUAGE_ASM__
#define HW_I2C_DEBUG1(x)           (*(volatile hw_i2c_debug1_t *) HW_I2C_DEBUG1_ADDR(x))
#define HW_I2C_DEBUG1_RD(x)      (HW_I2C_DEBUG1(x).U)
#define HW_I2C_DEBUG1_WR(x, v)     (HW_I2C_DEBUG1(x).U = (v))
#define HW_I2C_DEBUG1_SET(x, v)    ((*(volatile reg32_t *) HW_I2C_DEBUG1_SET_ADDR(x)) = (v))
#define HW_I2C_DEBUG1_CLR(x, v)    ((*(volatile reg32_t *) HW_I2C_DEBUG1_CLR_ADDR(x)) = (v))
#define HW_I2C_DEBUG1_TOG(x, v)    ((*(volatile reg32_t *) HW_I2C_DEBUG1_TOG_ADDR(x)) = (v))
#endif


/*
 * constants & macros for individual HW_I2C_DEBUG1 bitfields
 */
/* --- Register HW_I2C_DEBUG1, field I2C_CLK_IN */

#define BP_I2C_DEBUG1_I2C_CLK_IN      31
#define BM_I2C_DEBUG1_I2C_CLK_IN      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_I2C_DEBUG1_I2C_CLK_IN(v)   ((((reg32_t) v) << 31) & BM_I2C_DEBUG1_I2C_CLK_IN)
#else
#define BF_I2C_DEBUG1_I2C_CLK_IN(v)   (((v) << 31) & BM_I2C_DEBUG1_I2C_CLK_IN)
#endif
/* --- Register HW_I2C_DEBUG1, field I2C_DATA_IN */

#define BP_I2C_DEBUG1_I2C_DATA_IN      30
#define BM_I2C_DEBUG1_I2C_DATA_IN      0x40000000

#define BF_I2C_DEBUG1_I2C_DATA_IN(v)   (((v) << 30) & BM_I2C_DEBUG1_I2C_DATA_IN)
/* --- Register HW_I2C_DEBUG1, field RSVD4 */

#define BP_I2C_DEBUG1_RSVD4      28
#define BM_I2C_DEBUG1_RSVD4      0x30000000

#define BF_I2C_DEBUG1_RSVD4(v)   (((v) << 28) & BM_I2C_DEBUG1_RSVD4)
/* --- Register HW_I2C_DEBUG1, field DMA_BYTE_ENABLES */

#define BP_I2C_DEBUG1_DMA_BYTE_ENABLES      24
#define BM_I2C_DEBUG1_DMA_BYTE_ENABLES      0x0F000000

#define BF_I2C_DEBUG1_DMA_BYTE_ENABLES(v)   (((v) << 24) & BM_I2C_DEBUG1_DMA_BYTE_ENABLES)
/* --- Register HW_I2C_DEBUG1, field CLK_GEN_STATE */

#define BP_I2C_DEBUG1_CLK_GEN_STATE      16
#define BM_I2C_DEBUG1_CLK_GEN_STATE      0x00FF0000

#define BF_I2C_DEBUG1_CLK_GEN_STATE(v)   (((v) << 16) & BM_I2C_DEBUG1_CLK_GEN_STATE)
/* --- Register HW_I2C_DEBUG1, field RSVD2 */

#define BP_I2C_DEBUG1_RSVD2      11
#define BM_I2C_DEBUG1_RSVD2      0x0000F800

#define BF_I2C_DEBUG1_RSVD2(v)   (((v) << 11) & BM_I2C_DEBUG1_RSVD2)
/* --- Register HW_I2C_DEBUG1, field LST_MODE */

#define BP_I2C_DEBUG1_LST_MODE      9
#define BM_I2C_DEBUG1_LST_MODE      0x00000600

#define BF_I2C_DEBUG1_LST_MODE(v)   (((v) << 9) & BM_I2C_DEBUG1_LST_MODE)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_DEBUG1_LST_MODE(n, v)   BFn_CS1(I2C_DEBUG1, n, LST_MODE, v)
#endif

#define BV_I2C_DEBUG1_LST_MODE__BCAST     0x0
#define BV_I2C_DEBUG1_LST_MODE__MY_WRITE  0x1
#define BV_I2C_DEBUG1_LST_MODE__MY_READ   0x2
#define BV_I2C_DEBUG1_LST_MODE__NOT_ME    0x3

/* --- Register HW_I2C_DEBUG1, field LOCAL_SLAVE_TEST */

#define BP_I2C_DEBUG1_LOCAL_SLAVE_TEST      8
#define BM_I2C_DEBUG1_LOCAL_SLAVE_TEST      0x00000100

#define BF_I2C_DEBUG1_LOCAL_SLAVE_TEST(v)   (((v) << 8) & BM_I2C_DEBUG1_LOCAL_SLAVE_TEST)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_DEBUG1_LOCAL_SLAVE_TEST(n, v)   BFn_CS1(I2C_DEBUG1, n, LOCAL_SLAVE_TEST, v)
#endif

/* --- Register HW_I2C_DEBUG1, field RSVD1 */

#define BP_I2C_DEBUG1_RSVD1      5
#define BM_I2C_DEBUG1_RSVD1      0x000000E0

#define BF_I2C_DEBUG1_RSVD1(v)   (((v) << 5) & BM_I2C_DEBUG1_RSVD1)
/* --- Register HW_I2C_DEBUG1, field FORCE_CLK_ON */

#define BP_I2C_DEBUG1_FORCE_CLK_ON      4
#define BM_I2C_DEBUG1_FORCE_CLK_ON      0x00000010

#define BF_I2C_DEBUG1_FORCE_CLK_ON(v)   (((v) << 4) & BM_I2C_DEBUG1_FORCE_CLK_ON)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_DEBUG1_FORCE_CLK_ON(n, v)   BFn_CS1(I2C_DEBUG1, n, FORCE_CLK_ON, v)
#endif

/* --- Register HW_I2C_DEBUG1, field FORCE_ARB_LOSS */

#define BP_I2C_DEBUG1_FORCE_ARB_LOSS      3
#define BM_I2C_DEBUG1_FORCE_ARB_LOSS      0x00000008

#define BF_I2C_DEBUG1_FORCE_ARB_LOSS(v)   (((v) << 3) & BM_I2C_DEBUG1_FORCE_ARB_LOSS)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_DEBUG1_FORCE_ARB_LOSS(n, v)   BFn_CS1(I2C_DEBUG1, n, FORCE_ARB_LOSS, v)
#endif

/* --- Register HW_I2C_DEBUG1, field FORCE_RCV_ACK */

#define BP_I2C_DEBUG1_FORCE_RCV_ACK      2
#define BM_I2C_DEBUG1_FORCE_RCV_ACK      0x00000004

#define BF_I2C_DEBUG1_FORCE_RCV_ACK(v)   (((v) << 2) & BM_I2C_DEBUG1_FORCE_RCV_ACK)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_DEBUG1_FORCE_RCV_ACK(n, v)   BFn_CS1(I2C_DEBUG1, n, FORCE_RCV_ACK, v)
#endif

/* --- Register HW_I2C_DEBUG1, field FORCE_I2C_DATA_OE */

#define BP_I2C_DEBUG1_FORCE_I2C_DATA_OE      1
#define BM_I2C_DEBUG1_FORCE_I2C_DATA_OE      0x00000002

#define BF_I2C_DEBUG1_FORCE_I2C_DATA_OE(v)   (((v) << 1) & BM_I2C_DEBUG1_FORCE_I2C_DATA_OE)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_DEBUG1_FORCE_I2C_DATA_OE(n, v)   BFn_CS1(I2C_DEBUG1, n, FORCE_I2C_DATA_OE, v)
#endif

/* --- Register HW_I2C_DEBUG1, field FORCE_I2C_CLK_OE */

#define BP_I2C_DEBUG1_FORCE_I2C_CLK_OE      0
#define BM_I2C_DEBUG1_FORCE_I2C_CLK_OE      0x00000001

#define BF_I2C_DEBUG1_FORCE_I2C_CLK_OE(v)   (((v) << 0) & BM_I2C_DEBUG1_FORCE_I2C_CLK_OE)
#ifndef __LANGUAGE_ASM__
#define BW_I2C_DEBUG1_FORCE_I2C_CLK_OE(n, v)   BFn_CS1(I2C_DEBUG1, n, FORCE_I2C_CLK_OE, v)
#endif



/*
 * HW_I2C_VERSION - I2C Version Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned STEP   : 16;
        unsigned MINOR  :  8;
        unsigned MAJOR  :  8;
    } B;
} hw_i2c_version_t;
#endif

/*
 * constants & macros for entire multi-block HW_I2C_VERSION register
 */
#define HW_I2C_VERSION_ADDR(x)      (REGS_I2C_BASE(x) + 0xd0)

#ifndef __LANGUAGE_ASM__
#define HW_I2C_VERSION(x)           (*(volatile hw_i2c_version_t *) HW_I2C_VERSION_ADDR(x))
#define HW_I2C_VERSION_RD(x)      (HW_I2C_VERSION(x).U)
#endif


/*
 * constants & macros for individual HW_I2C_VERSION bitfields
 */
/* --- Register HW_I2C_VERSION, field MAJOR */

#define BP_I2C_VERSION_MAJOR      24
#define BM_I2C_VERSION_MAJOR      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_I2C_VERSION_MAJOR(v)   ((((reg32_t) v) << 24) & BM_I2C_VERSION_MAJOR)
#else
#define BF_I2C_VERSION_MAJOR(v)   (((v) << 24) & BM_I2C_VERSION_MAJOR)
#endif
/* --- Register HW_I2C_VERSION, field MINOR */

#define BP_I2C_VERSION_MINOR      16
#define BM_I2C_VERSION_MINOR      0x00FF0000

#define BF_I2C_VERSION_MINOR(v)   (((v) << 16) & BM_I2C_VERSION_MINOR)
/* --- Register HW_I2C_VERSION, field STEP */

#define BP_I2C_VERSION_STEP      0
#define BM_I2C_VERSION_STEP      0x0000FFFF

#define BF_I2C_VERSION_STEP(v)   (((v) << 0) & BM_I2C_VERSION_STEP)

#endif /* _I2C_H */

////////////////////////////////////////////////////////////////////////////////
