/*
 * Copyright 2008-2009 Freescale Semiconductor, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

 * WARNING!  THIS FILE IS AUTOMATICALLY GENERATED FROM XML.
 *                DO NOT MODIFY THIS FILE DIRECTLY.
 *
 * Xml Revision: 2.1
 *
 * Template revision: 26195
 *
 *
 * The following naming conventions are followed in this file.
 *      XX_<module>_<regname>_<field>
 *
 * XX specifies the define / macro class
 *      HW pertains to a register
 *      BM indicates a Bit Mask
 *      BF indicates a Bit Field macro
 *
 * <module> is the hardware module name which can be any of the following...
 *      USB20 (Note when there is more than one copy of a given module, the
 *      module name includes a number starting from 0 for the first instance
 *      of that module)
 *
 * <regname> is the specific register within that module
 *
 * <field> is the specific bitfield within that <module>_<register>
 *
 * We also define the following...
 *      hw_<module>_<regname>_t is typedef of anonymous union
 *
 */

#ifndef _SAIF_H
#define _SAIF_H  1

#include "regs.h"

#ifndef REGS_SAIF_BASE
#define REGS_SAIF0_BASE (REGS_BASE + 0x42000)
#define REGS_SAIF1_BASE (REGS_BASE + 0x46000)
#define REGS_SAIF_BASE(x) ( x == 0 ? REGS_SAIF0_BASE : x == 1 ? REGS_SAIF1_BASE : 0xffff0000)
#endif

/*
 * HW_SAIF_CTRL - SAIF Control Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RUN                  :  1;
        unsigned READ_MODE            :  1;
        unsigned SLAVE_MODE           :  1;
        unsigned BITCLK_48XFS_ENABLE  :  1;
        unsigned WORD_LENGTH          :  4;
        unsigned BITCLK_EDGE          :  1;
        unsigned LRCLK_POLARITY       :  1;
        unsigned JUSTIFY              :  1;
        unsigned DELAY                :  1;
        unsigned BIT_ORDER            :  1;
        unsigned LRCLK_PULSE          :  1;
        unsigned CHANNEL_NUM_SELECT   :  2;
        unsigned DMAWAIT_COUNT        :  5;
        unsigned RSRVD2               :  3;
        unsigned FIFO_SERVICE_IRQ_EN  :  1;
        unsigned FIFO_ERROR_IRQ_EN    :  1;
        unsigned BITCLK_BASE_RATE     :  1;
        unsigned BITCLK_MULT_RATE     :  3;
        unsigned CLKGATE              :  1;
        unsigned SFTRST               :  1;
    } B;
} hw_saif_ctrl_t;
#endif

/*
 * constants & macros for entire multi-block HW_SAIF_CTRL register
 */
#define HW_SAIF_CTRL_ADDR(x)      (REGS_SAIF_BASE(x) + 0x0)
#define HW_SAIF_CTRL_SET_ADDR(x)  (HW_SAIF_CTRL_ADDR(x) + 4)
#define HW_SAIF_CTRL_CLR_ADDR(x)  (HW_SAIF_CTRL_ADDR(x) + 8)
#define HW_SAIF_CTRL_TOG_ADDR(x)  (HW_SAIF_CTRL_ADDR(x) + 12)

#ifndef __LANGUAGE_ASM__
#define HW_SAIF_CTRL(x)           (*(volatile hw_saif_ctrl_t *) HW_SAIF_CTRL_ADDR(x))
#define HW_SAIF_CTRL_RD(x)      (HW_SAIF_CTRL(x).U)
#define HW_SAIF_CTRL_WR(x, v)     (HW_SAIF_CTRL(x).U = (v))
#define HW_SAIF_CTRL_SET(x, v)    ((*(volatile reg32_t *) HW_SAIF_CTRL_SET_ADDR(x)) = (v))
#define HW_SAIF_CTRL_CLR(x, v)    ((*(volatile reg32_t *) HW_SAIF_CTRL_CLR_ADDR(x)) = (v))
#define HW_SAIF_CTRL_TOG(x, v)    ((*(volatile reg32_t *) HW_SAIF_CTRL_TOG_ADDR(x)) = (v))
#endif


/*
 * constants & macros for individual HW_SAIF_CTRL bitfields
 */
/* --- Register HW_SAIF_CTRL, field SFTRST */

#define BP_SAIF_CTRL_SFTRST      31
#define BM_SAIF_CTRL_SFTRST      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_SAIF_CTRL_SFTRST(v)   ((((reg32_t) v) << 31) & BM_SAIF_CTRL_SFTRST)
#else
#define BF_SAIF_CTRL_SFTRST(v)   (((v) << 31) & BM_SAIF_CTRL_SFTRST)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_SAIF_CTRL_SFTRST(n, v)   BFn_CS1(SAIF_CTRL, n, SFTRST, v)
#endif

/* --- Register HW_SAIF_CTRL, field CLKGATE */

#define BP_SAIF_CTRL_CLKGATE      30
#define BM_SAIF_CTRL_CLKGATE      0x40000000

#define BF_SAIF_CTRL_CLKGATE(v)   (((v) << 30) & BM_SAIF_CTRL_CLKGATE)
#ifndef __LANGUAGE_ASM__
#define BW_SAIF_CTRL_CLKGATE(n, v)   BFn_CS1(SAIF_CTRL, n, CLKGATE, v)
#endif

/* --- Register HW_SAIF_CTRL, field BITCLK_MULT_RATE */

#define BP_SAIF_CTRL_BITCLK_MULT_RATE      27
#define BM_SAIF_CTRL_BITCLK_MULT_RATE      0x38000000

#define BF_SAIF_CTRL_BITCLK_MULT_RATE(v)   (((v) << 27) & BM_SAIF_CTRL_BITCLK_MULT_RATE)
#ifndef __LANGUAGE_ASM__
#define BW_SAIF_CTRL_BITCLK_MULT_RATE(n, v)   BFn_CS1(SAIF_CTRL, n, BITCLK_MULT_RATE, v)
#endif

/* --- Register HW_SAIF_CTRL, field BITCLK_BASE_RATE */

#define BP_SAIF_CTRL_BITCLK_BASE_RATE      26
#define BM_SAIF_CTRL_BITCLK_BASE_RATE      0x04000000

#define BF_SAIF_CTRL_BITCLK_BASE_RATE(v)   (((v) << 26) & BM_SAIF_CTRL_BITCLK_BASE_RATE)
#ifndef __LANGUAGE_ASM__
#define BW_SAIF_CTRL_BITCLK_BASE_RATE(n, v)   BFn_CS1(SAIF_CTRL, n, BITCLK_BASE_RATE, v)
#endif

/* --- Register HW_SAIF_CTRL, field FIFO_ERROR_IRQ_EN */

#define BP_SAIF_CTRL_FIFO_ERROR_IRQ_EN      25
#define BM_SAIF_CTRL_FIFO_ERROR_IRQ_EN      0x02000000

#define BF_SAIF_CTRL_FIFO_ERROR_IRQ_EN(v)   (((v) << 25) & BM_SAIF_CTRL_FIFO_ERROR_IRQ_EN)
#ifndef __LANGUAGE_ASM__
#define BW_SAIF_CTRL_FIFO_ERROR_IRQ_EN(n, v)   BFn_CS1(SAIF_CTRL, n, FIFO_ERROR_IRQ_EN, v)
#endif

/* --- Register HW_SAIF_CTRL, field FIFO_SERVICE_IRQ_EN */

#define BP_SAIF_CTRL_FIFO_SERVICE_IRQ_EN      24
#define BM_SAIF_CTRL_FIFO_SERVICE_IRQ_EN      0x01000000

#define BF_SAIF_CTRL_FIFO_SERVICE_IRQ_EN(v)   (((v) << 24) & BM_SAIF_CTRL_FIFO_SERVICE_IRQ_EN)
#ifndef __LANGUAGE_ASM__
#define BW_SAIF_CTRL_FIFO_SERVICE_IRQ_EN(n, v)   BFn_CS1(SAIF_CTRL, n, FIFO_SERVICE_IRQ_EN, v)
#endif

/* --- Register HW_SAIF_CTRL, field RSRVD2 */

#define BP_SAIF_CTRL_RSRVD2      21
#define BM_SAIF_CTRL_RSRVD2      0x00E00000

#define BF_SAIF_CTRL_RSRVD2(v)   (((v) << 21) & BM_SAIF_CTRL_RSRVD2)
/* --- Register HW_SAIF_CTRL, field DMAWAIT_COUNT */

#define BP_SAIF_CTRL_DMAWAIT_COUNT      16
#define BM_SAIF_CTRL_DMAWAIT_COUNT      0x001F0000

#define BF_SAIF_CTRL_DMAWAIT_COUNT(v)   (((v) << 16) & BM_SAIF_CTRL_DMAWAIT_COUNT)
#ifndef __LANGUAGE_ASM__
#define BW_SAIF_CTRL_DMAWAIT_COUNT(n, v)   BFn_CS1(SAIF_CTRL, n, DMAWAIT_COUNT, v)
#endif

/* --- Register HW_SAIF_CTRL, field CHANNEL_NUM_SELECT */

#define BP_SAIF_CTRL_CHANNEL_NUM_SELECT      14
#define BM_SAIF_CTRL_CHANNEL_NUM_SELECT      0x0000C000

#define BF_SAIF_CTRL_CHANNEL_NUM_SELECT(v)   (((v) << 14) & BM_SAIF_CTRL_CHANNEL_NUM_SELECT)
#ifndef __LANGUAGE_ASM__
#define BW_SAIF_CTRL_CHANNEL_NUM_SELECT(n, v)   BFn_CS1(SAIF_CTRL, n, CHANNEL_NUM_SELECT, v)
#endif

/* --- Register HW_SAIF_CTRL, field LRCLK_PULSE */

#define BP_SAIF_CTRL_LRCLK_PULSE      13
#define BM_SAIF_CTRL_LRCLK_PULSE      0x00002000

#define BF_SAIF_CTRL_LRCLK_PULSE(v)   (((v) << 13) & BM_SAIF_CTRL_LRCLK_PULSE)
#ifndef __LANGUAGE_ASM__
#define BW_SAIF_CTRL_LRCLK_PULSE(n, v)   BFn_CS1(SAIF_CTRL, n, LRCLK_PULSE, v)
#endif

/* --- Register HW_SAIF_CTRL, field BIT_ORDER */

#define BP_SAIF_CTRL_BIT_ORDER      12
#define BM_SAIF_CTRL_BIT_ORDER      0x00001000

#define BF_SAIF_CTRL_BIT_ORDER(v)   (((v) << 12) & BM_SAIF_CTRL_BIT_ORDER)
#ifndef __LANGUAGE_ASM__
#define BW_SAIF_CTRL_BIT_ORDER(n, v)   BFn_CS1(SAIF_CTRL, n, BIT_ORDER, v)
#endif

/* --- Register HW_SAIF_CTRL, field DELAY */

#define BP_SAIF_CTRL_DELAY      11
#define BM_SAIF_CTRL_DELAY      0x00000800

#define BF_SAIF_CTRL_DELAY(v)   (((v) << 11) & BM_SAIF_CTRL_DELAY)
#ifndef __LANGUAGE_ASM__
#define BW_SAIF_CTRL_DELAY(n, v)   BFn_CS1(SAIF_CTRL, n, DELAY, v)
#endif

/* --- Register HW_SAIF_CTRL, field JUSTIFY */

#define BP_SAIF_CTRL_JUSTIFY      10
#define BM_SAIF_CTRL_JUSTIFY      0x00000400

#define BF_SAIF_CTRL_JUSTIFY(v)   (((v) << 10) & BM_SAIF_CTRL_JUSTIFY)
#ifndef __LANGUAGE_ASM__
#define BW_SAIF_CTRL_JUSTIFY(n, v)   BFn_CS1(SAIF_CTRL, n, JUSTIFY, v)
#endif

/* --- Register HW_SAIF_CTRL, field LRCLK_POLARITY */

#define BP_SAIF_CTRL_LRCLK_POLARITY      9
#define BM_SAIF_CTRL_LRCLK_POLARITY      0x00000200

#define BF_SAIF_CTRL_LRCLK_POLARITY(v)   (((v) << 9) & BM_SAIF_CTRL_LRCLK_POLARITY)
#ifndef __LANGUAGE_ASM__
#define BW_SAIF_CTRL_LRCLK_POLARITY(n, v)   BFn_CS1(SAIF_CTRL, n, LRCLK_POLARITY, v)
#endif

/* --- Register HW_SAIF_CTRL, field BITCLK_EDGE */

#define BP_SAIF_CTRL_BITCLK_EDGE      8
#define BM_SAIF_CTRL_BITCLK_EDGE      0x00000100

#define BF_SAIF_CTRL_BITCLK_EDGE(v)   (((v) << 8) & BM_SAIF_CTRL_BITCLK_EDGE)
#ifndef __LANGUAGE_ASM__
#define BW_SAIF_CTRL_BITCLK_EDGE(n, v)   BFn_CS1(SAIF_CTRL, n, BITCLK_EDGE, v)
#endif

/* --- Register HW_SAIF_CTRL, field WORD_LENGTH */

#define BP_SAIF_CTRL_WORD_LENGTH      4
#define BM_SAIF_CTRL_WORD_LENGTH      0x000000F0

#define BF_SAIF_CTRL_WORD_LENGTH(v)   (((v) << 4) & BM_SAIF_CTRL_WORD_LENGTH)
#ifndef __LANGUAGE_ASM__
#define BW_SAIF_CTRL_WORD_LENGTH(n, v)   BFn_CS1(SAIF_CTRL, n, WORD_LENGTH, v)
#endif

/* --- Register HW_SAIF_CTRL, field BITCLK_48XFS_ENABLE */

#define BP_SAIF_CTRL_BITCLK_48XFS_ENABLE      3
#define BM_SAIF_CTRL_BITCLK_48XFS_ENABLE      0x00000008

#define BF_SAIF_CTRL_BITCLK_48XFS_ENABLE(v)   (((v) << 3) & BM_SAIF_CTRL_BITCLK_48XFS_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_SAIF_CTRL_BITCLK_48XFS_ENABLE(n, v)   BFn_CS1(SAIF_CTRL, n, BITCLK_48XFS_ENABLE, v)
#endif

/* --- Register HW_SAIF_CTRL, field SLAVE_MODE */

#define BP_SAIF_CTRL_SLAVE_MODE      2
#define BM_SAIF_CTRL_SLAVE_MODE      0x00000004

#define BF_SAIF_CTRL_SLAVE_MODE(v)   (((v) << 2) & BM_SAIF_CTRL_SLAVE_MODE)
#ifndef __LANGUAGE_ASM__
#define BW_SAIF_CTRL_SLAVE_MODE(n, v)   BFn_CS1(SAIF_CTRL, n, SLAVE_MODE, v)
#endif

/* --- Register HW_SAIF_CTRL, field READ_MODE */

#define BP_SAIF_CTRL_READ_MODE      1
#define BM_SAIF_CTRL_READ_MODE      0x00000002

#define BF_SAIF_CTRL_READ_MODE(v)   (((v) << 1) & BM_SAIF_CTRL_READ_MODE)
#ifndef __LANGUAGE_ASM__
#define BW_SAIF_CTRL_READ_MODE(n, v)   BFn_CS1(SAIF_CTRL, n, READ_MODE, v)
#endif

/* --- Register HW_SAIF_CTRL, field RUN */

#define BP_SAIF_CTRL_RUN      0
#define BM_SAIF_CTRL_RUN      0x00000001

#define BF_SAIF_CTRL_RUN(v)   (((v) << 0) & BM_SAIF_CTRL_RUN)
#ifndef __LANGUAGE_ASM__
#define BW_SAIF_CTRL_RUN(n, v)   BFn_CS1(SAIF_CTRL, n, RUN, v)
#endif



/*
 * HW_SAIF_STAT - SAIF Status Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BUSY                :  1;
        unsigned RSRVD0              :  3;
        unsigned FIFO_SERVICE_IRQ    :  1;
        unsigned FIFO_OVERFLOW_IRQ   :  1;
        unsigned FIFO_UNDERFLOW_IRQ  :  1;
        unsigned RSRVD1              :  9;
        unsigned DMA_PREQ            :  1;
        unsigned RSRVD2              : 14;
        unsigned PRESENT             :  1;
    } B;
} hw_saif_stat_t;
#endif

/*
 * constants & macros for entire multi-block HW_SAIF_STAT register
 */
#define HW_SAIF_STAT_ADDR(x)      (REGS_SAIF_BASE(x) + 0x10)
#define HW_SAIF_STAT_SET_ADDR(x)  (HW_SAIF_STAT_ADDR(x) + 4)
#define HW_SAIF_STAT_CLR_ADDR(x)  (HW_SAIF_STAT_ADDR(x) + 8)
#define HW_SAIF_STAT_TOG_ADDR(x)  (HW_SAIF_STAT_ADDR(x) + 12)

#ifndef __LANGUAGE_ASM__
#define HW_SAIF_STAT(x)           (*(volatile hw_saif_stat_t *) HW_SAIF_STAT_ADDR(x))
#define HW_SAIF_STAT_RD(x)      (HW_SAIF_STAT(x).U)
#define HW_SAIF_STAT_WR(x, v)     (HW_SAIF_STAT(x).U = (v))
#define HW_SAIF_STAT_SET(x, v)    ((*(volatile reg32_t *) HW_SAIF_STAT_SET_ADDR(x)) = (v))
#define HW_SAIF_STAT_CLR(x, v)    ((*(volatile reg32_t *) HW_SAIF_STAT_CLR_ADDR(x)) = (v))
#define HW_SAIF_STAT_TOG(x, v)    ((*(volatile reg32_t *) HW_SAIF_STAT_TOG_ADDR(x)) = (v))
#endif


/*
 * constants & macros for individual HW_SAIF_STAT bitfields
 */
/* --- Register HW_SAIF_STAT, field PRESENT */

#define BP_SAIF_STAT_PRESENT      31
#define BM_SAIF_STAT_PRESENT      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_SAIF_STAT_PRESENT(v)   ((((reg32_t) v) << 31) & BM_SAIF_STAT_PRESENT)
#else
#define BF_SAIF_STAT_PRESENT(v)   (((v) << 31) & BM_SAIF_STAT_PRESENT)
#endif
/* --- Register HW_SAIF_STAT, field RSRVD2 */

#define BP_SAIF_STAT_RSRVD2      17
#define BM_SAIF_STAT_RSRVD2      0x7FFE0000

#define BF_SAIF_STAT_RSRVD2(v)   (((v) << 17) & BM_SAIF_STAT_RSRVD2)
/* --- Register HW_SAIF_STAT, field DMA_PREQ */

#define BP_SAIF_STAT_DMA_PREQ      16
#define BM_SAIF_STAT_DMA_PREQ      0x00010000

#define BF_SAIF_STAT_DMA_PREQ(v)   (((v) << 16) & BM_SAIF_STAT_DMA_PREQ)
/* --- Register HW_SAIF_STAT, field RSRVD1 */

#define BP_SAIF_STAT_RSRVD1      7
#define BM_SAIF_STAT_RSRVD1      0x0000FF80

#define BF_SAIF_STAT_RSRVD1(v)   (((v) << 7) & BM_SAIF_STAT_RSRVD1)
/* --- Register HW_SAIF_STAT, field FIFO_UNDERFLOW_IRQ */

#define BP_SAIF_STAT_FIFO_UNDERFLOW_IRQ      6
#define BM_SAIF_STAT_FIFO_UNDERFLOW_IRQ      0x00000040

#define BF_SAIF_STAT_FIFO_UNDERFLOW_IRQ(v)   (((v) << 6) & BM_SAIF_STAT_FIFO_UNDERFLOW_IRQ)
#ifndef __LANGUAGE_ASM__
#define BW_SAIF_STAT_FIFO_UNDERFLOW_IRQ(n, v)   BFn_CS1(SAIF_STAT, n, FIFO_UNDERFLOW_IRQ, v)
#endif

/* --- Register HW_SAIF_STAT, field FIFO_OVERFLOW_IRQ */

#define BP_SAIF_STAT_FIFO_OVERFLOW_IRQ      5
#define BM_SAIF_STAT_FIFO_OVERFLOW_IRQ      0x00000020

#define BF_SAIF_STAT_FIFO_OVERFLOW_IRQ(v)   (((v) << 5) & BM_SAIF_STAT_FIFO_OVERFLOW_IRQ)
#ifndef __LANGUAGE_ASM__
#define BW_SAIF_STAT_FIFO_OVERFLOW_IRQ(n, v)   BFn_CS1(SAIF_STAT, n, FIFO_OVERFLOW_IRQ, v)
#endif

/* --- Register HW_SAIF_STAT, field FIFO_SERVICE_IRQ */

#define BP_SAIF_STAT_FIFO_SERVICE_IRQ      4
#define BM_SAIF_STAT_FIFO_SERVICE_IRQ      0x00000010

#define BF_SAIF_STAT_FIFO_SERVICE_IRQ(v)   (((v) << 4) & BM_SAIF_STAT_FIFO_SERVICE_IRQ)
/* --- Register HW_SAIF_STAT, field RSRVD0 */

#define BP_SAIF_STAT_RSRVD0      1
#define BM_SAIF_STAT_RSRVD0      0x0000000E

#define BF_SAIF_STAT_RSRVD0(v)   (((v) << 1) & BM_SAIF_STAT_RSRVD0)
/* --- Register HW_SAIF_STAT, field BUSY */

#define BP_SAIF_STAT_BUSY      0
#define BM_SAIF_STAT_BUSY      0x00000001

#define BF_SAIF_STAT_BUSY(v)   (((v) << 0) & BM_SAIF_STAT_BUSY)


/*
 * HW_SAIF_DATA - SAIF Data Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PCM_LEFT   : 16;
        unsigned PCM_RIGHT  : 16;
    } B;
} hw_saif_data_t;
#endif

/*
 * constants & macros for entire multi-block HW_SAIF_DATA register
 */
#define HW_SAIF_DATA_ADDR(x)      (REGS_SAIF_BASE(x) + 0x20)
#define HW_SAIF_DATA_SET_ADDR(x)  (HW_SAIF_DATA_ADDR(x) + 4)
#define HW_SAIF_DATA_CLR_ADDR(x)  (HW_SAIF_DATA_ADDR(x) + 8)
#define HW_SAIF_DATA_TOG_ADDR(x)  (HW_SAIF_DATA_ADDR(x) + 12)

#ifndef __LANGUAGE_ASM__
#define HW_SAIF_DATA(x)           (*(volatile hw_saif_data_t *) HW_SAIF_DATA_ADDR(x))
#define HW_SAIF_DATA_RD(x)      (HW_SAIF_DATA(x).U)
#define HW_SAIF_DATA_WR(x, v)     (HW_SAIF_DATA(x).U = (v))
#define HW_SAIF_DATA_SET(x, v)    ((*(volatile reg32_t *) HW_SAIF_DATA_SET_ADDR(x)) = (v))
#define HW_SAIF_DATA_CLR(x, v)    ((*(volatile reg32_t *) HW_SAIF_DATA_CLR_ADDR(x)) = (v))
#define HW_SAIF_DATA_TOG(x, v)    ((*(volatile reg32_t *) HW_SAIF_DATA_TOG_ADDR(x)) = (v))
#endif


/*
 * constants & macros for individual HW_SAIF_DATA bitfields
 */
/* --- Register HW_SAIF_DATA, field PCM_RIGHT */

#define BP_SAIF_DATA_PCM_RIGHT      16
#define BM_SAIF_DATA_PCM_RIGHT      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_SAIF_DATA_PCM_RIGHT(v)   ((((reg32_t) v) << 16) & BM_SAIF_DATA_PCM_RIGHT)
#else
#define BF_SAIF_DATA_PCM_RIGHT(v)   (((v) << 16) & BM_SAIF_DATA_PCM_RIGHT)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_SAIF_DATA_PCM_RIGHT(n, v)   (HW_SAIF_DATA(n).B.PCM_RIGHT = (v))
#endif

/* --- Register HW_SAIF_DATA, field PCM_LEFT */

#define BP_SAIF_DATA_PCM_LEFT      0
#define BM_SAIF_DATA_PCM_LEFT      0x0000FFFF

#define BF_SAIF_DATA_PCM_LEFT(v)   (((v) << 0) & BM_SAIF_DATA_PCM_LEFT)
#ifndef __LANGUAGE_ASM__
#define BW_SAIF_DATA_PCM_LEFT(n, v)   (HW_SAIF_DATA(n).B.PCM_LEFT = (v))
#endif



/*
 * HW_SAIF_VERSION - SAIF Version Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned STEP   : 16;
        unsigned MINOR  :  8;
        unsigned MAJOR  :  8;
    } B;
} hw_saif_version_t;
#endif

/*
 * constants & macros for entire multi-block HW_SAIF_VERSION register
 */
#define HW_SAIF_VERSION_ADDR(x)      (REGS_SAIF_BASE(x) + 0x30)

#ifndef __LANGUAGE_ASM__
#define HW_SAIF_VERSION(x)           (*(volatile hw_saif_version_t *) HW_SAIF_VERSION_ADDR(x))
#define HW_SAIF_VERSION_RD(x)      (HW_SAIF_VERSION(x).U)
#endif


/*
 * constants & macros for individual HW_SAIF_VERSION bitfields
 */
/* --- Register HW_SAIF_VERSION, field MAJOR */

#define BP_SAIF_VERSION_MAJOR      24
#define BM_SAIF_VERSION_MAJOR      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_SAIF_VERSION_MAJOR(v)   ((((reg32_t) v) << 24) & BM_SAIF_VERSION_MAJOR)
#else
#define BF_SAIF_VERSION_MAJOR(v)   (((v) << 24) & BM_SAIF_VERSION_MAJOR)
#endif
/* --- Register HW_SAIF_VERSION, field MINOR */

#define BP_SAIF_VERSION_MINOR      16
#define BM_SAIF_VERSION_MINOR      0x00FF0000

#define BF_SAIF_VERSION_MINOR(v)   (((v) << 16) & BM_SAIF_VERSION_MINOR)
/* --- Register HW_SAIF_VERSION, field STEP */

#define BP_SAIF_VERSION_STEP      0
#define BM_SAIF_VERSION_STEP      0x0000FFFF

#define BF_SAIF_VERSION_STEP(v)   (((v) << 0) & BM_SAIF_VERSION_STEP)

#endif /* _SAIF_H */

////////////////////////////////////////////////////////////////////////////////
