import * as ESTree from 'estree';
import { TControlFlowCustomNodeFactory } from '../../../types/container/custom-nodes/TControlFlowCustomNodeFactory';
import { TControlFlowStorage } from '../../../types/storages/TControlFlowStorage';
import { IOptions } from '../../../interfaces/options/IOptions';
import { IRandomGenerator } from '../../../interfaces/utils/IRandomGenerator';
import { AbstractControlFlowReplacer } from './AbstractControlFlowReplacer';
export declare class CallExpressionControlFlowReplacer extends AbstractControlFlowReplacer {
    private static readonly usingExistingIdentifierChance;
    constructor(controlFlowCustomNodeFactory: TControlFlowCustomNodeFactory, randomGenerator: IRandomGenerator, options: IOptions);
    replace(callExpressionNode: ESTree.CallExpression, parentNode: ESTree.Node, controlFlowStorage: TControlFlowStorage): ESTree.Node;
    protected getControlFlowStorageCallNode(controlFlowStorageId: string, storageKey: string, callee: ESTree.Expression, expressionArguments: (ESTree.Expression | ESTree.SpreadElement)[]): ESTree.Node;
}
