# travis-pecl

These few lines of code support building and testing PHP extensions on Travis-CI.

## Usage

First, we'll add this repo to our extension as submodule:

    git submodule add -n travis-pecl https://github.com/m6w6/travis-pecl.git travis/pecl
    git submodule update --init

Let's build a `.travis.yml`by example. We'll use a simple PHP script, e.g. `gen_travis_yml.php`,
which will generate the configuration for us:

    #!/usr/bin/env php
    # file generated by gen_travis_yml.php, do not edit!
    
    # use the container infrastructure
    sudo: false
    
    # we want to build a C library
    language: c
    
    # use the system's PHP to run this script
    addons:
      apt:
        packages:
          - php5-cli
          - php-pear
    
    # now we'll specify the build matrix environment
    env:
    <?php
    
    # instantiate the generator
    $gen = include "travis/pecl/gen_matrix.php";
    
    # generate the matrix
    $env = $gen([
      # the latest releases of minor versions we want to build against
      "PHP" => ["5.4", "5.5", "5.6"],
      # test debug and non-debug builds
      "enable_debug",
      # test threadsafe and non-threadsafe builds
      "enable_maintainer_zts",
      # test with ext/json enabled an disabled
      "enable_json",
      # always build with iconv support
      "with_iconv" => ["yes"],
    ]);
    
    # output the build matrix
    foreach ($env as $e) {
      printf("  - %s\n", %e);
    }
    
    ?>
    
    before_script:
      # build the matrix' PHP version
      - make -f travis/pecl/Makefile php
      # build the extension, the PECL variable expects the extension name 
      # and optionally the soname and a specific version of the extension
      # separeated by double colon, e.g. PECL=myext:ext:1.7.5
      - make -f travis/pecl/Makefile ext PECL=myext
    
    script:
      # run the PHPT test suite
      - make -f travis/pecl/Makefile test
    

That's it, more TBD.
